-- MySQL dump 10.13  Distrib 5.5.46, for debian-linux-gnu (x86_64)
--
-- Host: localhost    Database: tm
-- ------------------------------------------------------
-- Server version	5.5.46-0ubuntu0.14.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actions`
--

DROP TABLE IF EXISTS `actions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actions` (
  `aid` varchar(255) NOT NULL DEFAULT '0' COMMENT 'Primary Key: Unique actions ID.',
  `type` varchar(32) NOT NULL DEFAULT '' COMMENT 'The object that that action acts on (node, user, comment, system or custom types.)',
  `callback` varchar(255) NOT NULL DEFAULT '' COMMENT 'The callback function that executes when the action runs.',
  `parameters` longblob NOT NULL COMMENT 'Parameters to be passed to the callback function.',
  `label` varchar(255) NOT NULL DEFAULT '0' COMMENT 'Label of the action.',
  PRIMARY KEY (`aid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores action information.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actions`
--

LOCK TABLES `actions` WRITE;
/*!40000 ALTER TABLE `actions` DISABLE KEYS */;
INSERT INTO `actions` VALUES ('comment_publish_action','comment','comment_publish_action','','Publish comment'),('comment_save_action','comment','comment_save_action','','Save comment'),('comment_unpublish_action','comment','comment_unpublish_action','','Unpublish comment'),('node_export_drupal_action','node','node_export_drupal_action','','Node export (Drupal var export)'),('node_make_sticky_action','node','node_make_sticky_action','','Make content sticky'),('node_make_unsticky_action','node','node_make_unsticky_action','','Make content unsticky'),('node_promote_action','node','node_promote_action','','Promote content to front page'),('node_publish_action','node','node_publish_action','','Publish content'),('node_save_action','node','node_save_action','','Save content'),('node_unpromote_action','node','node_unpromote_action','','Remove content from front page'),('node_unpublish_action','node','node_unpublish_action','','Unpublish content'),('pathauto_node_update_action','node','pathauto_node_update_action','','Update node alias'),('pathauto_taxonomy_term_update_action','taxonomy_term','pathauto_taxonomy_term_update_action','','Update taxonomy term alias'),('pathauto_user_update_action','user','pathauto_user_update_action','','Update user alias'),('system_block_ip_action','user','system_block_ip_action','','Ban IP address of current user'),('user_block_user_action','user','user_block_user_action','','Block current user');
/*!40000 ALTER TABLE `actions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `authmap`
--

DROP TABLE IF EXISTS `authmap`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `authmap` (
  `aid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: Unique authmap ID.',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT 'User’s users.uid.',
  `authname` varchar(128) NOT NULL DEFAULT '' COMMENT 'Unique authentication name.',
  `module` varchar(128) NOT NULL DEFAULT '' COMMENT 'Module which is controlling the authentication.',
  PRIMARY KEY (`aid`),
  UNIQUE KEY `authname` (`authname`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores distributed authentication mapping.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `authmap`
--

LOCK TABLES `authmap` WRITE;
/*!40000 ALTER TABLE `authmap` DISABLE KEYS */;
/*!40000 ALTER TABLE `authmap` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backup_migrate_destinations`
--

DROP TABLE IF EXISTS `backup_migrate_destinations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `backup_migrate_destinations` (
  `destination_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary ID field for the table. Not used for anything except internal lookups.',
  `machine_name` varchar(255) NOT NULL DEFAULT '0' COMMENT 'The primary identifier for a destination.',
  `name` varchar(255) NOT NULL COMMENT 'The name of the destination.',
  `subtype` varchar(32) NOT NULL COMMENT 'The type of the destination.',
  `location` text NOT NULL COMMENT 'The the location string of the destination.',
  `settings` text NOT NULL COMMENT 'Other settings for the destination.',
  PRIMARY KEY (`destination_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backup_migrate_destinations`
--

LOCK TABLES `backup_migrate_destinations` WRITE;
/*!40000 ALTER TABLE `backup_migrate_destinations` DISABLE KEYS */;
/*!40000 ALTER TABLE `backup_migrate_destinations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backup_migrate_profiles`
--

DROP TABLE IF EXISTS `backup_migrate_profiles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `backup_migrate_profiles` (
  `profile_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary ID field for the table. Not used for anything except internal lookups.',
  `machine_name` varchar(255) NOT NULL DEFAULT '0' COMMENT 'The primary identifier for a profile.',
  `name` varchar(255) NOT NULL COMMENT 'The name of the profile.',
  `filename` varchar(255) NOT NULL COMMENT 'The name of the profile.',
  `append_timestamp` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Append a timestamp to the filename.',
  `timestamp_format` varchar(14) NOT NULL COMMENT 'The format of the timestamp.',
  `filters` text NOT NULL COMMENT 'The filter settings for the profile.',
  PRIMARY KEY (`profile_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backup_migrate_profiles`
--

LOCK TABLES `backup_migrate_profiles` WRITE;
/*!40000 ALTER TABLE `backup_migrate_profiles` DISABLE KEYS */;
INSERT INTO `backup_migrate_profiles` VALUES (1,'default','Default Settings','[site:name]',1,'Y-m-d\\TH-i-s','a:11:{s:11:\"compression\";s:3:\"zip\";s:21:\"notify_success_enable\";i:0;s:20:\"notify_success_email\";s:33:\"no-reply@santiagodecompostela.gal\";s:21:\"notify_failure_enable\";i:0;s:20:\"notify_failure_email\";s:33:\"no-reply@santiagodecompostela.gal\";s:18:\"utils_site_offline\";i:0;s:26:\"utils_site_offline_message\";s:125:\"Compostela, Territorio das Mulleres está en mantemento nestes intres. Pronto estaremos de volta. Grazas pola súa paciencia.\";s:17:\"utils_description\";s:0:\"\";s:7:\"use_cli\";i:0;s:13:\"ignore_errors\";i:0;s:7:\"sources\";a:3:{s:2:\"db\";a:3:{s:14:\"exclude_tables\";a:0:{}s:13:\"nodata_tables\";a:25:{s:5:\"cache\";s:5:\"cache\";s:11:\"cache_block\";s:11:\"cache_block\";s:15:\"cache_bootstrap\";s:15:\"cache_bootstrap\";s:16:\"cache_feeds_http\";s:16:\"cache_feeds_http\";s:11:\"cache_field\";s:11:\"cache_field\";s:12:\"cache_filter\";s:12:\"cache_filter\";s:10:\"cache_form\";s:10:\"cache_form\";s:11:\"cache_image\";s:11:\"cache_image\";s:17:\"cache_l10n_update\";s:17:\"cache_l10n_update\";s:15:\"cache_libraries\";s:15:\"cache_libraries\";s:14:\"cache_location\";s:14:\"cache_location\";s:10:\"cache_menu\";s:10:\"cache_menu\";s:13:\"cache_metatag\";s:13:\"cache_metatag\";s:10:\"cache_page\";s:10:\"cache_page\";s:10:\"cache_path\";s:10:\"cache_path\";s:11:\"cache_token\";s:11:\"cache_token\";s:12:\"cache_update\";s:12:\"cache_update\";s:14:\"cache_variable\";s:14:\"cache_variable\";s:11:\"cache_views\";s:11:\"cache_views\";s:16:\"cache_views_data\";s:16:\"cache_views_data\";s:14:\"search_dataset\";s:14:\"search_dataset\";s:12:\"search_index\";s:12:\"search_index\";s:12:\"search_total\";s:12:\"search_total\";s:8:\"sessions\";s:8:\"sessions\";s:8:\"watchdog\";s:8:\"watchdog\";}s:17:\"utils_lock_tables\";i:0;}s:5:\"files\";a:1:{s:17:\"exclude_filepaths\";s:45:\"backup_migrate\r\nstyles\r\ncss\r\njs\r\nctools\r\nless\";}s:7:\"archive\";a:1:{s:17:\"exclude_filepaths\";s:158:\"public://backup_migrate\r\npublic://styles\r\npublic://css\r\npublic://js\r\npublic://ctools\r\npublic://less\r\nprivate://backup_migrate\r\nsites/default/settings.php\r\ntmp\";}}}');
/*!40000 ALTER TABLE `backup_migrate_profiles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backup_migrate_schedules`
--

DROP TABLE IF EXISTS `backup_migrate_schedules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `backup_migrate_schedules` (
  `schedule_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary ID field for the table. Not used for anything except internal lookups.',
  `machine_name` varchar(255) NOT NULL DEFAULT '0' COMMENT 'The primary identifier for a profile.',
  `name` varchar(255) NOT NULL COMMENT 'The name of the profile.',
  `source_id` varchar(255) NOT NULL DEFAULT 'db' COMMENT 'The backup_migrate_destination.destination_id of the source to backup from.',
  `destination_id` varchar(255) NOT NULL DEFAULT '0' COMMENT 'The backup_migrate_destination.destination_id of the destination to back up to.',
  `copy_destination_id` varchar(32) NOT NULL DEFAULT '0' COMMENT 'A second backup_migrate_destination.destination_id of the destination to copy the backup to.',
  `profile_id` varchar(255) NOT NULL DEFAULT '0' COMMENT 'The primary identifier for a profile.',
  `keep` int(11) NOT NULL DEFAULT '0' COMMENT 'The number of backups to keep.',
  `period` int(11) NOT NULL DEFAULT '0' COMMENT 'The number of seconds between backups.',
  `enabled` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Whether the schedule is enabled.',
  `cron` varchar(32) NOT NULL DEFAULT 'builtin' COMMENT 'Whether the schedule should be run during cron.',
  `cron_schedule` varchar(255) NOT NULL DEFAULT '0 4 * * *' COMMENT 'The cron schedule to run on.',
  PRIMARY KEY (`schedule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backup_migrate_schedules`
--

LOCK TABLES `backup_migrate_schedules` WRITE;
/*!40000 ALTER TABLE `backup_migrate_schedules` DISABLE KEYS */;
/*!40000 ALTER TABLE `backup_migrate_schedules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backup_migrate_sources`
--

DROP TABLE IF EXISTS `backup_migrate_sources`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `backup_migrate_sources` (
  `source_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary ID field for the table. Not used for anything except internal lookups.',
  `machine_name` varchar(32) NOT NULL DEFAULT '0' COMMENT 'The primary identifier for a source.',
  `name` varchar(255) NOT NULL COMMENT 'The name of the source.',
  `subtype` varchar(32) NOT NULL COMMENT 'The type of the source.',
  `location` text NOT NULL COMMENT 'The the location string of the source.',
  `settings` text NOT NULL COMMENT 'Other settings for the source.',
  PRIMARY KEY (`source_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backup_migrate_sources`
--

LOCK TABLES `backup_migrate_sources` WRITE;
/*!40000 ALTER TABLE `backup_migrate_sources` DISABLE KEYS */;
/*!40000 ALTER TABLE `backup_migrate_sources` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `batch`
--

DROP TABLE IF EXISTS `batch`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `batch` (
  `bid` int(10) unsigned NOT NULL COMMENT 'Primary Key: Unique batch ID.',
  `token` varchar(64) NOT NULL COMMENT 'A string token generated against the current user’s session id and the batch id, used to ensure that only the user who submitted the batch can effectively access it.',
  `timestamp` int(11) NOT NULL COMMENT 'A Unix timestamp indicating when this batch was submitted for processing. Stale batches are purged at cron time.',
  `batch` longblob COMMENT 'A serialized array containing the processing data for the batch.',
  PRIMARY KEY (`bid`),
  KEY `token` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores details about batches (processes that run in...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `batch`
--

LOCK TABLES `batch` WRITE;
/*!40000 ALTER TABLE `batch` DISABLE KEYS */;
/*!40000 ALTER TABLE `batch` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `block`
--

DROP TABLE IF EXISTS `block`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `block` (
  `bid` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: Unique block ID.',
  `module` varchar(64) NOT NULL DEFAULT '' COMMENT 'The module from which the block originates; for example, ’user’ for the Who’s Online block, and ’block’ for any custom blocks.',
  `delta` varchar(32) NOT NULL DEFAULT '0' COMMENT 'Unique ID for block within a module.',
  `theme` varchar(64) NOT NULL DEFAULT '' COMMENT 'The theme under which the block settings apply.',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Block enabled status. (1 = enabled, 0 = disabled)',
  `weight` int(11) NOT NULL DEFAULT '0' COMMENT 'Block weight within region.',
  `region` varchar(64) NOT NULL DEFAULT '' COMMENT 'Theme region within which the block is set.',
  `custom` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Flag to indicate how users may control visibility of the block. (0 = Users cannot control, 1 = On by default, but can be hidden, 2 = Hidden by default, but can be shown)',
  `visibility` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Flag to indicate how to show blocks on pages. (0 = Show on all pages except listed pages, 1 = Show only on listed pages, 2 = Use custom PHP code to determine visibility)',
  `pages` text NOT NULL COMMENT 'Contents of the `Pages` block; contains either a list of paths on which to include/exclude the block or PHP code, depending on `visibility` setting.',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT 'Custom title for the block. (Empty string will use block default title, <none> will remove the title, text will cause block to use specified title.)',
  `cache` tinyint(4) NOT NULL DEFAULT '1' COMMENT 'Binary flag to indicate block cache mode. (-2: Custom cache, -1: Do not cache, 1: Cache per role, 2: Cache per user, 4: Cache per page, 8: Block cache global) See DRUPAL_CACHE_* constants in ../includes/common.inc for more detailed information.',
  `i18n_mode` int(11) NOT NULL DEFAULT '0' COMMENT 'Block multilingual mode.',
  `css_class` varchar(255) NOT NULL DEFAULT '' COMMENT 'String containing the classes for the block.',
  PRIMARY KEY (`bid`),
  UNIQUE KEY `tmd` (`theme`,`module`,`delta`),
  KEY `list` (`theme`,`status`,`region`,`weight`,`module`)
) ENGINE=InnoDB AUTO_INCREMENT=119 DEFAULT CHARSET=utf8 COMMENT='Stores block settings, such as region and visibility...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `block`
--

LOCK TABLES `block` WRITE;
/*!40000 ALTER TABLE `block` DISABLE KEYS */;
INSERT INTO `block` VALUES (1,'system','main','bartik',1,0,'content',0,0,'','',-1,0,''),(2,'search','form','bartik',1,-1,'sidebar_first',0,0,'','',-1,0,''),(3,'node','recent','seven',1,10,'dashboard_main',0,0,'','',-1,0,''),(4,'user','login','bartik',1,0,'sidebar_first',0,0,'','',-1,0,''),(5,'system','navigation','bartik',1,0,'sidebar_first',0,0,'','',-1,0,''),(6,'system','powered-by','bartik',1,10,'footer',0,0,'','',-1,0,''),(7,'system','help','bartik',1,0,'help',0,0,'','',-1,0,''),(8,'system','main','seven',1,0,'content',0,0,'','',-1,0,''),(9,'system','help','seven',1,0,'help',0,0,'','',-1,0,''),(10,'user','login','seven',1,10,'content',0,0,'','',-1,0,''),(11,'user','new','seven',1,0,'dashboard_sidebar',0,0,'','',-1,0,''),(12,'search','form','seven',1,-10,'dashboard_sidebar',0,0,'','',-1,0,''),(13,'comment','recent','bartik',0,0,'-1',0,0,'','',1,0,''),(14,'node','syndicate','bartik',0,0,'-1',0,0,'','',-1,0,''),(15,'node','recent','bartik',0,0,'-1',0,0,'','',1,0,''),(16,'shortcut','shortcuts','bartik',0,0,'-1',0,0,'','',-1,0,''),(17,'system','management','bartik',0,0,'-1',0,0,'','',-1,0,''),(18,'system','user-menu','bartik',0,0,'-1',0,0,'','',-1,0,''),(19,'system','main-menu','bartik',0,0,'-1',0,0,'','',-1,0,''),(20,'user','new','bartik',0,0,'-1',0,0,'','',1,0,''),(21,'user','online','bartik',0,0,'-1',0,0,'','',-1,0,''),(22,'comment','recent','seven',1,0,'dashboard_inactive',0,0,'','',1,0,''),(23,'node','syndicate','seven',0,0,'-1',0,0,'','',-1,0,''),(24,'shortcut','shortcuts','seven',0,0,'-1',0,0,'','',-1,0,''),(25,'system','powered-by','seven',0,10,'-1',0,0,'','',-1,0,''),(26,'system','navigation','seven',0,0,'-1',0,0,'','',-1,0,''),(27,'system','management','seven',0,0,'-1',0,0,'','',-1,0,''),(28,'system','user-menu','seven',0,0,'-1',0,0,'','',-1,0,''),(29,'system','main-menu','seven',0,0,'-1',0,0,'','',-1,0,''),(30,'user','online','seven',1,0,'dashboard_inactive',0,0,'','',-1,0,''),(31,'comment','recent','tm',0,0,'-1',0,0,'','',1,0,''),(32,'node','recent','tm',0,0,'-1',0,0,'','',1,0,''),(33,'node','syndicate','tm',0,0,'-1',0,0,'','',-1,0,''),(34,'search','form','tm',0,-1,'-1',0,0,'','',-1,0,''),(35,'shortcut','shortcuts','tm',0,0,'-1',0,0,'','',-1,0,''),(36,'system','help','tm',1,0,'help',0,0,'','',-1,0,''),(37,'system','main','tm',1,-14,'content',0,0,'','',-1,0,''),(38,'system','main-menu','tm',0,0,'-1',0,0,'','',-1,0,''),(39,'system','management','tm',0,0,'-1',0,0,'','',-1,0,''),(40,'system','navigation','tm',0,0,'-1',0,0,'','',-1,0,''),(41,'system','powered-by','tm',0,10,'-1',0,0,'','',-1,0,''),(42,'system','user-menu','tm',0,0,'-1',0,0,'','',-1,0,''),(43,'user','login','tm',0,0,'-1',0,0,'','',-1,0,''),(44,'user','new','tm',0,0,'-1',0,0,'','',1,0,''),(45,'user','online','tm',0,0,'-1',0,0,'','',-1,0,''),(46,'comment','recent','bootstrap_agency',0,0,'-1',0,0,'','',1,0,''),(47,'node','recent','bootstrap_agency',0,0,'-1',0,0,'','',1,0,''),(48,'node','syndicate','bootstrap_agency',0,0,'-1',0,0,'','',-1,0,''),(49,'search','form','bootstrap_agency',0,-1,'-1',0,0,'','',-1,0,''),(50,'shortcut','shortcuts','bootstrap_agency',0,0,'-1',0,0,'','',-1,0,''),(51,'system','help','bootstrap_agency',1,0,'help',0,0,'','',-1,0,''),(52,'system','main','bootstrap_agency',1,0,'content',0,0,'','',-1,0,''),(53,'system','main-menu','bootstrap_agency',0,0,'-1',0,0,'','',-1,0,''),(54,'system','management','bootstrap_agency',0,0,'-1',0,0,'','',-1,0,''),(55,'system','navigation','bootstrap_agency',0,0,'-1',0,0,'','',-1,0,''),(56,'system','powered-by','bootstrap_agency',0,10,'-1',0,0,'','',-1,0,''),(57,'system','user-menu','bootstrap_agency',0,0,'-1',0,0,'','',-1,0,''),(58,'user','login','bootstrap_agency',0,0,'-1',0,0,'','',-1,0,''),(59,'user','new','bootstrap_agency',0,0,'-1',0,0,'','',1,0,''),(60,'user','online','bootstrap_agency',0,0,'-1',0,0,'','',-1,0,''),(61,'locale','language','bartik',0,0,'-1',0,0,'','<none>',-1,0,'locale-block'),(62,'locale','language','bootstrap_agency',0,0,'-1',0,0,'','<none>',-1,0,'locale-block'),(63,'locale','language','seven',0,0,'-1',0,0,'','<none>',-1,0,'locale-block'),(64,'locale','language','tm',1,-14,'aside_nav',0,0,'','<none>',-1,0,'locale-block'),(77,'backup_migrate','quick_backup','bartik',0,0,'-1',0,0,'','',1,0,''),(78,'backup_migrate','quick_backup','bootstrap_agency',0,0,'-1',0,0,'','',1,0,''),(79,'backup_migrate','quick_backup','seven',0,0,'-1',0,0,'','',1,0,''),(80,'backup_migrate','quick_backup','tm',0,0,'-1',0,0,'','',1,0,''),(81,'custom_search_blocks','1','bartik',0,0,'-1',0,1,'arquivo\r\narquivo/*\r\narchivo\r\narchivo/*','<none>',-1,0,'search-block'),(82,'custom_search_blocks','1','bootstrap_agency',0,0,'-1',0,1,'arquivo\r\narquivo/*\r\narchivo\r\narchivo/*','<none>',-1,0,'search-block'),(83,'custom_search_blocks','1','seven',0,0,'-1',0,1,'arquivo\r\narquivo/*\r\narchivo\r\narchivo/*','<none>',-1,0,'search-block'),(84,'custom_search_blocks','1','tm',1,-16,'sidebar_second',0,1,'arquivo\r\narquivo/*\r\narchivo\r\narchivo/*','<none>',-1,0,'search-block'),(85,'service_links','service_links','bartik',0,0,'-1',0,0,'','',-1,0,''),(86,'service_links','service_links_fisheye','bartik',0,0,'-1',0,0,'','',-1,0,''),(87,'service_links','service_links_not_node','bartik',0,0,'-1',0,0,'','',-1,0,''),(88,'service_links','service_links','bootstrap_agency',0,0,'-1',0,0,'','',-1,0,''),(89,'service_links','service_links_fisheye','bootstrap_agency',0,0,'-1',0,0,'','',-1,0,''),(90,'service_links','service_links_not_node','bootstrap_agency',0,0,'-1',0,0,'','',-1,0,''),(91,'service_links','service_links','seven',0,0,'-1',0,0,'','',-1,0,''),(92,'service_links','service_links_fisheye','seven',0,0,'-1',0,0,'','',-1,0,''),(93,'service_links','service_links_not_node','seven',0,0,'-1',0,0,'','',-1,0,''),(94,'service_links','service_links','tm',0,0,'-1',0,0,'','',-1,0,''),(95,'service_links','service_links_fisheye','tm',0,0,'-1',0,0,'','',-1,0,''),(96,'service_links','service_links_not_node','tm',0,0,'-1',0,0,'','',-1,0,''),(97,'views','map-block_1','tm',1,-18,'content',0,1,'mapa','<none>',-1,0,''),(98,'block','1','bootstrap_agency',0,0,'-1',0,0,'','<none>',-1,0,'social-block'),(99,'block','1','tm',1,-13,'aside_nav',0,0,'','<none>',-1,0,'social-block'),(100,'block','2','bootstrap_agency',0,0,'-1',0,0,'','<none>',-1,0,'logos-block'),(101,'block','2','tm',1,-12,'aside_nav',0,0,'','<none>',-1,0,'logos-block'),(102,'views','map-block_1','bootstrap_agency',0,0,'-1',0,1,'mapa','<none>',-1,0,''),(103,'block','3','bootstrap_agency',0,0,'-1',0,1,'arquivo\r\narquivo/*','<none>',-1,0,'categories-block'),(104,'block','3','tm',1,-18,'sidebar_second',0,1,'arquivo\r\narquivo/*','<none>',-1,0,'categories-block'),(105,'block','4','bootstrap_agency',0,0,'-1',0,0,'','<none>',-1,0,''),(106,'block','4','tm',0,0,'-1',0,0,'','<none>',-1,0,''),(107,'views','archives-block_1','bootstrap_agency',0,0,'-1',0,0,'','',-1,0,''),(108,'views','archives-block_1','tm',0,0,'-1',0,0,'','',-1,0,''),(109,'block','5','tm',1,-16,'footer',0,1,'<front>','<none>',-1,0,'footer-block'),(110,'block','6','tm',1,-17,'sidebar_second',0,1,'archivo\r\narchivo/*','<none>',-1,0,'categories-block'),(111,'block','7','tm',1,-15,'footer',0,1,'<front>','<none>',-1,0,'footer-block'),(112,'views','axenda-block','tm',0,0,'-1',0,1,'actividades\r\nactividades/*\r\naxenda\r\naxenda/*','<none>',-1,0,''),(113,'views','diary_items-block','tm',1,-15,'sidebar_second',0,1,'actividades\r\nactividades/*\r\naxenda/*','<none>',-1,0,''),(114,'block','8','tm',1,-14,'sidebar_second',0,1,'actividades\r\nactividades/*\r\naxenda/*','<none>',-1,0,'diary-block-link'),(115,'block','9','tm',1,-13,'sidebar_second',0,1,'actividades\r\nactividades/*\r\naxenda/*','<none>',-1,0,'diary-block-link'),(116,'views','map-block_2','tm',1,-17,'content',0,1,'mapa/*','<none>',-1,0,''),(117,'block','10','tm',1,-16,'content',0,1,'actividades\r\nactividades/*','<none>',-1,0,'block-toggle-activities-diary'),(118,'block','11','tm',1,-15,'content',0,1,'actividades\r\nactividades/*','<none>',-1,0,'block-toggle-activities-diary');
/*!40000 ALTER TABLE `block` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `block_custom`
--

DROP TABLE IF EXISTS `block_custom`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `block_custom` (
  `bid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The block’s block.bid.',
  `body` longtext COMMENT 'Block contents.',
  `info` varchar(128) NOT NULL DEFAULT '' COMMENT 'Block description.',
  `format` varchar(255) DEFAULT NULL COMMENT 'The filter_format.format of the block body.',
  PRIMARY KEY (`bid`),
  UNIQUE KEY `info` (`info`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COMMENT='Stores contents of custom-made blocks.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `block_custom`
--

LOCK TABLES `block_custom` WRITE;
/*!40000 ALTER TABLE `block_custom` DISABLE KEYS */;
INSERT INTO `block_custom` VALUES (1,'<ul><li><a href=\"https://www.facebook.com/territoriodasmulleres\">FB</a></li><li><a href=\"https://twitter.com/CompostelaTM\">TW</a></li><li><a href=\"https://www.instagram.com/compostelatm\">INST</a></li></ul>','Redes sociais','filtered_html'),(2,'<p><a href=\"http://santiagodecompostela.gal\"><img alt=\"Logo Concello de Santiago\" src=\"/sites/all/files/public/media/logo-concello-santiago.png\" style=\"width: 43px; height: 59px;\" /></a></p>','Logos','filtered_html'),(3,'<ul><li class=\"first\"><a href=\"/gl/arquivo/relevantes\">Relevantes<span class=\"icon icon-relevants\">&nbsp;</span></a></li><li><a href=\"/gl/arquivo/estudios\">Estudios<span class=\"icon icon-studies\">&nbsp;</span></a></li><li><a href=\"/gl/arquivo/axendas\">Axendas<span class=\"icon icon-diaries\">&nbsp;</span></a></li><li><a href=\"/gl/arquivo/campañas\">Campañas<span class=\"icon icon-campaigns\">&nbsp;</span></a></li><li><a href=\"/gl/arquivo/videos\">Vídeos<span class=\"icon icon-videos\">&nbsp;</span></a></li><li class=\"last\"><a href=\"#block-custom-search-blocks-1\">Búsquedas<span class=\"icon icon-searchs\">&nbsp;</span></a></li></ul>','Categorías Arquivo (gl)','filtered_html'),(4,'<p><a href=\"mailto:territoriodasmulleres@gmail.com\">comentar</a></p>','Comentar','filtered_html'),(5,'<div class=\"row\"><div class=\"col-xs-6 col-sm-12\"><p>Correo: <a href=\"mailto:territoriodasmulleres@gmail.com\">territoriodasmulleres [@] gmail.com</a>. Tel.: 981 542 465 (CIM)</p><p>&copy; Concello de Santiago. Pazo de Raxoi. Praza do Obradoiro. Tel.: 981 542 300&nbsp;(Centraliña). <a href=\"http://www.santiagodecompostela.gal/avisolegal.php?lg=gal\">Aviso legal</a>.</p></div><div class=\"col-xs-6 visible-xs-block\"><ul class=\"pull-right\"><li><a href=\"https://www.facebook.com/territoriodasmulleres\">FB</a></li><li><a href=\"https://twitter.com/CompostelaTM\">TW</a></li><li><a href=\"https://www.instagram.com/compostelatm\">INST</a></li></ul><a class=\"pull-right\" href=\"http://santiagodecompostela.gal\"><img alt=\"Logo Concello de Santiago\" src=\"/sites/all/files/public/media/logo-concello-santiago-negro.png\" /></a></div></div>','Footer (gl)','filtered_html'),(6,'<ul><li class=\"first\"><a href=\"/es/archivo/relevantes\">Relevantes<span class=\"icon icon-relevants\">&nbsp;</span></a></li><li><a href=\"/es/archivo/estudios\">Estudios<span class=\"icon icon-studies\">&nbsp;</span></a></li><li><a href=\"/es/archivo/agendas\">Agendas<span class=\"icon icon-diaries\">&nbsp;</span></a></li><li><a href=\"/es/archivo/campañas\">Campañas<span class=\"icon icon-campaigns\">&nbsp;</span></a></li><li><a href=\"/es/archivo/videos\">Vídeos<span class=\"icon icon-videos\">&nbsp;</span></a></li><li class=\"last\"><a href=\"#block-custom-search-blocks-1\">Búsquedas<span class=\"icon icon-searchs\">&nbsp;</span></a></li></ul>','Categorías Arquivo (es)','filtered_html'),(7,'<div class=\"row\"><div class=\"col-xs-6 col-sm-12\"><p>Correo: <a href=\"mailto:territoriodasmulleres@gmail.com\">territoriodasmulleres [@] gmail.com</a>. Tel.: 981 542 465 (CIM)</p><p>&copy; Ayuntamiento de Santiago. Pazo de Raxoi. Praza do Obradoiro. Tel.: 981 542 300&nbsp;(Centralita). <a href=\"http://www.santiagodecompostela.gal/avisolegal.php?lg=cas\">Aviso legal</a>.</p></div><div class=\"col-xs-6 visible-xs-block\"><ul class=\"pull-right\"><li><a href=\"https://www.facebook.com/territoriodasmulleres\">FB</a></li><li><a href=\"https://twitter.com/CompostelaTM\">TW</a></li><li><a href=\"https://www.instagram.com/compostelatm\">INST</a></li></ul><a class=\"pull-right\" href=\"http://santiagodecompostela.gal\"><img alt=\"Logo Ayuntamiento de Santiago\" src=\"/sites/all/files/public/media/logo-concello-santiago-negro.png\" /></a></div></div>','Footer (es)','filtered_html'),(8,'<p>Axenda cultural completa en <a href=\"http://santiagoturismo.com\">SantiagoTurismo.com</a></p>','View Axenda Link (gl)','filtered_html'),(9,'<p>Agenda cultural completa en <a href=\"http://santiagoturismo.com\">SantiagoTurismo.com</a></p>','View Axenda Link (es)','filtered_html'),(10,'<ul><li><a id=\"toggle-activities\">Actividades</a></li><li><a id=\"toggle-diary\">Axenda cultural</a></li></ul>','Toggle Actividades - Axenda','filtered_html'),(11,'<ul><li><a id=\"toggle-activities\">Actividades</a></li><li><a id=\"toggle-diary\">Agenda cultural</a></li></ul>','Toggle Actividades - Agenda','filtered_html');
/*!40000 ALTER TABLE `block_custom` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `block_node_type`
--

DROP TABLE IF EXISTS `block_node_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `block_node_type` (
  `module` varchar(64) NOT NULL COMMENT 'The block’s origin module, from block.module.',
  `delta` varchar(32) NOT NULL COMMENT 'The block’s unique delta within module, from block.delta.',
  `type` varchar(32) NOT NULL COMMENT 'The machine-readable name of this type from node_type.type.',
  PRIMARY KEY (`module`,`delta`,`type`),
  KEY `type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Sets up display criteria for blocks based on content types';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `block_node_type`
--

LOCK TABLES `block_node_type` WRITE;
/*!40000 ALTER TABLE `block_node_type` DISABLE KEYS */;
/*!40000 ALTER TABLE `block_node_type` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `block_role`
--

DROP TABLE IF EXISTS `block_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `block_role` (
  `module` varchar(64) NOT NULL COMMENT 'The block’s origin module, from block.module.',
  `delta` varchar(32) NOT NULL COMMENT 'The block’s unique delta within module, from block.delta.',
  `rid` int(10) unsigned NOT NULL COMMENT 'The user’s role ID from users_roles.rid.',
  PRIMARY KEY (`module`,`delta`,`rid`),
  KEY `rid` (`rid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Sets up access permissions for blocks based on user roles';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `block_role`
--

LOCK TABLES `block_role` WRITE;
/*!40000 ALTER TABLE `block_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `block_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blocked_ips`
--

DROP TABLE IF EXISTS `blocked_ips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blocked_ips` (
  `iid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: unique ID for IP addresses.',
  `ip` varchar(40) NOT NULL DEFAULT '' COMMENT 'IP address',
  PRIMARY KEY (`iid`),
  KEY `blocked_ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores blocked IP addresses.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blocked_ips`
--

LOCK TABLES `blocked_ips` WRITE;
/*!40000 ALTER TABLE `blocked_ips` DISABLE KEYS */;
/*!40000 ALTER TABLE `blocked_ips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache`
--

DROP TABLE IF EXISTS `cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Generic cache table for caching things not separated out...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache`
--

LOCK TABLES `cache` WRITE;
/*!40000 ALTER TABLE `cache` DISABLE KEYS */;
INSERT INTO `cache` VALUES ('ctools_plugin_files:ctools:content_types','a:6:{s:6:\"ctools\";a:62:{s:4:\"form\";O:8:\"stdClass\":3:{s:3:\"uri\";s:60:\"sites/all/modules/ctools/plugins/content_types/form/form.inc\";s:8:\"filename\";s:8:\"form.inc\";s:4:\"name\";s:4:\"form\";}s:17:\"entity_form_field\";O:8:\"stdClass\":3:{s:3:\"uri\";s:73:\"sites/all/modules/ctools/plugins/content_types/form/entity_form_field.inc\";s:8:\"filename\";s:21:\"entity_form_field.inc\";s:4:\"name\";s:17:\"entity_form_field\";}s:4:\"node\";O:8:\"stdClass\":3:{s:3:\"uri\";s:60:\"sites/all/modules/ctools/plugins/content_types/node/node.inc\";s:8:\"filename\";s:8:\"node.inc\";s:4:\"name\";s:4:\"node\";}s:5:\"token\";O:8:\"stdClass\":3:{s:3:\"uri\";s:62:\"sites/all/modules/ctools/plugins/content_types/token/token.inc\";s:8:\"filename\";s:9:\"token.inc\";s:4:\"name\";s:5:\"token\";}s:5:\"block\";O:8:\"stdClass\":3:{s:3:\"uri\";s:62:\"sites/all/modules/ctools/plugins/content_types/block/block.inc\";s:8:\"filename\";s:9:\"block.inc\";s:4:\"name\";s:5:\"block\";}s:10:\"page_title\";O:8:\"stdClass\":3:{s:3:\"uri\";s:66:\"sites/all/modules/ctools/plugins/content_types/page/page_title.inc\";s:8:\"filename\";s:14:\"page_title.inc\";s:4:\"name\";s:10:\"page_title\";}s:11:\"page_slogan\";O:8:\"stdClass\":3:{s:3:\"uri\";s:67:\"sites/all/modules/ctools/plugins/content_types/page/page_slogan.inc\";s:8:\"filename\";s:15:\"page_slogan.inc\";s:4:\"name\";s:11:\"page_slogan\";}s:15:\"page_feed_icons\";O:8:\"stdClass\":3:{s:3:\"uri\";s:71:\"sites/all/modules/ctools/plugins/content_types/page/page_feed_icons.inc\";s:8:\"filename\";s:19:\"page_feed_icons.inc\";s:4:\"name\";s:15:\"page_feed_icons\";}s:12:\"page_actions\";O:8:\"stdClass\":3:{s:3:\"uri\";s:68:\"sites/all/modules/ctools/plugins/content_types/page/page_actions.inc\";s:8:\"filename\";s:16:\"page_actions.inc\";s:4:\"name\";s:12:\"page_actions\";}s:15:\"page_breadcrumb\";O:8:\"stdClass\":3:{s:3:\"uri\";s:71:\"sites/all/modules/ctools/plugins/content_types/page/page_breadcrumb.inc\";s:8:\"filename\";s:19:\"page_breadcrumb.inc\";s:4:\"name\";s:15:\"page_breadcrumb\";}s:20:\"page_secondary_links\";O:8:\"stdClass\":3:{s:3:\"uri\";s:76:\"sites/all/modules/ctools/plugins/content_types/page/page_secondary_links.inc\";s:8:\"filename\";s:24:\"page_secondary_links.inc\";s:4:\"name\";s:20:\"page_secondary_links\";}s:14:\"page_site_name\";O:8:\"stdClass\":3:{s:3:\"uri\";s:70:\"sites/all/modules/ctools/plugins/content_types/page/page_site_name.inc\";s:8:\"filename\";s:18:\"page_site_name.inc\";s:4:\"name\";s:14:\"page_site_name\";}s:9:\"page_help\";O:8:\"stdClass\":3:{s:3:\"uri\";s:65:\"sites/all/modules/ctools/plugins/content_types/page/page_help.inc\";s:8:\"filename\";s:13:\"page_help.inc\";s:4:\"name\";s:9:\"page_help\";}s:9:\"page_logo\";O:8:\"stdClass\":3:{s:3:\"uri\";s:65:\"sites/all/modules/ctools/plugins/content_types/page/page_logo.inc\";s:8:\"filename\";s:13:\"page_logo.inc\";s:4:\"name\";s:9:\"page_logo\";}s:18:\"page_primary_links\";O:8:\"stdClass\":3:{s:3:\"uri\";s:74:\"sites/all/modules/ctools/plugins/content_types/page/page_primary_links.inc\";s:8:\"filename\";s:22:\"page_primary_links.inc\";s:4:\"name\";s:18:\"page_primary_links\";}s:9:\"page_tabs\";O:8:\"stdClass\":3:{s:3:\"uri\";s:65:\"sites/all/modules/ctools/plugins/content_types/page/page_tabs.inc\";s:8:\"filename\";s:13:\"page_tabs.inc\";s:4:\"name\";s:9:\"page_tabs\";}s:13:\"page_messages\";O:8:\"stdClass\":3:{s:3:\"uri\";s:69:\"sites/all/modules/ctools/plugins/content_types/page/page_messages.inc\";s:8:\"filename\";s:17:\"page_messages.inc\";s:4:\"name\";s:13:\"page_messages\";}s:7:\"contact\";O:8:\"stdClass\":3:{s:3:\"uri\";s:66:\"sites/all/modules/ctools/plugins/content_types/contact/contact.inc\";s:8:\"filename\";s:11:\"contact.inc\";s:4:\"name\";s:7:\"contact\";}s:12:\"user_contact\";O:8:\"stdClass\":3:{s:3:\"uri\";s:71:\"sites/all/modules/ctools/plugins/content_types/contact/user_contact.inc\";s:8:\"filename\";s:16:\"user_contact.inc\";s:4:\"name\";s:12:\"user_contact\";}s:9:\"term_name\";O:8:\"stdClass\":3:{s:3:\"uri\";s:73:\"sites/all/modules/ctools/plugins/content_types/term_context/term_name.inc\";s:8:\"filename\";s:13:\"term_name.inc\";s:4:\"name\";s:9:\"term_name\";}s:16:\"term_description\";O:8:\"stdClass\":3:{s:3:\"uri\";s:80:\"sites/all/modules/ctools/plugins/content_types/term_context/term_description.inc\";s:8:\"filename\";s:20:\"term_description.inc\";s:4:\"name\";s:16:\"term_description\";}s:9:\"term_list\";O:8:\"stdClass\":3:{s:3:\"uri\";s:73:\"sites/all/modules/ctools/plugins/content_types/term_context/term_list.inc\";s:8:\"filename\";s:13:\"term_list.inc\";s:4:\"name\";s:9:\"term_list\";}s:11:\"search_form\";O:8:\"stdClass\":3:{s:3:\"uri\";s:69:\"sites/all/modules/ctools/plugins/content_types/search/search_form.inc\";s:8:\"filename\";s:15:\"search_form.inc\";s:4:\"name\";s:11:\"search_form\";}s:13:\"search_result\";O:8:\"stdClass\":3:{s:3:\"uri\";s:71:\"sites/all/modules/ctools/plugins/content_types/search/search_result.inc\";s:8:\"filename\";s:17:\"search_result.inc\";s:4:\"name\";s:13:\"search_result\";}s:6:\"custom\";O:8:\"stdClass\":3:{s:3:\"uri\";s:64:\"sites/all/modules/ctools/plugins/content_types/custom/custom.inc\";s:8:\"filename\";s:10:\"custom.inc\";s:4:\"name\";s:6:\"custom\";}s:14:\"user_signature\";O:8:\"stdClass\":3:{s:3:\"uri\";s:78:\"sites/all/modules/ctools/plugins/content_types/user_context/user_signature.inc\";s:8:\"filename\";s:18:\"user_signature.inc\";s:4:\"name\";s:14:\"user_signature\";}s:10:\"user_links\";O:8:\"stdClass\":3:{s:3:\"uri\";s:74:\"sites/all/modules/ctools/plugins/content_types/user_context/user_links.inc\";s:8:\"filename\";s:14:\"user_links.inc\";s:4:\"name\";s:10:\"user_links\";}s:14:\"profile_fields\";O:8:\"stdClass\":3:{s:3:\"uri\";s:78:\"sites/all/modules/ctools/plugins/content_types/user_context/profile_fields.inc\";s:8:\"filename\";s:18:\"profile_fields.inc\";s:4:\"name\";s:14:\"profile_fields\";}s:12:\"user_picture\";O:8:\"stdClass\":3:{s:3:\"uri\";s:76:\"sites/all/modules/ctools/plugins/content_types/user_context/user_picture.inc\";s:8:\"filename\";s:16:\"user_picture.inc\";s:4:\"name\";s:12:\"user_picture\";}s:12:\"user_profile\";O:8:\"stdClass\":3:{s:3:\"uri\";s:76:\"sites/all/modules/ctools/plugins/content_types/user_context/user_profile.inc\";s:8:\"filename\";s:16:\"user_profile.inc\";s:4:\"name\";s:12:\"user_profile\";}s:10:\"node_links\";O:8:\"stdClass\":3:{s:3:\"uri\";s:74:\"sites/all/modules/ctools/plugins/content_types/node_context/node_links.inc\";s:8:\"filename\";s:14:\"node_links.inc\";s:4:\"name\";s:10:\"node_links\";}s:10:\"node_title\";O:8:\"stdClass\":3:{s:3:\"uri\";s:74:\"sites/all/modules/ctools/plugins/content_types/node_context/node_title.inc\";s:8:\"filename\";s:14:\"node_title.inc\";s:4:\"name\";s:10:\"node_title\";}s:11:\"node_author\";O:8:\"stdClass\":3:{s:3:\"uri\";s:75:\"sites/all/modules/ctools/plugins/content_types/node_context/node_author.inc\";s:8:\"filename\";s:15:\"node_author.inc\";s:4:\"name\";s:11:\"node_author\";}s:16:\"node_attachments\";O:8:\"stdClass\":3:{s:3:\"uri\";s:80:\"sites/all/modules/ctools/plugins/content_types/node_context/node_attachments.inc\";s:8:\"filename\";s:20:\"node_attachments.inc\";s:4:\"name\";s:16:\"node_attachments\";}s:18:\"node_book_children\";O:8:\"stdClass\":3:{s:3:\"uri\";s:82:\"sites/all/modules/ctools/plugins/content_types/node_context/node_book_children.inc\";s:8:\"filename\";s:22:\"node_book_children.inc\";s:4:\"name\";s:18:\"node_book_children\";}s:14:\"node_type_desc\";O:8:\"stdClass\":3:{s:3:\"uri\";s:78:\"sites/all/modules/ctools/plugins/content_types/node_context/node_type_desc.inc\";s:8:\"filename\";s:18:\"node_type_desc.inc\";s:4:\"name\";s:14:\"node_type_desc\";}s:17:\"node_comment_form\";O:8:\"stdClass\":3:{s:3:\"uri\";s:81:\"sites/all/modules/ctools/plugins/content_types/node_context/node_comment_form.inc\";s:8:\"filename\";s:21:\"node_comment_form.inc\";s:4:\"name\";s:17:\"node_comment_form\";}s:12:\"node_content\";O:8:\"stdClass\":3:{s:3:\"uri\";s:76:\"sites/all/modules/ctools/plugins/content_types/node_context/node_content.inc\";s:8:\"filename\";s:16:\"node_content.inc\";s:4:\"name\";s:12:\"node_content\";}s:20:\"node_comment_wrapper\";O:8:\"stdClass\":3:{s:3:\"uri\";s:84:\"sites/all/modules/ctools/plugins/content_types/node_context/node_comment_wrapper.inc\";s:8:\"filename\";s:24:\"node_comment_wrapper.inc\";s:4:\"name\";s:20:\"node_comment_wrapper\";}s:10:\"node_terms\";O:8:\"stdClass\":3:{s:3:\"uri\";s:74:\"sites/all/modules/ctools/plugins/content_types/node_context/node_terms.inc\";s:8:\"filename\";s:14:\"node_terms.inc\";s:4:\"name\";s:10:\"node_terms\";}s:12:\"node_created\";O:8:\"stdClass\":3:{s:3:\"uri\";s:76:\"sites/all/modules/ctools/plugins/content_types/node_context/node_created.inc\";s:8:\"filename\";s:16:\"node_created.inc\";s:4:\"name\";s:12:\"node_created\";}s:9:\"node_body\";O:8:\"stdClass\":3:{s:3:\"uri\";s:73:\"sites/all/modules/ctools/plugins/content_types/node_context/node_body.inc\";s:8:\"filename\";s:13:\"node_body.inc\";s:4:\"name\";s:9:\"node_body\";}s:12:\"node_updated\";O:8:\"stdClass\":3:{s:3:\"uri\";s:76:\"sites/all/modules/ctools/plugins/content_types/node_context/node_updated.inc\";s:8:\"filename\";s:16:\"node_updated.inc\";s:4:\"name\";s:12:\"node_updated\";}s:13:\"node_comments\";O:8:\"stdClass\":3:{s:3:\"uri\";s:77:\"sites/all/modules/ctools/plugins/content_types/node_context/node_comments.inc\";s:8:\"filename\";s:17:\"node_comments.inc\";s:4:\"name\";s:13:\"node_comments\";}s:13:\"node_book_nav\";O:8:\"stdClass\":3:{s:3:\"uri\";s:77:\"sites/all/modules/ctools/plugins/content_types/node_context/node_book_nav.inc\";s:8:\"filename\";s:17:\"node_book_nav.inc\";s:4:\"name\";s:13:\"node_book_nav\";}s:18:\"comment_reply_form\";O:8:\"stdClass\":3:{s:3:\"uri\";s:77:\"sites/all/modules/ctools/plugins/content_types/comment/comment_reply_form.inc\";s:8:\"filename\";s:22:\"comment_reply_form.inc\";s:4:\"name\";s:18:\"comment_reply_form\";}s:15:\"comment_created\";O:8:\"stdClass\":3:{s:3:\"uri\";s:74:\"sites/all/modules/ctools/plugins/content_types/comment/comment_created.inc\";s:8:\"filename\";s:19:\"comment_created.inc\";s:4:\"name\";s:15:\"comment_created\";}s:13:\"comment_links\";O:8:\"stdClass\":3:{s:3:\"uri\";s:72:\"sites/all/modules/ctools/plugins/content_types/comment/comment_links.inc\";s:8:\"filename\";s:17:\"comment_links.inc\";s:4:\"name\";s:13:\"comment_links\";}s:14:\"node_form_path\";O:8:\"stdClass\":3:{s:3:\"uri\";s:75:\"sites/all/modules/ctools/plugins/content_types/node_form/node_form_path.inc\";s:8:\"filename\";s:18:\"node_form_path.inc\";s:4:\"name\";s:14:\"node_form_path\";}s:20:\"node_form_publishing\";O:8:\"stdClass\":3:{s:3:\"uri\";s:81:\"sites/all/modules/ctools/plugins/content_types/node_form/node_form_publishing.inc\";s:8:\"filename\";s:24:\"node_form_publishing.inc\";s:4:\"name\";s:20:\"node_form_publishing\";}s:13:\"node_form_log\";O:8:\"stdClass\":3:{s:3:\"uri\";s:74:\"sites/all/modules/ctools/plugins/content_types/node_form/node_form_log.inc\";s:8:\"filename\";s:17:\"node_form_log.inc\";s:4:\"name\";s:13:\"node_form_log\";}s:17:\"node_form_buttons\";O:8:\"stdClass\":3:{s:3:\"uri\";s:78:\"sites/all/modules/ctools/plugins/content_types/node_form/node_form_buttons.inc\";s:8:\"filename\";s:21:\"node_form_buttons.inc\";s:4:\"name\";s:17:\"node_form_buttons\";}s:18:\"node_form_language\";O:8:\"stdClass\":3:{s:3:\"uri\";s:79:\"sites/all/modules/ctools/plugins/content_types/node_form/node_form_language.inc\";s:8:\"filename\";s:22:\"node_form_language.inc\";s:4:\"name\";s:18:\"node_form_language\";}s:21:\"node_form_attachments\";O:8:\"stdClass\":3:{s:3:\"uri\";s:82:\"sites/all/modules/ctools/plugins/content_types/node_form/node_form_attachments.inc\";s:8:\"filename\";s:25:\"node_form_attachments.inc\";s:4:\"name\";s:21:\"node_form_attachments\";}s:14:\"node_form_book\";O:8:\"stdClass\":3:{s:3:\"uri\";s:75:\"sites/all/modules/ctools/plugins/content_types/node_form/node_form_book.inc\";s:8:\"filename\";s:18:\"node_form_book.inc\";s:4:\"name\";s:14:\"node_form_book\";}s:14:\"node_form_menu\";O:8:\"stdClass\":3:{s:3:\"uri\";s:75:\"sites/all/modules/ctools/plugins/content_types/node_form/node_form_menu.inc\";s:8:\"filename\";s:18:\"node_form_menu.inc\";s:4:\"name\";s:14:\"node_form_menu\";}s:17:\"node_form_comment\";O:8:\"stdClass\":3:{s:3:\"uri\";s:78:\"sites/all/modules/ctools/plugins/content_types/node_form/node_form_comment.inc\";s:8:\"filename\";s:21:\"node_form_comment.inc\";s:4:\"name\";s:17:\"node_form_comment\";}s:16:\"node_form_author\";O:8:\"stdClass\":3:{s:3:\"uri\";s:77:\"sites/all/modules/ctools/plugins/content_types/node_form/node_form_author.inc\";s:8:\"filename\";s:20:\"node_form_author.inc\";s:4:\"name\";s:16:\"node_form_author\";}s:15:\"node_form_title\";O:8:\"stdClass\":3:{s:3:\"uri\";s:76:\"sites/all/modules/ctools/plugins/content_types/node_form/node_form_title.inc\";s:8:\"filename\";s:19:\"node_form_title.inc\";s:4:\"name\";s:15:\"node_form_title\";}s:18:\"entity_field_extra\";O:8:\"stdClass\":3:{s:3:\"uri\";s:84:\"sites/all/modules/ctools/plugins/content_types/entity_context/entity_field_extra.inc\";s:8:\"filename\";s:22:\"entity_field_extra.inc\";s:4:\"name\";s:18:\"entity_field_extra\";}s:12:\"entity_field\";O:8:\"stdClass\":3:{s:3:\"uri\";s:78:\"sites/all/modules/ctools/plugins/content_types/entity_context/entity_field.inc\";s:8:\"filename\";s:16:\"entity_field.inc\";s:4:\"name\";s:12:\"entity_field\";}s:16:\"vocabulary_terms\";O:8:\"stdClass\":3:{s:3:\"uri\";s:86:\"sites/all/modules/ctools/plugins/content_types/vocabulary_context/vocabulary_terms.inc\";s:8:\"filename\";s:20:\"vocabulary_terms.inc\";s:4:\"name\";s:16:\"vocabulary_terms\";}}s:6:\"entity\";a:1:{s:11:\"entity_view\";O:8:\"stdClass\":3:{s:3:\"uri\";s:61:\"sites/all/modules/entity/ctools/content_types/entity_view.inc\";s:8:\"filename\";s:15:\"entity_view.inc\";s:4:\"name\";s:11:\"entity_view\";}}s:8:\"location\";a:0:{}s:7:\"metatag\";a:1:{s:18:\"node_form_metatags\";O:8:\"stdClass\":3:{s:3:\"uri\";s:70:\"sites/all/modules/metatag/plugins/content_types/node_form_metatags.inc\";s:8:\"filename\";s:22:\"node_form_metatags.inc\";s:4:\"name\";s:18:\"node_form_metatags\";}}s:4:\"rate\";a:1:{s:11:\"rate_widget\";O:8:\"stdClass\":3:{s:3:\"uri\";s:60:\"sites/all/modules/rate/plugins/content_types/rate_widget.inc\";s:8:\"filename\";s:15:\"rate_widget.inc\";s:4:\"name\";s:11:\"rate_widget\";}}s:4:\"uuid\";a:0:{}}',0,1469579868,1),('ctools_plugin_files:feeds:plugins','a:0:{}',0,1469579872,1),('ctools_plugin_type_info','a:3:{s:6:\"ctools\";a:7:{s:8:\"contexts\";a:14:{s:13:\"child plugins\";b:1;s:6:\"module\";s:6:\"ctools\";s:4:\"type\";s:8:\"contexts\";s:5:\"cache\";b:0;s:11:\"cache table\";s:5:\"cache\";s:7:\"classes\";a:0:{}s:9:\"use hooks\";b:0;s:8:\"defaults\";a:0:{}s:7:\"process\";s:0:\"\";s:9:\"alterable\";b:1;s:9:\"extension\";s:3:\"inc\";s:9:\"info file\";b:0;s:4:\"hook\";s:15:\"ctools_contexts\";s:11:\"load themes\";b:0;}s:9:\"arguments\";a:14:{s:13:\"child plugins\";b:1;s:6:\"module\";s:6:\"ctools\";s:4:\"type\";s:9:\"arguments\";s:5:\"cache\";b:0;s:11:\"cache table\";s:5:\"cache\";s:7:\"classes\";a:0:{}s:9:\"use hooks\";b:0;s:8:\"defaults\";a:0:{}s:7:\"process\";s:0:\"\";s:9:\"alterable\";b:1;s:9:\"extension\";s:3:\"inc\";s:9:\"info file\";b:0;s:4:\"hook\";s:16:\"ctools_arguments\";s:11:\"load themes\";b:0;}s:13:\"relationships\";a:14:{s:13:\"child plugins\";b:1;s:6:\"module\";s:6:\"ctools\";s:4:\"type\";s:13:\"relationships\";s:5:\"cache\";b:0;s:11:\"cache table\";s:5:\"cache\";s:7:\"classes\";a:0:{}s:9:\"use hooks\";b:0;s:8:\"defaults\";a:0:{}s:7:\"process\";s:0:\"\";s:9:\"alterable\";b:1;s:9:\"extension\";s:3:\"inc\";s:9:\"info file\";b:0;s:4:\"hook\";s:20:\"ctools_relationships\";s:11:\"load themes\";b:0;}s:6:\"access\";a:14:{s:13:\"child plugins\";b:1;s:6:\"module\";s:6:\"ctools\";s:4:\"type\";s:6:\"access\";s:5:\"cache\";b:0;s:11:\"cache table\";s:5:\"cache\";s:7:\"classes\";a:0:{}s:9:\"use hooks\";b:0;s:8:\"defaults\";a:0:{}s:7:\"process\";s:0:\"\";s:9:\"alterable\";b:1;s:9:\"extension\";s:3:\"inc\";s:9:\"info file\";b:0;s:4:\"hook\";s:13:\"ctools_access\";s:11:\"load themes\";b:0;}s:5:\"cache\";a:13:{s:6:\"module\";s:6:\"ctools\";s:4:\"type\";s:5:\"cache\";s:5:\"cache\";b:0;s:11:\"cache table\";s:5:\"cache\";s:7:\"classes\";a:0:{}s:9:\"use hooks\";b:0;s:8:\"defaults\";a:0:{}s:7:\"process\";s:0:\"\";s:9:\"alterable\";b:1;s:9:\"extension\";s:3:\"inc\";s:9:\"info file\";b:0;s:4:\"hook\";s:12:\"ctools_cache\";s:11:\"load themes\";b:0;}s:13:\"content_types\";a:13:{s:5:\"cache\";b:0;s:7:\"process\";a:3:{s:8:\"function\";s:22:\"ctools_content_process\";s:4:\"file\";s:11:\"content.inc\";s:4:\"path\";s:33:\"sites/all/modules/ctools/includes\";}s:6:\"module\";s:6:\"ctools\";s:4:\"type\";s:13:\"content_types\";s:11:\"cache table\";s:5:\"cache\";s:7:\"classes\";a:0:{}s:9:\"use hooks\";b:0;s:8:\"defaults\";a:0:{}s:9:\"alterable\";b:1;s:9:\"extension\";s:3:\"inc\";s:9:\"info file\";b:0;s:4:\"hook\";s:20:\"ctools_content_types\";s:11:\"load themes\";b:0;}s:9:\"export_ui\";a:13:{s:7:\"process\";a:3:{s:8:\"function\";s:24:\"ctools_export_ui_process\";s:4:\"file\";s:13:\"export-ui.inc\";s:4:\"path\";s:33:\"sites/all/modules/ctools/includes\";}s:7:\"classes\";a:1:{i:0;s:7:\"handler\";}s:6:\"module\";s:6:\"ctools\";s:4:\"type\";s:9:\"export_ui\";s:5:\"cache\";b:0;s:11:\"cache table\";s:5:\"cache\";s:9:\"use hooks\";b:0;s:8:\"defaults\";a:0:{}s:9:\"alterable\";b:1;s:9:\"extension\";s:3:\"inc\";s:9:\"info file\";b:0;s:4:\"hook\";s:16:\"ctools_export_ui\";s:11:\"load themes\";b:0;}}s:5:\"feeds\";a:1:{s:7:\"plugins\";a:13:{s:5:\"cache\";b:1;s:9:\"use hooks\";b:1;s:7:\"classes\";a:1:{i:0;s:7:\"handler\";}s:6:\"module\";s:5:\"feeds\";s:4:\"type\";s:7:\"plugins\";s:11:\"cache table\";s:5:\"cache\";s:8:\"defaults\";a:0:{}s:7:\"process\";s:0:\"\";s:9:\"alterable\";b:1;s:9:\"extension\";s:3:\"inc\";s:9:\"info file\";b:0;s:4:\"hook\";s:13:\"feeds_plugins\";s:11:\"load themes\";b:0;}}s:8:\"views_ui\";a:1:{s:12:\"views_wizard\";a:14:{s:13:\"child plugins\";b:1;s:7:\"classes\";a:1:{i:0;s:17:\"form_wizard_class\";}s:8:\"defaults\";a:6:{s:12:\"get children\";N;s:9:\"get child\";N;s:5:\"title\";s:0:\"\";s:10:\"base_table\";N;s:12:\"get_instance\";s:33:\"views_ui_get_form_wizard_instance\";s:17:\"form_wizard_class\";a:2:{s:4:\"file\";s:26:\"views_ui_base_views_wizard\";s:5:\"class\";s:22:\"ViewsUiBaseViewsWizard\";}}s:6:\"module\";s:8:\"views_ui\";s:4:\"type\";s:12:\"views_wizard\";s:5:\"cache\";b:0;s:11:\"cache table\";s:5:\"cache\";s:9:\"use hooks\";b:0;s:7:\"process\";s:0:\"\";s:9:\"alterable\";b:1;s:9:\"extension\";s:3:\"inc\";s:9:\"info file\";b:0;s:4:\"hook\";s:21:\"views_ui_views_wizard\";s:11:\"load themes\";b:0;}}}',0,1469579868,1),('date_timezone_identifiers_list','a:417:{s:14:\"Africa/Abidjan\";s:14:\"Africa/Abidjan\";s:12:\"Africa/Accra\";s:12:\"Africa/Accra\";s:18:\"Africa/Addis_Ababa\";s:18:\"Africa/Addis_Ababa\";s:14:\"Africa/Algiers\";s:14:\"Africa/Algiers\";s:13:\"Africa/Asmara\";s:13:\"Africa/Asmara\";s:13:\"Africa/Bamako\";s:13:\"Africa/Bamako\";s:13:\"Africa/Bangui\";s:13:\"Africa/Bangui\";s:13:\"Africa/Banjul\";s:13:\"Africa/Banjul\";s:13:\"Africa/Bissau\";s:13:\"Africa/Bissau\";s:15:\"Africa/Blantyre\";s:15:\"Africa/Blantyre\";s:18:\"Africa/Brazzaville\";s:18:\"Africa/Brazzaville\";s:16:\"Africa/Bujumbura\";s:16:\"Africa/Bujumbura\";s:12:\"Africa/Cairo\";s:12:\"Africa/Cairo\";s:17:\"Africa/Casablanca\";s:17:\"Africa/Casablanca\";s:12:\"Africa/Ceuta\";s:12:\"Africa/Ceuta\";s:14:\"Africa/Conakry\";s:14:\"Africa/Conakry\";s:12:\"Africa/Dakar\";s:12:\"Africa/Dakar\";s:20:\"Africa/Dar_es_Salaam\";s:20:\"Africa/Dar_es_Salaam\";s:15:\"Africa/Djibouti\";s:15:\"Africa/Djibouti\";s:13:\"Africa/Douala\";s:13:\"Africa/Douala\";s:15:\"Africa/El_Aaiun\";s:15:\"Africa/El_Aaiun\";s:15:\"Africa/Freetown\";s:15:\"Africa/Freetown\";s:15:\"Africa/Gaborone\";s:15:\"Africa/Gaborone\";s:13:\"Africa/Harare\";s:13:\"Africa/Harare\";s:19:\"Africa/Johannesburg\";s:19:\"Africa/Johannesburg\";s:11:\"Africa/Juba\";s:11:\"Africa/Juba\";s:14:\"Africa/Kampala\";s:14:\"Africa/Kampala\";s:15:\"Africa/Khartoum\";s:15:\"Africa/Khartoum\";s:13:\"Africa/Kigali\";s:13:\"Africa/Kigali\";s:15:\"Africa/Kinshasa\";s:15:\"Africa/Kinshasa\";s:12:\"Africa/Lagos\";s:12:\"Africa/Lagos\";s:17:\"Africa/Libreville\";s:17:\"Africa/Libreville\";s:11:\"Africa/Lome\";s:11:\"Africa/Lome\";s:13:\"Africa/Luanda\";s:13:\"Africa/Luanda\";s:17:\"Africa/Lubumbashi\";s:17:\"Africa/Lubumbashi\";s:13:\"Africa/Lusaka\";s:13:\"Africa/Lusaka\";s:13:\"Africa/Malabo\";s:13:\"Africa/Malabo\";s:13:\"Africa/Maputo\";s:13:\"Africa/Maputo\";s:13:\"Africa/Maseru\";s:13:\"Africa/Maseru\";s:14:\"Africa/Mbabane\";s:14:\"Africa/Mbabane\";s:16:\"Africa/Mogadishu\";s:16:\"Africa/Mogadishu\";s:15:\"Africa/Monrovia\";s:15:\"Africa/Monrovia\";s:14:\"Africa/Nairobi\";s:14:\"Africa/Nairobi\";s:15:\"Africa/Ndjamena\";s:15:\"Africa/Ndjamena\";s:13:\"Africa/Niamey\";s:13:\"Africa/Niamey\";s:17:\"Africa/Nouakchott\";s:17:\"Africa/Nouakchott\";s:18:\"Africa/Ouagadougou\";s:18:\"Africa/Ouagadougou\";s:17:\"Africa/Porto-Novo\";s:17:\"Africa/Porto-Novo\";s:15:\"Africa/Sao_Tome\";s:15:\"Africa/Sao_Tome\";s:14:\"Africa/Tripoli\";s:14:\"Africa/Tripoli\";s:12:\"Africa/Tunis\";s:12:\"Africa/Tunis\";s:15:\"Africa/Windhoek\";s:15:\"Africa/Windhoek\";s:12:\"America/Adak\";s:12:\"America/Adak\";s:17:\"America/Anchorage\";s:17:\"America/Anchorage\";s:16:\"America/Anguilla\";s:16:\"America/Anguilla\";s:15:\"America/Antigua\";s:15:\"America/Antigua\";s:17:\"America/Araguaina\";s:17:\"America/Araguaina\";s:30:\"America/Argentina/Buenos_Aires\";s:30:\"America/Argentina/Buenos_Aires\";s:27:\"America/Argentina/Catamarca\";s:27:\"America/Argentina/Catamarca\";s:25:\"America/Argentina/Cordoba\";s:25:\"America/Argentina/Cordoba\";s:23:\"America/Argentina/Jujuy\";s:23:\"America/Argentina/Jujuy\";s:26:\"America/Argentina/La_Rioja\";s:26:\"America/Argentina/La_Rioja\";s:25:\"America/Argentina/Mendoza\";s:25:\"America/Argentina/Mendoza\";s:30:\"America/Argentina/Rio_Gallegos\";s:30:\"America/Argentina/Rio_Gallegos\";s:23:\"America/Argentina/Salta\";s:23:\"America/Argentina/Salta\";s:26:\"America/Argentina/San_Juan\";s:26:\"America/Argentina/San_Juan\";s:26:\"America/Argentina/San_Luis\";s:26:\"America/Argentina/San_Luis\";s:25:\"America/Argentina/Tucuman\";s:25:\"America/Argentina/Tucuman\";s:25:\"America/Argentina/Ushuaia\";s:25:\"America/Argentina/Ushuaia\";s:13:\"America/Aruba\";s:13:\"America/Aruba\";s:16:\"America/Asuncion\";s:16:\"America/Asuncion\";s:16:\"America/Atikokan\";s:16:\"America/Atikokan\";s:13:\"America/Bahia\";s:13:\"America/Bahia\";s:22:\"America/Bahia_Banderas\";s:22:\"America/Bahia_Banderas\";s:16:\"America/Barbados\";s:16:\"America/Barbados\";s:13:\"America/Belem\";s:13:\"America/Belem\";s:14:\"America/Belize\";s:14:\"America/Belize\";s:20:\"America/Blanc-Sablon\";s:20:\"America/Blanc-Sablon\";s:17:\"America/Boa_Vista\";s:17:\"America/Boa_Vista\";s:14:\"America/Bogota\";s:14:\"America/Bogota\";s:13:\"America/Boise\";s:13:\"America/Boise\";s:21:\"America/Cambridge_Bay\";s:21:\"America/Cambridge_Bay\";s:20:\"America/Campo_Grande\";s:20:\"America/Campo_Grande\";s:14:\"America/Cancun\";s:14:\"America/Cancun\";s:15:\"America/Caracas\";s:15:\"America/Caracas\";s:15:\"America/Cayenne\";s:15:\"America/Cayenne\";s:14:\"America/Cayman\";s:14:\"America/Cayman\";s:15:\"America/Chicago\";s:15:\"America/Chicago\";s:17:\"America/Chihuahua\";s:17:\"America/Chihuahua\";s:18:\"America/Costa_Rica\";s:18:\"America/Costa_Rica\";s:15:\"America/Creston\";s:15:\"America/Creston\";s:14:\"America/Cuiaba\";s:14:\"America/Cuiaba\";s:15:\"America/Curacao\";s:15:\"America/Curacao\";s:20:\"America/Danmarkshavn\";s:20:\"America/Danmarkshavn\";s:14:\"America/Dawson\";s:14:\"America/Dawson\";s:20:\"America/Dawson_Creek\";s:20:\"America/Dawson_Creek\";s:14:\"America/Denver\";s:14:\"America/Denver\";s:15:\"America/Detroit\";s:15:\"America/Detroit\";s:16:\"America/Dominica\";s:16:\"America/Dominica\";s:16:\"America/Edmonton\";s:16:\"America/Edmonton\";s:16:\"America/Eirunepe\";s:16:\"America/Eirunepe\";s:19:\"America/El_Salvador\";s:19:\"America/El_Salvador\";s:17:\"America/Fortaleza\";s:17:\"America/Fortaleza\";s:17:\"America/Glace_Bay\";s:17:\"America/Glace_Bay\";s:15:\"America/Godthab\";s:15:\"America/Godthab\";s:17:\"America/Goose_Bay\";s:17:\"America/Goose_Bay\";s:18:\"America/Grand_Turk\";s:18:\"America/Grand_Turk\";s:15:\"America/Grenada\";s:15:\"America/Grenada\";s:18:\"America/Guadeloupe\";s:18:\"America/Guadeloupe\";s:17:\"America/Guatemala\";s:17:\"America/Guatemala\";s:17:\"America/Guayaquil\";s:17:\"America/Guayaquil\";s:14:\"America/Guyana\";s:14:\"America/Guyana\";s:15:\"America/Halifax\";s:15:\"America/Halifax\";s:14:\"America/Havana\";s:14:\"America/Havana\";s:18:\"America/Hermosillo\";s:18:\"America/Hermosillo\";s:28:\"America/Indiana/Indianapolis\";s:28:\"America/Indiana/Indianapolis\";s:20:\"America/Indiana/Knox\";s:20:\"America/Indiana/Knox\";s:23:\"America/Indiana/Marengo\";s:23:\"America/Indiana/Marengo\";s:26:\"America/Indiana/Petersburg\";s:26:\"America/Indiana/Petersburg\";s:25:\"America/Indiana/Tell_City\";s:25:\"America/Indiana/Tell_City\";s:21:\"America/Indiana/Vevay\";s:21:\"America/Indiana/Vevay\";s:25:\"America/Indiana/Vincennes\";s:25:\"America/Indiana/Vincennes\";s:23:\"America/Indiana/Winamac\";s:23:\"America/Indiana/Winamac\";s:14:\"America/Inuvik\";s:14:\"America/Inuvik\";s:15:\"America/Iqaluit\";s:15:\"America/Iqaluit\";s:15:\"America/Jamaica\";s:15:\"America/Jamaica\";s:14:\"America/Juneau\";s:14:\"America/Juneau\";s:27:\"America/Kentucky/Louisville\";s:27:\"America/Kentucky/Louisville\";s:27:\"America/Kentucky/Monticello\";s:27:\"America/Kentucky/Monticello\";s:18:\"America/Kralendijk\";s:18:\"America/Kralendijk\";s:14:\"America/La_Paz\";s:14:\"America/La_Paz\";s:12:\"America/Lima\";s:12:\"America/Lima\";s:19:\"America/Los_Angeles\";s:19:\"America/Los_Angeles\";s:21:\"America/Lower_Princes\";s:21:\"America/Lower_Princes\";s:14:\"America/Maceio\";s:14:\"America/Maceio\";s:15:\"America/Managua\";s:15:\"America/Managua\";s:14:\"America/Manaus\";s:14:\"America/Manaus\";s:15:\"America/Marigot\";s:15:\"America/Marigot\";s:18:\"America/Martinique\";s:18:\"America/Martinique\";s:17:\"America/Matamoros\";s:17:\"America/Matamoros\";s:16:\"America/Mazatlan\";s:16:\"America/Mazatlan\";s:17:\"America/Menominee\";s:17:\"America/Menominee\";s:14:\"America/Merida\";s:14:\"America/Merida\";s:18:\"America/Metlakatla\";s:18:\"America/Metlakatla\";s:19:\"America/Mexico_City\";s:19:\"America/Mexico_City\";s:16:\"America/Miquelon\";s:16:\"America/Miquelon\";s:15:\"America/Moncton\";s:15:\"America/Moncton\";s:17:\"America/Monterrey\";s:17:\"America/Monterrey\";s:18:\"America/Montevideo\";s:18:\"America/Montevideo\";s:18:\"America/Montserrat\";s:18:\"America/Montserrat\";s:14:\"America/Nassau\";s:14:\"America/Nassau\";s:16:\"America/New_York\";s:16:\"America/New_York\";s:15:\"America/Nipigon\";s:15:\"America/Nipigon\";s:12:\"America/Nome\";s:12:\"America/Nome\";s:15:\"America/Noronha\";s:15:\"America/Noronha\";s:27:\"America/North_Dakota/Beulah\";s:27:\"America/North_Dakota/Beulah\";s:27:\"America/North_Dakota/Center\";s:27:\"America/North_Dakota/Center\";s:30:\"America/North_Dakota/New_Salem\";s:30:\"America/North_Dakota/New_Salem\";s:15:\"America/Ojinaga\";s:15:\"America/Ojinaga\";s:14:\"America/Panama\";s:14:\"America/Panama\";s:19:\"America/Pangnirtung\";s:19:\"America/Pangnirtung\";s:18:\"America/Paramaribo\";s:18:\"America/Paramaribo\";s:15:\"America/Phoenix\";s:15:\"America/Phoenix\";s:22:\"America/Port-au-Prince\";s:22:\"America/Port-au-Prince\";s:21:\"America/Port_of_Spain\";s:21:\"America/Port_of_Spain\";s:19:\"America/Porto_Velho\";s:19:\"America/Porto_Velho\";s:19:\"America/Puerto_Rico\";s:19:\"America/Puerto_Rico\";s:19:\"America/Rainy_River\";s:19:\"America/Rainy_River\";s:20:\"America/Rankin_Inlet\";s:20:\"America/Rankin_Inlet\";s:14:\"America/Recife\";s:14:\"America/Recife\";s:14:\"America/Regina\";s:14:\"America/Regina\";s:16:\"America/Resolute\";s:16:\"America/Resolute\";s:18:\"America/Rio_Branco\";s:18:\"America/Rio_Branco\";s:20:\"America/Santa_Isabel\";s:20:\"America/Santa_Isabel\";s:16:\"America/Santarem\";s:16:\"America/Santarem\";s:16:\"America/Santiago\";s:16:\"America/Santiago\";s:21:\"America/Santo_Domingo\";s:21:\"America/Santo_Domingo\";s:17:\"America/Sao_Paulo\";s:17:\"America/Sao_Paulo\";s:20:\"America/Scoresbysund\";s:20:\"America/Scoresbysund\";s:13:\"America/Sitka\";s:13:\"America/Sitka\";s:21:\"America/St_Barthelemy\";s:21:\"America/St_Barthelemy\";s:16:\"America/St_Johns\";s:16:\"America/St_Johns\";s:16:\"America/St_Kitts\";s:16:\"America/St_Kitts\";s:16:\"America/St_Lucia\";s:16:\"America/St_Lucia\";s:17:\"America/St_Thomas\";s:17:\"America/St_Thomas\";s:18:\"America/St_Vincent\";s:18:\"America/St_Vincent\";s:21:\"America/Swift_Current\";s:21:\"America/Swift_Current\";s:19:\"America/Tegucigalpa\";s:19:\"America/Tegucigalpa\";s:13:\"America/Thule\";s:13:\"America/Thule\";s:19:\"America/Thunder_Bay\";s:19:\"America/Thunder_Bay\";s:15:\"America/Tijuana\";s:15:\"America/Tijuana\";s:15:\"America/Toronto\";s:15:\"America/Toronto\";s:15:\"America/Tortola\";s:15:\"America/Tortola\";s:17:\"America/Vancouver\";s:17:\"America/Vancouver\";s:18:\"America/Whitehorse\";s:18:\"America/Whitehorse\";s:16:\"America/Winnipeg\";s:16:\"America/Winnipeg\";s:15:\"America/Yakutat\";s:15:\"America/Yakutat\";s:19:\"America/Yellowknife\";s:19:\"America/Yellowknife\";s:16:\"Antarctica/Casey\";s:16:\"Antarctica/Casey\";s:16:\"Antarctica/Davis\";s:16:\"Antarctica/Davis\";s:25:\"Antarctica/DumontDUrville\";s:25:\"Antarctica/DumontDUrville\";s:20:\"Antarctica/Macquarie\";s:20:\"Antarctica/Macquarie\";s:17:\"Antarctica/Mawson\";s:17:\"Antarctica/Mawson\";s:18:\"Antarctica/McMurdo\";s:18:\"Antarctica/McMurdo\";s:17:\"Antarctica/Palmer\";s:17:\"Antarctica/Palmer\";s:18:\"Antarctica/Rothera\";s:18:\"Antarctica/Rothera\";s:16:\"Antarctica/Syowa\";s:16:\"Antarctica/Syowa\";s:16:\"Antarctica/Troll\";s:16:\"Antarctica/Troll\";s:17:\"Antarctica/Vostok\";s:17:\"Antarctica/Vostok\";s:19:\"Arctic/Longyearbyen\";s:19:\"Arctic/Longyearbyen\";s:9:\"Asia/Aden\";s:9:\"Asia/Aden\";s:11:\"Asia/Almaty\";s:11:\"Asia/Almaty\";s:10:\"Asia/Amman\";s:10:\"Asia/Amman\";s:11:\"Asia/Anadyr\";s:11:\"Asia/Anadyr\";s:10:\"Asia/Aqtau\";s:10:\"Asia/Aqtau\";s:11:\"Asia/Aqtobe\";s:11:\"Asia/Aqtobe\";s:13:\"Asia/Ashgabat\";s:13:\"Asia/Ashgabat\";s:12:\"Asia/Baghdad\";s:12:\"Asia/Baghdad\";s:12:\"Asia/Bahrain\";s:12:\"Asia/Bahrain\";s:9:\"Asia/Baku\";s:9:\"Asia/Baku\";s:12:\"Asia/Bangkok\";s:12:\"Asia/Bangkok\";s:11:\"Asia/Beirut\";s:11:\"Asia/Beirut\";s:12:\"Asia/Bishkek\";s:12:\"Asia/Bishkek\";s:11:\"Asia/Brunei\";s:11:\"Asia/Brunei\";s:10:\"Asia/Chita\";s:10:\"Asia/Chita\";s:15:\"Asia/Choibalsan\";s:15:\"Asia/Choibalsan\";s:12:\"Asia/Colombo\";s:12:\"Asia/Colombo\";s:13:\"Asia/Damascus\";s:13:\"Asia/Damascus\";s:10:\"Asia/Dhaka\";s:10:\"Asia/Dhaka\";s:9:\"Asia/Dili\";s:9:\"Asia/Dili\";s:10:\"Asia/Dubai\";s:10:\"Asia/Dubai\";s:13:\"Asia/Dushanbe\";s:13:\"Asia/Dushanbe\";s:9:\"Asia/Gaza\";s:9:\"Asia/Gaza\";s:11:\"Asia/Hebron\";s:11:\"Asia/Hebron\";s:16:\"Asia/Ho_Chi_Minh\";s:16:\"Asia/Ho_Chi_Minh\";s:14:\"Asia/Hong_Kong\";s:14:\"Asia/Hong_Kong\";s:9:\"Asia/Hovd\";s:9:\"Asia/Hovd\";s:12:\"Asia/Irkutsk\";s:12:\"Asia/Irkutsk\";s:12:\"Asia/Jakarta\";s:12:\"Asia/Jakarta\";s:13:\"Asia/Jayapura\";s:13:\"Asia/Jayapura\";s:14:\"Asia/Jerusalem\";s:14:\"Asia/Jerusalem\";s:10:\"Asia/Kabul\";s:10:\"Asia/Kabul\";s:14:\"Asia/Kamchatka\";s:14:\"Asia/Kamchatka\";s:12:\"Asia/Karachi\";s:12:\"Asia/Karachi\";s:14:\"Asia/Kathmandu\";s:14:\"Asia/Kathmandu\";s:13:\"Asia/Khandyga\";s:13:\"Asia/Khandyga\";s:12:\"Asia/Kolkata\";s:12:\"Asia/Kolkata\";s:16:\"Asia/Krasnoyarsk\";s:16:\"Asia/Krasnoyarsk\";s:17:\"Asia/Kuala_Lumpur\";s:17:\"Asia/Kuala_Lumpur\";s:12:\"Asia/Kuching\";s:12:\"Asia/Kuching\";s:11:\"Asia/Kuwait\";s:11:\"Asia/Kuwait\";s:10:\"Asia/Macau\";s:10:\"Asia/Macau\";s:12:\"Asia/Magadan\";s:12:\"Asia/Magadan\";s:13:\"Asia/Makassar\";s:13:\"Asia/Makassar\";s:11:\"Asia/Manila\";s:11:\"Asia/Manila\";s:11:\"Asia/Muscat\";s:11:\"Asia/Muscat\";s:12:\"Asia/Nicosia\";s:12:\"Asia/Nicosia\";s:17:\"Asia/Novokuznetsk\";s:17:\"Asia/Novokuznetsk\";s:16:\"Asia/Novosibirsk\";s:16:\"Asia/Novosibirsk\";s:9:\"Asia/Omsk\";s:9:\"Asia/Omsk\";s:9:\"Asia/Oral\";s:9:\"Asia/Oral\";s:15:\"Asia/Phnom_Penh\";s:15:\"Asia/Phnom_Penh\";s:14:\"Asia/Pontianak\";s:14:\"Asia/Pontianak\";s:14:\"Asia/Pyongyang\";s:14:\"Asia/Pyongyang\";s:10:\"Asia/Qatar\";s:10:\"Asia/Qatar\";s:14:\"Asia/Qyzylorda\";s:14:\"Asia/Qyzylorda\";s:12:\"Asia/Rangoon\";s:12:\"Asia/Rangoon\";s:11:\"Asia/Riyadh\";s:11:\"Asia/Riyadh\";s:13:\"Asia/Sakhalin\";s:13:\"Asia/Sakhalin\";s:14:\"Asia/Samarkand\";s:14:\"Asia/Samarkand\";s:10:\"Asia/Seoul\";s:10:\"Asia/Seoul\";s:13:\"Asia/Shanghai\";s:13:\"Asia/Shanghai\";s:14:\"Asia/Singapore\";s:14:\"Asia/Singapore\";s:18:\"Asia/Srednekolymsk\";s:18:\"Asia/Srednekolymsk\";s:11:\"Asia/Taipei\";s:11:\"Asia/Taipei\";s:13:\"Asia/Tashkent\";s:13:\"Asia/Tashkent\";s:12:\"Asia/Tbilisi\";s:12:\"Asia/Tbilisi\";s:11:\"Asia/Tehran\";s:11:\"Asia/Tehran\";s:12:\"Asia/Thimphu\";s:12:\"Asia/Thimphu\";s:10:\"Asia/Tokyo\";s:10:\"Asia/Tokyo\";s:16:\"Asia/Ulaanbaatar\";s:16:\"Asia/Ulaanbaatar\";s:11:\"Asia/Urumqi\";s:11:\"Asia/Urumqi\";s:13:\"Asia/Ust-Nera\";s:13:\"Asia/Ust-Nera\";s:14:\"Asia/Vientiane\";s:14:\"Asia/Vientiane\";s:16:\"Asia/Vladivostok\";s:16:\"Asia/Vladivostok\";s:12:\"Asia/Yakutsk\";s:12:\"Asia/Yakutsk\";s:18:\"Asia/Yekaterinburg\";s:18:\"Asia/Yekaterinburg\";s:12:\"Asia/Yerevan\";s:12:\"Asia/Yerevan\";s:15:\"Atlantic/Azores\";s:15:\"Atlantic/Azores\";s:16:\"Atlantic/Bermuda\";s:16:\"Atlantic/Bermuda\";s:15:\"Atlantic/Canary\";s:15:\"Atlantic/Canary\";s:19:\"Atlantic/Cape_Verde\";s:19:\"Atlantic/Cape_Verde\";s:14:\"Atlantic/Faroe\";s:14:\"Atlantic/Faroe\";s:16:\"Atlantic/Madeira\";s:16:\"Atlantic/Madeira\";s:18:\"Atlantic/Reykjavik\";s:18:\"Atlantic/Reykjavik\";s:22:\"Atlantic/South_Georgia\";s:22:\"Atlantic/South_Georgia\";s:18:\"Atlantic/St_Helena\";s:18:\"Atlantic/St_Helena\";s:16:\"Atlantic/Stanley\";s:16:\"Atlantic/Stanley\";s:18:\"Australia/Adelaide\";s:18:\"Australia/Adelaide\";s:18:\"Australia/Brisbane\";s:18:\"Australia/Brisbane\";s:21:\"Australia/Broken_Hill\";s:21:\"Australia/Broken_Hill\";s:16:\"Australia/Currie\";s:16:\"Australia/Currie\";s:16:\"Australia/Darwin\";s:16:\"Australia/Darwin\";s:15:\"Australia/Eucla\";s:15:\"Australia/Eucla\";s:16:\"Australia/Hobart\";s:16:\"Australia/Hobart\";s:18:\"Australia/Lindeman\";s:18:\"Australia/Lindeman\";s:19:\"Australia/Lord_Howe\";s:19:\"Australia/Lord_Howe\";s:19:\"Australia/Melbourne\";s:19:\"Australia/Melbourne\";s:15:\"Australia/Perth\";s:15:\"Australia/Perth\";s:16:\"Australia/Sydney\";s:16:\"Australia/Sydney\";s:16:\"Europe/Amsterdam\";s:16:\"Europe/Amsterdam\";s:14:\"Europe/Andorra\";s:14:\"Europe/Andorra\";s:13:\"Europe/Athens\";s:13:\"Europe/Athens\";s:15:\"Europe/Belgrade\";s:15:\"Europe/Belgrade\";s:13:\"Europe/Berlin\";s:13:\"Europe/Berlin\";s:17:\"Europe/Bratislava\";s:17:\"Europe/Bratislava\";s:15:\"Europe/Brussels\";s:15:\"Europe/Brussels\";s:16:\"Europe/Bucharest\";s:16:\"Europe/Bucharest\";s:15:\"Europe/Budapest\";s:15:\"Europe/Budapest\";s:15:\"Europe/Busingen\";s:15:\"Europe/Busingen\";s:15:\"Europe/Chisinau\";s:15:\"Europe/Chisinau\";s:17:\"Europe/Copenhagen\";s:17:\"Europe/Copenhagen\";s:13:\"Europe/Dublin\";s:13:\"Europe/Dublin\";s:16:\"Europe/Gibraltar\";s:16:\"Europe/Gibraltar\";s:15:\"Europe/Guernsey\";s:15:\"Europe/Guernsey\";s:15:\"Europe/Helsinki\";s:15:\"Europe/Helsinki\";s:18:\"Europe/Isle_of_Man\";s:18:\"Europe/Isle_of_Man\";s:15:\"Europe/Istanbul\";s:15:\"Europe/Istanbul\";s:13:\"Europe/Jersey\";s:13:\"Europe/Jersey\";s:18:\"Europe/Kaliningrad\";s:18:\"Europe/Kaliningrad\";s:11:\"Europe/Kiev\";s:11:\"Europe/Kiev\";s:13:\"Europe/Lisbon\";s:13:\"Europe/Lisbon\";s:16:\"Europe/Ljubljana\";s:16:\"Europe/Ljubljana\";s:13:\"Europe/London\";s:13:\"Europe/London\";s:17:\"Europe/Luxembourg\";s:17:\"Europe/Luxembourg\";s:13:\"Europe/Madrid\";s:13:\"Europe/Madrid\";s:12:\"Europe/Malta\";s:12:\"Europe/Malta\";s:16:\"Europe/Mariehamn\";s:16:\"Europe/Mariehamn\";s:12:\"Europe/Minsk\";s:12:\"Europe/Minsk\";s:13:\"Europe/Monaco\";s:13:\"Europe/Monaco\";s:13:\"Europe/Moscow\";s:13:\"Europe/Moscow\";s:11:\"Europe/Oslo\";s:11:\"Europe/Oslo\";s:12:\"Europe/Paris\";s:12:\"Europe/Paris\";s:16:\"Europe/Podgorica\";s:16:\"Europe/Podgorica\";s:13:\"Europe/Prague\";s:13:\"Europe/Prague\";s:11:\"Europe/Riga\";s:11:\"Europe/Riga\";s:11:\"Europe/Rome\";s:11:\"Europe/Rome\";s:13:\"Europe/Samara\";s:13:\"Europe/Samara\";s:17:\"Europe/San_Marino\";s:17:\"Europe/San_Marino\";s:15:\"Europe/Sarajevo\";s:15:\"Europe/Sarajevo\";s:17:\"Europe/Simferopol\";s:17:\"Europe/Simferopol\";s:13:\"Europe/Skopje\";s:13:\"Europe/Skopje\";s:12:\"Europe/Sofia\";s:12:\"Europe/Sofia\";s:16:\"Europe/Stockholm\";s:16:\"Europe/Stockholm\";s:14:\"Europe/Tallinn\";s:14:\"Europe/Tallinn\";s:13:\"Europe/Tirane\";s:13:\"Europe/Tirane\";s:15:\"Europe/Uzhgorod\";s:15:\"Europe/Uzhgorod\";s:12:\"Europe/Vaduz\";s:12:\"Europe/Vaduz\";s:14:\"Europe/Vatican\";s:14:\"Europe/Vatican\";s:13:\"Europe/Vienna\";s:13:\"Europe/Vienna\";s:14:\"Europe/Vilnius\";s:14:\"Europe/Vilnius\";s:16:\"Europe/Volgograd\";s:16:\"Europe/Volgograd\";s:13:\"Europe/Warsaw\";s:13:\"Europe/Warsaw\";s:13:\"Europe/Zagreb\";s:13:\"Europe/Zagreb\";s:17:\"Europe/Zaporozhye\";s:17:\"Europe/Zaporozhye\";s:13:\"Europe/Zurich\";s:13:\"Europe/Zurich\";s:19:\"Indian/Antananarivo\";s:19:\"Indian/Antananarivo\";s:13:\"Indian/Chagos\";s:13:\"Indian/Chagos\";s:16:\"Indian/Christmas\";s:16:\"Indian/Christmas\";s:12:\"Indian/Cocos\";s:12:\"Indian/Cocos\";s:13:\"Indian/Comoro\";s:13:\"Indian/Comoro\";s:16:\"Indian/Kerguelen\";s:16:\"Indian/Kerguelen\";s:11:\"Indian/Mahe\";s:11:\"Indian/Mahe\";s:15:\"Indian/Maldives\";s:15:\"Indian/Maldives\";s:16:\"Indian/Mauritius\";s:16:\"Indian/Mauritius\";s:14:\"Indian/Mayotte\";s:14:\"Indian/Mayotte\";s:14:\"Indian/Reunion\";s:14:\"Indian/Reunion\";s:12:\"Pacific/Apia\";s:12:\"Pacific/Apia\";s:16:\"Pacific/Auckland\";s:16:\"Pacific/Auckland\";s:20:\"Pacific/Bougainville\";s:20:\"Pacific/Bougainville\";s:15:\"Pacific/Chatham\";s:15:\"Pacific/Chatham\";s:13:\"Pacific/Chuuk\";s:13:\"Pacific/Chuuk\";s:14:\"Pacific/Easter\";s:14:\"Pacific/Easter\";s:13:\"Pacific/Efate\";s:13:\"Pacific/Efate\";s:17:\"Pacific/Enderbury\";s:17:\"Pacific/Enderbury\";s:15:\"Pacific/Fakaofo\";s:15:\"Pacific/Fakaofo\";s:12:\"Pacific/Fiji\";s:12:\"Pacific/Fiji\";s:16:\"Pacific/Funafuti\";s:16:\"Pacific/Funafuti\";s:17:\"Pacific/Galapagos\";s:17:\"Pacific/Galapagos\";s:15:\"Pacific/Gambier\";s:15:\"Pacific/Gambier\";s:19:\"Pacific/Guadalcanal\";s:19:\"Pacific/Guadalcanal\";s:12:\"Pacific/Guam\";s:12:\"Pacific/Guam\";s:16:\"Pacific/Honolulu\";s:16:\"Pacific/Honolulu\";s:16:\"Pacific/Johnston\";s:16:\"Pacific/Johnston\";s:18:\"Pacific/Kiritimati\";s:18:\"Pacific/Kiritimati\";s:14:\"Pacific/Kosrae\";s:14:\"Pacific/Kosrae\";s:17:\"Pacific/Kwajalein\";s:17:\"Pacific/Kwajalein\";s:14:\"Pacific/Majuro\";s:14:\"Pacific/Majuro\";s:17:\"Pacific/Marquesas\";s:17:\"Pacific/Marquesas\";s:14:\"Pacific/Midway\";s:14:\"Pacific/Midway\";s:13:\"Pacific/Nauru\";s:13:\"Pacific/Nauru\";s:12:\"Pacific/Niue\";s:12:\"Pacific/Niue\";s:15:\"Pacific/Norfolk\";s:15:\"Pacific/Norfolk\";s:14:\"Pacific/Noumea\";s:14:\"Pacific/Noumea\";s:17:\"Pacific/Pago_Pago\";s:17:\"Pacific/Pago_Pago\";s:13:\"Pacific/Palau\";s:13:\"Pacific/Palau\";s:16:\"Pacific/Pitcairn\";s:16:\"Pacific/Pitcairn\";s:15:\"Pacific/Pohnpei\";s:15:\"Pacific/Pohnpei\";s:20:\"Pacific/Port_Moresby\";s:20:\"Pacific/Port_Moresby\";s:17:\"Pacific/Rarotonga\";s:17:\"Pacific/Rarotonga\";s:14:\"Pacific/Saipan\";s:14:\"Pacific/Saipan\";s:14:\"Pacific/Tahiti\";s:14:\"Pacific/Tahiti\";s:14:\"Pacific/Tarawa\";s:14:\"Pacific/Tarawa\";s:17:\"Pacific/Tongatapu\";s:17:\"Pacific/Tongatapu\";s:12:\"Pacific/Wake\";s:12:\"Pacific/Wake\";s:14:\"Pacific/Wallis\";s:14:\"Pacific/Wallis\";s:3:\"UTC\";s:3:\"UTC\";}',0,1474359341,1),('entity_info:es','a:8:{s:7:\"comment\";a:25:{s:5:\"label\";s:10:\"Comentario\";s:10:\"base table\";s:7:\"comment\";s:12:\"uri callback\";s:11:\"comment_uri\";s:9:\"fieldable\";b:1;s:16:\"controller class\";s:17:\"CommentController\";s:11:\"entity keys\";a:6:{s:2:\"id\";s:3:\"cid\";s:6:\"bundle\";s:9:\"node_type\";s:5:\"label\";s:7:\"subject\";s:8:\"language\";s:8:\"language\";s:8:\"revision\";s:0:\"\";s:4:\"uuid\";s:4:\"uuid\";}s:7:\"bundles\";a:7:{s:21:\"comment_node_activity\";a:4:{s:5:\"label\";s:24:\"comentario de Actividade\";s:11:\"node bundle\";s:8:\"activity\";s:5:\"admin\";a:4:{s:4:\"path\";s:55:\"admin/structure/types/manage/%comment_node_type/comment\";s:15:\"bundle argument\";i:4;s:9:\"real path\";s:45:\"admin/structure/types/manage/activity/comment\";s:16:\"access arguments\";a:1:{i:0;s:24:\"administer content types\";}}s:11:\"rdf_mapping\";a:8:{s:7:\"rdftype\";a:2:{i:0;s:9:\"sioc:Post\";i:1;s:13:\"sioct:Comment\";}s:5:\"title\";a:1:{s:10:\"predicates\";a:1:{i:0;s:8:\"dc:title\";}}s:7:\"created\";a:3:{s:10:\"predicates\";a:2:{i:0;s:7:\"dc:date\";i:1;s:10:\"dc:created\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:7:\"changed\";a:3:{s:10:\"predicates\";a:1:{i:0;s:11:\"dc:modified\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:12:\"comment_body\";a:1:{s:10:\"predicates\";a:1:{i:0;s:15:\"content:encoded\";}}s:3:\"pid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:13:\"sioc:reply_of\";}s:4:\"type\";s:3:\"rel\";}s:3:\"uid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:has_creator\";}s:4:\"type\";s:3:\"rel\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:1:{i:0;s:9:\"foaf:name\";}}}}s:20:\"comment_node_archive\";a:4:{s:5:\"label\";s:21:\"comentario de Arquivo\";s:11:\"node bundle\";s:7:\"archive\";s:5:\"admin\";a:4:{s:4:\"path\";s:55:\"admin/structure/types/manage/%comment_node_type/comment\";s:15:\"bundle argument\";i:4;s:9:\"real path\";s:44:\"admin/structure/types/manage/archive/comment\";s:16:\"access arguments\";a:1:{i:0;s:24:\"administer content types\";}}s:11:\"rdf_mapping\";a:8:{s:7:\"rdftype\";a:2:{i:0;s:9:\"sioc:Post\";i:1;s:13:\"sioct:Comment\";}s:5:\"title\";a:1:{s:10:\"predicates\";a:1:{i:0;s:8:\"dc:title\";}}s:7:\"created\";a:3:{s:10:\"predicates\";a:2:{i:0;s:7:\"dc:date\";i:1;s:10:\"dc:created\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:7:\"changed\";a:3:{s:10:\"predicates\";a:1:{i:0;s:11:\"dc:modified\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:12:\"comment_body\";a:1:{s:10:\"predicates\";a:1:{i:0;s:15:\"content:encoded\";}}s:3:\"pid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:13:\"sioc:reply_of\";}s:4:\"type\";s:3:\"rel\";}s:3:\"uid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:has_creator\";}s:4:\"type\";s:3:\"rel\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:1:{i:0;s:9:\"foaf:name\";}}}}s:19:\"comment_node_banner\";a:4:{s:5:\"label\";s:20:\"comentario de Banner\";s:11:\"node bundle\";s:6:\"banner\";s:5:\"admin\";a:4:{s:4:\"path\";s:55:\"admin/structure/types/manage/%comment_node_type/comment\";s:15:\"bundle argument\";i:4;s:9:\"real path\";s:43:\"admin/structure/types/manage/banner/comment\";s:16:\"access arguments\";a:1:{i:0;s:24:\"administer content types\";}}s:11:\"rdf_mapping\";a:8:{s:7:\"rdftype\";a:2:{i:0;s:9:\"sioc:Post\";i:1;s:13:\"sioct:Comment\";}s:5:\"title\";a:1:{s:10:\"predicates\";a:1:{i:0;s:8:\"dc:title\";}}s:7:\"created\";a:3:{s:10:\"predicates\";a:2:{i:0;s:7:\"dc:date\";i:1;s:10:\"dc:created\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:7:\"changed\";a:3:{s:10:\"predicates\";a:1:{i:0;s:11:\"dc:modified\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:12:\"comment_body\";a:1:{s:10:\"predicates\";a:1:{i:0;s:15:\"content:encoded\";}}s:3:\"pid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:13:\"sioc:reply_of\";}s:4:\"type\";s:3:\"rel\";}s:3:\"uid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:has_creator\";}s:4:\"type\";s:3:\"rel\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:1:{i:0;s:9:\"foaf:name\";}}}}s:23:\"comment_node_diary_item\";a:4:{s:5:\"label\";s:31:\"comentario de Entrada da Axenda\";s:11:\"node bundle\";s:10:\"diary_item\";s:5:\"admin\";a:4:{s:4:\"path\";s:55:\"admin/structure/types/manage/%comment_node_type/comment\";s:15:\"bundle argument\";i:4;s:9:\"real path\";s:47:\"admin/structure/types/manage/diary-item/comment\";s:16:\"access arguments\";a:1:{i:0;s:24:\"administer content types\";}}s:11:\"rdf_mapping\";a:8:{s:7:\"rdftype\";a:2:{i:0;s:9:\"sioc:Post\";i:1;s:13:\"sioct:Comment\";}s:5:\"title\";a:1:{s:10:\"predicates\";a:1:{i:0;s:8:\"dc:title\";}}s:7:\"created\";a:3:{s:10:\"predicates\";a:2:{i:0;s:7:\"dc:date\";i:1;s:10:\"dc:created\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:7:\"changed\";a:3:{s:10:\"predicates\";a:1:{i:0;s:11:\"dc:modified\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:12:\"comment_body\";a:1:{s:10:\"predicates\";a:1:{i:0;s:15:\"content:encoded\";}}s:3:\"pid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:13:\"sioc:reply_of\";}s:4:\"type\";s:3:\"rel\";}s:3:\"uid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:has_creator\";}s:4:\"type\";s:3:\"rel\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:1:{i:0;s:9:\"foaf:name\";}}}}s:17:\"comment_node_home\";a:4:{s:5:\"label\";s:18:\"comentario de Home\";s:11:\"node bundle\";s:4:\"home\";s:5:\"admin\";a:4:{s:4:\"path\";s:55:\"admin/structure/types/manage/%comment_node_type/comment\";s:15:\"bundle argument\";i:4;s:9:\"real path\";s:41:\"admin/structure/types/manage/home/comment\";s:16:\"access arguments\";a:1:{i:0;s:24:\"administer content types\";}}s:11:\"rdf_mapping\";a:8:{s:7:\"rdftype\";a:2:{i:0;s:9:\"sioc:Post\";i:1;s:13:\"sioct:Comment\";}s:5:\"title\";a:1:{s:10:\"predicates\";a:1:{i:0;s:8:\"dc:title\";}}s:7:\"created\";a:3:{s:10:\"predicates\";a:2:{i:0;s:7:\"dc:date\";i:1;s:10:\"dc:created\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:7:\"changed\";a:3:{s:10:\"predicates\";a:1:{i:0;s:11:\"dc:modified\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:12:\"comment_body\";a:1:{s:10:\"predicates\";a:1:{i:0;s:15:\"content:encoded\";}}s:3:\"pid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:13:\"sioc:reply_of\";}s:4:\"type\";s:3:\"rel\";}s:3:\"uid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:has_creator\";}s:4:\"type\";s:3:\"rel\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:1:{i:0;s:9:\"foaf:name\";}}}}s:18:\"comment_node_place\";a:4:{s:5:\"label\";s:19:\"comentario de Lugar\";s:11:\"node bundle\";s:5:\"place\";s:5:\"admin\";a:4:{s:4:\"path\";s:55:\"admin/structure/types/manage/%comment_node_type/comment\";s:15:\"bundle argument\";i:4;s:9:\"real path\";s:42:\"admin/structure/types/manage/place/comment\";s:16:\"access arguments\";a:1:{i:0;s:24:\"administer content types\";}}s:11:\"rdf_mapping\";a:8:{s:7:\"rdftype\";a:2:{i:0;s:9:\"sioc:Post\";i:1;s:13:\"sioct:Comment\";}s:5:\"title\";a:1:{s:10:\"predicates\";a:1:{i:0;s:8:\"dc:title\";}}s:7:\"created\";a:3:{s:10:\"predicates\";a:2:{i:0;s:7:\"dc:date\";i:1;s:10:\"dc:created\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:7:\"changed\";a:3:{s:10:\"predicates\";a:1:{i:0;s:11:\"dc:modified\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:12:\"comment_body\";a:1:{s:10:\"predicates\";a:1:{i:0;s:15:\"content:encoded\";}}s:3:\"pid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:13:\"sioc:reply_of\";}s:4:\"type\";s:3:\"rel\";}s:3:\"uid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:has_creator\";}s:4:\"type\";s:3:\"rel\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:1:{i:0;s:9:\"foaf:name\";}}}}s:17:\"comment_node_page\";a:4:{s:5:\"label\";s:21:\"comentario de Páxina\";s:11:\"node bundle\";s:4:\"page\";s:5:\"admin\";a:4:{s:4:\"path\";s:55:\"admin/structure/types/manage/%comment_node_type/comment\";s:15:\"bundle argument\";i:4;s:9:\"real path\";s:41:\"admin/structure/types/manage/page/comment\";s:16:\"access arguments\";a:1:{i:0;s:24:\"administer content types\";}}s:11:\"rdf_mapping\";a:8:{s:7:\"rdftype\";a:2:{i:0;s:9:\"sioc:Post\";i:1;s:13:\"sioct:Comment\";}s:5:\"title\";a:1:{s:10:\"predicates\";a:1:{i:0;s:8:\"dc:title\";}}s:7:\"created\";a:3:{s:10:\"predicates\";a:2:{i:0;s:7:\"dc:date\";i:1;s:10:\"dc:created\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:7:\"changed\";a:3:{s:10:\"predicates\";a:1:{i:0;s:11:\"dc:modified\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:12:\"comment_body\";a:1:{s:10:\"predicates\";a:1:{i:0;s:15:\"content:encoded\";}}s:3:\"pid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:13:\"sioc:reply_of\";}s:4:\"type\";s:3:\"rel\";}s:3:\"uid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:has_creator\";}s:4:\"type\";s:3:\"rel\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:1:{i:0;s:9:\"foaf:name\";}}}}}s:10:\"view modes\";a:2:{s:4:\"full\";a:2:{s:5:\"label\";s:19:\"Comentario completo\";s:15:\"custom settings\";b:0;}s:5:\"token\";a:2:{s:5:\"label\";s:9:\"Comodines\";s:15:\"custom settings\";b:0;}}s:12:\"static cache\";b:0;s:11:\"field cache\";b:1;s:9:\"load hook\";s:12:\"comment_load\";s:11:\"translation\";a:1:{s:6:\"locale\";b:1;}s:22:\"base table field types\";a:15:{s:3:\"cid\";s:6:\"serial\";s:3:\"pid\";s:3:\"int\";s:3:\"nid\";s:3:\"int\";s:3:\"uid\";s:3:\"int\";s:7:\"subject\";s:7:\"varchar\";s:8:\"hostname\";s:7:\"varchar\";s:7:\"created\";s:3:\"int\";s:7:\"changed\";s:3:\"int\";s:6:\"status\";s:3:\"int\";s:6:\"thread\";s:7:\"varchar\";s:4:\"name\";s:7:\"varchar\";s:4:\"mail\";s:7:\"varchar\";s:8:\"homepage\";s:7:\"varchar\";s:8:\"language\";s:7:\"varchar\";s:4:\"uuid\";s:4:\"char\";}s:17:\"schema_fields_sql\";a:1:{s:10:\"base table\";a:15:{i:0;s:3:\"cid\";i:1;s:3:\"pid\";i:2;s:3:\"nid\";i:3;s:3:\"uid\";i:4;s:7:\"subject\";i:5;s:8:\"hostname\";i:6;s:7:\"created\";i:7;s:7:\"changed\";i:8;s:6:\"status\";i:9;s:6:\"thread\";i:10;s:4:\"name\";i:11;s:4:\"mail\";i:12;s:8:\"homepage\";i:13;s:8:\"language\";i:14;s:4:\"uuid\";}}s:10:\"token type\";s:7:\"comment\";s:12:\"plural label\";s:11:\"Comentarios\";s:11:\"description\";s:43:\"Comentario o nota que se refiere a un nodo.\";s:15:\"access callback\";s:30:\"entity_metadata_comment_access\";s:17:\"creation callback\";s:30:\"entity_metadata_create_comment\";s:13:\"save callback\";s:12:\"comment_save\";s:17:\"deletion callback\";s:14:\"comment_delete\";s:13:\"view callback\";s:28:\"entity_metadata_view_comment\";s:13:\"form callback\";s:28:\"entity_metadata_form_comment\";s:13:\"configuration\";b:0;s:4:\"uuid\";b:1;}s:16:\"i18n_translation\";a:16:{s:5:\"label\";s:23:\"Conjunto de traducción\";s:16:\"controller class\";s:28:\"I18nTranslationSetController\";s:10:\"base table\";s:20:\"i18n_translation_set\";s:9:\"fieldable\";b:0;s:11:\"entity keys\";a:4:{s:2:\"id\";s:4:\"tsid\";s:6:\"bundle\";s:4:\"type\";s:5:\"label\";s:5:\"title\";s:8:\"revision\";s:0:\"\";}s:11:\"bundle keys\";a:1:{s:6:\"bundle\";s:4:\"type\";}s:7:\"bundles\";a:2:{s:9:\"menu_link\";a:2:{s:5:\"label\";s:15:\"Enlace de menú\";s:11:\"rdf_mapping\";a:0:{}}s:13:\"taxonomy_term\";a:2:{s:5:\"label\";s:22:\"Término de taxonomía\";s:11:\"rdf_mapping\";a:0:{}}}s:12:\"static cache\";b:1;s:11:\"field cache\";b:1;s:9:\"load hook\";s:21:\"i18n_translation_load\";s:10:\"view modes\";a:0:{}s:11:\"translation\";a:0:{}s:22:\"base table field types\";a:8:{s:4:\"tsid\";s:6:\"serial\";s:5:\"title\";s:7:\"varchar\";s:4:\"type\";s:7:\"varchar\";s:6:\"bundle\";s:7:\"varchar\";s:9:\"master_id\";s:3:\"int\";s:6:\"status\";s:3:\"int\";s:7:\"created\";s:3:\"int\";s:7:\"changed\";s:3:\"int\";}s:17:\"schema_fields_sql\";a:1:{s:10:\"base table\";a:8:{i:0;s:4:\"tsid\";i:1;s:5:\"title\";i:2;s:4:\"type\";i:3;s:6:\"bundle\";i:4;s:9:\"master_id\";i:5;s:6:\"status\";i:6;s:7:\"created\";i:7;s:7:\"changed\";}}s:10:\"token type\";s:16:\"i18n_translation\";s:13:\"configuration\";b:0;}s:4:\"node\";a:28:{s:5:\"label\";s:4:\"Nodo\";s:16:\"controller class\";s:14:\"NodeController\";s:10:\"base table\";s:4:\"node\";s:14:\"revision table\";s:13:\"node_revision\";s:12:\"uri callback\";s:8:\"node_uri\";s:9:\"fieldable\";b:1;s:11:\"entity keys\";a:7:{s:2:\"id\";s:3:\"nid\";s:8:\"revision\";s:3:\"vid\";s:6:\"bundle\";s:4:\"type\";s:5:\"label\";s:5:\"title\";s:8:\"language\";s:8:\"language\";s:4:\"uuid\";s:4:\"uuid\";s:13:\"revision uuid\";s:5:\"vuuid\";}s:11:\"bundle keys\";a:1:{s:6:\"bundle\";s:4:\"type\";}s:7:\"bundles\";a:7:{s:8:\"activity\";a:3:{s:5:\"label\";s:10:\"Actividade\";s:5:\"admin\";a:4:{s:4:\"path\";s:39:\"admin/structure/types/manage/%node_type\";s:9:\"real path\";s:37:\"admin/structure/types/manage/activity\";s:15:\"bundle argument\";i:4;s:16:\"access arguments\";a:1:{i:0;s:24:\"administer content types\";}}s:11:\"rdf_mapping\";a:9:{s:7:\"rdftype\";a:2:{i:0;s:9:\"sioc:Item\";i:1;s:13:\"foaf:Document\";}s:5:\"title\";a:1:{s:10:\"predicates\";a:1:{i:0;s:8:\"dc:title\";}}s:7:\"created\";a:3:{s:10:\"predicates\";a:2:{i:0;s:7:\"dc:date\";i:1;s:10:\"dc:created\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:7:\"changed\";a:3:{s:10:\"predicates\";a:1:{i:0;s:11:\"dc:modified\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:4:\"body\";a:1:{s:10:\"predicates\";a:1:{i:0;s:15:\"content:encoded\";}}s:3:\"uid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:has_creator\";}s:4:\"type\";s:3:\"rel\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:1:{i:0;s:9:\"foaf:name\";}}s:13:\"comment_count\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:num_replies\";}s:8:\"datatype\";s:11:\"xsd:integer\";}s:13:\"last_activity\";a:3:{s:10:\"predicates\";a:1:{i:0;s:23:\"sioc:last_activity_date\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}}}s:7:\"archive\";a:3:{s:5:\"label\";s:7:\"Arquivo\";s:5:\"admin\";a:4:{s:4:\"path\";s:39:\"admin/structure/types/manage/%node_type\";s:9:\"real path\";s:36:\"admin/structure/types/manage/archive\";s:15:\"bundle argument\";i:4;s:16:\"access arguments\";a:1:{i:0;s:24:\"administer content types\";}}s:11:\"rdf_mapping\";a:9:{s:7:\"rdftype\";a:2:{i:0;s:9:\"sioc:Item\";i:1;s:13:\"foaf:Document\";}s:5:\"title\";a:1:{s:10:\"predicates\";a:1:{i:0;s:8:\"dc:title\";}}s:7:\"created\";a:3:{s:10:\"predicates\";a:2:{i:0;s:7:\"dc:date\";i:1;s:10:\"dc:created\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:7:\"changed\";a:3:{s:10:\"predicates\";a:1:{i:0;s:11:\"dc:modified\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:4:\"body\";a:1:{s:10:\"predicates\";a:1:{i:0;s:15:\"content:encoded\";}}s:3:\"uid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:has_creator\";}s:4:\"type\";s:3:\"rel\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:1:{i:0;s:9:\"foaf:name\";}}s:13:\"comment_count\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:num_replies\";}s:8:\"datatype\";s:11:\"xsd:integer\";}s:13:\"last_activity\";a:3:{s:10:\"predicates\";a:1:{i:0;s:23:\"sioc:last_activity_date\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}}}s:6:\"banner\";a:3:{s:5:\"label\";s:6:\"Banner\";s:5:\"admin\";a:4:{s:4:\"path\";s:39:\"admin/structure/types/manage/%node_type\";s:9:\"real path\";s:35:\"admin/structure/types/manage/banner\";s:15:\"bundle argument\";i:4;s:16:\"access arguments\";a:1:{i:0;s:24:\"administer content types\";}}s:11:\"rdf_mapping\";a:9:{s:7:\"rdftype\";a:2:{i:0;s:9:\"sioc:Item\";i:1;s:13:\"foaf:Document\";}s:5:\"title\";a:1:{s:10:\"predicates\";a:1:{i:0;s:8:\"dc:title\";}}s:7:\"created\";a:3:{s:10:\"predicates\";a:2:{i:0;s:7:\"dc:date\";i:1;s:10:\"dc:created\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:7:\"changed\";a:3:{s:10:\"predicates\";a:1:{i:0;s:11:\"dc:modified\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:4:\"body\";a:1:{s:10:\"predicates\";a:1:{i:0;s:15:\"content:encoded\";}}s:3:\"uid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:has_creator\";}s:4:\"type\";s:3:\"rel\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:1:{i:0;s:9:\"foaf:name\";}}s:13:\"comment_count\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:num_replies\";}s:8:\"datatype\";s:11:\"xsd:integer\";}s:13:\"last_activity\";a:3:{s:10:\"predicates\";a:1:{i:0;s:23:\"sioc:last_activity_date\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}}}s:10:\"diary_item\";a:3:{s:5:\"label\";s:17:\"Entrada da Axenda\";s:5:\"admin\";a:4:{s:4:\"path\";s:39:\"admin/structure/types/manage/%node_type\";s:9:\"real path\";s:39:\"admin/structure/types/manage/diary-item\";s:15:\"bundle argument\";i:4;s:16:\"access arguments\";a:1:{i:0;s:24:\"administer content types\";}}s:11:\"rdf_mapping\";a:9:{s:7:\"rdftype\";a:2:{i:0;s:9:\"sioc:Item\";i:1;s:13:\"foaf:Document\";}s:5:\"title\";a:1:{s:10:\"predicates\";a:1:{i:0;s:8:\"dc:title\";}}s:7:\"created\";a:3:{s:10:\"predicates\";a:2:{i:0;s:7:\"dc:date\";i:1;s:10:\"dc:created\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:7:\"changed\";a:3:{s:10:\"predicates\";a:1:{i:0;s:11:\"dc:modified\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:4:\"body\";a:1:{s:10:\"predicates\";a:1:{i:0;s:15:\"content:encoded\";}}s:3:\"uid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:has_creator\";}s:4:\"type\";s:3:\"rel\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:1:{i:0;s:9:\"foaf:name\";}}s:13:\"comment_count\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:num_replies\";}s:8:\"datatype\";s:11:\"xsd:integer\";}s:13:\"last_activity\";a:3:{s:10:\"predicates\";a:1:{i:0;s:23:\"sioc:last_activity_date\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}}}s:4:\"home\";a:3:{s:5:\"label\";s:4:\"Home\";s:5:\"admin\";a:4:{s:4:\"path\";s:39:\"admin/structure/types/manage/%node_type\";s:9:\"real path\";s:33:\"admin/structure/types/manage/home\";s:15:\"bundle argument\";i:4;s:16:\"access arguments\";a:1:{i:0;s:24:\"administer content types\";}}s:11:\"rdf_mapping\";a:9:{s:7:\"rdftype\";a:2:{i:0;s:9:\"sioc:Item\";i:1;s:13:\"foaf:Document\";}s:5:\"title\";a:1:{s:10:\"predicates\";a:1:{i:0;s:8:\"dc:title\";}}s:7:\"created\";a:3:{s:10:\"predicates\";a:2:{i:0;s:7:\"dc:date\";i:1;s:10:\"dc:created\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:7:\"changed\";a:3:{s:10:\"predicates\";a:1:{i:0;s:11:\"dc:modified\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:4:\"body\";a:1:{s:10:\"predicates\";a:1:{i:0;s:15:\"content:encoded\";}}s:3:\"uid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:has_creator\";}s:4:\"type\";s:3:\"rel\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:1:{i:0;s:9:\"foaf:name\";}}s:13:\"comment_count\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:num_replies\";}s:8:\"datatype\";s:11:\"xsd:integer\";}s:13:\"last_activity\";a:3:{s:10:\"predicates\";a:1:{i:0;s:23:\"sioc:last_activity_date\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}}}s:5:\"place\";a:3:{s:5:\"label\";s:5:\"Lugar\";s:5:\"admin\";a:4:{s:4:\"path\";s:39:\"admin/structure/types/manage/%node_type\";s:9:\"real path\";s:34:\"admin/structure/types/manage/place\";s:15:\"bundle argument\";i:4;s:16:\"access arguments\";a:1:{i:0;s:24:\"administer content types\";}}s:11:\"rdf_mapping\";a:9:{s:7:\"rdftype\";a:2:{i:0;s:9:\"sioc:Item\";i:1;s:13:\"foaf:Document\";}s:5:\"title\";a:1:{s:10:\"predicates\";a:1:{i:0;s:8:\"dc:title\";}}s:7:\"created\";a:3:{s:10:\"predicates\";a:2:{i:0;s:7:\"dc:date\";i:1;s:10:\"dc:created\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:7:\"changed\";a:3:{s:10:\"predicates\";a:1:{i:0;s:11:\"dc:modified\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:4:\"body\";a:1:{s:10:\"predicates\";a:1:{i:0;s:15:\"content:encoded\";}}s:3:\"uid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:has_creator\";}s:4:\"type\";s:3:\"rel\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:1:{i:0;s:9:\"foaf:name\";}}s:13:\"comment_count\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:num_replies\";}s:8:\"datatype\";s:11:\"xsd:integer\";}s:13:\"last_activity\";a:3:{s:10:\"predicates\";a:1:{i:0;s:23:\"sioc:last_activity_date\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}}}s:4:\"page\";a:3:{s:5:\"label\";s:7:\"Páxina\";s:5:\"admin\";a:4:{s:4:\"path\";s:39:\"admin/structure/types/manage/%node_type\";s:9:\"real path\";s:33:\"admin/structure/types/manage/page\";s:15:\"bundle argument\";i:4;s:16:\"access arguments\";a:1:{i:0;s:24:\"administer content types\";}}s:11:\"rdf_mapping\";a:9:{s:7:\"rdftype\";a:1:{i:0;s:13:\"foaf:Document\";}s:5:\"title\";a:1:{s:10:\"predicates\";a:1:{i:0;s:8:\"dc:title\";}}s:7:\"created\";a:3:{s:10:\"predicates\";a:2:{i:0;s:7:\"dc:date\";i:1;s:10:\"dc:created\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:7:\"changed\";a:3:{s:10:\"predicates\";a:1:{i:0;s:11:\"dc:modified\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:4:\"body\";a:1:{s:10:\"predicates\";a:1:{i:0;s:15:\"content:encoded\";}}s:3:\"uid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:has_creator\";}s:4:\"type\";s:3:\"rel\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:1:{i:0;s:9:\"foaf:name\";}}s:13:\"comment_count\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:num_replies\";}s:8:\"datatype\";s:11:\"xsd:integer\";}s:13:\"last_activity\";a:3:{s:10:\"predicates\";a:1:{i:0;s:23:\"sioc:last_activity_date\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}}}}s:10:\"view modes\";a:6:{s:4:\"full\";a:2:{s:5:\"label\";s:18:\"Contenido completo\";s:15:\"custom settings\";b:0;}s:6:\"teaser\";a:2:{s:5:\"label\";s:7:\"Resumen\";s:15:\"custom settings\";b:1;}s:3:\"rss\";a:2:{s:5:\"label\";s:3:\"RSS\";s:15:\"custom settings\";b:0;}s:12:\"search_index\";a:2:{s:5:\"label\";s:20:\"Índice de búsqueda\";s:15:\"custom settings\";b:0;}s:13:\"search_result\";a:2:{s:5:\"label\";s:39:\"Resaltando el resultado de la búsqueda\";s:15:\"custom settings\";b:0;}s:5:\"token\";a:2:{s:5:\"label\";s:9:\"Comodines\";s:15:\"custom settings\";b:0;}}s:12:\"static cache\";b:1;s:11:\"field cache\";b:1;s:9:\"load hook\";s:9:\"node_load\";s:11:\"translation\";a:1:{s:6:\"locale\";b:1;}s:22:\"base table field types\";a:15:{s:3:\"nid\";s:6:\"serial\";s:3:\"vid\";s:3:\"int\";s:4:\"type\";s:7:\"varchar\";s:8:\"language\";s:7:\"varchar\";s:5:\"title\";s:7:\"varchar\";s:3:\"uid\";s:3:\"int\";s:6:\"status\";s:3:\"int\";s:7:\"created\";s:3:\"int\";s:7:\"changed\";s:3:\"int\";s:7:\"comment\";s:3:\"int\";s:7:\"promote\";s:3:\"int\";s:6:\"sticky\";s:3:\"int\";s:4:\"tnid\";s:3:\"int\";s:9:\"translate\";s:3:\"int\";s:4:\"uuid\";s:4:\"char\";}s:17:\"schema_fields_sql\";a:2:{s:10:\"base table\";a:15:{i:0;s:3:\"nid\";i:1;s:3:\"vid\";i:2;s:4:\"type\";i:3;s:8:\"language\";i:4;s:5:\"title\";i:5;s:3:\"uid\";i:6;s:6:\"status\";i:7;s:7:\"created\";i:8;s:7:\"changed\";i:9;s:7:\"comment\";i:10;s:7:\"promote\";i:11;s:6:\"sticky\";i:12;s:4:\"tnid\";i:13;s:9:\"translate\";i:14;s:4:\"uuid\";}s:14:\"revision table\";a:11:{i:0;s:3:\"nid\";i:1;s:3:\"vid\";i:2;s:3:\"uid\";i:3;s:5:\"title\";i:4;s:3:\"log\";i:5;s:9:\"timestamp\";i:6;s:6:\"status\";i:7;s:7:\"comment\";i:8;s:7:\"promote\";i:9;s:6:\"sticky\";i:10;s:5:\"vuuid\";}}s:10:\"token type\";s:4:\"node\";s:12:\"plural label\";s:5:\"Nodos\";s:11:\"description\";s:71:\"Los nodos representan los principales elementos de contenido del sitio.\";s:15:\"access callback\";s:35:\"entity_metadata_no_hook_node_access\";s:17:\"creation callback\";s:27:\"entity_metadata_create_node\";s:13:\"save callback\";s:9:\"node_save\";s:17:\"deletion callback\";s:11:\"node_delete\";s:26:\"revision deletion callback\";s:20:\"node_revision_delete\";s:13:\"form callback\";s:25:\"entity_metadata_form_node\";s:13:\"view callback\";s:25:\"entity_metadata_view_node\";s:13:\"configuration\";b:0;s:4:\"uuid\";b:1;}s:4:\"file\";a:22:{s:5:\"label\";s:7:\"Archivo\";s:10:\"base table\";s:12:\"file_managed\";s:11:\"entity keys\";a:5:{s:2:\"id\";s:3:\"fid\";s:5:\"label\";s:8:\"filename\";s:8:\"revision\";s:0:\"\";s:6:\"bundle\";s:0:\"\";s:4:\"uuid\";s:4:\"uuid\";}s:12:\"static cache\";b:0;s:9:\"fieldable\";b:0;s:16:\"controller class\";s:29:\"DrupalDefaultEntityController\";s:11:\"field cache\";b:1;s:9:\"load hook\";s:9:\"file_load\";s:7:\"bundles\";a:1:{s:4:\"file\";a:2:{s:5:\"label\";s:7:\"Archivo\";s:11:\"rdf_mapping\";a:0:{}}}s:10:\"view modes\";a:0:{}s:11:\"translation\";a:0:{}s:22:\"base table field types\";a:9:{s:3:\"fid\";s:6:\"serial\";s:3:\"uid\";s:3:\"int\";s:8:\"filename\";s:7:\"varchar\";s:3:\"uri\";s:7:\"varchar\";s:8:\"filemime\";s:7:\"varchar\";s:8:\"filesize\";s:3:\"int\";s:6:\"status\";s:3:\"int\";s:9:\"timestamp\";s:3:\"int\";s:4:\"uuid\";s:4:\"char\";}s:17:\"schema_fields_sql\";a:1:{s:10:\"base table\";a:9:{i:0;s:3:\"fid\";i:1;s:3:\"uid\";i:2;s:8:\"filename\";i:3;s:3:\"uri\";i:4;s:8:\"filemime\";i:5;s:8:\"filesize\";i:6;s:6:\"status\";i:7;s:9:\"timestamp\";i:8;s:4:\"uuid\";}}s:10:\"token type\";s:4:\"file\";s:12:\"plural label\";s:8:\"Archivos\";s:11:\"description\";s:15:\"Archivo subido.\";s:15:\"access callback\";s:27:\"entity_metadata_file_access\";s:13:\"save callback\";s:9:\"file_save\";s:17:\"deletion callback\";s:27:\"entity_metadata_delete_file\";s:12:\"uri callback\";s:24:\"entity_metadata_uri_file\";s:13:\"configuration\";b:0;s:4:\"uuid\";b:1;}s:13:\"taxonomy_term\";a:27:{s:5:\"label\";s:22:\"Término de taxonomía\";s:16:\"controller class\";s:22:\"TaxonomyTermController\";s:10:\"base table\";s:18:\"taxonomy_term_data\";s:12:\"uri callback\";s:17:\"taxonomy_term_uri\";s:9:\"fieldable\";b:1;s:11:\"entity keys\";a:6:{s:2:\"id\";s:3:\"tid\";s:6:\"bundle\";s:23:\"vocabulary_machine_name\";s:5:\"label\";s:4:\"name\";s:8:\"revision\";s:0:\"\";s:8:\"language\";s:8:\"language\";s:4:\"uuid\";s:4:\"uuid\";}s:11:\"bundle keys\";a:1:{s:6:\"bundle\";s:12:\"machine_name\";}s:7:\"bundles\";a:4:{s:4:\"tags\";a:3:{s:5:\"label\";s:9:\"Etiquetas\";s:5:\"admin\";a:4:{s:4:\"path\";s:58:\"admin/structure/taxonomy/%taxonomy_vocabulary_machine_name\";s:9:\"real path\";s:29:\"admin/structure/taxonomy/tags\";s:15:\"bundle argument\";i:3;s:16:\"access arguments\";a:1:{i:0;s:19:\"administer taxonomy\";}}s:11:\"rdf_mapping\";a:5:{s:7:\"rdftype\";a:1:{i:0;s:12:\"skos:Concept\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:2:{i:0;s:10:\"rdfs:label\";i:1;s:14:\"skos:prefLabel\";}}s:11:\"description\";a:1:{s:10:\"predicates\";a:1:{i:0;s:15:\"skos:definition\";}}s:3:\"vid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:13:\"skos:inScheme\";}s:4:\"type\";s:3:\"rel\";}s:6:\"parent\";a:2:{s:10:\"predicates\";a:1:{i:0;s:12:\"skos:broader\";}s:4:\"type\";s:3:\"rel\";}}}s:6:\"places\";a:3:{s:5:\"label\";s:4:\"Mapa\";s:5:\"admin\";a:4:{s:4:\"path\";s:58:\"admin/structure/taxonomy/%taxonomy_vocabulary_machine_name\";s:9:\"real path\";s:31:\"admin/structure/taxonomy/places\";s:15:\"bundle argument\";i:3;s:16:\"access arguments\";a:1:{i:0;s:19:\"administer taxonomy\";}}s:11:\"rdf_mapping\";a:5:{s:7:\"rdftype\";a:1:{i:0;s:12:\"skos:Concept\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:2:{i:0;s:10:\"rdfs:label\";i:1;s:14:\"skos:prefLabel\";}}s:11:\"description\";a:1:{s:10:\"predicates\";a:1:{i:0;s:15:\"skos:definition\";}}s:3:\"vid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:13:\"skos:inScheme\";}s:4:\"type\";s:3:\"rel\";}s:6:\"parent\";a:2:{s:10:\"predicates\";a:1:{i:0;s:12:\"skos:broader\";}s:4:\"type\";s:3:\"rel\";}}}s:10:\"categories\";a:3:{s:5:\"label\";s:7:\"Arquivo\";s:5:\"admin\";a:4:{s:4:\"path\";s:58:\"admin/structure/taxonomy/%taxonomy_vocabulary_machine_name\";s:9:\"real path\";s:35:\"admin/structure/taxonomy/categories\";s:15:\"bundle argument\";i:3;s:16:\"access arguments\";a:1:{i:0;s:19:\"administer taxonomy\";}}s:11:\"rdf_mapping\";a:5:{s:7:\"rdftype\";a:1:{i:0;s:12:\"skos:Concept\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:2:{i:0;s:10:\"rdfs:label\";i:1;s:14:\"skos:prefLabel\";}}s:11:\"description\";a:1:{s:10:\"predicates\";a:1:{i:0;s:15:\"skos:definition\";}}s:3:\"vid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:13:\"skos:inScheme\";}s:4:\"type\";s:3:\"rel\";}s:6:\"parent\";a:2:{s:10:\"predicates\";a:1:{i:0;s:12:\"skos:broader\";}s:4:\"type\";s:3:\"rel\";}}}s:14:\"rss_categories\";a:3:{s:5:\"label\";s:15:\"RSS Categorías\";s:5:\"admin\";a:4:{s:4:\"path\";s:58:\"admin/structure/taxonomy/%taxonomy_vocabulary_machine_name\";s:9:\"real path\";s:39:\"admin/structure/taxonomy/rss_categories\";s:15:\"bundle argument\";i:3;s:16:\"access arguments\";a:1:{i:0;s:19:\"administer taxonomy\";}}s:11:\"rdf_mapping\";a:5:{s:7:\"rdftype\";a:1:{i:0;s:12:\"skos:Concept\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:2:{i:0;s:10:\"rdfs:label\";i:1;s:14:\"skos:prefLabel\";}}s:11:\"description\";a:1:{s:10:\"predicates\";a:1:{i:0;s:15:\"skos:definition\";}}s:3:\"vid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:13:\"skos:inScheme\";}s:4:\"type\";s:3:\"rel\";}s:6:\"parent\";a:2:{s:10:\"predicates\";a:1:{i:0;s:12:\"skos:broader\";}s:4:\"type\";s:3:\"rel\";}}}}s:10:\"view modes\";a:2:{s:4:\"full\";a:2:{s:5:\"label\";s:34:\"Página de términos de taxonomía\";s:15:\"custom settings\";b:0;}s:5:\"token\";a:2:{s:5:\"label\";s:9:\"Comodines\";s:15:\"custom settings\";b:0;}}s:12:\"static cache\";b:1;s:11:\"field cache\";b:1;s:9:\"load hook\";s:18:\"taxonomy_term_load\";s:11:\"translation\";a:0:{}s:22:\"base table field types\";a:9:{s:3:\"tid\";s:6:\"serial\";s:3:\"vid\";s:3:\"int\";s:4:\"name\";s:7:\"varchar\";s:11:\"description\";s:4:\"text\";s:6:\"format\";s:7:\"varchar\";s:6:\"weight\";s:3:\"int\";s:4:\"uuid\";s:4:\"char\";s:8:\"language\";s:7:\"varchar\";s:9:\"i18n_tsid\";s:3:\"int\";}s:17:\"schema_fields_sql\";a:1:{s:10:\"base table\";a:9:{i:0;s:3:\"tid\";i:1;s:3:\"vid\";i:2;s:4:\"name\";i:3;s:11:\"description\";i:4;s:6:\"format\";i:5;s:6:\"weight\";i:6;s:4:\"uuid\";i:7;s:8:\"language\";i:8;s:9:\"i18n_tsid\";}}s:10:\"token type\";s:4:\"term\";s:14:\"label callback\";s:33:\"i18n_taxonomy_taxonomy_term_label\";s:12:\"plural label\";s:23:\"Términos de taxonomía\";s:11:\"description\";s:64:\"Términos de taxonomía utilizados para clasificar el contenido.\";s:15:\"access callback\";s:31:\"entity_metadata_taxonomy_access\";s:17:\"creation callback\";s:29:\"entity_metadata_create_object\";s:13:\"save callback\";s:18:\"taxonomy_term_save\";s:17:\"deletion callback\";s:20:\"taxonomy_term_delete\";s:13:\"view callback\";s:27:\"entity_metadata_view_single\";s:13:\"form callback\";s:34:\"entity_metadata_form_taxonomy_term\";s:13:\"configuration\";b:0;s:4:\"uuid\";b:1;}s:19:\"taxonomy_vocabulary\";a:22:{s:5:\"label\";s:25:\"Vocabulario de taxonomía\";s:16:\"controller class\";s:28:\"TaxonomyVocabularyController\";s:10:\"base table\";s:19:\"taxonomy_vocabulary\";s:11:\"entity keys\";a:4:{s:2:\"id\";s:3:\"vid\";s:5:\"label\";s:4:\"name\";s:8:\"revision\";s:0:\"\";s:6:\"bundle\";s:0:\"\";}s:9:\"fieldable\";b:0;s:12:\"static cache\";b:1;s:11:\"field cache\";b:1;s:9:\"load hook\";s:24:\"taxonomy_vocabulary_load\";s:7:\"bundles\";a:1:{s:19:\"taxonomy_vocabulary\";a:2:{s:5:\"label\";s:25:\"Vocabulario de taxonomía\";s:11:\"rdf_mapping\";a:3:{s:7:\"rdftype\";a:1:{i:0;s:18:\"skos:ConceptScheme\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:1:{i:0;s:8:\"dc:title\";}}s:11:\"description\";a:1:{s:10:\"predicates\";a:1:{i:0;s:12:\"rdfs:comment\";}}}}}s:10:\"view modes\";a:0:{}s:11:\"translation\";a:0:{}s:22:\"base table field types\";a:9:{s:3:\"vid\";s:6:\"serial\";s:4:\"name\";s:7:\"varchar\";s:12:\"machine_name\";s:7:\"varchar\";s:11:\"description\";s:4:\"text\";s:9:\"hierarchy\";s:3:\"int\";s:6:\"module\";s:7:\"varchar\";s:6:\"weight\";s:3:\"int\";s:8:\"language\";s:7:\"varchar\";s:9:\"i18n_mode\";s:3:\"int\";}s:17:\"schema_fields_sql\";a:1:{s:10:\"base table\";a:9:{i:0;s:3:\"vid\";i:1;s:4:\"name\";i:2;s:12:\"machine_name\";i:3;s:11:\"description\";i:4;s:9:\"hierarchy\";i:5;s:6:\"module\";i:6;s:6:\"weight\";i:7;s:8:\"language\";i:8;s:9:\"i18n_mode\";}}s:10:\"token type\";s:10:\"vocabulary\";s:12:\"plural label\";s:26:\"Vocabularios de taxonomía\";s:11:\"description\";s:120:\"Vocabularios contienen términos relacionados con la taxonomía, los cuales son utilizados para clasificar el contenido.\";s:15:\"access callback\";s:31:\"entity_metadata_taxonomy_access\";s:17:\"creation callback\";s:29:\"entity_metadata_create_object\";s:13:\"save callback\";s:24:\"taxonomy_vocabulary_save\";s:17:\"deletion callback\";s:26:\"taxonomy_vocabulary_delete\";s:13:\"form callback\";s:40:\"entity_metadata_form_taxonomy_vocabulary\";s:13:\"configuration\";b:0;}s:4:\"user\";a:26:{s:5:\"label\";s:7:\"Usuario\";s:16:\"controller class\";s:14:\"UserController\";s:10:\"base table\";s:5:\"users\";s:12:\"uri callback\";s:8:\"user_uri\";s:14:\"label callback\";s:15:\"format_username\";s:9:\"fieldable\";b:1;s:11:\"entity keys\";a:4:{s:2:\"id\";s:3:\"uid\";s:8:\"revision\";s:0:\"\";s:6:\"bundle\";s:0:\"\";s:4:\"uuid\";s:4:\"uuid\";}s:7:\"bundles\";a:1:{s:4:\"user\";a:3:{s:5:\"label\";s:7:\"Usuario\";s:5:\"admin\";a:2:{s:4:\"path\";s:28:\"admin/config/people/accounts\";s:16:\"access arguments\";a:1:{i:0;s:16:\"administer users\";}}s:11:\"rdf_mapping\";a:3:{s:7:\"rdftype\";a:1:{i:0;s:16:\"sioc:UserAccount\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:1:{i:0;s:9:\"foaf:name\";}}s:8:\"homepage\";a:2:{s:10:\"predicates\";a:1:{i:0;s:9:\"foaf:page\";}s:4:\"type\";s:3:\"rel\";}}}}s:10:\"view modes\";a:2:{s:4:\"full\";a:2:{s:5:\"label\";s:17:\"Cuenta de usuario\";s:15:\"custom settings\";b:0;}s:5:\"token\";a:2:{s:5:\"label\";s:9:\"Comodines\";s:15:\"custom settings\";b:0;}}s:12:\"static cache\";b:1;s:11:\"field cache\";b:1;s:9:\"load hook\";s:9:\"user_load\";s:11:\"translation\";a:0:{}s:22:\"base table field types\";a:17:{s:3:\"uid\";s:3:\"int\";s:4:\"name\";s:7:\"varchar\";s:4:\"pass\";s:7:\"varchar\";s:4:\"mail\";s:7:\"varchar\";s:5:\"theme\";s:7:\"varchar\";s:9:\"signature\";s:7:\"varchar\";s:16:\"signature_format\";s:7:\"varchar\";s:7:\"created\";s:3:\"int\";s:6:\"access\";s:3:\"int\";s:5:\"login\";s:3:\"int\";s:6:\"status\";s:3:\"int\";s:8:\"timezone\";s:7:\"varchar\";s:8:\"language\";s:7:\"varchar\";s:7:\"picture\";s:3:\"int\";s:4:\"init\";s:7:\"varchar\";s:4:\"data\";s:4:\"blob\";s:4:\"uuid\";s:4:\"char\";}s:17:\"schema_fields_sql\";a:1:{s:10:\"base table\";a:17:{i:0;s:3:\"uid\";i:1;s:4:\"name\";i:2;s:4:\"pass\";i:3;s:4:\"mail\";i:4;s:5:\"theme\";i:5;s:9:\"signature\";i:6;s:16:\"signature_format\";i:7;s:7:\"created\";i:8;s:6:\"access\";i:9;s:5:\"login\";i:10;s:6:\"status\";i:11;s:8:\"timezone\";i:12;s:8:\"language\";i:13;s:7:\"picture\";i:14;s:4:\"init\";i:15;s:4:\"data\";i:16;s:4:\"uuid\";}}s:10:\"token type\";s:4:\"user\";s:12:\"plural label\";s:8:\"Usuarios\";s:11:\"description\";s:61:\"Usuarios que se han registrado y tienen cuenta en este sitio.\";s:15:\"access callback\";s:27:\"entity_metadata_user_access\";s:17:\"creation callback\";s:29:\"entity_metadata_create_object\";s:13:\"save callback\";s:25:\"entity_metadata_user_save\";s:17:\"deletion callback\";s:11:\"user_delete\";s:13:\"form callback\";s:25:\"entity_metadata_form_user\";s:13:\"view callback\";s:27:\"entity_metadata_view_single\";s:13:\"configuration\";b:0;s:4:\"uuid\";b:1;}s:15:\"wysiwyg_profile\";a:15:{s:5:\"label\";s:15:\"Wysiwyg profile\";s:10:\"base table\";s:7:\"wysiwyg\";s:16:\"controller class\";s:24:\"WysiwygProfileController\";s:9:\"fieldable\";b:0;s:12:\"static cache\";b:0;s:11:\"entity keys\";a:3:{s:2:\"id\";s:6:\"format\";s:8:\"revision\";s:0:\"\";s:6:\"bundle\";s:0:\"\";}s:11:\"field cache\";b:1;s:9:\"load hook\";s:20:\"wysiwyg_profile_load\";s:7:\"bundles\";a:1:{s:15:\"wysiwyg_profile\";a:2:{s:5:\"label\";s:15:\"Wysiwyg profile\";s:11:\"rdf_mapping\";a:0:{}}}s:10:\"view modes\";a:0:{}s:11:\"translation\";a:0:{}s:22:\"base table field types\";a:3:{s:6:\"format\";s:7:\"varchar\";s:6:\"editor\";s:7:\"varchar\";s:8:\"settings\";s:4:\"text\";}s:17:\"schema_fields_sql\";a:1:{s:10:\"base table\";a:3:{i:0;s:6:\"format\";i:1;s:6:\"editor\";i:2;s:8:\"settings\";}}s:10:\"token type\";s:15:\"wysiwyg_profile\";s:13:\"configuration\";b:0;}}',0,1469579890,1),('entity_info:gl','a:8:{s:7:\"comment\";a:25:{s:5:\"label\";s:10:\"Comentario\";s:10:\"base table\";s:7:\"comment\";s:12:\"uri callback\";s:11:\"comment_uri\";s:9:\"fieldable\";b:1;s:16:\"controller class\";s:17:\"CommentController\";s:11:\"entity keys\";a:6:{s:2:\"id\";s:3:\"cid\";s:6:\"bundle\";s:9:\"node_type\";s:5:\"label\";s:7:\"subject\";s:8:\"language\";s:8:\"language\";s:8:\"revision\";s:0:\"\";s:4:\"uuid\";s:4:\"uuid\";}s:7:\"bundles\";a:7:{s:21:\"comment_node_activity\";a:4:{s:5:\"label\";s:24:\"comentario de Actividade\";s:11:\"node bundle\";s:8:\"activity\";s:5:\"admin\";a:4:{s:4:\"path\";s:55:\"admin/structure/types/manage/%comment_node_type/comment\";s:15:\"bundle argument\";i:4;s:9:\"real path\";s:45:\"admin/structure/types/manage/activity/comment\";s:16:\"access arguments\";a:1:{i:0;s:24:\"administer content types\";}}s:11:\"rdf_mapping\";a:8:{s:7:\"rdftype\";a:2:{i:0;s:9:\"sioc:Post\";i:1;s:13:\"sioct:Comment\";}s:5:\"title\";a:1:{s:10:\"predicates\";a:1:{i:0;s:8:\"dc:title\";}}s:7:\"created\";a:3:{s:10:\"predicates\";a:2:{i:0;s:7:\"dc:date\";i:1;s:10:\"dc:created\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:7:\"changed\";a:3:{s:10:\"predicates\";a:1:{i:0;s:11:\"dc:modified\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:12:\"comment_body\";a:1:{s:10:\"predicates\";a:1:{i:0;s:15:\"content:encoded\";}}s:3:\"pid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:13:\"sioc:reply_of\";}s:4:\"type\";s:3:\"rel\";}s:3:\"uid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:has_creator\";}s:4:\"type\";s:3:\"rel\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:1:{i:0;s:9:\"foaf:name\";}}}}s:20:\"comment_node_archive\";a:4:{s:5:\"label\";s:21:\"comentario de Arquivo\";s:11:\"node bundle\";s:7:\"archive\";s:5:\"admin\";a:4:{s:4:\"path\";s:55:\"admin/structure/types/manage/%comment_node_type/comment\";s:15:\"bundle argument\";i:4;s:9:\"real path\";s:44:\"admin/structure/types/manage/archive/comment\";s:16:\"access arguments\";a:1:{i:0;s:24:\"administer content types\";}}s:11:\"rdf_mapping\";a:8:{s:7:\"rdftype\";a:2:{i:0;s:9:\"sioc:Post\";i:1;s:13:\"sioct:Comment\";}s:5:\"title\";a:1:{s:10:\"predicates\";a:1:{i:0;s:8:\"dc:title\";}}s:7:\"created\";a:3:{s:10:\"predicates\";a:2:{i:0;s:7:\"dc:date\";i:1;s:10:\"dc:created\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:7:\"changed\";a:3:{s:10:\"predicates\";a:1:{i:0;s:11:\"dc:modified\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:12:\"comment_body\";a:1:{s:10:\"predicates\";a:1:{i:0;s:15:\"content:encoded\";}}s:3:\"pid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:13:\"sioc:reply_of\";}s:4:\"type\";s:3:\"rel\";}s:3:\"uid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:has_creator\";}s:4:\"type\";s:3:\"rel\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:1:{i:0;s:9:\"foaf:name\";}}}}s:19:\"comment_node_banner\";a:4:{s:5:\"label\";s:20:\"comentario de Banner\";s:11:\"node bundle\";s:6:\"banner\";s:5:\"admin\";a:4:{s:4:\"path\";s:55:\"admin/structure/types/manage/%comment_node_type/comment\";s:15:\"bundle argument\";i:4;s:9:\"real path\";s:43:\"admin/structure/types/manage/banner/comment\";s:16:\"access arguments\";a:1:{i:0;s:24:\"administer content types\";}}s:11:\"rdf_mapping\";a:8:{s:7:\"rdftype\";a:2:{i:0;s:9:\"sioc:Post\";i:1;s:13:\"sioct:Comment\";}s:5:\"title\";a:1:{s:10:\"predicates\";a:1:{i:0;s:8:\"dc:title\";}}s:7:\"created\";a:3:{s:10:\"predicates\";a:2:{i:0;s:7:\"dc:date\";i:1;s:10:\"dc:created\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:7:\"changed\";a:3:{s:10:\"predicates\";a:1:{i:0;s:11:\"dc:modified\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:12:\"comment_body\";a:1:{s:10:\"predicates\";a:1:{i:0;s:15:\"content:encoded\";}}s:3:\"pid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:13:\"sioc:reply_of\";}s:4:\"type\";s:3:\"rel\";}s:3:\"uid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:has_creator\";}s:4:\"type\";s:3:\"rel\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:1:{i:0;s:9:\"foaf:name\";}}}}s:23:\"comment_node_diary_item\";a:4:{s:5:\"label\";s:31:\"comentario de Entrada da Axenda\";s:11:\"node bundle\";s:10:\"diary_item\";s:5:\"admin\";a:4:{s:4:\"path\";s:55:\"admin/structure/types/manage/%comment_node_type/comment\";s:15:\"bundle argument\";i:4;s:9:\"real path\";s:47:\"admin/structure/types/manage/diary-item/comment\";s:16:\"access arguments\";a:1:{i:0;s:24:\"administer content types\";}}s:11:\"rdf_mapping\";a:8:{s:7:\"rdftype\";a:2:{i:0;s:9:\"sioc:Post\";i:1;s:13:\"sioct:Comment\";}s:5:\"title\";a:1:{s:10:\"predicates\";a:1:{i:0;s:8:\"dc:title\";}}s:7:\"created\";a:3:{s:10:\"predicates\";a:2:{i:0;s:7:\"dc:date\";i:1;s:10:\"dc:created\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:7:\"changed\";a:3:{s:10:\"predicates\";a:1:{i:0;s:11:\"dc:modified\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:12:\"comment_body\";a:1:{s:10:\"predicates\";a:1:{i:0;s:15:\"content:encoded\";}}s:3:\"pid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:13:\"sioc:reply_of\";}s:4:\"type\";s:3:\"rel\";}s:3:\"uid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:has_creator\";}s:4:\"type\";s:3:\"rel\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:1:{i:0;s:9:\"foaf:name\";}}}}s:17:\"comment_node_home\";a:4:{s:5:\"label\";s:18:\"comentario de Home\";s:11:\"node bundle\";s:4:\"home\";s:5:\"admin\";a:4:{s:4:\"path\";s:55:\"admin/structure/types/manage/%comment_node_type/comment\";s:15:\"bundle argument\";i:4;s:9:\"real path\";s:41:\"admin/structure/types/manage/home/comment\";s:16:\"access arguments\";a:1:{i:0;s:24:\"administer content types\";}}s:11:\"rdf_mapping\";a:8:{s:7:\"rdftype\";a:2:{i:0;s:9:\"sioc:Post\";i:1;s:13:\"sioct:Comment\";}s:5:\"title\";a:1:{s:10:\"predicates\";a:1:{i:0;s:8:\"dc:title\";}}s:7:\"created\";a:3:{s:10:\"predicates\";a:2:{i:0;s:7:\"dc:date\";i:1;s:10:\"dc:created\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:7:\"changed\";a:3:{s:10:\"predicates\";a:1:{i:0;s:11:\"dc:modified\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:12:\"comment_body\";a:1:{s:10:\"predicates\";a:1:{i:0;s:15:\"content:encoded\";}}s:3:\"pid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:13:\"sioc:reply_of\";}s:4:\"type\";s:3:\"rel\";}s:3:\"uid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:has_creator\";}s:4:\"type\";s:3:\"rel\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:1:{i:0;s:9:\"foaf:name\";}}}}s:18:\"comment_node_place\";a:4:{s:5:\"label\";s:19:\"comentario de Lugar\";s:11:\"node bundle\";s:5:\"place\";s:5:\"admin\";a:4:{s:4:\"path\";s:55:\"admin/structure/types/manage/%comment_node_type/comment\";s:15:\"bundle argument\";i:4;s:9:\"real path\";s:42:\"admin/structure/types/manage/place/comment\";s:16:\"access arguments\";a:1:{i:0;s:24:\"administer content types\";}}s:11:\"rdf_mapping\";a:8:{s:7:\"rdftype\";a:2:{i:0;s:9:\"sioc:Post\";i:1;s:13:\"sioct:Comment\";}s:5:\"title\";a:1:{s:10:\"predicates\";a:1:{i:0;s:8:\"dc:title\";}}s:7:\"created\";a:3:{s:10:\"predicates\";a:2:{i:0;s:7:\"dc:date\";i:1;s:10:\"dc:created\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:7:\"changed\";a:3:{s:10:\"predicates\";a:1:{i:0;s:11:\"dc:modified\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:12:\"comment_body\";a:1:{s:10:\"predicates\";a:1:{i:0;s:15:\"content:encoded\";}}s:3:\"pid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:13:\"sioc:reply_of\";}s:4:\"type\";s:3:\"rel\";}s:3:\"uid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:has_creator\";}s:4:\"type\";s:3:\"rel\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:1:{i:0;s:9:\"foaf:name\";}}}}s:17:\"comment_node_page\";a:4:{s:5:\"label\";s:21:\"comentario de Páxina\";s:11:\"node bundle\";s:4:\"page\";s:5:\"admin\";a:4:{s:4:\"path\";s:55:\"admin/structure/types/manage/%comment_node_type/comment\";s:15:\"bundle argument\";i:4;s:9:\"real path\";s:41:\"admin/structure/types/manage/page/comment\";s:16:\"access arguments\";a:1:{i:0;s:24:\"administer content types\";}}s:11:\"rdf_mapping\";a:8:{s:7:\"rdftype\";a:2:{i:0;s:9:\"sioc:Post\";i:1;s:13:\"sioct:Comment\";}s:5:\"title\";a:1:{s:10:\"predicates\";a:1:{i:0;s:8:\"dc:title\";}}s:7:\"created\";a:3:{s:10:\"predicates\";a:2:{i:0;s:7:\"dc:date\";i:1;s:10:\"dc:created\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:7:\"changed\";a:3:{s:10:\"predicates\";a:1:{i:0;s:11:\"dc:modified\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:12:\"comment_body\";a:1:{s:10:\"predicates\";a:1:{i:0;s:15:\"content:encoded\";}}s:3:\"pid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:13:\"sioc:reply_of\";}s:4:\"type\";s:3:\"rel\";}s:3:\"uid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:has_creator\";}s:4:\"type\";s:3:\"rel\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:1:{i:0;s:9:\"foaf:name\";}}}}}s:10:\"view modes\";a:2:{s:4:\"full\";a:2:{s:5:\"label\";s:19:\"Comentario completo\";s:15:\"custom settings\";b:0;}s:5:\"token\";a:2:{s:5:\"label\";s:9:\"Comodines\";s:15:\"custom settings\";b:0;}}s:12:\"static cache\";b:0;s:11:\"field cache\";b:1;s:9:\"load hook\";s:12:\"comment_load\";s:11:\"translation\";a:1:{s:6:\"locale\";b:1;}s:22:\"base table field types\";a:15:{s:3:\"cid\";s:6:\"serial\";s:3:\"pid\";s:3:\"int\";s:3:\"nid\";s:3:\"int\";s:3:\"uid\";s:3:\"int\";s:7:\"subject\";s:7:\"varchar\";s:8:\"hostname\";s:7:\"varchar\";s:7:\"created\";s:3:\"int\";s:7:\"changed\";s:3:\"int\";s:6:\"status\";s:3:\"int\";s:6:\"thread\";s:7:\"varchar\";s:4:\"name\";s:7:\"varchar\";s:4:\"mail\";s:7:\"varchar\";s:8:\"homepage\";s:7:\"varchar\";s:8:\"language\";s:7:\"varchar\";s:4:\"uuid\";s:4:\"char\";}s:17:\"schema_fields_sql\";a:1:{s:10:\"base table\";a:15:{i:0;s:3:\"cid\";i:1;s:3:\"pid\";i:2;s:3:\"nid\";i:3;s:3:\"uid\";i:4;s:7:\"subject\";i:5;s:8:\"hostname\";i:6;s:7:\"created\";i:7;s:7:\"changed\";i:8;s:6:\"status\";i:9;s:6:\"thread\";i:10;s:4:\"name\";i:11;s:4:\"mail\";i:12;s:8:\"homepage\";i:13;s:8:\"language\";i:14;s:4:\"uuid\";}}s:10:\"token type\";s:7:\"comment\";s:12:\"plural label\";s:11:\"Comentarios\";s:11:\"description\";s:37:\"Remark or note that refers to a node.\";s:15:\"access callback\";s:30:\"entity_metadata_comment_access\";s:17:\"creation callback\";s:30:\"entity_metadata_create_comment\";s:13:\"save callback\";s:12:\"comment_save\";s:17:\"deletion callback\";s:14:\"comment_delete\";s:13:\"view callback\";s:28:\"entity_metadata_view_comment\";s:13:\"form callback\";s:28:\"entity_metadata_form_comment\";s:13:\"configuration\";b:0;s:4:\"uuid\";b:1;}s:16:\"i18n_translation\";a:16:{s:5:\"label\";s:15:\"Translation set\";s:16:\"controller class\";s:28:\"I18nTranslationSetController\";s:10:\"base table\";s:20:\"i18n_translation_set\";s:9:\"fieldable\";b:0;s:11:\"entity keys\";a:4:{s:2:\"id\";s:4:\"tsid\";s:6:\"bundle\";s:4:\"type\";s:5:\"label\";s:5:\"title\";s:8:\"revision\";s:0:\"\";}s:11:\"bundle keys\";a:1:{s:6:\"bundle\";s:4:\"type\";}s:7:\"bundles\";a:2:{s:9:\"menu_link\";a:2:{s:5:\"label\";s:17:\"Ligazón de menú\";s:11:\"rdf_mapping\";a:0:{}}s:13:\"taxonomy_term\";a:2:{s:5:\"label\";s:19:\"Termo de taxonomía\";s:11:\"rdf_mapping\";a:0:{}}}s:12:\"static cache\";b:1;s:11:\"field cache\";b:1;s:9:\"load hook\";s:21:\"i18n_translation_load\";s:10:\"view modes\";a:0:{}s:11:\"translation\";a:0:{}s:22:\"base table field types\";a:8:{s:4:\"tsid\";s:6:\"serial\";s:5:\"title\";s:7:\"varchar\";s:4:\"type\";s:7:\"varchar\";s:6:\"bundle\";s:7:\"varchar\";s:9:\"master_id\";s:3:\"int\";s:6:\"status\";s:3:\"int\";s:7:\"created\";s:3:\"int\";s:7:\"changed\";s:3:\"int\";}s:17:\"schema_fields_sql\";a:1:{s:10:\"base table\";a:8:{i:0;s:4:\"tsid\";i:1;s:5:\"title\";i:2;s:4:\"type\";i:3;s:6:\"bundle\";i:4;s:9:\"master_id\";i:5;s:6:\"status\";i:6;s:7:\"created\";i:7;s:7:\"changed\";}}s:10:\"token type\";s:16:\"i18n_translation\";s:13:\"configuration\";b:0;}s:4:\"node\";a:28:{s:5:\"label\";s:4:\"Nodo\";s:16:\"controller class\";s:14:\"NodeController\";s:10:\"base table\";s:4:\"node\";s:14:\"revision table\";s:13:\"node_revision\";s:12:\"uri callback\";s:8:\"node_uri\";s:9:\"fieldable\";b:1;s:11:\"entity keys\";a:7:{s:2:\"id\";s:3:\"nid\";s:8:\"revision\";s:3:\"vid\";s:6:\"bundle\";s:4:\"type\";s:5:\"label\";s:5:\"title\";s:8:\"language\";s:8:\"language\";s:4:\"uuid\";s:4:\"uuid\";s:13:\"revision uuid\";s:5:\"vuuid\";}s:11:\"bundle keys\";a:1:{s:6:\"bundle\";s:4:\"type\";}s:7:\"bundles\";a:7:{s:8:\"activity\";a:3:{s:5:\"label\";s:10:\"Actividade\";s:5:\"admin\";a:4:{s:4:\"path\";s:39:\"admin/structure/types/manage/%node_type\";s:9:\"real path\";s:37:\"admin/structure/types/manage/activity\";s:15:\"bundle argument\";i:4;s:16:\"access arguments\";a:1:{i:0;s:24:\"administer content types\";}}s:11:\"rdf_mapping\";a:9:{s:7:\"rdftype\";a:2:{i:0;s:9:\"sioc:Item\";i:1;s:13:\"foaf:Document\";}s:5:\"title\";a:1:{s:10:\"predicates\";a:1:{i:0;s:8:\"dc:title\";}}s:7:\"created\";a:3:{s:10:\"predicates\";a:2:{i:0;s:7:\"dc:date\";i:1;s:10:\"dc:created\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:7:\"changed\";a:3:{s:10:\"predicates\";a:1:{i:0;s:11:\"dc:modified\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:4:\"body\";a:1:{s:10:\"predicates\";a:1:{i:0;s:15:\"content:encoded\";}}s:3:\"uid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:has_creator\";}s:4:\"type\";s:3:\"rel\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:1:{i:0;s:9:\"foaf:name\";}}s:13:\"comment_count\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:num_replies\";}s:8:\"datatype\";s:11:\"xsd:integer\";}s:13:\"last_activity\";a:3:{s:10:\"predicates\";a:1:{i:0;s:23:\"sioc:last_activity_date\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}}}s:7:\"archive\";a:3:{s:5:\"label\";s:7:\"Arquivo\";s:5:\"admin\";a:4:{s:4:\"path\";s:39:\"admin/structure/types/manage/%node_type\";s:9:\"real path\";s:36:\"admin/structure/types/manage/archive\";s:15:\"bundle argument\";i:4;s:16:\"access arguments\";a:1:{i:0;s:24:\"administer content types\";}}s:11:\"rdf_mapping\";a:9:{s:7:\"rdftype\";a:2:{i:0;s:9:\"sioc:Item\";i:1;s:13:\"foaf:Document\";}s:5:\"title\";a:1:{s:10:\"predicates\";a:1:{i:0;s:8:\"dc:title\";}}s:7:\"created\";a:3:{s:10:\"predicates\";a:2:{i:0;s:7:\"dc:date\";i:1;s:10:\"dc:created\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:7:\"changed\";a:3:{s:10:\"predicates\";a:1:{i:0;s:11:\"dc:modified\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:4:\"body\";a:1:{s:10:\"predicates\";a:1:{i:0;s:15:\"content:encoded\";}}s:3:\"uid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:has_creator\";}s:4:\"type\";s:3:\"rel\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:1:{i:0;s:9:\"foaf:name\";}}s:13:\"comment_count\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:num_replies\";}s:8:\"datatype\";s:11:\"xsd:integer\";}s:13:\"last_activity\";a:3:{s:10:\"predicates\";a:1:{i:0;s:23:\"sioc:last_activity_date\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}}}s:6:\"banner\";a:3:{s:5:\"label\";s:6:\"Banner\";s:5:\"admin\";a:4:{s:4:\"path\";s:39:\"admin/structure/types/manage/%node_type\";s:9:\"real path\";s:35:\"admin/structure/types/manage/banner\";s:15:\"bundle argument\";i:4;s:16:\"access arguments\";a:1:{i:0;s:24:\"administer content types\";}}s:11:\"rdf_mapping\";a:9:{s:7:\"rdftype\";a:2:{i:0;s:9:\"sioc:Item\";i:1;s:13:\"foaf:Document\";}s:5:\"title\";a:1:{s:10:\"predicates\";a:1:{i:0;s:8:\"dc:title\";}}s:7:\"created\";a:3:{s:10:\"predicates\";a:2:{i:0;s:7:\"dc:date\";i:1;s:10:\"dc:created\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:7:\"changed\";a:3:{s:10:\"predicates\";a:1:{i:0;s:11:\"dc:modified\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:4:\"body\";a:1:{s:10:\"predicates\";a:1:{i:0;s:15:\"content:encoded\";}}s:3:\"uid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:has_creator\";}s:4:\"type\";s:3:\"rel\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:1:{i:0;s:9:\"foaf:name\";}}s:13:\"comment_count\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:num_replies\";}s:8:\"datatype\";s:11:\"xsd:integer\";}s:13:\"last_activity\";a:3:{s:10:\"predicates\";a:1:{i:0;s:23:\"sioc:last_activity_date\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}}}s:10:\"diary_item\";a:3:{s:5:\"label\";s:17:\"Entrada da Axenda\";s:5:\"admin\";a:4:{s:4:\"path\";s:39:\"admin/structure/types/manage/%node_type\";s:9:\"real path\";s:39:\"admin/structure/types/manage/diary-item\";s:15:\"bundle argument\";i:4;s:16:\"access arguments\";a:1:{i:0;s:24:\"administer content types\";}}s:11:\"rdf_mapping\";a:9:{s:7:\"rdftype\";a:2:{i:0;s:9:\"sioc:Item\";i:1;s:13:\"foaf:Document\";}s:5:\"title\";a:1:{s:10:\"predicates\";a:1:{i:0;s:8:\"dc:title\";}}s:7:\"created\";a:3:{s:10:\"predicates\";a:2:{i:0;s:7:\"dc:date\";i:1;s:10:\"dc:created\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:7:\"changed\";a:3:{s:10:\"predicates\";a:1:{i:0;s:11:\"dc:modified\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:4:\"body\";a:1:{s:10:\"predicates\";a:1:{i:0;s:15:\"content:encoded\";}}s:3:\"uid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:has_creator\";}s:4:\"type\";s:3:\"rel\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:1:{i:0;s:9:\"foaf:name\";}}s:13:\"comment_count\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:num_replies\";}s:8:\"datatype\";s:11:\"xsd:integer\";}s:13:\"last_activity\";a:3:{s:10:\"predicates\";a:1:{i:0;s:23:\"sioc:last_activity_date\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}}}s:4:\"home\";a:3:{s:5:\"label\";s:4:\"Home\";s:5:\"admin\";a:4:{s:4:\"path\";s:39:\"admin/structure/types/manage/%node_type\";s:9:\"real path\";s:33:\"admin/structure/types/manage/home\";s:15:\"bundle argument\";i:4;s:16:\"access arguments\";a:1:{i:0;s:24:\"administer content types\";}}s:11:\"rdf_mapping\";a:9:{s:7:\"rdftype\";a:2:{i:0;s:9:\"sioc:Item\";i:1;s:13:\"foaf:Document\";}s:5:\"title\";a:1:{s:10:\"predicates\";a:1:{i:0;s:8:\"dc:title\";}}s:7:\"created\";a:3:{s:10:\"predicates\";a:2:{i:0;s:7:\"dc:date\";i:1;s:10:\"dc:created\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:7:\"changed\";a:3:{s:10:\"predicates\";a:1:{i:0;s:11:\"dc:modified\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:4:\"body\";a:1:{s:10:\"predicates\";a:1:{i:0;s:15:\"content:encoded\";}}s:3:\"uid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:has_creator\";}s:4:\"type\";s:3:\"rel\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:1:{i:0;s:9:\"foaf:name\";}}s:13:\"comment_count\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:num_replies\";}s:8:\"datatype\";s:11:\"xsd:integer\";}s:13:\"last_activity\";a:3:{s:10:\"predicates\";a:1:{i:0;s:23:\"sioc:last_activity_date\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}}}s:5:\"place\";a:3:{s:5:\"label\";s:5:\"Lugar\";s:5:\"admin\";a:4:{s:4:\"path\";s:39:\"admin/structure/types/manage/%node_type\";s:9:\"real path\";s:34:\"admin/structure/types/manage/place\";s:15:\"bundle argument\";i:4;s:16:\"access arguments\";a:1:{i:0;s:24:\"administer content types\";}}s:11:\"rdf_mapping\";a:9:{s:7:\"rdftype\";a:2:{i:0;s:9:\"sioc:Item\";i:1;s:13:\"foaf:Document\";}s:5:\"title\";a:1:{s:10:\"predicates\";a:1:{i:0;s:8:\"dc:title\";}}s:7:\"created\";a:3:{s:10:\"predicates\";a:2:{i:0;s:7:\"dc:date\";i:1;s:10:\"dc:created\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:7:\"changed\";a:3:{s:10:\"predicates\";a:1:{i:0;s:11:\"dc:modified\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:4:\"body\";a:1:{s:10:\"predicates\";a:1:{i:0;s:15:\"content:encoded\";}}s:3:\"uid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:has_creator\";}s:4:\"type\";s:3:\"rel\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:1:{i:0;s:9:\"foaf:name\";}}s:13:\"comment_count\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:num_replies\";}s:8:\"datatype\";s:11:\"xsd:integer\";}s:13:\"last_activity\";a:3:{s:10:\"predicates\";a:1:{i:0;s:23:\"sioc:last_activity_date\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}}}s:4:\"page\";a:3:{s:5:\"label\";s:7:\"Páxina\";s:5:\"admin\";a:4:{s:4:\"path\";s:39:\"admin/structure/types/manage/%node_type\";s:9:\"real path\";s:33:\"admin/structure/types/manage/page\";s:15:\"bundle argument\";i:4;s:16:\"access arguments\";a:1:{i:0;s:24:\"administer content types\";}}s:11:\"rdf_mapping\";a:9:{s:7:\"rdftype\";a:1:{i:0;s:13:\"foaf:Document\";}s:5:\"title\";a:1:{s:10:\"predicates\";a:1:{i:0;s:8:\"dc:title\";}}s:7:\"created\";a:3:{s:10:\"predicates\";a:2:{i:0;s:7:\"dc:date\";i:1;s:10:\"dc:created\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:7:\"changed\";a:3:{s:10:\"predicates\";a:1:{i:0;s:11:\"dc:modified\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:4:\"body\";a:1:{s:10:\"predicates\";a:1:{i:0;s:15:\"content:encoded\";}}s:3:\"uid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:has_creator\";}s:4:\"type\";s:3:\"rel\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:1:{i:0;s:9:\"foaf:name\";}}s:13:\"comment_count\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:num_replies\";}s:8:\"datatype\";s:11:\"xsd:integer\";}s:13:\"last_activity\";a:3:{s:10:\"predicates\";a:1:{i:0;s:23:\"sioc:last_activity_date\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}}}}s:10:\"view modes\";a:6:{s:4:\"full\";a:2:{s:5:\"label\";s:16:\"Contido completo\";s:15:\"custom settings\";b:0;}s:6:\"teaser\";a:2:{s:5:\"label\";s:6:\"Resumo\";s:15:\"custom settings\";b:1;}s:3:\"rss\";a:2:{s:5:\"label\";s:3:\"RSS\";s:15:\"custom settings\";b:0;}s:12:\"search_index\";a:2:{s:5:\"label\";s:17:\"Índice de búsca\";s:15:\"custom settings\";b:0;}s:13:\"search_result\";a:2:{s:5:\"label\";s:33:\"Resaltando o resultado da procura\";s:15:\"custom settings\";b:0;}s:5:\"token\";a:2:{s:5:\"label\";s:9:\"Comodines\";s:15:\"custom settings\";b:0;}}s:12:\"static cache\";b:1;s:11:\"field cache\";b:1;s:9:\"load hook\";s:9:\"node_load\";s:11:\"translation\";a:1:{s:6:\"locale\";b:1;}s:22:\"base table field types\";a:15:{s:3:\"nid\";s:6:\"serial\";s:3:\"vid\";s:3:\"int\";s:4:\"type\";s:7:\"varchar\";s:8:\"language\";s:7:\"varchar\";s:5:\"title\";s:7:\"varchar\";s:3:\"uid\";s:3:\"int\";s:6:\"status\";s:3:\"int\";s:7:\"created\";s:3:\"int\";s:7:\"changed\";s:3:\"int\";s:7:\"comment\";s:3:\"int\";s:7:\"promote\";s:3:\"int\";s:6:\"sticky\";s:3:\"int\";s:4:\"tnid\";s:3:\"int\";s:9:\"translate\";s:3:\"int\";s:4:\"uuid\";s:4:\"char\";}s:17:\"schema_fields_sql\";a:2:{s:10:\"base table\";a:15:{i:0;s:3:\"nid\";i:1;s:3:\"vid\";i:2;s:4:\"type\";i:3;s:8:\"language\";i:4;s:5:\"title\";i:5;s:3:\"uid\";i:6;s:6:\"status\";i:7;s:7:\"created\";i:8;s:7:\"changed\";i:9;s:7:\"comment\";i:10;s:7:\"promote\";i:11;s:6:\"sticky\";i:12;s:4:\"tnid\";i:13;s:9:\"translate\";i:14;s:4:\"uuid\";}s:14:\"revision table\";a:11:{i:0;s:3:\"nid\";i:1;s:3:\"vid\";i:2;s:3:\"uid\";i:3;s:5:\"title\";i:4;s:3:\"log\";i:5;s:9:\"timestamp\";i:6;s:6:\"status\";i:7;s:7:\"comment\";i:8;s:7:\"promote\";i:9;s:6:\"sticky\";i:10;s:5:\"vuuid\";}}s:10:\"token type\";s:4:\"node\";s:12:\"plural label\";s:5:\"Nodos\";s:11:\"description\";s:44:\"Nodes represent the main site content items.\";s:15:\"access callback\";s:35:\"entity_metadata_no_hook_node_access\";s:17:\"creation callback\";s:27:\"entity_metadata_create_node\";s:13:\"save callback\";s:9:\"node_save\";s:17:\"deletion callback\";s:11:\"node_delete\";s:26:\"revision deletion callback\";s:20:\"node_revision_delete\";s:13:\"form callback\";s:25:\"entity_metadata_form_node\";s:13:\"view callback\";s:25:\"entity_metadata_view_node\";s:13:\"configuration\";b:0;s:4:\"uuid\";b:1;}s:4:\"file\";a:22:{s:5:\"label\";s:8:\"Ficheiro\";s:10:\"base table\";s:12:\"file_managed\";s:11:\"entity keys\";a:5:{s:2:\"id\";s:3:\"fid\";s:5:\"label\";s:8:\"filename\";s:8:\"revision\";s:0:\"\";s:6:\"bundle\";s:0:\"\";s:4:\"uuid\";s:4:\"uuid\";}s:12:\"static cache\";b:0;s:9:\"fieldable\";b:0;s:16:\"controller class\";s:29:\"DrupalDefaultEntityController\";s:11:\"field cache\";b:1;s:9:\"load hook\";s:9:\"file_load\";s:7:\"bundles\";a:1:{s:4:\"file\";a:2:{s:5:\"label\";s:8:\"Ficheiro\";s:11:\"rdf_mapping\";a:0:{}}}s:10:\"view modes\";a:0:{}s:11:\"translation\";a:0:{}s:22:\"base table field types\";a:9:{s:3:\"fid\";s:6:\"serial\";s:3:\"uid\";s:3:\"int\";s:8:\"filename\";s:7:\"varchar\";s:3:\"uri\";s:7:\"varchar\";s:8:\"filemime\";s:7:\"varchar\";s:8:\"filesize\";s:3:\"int\";s:6:\"status\";s:3:\"int\";s:9:\"timestamp\";s:3:\"int\";s:4:\"uuid\";s:4:\"char\";}s:17:\"schema_fields_sql\";a:1:{s:10:\"base table\";a:9:{i:0;s:3:\"fid\";i:1;s:3:\"uid\";i:2;s:8:\"filename\";i:3;s:3:\"uri\";i:4;s:8:\"filemime\";i:5;s:8:\"filesize\";i:6;s:6:\"status\";i:7;s:9:\"timestamp\";i:8;s:4:\"uuid\";}}s:10:\"token type\";s:4:\"file\";s:12:\"plural label\";s:9:\"Ficheiros\";s:11:\"description\";s:14:\"Uploaded file.\";s:15:\"access callback\";s:27:\"entity_metadata_file_access\";s:13:\"save callback\";s:9:\"file_save\";s:17:\"deletion callback\";s:27:\"entity_metadata_delete_file\";s:12:\"uri callback\";s:24:\"entity_metadata_uri_file\";s:13:\"configuration\";b:0;s:4:\"uuid\";b:1;}s:13:\"taxonomy_term\";a:27:{s:5:\"label\";s:19:\"Termo de taxonomía\";s:16:\"controller class\";s:22:\"TaxonomyTermController\";s:10:\"base table\";s:18:\"taxonomy_term_data\";s:12:\"uri callback\";s:17:\"taxonomy_term_uri\";s:9:\"fieldable\";b:1;s:11:\"entity keys\";a:6:{s:2:\"id\";s:3:\"tid\";s:6:\"bundle\";s:23:\"vocabulary_machine_name\";s:5:\"label\";s:4:\"name\";s:8:\"revision\";s:0:\"\";s:8:\"language\";s:8:\"language\";s:4:\"uuid\";s:4:\"uuid\";}s:11:\"bundle keys\";a:1:{s:6:\"bundle\";s:12:\"machine_name\";}s:7:\"bundles\";a:4:{s:4:\"tags\";a:3:{s:5:\"label\";s:9:\"Etiquetas\";s:5:\"admin\";a:4:{s:4:\"path\";s:58:\"admin/structure/taxonomy/%taxonomy_vocabulary_machine_name\";s:9:\"real path\";s:29:\"admin/structure/taxonomy/tags\";s:15:\"bundle argument\";i:3;s:16:\"access arguments\";a:1:{i:0;s:19:\"administer taxonomy\";}}s:11:\"rdf_mapping\";a:5:{s:7:\"rdftype\";a:1:{i:0;s:12:\"skos:Concept\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:2:{i:0;s:10:\"rdfs:label\";i:1;s:14:\"skos:prefLabel\";}}s:11:\"description\";a:1:{s:10:\"predicates\";a:1:{i:0;s:15:\"skos:definition\";}}s:3:\"vid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:13:\"skos:inScheme\";}s:4:\"type\";s:3:\"rel\";}s:6:\"parent\";a:2:{s:10:\"predicates\";a:1:{i:0;s:12:\"skos:broader\";}s:4:\"type\";s:3:\"rel\";}}}s:6:\"places\";a:3:{s:5:\"label\";s:4:\"Mapa\";s:5:\"admin\";a:4:{s:4:\"path\";s:58:\"admin/structure/taxonomy/%taxonomy_vocabulary_machine_name\";s:9:\"real path\";s:31:\"admin/structure/taxonomy/places\";s:15:\"bundle argument\";i:3;s:16:\"access arguments\";a:1:{i:0;s:19:\"administer taxonomy\";}}s:11:\"rdf_mapping\";a:5:{s:7:\"rdftype\";a:1:{i:0;s:12:\"skos:Concept\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:2:{i:0;s:10:\"rdfs:label\";i:1;s:14:\"skos:prefLabel\";}}s:11:\"description\";a:1:{s:10:\"predicates\";a:1:{i:0;s:15:\"skos:definition\";}}s:3:\"vid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:13:\"skos:inScheme\";}s:4:\"type\";s:3:\"rel\";}s:6:\"parent\";a:2:{s:10:\"predicates\";a:1:{i:0;s:12:\"skos:broader\";}s:4:\"type\";s:3:\"rel\";}}}s:10:\"categories\";a:3:{s:5:\"label\";s:7:\"Arquivo\";s:5:\"admin\";a:4:{s:4:\"path\";s:58:\"admin/structure/taxonomy/%taxonomy_vocabulary_machine_name\";s:9:\"real path\";s:35:\"admin/structure/taxonomy/categories\";s:15:\"bundle argument\";i:3;s:16:\"access arguments\";a:1:{i:0;s:19:\"administer taxonomy\";}}s:11:\"rdf_mapping\";a:5:{s:7:\"rdftype\";a:1:{i:0;s:12:\"skos:Concept\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:2:{i:0;s:10:\"rdfs:label\";i:1;s:14:\"skos:prefLabel\";}}s:11:\"description\";a:1:{s:10:\"predicates\";a:1:{i:0;s:15:\"skos:definition\";}}s:3:\"vid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:13:\"skos:inScheme\";}s:4:\"type\";s:3:\"rel\";}s:6:\"parent\";a:2:{s:10:\"predicates\";a:1:{i:0;s:12:\"skos:broader\";}s:4:\"type\";s:3:\"rel\";}}}s:14:\"rss_categories\";a:3:{s:5:\"label\";s:15:\"RSS Categorías\";s:5:\"admin\";a:4:{s:4:\"path\";s:58:\"admin/structure/taxonomy/%taxonomy_vocabulary_machine_name\";s:9:\"real path\";s:39:\"admin/structure/taxonomy/rss_categories\";s:15:\"bundle argument\";i:3;s:16:\"access arguments\";a:1:{i:0;s:19:\"administer taxonomy\";}}s:11:\"rdf_mapping\";a:5:{s:7:\"rdftype\";a:1:{i:0;s:12:\"skos:Concept\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:2:{i:0;s:10:\"rdfs:label\";i:1;s:14:\"skos:prefLabel\";}}s:11:\"description\";a:1:{s:10:\"predicates\";a:1:{i:0;s:15:\"skos:definition\";}}s:3:\"vid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:13:\"skos:inScheme\";}s:4:\"type\";s:3:\"rel\";}s:6:\"parent\";a:2:{s:10:\"predicates\";a:1:{i:0;s:12:\"skos:broader\";}s:4:\"type\";s:3:\"rel\";}}}}s:10:\"view modes\";a:2:{s:4:\"full\";a:2:{s:5:\"label\";s:32:\"Páxina de térmos de taxonomía\";s:15:\"custom settings\";b:0;}s:5:\"token\";a:2:{s:5:\"label\";s:9:\"Comodines\";s:15:\"custom settings\";b:0;}}s:12:\"static cache\";b:1;s:11:\"field cache\";b:1;s:9:\"load hook\";s:18:\"taxonomy_term_load\";s:11:\"translation\";a:0:{}s:22:\"base table field types\";a:9:{s:3:\"tid\";s:6:\"serial\";s:3:\"vid\";s:3:\"int\";s:4:\"name\";s:7:\"varchar\";s:11:\"description\";s:4:\"text\";s:6:\"format\";s:7:\"varchar\";s:6:\"weight\";s:3:\"int\";s:4:\"uuid\";s:4:\"char\";s:8:\"language\";s:7:\"varchar\";s:9:\"i18n_tsid\";s:3:\"int\";}s:17:\"schema_fields_sql\";a:1:{s:10:\"base table\";a:9:{i:0;s:3:\"tid\";i:1;s:3:\"vid\";i:2;s:4:\"name\";i:3;s:11:\"description\";i:4;s:6:\"format\";i:5;s:6:\"weight\";i:6;s:4:\"uuid\";i:7;s:8:\"language\";i:8;s:9:\"i18n_tsid\";}}s:10:\"token type\";s:4:\"term\";s:14:\"label callback\";s:33:\"i18n_taxonomy_taxonomy_term_label\";s:12:\"plural label\";s:20:\"Termos de taxonomía\";s:11:\"description\";s:48:\"Taxonomy terms are used for classifying content.\";s:15:\"access callback\";s:31:\"entity_metadata_taxonomy_access\";s:17:\"creation callback\";s:29:\"entity_metadata_create_object\";s:13:\"save callback\";s:18:\"taxonomy_term_save\";s:17:\"deletion callback\";s:20:\"taxonomy_term_delete\";s:13:\"view callback\";s:27:\"entity_metadata_view_single\";s:13:\"form callback\";s:34:\"entity_metadata_form_taxonomy_term\";s:13:\"configuration\";b:0;s:4:\"uuid\";b:1;}s:19:\"taxonomy_vocabulary\";a:22:{s:5:\"label\";s:25:\"Vocabulario de taxonomía\";s:16:\"controller class\";s:28:\"TaxonomyVocabularyController\";s:10:\"base table\";s:19:\"taxonomy_vocabulary\";s:11:\"entity keys\";a:4:{s:2:\"id\";s:3:\"vid\";s:5:\"label\";s:4:\"name\";s:8:\"revision\";s:0:\"\";s:6:\"bundle\";s:0:\"\";}s:9:\"fieldable\";b:0;s:12:\"static cache\";b:1;s:11:\"field cache\";b:1;s:9:\"load hook\";s:24:\"taxonomy_vocabulary_load\";s:7:\"bundles\";a:1:{s:19:\"taxonomy_vocabulary\";a:2:{s:5:\"label\";s:25:\"Vocabulario de taxonomía\";s:11:\"rdf_mapping\";a:3:{s:7:\"rdftype\";a:1:{i:0;s:18:\"skos:ConceptScheme\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:1:{i:0;s:8:\"dc:title\";}}s:11:\"description\";a:1:{s:10:\"predicates\";a:1:{i:0;s:12:\"rdfs:comment\";}}}}}s:10:\"view modes\";a:0:{}s:11:\"translation\";a:0:{}s:22:\"base table field types\";a:9:{s:3:\"vid\";s:6:\"serial\";s:4:\"name\";s:7:\"varchar\";s:12:\"machine_name\";s:7:\"varchar\";s:11:\"description\";s:4:\"text\";s:9:\"hierarchy\";s:3:\"int\";s:6:\"module\";s:7:\"varchar\";s:6:\"weight\";s:3:\"int\";s:8:\"language\";s:7:\"varchar\";s:9:\"i18n_mode\";s:3:\"int\";}s:17:\"schema_fields_sql\";a:1:{s:10:\"base table\";a:9:{i:0;s:3:\"vid\";i:1;s:4:\"name\";i:2;s:12:\"machine_name\";i:3;s:11:\"description\";i:4;s:9:\"hierarchy\";i:5;s:6:\"module\";i:6;s:6:\"weight\";i:7;s:8:\"language\";i:8;s:9:\"i18n_mode\";}}s:10:\"token type\";s:10:\"vocabulary\";s:12:\"plural label\";s:21:\"Taxonomy vocabularies\";s:11:\"description\";s:84:\"Vocabularies contain related taxonomy terms, which are used for classifying content.\";s:15:\"access callback\";s:31:\"entity_metadata_taxonomy_access\";s:17:\"creation callback\";s:29:\"entity_metadata_create_object\";s:13:\"save callback\";s:24:\"taxonomy_vocabulary_save\";s:17:\"deletion callback\";s:26:\"taxonomy_vocabulary_delete\";s:13:\"form callback\";s:40:\"entity_metadata_form_taxonomy_vocabulary\";s:13:\"configuration\";b:0;}s:4:\"user\";a:26:{s:5:\"label\";s:9:\"Usuario/a\";s:16:\"controller class\";s:14:\"UserController\";s:10:\"base table\";s:5:\"users\";s:12:\"uri callback\";s:8:\"user_uri\";s:14:\"label callback\";s:15:\"format_username\";s:9:\"fieldable\";b:1;s:11:\"entity keys\";a:4:{s:2:\"id\";s:3:\"uid\";s:8:\"revision\";s:0:\"\";s:6:\"bundle\";s:0:\"\";s:4:\"uuid\";s:4:\"uuid\";}s:7:\"bundles\";a:1:{s:4:\"user\";a:3:{s:5:\"label\";s:9:\"Usuario/a\";s:5:\"admin\";a:2:{s:4:\"path\";s:28:\"admin/config/people/accounts\";s:16:\"access arguments\";a:1:{i:0;s:16:\"administer users\";}}s:11:\"rdf_mapping\";a:3:{s:7:\"rdftype\";a:1:{i:0;s:16:\"sioc:UserAccount\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:1:{i:0;s:9:\"foaf:name\";}}s:8:\"homepage\";a:2:{s:10:\"predicates\";a:1:{i:0;s:9:\"foaf:page\";}s:4:\"type\";s:3:\"rel\";}}}}s:10:\"view modes\";a:2:{s:4:\"full\";a:2:{s:5:\"label\";s:16:\"Conta de usuario\";s:15:\"custom settings\";b:0;}s:5:\"token\";a:2:{s:5:\"label\";s:9:\"Comodines\";s:15:\"custom settings\";b:0;}}s:12:\"static cache\";b:1;s:11:\"field cache\";b:1;s:9:\"load hook\";s:9:\"user_load\";s:11:\"translation\";a:0:{}s:22:\"base table field types\";a:17:{s:3:\"uid\";s:3:\"int\";s:4:\"name\";s:7:\"varchar\";s:4:\"pass\";s:7:\"varchar\";s:4:\"mail\";s:7:\"varchar\";s:5:\"theme\";s:7:\"varchar\";s:9:\"signature\";s:7:\"varchar\";s:16:\"signature_format\";s:7:\"varchar\";s:7:\"created\";s:3:\"int\";s:6:\"access\";s:3:\"int\";s:5:\"login\";s:3:\"int\";s:6:\"status\";s:3:\"int\";s:8:\"timezone\";s:7:\"varchar\";s:8:\"language\";s:7:\"varchar\";s:7:\"picture\";s:3:\"int\";s:4:\"init\";s:7:\"varchar\";s:4:\"data\";s:4:\"blob\";s:4:\"uuid\";s:4:\"char\";}s:17:\"schema_fields_sql\";a:1:{s:10:\"base table\";a:17:{i:0;s:3:\"uid\";i:1;s:4:\"name\";i:2;s:4:\"pass\";i:3;s:4:\"mail\";i:4;s:5:\"theme\";i:5;s:9:\"signature\";i:6;s:16:\"signature_format\";i:7;s:7:\"created\";i:8;s:6:\"access\";i:9;s:5:\"login\";i:10;s:6:\"status\";i:11;s:8:\"timezone\";i:12;s:8:\"language\";i:13;s:7:\"picture\";i:14;s:4:\"init\";i:15;s:4:\"data\";i:16;s:4:\"uuid\";}}s:10:\"token type\";s:4:\"user\";s:12:\"plural label\";s:8:\"Usuarios\";s:11:\"description\";s:55:\"Usuarios que se rexistraron e teñen conta neste sitio.\";s:15:\"access callback\";s:27:\"entity_metadata_user_access\";s:17:\"creation callback\";s:29:\"entity_metadata_create_object\";s:13:\"save callback\";s:25:\"entity_metadata_user_save\";s:17:\"deletion callback\";s:11:\"user_delete\";s:13:\"form callback\";s:25:\"entity_metadata_form_user\";s:13:\"view callback\";s:27:\"entity_metadata_view_single\";s:13:\"configuration\";b:0;s:4:\"uuid\";b:1;}s:15:\"wysiwyg_profile\";a:15:{s:5:\"label\";s:15:\"Perfíl Wysiwyg\";s:10:\"base table\";s:7:\"wysiwyg\";s:16:\"controller class\";s:24:\"WysiwygProfileController\";s:9:\"fieldable\";b:0;s:12:\"static cache\";b:0;s:11:\"entity keys\";a:3:{s:2:\"id\";s:6:\"format\";s:8:\"revision\";s:0:\"\";s:6:\"bundle\";s:0:\"\";}s:11:\"field cache\";b:1;s:9:\"load hook\";s:20:\"wysiwyg_profile_load\";s:7:\"bundles\";a:1:{s:15:\"wysiwyg_profile\";a:2:{s:5:\"label\";s:15:\"Perfíl Wysiwyg\";s:11:\"rdf_mapping\";a:0:{}}}s:10:\"view modes\";a:0:{}s:11:\"translation\";a:0:{}s:22:\"base table field types\";a:3:{s:6:\"format\";s:7:\"varchar\";s:6:\"editor\";s:7:\"varchar\";s:8:\"settings\";s:4:\"text\";}s:17:\"schema_fields_sql\";a:1:{s:10:\"base table\";a:3:{i:0;s:6:\"format\";i:1;s:6:\"editor\";i:2;s:8:\"settings\";}}s:10:\"token type\";s:15:\"wysiwyg_profile\";s:13:\"configuration\";b:0;}}',0,1469579868,1),('filter_formats:es','a:3:{s:13:\"filtered_html\";O:8:\"stdClass\":5:{s:6:\"format\";s:13:\"filtered_html\";s:4:\"name\";s:13:\"Filtered HTML\";s:5:\"cache\";s:1:\"1\";s:6:\"status\";s:1:\"1\";s:6:\"weight\";s:1:\"0\";}s:9:\"full_html\";O:8:\"stdClass\":5:{s:6:\"format\";s:9:\"full_html\";s:4:\"name\";s:9:\"Full HTML\";s:5:\"cache\";s:1:\"1\";s:6:\"status\";s:1:\"1\";s:6:\"weight\";s:1:\"1\";}s:10:\"plain_text\";O:8:\"stdClass\":5:{s:6:\"format\";s:10:\"plain_text\";s:4:\"name\";s:10:\"Plain text\";s:5:\"cache\";s:1:\"1\";s:6:\"status\";s:1:\"1\";s:6:\"weight\";s:2:\"10\";}}',0,1469579890,1),('filter_formats:gl','a:3:{s:13:\"filtered_html\";O:8:\"stdClass\":5:{s:6:\"format\";s:13:\"filtered_html\";s:4:\"name\";s:13:\"Filtered HTML\";s:5:\"cache\";s:1:\"1\";s:6:\"status\";s:1:\"1\";s:6:\"weight\";s:1:\"0\";}s:9:\"full_html\";O:8:\"stdClass\":5:{s:6:\"format\";s:9:\"full_html\";s:4:\"name\";s:9:\"Full HTML\";s:5:\"cache\";s:1:\"1\";s:6:\"status\";s:1:\"1\";s:6:\"weight\";s:1:\"1\";}s:10:\"plain_text\";O:8:\"stdClass\":5:{s:6:\"format\";s:10:\"plain_text\";s:4:\"name\";s:10:\"Plain text\";s:5:\"cache\";s:1:\"1\";s:6:\"status\";s:1:\"1\";s:6:\"weight\";s:2:\"10\";}}',0,1469579868,1),('filter_list_format','a:3:{s:9:\"full_html\";a:8:{s:11:\"filter_html\";O:8:\"stdClass\":6:{s:6:\"format\";s:9:\"full_html\";s:6:\"module\";s:6:\"filter\";s:4:\"name\";s:11:\"filter_html\";s:6:\"weight\";s:3:\"-10\";s:6:\"status\";s:1:\"0\";s:8:\"settings\";s:168:\"a:3:{s:12:\"allowed_html\";s:74:\"<a> <em> <strong> <cite> <blockquote> <code> <ul> <ol> <li> <dl> <dt> <dd>\";s:16:\"filter_html_help\";i:1;s:20:\"filter_html_nofollow\";i:0;}\";}s:18:\"filter_html_escape\";O:8:\"stdClass\":6:{s:6:\"format\";s:9:\"full_html\";s:6:\"module\";s:6:\"filter\";s:4:\"name\";s:18:\"filter_html_escape\";s:6:\"weight\";s:3:\"-10\";s:6:\"status\";s:1:\"0\";s:8:\"settings\";s:6:\"a:0:{}\";}s:12:\"video_filter\";O:8:\"stdClass\":6:{s:6:\"format\";s:9:\"full_html\";s:6:\"module\";s:12:\"video_filter\";s:4:\"name\";s:12:\"video_filter\";s:6:\"weight\";s:2:\"-1\";s:6:\"status\";s:1:\"1\";s:8:\"settings\";s:1073:\"a:7:{s:18:\"video_filter_width\";s:3:\"400\";s:19:\"video_filter_height\";s:3:\"400\";s:21:\"video_filter_autoplay\";s:1:\"0\";s:20:\"video_filter_related\";s:1:\"0\";s:18:\"video_filter_html5\";s:1:\"1\";s:19:\"video_filter_codecs\";a:38:{s:5:\"vimeo\";s:5:\"vimeo\";s:7:\"youtube\";s:7:\"youtube\";s:16:\"youtube_playlist\";s:16:\"youtube_playlist\";s:7:\"archive\";i:0;s:6:\"bliptv\";i:0;s:12:\"candidcareer\";i:0;s:6:\"capped\";i:0;s:12:\"collegehumor\";i:0;s:4:\"coub\";i:0;s:11:\"dailymotion\";i:0;s:21:\"democracynow_fullshow\";i:0;s:18:\"democracynow_story\";i:0;s:17:\"flickr_slideshows\";i:0;s:12:\"flickr_video\";i:0;s:7:\"foxnews\";i:0;s:12:\"gametrailers\";i:0;s:10:\"gamevideos\";i:0;s:5:\"giphy\";i:0;s:7:\"godtube\";i:0;s:6:\"google\";i:0;s:9:\"instagram\";i:0;s:8:\"metacafe\";i:0;s:6:\"mailru\";i:0;s:7:\"myspace\";i:0;s:7:\"myvideo\";i:0;s:17:\"picasa_slideshows\";i:0;s:6:\"rutube\";i:0;s:10:\"slideshare\";i:0;s:12:\"streamhoster\";i:0;s:11:\"teachertube\";i:0;s:3:\"ted\";i:0;s:6:\"twitch\";i:0;s:7:\"ustream\";i:0;s:4:\"vbox\";i:0;s:4:\"vine\";i:0;s:9:\"whatchado\";i:0;s:6:\"wistia\";i:0;s:5:\"youku\";i:0;}s:29:\"video_filter_multiple_sources\";s:1:\"1\";}\";}s:10:\"filter_url\";O:8:\"stdClass\":6:{s:6:\"format\";s:9:\"full_html\";s:6:\"module\";s:6:\"filter\";s:4:\"name\";s:10:\"filter_url\";s:6:\"weight\";s:1:\"0\";s:6:\"status\";s:1:\"1\";s:8:\"settings\";s:40:\"a:1:{s:17:\"filter_url_length\";s:2:\"72\";}\";}s:15:\"transliteration\";O:8:\"stdClass\":6:{s:6:\"format\";s:9:\"full_html\";s:6:\"module\";s:15:\"transliteration\";s:4:\"name\";s:15:\"transliteration\";s:6:\"weight\";s:1:\"0\";s:6:\"status\";s:1:\"0\";s:8:\"settings\";s:46:\"a:1:{s:24:\"no_known_transliteration\";s:1:\"?\";}\";}s:17:\"video_embed_field\";O:8:\"stdClass\":6:{s:6:\"format\";s:9:\"full_html\";s:6:\"module\";s:17:\"video_embed_field\";s:4:\"name\";s:17:\"video_embed_field\";s:6:\"weight\";s:1:\"0\";s:6:\"status\";s:1:\"0\";s:8:\"settings\";s:6:\"a:0:{}\";}s:12:\"filter_autop\";O:8:\"stdClass\":6:{s:6:\"format\";s:9:\"full_html\";s:6:\"module\";s:6:\"filter\";s:4:\"name\";s:12:\"filter_autop\";s:6:\"weight\";s:1:\"1\";s:6:\"status\";s:1:\"1\";s:8:\"settings\";s:6:\"a:0:{}\";}s:20:\"filter_htmlcorrector\";O:8:\"stdClass\":6:{s:6:\"format\";s:9:\"full_html\";s:6:\"module\";s:6:\"filter\";s:4:\"name\";s:20:\"filter_htmlcorrector\";s:6:\"weight\";s:2:\"10\";s:6:\"status\";s:1:\"1\";s:8:\"settings\";s:6:\"a:0:{}\";}}s:10:\"plain_text\";a:5:{s:11:\"filter_html\";O:8:\"stdClass\":6:{s:6:\"format\";s:10:\"plain_text\";s:6:\"module\";s:6:\"filter\";s:4:\"name\";s:11:\"filter_html\";s:6:\"weight\";s:3:\"-10\";s:6:\"status\";s:1:\"0\";s:8:\"settings\";s:168:\"a:3:{s:12:\"allowed_html\";s:74:\"<a> <em> <strong> <cite> <blockquote> <code> <ul> <ol> <li> <dl> <dt> <dd>\";s:16:\"filter_html_help\";i:1;s:20:\"filter_html_nofollow\";i:0;}\";}s:18:\"filter_html_escape\";O:8:\"stdClass\":6:{s:6:\"format\";s:10:\"plain_text\";s:6:\"module\";s:6:\"filter\";s:4:\"name\";s:18:\"filter_html_escape\";s:6:\"weight\";s:1:\"0\";s:6:\"status\";s:1:\"1\";s:8:\"settings\";s:6:\"a:0:{}\";}s:10:\"filter_url\";O:8:\"stdClass\":6:{s:6:\"format\";s:10:\"plain_text\";s:6:\"module\";s:6:\"filter\";s:4:\"name\";s:10:\"filter_url\";s:6:\"weight\";s:1:\"1\";s:6:\"status\";s:1:\"1\";s:8:\"settings\";s:36:\"a:1:{s:17:\"filter_url_length\";i:72;}\";}s:12:\"filter_autop\";O:8:\"stdClass\":6:{s:6:\"format\";s:10:\"plain_text\";s:6:\"module\";s:6:\"filter\";s:4:\"name\";s:12:\"filter_autop\";s:6:\"weight\";s:1:\"2\";s:6:\"status\";s:1:\"1\";s:8:\"settings\";s:6:\"a:0:{}\";}s:20:\"filter_htmlcorrector\";O:8:\"stdClass\":6:{s:6:\"format\";s:10:\"plain_text\";s:6:\"module\";s:6:\"filter\";s:4:\"name\";s:20:\"filter_htmlcorrector\";s:6:\"weight\";s:2:\"10\";s:6:\"status\";s:1:\"0\";s:8:\"settings\";s:6:\"a:0:{}\";}}s:13:\"filtered_html\";a:9:{s:18:\"filter_html_escape\";O:8:\"stdClass\":6:{s:6:\"format\";s:13:\"filtered_html\";s:6:\"module\";s:6:\"filter\";s:4:\"name\";s:18:\"filter_html_escape\";s:6:\"weight\";s:3:\"-10\";s:6:\"status\";s:1:\"0\";s:8:\"settings\";s:6:\"a:0:{}\";}s:12:\"video_filter\";O:8:\"stdClass\":6:{s:6:\"format\";s:13:\"filtered_html\";s:6:\"module\";s:12:\"video_filter\";s:4:\"name\";s:12:\"video_filter\";s:6:\"weight\";s:2:\"-1\";s:6:\"status\";s:1:\"1\";s:8:\"settings\";s:1073:\"a:7:{s:18:\"video_filter_width\";s:3:\"400\";s:19:\"video_filter_height\";s:3:\"400\";s:21:\"video_filter_autoplay\";s:1:\"0\";s:20:\"video_filter_related\";s:1:\"0\";s:18:\"video_filter_html5\";s:1:\"1\";s:19:\"video_filter_codecs\";a:38:{s:5:\"vimeo\";s:5:\"vimeo\";s:7:\"youtube\";s:7:\"youtube\";s:16:\"youtube_playlist\";s:16:\"youtube_playlist\";s:7:\"archive\";i:0;s:6:\"bliptv\";i:0;s:12:\"candidcareer\";i:0;s:6:\"capped\";i:0;s:12:\"collegehumor\";i:0;s:4:\"coub\";i:0;s:11:\"dailymotion\";i:0;s:21:\"democracynow_fullshow\";i:0;s:18:\"democracynow_story\";i:0;s:17:\"flickr_slideshows\";i:0;s:12:\"flickr_video\";i:0;s:7:\"foxnews\";i:0;s:12:\"gametrailers\";i:0;s:10:\"gamevideos\";i:0;s:5:\"giphy\";i:0;s:7:\"godtube\";i:0;s:6:\"google\";i:0;s:9:\"instagram\";i:0;s:8:\"metacafe\";i:0;s:6:\"mailru\";i:0;s:7:\"myspace\";i:0;s:7:\"myvideo\";i:0;s:17:\"picasa_slideshows\";i:0;s:6:\"rutube\";i:0;s:10:\"slideshare\";i:0;s:12:\"streamhoster\";i:0;s:11:\"teachertube\";i:0;s:3:\"ted\";i:0;s:6:\"twitch\";i:0;s:7:\"ustream\";i:0;s:4:\"vbox\";i:0;s:4:\"vine\";i:0;s:9:\"whatchado\";i:0;s:6:\"wistia\";i:0;s:5:\"youku\";i:0;}s:29:\"video_filter_multiple_sources\";s:1:\"1\";}\";}s:10:\"filter_url\";O:8:\"stdClass\":6:{s:6:\"format\";s:13:\"filtered_html\";s:6:\"module\";s:6:\"filter\";s:4:\"name\";s:10:\"filter_url\";s:6:\"weight\";s:1:\"0\";s:6:\"status\";s:1:\"1\";s:8:\"settings\";s:40:\"a:1:{s:17:\"filter_url_length\";s:2:\"72\";}\";}s:10:\"gmap_macro\";O:8:\"stdClass\":6:{s:6:\"format\";s:13:\"filtered_html\";s:6:\"module\";s:4:\"gmap\";s:4:\"name\";s:10:\"gmap_macro\";s:6:\"weight\";s:1:\"0\";s:6:\"status\";s:1:\"0\";s:8:\"settings\";s:6:\"a:0:{}\";}s:15:\"transliteration\";O:8:\"stdClass\":6:{s:6:\"format\";s:13:\"filtered_html\";s:6:\"module\";s:15:\"transliteration\";s:4:\"name\";s:15:\"transliteration\";s:6:\"weight\";s:1:\"0\";s:6:\"status\";s:1:\"0\";s:8:\"settings\";s:46:\"a:1:{s:24:\"no_known_transliteration\";s:1:\"?\";}\";}s:17:\"video_embed_field\";O:8:\"stdClass\":6:{s:6:\"format\";s:13:\"filtered_html\";s:6:\"module\";s:17:\"video_embed_field\";s:4:\"name\";s:17:\"video_embed_field\";s:6:\"weight\";s:1:\"0\";s:6:\"status\";s:1:\"0\";s:8:\"settings\";s:6:\"a:0:{}\";}s:11:\"filter_html\";O:8:\"stdClass\":6:{s:6:\"format\";s:13:\"filtered_html\";s:6:\"module\";s:6:\"filter\";s:4:\"name\";s:11:\"filter_html\";s:6:\"weight\";s:1:\"1\";s:6:\"status\";s:1:\"1\";s:8:\"settings\";s:241:\"a:3:{s:12:\"allowed_html\";s:146:\"<a> <em> <strong> <cite> <blockquote> <code> <ul> <ol> <li> <dl> <dt> <dd> <h2> <h3> <h4> <h5> <h6> <address> <p> <br> <div> <span> <img> <iframe>\";s:16:\"filter_html_help\";i:0;s:20:\"filter_html_nofollow\";i:0;}\";}s:12:\"filter_autop\";O:8:\"stdClass\":6:{s:6:\"format\";s:13:\"filtered_html\";s:6:\"module\";s:6:\"filter\";s:4:\"name\";s:12:\"filter_autop\";s:6:\"weight\";s:1:\"2\";s:6:\"status\";s:1:\"1\";s:8:\"settings\";s:6:\"a:0:{}\";}s:20:\"filter_htmlcorrector\";O:8:\"stdClass\":6:{s:6:\"format\";s:13:\"filtered_html\";s:6:\"module\";s:6:\"filter\";s:4:\"name\";s:20:\"filter_htmlcorrector\";s:6:\"weight\";s:2:\"10\";s:6:\"status\";s:1:\"1\";s:8:\"settings\";s:6:\"a:0:{}\";}}}',0,1469579868,1),('gmap_icondata','a:4:{s:36:\"sites/all/modules/gmap/markers/flat/\";a:4:{s:1:\"f\";a:1:{i:0;s:5:\"x.png\";}s:1:\"w\";a:1:{i:0;i:16;}s:1:\"h\";a:1:{i:0;i:16;}s:1:\"i\";a:1:{i:0;a:2:{i:0;a:7:{i:0;a:2:{i:0;s:8:\"defaults\";i:1;s:8:\"treasure\";}i:1;a:2:{i:0;s:0:\"\";i:1;s:16:\"X marks the spot\";}i:2;a:2:{i:0;a:0:{}i:1;a:1:{i:0;i:0;}}i:3;a:2:{i:0;i:8;i:1;i:0;}i:4;a:2:{i:0;i:8;i:1;i:0;}i:5;a:2:{i:0;i:8;i:1;i:0;}i:6;a:2:{i:0;i:8;i:1;i:0;}}i:1;a:13:{i:0;a:0:{}i:1;a:0:{}i:2;a:0:{}i:3;a:0:{}i:4;a:0:{}i:5;a:0:{}i:6;a:0:{}i:7;a:0:{}i:8;a:0:{}i:9;a:0:{}i:10;a:0:{}i:11;a:0:{}i:12;a:0:{}}}}}s:35:\"sites/all/modules/gmap/markers/big/\";a:4:{s:1:\"f\";a:3:{i:0;s:10:\"shadow.png\";i:1;s:8:\"blue.png\";i:2;s:7:\"red.png\";}s:1:\"w\";a:2:{i:0;i:56;i:1;i:30;}s:1:\"h\";a:1:{i:0;i:51;}s:1:\"i\";a:1:{i:0;a:2:{i:0;a:9:{i:0;a:3:{i:0;s:8:\"defaults\";i:1;s:8:\"big blue\";i:2;s:7:\"big red\";}i:1;a:3:{i:0;s:0:\"\";i:1;s:8:\"Big Blue\";i:2;s:7:\"Big Red\";}i:2;a:3:{i:0;a:0:{}i:1;a:1:{i:0;i:1;}i:2;a:1:{i:0;i:2;}}i:3;a:2:{i:0;i:16;i:1;i:0;}i:4;a:2:{i:0;i:51;i:1;i:0;}i:5;a:2:{i:0;i:24;i:1;i:0;}i:6;a:2:{i:0;i:4;i:1;i:0;}i:7;a:1:{i:0;i:0;}i:8;a:1:{i:0;i:0;}}i:1;a:13:{i:0;a:0:{}i:1;a:0:{}i:2;a:0:{}i:3;a:0:{}i:4;a:0:{}i:5;a:0:{}i:6;a:0:{}i:7;a:0:{}i:8;a:0:{}i:9;a:0:{}i:10;a:0:{}i:11;a:0:{}i:12;a:0:{}}}}}s:37:\"sites/all/modules/gmap/markers/small/\";a:4:{s:1:\"f\";a:24:{i:0;s:10:\"shadow.png\";i:1;s:7:\"red.png\";i:2;s:8:\"bred.png\";i:3;s:10:\"orange.png\";i:4;s:11:\"pyellow.png\";i:5;s:10:\"yellow.png\";i:6;s:10:\"pgreen.png\";i:7;s:9:\"green.png\";i:8;s:10:\"dgreen.png\";i:9;s:10:\"fgreen.png\";i:10;s:9:\"pblue.png\";i:11;s:9:\"lblue.png\";i:12;s:8:\"blue.png\";i:13;s:9:\"dblue.png\";i:14;s:10:\"purple.png\";i:15;s:8:\"pink.png\";i:16;s:9:\"bpink.png\";i:17;s:9:\"brown.png\";i:18;s:9:\"white.png\";i:19;s:9:\"lgray.png\";i:20;s:8:\"gray.png\";i:21;s:9:\"black.png\";i:22;s:11:\"altblue.png\";i:23;s:10:\"altred.png\";}s:1:\"w\";a:2:{i:0;i:22;i:1;i:12;}s:1:\"h\";a:1:{i:0;i:20;}s:1:\"i\";a:1:{i:0;a:2:{i:0;a:9:{i:0;a:24:{i:0;s:8:\"defaults\";i:1;s:9:\"small red\";i:2;s:10:\"small bred\";i:3;s:12:\"small orange\";i:4;s:13:\"small pyellow\";i:5;s:12:\"small yellow\";i:6;s:12:\"small pgreen\";i:7;s:11:\"small green\";i:8;s:12:\"small dgreen\";i:9;s:12:\"small fgreen\";i:10;s:11:\"small pblue\";i:11;s:11:\"small lblue\";i:12;s:10:\"small blue\";i:13;s:11:\"small dblue\";i:14;s:12:\"small purple\";i:15;s:10:\"small pink\";i:16;s:11:\"small bpink\";i:17;s:11:\"small brown\";i:18;s:11:\"small white\";i:19;s:11:\"small lgray\";i:20;s:10:\"small gray\";i:21;s:11:\"small black\";i:22;s:14:\"alt small blue\";i:23;s:13:\"alt small red\";}i:1;a:24:{i:0;s:0:\"\";i:1;s:9:\"Small Red\";i:2;s:16:\"Small Bright red\";i:3;s:12:\"Small Orange\";i:4;s:17:\"Small Pale Yellow\";i:5;s:12:\"Small Yellow\";i:6;s:16:\"Small Pale Green\";i:7;s:11:\"Small Green\";i:8;s:16:\"Small Dark Green\";i:9;s:18:\"Small Flouro Green\";i:10;s:15:\"Small Pale Blue\";i:11;s:16:\"Small Light Blue\";i:12;s:10:\"Small Blue\";i:13;s:15:\"Small Dark Blue\";i:14;s:12:\"Small Purple\";i:15;s:10:\"Small Pink\";i:16;s:17:\"Small Bright Pink\";i:17;s:11:\"Small Brown\";i:18;s:11:\"Small White\";i:19;s:16:\"Small Light Gray\";i:20;s:10:\"Small Gray\";i:21;s:11:\"Small Black\";i:22;s:22:\"Small Blue (Alternate)\";i:23;s:21:\"Small Red (Alternate)\";}i:2;a:24:{i:0;a:0:{}i:1;a:1:{i:0;i:1;}i:2;a:1:{i:0;i:2;}i:3;a:1:{i:0;i:3;}i:4;a:1:{i:0;i:4;}i:5;a:1:{i:0;i:5;}i:6;a:1:{i:0;i:6;}i:7;a:1:{i:0;i:7;}i:8;a:1:{i:0;i:8;}i:9;a:1:{i:0;i:9;}i:10;a:1:{i:0;i:10;}i:11;a:1:{i:0;i:11;}i:12;a:1:{i:0;i:12;}i:13;a:1:{i:0;i:13;}i:14;a:1:{i:0;i:14;}i:15;a:1:{i:0;i:15;}i:16;a:1:{i:0;i:16;}i:17;a:1:{i:0;i:17;}i:18;a:1:{i:0;i:18;}i:19;a:1:{i:0;i:19;}i:20;a:1:{i:0;i:20;}i:21;a:1:{i:0;i:21;}i:22;a:1:{i:0;i:22;}i:23;a:1:{i:0;i:23;}}i:3;a:2:{i:0;i:7;i:1;i:0;}i:4;a:2:{i:0;i:19;i:1;i:0;}i:5;a:2:{i:0;i:10;i:1;i:0;}i:6;a:2:{i:0;i:2;i:1;i:0;}i:7;a:1:{i:0;i:0;}i:8;a:1:{i:0;i:0;}}i:1;a:13:{i:0;a:0:{}i:1;a:0:{}i:2;a:0:{}i:3;a:0:{}i:4;a:0:{}i:5;a:0:{}i:6;a:0:{}i:7;a:0:{}i:8;a:0:{}i:9;a:0:{}i:10;a:0:{}i:11;a:0:{}i:12;a:0:{}}}}}s:31:\"sites/all/modules/gmap/markers/\";a:4:{s:1:\"f\";a:131:{i:0;s:8:\"blue.png\";i:1;s:8:\"gray.png\";i:2;s:9:\"green.png\";i:3;s:9:\"lblue.png\";i:4;s:10:\"orange.png\";i:5;s:8:\"pink.png\";i:6;s:10:\"purple.png\";i:7;s:9:\"white.png\";i:8;s:10:\"yellow.png\";i:9;s:11:\"number1.png\";i:10;s:11:\"number2.png\";i:11;s:11:\"number3.png\";i:12;s:11:\"number4.png\";i:13;s:11:\"number5.png\";i:14;s:11:\"number6.png\";i:15;s:11:\"number7.png\";i:16;s:11:\"number8.png\";i:17;s:11:\"number9.png\";i:18;s:12:\"number10.png\";i:19;s:12:\"number11.png\";i:20;s:12:\"number12.png\";i:21;s:12:\"number13.png\";i:22;s:12:\"number14.png\";i:23;s:12:\"number15.png\";i:24;s:12:\"number16.png\";i:25;s:12:\"number17.png\";i:26;s:12:\"number18.png\";i:27;s:12:\"number19.png\";i:28;s:12:\"number20.png\";i:29;s:12:\"number21.png\";i:30;s:12:\"number22.png\";i:31;s:12:\"number23.png\";i:32;s:12:\"number24.png\";i:33;s:12:\"number25.png\";i:34;s:12:\"number26.png\";i:35;s:12:\"number27.png\";i:36;s:12:\"number28.png\";i:37;s:12:\"number29.png\";i:38;s:12:\"number30.png\";i:39;s:12:\"number31.png\";i:40;s:12:\"number32.png\";i:41;s:12:\"number33.png\";i:42;s:12:\"number34.png\";i:43;s:12:\"number35.png\";i:44;s:12:\"number36.png\";i:45;s:12:\"number37.png\";i:46;s:12:\"number38.png\";i:47;s:12:\"number39.png\";i:48;s:12:\"number40.png\";i:49;s:12:\"number41.png\";i:50;s:12:\"number42.png\";i:51;s:12:\"number43.png\";i:52;s:12:\"number44.png\";i:53;s:12:\"number45.png\";i:54;s:12:\"number46.png\";i:55;s:12:\"number47.png\";i:56;s:12:\"number48.png\";i:57;s:12:\"number49.png\";i:58;s:12:\"number50.png\";i:59;s:12:\"number51.png\";i:60;s:12:\"number52.png\";i:61;s:12:\"number53.png\";i:62;s:12:\"number54.png\";i:63;s:12:\"number55.png\";i:64;s:12:\"number56.png\";i:65;s:12:\"number57.png\";i:66;s:12:\"number58.png\";i:67;s:12:\"number59.png\";i:68;s:12:\"number60.png\";i:69;s:12:\"number61.png\";i:70;s:12:\"number62.png\";i:71;s:12:\"number63.png\";i:72;s:12:\"number64.png\";i:73;s:12:\"number65.png\";i:74;s:12:\"number66.png\";i:75;s:12:\"number67.png\";i:76;s:12:\"number68.png\";i:77;s:12:\"number69.png\";i:78;s:12:\"number70.png\";i:79;s:12:\"number71.png\";i:80;s:12:\"number72.png\";i:81;s:12:\"number73.png\";i:82;s:12:\"number74.png\";i:83;s:12:\"number75.png\";i:84;s:12:\"number76.png\";i:85;s:12:\"number77.png\";i:86;s:12:\"number78.png\";i:87;s:12:\"number79.png\";i:88;s:12:\"number80.png\";i:89;s:12:\"number81.png\";i:90;s:12:\"number82.png\";i:91;s:12:\"number83.png\";i:92;s:12:\"number84.png\";i:93;s:12:\"number85.png\";i:94;s:12:\"number86.png\";i:95;s:12:\"number87.png\";i:96;s:12:\"number88.png\";i:97;s:12:\"number89.png\";i:98;s:12:\"number90.png\";i:99;s:12:\"number91.png\";i:100;s:12:\"number92.png\";i:101;s:12:\"number93.png\";i:102;s:12:\"number94.png\";i:103;s:12:\"number95.png\";i:104;s:12:\"number96.png\";i:105;s:12:\"number97.png\";i:106;s:12:\"number98.png\";i:107;s:12:\"number99.png\";i:108;s:11:\"letter1.png\";i:109;s:11:\"letter2.png\";i:110;s:11:\"letter3.png\";i:111;s:11:\"letter4.png\";i:112;s:11:\"letter5.png\";i:113;s:11:\"letter6.png\";i:114;s:11:\"letter7.png\";i:115;s:11:\"letter8.png\";i:116;s:11:\"letter9.png\";i:117;s:12:\"letter10.png\";i:118;s:10:\"route1.png\";i:119;s:10:\"route2.png\";i:120;s:17:\"marker_sunday.png\";i:121;s:17:\"marker_monday.png\";i:122;s:18:\"marker_tuesday.png\";i:123;s:20:\"marker_wednesday.png\";i:124;s:19:\"marker_thursday.png\";i:125;s:17:\"marker_friday.png\";i:126;s:19:\"marker_saturday.png\";i:127;s:9:\"blank.png\";i:128;s:11:\"cluster.png\";i:129;s:10:\"drupal.png\";i:130;s:10:\"vertex.png\";}s:1:\"w\";a:131:{i:0;i:20;i:1;i:20;i:2;i:20;i:3;i:20;i:4;i:20;i:5;i:20;i:6;i:20;i:7;i:20;i:8;i:20;i:9;i:20;i:10;i:20;i:11;i:20;i:12;i:20;i:13;i:20;i:14;i:20;i:15;i:20;i:16;i:20;i:17;i:20;i:18;i:20;i:19;i:20;i:20;i:20;i:21;i:20;i:22;i:20;i:23;i:20;i:24;i:20;i:25;i:20;i:26;i:20;i:27;i:20;i:28;i:20;i:29;i:20;i:30;i:20;i:31;i:20;i:32;i:20;i:33;i:20;i:34;i:20;i:35;i:20;i:36;i:20;i:37;i:20;i:38;i:20;i:39;i:20;i:40;i:20;i:41;i:20;i:42;i:20;i:43;i:20;i:44;i:20;i:45;i:20;i:46;i:20;i:47;i:20;i:48;i:20;i:49;i:20;i:50;i:20;i:51;i:20;i:52;i:20;i:53;i:20;i:54;i:20;i:55;i:20;i:56;i:20;i:57;i:20;i:58;i:20;i:59;i:20;i:60;i:20;i:61;i:20;i:62;i:20;i:63;i:20;i:64;i:20;i:65;i:20;i:66;i:20;i:67;i:20;i:68;i:20;i:69;i:20;i:70;i:20;i:71;i:20;i:72;i:20;i:73;i:20;i:74;i:20;i:75;i:20;i:76;i:20;i:77;i:20;i:78;i:20;i:79;i:20;i:80;i:20;i:81;i:20;i:82;i:20;i:83;i:20;i:84;i:20;i:85;i:20;i:86;i:20;i:87;i:20;i:88;i:20;i:89;i:20;i:90;i:20;i:91;i:20;i:92;i:20;i:93;i:20;i:94;i:20;i:95;i:20;i:96;i:20;i:97;i:20;i:98;i:20;i:99;i:20;i:100;i:20;i:101;i:20;i:102;i:20;i:103;i:20;i:104;i:20;i:105;i:20;i:106;i:20;i:107;i:20;i:108;i:20;i:109;i:20;i:110;i:20;i:111;i:20;i:112;i:20;i:113;i:20;i:114;i:20;i:115;i:20;i:116;i:20;i:117;i:20;i:118;i:20;i:119;i:20;i:120;i:20;i:121;i:20;i:122;i:20;i:123;i:20;i:124;i:20;i:125;i:20;i:126;i:20;i:127;i:20;i:128;i:20;i:129;i:20;i:130;i:8;}s:1:\"h\";a:131:{i:0;i:34;i:1;i:34;i:2;i:34;i:3;i:34;i:4;i:34;i:5;i:34;i:6;i:34;i:7;i:34;i:8;i:34;i:9;i:34;i:10;i:34;i:11;i:34;i:12;i:34;i:13;i:34;i:14;i:34;i:15;i:34;i:16;i:34;i:17;i:34;i:18;i:34;i:19;i:34;i:20;i:34;i:21;i:34;i:22;i:34;i:23;i:34;i:24;i:34;i:25;i:34;i:26;i:34;i:27;i:34;i:28;i:34;i:29;i:34;i:30;i:34;i:31;i:34;i:32;i:34;i:33;i:34;i:34;i:34;i:35;i:34;i:36;i:34;i:37;i:34;i:38;i:34;i:39;i:34;i:40;i:34;i:41;i:34;i:42;i:34;i:43;i:34;i:44;i:34;i:45;i:34;i:46;i:34;i:47;i:34;i:48;i:34;i:49;i:34;i:50;i:34;i:51;i:34;i:52;i:34;i:53;i:34;i:54;i:34;i:55;i:34;i:56;i:34;i:57;i:34;i:58;i:34;i:59;i:34;i:60;i:34;i:61;i:34;i:62;i:34;i:63;i:34;i:64;i:34;i:65;i:34;i:66;i:34;i:67;i:34;i:68;i:34;i:69;i:34;i:70;i:34;i:71;i:34;i:72;i:34;i:73;i:34;i:74;i:34;i:75;i:34;i:76;i:34;i:77;i:34;i:78;i:34;i:79;i:34;i:80;i:34;i:81;i:34;i:82;i:34;i:83;i:34;i:84;i:34;i:85;i:34;i:86;i:34;i:87;i:34;i:88;i:34;i:89;i:34;i:90;i:34;i:91;i:34;i:92;i:34;i:93;i:34;i:94;i:34;i:95;i:34;i:96;i:34;i:97;i:34;i:98;i:34;i:99;i:34;i:100;i:34;i:101;i:34;i:102;i:34;i:103;i:34;i:104;i:34;i:105;i:34;i:106;i:34;i:107;i:34;i:108;i:34;i:109;i:34;i:110;i:34;i:111;i:34;i:112;i:34;i:113;i:34;i:114;i:34;i:115;i:34;i:116;i:34;i:117;i:34;i:118;i:34;i:119;i:34;i:120;i:34;i:121;i:34;i:122;i:34;i:123;i:34;i:124;i:34;i:125;i:34;i:126;i:34;i:127;i:34;i:128;i:34;i:129;i:34;i:130;i:8;}s:1:\"i\";a:6:{i:0;a:2:{i:0;a:7:{i:0;a:10:{i:0;s:8:\"defaults\";i:1;s:4:\"blue\";i:2;s:4:\"gray\";i:3;s:5:\"green\";i:4;s:5:\"lblue\";i:5;s:6:\"orange\";i:6;s:4:\"pink\";i:7;s:6:\"purple\";i:8;s:5:\"white\";i:9;s:6:\"yellow\";}i:1;a:10:{i:0;s:0:\"\";i:1;s:4:\"Blue\";i:2;s:4:\"Gray\";i:3;s:5:\"Green\";i:4;s:10:\"Light Blue\";i:5;s:6:\"Orange\";i:6;s:4:\"Pink\";i:7;s:6:\"Purple\";i:8;s:5:\"White\";i:9;s:6:\"Yellow\";}i:2;a:10:{i:0;a:0:{}i:1;a:1:{i:0;i:0;}i:2;a:1:{i:0;i:1;}i:3;a:1:{i:0;i:2;}i:4;a:1:{i:0;i:3;}i:5;a:1:{i:0;i:4;}i:6;a:1:{i:0;i:5;}i:7;a:1:{i:0;i:6;}i:8;a:1:{i:0;i:7;}i:9;a:1:{i:0;i:8;}}i:3;a:2:{i:0;i:10;i:1;i:0;}i:4;a:2:{i:0;i:29;i:1;i:0;}i:5;a:2:{i:0;i:17;i:1;i:0;}i:6;a:2:{i:0;i:3;i:1;i:0;}}i:1;a:13:{i:0;a:0:{}i:1;a:0:{}i:2;a:0:{}i:3;a:0:{}i:4;a:0:{}i:5;a:0:{}i:6;a:0:{}i:7;a:0:{}i:8;a:0:{}i:9;a:0:{}i:10;a:0:{}i:11;a:0:{}i:12;a:0:{}}}i:1;a:2:{i:0;a:7:{i:0;a:2:{i:0;s:8:\"defaults\";i:1;s:7:\"numbers\";}i:1;a:2:{i:0;s:0:\"\";i:1;s:7:\"Numbers\";}i:2;a:2:{i:0;a:0:{}i:1;a:99:{i:0;i:9;i:1;i:10;i:2;i:11;i:3;i:12;i:4;i:13;i:5;i:14;i:6;i:15;i:7;i:16;i:8;i:17;i:9;i:18;i:10;i:19;i:11;i:20;i:12;i:21;i:13;i:22;i:14;i:23;i:15;i:24;i:16;i:25;i:17;i:26;i:18;i:27;i:19;i:28;i:20;i:29;i:21;i:30;i:22;i:31;i:23;i:32;i:24;i:33;i:25;i:34;i:26;i:35;i:27;i:36;i:28;i:37;i:29;i:38;i:30;i:39;i:31;i:40;i:32;i:41;i:33;i:42;i:34;i:43;i:35;i:44;i:36;i:45;i:37;i:46;i:38;i:47;i:39;i:48;i:40;i:49;i:41;i:50;i:42;i:51;i:43;i:52;i:44;i:53;i:45;i:54;i:46;i:55;i:47;i:56;i:48;i:57;i:49;i:58;i:50;i:59;i:51;i:60;i:52;i:61;i:53;i:62;i:54;i:63;i:55;i:64;i:56;i:65;i:57;i:66;i:58;i:67;i:59;i:68;i:60;i:69;i:61;i:70;i:62;i:71;i:63;i:72;i:64;i:73;i:65;i:74;i:66;i:75;i:67;i:76;i:68;i:77;i:69;i:78;i:70;i:79;i:71;i:80;i:72;i:81;i:73;i:82;i:74;i:83;i:75;i:84;i:76;i:85;i:77;i:86;i:78;i:87;i:79;i:88;i:80;i:89;i:81;i:90;i:82;i:91;i:83;i:92;i:84;i:93;i:85;i:94;i:86;i:95;i:87;i:96;i:88;i:97;i:89;i:98;i:90;i:99;i:91;i:100;i:92;i:101;i:93;i:102;i:94;i:103;i:95;i:104;i:96;i:105;i:97;i:106;i:98;i:107;}}i:3;a:2:{i:0;i:10;i:1;i:0;}i:4;a:2:{i:0;i:29;i:1;i:0;}i:5;a:2:{i:0;i:17;i:1;i:0;}i:6;a:2:{i:0;i:6;i:1;i:0;}}i:1;a:13:{i:0;a:0:{}i:1;a:0:{}i:2;a:0:{}i:3;a:0:{}i:4;a:0:{}i:5;a:0:{}i:6;a:0:{}i:7;a:0:{}i:8;a:0:{}i:9;a:0:{}i:10;a:0:{}i:11;a:0:{}i:12;a:0:{}}}i:2;a:2:{i:0;a:7:{i:0;a:2:{i:0;s:8:\"defaults\";i:1;s:7:\"letters\";}i:1;a:2:{i:0;s:0:\"\";i:1;s:7:\"Letters\";}i:2;a:2:{i:0;a:0:{}i:1;a:10:{i:0;i:108;i:1;i:109;i:2;i:110;i:3;i:111;i:4;i:112;i:5;i:113;i:6;i:114;i:7;i:115;i:8;i:116;i:9;i:117;}}i:3;a:2:{i:0;i:10;i:1;i:0;}i:4;a:2:{i:0;i:29;i:1;i:0;}i:5;a:2:{i:0;i:17;i:1;i:0;}i:6;a:2:{i:0;i:6;i:1;i:0;}}i:1;a:13:{i:0;a:0:{}i:1;a:0:{}i:2;a:0:{}i:3;a:0:{}i:4;a:0:{}i:5;a:0:{}i:6;a:0:{}i:7;a:0:{}i:8;a:0:{}i:9;a:0:{}i:10;a:0:{}i:11;a:0:{}i:12;a:0:{}}}i:3;a:2:{i:0;a:7:{i:0;a:2:{i:0;s:8:\"defaults\";i:1;s:5:\"route\";}i:1;a:2:{i:0;s:0:\"\";i:1;s:5:\"Route\";}i:2;a:2:{i:0;a:0:{}i:1;a:2:{i:0;i:118;i:1;i:119;}}i:3;a:2:{i:0;i:10;i:1;i:0;}i:4;a:2:{i:0;i:29;i:1;i:0;}i:5;a:2:{i:0;i:17;i:1;i:0;}i:6;a:2:{i:0;i:6;i:1;i:0;}}i:1;a:13:{i:0;a:0:{}i:1;a:0:{}i:2;a:0:{}i:3;a:0:{}i:4;a:0:{}i:5;a:0:{}i:6;a:0:{}i:7;a:0:{}i:8;a:0:{}i:9;a:0:{}i:10;a:0:{}i:11;a:0:{}i:12;a:0:{}}}i:4;a:2:{i:0;a:7:{i:0;a:9:{i:0;s:8:\"defaults\";i:1;s:6:\"sunday\";i:2;s:6:\"monday\";i:3;s:7:\"tuesday\";i:4;s:9:\"wednesday\";i:5;s:8:\"thursday\";i:6;s:6:\"friday\";i:7;s:8:\"saturday\";i:8;s:4:\"week\";}i:1;a:9:{i:0;s:0:\"\";i:1;s:6:\"Sunday\";i:2;s:6:\"Monday\";i:3;s:7:\"Tuesday\";i:4;s:9:\"Wednesday\";i:5;s:8:\"Thursday\";i:6;s:6:\"Friday\";i:7;s:8:\"Saturday\";i:8;s:4:\"Week\";}i:2;a:9:{i:0;a:0:{}i:1;a:1:{i:0;i:120;}i:2;a:1:{i:0;i:121;}i:3;a:1:{i:0;i:122;}i:4;a:1:{i:0;i:123;}i:5;a:1:{i:0;i:124;}i:6;a:1:{i:0;i:125;}i:7;a:1:{i:0;i:126;}i:8;a:7:{i:0;i:120;i:1;i:121;i:2;i:122;i:3;i:123;i:4;i:124;i:5;i:125;i:6;i:126;}}i:3;a:2:{i:0;i:10;i:1;i:0;}i:4;a:2:{i:0;i:29;i:1;i:0;}i:5;a:2:{i:0;i:17;i:1;i:0;}i:6;a:2:{i:0;i:3;i:1;i:0;}}i:1;a:13:{i:0;a:0:{}i:1;a:0:{}i:2;a:0:{}i:3;a:0:{}i:4;a:0:{}i:5;a:0:{}i:6;a:0:{}i:7;a:0:{}i:8;a:0:{}i:9;a:0:{}i:10;a:0:{}i:11;a:0:{}i:12;a:0:{}}}i:5;a:2:{i:0;a:7:{i:0;a:5:{i:0;s:8:\"defaults\";i:1;s:5:\"blank\";i:2;s:7:\"cluster\";i:3;s:6:\"drupal\";i:4;s:6:\"vertex\";}i:1;a:5:{i:0;s:0:\"\";i:1;s:5:\"Blank\";i:2;s:7:\"Cluster\";i:3;s:6:\"Drupal\";i:4;s:11:\"Line Vertex\";}i:2;a:5:{i:0;a:0:{}i:1;a:1:{i:0;i:127;}i:2;a:1:{i:0;i:128;}i:3;a:1:{i:0;i:129;}i:4;a:1:{i:0;i:130;}}i:3;a:5:{i:0;i:10;i:1;i:0;i:2;i:0;i:3;i:0;i:4;i:4;}i:4;a:5:{i:0;i:29;i:1;i:0;i:2;i:0;i:3;i:0;i:4;i:4;}i:5;a:5:{i:0;i:17;i:1;i:0;i:2;i:0;i:3;i:0;i:4;i:4;}i:6;a:5:{i:0;i:6;i:1;i:0;i:2;i:0;i:3;i:0;i:4;i:4;}}i:1;a:13:{i:0;a:0:{}i:1;a:0:{}i:2;a:0:{}i:3;a:0:{}i:4;a:0:{}i:5;a:0:{}i:6;a:0:{}i:7;a:0:{}i:8;a:0:{}i:9;a:0:{}i:10;a:0:{}i:11;a:0:{}i:12;a:0:{}}}}}}',0,1469631376,1),('gmap_marker_titles','a:50:{s:8:\"treasure\";s:16:\"X marks the spot\";s:8:\"big blue\";s:8:\"Big Blue\";s:7:\"big red\";s:7:\"Big Red\";s:9:\"small red\";s:9:\"Small Red\";s:10:\"small bred\";s:16:\"Small Bright red\";s:12:\"small orange\";s:12:\"Small Orange\";s:13:\"small pyellow\";s:17:\"Small Pale Yellow\";s:12:\"small yellow\";s:12:\"Small Yellow\";s:12:\"small pgreen\";s:16:\"Small Pale Green\";s:11:\"small green\";s:11:\"Small Green\";s:12:\"small dgreen\";s:16:\"Small Dark Green\";s:12:\"small fgreen\";s:18:\"Small Flouro Green\";s:11:\"small pblue\";s:15:\"Small Pale Blue\";s:11:\"small lblue\";s:16:\"Small Light Blue\";s:10:\"small blue\";s:10:\"Small Blue\";s:11:\"small dblue\";s:15:\"Small Dark Blue\";s:12:\"small purple\";s:12:\"Small Purple\";s:10:\"small pink\";s:10:\"Small Pink\";s:11:\"small bpink\";s:17:\"Small Bright Pink\";s:11:\"small brown\";s:11:\"Small Brown\";s:11:\"small white\";s:11:\"Small White\";s:11:\"small lgray\";s:16:\"Small Light Gray\";s:10:\"small gray\";s:10:\"Small Gray\";s:11:\"small black\";s:11:\"Small Black\";s:14:\"alt small blue\";s:22:\"Small Blue (Alternate)\";s:13:\"alt small red\";s:21:\"Small Red (Alternate)\";s:4:\"blue\";s:4:\"Azul\";s:4:\"gray\";s:4:\"Gris\";s:5:\"green\";s:5:\"Verde\";s:5:\"lblue\";s:10:\"Light Blue\";s:6:\"orange\";s:6:\"Orange\";s:4:\"pink\";s:4:\"Pink\";s:6:\"purple\";s:6:\"Purple\";s:5:\"white\";s:6:\"Branco\";s:6:\"yellow\";s:7:\"Amarelo\";s:7:\"numbers\";s:7:\"Numbers\";s:7:\"letters\";s:7:\"Letters\";s:5:\"route\";s:4:\"Ruta\";s:6:\"sunday\";s:7:\"domingo\";s:6:\"monday\";s:4:\"luns\";s:7:\"tuesday\";s:6:\"martes\";s:9:\"wednesday\";s:9:\"mércores\";s:8:\"thursday\";s:5:\"xoves\";s:6:\"friday\";s:6:\"venres\";s:8:\"saturday\";s:7:\"sábado\";s:4:\"week\";s:6:\"Semana\";s:5:\"blank\";s:9:\"En blanco\";s:7:\"cluster\";s:7:\"Cluster\";s:6:\"drupal\";s:6:\"Drupal\";s:6:\"vertex\";s:11:\"Line Vertex\";}',0,1469631376,1),('image_effects:gl','a:6:{s:10:\"image_crop\";a:9:{s:5:\"label\";s:8:\"Recortar\";s:4:\"help\";s:84:\"O recorte eliminará partes dunha imaxe para que teña as dimensiones especificadas.\";s:15:\"effect callback\";s:17:\"image_crop_effect\";s:19:\"dimensions callback\";s:23:\"image_resize_dimensions\";s:13:\"form callback\";s:15:\"image_crop_form\";s:13:\"summary theme\";s:18:\"image_crop_summary\";s:6:\"module\";s:5:\"image\";s:4:\"name\";s:10:\"image_crop\";s:4:\"data\";a:0:{}}s:16:\"image_desaturate\";a:7:{s:5:\"label\";s:9:\"Desaturar\";s:4:\"help\";s:50:\"Desaturar convirte unha imaxe en escala de grises.\";s:15:\"effect callback\";s:23:\"image_desaturate_effect\";s:22:\"dimensions passthrough\";b:1;s:6:\"module\";s:5:\"image\";s:4:\"name\";s:16:\"image_desaturate\";s:4:\"data\";a:0:{}}s:12:\"image_resize\";a:9:{s:5:\"label\";s:13:\"Redimensionar\";s:4:\"help\";s:142:\"O redimensionado fará cas imáxes tomen unhas dimensións precisas. Isto pode facer cas imáxes se encollan ou estiren desproporcionadamente.\";s:15:\"effect callback\";s:19:\"image_resize_effect\";s:19:\"dimensions callback\";s:23:\"image_resize_dimensions\";s:13:\"form callback\";s:17:\"image_resize_form\";s:13:\"summary theme\";s:20:\"image_resize_summary\";s:6:\"module\";s:5:\"image\";s:4:\"name\";s:12:\"image_resize\";s:4:\"data\";a:0:{}}s:12:\"image_rotate\";a:9:{s:5:\"label\";s:5:\"Rotar\";s:4:\"help\";s:82:\"Xirar una imaxe pode facer que as dimensiones aumenten para axustarse á diagonal.\";s:15:\"effect callback\";s:19:\"image_rotate_effect\";s:19:\"dimensions callback\";s:23:\"image_rotate_dimensions\";s:13:\"form callback\";s:17:\"image_rotate_form\";s:13:\"summary theme\";s:20:\"image_rotate_summary\";s:6:\"module\";s:5:\"image\";s:4:\"name\";s:12:\"image_rotate\";s:4:\"data\";a:0:{}}s:11:\"image_scale\";a:9:{s:5:\"label\";s:6:\"Escala\";s:4:\"help\";s:124:\"O escalado manten a relación de proporcións da imaxe orixinal. Se só se especifica unha dimensión, a outra calcularáse.\";s:15:\"effect callback\";s:18:\"image_scale_effect\";s:19:\"dimensions callback\";s:22:\"image_scale_dimensions\";s:13:\"form callback\";s:16:\"image_scale_form\";s:13:\"summary theme\";s:19:\"image_scale_summary\";s:6:\"module\";s:5:\"image\";s:4:\"name\";s:11:\"image_scale\";s:4:\"data\";a:0:{}}s:20:\"image_scale_and_crop\";a:9:{s:5:\"label\";s:18:\"Escalar e recortar\";s:4:\"help\";s:190:\"Escalar e recortar van manter a proporción da imaxe orixinal, logo cortará o que sobre polo lado maior. Isto é moi útil para crear miniaturas perfectamente cadradas sen deformar a imaxe.\";s:15:\"effect callback\";s:27:\"image_scale_and_crop_effect\";s:19:\"dimensions callback\";s:23:\"image_resize_dimensions\";s:13:\"form callback\";s:17:\"image_resize_form\";s:13:\"summary theme\";s:20:\"image_resize_summary\";s:6:\"module\";s:5:\"image\";s:4:\"name\";s:20:\"image_scale_and_crop\";s:4:\"data\";a:0:{}}}',0,1469579872,1),('image_styles','a:9:{s:15:\"flexslider_full\";a:5:{s:7:\"effects\";a:1:{i:0;a:10:{s:5:\"label\";s:18:\"Escalar e recortar\";s:4:\"help\";s:190:\"Escalar e recortar van manter a proporción da imaxe orixinal, logo cortará o que sobre polo lado maior. Isto é moi útil para crear miniaturas perfectamente cadradas sen deformar a imaxe.\";s:15:\"effect callback\";s:27:\"image_scale_and_crop_effect\";s:19:\"dimensions callback\";s:23:\"image_resize_dimensions\";s:13:\"form callback\";s:17:\"image_resize_form\";s:13:\"summary theme\";s:20:\"image_resize_summary\";s:6:\"module\";s:5:\"image\";s:4:\"name\";s:20:\"image_scale_and_crop\";s:4:\"data\";a:2:{s:5:\"width\";i:800;s:6:\"height\";i:500;}s:6:\"weight\";i:0;}}s:4:\"name\";s:15:\"flexslider_full\";s:5:\"label\";s:15:\"flexslider_full\";s:6:\"module\";s:10:\"flexslider\";s:7:\"storage\";i:4;}s:20:\"flexslider_thumbnail\";a:5:{s:7:\"effects\";a:1:{i:0;a:10:{s:5:\"label\";s:18:\"Escalar e recortar\";s:4:\"help\";s:190:\"Escalar e recortar van manter a proporción da imaxe orixinal, logo cortará o que sobre polo lado maior. Isto é moi útil para crear miniaturas perfectamente cadradas sen deformar a imaxe.\";s:15:\"effect callback\";s:27:\"image_scale_and_crop_effect\";s:19:\"dimensions callback\";s:23:\"image_resize_dimensions\";s:13:\"form callback\";s:17:\"image_resize_form\";s:13:\"summary theme\";s:20:\"image_resize_summary\";s:6:\"module\";s:5:\"image\";s:4:\"name\";s:20:\"image_scale_and_crop\";s:4:\"data\";a:2:{s:5:\"width\";i:160;s:6:\"height\";i:100;}s:6:\"weight\";i:0;}}s:4:\"name\";s:20:\"flexslider_thumbnail\";s:5:\"label\";s:20:\"flexslider_thumbnail\";s:6:\"module\";s:10:\"flexslider\";s:7:\"storage\";i:4;}s:9:\"thumbnail\";a:5:{s:5:\"label\";s:19:\"Thumbnail (100x100)\";s:7:\"effects\";a:1:{i:0;a:10:{s:5:\"label\";s:6:\"Escala\";s:4:\"help\";s:124:\"O escalado manten a relación de proporcións da imaxe orixinal. Se só se especifica unha dimensión, a outra calcularáse.\";s:15:\"effect callback\";s:18:\"image_scale_effect\";s:19:\"dimensions callback\";s:22:\"image_scale_dimensions\";s:13:\"form callback\";s:16:\"image_scale_form\";s:13:\"summary theme\";s:19:\"image_scale_summary\";s:6:\"module\";s:5:\"image\";s:4:\"name\";s:11:\"image_scale\";s:4:\"data\";a:3:{s:5:\"width\";i:100;s:6:\"height\";i:100;s:7:\"upscale\";i:1;}s:6:\"weight\";i:0;}}s:4:\"name\";s:9:\"thumbnail\";s:6:\"module\";s:5:\"image\";s:7:\"storage\";i:4;}s:6:\"medium\";a:5:{s:5:\"label\";s:16:\"Medium (220x220)\";s:7:\"effects\";a:1:{i:0;a:10:{s:5:\"label\";s:6:\"Escala\";s:4:\"help\";s:124:\"O escalado manten a relación de proporcións da imaxe orixinal. Se só se especifica unha dimensión, a outra calcularáse.\";s:15:\"effect callback\";s:18:\"image_scale_effect\";s:19:\"dimensions callback\";s:22:\"image_scale_dimensions\";s:13:\"form callback\";s:16:\"image_scale_form\";s:13:\"summary theme\";s:19:\"image_scale_summary\";s:6:\"module\";s:5:\"image\";s:4:\"name\";s:11:\"image_scale\";s:4:\"data\";a:3:{s:5:\"width\";i:220;s:6:\"height\";i:220;s:7:\"upscale\";i:1;}s:6:\"weight\";i:0;}}s:4:\"name\";s:6:\"medium\";s:6:\"module\";s:5:\"image\";s:7:\"storage\";i:4;}s:5:\"large\";a:6:{s:4:\"isid\";s:1:\"5\";s:4:\"name\";s:5:\"large\";s:5:\"label\";s:15:\"Large (480x480)\";s:6:\"module\";s:5:\"image\";s:7:\"storage\";i:2;s:7:\"effects\";a:1:{i:6;a:12:{s:5:\"label\";s:6:\"Escala\";s:4:\"help\";s:124:\"O escalado manten a relación de proporcións da imaxe orixinal. Se só se especifica unha dimensión, a outra calcularáse.\";s:15:\"effect callback\";s:18:\"image_scale_effect\";s:19:\"dimensions callback\";s:22:\"image_scale_dimensions\";s:13:\"form callback\";s:16:\"image_scale_form\";s:13:\"summary theme\";s:19:\"image_scale_summary\";s:6:\"module\";s:5:\"image\";s:4:\"name\";s:11:\"image_scale\";s:4:\"data\";a:3:{s:5:\"width\";s:3:\"720\";s:6:\"height\";s:3:\"720\";s:7:\"upscale\";i:0;}s:4:\"ieid\";s:1:\"6\";s:4:\"isid\";s:1:\"5\";s:6:\"weight\";s:1:\"0\";}}}s:8:\"tm_large\";a:6:{s:4:\"isid\";s:1:\"1\";s:4:\"name\";s:8:\"tm_large\";s:5:\"label\";s:15:\"TM Large (1400)\";s:6:\"module\";N;s:7:\"storage\";i:1;s:7:\"effects\";a:1:{i:1;a:12:{s:5:\"label\";s:6:\"Escala\";s:4:\"help\";s:124:\"O escalado manten a relación de proporcións da imaxe orixinal. Se só se especifica unha dimensión, a outra calcularáse.\";s:15:\"effect callback\";s:18:\"image_scale_effect\";s:19:\"dimensions callback\";s:22:\"image_scale_dimensions\";s:13:\"form callback\";s:16:\"image_scale_form\";s:13:\"summary theme\";s:19:\"image_scale_summary\";s:6:\"module\";s:5:\"image\";s:4:\"name\";s:11:\"image_scale\";s:4:\"data\";a:3:{s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:0:\"\";s:7:\"upscale\";i:0;}s:4:\"ieid\";s:1:\"1\";s:4:\"isid\";s:1:\"1\";s:6:\"weight\";s:1:\"1\";}}}s:9:\"tm_medium\";a:6:{s:4:\"isid\";s:1:\"2\";s:4:\"name\";s:9:\"tm_medium\";s:5:\"label\";s:15:\"TM Medium (800)\";s:6:\"module\";N;s:7:\"storage\";i:1;s:7:\"effects\";a:1:{i:2;a:12:{s:5:\"label\";s:6:\"Escala\";s:4:\"help\";s:124:\"O escalado manten a relación de proporcións da imaxe orixinal. Se só se especifica unha dimensión, a outra calcularáse.\";s:15:\"effect callback\";s:18:\"image_scale_effect\";s:19:\"dimensions callback\";s:22:\"image_scale_dimensions\";s:13:\"form callback\";s:16:\"image_scale_form\";s:13:\"summary theme\";s:19:\"image_scale_summary\";s:6:\"module\";s:5:\"image\";s:4:\"name\";s:11:\"image_scale\";s:4:\"data\";a:3:{s:5:\"width\";s:3:\"800\";s:6:\"height\";s:0:\"\";s:7:\"upscale\";i:0;}s:4:\"ieid\";s:1:\"2\";s:4:\"isid\";s:1:\"2\";s:6:\"weight\";s:1:\"1\";}}}s:16:\"tm_medium_square\";a:6:{s:4:\"isid\";s:1:\"3\";s:4:\"name\";s:16:\"tm_medium_square\";s:5:\"label\";s:26:\"TM Medium Square (600x600)\";s:6:\"module\";N;s:7:\"storage\";i:1;s:7:\"effects\";a:2:{i:3;a:12:{s:5:\"label\";s:6:\"Escala\";s:4:\"help\";s:124:\"O escalado manten a relación de proporcións da imaxe orixinal. Se só se especifica unha dimensión, a outra calcularáse.\";s:15:\"effect callback\";s:18:\"image_scale_effect\";s:19:\"dimensions callback\";s:22:\"image_scale_dimensions\";s:13:\"form callback\";s:16:\"image_scale_form\";s:13:\"summary theme\";s:19:\"image_scale_summary\";s:6:\"module\";s:5:\"image\";s:4:\"name\";s:11:\"image_scale\";s:4:\"data\";a:3:{s:5:\"width\";s:0:\"\";s:6:\"height\";s:3:\"600\";s:7:\"upscale\";i:1;}s:4:\"ieid\";s:1:\"3\";s:4:\"isid\";s:1:\"3\";s:6:\"weight\";s:1:\"1\";}i:4;a:12:{s:5:\"label\";s:8:\"Recortar\";s:4:\"help\";s:84:\"O recorte eliminará partes dunha imaxe para que teña as dimensiones especificadas.\";s:15:\"effect callback\";s:17:\"image_crop_effect\";s:19:\"dimensions callback\";s:23:\"image_resize_dimensions\";s:13:\"form callback\";s:15:\"image_crop_form\";s:13:\"summary theme\";s:18:\"image_crop_summary\";s:6:\"module\";s:5:\"image\";s:4:\"name\";s:10:\"image_crop\";s:4:\"data\";a:3:{s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:6:\"anchor\";s:13:\"center-center\";}s:4:\"ieid\";s:1:\"4\";s:4:\"isid\";s:1:\"3\";s:6:\"weight\";s:1:\"2\";}}}s:22:\"tm_medium_square_video\";a:6:{s:4:\"isid\";s:1:\"4\";s:4:\"name\";s:22:\"tm_medium_square_video\";s:5:\"label\";s:32:\"TM Medium Square Video (270x270)\";s:6:\"module\";N;s:7:\"storage\";i:1;s:7:\"effects\";a:1:{i:5;a:12:{s:5:\"label\";s:8:\"Recortar\";s:4:\"help\";s:84:\"O recorte eliminará partes dunha imaxe para que teña as dimensiones especificadas.\";s:15:\"effect callback\";s:17:\"image_crop_effect\";s:19:\"dimensions callback\";s:23:\"image_resize_dimensions\";s:13:\"form callback\";s:15:\"image_crop_form\";s:13:\"summary theme\";s:18:\"image_crop_summary\";s:6:\"module\";s:5:\"image\";s:4:\"name\";s:10:\"image_crop\";s:4:\"data\";a:3:{s:5:\"width\";s:3:\"270\";s:6:\"height\";s:3:\"270\";s:6:\"anchor\";s:13:\"center-center\";}s:4:\"ieid\";s:1:\"5\";s:4:\"isid\";s:1:\"4\";s:6:\"weight\";s:1:\"1\";}}}}',0,1469579872,1),('locale:es','a:7:{s:0:\"\";a:7179:{s:4:\"Show\";s:7:\"Mostrar\";s:3:\"All\";s:4:\"Todo\";s:14:\"Hide shortcuts\";s:14:\"Ocultar atajos\";s:12:\"(active tab)\";s:15:\"(solapa activa)\";s:4:\"Edit\";s:6:\"Editar\";s:7:\"Enabled\";s:8:\"Activado\";s:8:\"Disabled\";s:11:\"Desactivado\";s:12:\"Public files\";s:18:\"Archivos públicos\";s:43:\"Public local files served by the webserver.\";s:56:\"Archivos locales públicos servidos por el servidor web.\";s:15:\"Temporary files\";s:19:\"Archivos temporales\";s:46:\"Temporary local files for upload and previews.\";s:58:\"Archivos locales temporales para subidas y vistas previas.\";s:9:\"Languages\";s:7:\"Idiomas\";s:55:\"Configure languages for content and the user interface.\";s:66:\"Configurar los idiomas para el contenido y la interfaz de usuario.\";s:4:\"Long\";s:5:\"Largo\";s:6:\"Medium\";s:5:\"Medio\";s:5:\"Short\";s:5:\"Corto\";s:25:\"Drupal core update status\";s:47:\"Estado de actualizaciones del núcleo de Drupal\";s:24:\"No update data available\";s:42:\"No hay datos de actualización disponibles\";s:17:\"Weight for @title\";s:16:\"Peso para @title\";s:13:\"Left to right\";s:19:\"Izquierda a derecha\";s:17:\"Enabled languages\";s:17:\"Idiomas activados\";s:16:\"Default language\";s:21:\"Idioma predeterminado\";s:18:\"Save configuration\";s:22:\"Guardar configuración\";s:7:\"Content\";s:9:\"Contenido\";s:4:\"Help\";s:5:\"Ayuda\";s:8:\"Page top\";s:28:\"Parte superior de la página\";s:11:\"Page bottom\";s:27:\"Zona inferior de la página\";s:13:\"First sidebar\";s:21:\"Primera barra lateral\";s:16:\"Dashboard (main)\";b:1;s:19:\"Dashboard (sidebar)\";b:1;s:20:\"Dashboard (inactive)\";b:1;s:4:\"List\";s:5:\"Lista\";s:12:\"Add language\";s:14:\"Agregar idioma\";s:23:\"Detection and selection\";s:23:\"Detección y selección\";s:10:\"My account\";s:9:\"Mi cuenta\";s:7:\"Log out\";s:14:\"Cerrar sesión\";s:4:\"Home\";s:6:\"Inicio\";s:14:\"Administration\";s:15:\"Administración\";s:10:\"Appearance\";s:10:\"Apariencia\";s:33:\"Select and configure your themes.\";s:35:\"Seleccionar y configurar sus temas.\";s:13:\"Configuration\";s:14:\"Configuración\";s:20:\"Administer settings.\";s:21:\"Administrar opciones.\";s:17:\"Content authoring\";s:22:\"Autoría del contenido\";s:53:\"Settings related to formatting and authoring content.\";s:58:\"Opciones relacionadas con formato y autoría de contenido.\";s:11:\"Development\";s:10:\"Desarrollo\";s:18:\"Development tools.\";s:27:\"Herramientas de desarrollo.\";s:5:\"Media\";s:10:\"Multimedia\";s:12:\"Media tools.\";s:23:\"Herramientas multimedia\";s:6:\"People\";s:8:\"Personas\";s:24:\"Configure user accounts.\";s:30:\"Configurar cuentas de usuario.\";s:21:\"Regional and language\";s:17:\"Regional e idioma\";s:48:\"Regional settings, localization and translation.\";s:38:\"Configuración regional y traducción.\";s:13:\"Date and time\";s:12:\"Fecha y hora\";s:44:\"Configure display formats for date and time.\";s:55:\"Configurar formatos de presentación para fecha y hora.\";s:17:\"Regional settings\";s:19:\"Opciones regionales\";s:54:\"Settings for the site\'s default time zone and country.\";s:64:\"Opciones para la zona horaria y país predeterminados del sitio.\";s:19:\"Translate interface\";s:17:\"Traducir interfaz\";s:59:\"Translate the built in interface and optionally other text.\";s:57:\"Traduce la interfaz interna y opcionalmente otros textos.\";s:19:\"Search and metadata\";s:22:\"Búsqueda y meta datos\";s:36:\"Local site search, metadata and SEO.\";s:46:\"Búsqueda interna del sitio, meta datos y SEO.\";s:6:\"System\";s:7:\"Sistema\";s:37:\"General system related configuration.\";s:50:\"Configuración relacionada con el sistema general.\";s:14:\"User interface\";s:19:\"Interfaz de usuario\";s:38:\"Tools that enhance the user interface.\";s:48:\"Herramientas que mejoran la interfaz de usuario.\";s:12:\"Web services\";s:13:\"Servicios web\";s:30:\"Tools related to web services.\";s:44:\"Herramientas relacionadas con servicios web.\";s:8:\"Workflow\";s:16:\"Flujo de trabajo\";s:43:\"Content workflow, editorial workflow tools.\";s:76:\"Flujo de trabajo del contenido, herramientas del flujo de trabajo editorial.\";s:32:\"Administer content and comments.\";s:36:\"Administrar contenido y comentarios.\";s:9:\"Dashboard\";s:16:\"Panel de control\";s:34:\"View and customize your dashboard.\";s:39:\"Ver y personalizar su cuadro de mandos.\";s:48:\"Reference for usage, configuration, and modules.\";s:46:\"Referencia de uso, configuración, y módulos.\";s:5:\"Index\";s:7:\"Índice\";s:7:\"Modules\";s:8:\"Módulos\";s:26:\"Extend site functionality.\";s:36:\"Extender la funcionalidad del sitio.\";s:45:\"Manage user accounts, roles, and permissions.\";s:47:\"Gestionar cuentas de usuario, roles y permisos.\";s:7:\"Reports\";s:8:\"Informes\";s:34:\"View reports, updates, and errors.\";s:40:\"Ver informes, actualizaciones y errores.\";s:9:\"Structure\";s:10:\"Estructura\";s:45:\"Administer blocks, content types, menus, etc.\";s:53:\"Administrar bloques, tipos de contenido, menús, etc.\";s:5:\"Tasks\";s:6:\"Tareas\";s:30:\"Add to %shortcut_set shortcuts\";s:44:\"Añadir %shortcut_set a los accesos directos\";s:12:\"You are here\";s:17:\"Usted está aquí\";s:14:\"Status message\";s:17:\"Mensaje de estado\";s:13:\"Error message\";s:16:\"Mensaje de error\";s:15:\"Warning message\";s:22:\"Mensaje de advertencia\";s:12:\"Primary tabs\";s:19:\"Solapas principales\";s:24:\"!local-task-title!active\";s:24:\"!local-task-title!active\";s:13:\"Enable !title\";s:14:\"Activar !title\";s:21:\"Set !title as default\";s:37:\"Establecer !title como predeterminado\";s:16:\"!title !required\";s:16:\"!title !required\";s:4:\"edit\";s:6:\"editar\";s:6:\"delete\";s:8:\"eliminar\";s:12:\"English name\";s:17:\"Nombre en inglés\";s:11:\"Native name\";s:13:\"Nombre nativo\";s:4:\"Code\";s:7:\"Código\";s:9:\"Direction\";s:10:\"Dirección\";s:7:\"Default\";s:14:\"Predeterminado\";s:6:\"Weight\";s:4:\"Peso\";s:10:\"Operations\";s:11:\"Operaciones\";s:22:\"Administrative toolbar\";s:36:\"barra de herramientas administrativa\";s:32:\"Hello <strong>@username</strong>\";s:38:\"Bienvenido, <strong>@username</strong>\";s:12:\"User account\";s:17:\"Cuenta de usuario\";s:11:\"Add content\";s:17:\"Añadir contenido\";s:14:\"Edit shortcuts\";s:23:\"Editar accesos directos\";s:20:\"Skip to main content\";s:25:\"Ir al contenido principal\";s:20:\"Configuration saved.\";s:24:\"Configuración guardada.\";s:19:\"User interface text\";s:32:\"Texto de la interfaz del usuario\";s:3:\"URL\";s:3:\"URL\";s:60:\"Determine the language from the URL (Path prefix or domain).\";s:68:\"Determinar el idioma a partir de la URL (prefijo de ruta o dominio).\";s:7:\"Session\";s:7:\"Sesión\";s:56:\"Determine the language from a request/session parameter.\";s:70:\"Determinar el idioma a partir de un parámetro de petición o sesión.\";s:4:\"User\";s:7:\"Usuario\";s:38:\"Follow the user\'s language preference.\";s:46:\"Seguir las preferencias de idioma del usuario.\";s:7:\"Browser\";s:9:\"Navegador\";s:60:\"Determine the language from the browser\'s language settings.\";s:75:\"Determinar el idioma a partir de la configuración de idioma del navegador.\";s:9:\"Interface\";s:8:\"Interfaz\";s:36:\"Use the detected interface language.\";s:41:\"Utilizar el idioma de interfaz detectado.\";s:12:\"URL fallback\";s:15:\"URL alternativa\";s:59:\"Use an already detected language for URLs if none is found.\";s:73:\"Utilizar un idioma ya detectado para las URLs si no se encuentra ninguno.\";s:47:\"Use the default site language (@language_name).\";s:57:\"Usar el idioma predeterminado del sitio (@language_name).\";s:24:\"@type language detection\";s:29:\"detección de idioma de @type\";s:24:\"@title language provider\";s:26:\"Proveedor de idioma @title\";s:9:\"Configure\";s:10:\"Configurar\";s:13:\"Save settings\";s:25:\"Guardar la configuración\";s:40:\"Session language detection configuration\";s:55:\"Configuración de la detección de idioma de la sesión\";s:36:\"URL language detection configuration\";s:48:\"Configuración de la detección de idioma de URL\";s:16:\"Detection method\";s:21:\"Método de detección\";s:11:\"Description\";s:12:\"Descripción\";s:64:\"Field type(s) in use - see <a href=\"@fields-page\">Field list</a>\";s:72:\"Tipo(s) de campo en uso - ver <a href=\"@fields-page\">lista de campos</a>\";s:54:\"@module (<span class=\"admin-disabled\">disabled</span>)\";s:57:\"@module (<span class=\"admin-disabled\">desactivado</span>)\";s:18:\"Manages web fonts.\";b:1;s:6:\"Enable\";s:7:\"Activar\";s:52:\"@module (<span class=\"admin-enabled\">enabled</span>)\";s:53:\"@module (<span class=\"admin-enabled\">activado</span>)\";s:44:\"Administrative interface for managing fonts.\";b:1;s:57:\"Aggregates syndicated content (RSS, RDF, and Atom feeds).\";s:66:\"Integra contenido sindicado (canales de noticias RSS, RDF y Atom).\";s:5:\"About\";s:9:\"Acerca de\";s:4:\"Uses\";s:4:\"Usos\";s:19:\"Positioning content\";s:22:\"Posicionando contenido\";s:22:\"Controlling visibility\";s:23:\"Controlando visibilidad\";s:22:\"Creating custom blocks\";s:30:\"Creando bloques personalizados\";s:11:\"Permissions\";s:8:\"Permisos\";s:21:\"Configure permissions\";s:19:\"Configurar permisos\";s:6:\"Blocks\";s:7:\"Bloques\";s:68:\"Enables language selector for blocks and optional block translation.\";s:80:\"Habilita el selector de idioma para bloques y la traducción de bloque opcional.\";s:25:\"Enables multi-user blogs.\";s:31:\"Activa los blogs multi usuario.\";s:66:\"Allows users to create and organize related content in an outline.\";s:83:\"Permite a los usuarios crear y organizar los contenidos relacionados en un índice.\";s:67:\"Performs bulk exporting of data objects known about by Chaos tools.\";b:1;s:42:\"Import and exports bundles through the UI.\";b:1;s:46:\"A library of helpful tools by Merlin of Chaos.\";b:1;s:41:\"Shows how to use the power of Chaos AJAX.\";b:1;s:52:\"@module (<span class=\"admin-missing\">missing</span>)\";s:52:\"@module (<span class=\"admin-missing\">ausente</span>)\";s:15:\"Changing colors\";s:17:\"Cambiando colores\";s:70:\"Allows administrators to change the color scheme of compatible themes.\";s:92:\"Permite a los administradores cambiar el esquema de color de los temas compatibles con él..\";s:27:\"Default and custom settings\";s:41:\"Opciones predeterminadas y personalizadas\";s:16:\"Comment approval\";s:25:\"Aprobación de comentario\";s:8:\"Comments\";s:11:\"Comentarios\";s:59:\"List and edit site comments and the comment approval queue.\";s:84:\"Enumerar y editar los comentarios del sitio y la cola de aprobación de comentarios.\";s:57:\"Allows users to comment on and discuss published content.\";s:63:\"Permite a los usuarios comentar y discutir contenido publicado.\";s:61:\"Enables the use of both personal and site-wide contact forms.\";s:68:\"Habilita el uso de formularios de contacto personal y a nivel sitio.\";s:63:\"Makes contact categories and replies available for translation.\";s:76:\"Permite que las categorías de contacto y las respuestas se puedan traducir.\";s:57:\"Allows content to be translated into different languages.\";s:60:\"Permite que el contenido sea traducido a diferentes idiomas.\";s:27:\"Displaying contextual links\";s:32:\"Presentando enlaces contextuales\";s:22:\"Tracking user activity\";s:37:\"Monitorizando la actividad de usuario\";s:25:\"Tracking content activity\";s:39:\"Monitorizando la actividad de contenido\";s:19:\"Customize dashboard\";s:29:\"Personalizar panel de control\";s:25:\"Customize your dashboard.\";s:32:\"Personalice su cuadro de mandos.\";s:20:\"Monitoring your site\";s:22:\"Monitorizando su sitio\";s:23:\"Debugging site problems\";s:30:\"Depurando problemas del sitio.\";s:47:\"Logs and records system events to the database.\";s:57:\"Anota y registra eventos del sistema en la base de datos.\";s:40:\"@font-your-face provider for Edge Fonts.\";b:1;s:43:\"Remove default content from the front page.\";b:1;s:20:\"Enabling field types\";s:24:\"Activando tipos de campo\";s:27:\"Managing field data storage\";s:47:\"Gestionando el almacenamiento de datos de campo\";s:57:\"Field API to add fields to entities like nodes and users.\";s:64:\"API para añadir campos a entidades tales como nodos y usuarios.\";s:37:\"Stores field data in an SQL database.\";s:54:\"Almacena los datos del campo en una base de datos SQL.\";s:26:\"Translate field properties\";s:30:\"Traducir propiedades del campo\";s:15:\"Planning fields\";s:19:\"Planeando de campos\";s:29:\"What the field will be called\";s:26:\"Cómo se llamará el campo\";s:38:\"What type of data the field will store\";s:38:\"Tipo de datos que almacenará el campo\";s:40:\"How the data will be input and displayed\";s:44:\"Como se introducirán y mostrarán los datos\";s:36:\"How many values the field will store\";s:43:\"Número de valores que almacenará el campo\";s:14:\"Reusing fields\";s:19:\"Reutilizando campos\";s:23:\"Fields on content items\";s:36:\"Campos en los elementos de contenido\";s:24:\"Fields on taxonomy terms\";s:33:\"Campos en términos de taxonomía\";s:23:\"Fields on user accounts\";s:29:\"Campos en cuentas de usuarios\";s:18:\"Fields on comments\";s:21:\"Campos en comentarios\";s:33:\"User interface for the Field API.\";s:42:\"Interfaz de usuario para el API de campos.\";s:26:\"Attaching files to content\";s:30:\"Anexando archivos al contenido\";s:27:\"Managing attachment display\";s:41:\"Gestionando presentación de los adjuntos\";s:23:\"Managing file locations\";s:34:\"Gestionando ubicación de archivos\";s:26:\"Defines a file field type.\";s:35:\"Define un tipo de campo de archivo.\";s:24:\"Configuring text formats\";s:30:\"Configurando formatos de texto\";s:24:\"Applying filters to text\";s:26:\"Aplicando filtros al texto\";s:21:\"Defining text formats\";s:28:\"Definiendo formatos de texto\";s:22:\"Choosing a text format\";s:29:\"eligiendo un formato de texto\";s:12:\"Text formats\";s:17:\"Formatos de texto\";s:43:\"Filters content in preparation for display.\";s:53:\"Filtra el contenido preparándolo para presentación.\";s:48:\"Enables fivestar ratings on content, users, etc.\";b:1;s:52:\"Iconic font designed for use with Twitter Bootstrap.\";b:1;s:56:\"Defines a field type for referencing a font from a node.\";b:1;s:50:\"@font-your-face provider with Font Squirrel fonts.\";b:1;s:52:\"@font-your-face provider of fonts from Fontdeck.com.\";b:1;s:49:\"@font-your-face provider of fonts from Fonts.com.\";b:1;s:27:\"Provides discussion forums.\";s:32:\"Proporciona foros de discusión.\";s:59:\"Provide the ability to use infinite pager on defined url\'s.\";b:1;s:48:\"Views plugins to show Google Maps from entities.\";b:1;s:48:\"GMap field types, currently only a marker field.\";b:1;s:50:\"Display location.module information on Google Maps\";s:51:\"Mostrar location.module información en Google Maps\";s:28:\"UI for building GMap macros.\";s:46:\"Interfaz de usuario para crear macros de GMap.\";s:66:\"A module that lets you add more styles to your gmap popup bubbles.\";b:1;s:22:\"Taxonomy based markers\";b:1;s:43:\"@font-your-face provider with Google fonts.\";b:1;s:26:\"Providing a help reference\";s:31:\"Proporciona ayuda de referencia\";s:32:\"Providing context-sensitive help\";s:42:\"Proporciona ayuda dependiente del contexto\";s:35:\"Manages the display of online help.\";s:52:\"Administra la presentación de la ayuda en pantalla.\";s:19:\"Manipulating images\";s:21:\"Manipulando imágenes\";s:60:\"Based on where it will be used: eg. <em>profile-picture</em>\";s:70:\"Basándose en dónde se usará; por ejemplo: <em>imagen-de_perfil</em>\";s:52:\"Describing its appearance: eg. <em>square-85x85</em>\";s:67:\"Describiendo su apariencia; por ejemplo: <em>cuadrado - 85×85</em>\";s:37:\"Attaching images to content as fields\";s:45:\"Adjuntando imágenes al contenido como campos\";s:12:\"Image styles\";s:17:\"Estilos de imagen\";s:34:\"Provides image manipulation tools.\";s:55:\"Proporciona herramientas de manipulación de imágenes.\";s:49:\"Extends Drupal support for multilingual features.\";s:63:\"Amplia el soporte de Drupal para características multi idioma.\";s:39:\"Create reusable Isotope configurations.\";b:1;s:44:\"An example of how to use the Isotope module.\";b:1;s:40:\"Create isotope views from views queries.\";b:1;s:13:\"jQuery update\";s:24:\"Actualización de jQuery\";s:53:\"Update jQuery and jQuery UI to a more recent version.\";s:66:\"Actualización a una versión más reciente de jQuery y jQuery UI.\";s:39:\"Add jQuery Waypoints plugin to the site\";b:1;s:64:\"Allows version-dependent and shared usage of external libraries.\";s:69:\"Permite versión dependiente y uso compartido de librerías externas.\";s:32:\"Defines simple link field types.\";s:43:\"Define los tipos de campo de enlace simple.\";s:69:\"Defines list field types. Use with Options to create selection lists.\";s:85:\"Define tipos de campos de listas. Uselo con opciones para crear listas de selección.\";s:26:\"Translating interface text\";s:32:\"Traduciendo texto de la interfaz\";s:64:\"Translations of text in the Drupal interface may be provided by:\";s:76:\"Las traducciones del texto de la interfaz de Drupal las pueden proporcionar:\";s:31:\"Configuring a multilingual site\";s:34:\"Configurando un sitio multi idioma\";s:58:\"Provides automatic downloads and updates for translations.\";s:75:\"Proporciona descargas y actualizaciones automáticas para las traducciones.\";s:65:\"Adds a \'Find Address\' button to all location fields that use gmap\";s:90:\"Añade un botón de \'Buscar dirección\' a todos los campos de ubicación que utilizan gmap\";s:39:\"Fill up all locations with lat&lon data\";b:1;s:30:\"Defines a Location field type.\";s:34:\"Define un tipo de campo ubicación\";s:13:\"Content types\";s:18:\"Tipos de contenido\";s:49:\"Allows you to add an email address to a location.\";b:1;s:58:\"Provide information about Location field to Entity module.\";b:1;s:5:\"Menus\";s:6:\"Menús\";s:45:\"Allows you to add a fax number to a location.\";b:1;s:52:\"Bulk assign random latitude and longitudes to nodes.\";b:1;s:8:\"Taxonomy\";s:10:\"Taxonomía\";s:47:\"Allows you to add a phone number to a location.\";s:60:\"Le permite añadir un número de teléfono a una ubicación.\";s:67:\"Manage tagging, categorization, and classification of your content.\";s:72:\"Gestionar el etiquetado, categorización y clasificación del contenido.\";s:35:\"Advanced search page for locations.\";b:1;s:4:\"view\";s:5:\"vista\";s:40:\"Associate locations with taxonomy terms.\";b:1;s:4:\"View\";s:3:\"Ver\";s:45:\"Allows you to add a www adress to a location.\";b:1;s:5:\"views\";s:6:\"vistas\";s:5:\"Views\";s:6:\"Vistas\";s:14:\"Managing menus\";s:18:\"Gestionando menús\";s:73:\"This action will permanently remove any customizations made to this view.\";s:98:\"Esta acción eliminará permanentemente cualquier personalización que se haya hecho a esta vista.\";s:27:\"The view has been reverted.\";s:29:\"Esta vista ha sido revertida.\";s:16:\"Displaying menus\";s:18:\"Presentando menús\";s:64:\"This action will permanently remove the view from your database.\";s:69:\"Esta acción eliminará permanentemente la vista de su base de datos.\";s:26:\"The view has been deleted.\";s:27:\"La vista ha sido eliminada.\";s:60:\"Allows administrators to customize the site navigation menu.\";s:77:\"Permite a los administradores personalizar el menú de navegación del sitio.\";s:40:\"Supports translatable custom menu items.\";s:54:\"Soporta elementos de menú personalizados traducibles.\";s:7:\"Disable\";s:10:\"Desactivar\";s:13:\"Module filter\";s:17:\"Filtro de módulo\";s:6:\"Revert\";s:8:\"Revertir\";s:46:\"Configure how the modules page looks and acts.\";s:58:\"Configurar como se muestra y actua la página de módulos.\";s:6:\"Delete\";s:8:\"Eliminar\";s:24:\"Filter the modules list.\";s:28:\"Filtra la lista de módulos.\";s:5:\"Clone\";s:6:\"Clonar\";s:46:\"Extended node options for multilingual content\";s:58:\"Opciones de nodo extendidas para el contenido plurilingüe\";s:6:\"Import\";s:8:\"Importar\";s:60:\"Enables multilingual forum, translates names and containers.\";s:60:\"Activa el foro multilingüe, traduce nombres y contenedores.\";s:6:\"Export\";s:8:\"Exportar\";s:45:\"API module for multilingual content selection\";s:60:\"Módulo de API para la selección de contenido multilingüe.\";s:17:\"Add a new @plugin\";b:1;s:19:\"Edit @plugin %title\";b:1;s:16:\"Creating content\";s:17:\"Creando contenido\";s:20:\"Clone @plugin %title\";b:1;s:14:\"Import @plugin\";b:1;s:29:\"Creating custom content types\";s:41:\"Creando tipos de contenido personalizados\";s:21:\"Export @plugin %title\";b:1;s:39:\"Are you sure you want to revert %title?\";b:1;s:21:\"Administering content\";s:23:\"Administrando contenido\";s:73:\"This action will permanently remove any customizations made to this item.\";b:1;s:27:\"The item has been reverted.\";b:1;s:18:\"Creating revisions\";s:18:\"Creando revisiones\";s:39:\"Are you sure you want to delete %title?\";s:45:\"¿Está seguro de que quiere eliminar %title?\";s:66:\"This action will permanently remove this item from your database..\";b:1;s:16:\"User permissions\";s:19:\"Permisos de usuario\";s:26:\"The item has been deleted.\";b:1;s:24:\"%title has been created.\";b:1;s:66:\"Allows content to be submitted to the site and displayed on pages.\";s:73:\"Permite que se envíe contenido al sitio y que se despliegue en páginas.\";s:28:\"%title could not be created.\";b:1;s:31:\"Associate locations with nodes.\";s:30:\"Asociar ubicaciones con nodos.\";s:24:\"%title has been updated.\";b:1;s:28:\"%title could not be updated.\";b:1;s:28:\"Defines numeric field types.\";s:34:\"Define tipos de campos numéricos.\";s:48:\"Allows users to log into your site using OpenID.\";s:58:\"Permite a los usuarios el inicio de sesión usando OpenID.\";s:27:\"@plugin %title was enabled.\";b:1;s:28:\"@plugin %title was disabled.\";b:1;s:32:\"There are no @titles to display.\";b:1;s:59:\"Displays the Drupal administration interface in an overlay.\";s:70:\"Presenta la interfaz administrativa de Drupal en una capa superpuesta.\";s:35:\"Manage customized lists of content.\";b:1;s:54:\"Provides a UI and API to manage pages within the site.\";b:1;s:16:\"Creating aliases\";s:13:\"Creando alias\";s:69:\"<em>member/jane-smith</em> aliased to internal path <em>user/123</em>\";s:78:\"<em>miembro/juana-garcia</em> es el alias de la ruta interna <em>user/123</em>\";s:65:\"<em>about-us/team</em> aliased to internal path <em>node/456</em>\";s:79:\"<em>sobre-nosotros/equipo</em> es el alias de la ruta interna <em>nodo/456</em>\";s:16:\"Managing aliases\";s:17:\"Gestionando alias\";s:11:\"URL aliases\";s:12:\"Alias de URL\";s:46:\"Change your site\'s URL paths by aliasing them.\";s:50:\"Cambia las rutas de URLs del sitio mediante alias.\";s:28:\"Allows users to rename URLs.\";s:43:\"Permitir a los usuarios renombrar las URLs.\";s:37:\"Define translations for generic paths\";s:42:\"Definir traducciones para rutas genéricas\";s:8:\"Settings\";s:8:\"Opciones\";s:34:\"Maximum alias and component length\";s:39:\"Máxima longitud de alias y componentes\";s:8:\"Patterns\";s:8:\"Patrones\";s:50:\"Allows embedded PHP code/snippets to be evaluated.\";s:52:\"Permite la evaluación de fragmentos de código PHP.\";s:27:\"Searching content and users\";s:29:\"Buscando contenido y usuarios\";s:26:\"Indexing content with cron\";s:28:\"Indexando contenido con cron\";s:18:\"Content reindexing\";s:24:\"Reindexando el contenido\";s:27:\"Configuring search settings\";s:34:\"Configurando opciones de búsqueda\";s:12:\"Search block\";s:19:\"Bloque de búsqueda\";s:23:\"Extending Search module\";s:33:\"Ampliando el módulo de búsqueda\";s:15:\"Search settings\";s:21:\"Opciones de búsqueda\";s:67:\"Configure relevance settings for search and other indexing options.\";s:93:\"Configurar las opciones de búsqueda por orden de relevancia y otras opciones de indexación.\";s:36:\"Enables site-wide keyword searching.\";s:50:\"Permite la búsqueda de palabras en todo el sitio.\";s:23:\"Administering shortcuts\";s:20:\"Administrando atajos\";s:22:\"Choosing shortcut sets\";s:29:\"Eligiendo conjuntos de atajos\";s:29:\"Adding and removing shortcuts\";s:30:\"Añadiendo y eliminando atajos\";s:20:\"Displaying shortcuts\";s:16:\"Mostrando atajos\";s:9:\"Shortcuts\";s:6:\"Atajos\";s:29:\"Add and modify shortcut sets.\";s:40:\"Agregar y modificar los accesos directos\";s:60:\"Allows users to manage customizable lists of shortcut links.\";s:82:\"Permitir a los usuarios gestionar las listas personalizables de enlaces de atajos,\";s:37:\"Logs access statistics for your site.\";s:40:\"Guarda estadísticas de acceso al sitio.\";s:57:\"Provides support for translation of user defined strings.\";s:75:\"Proporciona soporte para la traducción de textos definidos por el usuario.\";s:53:\"Create custom styles for applications such as Panels.\";b:1;s:74:\"Synchronizes taxonomy and fields accross translations of the same content.\";s:78:\"Sincroniza la taxonomía y los campos en las traducciones del mismo contenido.\";s:41:\"Logs and records system events to syslog.\";s:50:\"Anota y registra eventos del sistema en el syslog.\";s:16:\"Managing modules\";s:20:\"Gestionando módulos\";s:15:\"Managing themes\";s:17:\"Gestionando temas\";s:16:\"Managing caching\";s:19:\"Gestionando cachés\";s:29:\"Performing system maintenance\";s:36:\"Efectuando mantenimiento del sistema\";s:31:\"Configuring basic site settings\";s:40:\"Configurando opciones básicas del sitio\";s:19:\"Configuring actions\";s:21:\"Configurando acciones\";s:54:\"Handles general site configuration for administrators.\";s:68:\"Gestión de la configuración general del sitio por administradores.\";s:21:\"Creating vocabularies\";s:20:\"Creando vocabularios\";s:26:\"<em>vocabulary</em>: Music\";s:29:\"<em>vocabulario</em>: Música\";s:19:\"<em>term</em>: Jazz\";s:23:\"<em>término</em>: Jazz\";s:24:\"<em>sub-term</em>: Swing\";s:27:\"<em>subtérmino</em>: Swing\";s:25:\"<em>sub-term</em>: Fusion\";s:29:\"<em>subtérmino</em>: Fusión\";s:19:\"<em>term</em>: Rock\";s:23:\"<em>término</em>: Rock\";s:31:\"<em>sub-term</em>: Country rock\";s:34:\"<em>subtérmino</em>: Country rock\";s:28:\"<em>sub-term</em>: Hard rock\";s:31:\"<em>subtérmino</em>: Hard rock\";s:39:\"Assigning vocabularies to content types\";s:43:\"Asignando vocabularios a tipos de contenido\";s:19:\"Classifying content\";s:22:\"Clasificando contenido\";s:38:\"Viewing listings and RSS feeds by term\";s:59:\"Ver los lostados y los canales de noticias RSS por término\";s:25:\"Extending Taxonomy module\";s:34:\"Ampliando el módulo de taxonomía\";s:38:\"Enables the categorization of content.\";s:41:\"Permite la categorización del contenido.\";s:30:\"Enables multilingual taxonomy.\";s:34:\"Activa la taxonomía multi idioma.\";s:48:\"Controls access to context based upon term depth\";b:1;s:53:\"Provides a framework for unit and functional testing.\";s:74:\"Proporciona un entorno para la ejecución de test unitarios y funcionales.\";s:32:\"Defines simple text field types.\";s:38:\"Define tipos de campo de texto simple.\";s:9:\"Tutorials\";s:10:\"Tutoriales\";s:6:\"Author\";s:5:\"Autor\";s:5:\"!path\";s:5:\"!path\";s:74:\"ThemeKey rule that switches the theme if the user\'s role is \"premium user\"\";b:1;s:63:\"ThemeKey rule that switches the theme on content creation forms\";b:1;s:55:\"ThemeKey rule chain selecting special theme for iPhones\";b:1;s:33:\"Sophisticated ThemeKey rule chain\";b:1;s:9:\"Have Fun!\";s:11:\"¡Disfrute!\";s:37:\"Versions used to create this tutorial\";s:41:\"Versiones usadas para crear este tutorial\";s:8:\"ThemeKey\";s:8:\"ThemeKey\";s:19:\"ThemeKey Properties\";s:23:\"Propiedades de ThemeKey\";s:8:\"Examples\";s:8:\"Ejemplos\";s:42:\"Set a special theme for site administrator\";s:62:\"Establecer un tema especial para los administradores del sitio\";s:31:\"Create a Theme Switching Rules:\";b:1;s:55:\"Select a theme for Firefox 3.0.x, but not Firefox 3.5.x\";b:1;s:40:\"Cascade following Theme Switching Rules:\";b:1;s:23:\"Select a theme for IE 6\";b:1;s:33:\"Select a theme for Christmas 2009\";b:1;s:32:\"Select a theme for New Year 2010\";b:1;s:30:\"Create a Theme Switching Rule:\";b:1;s:9:\"Supported\";s:9:\"Se admite\";s:20:\"Properties explained\";s:26:\"Las propiedades explicadas\";s:10:\"Page Cache\";s:17:\"Caché de página\";s:10:\"Deprecated\";b:1;s:19:\"Operators explained\";s:25:\"Los operadores explicados\";s:34:\"<strong>!</strong><br />not equals\";b:1;s:32:\"<strong>*</strong><br />contains\";b:1;s:37:\"<strong>!*</strong><br />not contains\";b:1;s:10:\"PHP Manual\";s:13:\"Manual de PHP\";s:48:\"Map themes to Drupal paths or object properties.\";s:57:\"Asignar temas de Drupal a rutas o propiedades de objetos.\";s:66:\"Define rules to dynamically add CSS files to a page. Experimental!\";b:1;s:66:\"Implements parts of the ThemeKey API as an example for Developers.\";b:1;s:34:\"Export single rules with Features.\";b:1;s:71:\"Provides an additional rule chain to define rules to redirect the user.\";b:1;s:48:\"Just a fake module for testing ThemeKey plugins.\";b:1;s:53:\"Integrates ThemeKey with Drupal administration forms.\";s:66:\"Integra ThemeKey con los formularios de administración de Drupal.\";s:73:\"Provides a user interface for the Token API and some missing core tokens.\";s:126:\"Proporciona una interfaz de usuario para el API de comodines, además de algunos comodines que faltan en el núcleo de Drupal.\";s:31:\"Displaying administrative links\";s:33:\"Mostrando enlaces administrativos\";s:45:\"Enables tracking of recent content for users.\";s:63:\"Activa el seguimiento del contenido reciente para los usuarios.\";s:69:\"Provides an overview of the translation status of the site\'s content.\";s:74:\"Proporciona un  resumen del estado de traducción del contenido del sitio.\";s:71:\"Redirect to translated page when available. SEO for multilingual sites.\";s:87:\"Redirigir a la página traducida cuando esté diponible. SEO para sitios multilingües.\";s:47:\"Simple translation sets API for generic objects\";s:62:\"API simple de conjuntos de traducción para objetos genéricos\";s:11:\"File system\";s:19:\"Sistema de archivos\";s:68:\"Tell Drupal where to store uploaded files and how they are accessed.\";s:82:\"Indicar a Drupal dónde se deben almacenar los archivos y cómo se accede a ellos.\";s:61:\"Converts non-latin text to US-ASCII and sanitizes file names.\";s:69:\"Convierte texto no latino a US-ASCII y limpia los nombres de archivo.\";s:48:\"@font-your-face provider with Typekit.com fonts.\";b:1;s:30:\"Checking for available updates\";s:36:\"Buscando actualizaciones disponibles\";s:45:\"Performing updates through the user interface\";s:48:\"Actualizando a través de la interfaz de usuario\";s:60:\"Installing new modules and themes through the user interface\";s:70:\"Instalando nuevos módulos y temas a través de la interfaz de usuario\";s:27:\"Creating and managing users\";s:30:\"Creando y gestionando usuarios\";s:26:\"User roles and permissions\";s:28:\"Roles y permisos de usuarios\";s:16:\"Account settings\";s:27:\"Configuración de la cuenta\";s:47:\"Manages the user registration and login system.\";s:69:\"Administra el registro de usuarios y el sistema de inicio de sesión.\";s:31:\"Associate locations with users.\";b:1;s:43:\"Translate emails sent from the User module.\";s:53:\"Traducir los correos enviados desde el modulo Usuario\";s:43:\"Variable Information and basic variable API\";b:1;s:26:\"Variable Administration UI\";b:1;s:49:\"API to use variable realms from different modules\";s:58:\"API para usar ámbitos de variables de diferentes módulos\";s:4:\"Name\";s:6:\"Nombre\";s:60:\"Database storage for variable realms. This is an API module.\";b:1;s:71:\"Multilingual variables that switch language depending on page language.\";s:83:\"Variables plurilingües que cambian de idioma dependiendo del idioma de la página.\";s:21:\"(Machine name: @type)\";s:26:\"(Nombre de sistema: @type)\";s:13:\"manage fields\";s:16:\"gestionar campos\";s:51:\"Provides Brightcove handler for Video Embed Fields.\";b:1;s:14:\"manage display\";s:23:\"gestionar presentación\";s:65:\"No content types available. <a href=\"@link\">Add content type</a>.\";s:84:\"Ningún tipo de contenido disponible. <a href=\"@link\">Agregar tipo de contenido</a>.\";s:63:\"Expose a field type for embedding videos from youtube or vimeo.\";b:1;s:55:\"Create customized lists and queries from your database.\";s:60:\"Crear listas y consultas personalizadas de la base de datos.\";s:16:\"Add content type\";s:25:\"Añadir tipo de contenido\";s:46:\"Provides an Infinite Scrolling pager for Views\";b:1;s:9:\"Void Menu\";b:1;s:20:\"Configure Void Menu.\";b:1;s:71:\"Provides a series of new menu items that will accept any custom values.\";b:1;s:47:\"Provides a shared voting API for other modules.\";s:64:\"Proporciona una API compartida de votación para otros módulos.\";s:16:\"Wysiwyg profiles\";s:27:\"Perfiles del editor Wysiwyg\";s:30:\"Configure client-side editors.\";s:45:\"Configurar los editores del lado del cliente.\";s:48:\"Allows to edit content with client-side editors.\";b:1;s:38:\"Adds list of enabled fonts to WYSIWYG.\";b:1;s:15:\"@font-your-face\";b:1;s:7:\"Version\";s:8:\"Versión\";s:4:\"Core\";s:7:\"Núcleo\";s:35:\"Multilingual - Internationalization\";s:34:\"Multidioma - Internacionalización\";s:16:\"Chaos tool suite\";b:1;s:6:\"Fields\";s:6:\"Campos\";s:5:\"Other\";s:7:\"Otro(s)\";s:6:\"Voting\";s:9:\"Votación\";s:14:\"user-interface\";b:1;s:8:\"Location\";s:10:\"Ubicación\";s:12:\"Multilingual\";s:12:\"Multi idioma\";s:15:\"Example modules\";b:1;s:8:\"Variable\";s:8:\"Variable\";s:4:\"Menu\";s:5:\"Menú\";s:8:\"Required\";s:11:\"Obligatorio\";s:11:\"Unavailable\";s:13:\"No disponible\";s:11:\"Filter list\";s:16:\"Lista de filtros\";s:6:\"Update\";s:10:\"Actualizar\";s:9:\"Uninstall\";s:11:\"Desinstalar\";s:18:\"Install new module\";s:22:\"Instalar nuevo módulo\";s:5:\"Links\";s:7:\"Enlaces\";s:24:\"Version: !module-version\";s:25:\"Versión: !module-version\";s:25:\"Required by: !module-list\";s:28:\"Necesitado por: !module-list\";s:22:\"Requires: !module-list\";s:22:\"Necesita: !module-list\";s:15:\"Add new content\";s:23:\"Añadir nuevo contenido\";s:24:\"Submission form settings\";s:33:\"Opciones del formulario de envío\";s:17:\"Title field label\";s:29:\"Etiqueta del campo de título\";s:25:\"Preview before submitting\";s:29:\"Previsualizar antes de enviar\";s:8:\"Optional\";s:8:\"Opcional\";s:36:\"Explanation or submission guidelines\";s:39:\"Explicación o directrices para envíos\";s:18:\"Publishing options\";s:24:\"Opciones de publicación\";s:15:\"Default options\";s:21:\"Opciones predefinidas\";s:9:\"Published\";s:9:\"Publicado\";s:22:\"Promoted to front page\";s:22:\"Promovido a la portada\";s:22:\"Sticky at top of lists\";s:30:\"Fijo al comienzo de las listas\";s:19:\"Create new revision\";s:21:\"Crear nueva revisión\";s:16:\"Display settings\";s:25:\"Opciones de presentación\";s:36:\"Display author and date information.\";s:39:\"Mostrar información del autor y fecha.\";s:51:\"Author username and publish date will be displayed.\";s:61:\"Se mostrarán el nombre del autor y la fecha de publicación.\";s:17:\"Save content type\";s:28:\"Guardar el tipo de contenido\";s:19:\"Delete content type\";s:29:\"Eliminar el tipo de contenido\";s:16:\"Comment settings\";s:23:\"Opciones de comentarios\";s:39:\"Default comment setting for new content\";s:61:\"Opción predeterminada de comentarios para el nuevo contenido\";s:4:\"Open\";s:7:\"Abierta\";s:6:\"Closed\";s:7:\"Cerrado\";s:6:\"Hidden\";s:6:\"Oculto\";s:9:\"Threading\";s:20:\"Hilos de comentarios\";s:40:\"Show comment replies in a threaded list.\";s:63:\"Mostrar las respuestas a los comentarios en una lista de hilos.\";s:17:\"Comments per page\";s:23:\"Comentarios por página\";s:20:\"Anonymous commenting\";s:19:\"Comentario anónimo\";s:57:\"Anonymous posters may not enter their contact information\";s:68:\"Los remitentes anónimos no pueden dejar su información de contacto\";s:53:\"Anonymous posters may leave their contact information\";s:65:\"Los remitentes anónimos pueden dejar su información de contacto\";s:54:\"Anonymous posters must leave their contact information\";s:64:\"Los remitentes anónimos deben dejar su información de contacto\";s:19:\"Allow comment title\";s:30:\"Permitir título de comentario\";s:44:\"Show reply form on the same page as comments\";s:74:\"Mostrar el formulario de respuesta en la misma página que los comentarios\";s:15:\"Preview comment\";s:27:\"Vista previa del comentario\";s:20:\"Multilingual support\";s:21:\"Soporte multilenguaje\";s:9:\"Main menu\";s:15:\"Menú principal\";s:10:\"Management\";b:1;s:10:\"Navigation\";s:11:\"Navegación\";s:9:\"User menu\";b:1;s:13:\"Menu settings\";s:18:\"Opciones del menú\";s:15:\"Available menus\";s:16:\"Menú disponible\";s:60:\"The menus available to place links in for this content type.\";s:71:\"Los menús disponibles para situar enlaces para este tipo de contenido.\";s:31:\"Select and configure your theme\";s:32:\"Seleccionar y configurar su tema\";s:46:\"Configure default and theme specific settings.\";s:68:\"Configurar las opciones predeterminadas y específicas de los temas.\";s:6:\"Bartik\";s:6:\"Bartik\";s:15:\"Global settings\";s:17:\"Opciones globales\";s:5:\"Seven\";s:5:\"Seven\";s:16:\"Bootstrap Agency\";b:1;s:25:\"Bootstrap Sub-Theme (CDN)\";b:1;s:17:\"Install new theme\";s:19:\"Instalar nuevo tema\";s:15:\"Add text format\";s:24:\"Añadir formato de texto\";s:18:\"Logging and errors\";s:18:\"Registro y errores\";s:16:\"Maintenance mode\";s:21:\"Modo de mantenimiento\";s:62:\"Take the site offline for maintenance or bring it back online.\";s:65:\"Desconectar el sitio para su mantenimiento o volverlo a conectar.\";s:11:\"Performance\";s:11:\"Rendimiento\";s:15:\"Transliteration\";s:16:\"Transliteración\";s:40:\"Convert existing file names to US-ASCII.\";s:55:\"Convertir los nombres de archivo existentes a US-ASCII.\";s:9:\"Add style\";s:14:\"Añadir estilo\";s:22:\"Add a new image style.\";s:31:\"Agregar nuevo estilo de imagen.\";s:42:\"List the current image styles on the site.\";s:50:\"Enumerar los actuales estilos de imagen del sitio.\";s:13:\"Image toolkit\";s:34:\"Juego de herramientas de imágenes\";s:74:\"Choose which image toolkit to use if you have installed optional toolkits.\";s:92:\"Elegir qué juego de herramientas de imágenes quiere usar si ha instalado otros opcionales.\";s:14:\"Manage display\";s:23:\"Gestionar presentación\";s:7:\"Comment\";s:10:\"Comentario\";s:12:\"Full comment\";s:19:\"Comentario completo\";s:18:\"@node_type comment\";s:24:\"comentario de @node_type\";s:4:\"Node\";s:4:\"Nodo\";s:12:\"Full content\";s:18:\"Contenido completo\";s:6:\"Teaser\";s:7:\"Resumen\";s:3:\"RSS\";s:3:\"RSS\";s:12:\"Search index\";s:20:\"Índice de búsqueda\";s:32:\"Search result highlighting input\";s:39:\"Resaltando el resultado de la búsqueda\";s:4:\"File\";s:7:\"Archivo\";s:13:\"Taxonomy term\";s:22:\"Término de taxonomía\";s:18:\"Taxonomy term page\";s:34:\"Página de términos de taxonomía\";s:19:\"Taxonomy vocabulary\";s:25:\"Vocabulario de taxonomía\";s:15:\"Wysiwyg profile\";b:1;s:6:\"Tokens\";s:9:\"Comodines\";s:13:\"Manage fields\";s:16:\"Gestionar campos\";s:19:\"IP address blocking\";s:24:\"Bloqueo de dirección IP\";s:28:\"Manage blocked IP addresses.\";s:36:\"Gestionar direcciones IP bloqueadas.\";s:7:\"Formats\";s:8:\"Formatos\";s:51:\"Configure display format strings for date and time.\";s:48:\"Configurar formato de cadenas para fecha y hora.\";s:10:\"Add format\";s:15:\"Añadir formato\";s:43:\"Allow users to add additional date formats.\";s:62:\"Permitir a los usuarios añadir formatos de fecha adicionales.\";s:5:\"Types\";s:5:\"Tipos\";s:13:\"Add date type\";s:21:\"Añadir tipo de fecha\";s:18:\"Add new date type.\";s:28:\"Añadir nuevo tipo de fecha.\";s:8:\"Localize\";s:12:\"Regionalizar\";s:38:\"Configure date formats for each locale\";s:46:\"Configurar formatos de fecha para cada región\";s:8:\"Overview\";s:13:\"Vista general\";s:9:\"Translate\";s:8:\"Traducir\";s:10:\"Clean URLs\";s:11:\"URL limpias\";s:43:\"Enable or disable clean URLs for your site.\";s:45:\"Activar o desactivar URL limpias en su sitio.\";s:11:\"Clear index\";s:15:\"Limpiar índice\";s:9:\"Add alias\";s:13:\"Añadir alias\";s:13:\"Bulk generate\";b:1;s:14:\"Delete aliases\";s:12:\"Borrar alias\";s:7:\"Actions\";s:8:\"Acciones\";s:41:\"Manage the actions defined for your site.\";s:47:\"Gestionar las acciones definidas para su sitio.\";s:28:\"Configure an advanced action\";s:31:\"Configurar una acción avanzada\";s:14:\"Manage actions\";s:18:\"Gestionar acciones\";s:4:\"Cron\";s:4:\"Cron\";s:40:\"Manage automatic site maintenance tasks.\";s:49:\"Administrar tareas de mantenimiento automáticas.\";s:16:\"Site information\";s:22:\"Información del sitio\";s:16:\"Add shortcut set\";s:36:\"Añadir conjunto de accesos directos\";s:4:\"Ajax\";s:4:\"Ajax\";s:7:\"General\";s:7:\"General\";s:26:\"Theme Switching Rule Chain\";s:42:\"Encadenamiento de reglas de cambio de tema\";s:14:\"RSS publishing\";s:16:\"Publicación RSS\";s:18:\"Published comments\";s:22:\"Comentarios publicados\";s:28:\"Unapproved comments (@count)\";s:32:\"Comentarios sin aprobar (@count)\";s:36:\"Configure available dashboard blocks\";s:54:\"Configurar los bloques de panel de control disponibles\";s:53:\"Configure which blocks can be shown on the dashboard.\";s:68:\"Configurar los bloques que se pueden mostrar en el panel de control.\";s:5:\"block\";b:1;s:5:\"color\";b:1;s:7:\"comment\";b:1;s:10:\"contextual\";b:1;s:9:\"dashboard\";b:1;s:5:\"dblog\";b:1;s:5:\"field\";s:5:\"campo\";s:17:\"field_sql_storage\";b:1;s:8:\"field_ui\";b:1;s:4:\"file\";s:7:\"archivo\";s:6:\"filter\";s:6:\"filtro\";s:4:\"help\";b:1;s:5:\"image\";s:6:\"imagen\";s:4:\"list\";b:1;s:4:\"menu\";s:5:\"menú\";s:4:\"node\";s:4:\"nodo\";s:7:\"options\";b:1;s:6:\"system\";s:7:\"sistema\";s:8:\"taxonomy\";s:10:\"taxonomía\";s:4:\"text\";b:1;s:4:\"user\";s:7:\"usuario\";s:6:\"number\";b:1;s:4:\"path\";b:1;s:3:\"rdf\";b:1;s:6:\"search\";s:6:\"buscar\";s:8:\"shortcut\";b:1;s:7:\"toolbar\";b:1;s:6:\"update\";s:10:\"actualizar\";s:8:\"themekey\";b:1;s:13:\"jquery_update\";b:1;s:6:\"locale\";s:16:\"regionalización\";s:8:\"pathauto\";s:24:\"Alias automático de URL\";s:5:\"token\";b:1;s:7:\"wysiwyg\";b:1;s:8:\"Add user\";s:15:\"Añadir usuario\";s:50:\"Find and manage people interacting with your site.\";s:62:\"Encontrar y gestionar qué personas interactúan con su sitio.\";s:64:\"Determine access to features by selecting permissions for roles.\";s:86:\"Determina el acceso a las características mediante selección de permisos para roles.\";s:5:\"Roles\";s:5:\"Roles\";s:30:\"List, edit, or add user roles.\";s:42:\"Listar, editar o agregar roles de usuario.\";s:10:\"Field list\";s:15:\"Lista de campos\";s:39:\"Overview of fields on all entity types.\";s:67:\"Información general de los campos en todos los tipos de entidades.\";s:13:\"Used in views\";s:14:\"Usado en views\";s:37:\"Overview of fields used in all views.\";s:49:\"Resumen de los campos usados en todas las vistas.\";s:19:\"Recent log messages\";s:31:\"Mensajes recientes del registro\";s:43:\"View events that have recently been logged.\";s:42:\"Ver los eventos registrados recientemente.\";s:13:\"Status report\";s:17:\"Informe de estado\";s:74:\"Get a status report about your site\'s operation and any detected problems.\";s:86:\"Recibir un informe del estado funcional de su sitio y de cualquier problema detectado.\";s:26:\"Top \'access denied\' errors\";s:40:\"Principales errores de \"acceso denegado\"\";s:35:\"View \'access denied\' errors (403s).\";s:43:\"Ver los errores de \"acceso denegado\" (403).\";s:27:\"Top \'page not found\' errors\";s:46:\"Principales errores de \"página no encontrada\"\";s:36:\"View \'page not found\' errors (404s).\";s:49:\"Ver los errores de \"página no encontrada\" (404).\";s:18:\"Top search phrases\";s:36:\"Frases principales en las búsquedas\";s:33:\"View most popular search phrases.\";s:48:\"Ver las frases más populares en las búsquedas.\";s:17:\"Available updates\";s:27:\"Actualizaciones disponibles\";s:27:\"Install new module or theme\";s:29:\"Instalar tema o módulo nuevo\";s:13:\"Views plugins\";s:19:\"Extensión de Views\";s:38:\"Overview of plugins used in all views.\";s:54:\"Resumen de extensiones utilizados en todas las vistas.\";s:9:\"Add block\";s:14:\"Añadir bloque\";s:8:\"Add menu\";s:13:\"Añadir menú\";s:10:\"List menus\";s:15:\"Lista de menús\";s:14:\"Add vocabulary\";s:19:\"Añadir vocabulario\";s:12:\"Add new view\";s:19:\"Añadir nueva Vista\";s:22:\"Add view from template\";s:29:\"Agregar vista desde plantilla\";s:8:\"Advanced\";s:8:\"Avanzado\";s:5:\"Basic\";s:7:\"Básico\";s:12:\"Compose tips\";s:28:\"Recomendaciones de escritura\";s:6:\"Search\";s:6:\"Buscar\";s:5:\"Users\";s:8:\"Usuarios\";s:8:\"disabled\";s:11:\"desactivado\";s:20:\"Request new password\";s:31:\"Solicitar una nueva contraseña\";s:19:\"Default parent item\";s:38:\"Elemento de menú padre predeterminado\";s:21:\"Machine-readable name\";s:17:\"Nombre de sistema\";s:12:\"Machine name\";s:17:\"Nombre de sistema\";s:14:\"Comment fields\";s:21:\"Campos de comentarios\";s:15:\"Comment display\";s:28:\"Presentación de comentarios\";s:23:\"This field is required.\";s:26:\"Este campo es obligatorio.\";s:13:\"Vertical Tabs\";s:20:\"Pestañas verticales\";s:13:\"Not published\";s:12:\"No publicado\";s:17:\"Parent menu items\";s:24:\"Elementos de menú padre\";s:57:\"You must enable the @required modules to install @module.\";b:1;s:37:\"Some required modules must be enabled\";s:47:\"Algunos módulos requeridos deben ser activados\";s:42:\"Would you like to continue with the above?\";s:35:\"¿Quiere continuar con lo anterior?\";s:8:\"Continue\";s:9:\"Continuar\";s:6:\"Cancel\";s:8:\"Cancelar\";s:5:\"Files\";s:8:\"Archivos\";s:5:\"Title\";s:7:\"Título\";s:17:\"Content revisions\";s:23:\"Revisiones de contenido\";s:14:\"Taxonomy terms\";s:23:\"Términos de taxonomía\";s:3:\"...\";s:3:\"...\";s:30:\"Translate user-defined strings\";s:45:\"Traducir las cadenas definidas por el usuario\";s:23:\"Translate admin strings\";s:35:\"Traducir cadenas de administración\";s:17:\"Administer blocks\";s:19:\"Administrar bloques\";s:40:\"Administer comments and comment settings\";s:49:\"Administrar comentarios y opciones de comentarios\";s:13:\"View comments\";s:15:\"Ver comentarios\";s:13:\"Post comments\";s:20:\"Publicar comentarios\";s:21:\"Skip comment approval\";s:32:\"Omitir aprobación de comentario\";s:17:\"Edit own comments\";s:26:\"Editar comentarios propios\";s:20:\"Use contextual links\";s:25:\"Usar enlaces contextuales\";s:70:\"Use contextual links to perform actions related to elements on a page.\";s:95:\"Usar enlaces contextuales para ejecutar acciones relacionadas con los elementos de una página.\";s:19:\"Use CTools importer\";b:1;s:33:\"View the administrative dashboard\";s:38:\"Ver el panel de control administrativo\";s:16:\"Vocabulary terms\";b:1;s:30:\"All the terms in a vocabulary.\";b:1;s:10:\"Vocabulary\";s:11:\"Vocabulario\";s:10:\"User links\";b:1;s:34:\"User links of the referenced user.\";b:1;s:12:\"User picture\";s:18:\"Imagen del usuario\";s:22:\"The picture of a user.\";b:1;s:12:\"User profile\";b:1;s:22:\"The profile of a user.\";b:1;s:14:\"User signature\";b:1;s:24:\"The signature of a user.\";b:1;s:16:\"Term description\";s:25:\"Descripción del término\";s:17:\"Term description.\";b:1;s:4:\"Term\";s:8:\"Término\";s:21:\"List of related terms\";b:1;s:71:\"Terms related to an existing term; may be child, siblings or top level.\";b:1;s:9:\"Term name\";s:19:\"Nombre del término\";s:31:\"The name of this taxonomy term.\";b:1;s:20:\"Advanced search form\";b:1;s:36:\"A search form with advanced options.\";b:1;s:8:\"Keywords\";s:14:\"Palabras clave\";s:7:\"Widgets\";s:9:\"Controles\";s:14:\"Search results\";s:26:\"Resultados de la búsqueda\";s:39:\"The results of a search using keywords.\";b:1;s:46:\"Add the action links (local tasks) as content.\";b:1;s:13:\"Page elements\";b:1;s:10:\"Breadcrumb\";b:1;s:36:\"Add the breadcrumb trail as content.\";b:1;s:10:\"Feed icons\";b:1;s:45:\"Add the site feed_icons statement as content.\";b:1;s:49:\"Add the help text of the current page as content.\";b:1;s:9:\"Site logo\";b:1;s:30:\"Add the logo trail as content.\";b:1;s:15:\"Status messages\";b:1;s:55:\"Add the status messages of the current page as content.\";b:1;s:24:\"Primary navigation links\";b:1;s:47:\"Add the primary_links (local tasks) as content.\";b:1;s:26:\"Secondary navigation links\";b:1;s:49:\"Add the secondary_links (local tasks) as content.\";b:1;s:9:\"Site name\";s:20:\"Nombre del sitio web\";s:57:\"The name of the site, optionally links to the front page.\";b:1;s:11:\"Site slogan\";s:14:\"Lema del sitio\";s:33:\"Add the site\'s slogan as content.\";b:1;s:4:\"Tabs\";s:9:\"Pestañas\";s:38:\"Add the tabs (local tasks) as content.\";b:1;s:10:\"Page title\";s:21:\"Título de la página\";s:30:\"Add the page title as content.\";b:1;s:28:\"Node form author information\";b:1;s:36:\"Author information on the Node form.\";b:1;s:4:\"Form\";s:10:\"Formulario\";s:24:\"Node form submit buttons\";b:1;s:33:\"Submit buttons for the node form.\";b:1;s:26:\"Node form comment settings\";b:1;s:34:\"Comment settings on the Node form.\";b:1;s:19:\"Node form languages\";b:1;s:28:\"The language selection form.\";b:1;s:30:\"Node form revision log message\";b:1;s:34:\"Revision log message for the node.\";b:1;s:23:\"Node form menu settings\";b:1;s:31:\"Menu settings on the Node form.\";b:1;s:27:\"Node form url path settings\";b:1;s:36:\"Publishing options on the Node form.\";b:1;s:28:\"Node form publishing options\";b:1;s:21:\"Node form title field\";b:1;s:20:\"The node title form.\";b:1;s:14:\"Attached files\";b:1;s:37:\"A list of files attached to the node.\";b:1;s:11:\"Node author\";b:1;s:34:\"The author of the referenced node.\";b:1;s:9:\"Node body\";b:1;s:32:\"The body of the referenced node.\";b:1;s:13:\"Node comments\";b:1;s:36:\"The comments of the referenced node.\";b:1;s:12:\"Comment form\";b:1;s:28:\"A form to add a new comment.\";b:1;s:26:\"Comments and comment form.\";b:1;s:54:\"The comments and comment form for the referenced node.\";b:1;s:12:\"Node content\";b:1;s:35:\"The content of the referenced node.\";b:1;s:17:\"Node created date\";b:1;s:41:\"The date the referenced node was created.\";b:1;s:10:\"Node links\";b:1;s:34:\"Node links of the referenced node.\";b:1;s:10:\"Node terms\";b:1;s:38:\"Taxonomy terms of the referenced node.\";b:1;s:10:\"Node title\";b:1;s:33:\"The title of the referenced node.\";b:1;s:21:\"Node type description\";b:1;s:22:\"Node type description.\";b:1;s:22:\"Node last updated date\";b:1;s:46:\"The date the referenced node was last updated.\";b:1;s:13:\"Existing node\";b:1;s:37:\"Add a node from your site as content.\";b:1;s:6:\"Custom\";s:13:\"Personalizado\";s:12:\"Entity field\";b:1;s:12:\"General form\";b:1;s:62:\"Everything in the form that is not displayed by other content.\";b:1;s:18:\"Entity extra field\";b:1;s:14:\"Custom content\";b:1;s:20:\"Comment created date\";b:1;s:44:\"The date the referenced comment was created.\";b:1;s:13:\"Comment links\";b:1;s:40:\"Comment links of the referenced comment.\";b:1;s:18:\"Comment Reply Form\";b:1;s:34:\"A form to add a new comment reply.\";b:1;s:5:\"Block\";s:6:\"Bloque\";s:47:\"Display the comment with standard comment view.\";s:59:\"Mostrar el comentario con la vista estándar de comentario.\";s:27:\"Display the comment as RSS.\";s:32:\"Mostrar los comentarios como RSS\";s:44:\"Display the content with standard node view.\";s:52:\"Mostrar el contenido con la vista estándar de nodo.\";s:19:\"Content ID from URL\";s:25:\"ID de contenido desde URL\";s:25:\"Taxonomy term ID from URL\";s:41:\"ID de término de taxonomía desde la URL\";s:41:\"Display the user with standard user view.\";s:54:\"Mostrar el usuario con la vista estándar del usuario.\";s:16:\"User ID from URL\";s:27:\"La ID del usuario de la URL\";s:27:\"User ID from logged in user\";s:41:\"La ID de usuario del usuario identificado\";s:6:\"Master\";s:7:\"Maestro\";s:31:\"Default settings for this view.\";s:43:\"Configuración por defecto para esta vista.\";s:4:\"Page\";s:7:\"Página\";s:54:\"Display the view as a page, with a URL and menu links.\";s:62:\"Mostrar la vista como página, con una URL y enlaces de menú.\";s:28:\"Display the view as a block.\";s:32:\"Mostrar la vista como un bloque.\";s:10:\"Attachment\";s:7:\"Adjunto\";s:4:\"Feed\";s:4:\"Feed\";s:48:\"Display the view as a feed, such as an RSS feed.\";s:55:\"Presentar la vista como canal del tipo de un canal RSS.\";s:5:\"Embed\";s:9:\"Incrustar\";s:60:\"Provide a display which can be embedded using the views api.\";s:78:\"Provee una visualización que puede ser incrustada utilizando la API de Views.\";s:22:\"Empty display extender\";s:34:\"Extensor  de visualización vacía\";s:16:\"Unformatted list\";s:17:\"Lista sin formato\";s:32:\"Displays rows one after another.\";s:32:\"Muestra las filas una tras otra.\";s:9:\"HTML list\";s:10:\"Lista HTML\";s:30:\"Displays rows as an HTML list.\";s:36:\"Presentar filas como una lista HTML.\";s:4:\"Grid\";s:11:\"Cuadrícula\";s:24:\"Displays rows in a grid.\";s:33:\"Mostrar filas en una cuadrícula.\";s:5:\"Table\";s:5:\"Tabla\";s:25:\"Displays rows in a table.\";s:31:\"Mostrar las filas en una tabla.\";s:39:\"Displays the default summary as a list.\";s:46:\"Presenta el resumen predeterminado como lista.\";s:11:\"Unformatted\";s:11:\"Sin formato\";s:8:\"RSS Feed\";s:9:\"Canal RSS\";s:34:\"Generates an RSS feed from a view.\";s:44:\"Genera una fuente RSS a partir de una vista.\";s:46:\"Displays the fields with an optional template.\";s:47:\"Presenta los campos con una plantilla opcional.\";s:28:\"Display fields as RSS items.\";s:38:\"Mostrar los campos como elementos RSS.\";s:11:\"Fixed value\";s:10:\"Valor fijo\";s:8:\"PHP Code\";s:11:\"Código PHP\";s:18:\"Raw value from URL\";s:27:\"Valor en bruto desde el URL\";s:7:\"Numeric\";s:9:\"Numérico\";s:4:\"None\";s:7:\"Ninguno\";s:31:\"Will be available to all users.\";s:43:\"Estará disponible para todos los usuarios.\";s:4:\"Role\";s:3:\"Rol\";s:64:\"Access will be granted to users with any of the specified roles.\";s:73:\"Se dará acceso a los usuarios con cualquiera de los roles especificados.\";s:10:\"Permission\";s:7:\"Permiso\";s:69:\"Access will be granted to users with the specified permission string.\";s:71:\"Se permitirá el acceso de los usuarios con los permisos especificados.\";s:9:\"SQL Query\";s:12:\"Consulta SQL\";s:62:\"Query will be generated and run using the Drupal database API.\";s:78:\"La consulta se creará y ejecutará usando la API de bases de datos de Drupal.\";s:25:\"No caching of Views data.\";s:37:\"No hay caché de los datos de vistas.\";s:10:\"Time-based\";s:17:\"Con base temporal\";s:34:\"Simple time-based caching of data.\";s:40:\"Caché de datos simple de base temporal.\";s:18:\"Basic exposed form\";s:27:\"Formulario básico expuesto\";s:14:\"Input required\";s:17:\"Entrada requerida\";s:73:\"An exposed form that only renders a view if the form contains user input.\";s:101:\"Un formulario expuesto que solamente produce una vista si el formulario contiene entradas de usuario.\";s:17:\"Display all items\";s:27:\"Mostrar todos los elementos\";s:43:\"Display all items that this view might find\";s:58:\"Mostrar todos los elementos que esta vista pueda encontrar\";s:35:\"Display a specified number of items\";s:43:\"Mostrar un número específico de elementos\";s:57:\"Display a limited number items that this view might find.\";s:74:\"Mostrar un número limitado de elementos que esta vista podría encontrar.\";s:24:\"Paged output, full pager\";s:35:\"Salida paginada, paginador completo\";s:4:\"Full\";s:8:\"Completo\";s:31:\"Paged output, full Drupal style\";s:39:\"Salida paginada, estilo Drupal completo\";s:24:\"Paged output, mini pager\";s:31:\"Salida paginada, mini paginador\";s:4:\"Mini\";s:4:\"Mini\";s:26:\"Use the mini pager output.\";s:33:\"Usar la salida de mini paginador.\";s:42:\"Do not pass admin strings for translation.\";s:57:\"No pasar las cadenas administrativas para su traducción.\";s:9:\"Jump menu\";s:12:\"Menú saltar\";s:67:\"Customizing the dashboard requires the !permission-name permission.\";s:78:\"Para personalizar el panel de control se requiere el permiso !permission-name.\";s:35:\"Administer text formats and filters\";s:39:\"Administrar formatos de texto y filtros\";s:32:\"Use the !text_format text format\";s:36:\"Use el formato de texto !text_format\";s:23:\"Administer image styles\";s:29:\"Administrar estilos de imagen\";s:20:\"Administer languages\";s:19:\"Administrar idiomas\";s:25:\"Translate interface texts\";s:30:\"Traducir textos de la interfaz\";s:31:\"Administer menus and menu items\";s:39:\"Administrar menús y elementos de menú\";s:24:\"Administer Module Filter\";s:30:\"Administrar Filtro de Módulos\";s:37:\"Configure how Module Filter performs.\";s:46:\"Configura como funciona el Filtro de Módulos.\";s:29:\"Bypass content access control\";s:41:\"Sortear el control de acceso al contenido\";s:72:\"View, edit and delete all content regardless of permission restrictions.\";s:93:\"Ver, editar y borrar todo el contenido sin tener en cuenta las restricciones de los permisos.\";s:24:\"Administer content types\";s:30:\"Administrar tipos de contenido\";s:18:\"Administer content\";s:21:\"Administrar contenido\";s:32:\"Access the content overview page\";s:44:\"Acceder a la página de resumen de contenido\";s:50:\"Get an overview of <a href=\"@url\">all content</a>.\";s:68:\"Obtener una visión general de <a href=\"@url\">todo el contenido</a>.\";s:22:\"View published content\";s:23:\"Ver contenido publicado\";s:28:\"View own unpublished content\";s:36:\"Ver el contenido propio sin publicar\";s:22:\"View content revisions\";s:28:\"Ver revisiones del contenido\";s:24:\"Revert content revisions\";s:36:\"Restablecer revisiones del contenido\";s:24:\"Delete content revisions\";s:33:\"Eliminar revisiones del contenido\";s:30:\"%type_name: Create new content\";s:33:\"%type_name: Crear contenido nuevo\";s:28:\"%type_name: Edit own content\";s:35:\"%type_name: Editar contenido propio\";s:28:\"%type_name: Edit any content\";s:38:\"%type_name: Editar cualquier contenido\";s:30:\"%type_name: Delete own content\";s:35:\"%type_name: Borrar contenido propio\";s:30:\"%type_name: Delete any content\";s:38:\"%type_name: Borrar cualquier contenido\";s:22:\"Administer URL aliases\";s:24:\"Administrar alias de URL\";s:27:\"Create and edit URL aliases\";s:27:\"Crear y editar alias de URL\";s:17:\"Administer search\";s:21:\"Administrar búsqueda\";s:10:\"Use search\";s:14:\"Usar búsqueda\";s:19:\"Use advanced search\";s:23:\"Usar búsqueda avanzada\";s:20:\"Administer shortcuts\";s:18:\"Administrar atajos\";s:25:\"Edit current shortcut set\";s:35:\"Editar el actual conjunto de atajos\";s:23:\"Select any shortcut set\";s:40:\"Seleccionar cualquier conjunto de atajos\";s:18:\"Administer modules\";s:20:\"Administrar módulos\";s:29:\"Administer site configuration\";s:36:\"Administrar configuración del sitio\";s:17:\"Administer themes\";s:17:\"Administrar temas\";s:27:\"Administer software updates\";s:39:\"Administrar actualizaciones de software\";s:18:\"Administer actions\";s:20:\"Administrar acciones\";s:37:\"Use the administration pages and help\";s:44:\"Usar las páginas y ayuda de administración\";s:32:\"Use the site in maintenance mode\";s:38:\"Usar el sitio en modo de mantenimiento\";s:29:\"View the administration theme\";s:30:\"Ver el tema de administración\";s:17:\"View site reports\";s:22:\"Ver informes del sitio\";s:18:\"Block IP addresses\";s:23:\"Bloquear direcciones IP\";s:33:\"Administer vocabularies and terms\";s:36:\"Administrar vocabularios y términos\";s:25:\"Edit terms in %vocabulary\";s:31:\"Editar términos en %vocabulary\";s:29:\"Delete terms from %vocabulary\";s:33:\"Eliminar términos de %vocabulary\";s:28:\"administer theme assignments\";s:36:\"administrar las asignaciones de tema\";s:57:\"TODO Add a description for \'administer theme assignments\'\";s:83:\"POR HACER Agregar una descripción de las \'asignaciones de tema de administración\'\";s:28:\"administer themekey settings\";s:36:\"administrar las opciones de ThemeKey\";s:57:\"TODO Add a description for \'administer themekey settings\'\";b:1;s:30:\"Use the administration toolbar\";s:48:\"Usar la barra de herramientas de administración\";s:22:\"Administer permissions\";s:20:\"Administrar permisos\";s:16:\"Administer users\";s:20:\"Administrar usuarios\";s:18:\"View user profiles\";s:23:\"Ver perfiles de usuario\";s:19:\"Change own username\";s:32:\"Cambiar nombre de usuario propio\";s:23:\"Cancel own user account\";s:22:\"Cancelar cuenta propia\";s:9:\"Anonymous\";s:8:\"Anónimo\";s:40:\"Select method for cancelling own account\";s:58:\"Seleccionar el método de cancelación de la propia cuenta\";s:19:\"Administer pathauto\";s:37:\"Administrar alias de URL automáticos\";s:22:\"Notify of Path Changes\";s:26:\"Avisar de cambios de rutas\";s:45:\"Determines whether or not users are notified.\";s:42:\"Determina si los usuarios son notificados.\";s:16:\"Administer views\";b:1;s:38:\"Access the views administration pages.\";s:56:\"Acceso a las páginas de  administración de las vistas.\";s:27:\"Bypass views access control\";s:41:\"Saltar el control de acceso de las vistas\";s:43:\"Bypass access control when accessing views.\";s:50:\"Saltar el control de acceso al accesar las vistas.\";s:19:\"Default SQL storage\";s:33:\"Almacenamiento SQL predeterminado\";s:64:\"Stores fields in the local SQL database, using per-field tables.\";s:63:\"Almacena campos en la base SQL local, usando tablas por campos.\";s:55:\"This field stores the ID of a file as an integer value.\";s:73:\"Este campo alamacena la ID de un archivo como un valor de número entero.\";s:5:\"Image\";s:6:\"Imagen\";s:62:\"This field stores the ID of an image file as an integer value.\";s:82:\"Este campo almacena el ID de un archivo de imagen como un valor de número entero.\";s:4:\"Link\";s:6:\"Enlace\";s:71:\"Store a title, href, and attributes in the database to assemble a link.\";s:79:\"Almacena título, href y atributos en la base de datos para componer un enlace.\";s:14:\"List (integer)\";s:24:\"Lista (números enteros)\";s:12:\"List (float)\";s:26:\"Lista (números decimales)\";s:11:\"List (text)\";s:16:\"Lista (de texto)\";s:7:\"Boolean\";s:8:\"Booleano\";s:50:\"This field stores simple on/off or yes/no options.\";s:71:\"Este campo guarda valores sencillos como activado/desactivado o sí/no.\";s:7:\"Integer\";s:6:\"Entero\";s:57:\"This field stores a number in the database as an integer.\";s:74:\"Este campo almacena un número en la base de datos como un número entero.\";s:7:\"Decimal\";s:7:\"Decimal\";s:69:\"This field stores a number in the database in a fixed decimal format.\";s:78:\"Este campo almacena un número en la base de datos en un formato decimal fijo.\";s:5:\"Float\";s:5:\"Float\";s:70:\"This field stores a number in the database in a floating point format.\";s:79:\"Este campo almacena en la base de datos un número en formato de coma flotante.\";s:14:\"Term reference\";s:21:\"Referencia a término\";s:49:\"This field stores a reference to a taxonomy term.\";s:63:\"Este campo almacena una referencia a un término de taxonomía.\";s:4:\"Text\";s:5:\"Texto\";s:47:\"This field stores varchar text in the database.\";s:54:\"Este campo almacena texto varchar en la base de datos.\";s:9:\"Long text\";s:11:\"Texto largo\";s:44:\"This field stores long text in the database.\";s:52:\"Este campo almacena texto largo en la base de datos.\";s:21:\"Long text and summary\";s:21:\"Texto largo y resumen\";s:8:\"Galician\";s:7:\"Gallego\";s:7:\"Spanish\";s:8:\"Español\";s:7:\"English\";s:7:\"Inglés\";s:21:\"Updating translations\";s:25:\"Actualizando traducciones\";s:33:\"Error importing translation files\";s:40:\"Error importando archivos de traducción\";s:10:\"Processing\";s:10:\"Procesando\";s:13:\"Initializing.\";s:14:\"Inicializando.\";s:29:\"Completed @current of @total.\";s:34:\"Se completaron @current de @total.\";s:22:\"An error has occurred.\";s:21:\"Ha ocurrido un error.\";s:36:\"Node: Title - The title of the node.\";s:36:\"Nodo: Título - El título del nodo.\";s:10:\"Text field\";s:14:\"Campo de texto\";s:11:\"Select list\";s:19:\"Lista de selección\";s:25:\"Check boxes/radio buttons\";s:44:\"Casillas de selección / botones de opciones\";s:22:\"Single on/off checkbox\";s:35:\"Casilla de selección única on/off\";s:34:\"Autocomplete term widget (tagging)\";s:46:\"Control de autocompletar término (etiquetado)\";s:25:\"Text area (multiple rows)\";s:29:\"Área de texto (varias filas)\";s:24:\"Text area with a summary\";s:29:\"Área de texto con un resumen\";s:12:\"Generic file\";s:17:\"Archivo genérico\";s:14:\"Table of files\";s:17:\"Tabla de archivos\";s:11:\"URL to file\";s:15:\"URL del archivo\";s:24:\"Title, as link (default)\";s:34:\"Título, como enlace (por defecto)\";s:20:\"Title, as plain text\";s:31:\"Título, como texto sin formato\";s:19:\"Host, as plain text\";b:1;s:12:\"URL, as link\";s:16:\"URL, como enlace\";s:18:\"URL, as plain text\";b:1;s:13:\"URL, absolute\";s:12:\"URL absoluta\";s:15:\"Domain, as link\";s:20:\"Dominio, como enlace\";s:32:\"Short, as link with title \"Link\"\";s:40:\"Corto, como enlace con el título \"Link\"\";s:34:\"Label, as link with label as title\";s:47:\"Etiqueta, como enlace con etiqueta como título\";s:22:\"Separate title and URL\";s:22:\"Título separado y URL\";s:3:\"Key\";s:5:\"Clave\";s:10:\"Plain text\";s:17:\"Texto sin formato\";s:12:\"RSS category\";s:14:\"Categoría RSS\";s:7:\"Trimmed\";s:9:\"Recortado\";s:18:\"Summary or trimmed\";s:19:\"Resumen o recortado\";s:53:\"Path: Node alias - The path alias assigned to a node.\";b:1;s:8:\"Browscap\";b:1;s:17:\"Mobile Detect API\";b:1;s:13:\"Mobile Detect\";b:1;s:68:\"System: Date - Current time formatted as Y-m-d (example: 2009-12-24)\";b:1;s:62:\"System: Month - Current month formatted as \'Jan\' through \'Dec\'\";b:1;s:66:\"System: Time - Current time formatted as H:i:s (example: 18:30:10)\";b:1;s:67:\"System: Day of Month - Current day of the month formatted as 1 - 31\";b:1;s:55:\"System: Dummy - Dummy property. Value is always \'dummy\'\";b:1;s:56:\"System: Random - A random value that could be \'0\' or 1\'.\";s:64:\"Sistema: Aleatorio - Un valor aleatorio que puede ser \'0\' o \'1\'.\";s:72:\"Wildcard of \"drupal:path\". See explanation of \"drupal:path\" for details.\";b:1;s:66:\"Drupal: $_GET[\'q\'] - Current value of Drupal\'s query parameter \"q\"\";b:1;s:54:\"Taxonomy: Term - The term id (tid) of a taxonomy term.\";b:1;s:64:\"User: Name - The username of the user. See !link for your users.\";b:1;s:36:\"Views: VID - The vid of a view (vid)\";b:1;s:48:\"Views: Machine Name - The machine name of a view\";b:1;s:55:\"Views: Human Name - The (human readable) name of a view\";b:1;s:21:\"Site default language\";s:31:\"Idioma predeterminado del sitio\";s:8:\"Language\";s:6:\"Idioma\";s:9:\"Node type\";s:12:\"Tipo de nodo\";s:11:\"Text length\";s:18:\"Longitud del texto\";s:11:\"Drupal path\";s:14:\"Ruta en Drupal\";s:9:\"File path\";s:16:\"Ruta de archivos\";s:11:\"Day of week\";s:17:\"Día de la semana\";s:5:\"Theme\";s:4:\"Tema\";s:7:\"Country\";s:5:\"País\";s:9:\"Time zone\";s:12:\"Zona horaria\";s:9:\"Date type\";s:13:\"Tipo de fecha\";s:11:\"Date format\";s:16:\"Formato de fecha\";s:13:\"Time interval\";s:19:\"Intervalo de tiempo\";s:14:\"User mail text\";s:27:\"Texto del correo de usuario\";s:5:\"Array\";s:5:\"Array\";s:10:\"Properties\";s:11:\"Propiedades\";s:8:\"Multiple\";s:9:\"Múltiple\";s:14:\"E-mail address\";s:33:\"Dirección de correo electrónico\";s:9:\"Mail text\";s:16:\"Texto del correo\";s:7:\"Subject\";s:6:\"Asunto\";s:4:\"Body\";s:6:\"Cuerpo\";s:6:\"Number\";s:7:\"Número\";s:7:\"Options\";s:8:\"Opciones\";s:6:\"Select\";s:11:\"Seleccionar\";s:6:\"String\";s:5:\"Texto\";s:7:\"Unknown\";s:11:\"Desconocido\";s:10:\"Mail parts\";s:17:\"Partes del correo\";s:14:\"Formatted text\";s:16:\"Texto formateado\";s:17:\"Multiple language\";s:18:\"Múltiple lenguaje\";s:25:\"Source for the Main links\";s:33:\"Fuente de los enlaces principales\";s:13:\"No Main links\";s:23:\"Sin enlaces principales\";s:30:\"Source for the Secondary links\";s:33:\"Fuente de los enlaces secundarios\";s:18:\"No Secondary links\";s:23:\"Sin enlaces secundarios\";s:42:\"Select the source for the Secondary links.\";b:1;s:11:\"Menu parent\";s:11:\"Menú padre\";s:22:\"Select the menu parent\";b:1;s:12:\"Menu options\";s:17:\"Opciones de menú\";s:26:\"Select the available menus\";b:1;s:23:\"Length of trimmed posts\";s:34:\"Longitud de los envíos recortados\";s:43:\"Must users preview posts before submitting?\";s:51:\"¿Deben los usuarios previsualizar antes de enviar?\";s:25:\"The name of this website.\";s:28:\"El nombre de este sitio web.\";s:18:\"Site email address\";s:43:\"Dirección de correo electrónico del sitio\";s:14:\"Anonymous user\";s:16:\"Usuario anónimo\";s:42:\"The name used to indicate anonymous users.\";s:48:\"El nombre usado para indicar usuarios anónimos.\";s:18:\"Default front page\";s:30:\"Página inicial predeterminada\";s:28:\"Number of posts on main page\";s:42:\"Número de envíos en la página principal\";s:32:\"Default 403 (access denied) page\";s:41:\"Página 403 predefinida (acceso denegado)\";s:28:\"Default 404 (not found) page\";s:39:\"Página 404 predefinida (no encontrada)\";s:16:\"Feed description\";s:33:\"Descripción de canal de noticias\";s:48:\"Description of your site, included in each feed.\";s:61:\"Descripción de su sitio, incluido en cada canal de noticias.\";s:28:\"Number of items in each feed\";s:46:\"Número de elementos de cada canal de noticias\";s:48:\"Default number of items to include in each feed.\";s:63:\"Número predeterminado de elementos para incluir en cada canal.\";s:12:\"Feed content\";s:19:\"Contenido sindicado\";s:11:\"Titles only\";s:14:\"Sólo títulos\";s:18:\"Titles plus teaser\";s:21:\"Títulos y resúmenes\";s:9:\"Full text\";s:14:\"Texto completo\";s:69:\"Global setting for the default display of content items in each feed.\";s:105:\"Opción global para la presentación predefinida de los elementos de contenido en cada canal de noticias.\";s:15:\"Default country\";s:17:\"País predefinido\";s:17:\"First day of week\";s:24:\"Primer día de la semana\";s:17:\"Default time zone\";s:24:\"Zona horaria predefinida\";s:34:\"Users may set their own time zone.\";s:47:\"Los usuarios pueden establecer su zona horaria.\";s:52:\"Remind users at login if their time zone is not set.\";s:89:\"Recordar a los usuarios cuando se identifiquen si su zona horaria no se ha especificado .\";s:50:\"Only applied if users may set their own time zone.\";s:75:\"Solo aplicado si los usuarios pueden establecer sus propias zonas horarias.\";s:23:\"Time zone for new users\";s:34:\"Zona horaria para usuarios nuevos.\";s:18:\"Default time zone.\";s:28:\"Zona horaria predeterminada.\";s:16:\"Empty time zone.\";s:20:\"Zona horaria vacía.\";s:50:\"Users may set their own time zone at registration.\";s:69:\"Los usuarios pueden establecer su propia zona horaria al registrarse.\";s:30:\"Put site into maintenance mode\";s:38:\"Pasar el sitio a modo de mantenimiento\";s:24:\"Maintenance mode message\";s:33:\"Mensaje del modo de mantenimiento\";s:62:\"Message to show visitors when the site is in maintenance mode.\";s:101:\"Mensaje que se presenta a los visitantes cuando el sitio está desconectado en modo de mantenimiento.\";s:22:\"Global theme settings.\";b:1;s:14:\"Theme settings\";s:23:\"Opciones de tema visual\";s:46:\"Logo, icons and other specific theme settings.\";b:1;s:31:\"Cache pages for anonymous users\";s:42:\"Caché de páginas para usuarios anónimos\";s:12:\"Cache blocks\";s:17:\"Caché de bloques\";s:22:\"Minimum cache lifetime\";s:39:\"Tiempo mínimo de permanencia en caché\";s:26:\"Expiration of cached pages\";s:35:\"Caducidad de las páginas en caché\";s:68:\"The maximum time an external cache can use an old version of a page.\";s:92:\"El tiempo máximo que una caché externa puede utilizar una versión antigua de una página.\";s:22:\"Compress cached pages.\";s:29:\"Comprimir páginas en caché.\";s:33:\"Aggregate and compress CSS files.\";s:30:\"Unir y comprimir archivos CSS.\";s:27:\"Aggregate JavaScript files.\";s:25:\"Unir archivos JavaScript.\";s:20:\"Public registrations\";s:19:\"Registros públicos\";s:61:\"Require e-mail verification when a visitor creates an account\";s:76:\"Es necesaria la verificación por correo cuando un visitante crea una cuenta\";s:28:\"User registration guidelines\";s:37:\"Directrices para registro de usuarios\";s:42:\"Welcome, new user created by administrator\";s:53:\"Bienvenido, nuevo usuario creado por el administrador\";s:29:\"Welcome, no approval required\";s:38:\"Bienvenido, no se requiere aprobación\";s:40:\"Welcome, awaiting administrator approval\";s:59:\"Bienvenido, a la espera de la aprobación del administrador\";s:23:\"Password recovery email\";s:38:\"Correo de recuperación de contraseña\";s:67:\"Customize e-mail messages sent to users who request a new password.\";s:94:\"Personalice mensajes de correo enviados a los usuarios cuando solicitan una nueva contraseña.\";s:24:\"Account activation email\";s:47:\"Correo electrónico de activación de la cuenta\";s:38:\"Notify user when account is activated.\";s:50:\"Notificar al usuario cuando su cuenta es activada.\";s:21:\"Account blocked email\";s:29:\"Correo de la cuenta bloqueado\";s:36:\"Notify user when account is blocked.\";s:51:\"Notificar al usuario cuando su cuenta es bloqueada.\";s:33:\"Account cancellation confirmation\";s:39:\"Confirmación de cancelación de cuenta\";s:21:\"Account deleted email\";s:46:\"Correo electrónico cuando se borra una cuenta\";s:36:\"Notify user when account is deleted.\";s:51:\"Notificar al usuario cuando su cuenta es eliminada.\";s:17:\"Signature support\";s:15:\"Permitir firmas\";s:15:\"Picture support\";s:22:\"Soporte para imágenes\";s:17:\"Picture directory\";s:23:\"Directorio de imágenes\";s:72:\"Subdirectory in the file upload directory where pictures will be stored.\";s:87:\"Subdirectorio de la carpetas de archivos subidos en el que se guardarán las imágenes.\";s:15:\"Default picture\";s:21:\"Imagen predeterminada\";s:26:\"Picture maximum dimensions\";s:33:\"Dimensiones máximas de la imagen\";s:43:\"Maximum dimensions for pictures, in pixels.\";s:57:\"Las dimensiones máximas para las imágenes, en píxeles.\";s:25:\"Picture maximum file size\";s:37:\"Tamaño máximo del archivo de imagen\";s:38:\"Maximum file size for pictures, in kB.\";s:57:\"El tamaño máximo del archivo para las imágenes, en kB.\";s:18:\"Picture guidelines\";s:38:\"Directrices para imágenes de usuarios\";s:21:\"Languages for content\";s:25:\"Idiomas para el contenido\";s:64:\"Determines which languages will be allowed for content creation.\";s:66:\"Determina que idiomas se permitirán en la creación de contenido.\";s:31:\"Enable translation for language\";s:33:\"Habilitar traducción para idioma\";s:25:\"Translatable text formats\";s:29:\"Formatos de texto traducibles\";s:15:\"Source language\";s:16:\"Idioma de origen\";s:24:\"Debug string translation\";s:30:\"Depurar traducción de cadenas\";s:39:\"Configurable blocks titles and content.\";s:46:\"Títulos y contenido de bloques configurables.\";s:4:\"more\";s:4:\"más\";s:8:\"Defaults\";s:12:\"Predefinidos\";s:13:\"Image gallery\";s:21:\"Galería de imágenes\";s:5:\"Apply\";s:7:\"Aplicar\";s:5:\"Reset\";s:9:\"Reiniciar\";s:7:\"Sort by\";s:11:\"Ordenar por\";s:3:\"Asc\";s:3:\"Asc\";s:4:\"Desc\";s:4:\"Desc\";s:14:\"Items per page\";s:21:\"Elementos por página\";s:7:\"- All -\";s:8:\"- Todo -\";s:6:\"Offset\";s:14:\"Desplazamiento\";s:12:\"Gallery page\";s:19:\"Página de galería\";s:15:\"Recent comments\";s:21:\"Comentarios recientes\";s:8:\"Reply to\";s:11:\"Responder a\";s:12:\"Recent posts\";s:17:\"Envíos recientes\";s:4:\"Type\";s:4:\"Tipo\";s:7:\"Replies\";s:10:\"Respuestas\";s:1:\".\";s:1:\".\";s:1:\",\";s:1:\",\";s:9:\"Last Post\";s:14:\"Último envío\";s:4:\" new\";s:6:\" nuevo\";s:19:\"Recent posts for %1\";s:25:\"Envíos recientes para %1\";s:15:\"Monthly archive\";s:15:\"Archivo mensual\";s:2:\"%1\";s:2:\"%1\";s:15:\"Front page feed\";s:41:\"Canal de noticias de la página principal\";s:11:\"Last update\";s:22:\"Última actualización\";s:19:\"No backlinks found.\";s:27:\"No se encontraron backlinks\";s:21:\"Pages that link to %1\";s:27:\"Páginas que enlazan con %1\";s:15:\"What links here\";s:19:\"Lo que enlaza aquí\";s:15:\"Publish comment\";s:19:\"Publicar comentario\";s:17:\"Unpublish comment\";s:37:\"Rerirar comentario de la publicación\";s:39:\"Unpublish comment containing keyword(s)\";s:71:\"Retirar de la publicación comentarios que contengan las palabras clave\";s:12:\"Save comment\";s:18:\"Guardar comentario\";s:15:\"Publish content\";s:18:\"Publicar contenido\";s:17:\"Unpublish content\";s:36:\"Retirar contenido de la publicación\";s:19:\"Make content sticky\";s:57:\"Hacer que el contenido quede fijo en cabeza de las listas\";s:21:\"Make content unsticky\";s:58:\"Hacer que el contenido no sea fijo en cabeza de las listas\";s:29:\"Promote content to front page\";s:39:\"Llevar contenido a la página principal\";s:30:\"Remove content from front page\";s:40:\"Quitar contenido de la página principal\";s:28:\"Change the author of content\";s:30:\"Cambiar autoría del contenido\";s:12:\"Save content\";s:17:\"Guardar contenido\";s:39:\"Unpublish content containing keyword(s)\";s:71:\"Retirar de la publicación el contenido que contenga las palabras clave\";s:29:\"Display a message to the user\";s:29:\"Mostrar un mensaje al usuario\";s:11:\"Send e-mail\";s:26:\"Enviar correo electrónico\";s:30:\"Ban IP address of current user\";s:44:\"Bloquear la dirección IP del usuario actual\";s:15:\"Redirect to URL\";s:18:\"Redirigir a la URL\";s:18:\"Block current user\";s:23:\"Bloquear usuario actual\";s:17:\"Update node alias\";s:24:\"Actualizar alias de nodo\";s:26:\"Update taxonomy term alias\";s:28:\"Actualizar alias de término\";s:17:\"Update user alias\";s:27:\"Actualizar alias de usuario\";s:6:\"Header\";s:10:\"Encabezado\";s:11:\"Highlighted\";s:9:\"Destacado\";s:8:\"Featured\";s:9:\"Destacado\";s:13:\"Sidebar first\";s:21:\"Primera barra lateral\";s:14:\"Sidebar second\";s:21:\"Segunda barra lateral\";s:14:\"Triptych first\";s:16:\"Primer tríptico\";s:15:\"Triptych middle\";s:17:\"Tríptico central\";s:13:\"Triptych last\";s:15:\"Tríptico final\";s:19:\"Footer first column\";s:34:\"Primera columna del pie de página\";s:20:\"Footer second column\";s:34:\"Segunda columna del pie de página\";s:19:\"Footer third column\";s:34:\"Tercera columna del pie de página\";s:20:\"Footer fourth column\";s:33:\"Cuarta columna del pie de página\";s:6:\"Footer\";s:14:\"Pie de página\";s:25:\"Language switcher (@type)\";s:28:\"Alternador de idioma (@type)\";s:9:\"Syndicate\";s:8:\"Sindicar\";s:14:\"Recent content\";s:18:\"Contenido reciente\";s:11:\"Search form\";s:23:\"Formulario de búsqueda\";s:17:\"Main page content\";s:33:\"Contenido principal de la página\";s:17:\"Powered by Drupal\";s:26:\"Sitio elaborado con Drupal\";s:11:\"System help\";s:17:\"Ayuda del sistema\";s:10:\"User login\";s:17:\"Inicio de sesión\";s:9:\"Who\'s new\";s:15:\"Usuarios nuevos\";s:12:\"Who\'s online\";s:22:\"Quién está conectado\";s:6:\"fields\";s:6:\"campos\";s:5:\"Field\";s:5:\"Campo\";s:18:\"Contextual filters\";s:20:\"Filtros contextuales\";s:18:\"contextual filters\";s:20:\"filtros contextuales\";s:17:\"Contextual filter\";s:17:\"Filtro contextual\";s:17:\"contextual filter\";s:17:\"filtro contextual\";s:13:\"Sort criteria\";s:27:\"Criterios de clasificación\";s:13:\"sort criteria\";s:24:\"criterios de ordenación\";s:14:\"Sort criterion\";s:23:\"Criterio de ordenación\";s:14:\"sort criterion\";s:23:\"criterio de ordenación\";s:15:\"Filter criteria\";s:21:\"Criterios de filtrado\";s:15:\"filter criteria\";s:20:\"criterio de filtrado\";s:16:\"Filter criterion\";s:20:\"Criterio de filtrado\";s:16:\"filter criterion\";s:21:\"criterios de filtrado\";s:13:\"Relationships\";s:10:\"Relaciones\";s:13:\"relationships\";s:10:\"relaciones\";s:12:\"Relationship\";s:9:\"Relación\";s:6:\"header\";s:10:\"encabezado\";s:6:\"footer\";s:14:\"pie de página\";s:19:\"No results behavior\";s:35:\"Comportamiento si no hay resultados\";s:19:\"no results behavior\";s:35:\"comportamiento si no hay resultados\";s:11:\"Page splash\";b:1;s:7:\"Primary\";s:8:\"Primario\";s:9:\"Secondary\";s:10:\"Secundario\";s:11:\"Footer left\";b:1;s:13:\"Footer center\";b:1;s:12:\"Footer right\";b:1;s:7:\"Contact\";s:8:\"Contacto\";s:7:\"Top Bar\";b:1;s:42:\"The configuration options have been saved.\";s:47:\"Se han guardado las opciones de configuración.\";s:58:\"Please continue to <a href=\"@error_url\">the error page</a>\";s:66:\"Por favor, continue a <a href=\"@error_url\">la página de error</a>\";s:17:\"Translation files\";s:23:\"Archivos de traducción\";s:18:\"Translation files.\";b:1;s:0:\"\";b:1;s:33:\"Checked translation for %project.\";s:40:\"Comprobada la traducción para %project.\";s:10:\"@count sec\";b:1;s:5:\"1 min\";b:1;s:36:\"Downloaded translation for %project.\";s:46:\"La traducción para %project se ha descargado.\";s:35:\"Importing translation for %project.\";s:36:\"Importando traducción para %project\";s:17:\"Reset to defaults\";s:35:\"Restablecer valores predeterminados\";s:5:\"Value\";s:5:\"Valor\";s:6:\"Groups\";s:6:\"Grupos\";s:18:\"Node type settings\";s:31:\"Configuración del tipo de nodo\";s:3:\"all\";s:5:\"todos\";s:4:\"none\";s:7:\"ninguno\";s:4:\"True\";s:9:\"Verdadero\";s:6:\"Sunday\";s:7:\"Domingo\";s:6:\"Monday\";s:5:\"Lunes\";s:7:\"Tuesday\";s:6:\"Martes\";s:9:\"Wednesday\";s:10:\"Miércoles\";s:8:\"Thursday\";s:6:\"Jueves\";s:6:\"Friday\";s:7:\"Viernes\";s:8:\"Saturday\";s:7:\"Sábado\";s:13:\"User settings\";s:19:\"Opciones de usuario\";s:9:\"Unlimited\";s:9:\"Ilimitado\";s:9:\"Undefined\";s:11:\"Sin definir\";s:13:\"Feed settings\";s:29:\"Opciones de canal de noticias\";s:5:\"Empty\";s:6:\"Vacío\";s:5:\"Debug\";s:7:\"Depurar\";s:6:\"Global\";s:6:\"Global\";s:25:\"Enabled, with translation\";s:27:\"Habilitado, con traducción\";s:11:\"Text format\";s:16:\"Formato de texto\";s:34:\"Imported translation for %project.\";s:45:\"La traducción para %project se ha importado.\";s:9:\"Variables\";s:9:\"Variables\";s:4:\"Keys\";s:6:\"Claves\";s:21:\"!message (@percent%).\";s:21:\"!message (@percent%).\";s:28:\"Settings for each node type.\";s:32:\"Opciones para cada tipo de nodo.\";s:14:\"Variable realm\";s:22:\"Ámbito de la variable\";s:37:\"Site information and maintenance mode\";s:43:\"Información del sitio y modo mantenimiento\";s:47:\"Variables that don\'t belong to any other group.\";s:49:\"Variables que no pertenecen a ningún otro grupo.\";s:30:\"Debug and development options.\";s:37:\"Opciones de depuración y desarrollo.\";s:13:\"All variables\";s:19:\"Todas las variables\";s:38:\"There are %name variables in this form\";s:42:\"Existen variables %name en este formulario\";s:10:\"Realm list\";s:17:\"Lista de ámbitos\";s:12:\"Realm weight\";s:16:\"Peso del ámbito\";s:5:\"Pages\";s:8:\"Páginas\";s:6:\"Status\";s:6:\"Estado\";s:7:\"content\";s:9:\"contenido\";s:29:\"This action cannot be undone.\";s:34:\"Esta acción no se puede deshacer.\";s:9:\"Help text\";s:14:\"Texto de ayuda\";s:8:\"Category\";s:10:\"Categoría\";s:5:\"Label\";s:8:\"Etiqueta\";s:4:\"Save\";s:7:\"Guardar\";s:4:\"Path\";s:4:\"Ruta\";s:7:\"Updated\";s:11:\"Actualizado\";s:21:\"Submission guidelines\";s:22:\"Directices para enviar\";s:3:\"n/a\";s:3:\"n/d\";s:5:\"Paths\";s:5:\"Rutas\";s:7:\"Created\";s:6:\"Creado\";s:10:\"Node types\";s:13:\"Tipos de nodo\";s:9:\"Menu link\";s:15:\"Enlace de menú\";s:5:\"Items\";s:9:\"Elementos\";s:21:\"Autocomplete taxonomy\";s:27:\"Autocompletar la taxonomía\";s:8:\"Revision\";s:9:\"Revisión\";s:12:\"Translations\";s:12:\"Traducciones\";s:6:\"Sticky\";s:6:\"Sticky\";s:13:\"Default value\";s:20:\"Valor predeterminado\";s:20:\"Multilingual options\";s:21:\"Opciones multi idioma\";s:7:\"Strings\";s:7:\"Cadenas\";s:24:\"Synchronize translations\";s:24:\"Sincronizar traducciones\";s:16:\"Language neutral\";s:22:\"Sin idioma específico\";s:7:\"Context\";s:8:\"Contexto\";s:14:\"Field settings\";s:18:\"Opciones del campo\";s:17:\"Save translations\";s:24:\"Guardar las traducciones\";s:12:\"Create @name\";s:11:\"Crear @name\";s:13:\"Original text\";s:14:\"Texto original\";s:8:\"original\";s:8:\"original\";s:9:\"translate\";s:8:\"traducir\";s:40:\"<strong>@language_name</strong> (source)\";s:40:\"<strong>@language_name</strong> (origen)\";s:15:\"add translation\";s:19:\"agregar traducción\";s:22:\"Translations of %title\";s:22:\"Traducciones de %title\";s:30:\"@type %title has been created.\";s:26:\"@type %title se ha creado.\";s:30:\"@type %title has been updated.\";s:33:\"@type %title ha sido actualizado.\";s:11:\"Edit string\";s:12:\"Editar texto\";s:9:\"Post date\";s:21:\"Fecha de publicación\";s:19:\"Update translations\";s:23:\"Actualizar traducciones\";s:18:\"Content type names\";s:28:\"Nombre de tipos de contenido\";s:23:\"Already added languages\";s:20:\"Idiomas ya añadidos\";s:22:\"Create new translation\";s:23:\"Crear nueva traducción\";s:16:\"Translation mode\";s:19:\"Modo de traducción\";s:23:\"Languages not yet added\";s:25:\"Idiomas no añadidos aún\";s:24:\"Allowed HTML tags: @tags\";s:32:\"Etiquetas HTML permitidas: @tags\";s:30:\"The name of the taxonomy term.\";s:37:\"El nombre del término de taxonomía.\";s:46:\"The optional description of the taxonomy term.\";s:52:\"La descripción opcional del término de taxonomía.\";s:44:\"The vocabulary the taxonomy term belongs to.\";s:58:\"El vocabulario de taxonomía al que pertenece el término.\";s:52:\"The parent term of the taxonomy term, if one exists.\";s:59:\"El término padre del término de taxonomía, si existiera.\";s:36:\"The name of the taxonomy vocabulary.\";s:40:\"El nombre del vocabulario de taxonomía.\";s:52:\"The optional description of the taxonomy vocabulary.\";s:55:\"La descripción opcional del vocabulario de taxonomía.\";s:29:\"All pages except those listed\";s:46:\"Todas las páginas excepto las que se enumeran\";s:21:\"Only the listed pages\";s:29:\"Sólo las páginas enumeradas\";s:26:\"<em>Edit @type</em> @title\";s:28:\"<em>Editar @type</em> @title\";s:14:\"[empty string]\";s:16:\"Formato de texto\";s:11:\"Title label\";s:22:\"Título de la etiqueta\";s:5:\"Terms\";s:9:\"Términos\";s:8:\"Moderate\";s:8:\"Moderado\";s:5:\"terms\";s:9:\"términos\";s:7:\"Promote\";s:11:\"Promocionar\";s:8:\"(source)\";s:8:\"(fuente)\";s:19:\"Multilingual system\";s:20:\"Sistema multilingüe\";s:29:\"Reset language for all terms.\";s:45:\"Restablecer el idioma de todos los términos.\";s:47:\"Normal - All enabled languages will be allowed.\";s:47:\"Normal - Todos los idiomas activos se permiten.\";s:49:\"Extended - All defined languages will be allowed.\";s:51:\"Ampliado - Todos los idiomas definidos se permiten.\";s:21:\"Multilingual settings\";s:27:\"Configuración multilingüe\";s:12:\"Node options\";s:16:\"Opciones de nodo\";s:10:\"vocabulary\";s:11:\"vocabulario\";s:16:\"Save translation\";s:19:\"Guardar traducción\";s:30:\"Hide content translation links\";s:44:\"Esconder enlaces de traducción de contenido\";s:30:\"Select translations for %title\";s:36:\"Seleccionar traducciones para %title\";s:70:\"This module improves support for multilingual content in Drupal sites:\";s:78:\"Este módulo mejora el soporte de contenido multi idioma en los sitios Drupal:\";s:41:\"Shows content depending on page language.\";s:58:\"Muestra el contenido dependiendo del idioma de la página.\";s:31:\"Handles multilingual variables.\";s:36:\"Gestiona las variables multi idioma.\";s:69:\"This is the base module for several others adding different features:\";s:82:\"Este es el módulo básico para otros más que añaden distintas características:\";s:24:\"Multilingual menu items.\";s:32:\"Elementos de menú multi idioma.\";s:25:\"Extended language support\";s:26:\"Soporte ampliado de idioma\";s:69:\"Configure extended options for multilingual content and translations.\";s:74:\"Configurar opciones extendidas para contenido multilingüe y traducciones.\";s:53:\"This module provides support for multilingual blocks.\";s:59:\"Este módulo proporciona soporte para bloques multi idioma.\";s:67:\"You can set up a language for a block or define it as translatable:\";s:70:\"Puede establecer un idioma para un bloque o definirlo como traducible:\";s:74:\"Blocks with a language will be displayed only in pages with that language.\";s:76:\"Los bloques con un idioma se mostrarán sólo en las páginas de ese idioma.\";s:71:\"Translatable blocks can be translated using the localization interface.\";s:82:\"Los bloques traducibles se pueden traducir usando la interfaz de regionalización.\";s:18:\"Select text groups\";s:27:\"Seleccionar grupos de texto\";s:15:\"Refresh strings\";s:17:\"Actualizar textos\";s:70:\"This will create all the missing strings for the selected text groups.\";s:79:\"Esto creará todos los textos faltantes para los grupos de texto seleccionados.\";s:72:\"On this page you can refresh and update values for user defined strings.\";s:96:\"En esta página puede renovar y actualizar los valores de los textos definidos por los usuarios.\";s:58:\"Updated string %location for textgroup %textgroup: %string\";s:79:\"Se ha actualizado el texto %location para el grupo de texto %textgroup: %string\";s:59:\"Created string %location for text group %textgroup: %string\";s:74:\"Se ha creado el texto %location para el grupo de texto %textgroup: %string\";s:74:\"This module synchronizes content taxonomy and fields accross translations:\";s:84:\"Este módulo sincroniza la taxonomía y los campos del contenido entre traducciones.\";s:52:\"A language can be assigned globaly for a vocabulary.\";s:60:\"Se puede asignar un idioma a un vocabulario de forma global.\";s:65:\"Different terms for each language with translation relationships.\";s:67:\"Términos distintos para cada idioma con relaciones de traducción.\";s:59:\"Terms can be common to all languages, but may be localized.\";s:83:\"Los términos pueden ser comúnes a todos los idiomas, pero se pueden regionalizar.\";s:15:\"Add translation\";s:19:\"Añadir traducción\";s:70:\"Extended multilingual options provided by Internationalization module.\";s:81:\"Opciones multi idioma extendidas proveídas por el módulo Internacionalización.\";s:48:\"Set current language as default for new content.\";s:59:\"Hacer predeterminado el idioma actual para nuevo contenido.\";s:49:\"Require language (Do not allow Language Neutral).\";s:45:\"Idioma requerido (No permitir Idioma Neutral)\";s:34:\"Lock language (Cannot be changed).\";s:40:\"Bloquear idioma (No puede ser cambiado).\";s:34:\"Cannot refresh strings for %group.\";s:46:\"No se pueden refrescar las cadenas para %group\";s:47:\"Translatable menu items: title and description.\";s:56:\"Elementos del menú traducibles: título y descripción.\";s:54:\"Provides some extended multilingual options for nodes.\";s:65:\"Proporciona algunas opciones plurilingües extendidas para nodos.\";s:45:\"Content type names, descriptions, help texts.\";s:62:\"Nombres, descripciones, textos de ayuda de tipos de contenido.\";s:11:\"i18n_string\";s:11:\"i18n_string\";s:29:\"Refresh user defined strings.\";s:44:\"Actualizar cadenas definidas por el usuario.\";s:62:\"Vocabulary titles and term names for localizable vocabularies.\";s:78:\"Títulos de vocabularios y nombres de términos para vocabularios traducibles.\";s:29:\"The name of the content type.\";s:32:\"El nombre del tipo de contenido.\";s:45:\"The optional description of the content type.\";s:47:\"La descripción opcional del tipo de contenido.\";s:23:\"Enabled languages only.\";s:24:\"Sólo idiomas activados.\";s:38:\"All defined languages will be allowed.\";s:43:\"Se permitirán todos los idiomas definidos.\";s:37:\"Mixed options for multilingual sites.\";s:44:\"Opciones diversas para sitios multilingües.\";s:67:\"If no language is selected, block will show regardless of language.\";s:79:\"Si no se selecciona ningún idioma, el bloque se mostrará en cualquier idioma.\";s:31:\"Administer content translations\";s:37:\"Administrar traducciones de contenido\";s:51:\"Add or remove existing content to translation sets.\";s:73:\"Añadir o eliminar contenido existente a/de los conjuntos de traducción.\";s:18:\"Text format: @name\";s:23:\"Formato de texto: @name\";s:33:\"Options for user defined strings.\";s:47:\"Opciones para cadenas definidas por el usuario.\";s:41:\"Create also new revision for translations\";s:52:\"Crear también nueva revisión para las traducciones\";s:20:\"Standard node fields\";s:24:\"Campos de nodo estándar\";s:19:\"Configurable fields\";s:20:\"Campos configurables\";s:44:\"Multilingual variables, main variable names.\";s:57:\"Variables plurilingües, nombres principales de variable.\";s:44:\"Multilingual variables, real variable names.\";s:52:\"Variables plurilingües, nombres reales de variable.\";s:33:\"Configure multilingual variables.\";s:35:\"Configurar variables plurilingües.\";s:18:\"Language selection\";s:20:\"Selección de idioma\";s:54:\"Updated @count string names from %oldname to %newname.\";s:61:\"@count nombres de cadena actualizados de %oldname a %newname.\";s:33:\"Synchronize fields for node type.\";s:37:\"Sincronizar campos para tipo de nodo.\";s:16:\"Name (localized)\";s:18:\"Nombre (traducido)\";s:23:\"Description (localized)\";s:24:\"Descripción (traducida)\";s:22:\"Vocabulary (localized)\";s:23:\"Vocabulario (traducido)\";s:23:\"Parent term (localized)\";s:26:\"Término padre (traducido)\";s:16:\"Link (localized)\";s:18:\"Enlace (traducido)\";s:22:\"Plain text (localized)\";s:23:\"Texto plano (traducido)\";s:15:\"Translation set\";s:23:\"Conjunto de traducción\";s:16:\"Translation sets\";s:25:\"Conjuntos de traducciones\";s:26:\"Translation sets overview.\";s:36:\"Resumen de conjuntos de traducción.\";s:38:\"Overview of existing translation sets.\";s:51:\"Resumen de los conjuntos de traducción existentes.\";s:66:\"Enter items that will be considered as translations of each other.\";s:73:\"Escriba elementos que se considerarán como traducciones el uno del otro.\";s:72:\"This item belongs to a multilingual menu. You can set a language for it.\";s:96:\"Este elemento pertenece a un menú multilingüe. Puede establecer un idioma para dicho elemento.\";s:30:\"No translation sets available.\";s:41:\"Conjuntos de traducciones no disponibles.\";s:25:\"Extended language options\";s:29:\"Opciones de idioma extendidas\";s:19:\"Select translations\";s:24:\"Seleccionar traducciones\";s:56:\"Predefined language. If set, it will apply to all items.\";s:72:\"Idioma predefinido. Si se establece, se aplicará a todos los elementos.\";s:27:\"Clean up left over strings.\";s:26:\"Limpiar cadenas sobrantes.\";s:31:\"Refreshing user defined strings\";s:44:\"Refrescando cadenas definidas por el usuario\";s:23:\"Starting string refresh\";s:30:\"Comenzando refresco de cadenas\";s:37:\"Error refreshing user defined strings\";s:50:\"Error refrescando cadenas definidas por el usuario\";s:48:\"Successfully refreshed @count strings for %group\";s:55:\"Se han refrescado @count cadenas para %group con éxito\";s:33:\"Deleted @count left over strings.\";s:36:\"@count cadenas sobrantes eliminadas.\";s:72:\"This block has generated content, only the title can be translated here.\";s:76:\"Este bloque ha generado contenido, sólo se puede traducir el título aquí.\";s:28:\"Make this block translatable\";s:28:\"Hacer traducible este bloque\";s:35:\"Show this block for these languages\";s:38:\"Mostrar este bloque para estos idiomas\";s:18:\"Save and translate\";s:18:\"Guardar y traducir\";s:10:\"menu items\";s:19:\"elementos del menú\";s:53:\"Menus can also be configured to have no translations.\";s:67:\"Los menús también se pueden configurar para no tener traducción.\";s:10:\"translated\";s:9:\"traducido\";s:14:\"not translated\";s:12:\"sin traducir\";s:27:\"Translations of term %title\";s:32:\"Traducciones del término %title\";s:36:\"%language translation of term %title\";s:44:\"Traducción al %language del término %title\";s:21:\"- Select a language -\";s:24:\"- Seleccione un idioma -\";s:59:\"Updated string %location for text group %textgroup: %string\";s:71:\"Cadena %location actualizada para el grupo de texto %textgroup: %string\";s:25:\"Multilingual node options\";s:29:\"Opciones de nodo multilingüe\";s:45:\"Extended node options for multilingual sites.\";s:54:\"Opciones de nodo extendidas para sitios multilingües.\";s:70:\"Default language for content types with Multilingual support disabled.\";s:83:\"Idioma por defecto para tipos de contenido con el soporte multilingüe desactivado.\";s:48:\"The site\'s default language (Default behaviour).\";s:58:\"Idioma por defecto del sitio (Funcionamiento por defecto).\";s:31:\"Language neutral (Recommended).\";s:31:\"Lenguaje neutral (Recomendado).\";s:22:\"Translate to !language\";s:20:\"Traducir a !language\";s:15:\"Translate !name\";s:14:\"Traducir !name\";s:12:\"multilingual\";s:12:\"multilingüe\";s:6:\"Weekly\";s:12:\"Semanalmente\";s:14:\"Check manually\";s:21:\"Comprobar manualmente\";s:10:\"Up to date\";s:11:\"Actualizado\";s:17:\"Check for updates\";s:32:\"Comprobar si hay actualizaciones\";s:11:\"Drupal core\";s:17:\"Núcleo de Drupal\";s:19:\"Translation updates\";s:31:\"Actualizaciones de traducciones\";s:48:\"Check for updates of disabled modules and themes\";s:58:\"Comprobar actualizaciones de módulos y temas no activados\";s:21:\"No strings available.\";s:26:\"No hay textos disponibles.\";s:11:\"l10n_update\";s:11:\"l10n_update\";s:30:\"Automatic update configuration\";s:44:\"Configuración de actualización automática\";s:50:\"@count disallowed HTML string(s) in files: @files.\";s:55:\"@count cadenas HTML prohibidas en los archivos: @files.\";s:21:\"File not found: @uri.\";s:28:\"Archivo no encontrado: @uri.\";s:71:\"Translations imported: %number added, %update updated, %delete removed.\";s:87:\"Traducciones importadas: %number adicionados, %update actualizados, %delete eliminados.\";s:21:\"Checking translations\";s:22:\"Comprobar traducciones\";s:35:\"Error checking translation updates.\";s:49:\"Error comprobando actualizaciones de traducción.\";s:22:\"Updating translations.\";s:26:\"Traducciones actualizadas.\";s:69:\"No translation status available. <a href=\"@check\">Check manually</a>.\";s:92:\"El estado de la traducción no está disponible. <a href=\"@check\">Revíselo manualmente</a>.\";s:59:\"No translation files are provided for development releases.\";s:78:\"No se proporcionaron archivos de traducción para las versiones de desarrollo.\";s:49:\"File not found at %remote_path nor at %local_path\";s:55:\"Archivo no encontrado en %remote_path ni en %local_path\";s:15:\"@module (@date)\";s:15:\"@module (@date)\";s:19:\"@module (@version).\";s:19:\"@module (@version).\";s:25:\"Missing translations for:\";s:35:\"No se encuentran traducciones para:\";s:17:\"Updates available\";s:27:\"Actualizaciones disponibles\";s:20:\"Missing translations\";s:19:\"Faltan traducciones\";s:21:\"Updates for: @modules\";s:29:\"Actulizaciones para: @modules\";s:23:\"Last checked: !time ago\";s:33:\"Última comprobación: hace !time\";s:67:\"Status of interface translations for each of the enabled languages.\";s:76:\"Estado de traducciones de interfaz para cada uno de los idiomas habilitados.\";s:5:\"0 sec\";s:5:\"0 seg\";s:6:\"status\";s:6:\"estado\";s:3:\"any\";s:10:\"cualquiera\";s:9:\"published\";s:9:\"publicado\";s:13:\"not published\";s:12:\"no publicado\";s:8:\"promoted\";s:12:\"promocionado\";s:12:\"not promoted\";s:15:\"no promocionado\";s:6:\"sticky\";s:28:\"fijo en cabeza de las listas\";s:10:\"not sticky\";s:31:\"no fijo en cabeza de las listas\";s:4:\"type\";s:4:\"tipo\";s:8:\"language\";s:6:\"idioma\";s:21:\"Show only items where\";s:38:\"Mostrar sólo los elementos en los que\";s:6:\"Filter\";s:6:\"Filtro\";s:14:\"Update options\";s:26:\"Opciones de actualización\";s:24:\"Publish selected content\";s:34:\"Publicar el contenido seleccionado\";s:26:\"Unpublish selected content\";s:52:\"Retirar de la publicación el contenido seleccionado\";s:38:\"Promote selected content to front page\";s:45:\"Llevar lo seleccionado a la página principal\";s:39:\"Demote selected content from front page\";s:57:\"Retirar el contenido seleccionado de la página principal\";s:28:\"Make selected content sticky\";s:70:\"Hacer que el contenido seleccionado quede fijo en cabeza de las listas\";s:32:\"Make selected content not sticky\";s:71:\"Hacer que el contenido seleccionado no sea fijo en cabeza de las listas\";s:23:\"Delete selected content\";s:34:\"Eliminar el contenido seleccionado\";s:16:\"Update URL alias\";s:23:\"Actualizar alias de URL\";s:9:\"Operation\";s:10:\"Operación\";s:21:\"No content available.\";s:28:\"No hay contenido disponible.\";s:8:\"« first\";s:10:\"« primero\";s:12:\"‹ previous\";s:12:\"‹ anterior\";s:8:\"next ›\";s:13:\"siguiente ›\";s:7:\"last »\";s:10:\"última »\";s:35:\"Remove from %shortcut_set shortcuts\";s:46:\"Eliminar %shortcut_set de los accesos directos\";s:10:\"sort by @s\";s:14:\"ordenar por @s\";s:14:\"sort ascending\";s:16:\"orden ascendente\";s:22:\"GD library PNG support\";s:37:\"Funcionalidad PNG de la biblioteca GD\";s:16:\"CTools CSS Cache\";b:1;s:6:\"Exists\";b:1;s:11:\"Not enabled\";s:11:\"No activado\";s:15:\"Upload progress\";s:17:\"Progreso de carga\";s:40:\"GD library rotate and desaturate effects\";s:50:\"Efectos de rotado y desaturado de la biblioteca GD\";s:13:\"jQuery Update\";s:13:\"jQuery Update\";s:64:\"jQuery %jquery (<a href=\"@link\">configure</a>) and jQuery UI %ui\";b:1;s:23:\"Node Access Permissions\";s:26:\"Permisos de acceso al nodo\";s:19:\"Rebuild permissions\";s:20:\"Reconstruir permisos\";s:6:\"Drupal\";s:6:\"Drupal\";s:10:\"Web server\";s:12:\"Servidor web\";s:3:\"PHP\";s:3:\"PHP\";s:16:\"more information\";s:17:\"más información\";s:20:\"PHP register globals\";s:32:\"Variable register globals de PHP\";s:14:\"PHP extensions\";s:15:\"Extensiones PHP\";s:15:\"Database system\";s:24:\"Sistema de base de datos\";s:23:\"Database system version\";s:37:\"Versión del sistema de base de datos\";s:16:\"PHP memory limit\";s:22:\"Límite de memoria PHP\";s:9:\"Protected\";s:9:\"Protegido\";s:18:\"Configuration file\";s:25:\"Archivo de configuración\";s:22:\"Public files directory\";s:32:\"Directorio de archivos públicos\";s:25:\"Temporary files directory\";s:33:\"Directorio de archivos temporales\";s:12:\"@count hours\";b:1;s:10:\"@count min\";b:1;s:18:\"Last run !time ago\";s:29:\"Última ejecución hace !time\";s:46:\"You can <a href=\"@cron\">run cron manually</a>.\";s:52:\"Puede <a href=\"@cron\">ejecutar cron manualmente</a>.\";s:66:\"To run cron from outside the site, go to <a href=\"!cron\">!cron</a>\";s:68:\"Para ejecutar cron fuera del sitio, vaya a <a href=\"!cron\">!cron</a>\";s:22:\"Cron maintenance tasks\";s:31:\"Tareas de mantenimiento de cron\";s:42:\"Writable (<em>public</em> download method)\";s:57:\"Se puede escribir (método <em>público</em> de descarga)\";s:16:\"Database updates\";s:35:\"Actualizaciones de la base de datos\";s:20:\"Access to update.php\";s:19:\"Acceso a update.php\";s:12:\"Standard PHP\";s:13:\"PHP estándar\";s:22:\"PHP Mbstring Extension\";s:26:\"Extensión Mbstring de PHP\";s:5:\"Error\";s:5:\"Error\";s:15:\"Unicode library\";s:18:\"Biblioteca Unicode\";s:20:\"Update notifications\";s:24:\"Avisos de actualización\";s:23:\"Translation source node\";s:31:\"nodo original de la traducción\";s:56:\"The source node for this current node\'s translation set.\";s:66:\"El nodo de origen para el conjunto de traducción de nodos actual.\";s:20:\"Revision log message\";s:35:\"Mensaje del historial de revisiones\";s:60:\"The explanation of the most recent changes made to the node.\";s:61:\"La explicación de los cambios más recientes hechos al nodo.\";s:12:\"Content type\";s:17:\"Tipo de contenido\";s:29:\"The content type of the node.\";s:30:\"El tipo de contenido del nodo.\";s:32:\"Tokens related to content types.\";s:50:\"Comodines relacionados con los tipos de contenido.\";s:53:\"The unique machine-readable name of the content type.\";s:63:\"El único nombre legible por la máquina del tipo de contenido.\";s:10:\"Node count\";s:16:\"Número de nodos\";s:50:\"The number of nodes belonging to the content type.\";s:57:\"La cantidad de nodos pertenecientes al tipo de contenido.\";s:8:\"Edit URL\";s:10:\"Editar URL\";s:40:\"The URL of the content type\'s edit page.\";s:55:\"La URL de la página de edición del tipo de contenido.\";s:41:\"The URL of the taxonomy term\'s edit page.\";s:60:\"La URL de la página de edición del término de taxonomía.\";s:7:\"Parents\";s:6:\"Padres\";s:59:\"An array of all the term\'s parents, starting with the root.\";s:56:\"Matriz de los padres del término, a partir de la raíz.\";s:9:\"Root term\";s:14:\"Término raíz\";s:35:\"The root term of the taxonomy term.\";s:36:\"La raíz del término de taxonomía.\";s:51:\"The unique machine-readable name of the vocabulary.\";s:57:\"El único nombre legible por la máquina del vocabulario.\";s:38:\"The URL of the vocabulary\'s edit page.\";s:49:\"La URL de la página de edición del vocabulario.\";s:9:\"Base name\";s:11:\"Nombre base\";s:26:\"The base name of the file.\";s:27:\"El nombre base del archivo.\";s:9:\"Extension\";s:10:\"Extensión\";s:26:\"The extension of the file.\";s:26:\"La extensión del archivo.\";s:14:\"File byte size\";s:27:\"Tamaño de archivo en bytes\";s:31:\"The size of the file, in bytes.\";s:33:\"El tamaño del archivo, en bytes.\";s:24:\"Account cancellation URL\";s:32:\"URL de cancelación de la cuenta\";s:56:\"The URL of the confirm delete page for the user account.\";s:74:\"La URL de la página de confirmación para eliminar una cuenta de usuario.\";s:18:\"One-time login URL\";s:36:\"URL para un único inicio de sesión\";s:56:\"The URL of the one-time login page for the user account.\";s:72:\"La URL de la página de ingreso de uso único para la cuenta de usuario.\";s:7:\"Picture\";s:6:\"Imagen\";s:24:\"The picture of the user.\";s:22:\"La imagen del usuario.\";s:48:\"The user roles associated with the user account.\";s:56:\"Los roles de usuario asociados con la cuenta de usuario.\";s:10:\"IP address\";s:16:\"Direccion(es) IP\";s:10:\"Menu links\";s:16:\"Enlaces de menú\";s:29:\"Tokens related to menu links.\";s:48:\"Comodines relacionados con los enlaces de menú.\";s:7:\"Link ID\";s:12:\"ID de enlace\";s:31:\"The unique ID of the menu link.\";s:33:\"El ID único del enlace de menú.\";s:27:\"The title of the menu link.\";s:32:\"El título del enlace del menú.\";s:25:\"The URL of the menu link.\";s:27:\"La URL del enlace de menú.\";s:6:\"Parent\";s:5:\"Padre\";s:23:\"The menu link\'s parent.\";s:29:\"El padre del enlace de menú.\";s:64:\"An array of all the menu link\'s parents, starting with the root.\";s:71:\"Matriz de los padres de todo el menú del enlace, a partir de la raíz.\";s:4:\"Root\";s:5:\"Raíz\";s:21:\"The menu link\'s root.\";s:29:\"La raíz del enlace de menú.\";s:12:\"Current page\";s:14:\"Página actual\";s:43:\"Tokens related to the current page request.\";s:61:\"Comodines relacionados con la solicitud de la página actual.\";s:30:\"The title of the current page.\";s:32:\"El título de la página actual.\";s:28:\"The URL of the current page.\";s:28:\"La URL de la página actual.\";s:11:\"Page number\";s:18:\"Número de página\";s:61:\"The page number of the current page when viewing paged lists.\";s:67:\"El número de página de la página actual al ver listas paginadas.\";s:18:\"Query string value\";s:30:\"Valor de la cadena de consulta\";s:63:\"The value of a specific query string field of the current page.\";s:76:\"El valor de un campo de cadena de consulta específica de la página actual.\";s:23:\"Tokens related to URLs.\";s:35:\"Comodines relacionados con las URL.\";s:30:\"The path component of the URL.\";s:32:\"El componente de ruta de la URL.\";s:12:\"Relative URL\";s:12:\"URL relativa\";s:17:\"The relative URL.\";s:16:\"La URL relativa.\";s:12:\"Absolute URL\";s:12:\"URL absoluta\";s:17:\"The absolute URL.\";s:16:\"La URL absoluta.\";s:9:\"Brief URL\";s:9:\"URL breve\";s:52:\"The URL without the protocol and trailing backslash.\";s:42:\"La URL sin el protocolo ni la barra final.\";s:13:\"Unaliased URL\";s:13:\"URL sin alias\";s:18:\"The unaliased URL.\";s:17:\"La URL sin alias.\";s:9:\"Arguments\";s:10:\"Argumentos\";s:36:\"Tokens related to arrays of strings.\";s:45:\"Comodines relacionados con arrays de cadenas.\";s:5:\"First\";s:7:\"Primero\";s:31:\"The first element of the array.\";s:32:\"El primer elemento de la matriz.\";s:4:\"Last\";s:7:\"Último\";s:30:\"The last element of the array.\";s:33:\"El último elemento de la matriz.\";s:5:\"Count\";s:7:\"Número\";s:36:\"The number of elements in the array.\";s:37:\"El número de elementos en la matriz.\";s:8:\"Reversed\";s:9:\"Invertido\";s:19:\"The array reversed.\";s:20:\"La matriz invertida.\";s:31:\"The array of keys of the array.\";s:33:\"La matriz de claves de la matriz.\";s:8:\"Imploded\";s:12:\"Implosionado\";s:32:\"The specific value of the array.\";s:34:\"El valor específico de la matriz.\";s:6:\"Random\";s:9:\"Aleatorio\";s:31:\"A random number from 0 to @max.\";s:40:\"Un número aleatorio desde 0 hasta @max.\";s:4:\"Hash\";s:4:\"Hash\";s:64:\"A random hash. The possible hashing algorithms are: @hash-algos.\";s:63:\"Un hash al azar. Los algoritmos hash posibles son: @hash-algos.\";s:39:\"Tokens for comments posted on the site.\";s:49:\"Comodines para los comentarios enviados al sitio.\";s:13:\"Comment count\";s:23:\"Cantidad de comentarios\";s:40:\"The number of comments posted on a node.\";s:45:\"El número de comentarios enviados a un nodo.\";s:17:\"New comment count\";s:27:\"Nueva cuenta de comentarios\";s:72:\"The number of comments posted on a node since the reader last viewed it.\";s:92:\"La cantidad de comentarios enviados a un nodo desde la última vez que el usuario lo visitó\";s:10:\"Comment ID\";s:17:\"ID del comentario\";s:29:\"The unique ID of the comment.\";s:28:\"El ID único del comentario.\";s:10:\"IP Address\";s:13:\"Dirección IP\";s:59:\"The IP address of the computer the comment was posted from.\";s:69:\"La dirección IP de la máquina desde la que se envío el comentario.\";s:36:\"The name left by the comment author.\";s:45:\"el nombre dejado por el autor del comentario.\";s:13:\"Email address\";s:33:\"Dirección de correo electrónico\";s:45:\"The email address left by the comment author.\";s:72:\"La dirección de correo electrónico dejada por el autor del comentario.\";s:9:\"Home page\";s:17:\"Página de inicio\";s:45:\"The home page URL left by the comment author.\";s:69:\"La URL de la página de inicio que ha dejado el autor del comentario.\";s:25:\"The title of the comment.\";s:26:\"El título del comentario.\";s:44:\"The formatted content of the comment itself.\";s:45:\"El contenido formateado del comentario mismo.\";s:23:\"The URL of the comment.\";s:22:\"La URL del comentario.\";s:35:\"The URL of the comment\'s edit page.\";s:48:\"la URL de la página de edición del comentario.\";s:12:\"Date created\";s:18:\"Fecha de creación\";s:32:\"The date the comment was posted.\";s:43:\"La fecha en la que se envió el comentario.\";s:12:\"Date changed\";s:14:\"Fecha cambiada\";s:47:\"The date the comment was most recently updated.\";s:63:\"La fecha en la que se actualizó por última vez el comentario.\";s:53:\"The comment\'s parent, if comment threading is active.\";s:62:\"El comentario padre, si el hilo de comentarios está activado.\";s:35:\"The node the comment was posted to.\";s:36:\"El nodo al que envió el comentario.\";s:50:\"The author of the comment, if they were logged in.\";s:64:\"El autor del comentario, si estuviese identificado como usuario.\";s:24:\"Tokens related to menus.\";s:34:\"Comodines relacionados con menús.\";s:21:\"The name of the menu.\";s:20:\"El nombre del menú.\";s:45:\"The unique machine-readable name of the menu.\";s:51:\"El único nombre legible por la máquina del menú.\";s:37:\"The optional description of the menu.\";s:35:\"La descripción opcional del menú.\";s:15:\"Menu link count\";s:30:\"Número de enlaces en el menú\";s:47:\"The number of menu links belonging to the menu.\";s:55:\"El número de enlaces de menú pertenecientes al menú.\";s:32:\"The URL of the menu\'s edit page.\";s:43:\"La URL de la página de edición del menú.\";s:26:\"The menu of the menu link.\";s:29:\"El menú del enlace de menú.\";s:37:\"The URL of the menu link\'s edit page.\";s:53:\"La URL de la página de edición del enlace de menú.\";s:28:\"The menu link for this node.\";s:34:\"El enlace de menú para este nodo.\";s:5:\"Nodes\";s:5:\"Nodos\";s:55:\"Tokens related to individual content items, or \"nodes\".\";s:73:\"Comodines relacionados con elementos individuales de contenido o \"nodos\".\";s:10:\"Content ID\";s:15:\"ID de contenido\";s:45:\"The unique ID of the content item, or \"node\".\";s:48:\"El ID único del elemento de contenido o \"nodo\".\";s:11:\"Revision ID\";s:15:\"ID de revisión\";s:44:\"The unique ID of the node\'s latest revision.\";s:45:\"El ID único de la ultima revisión del nodo.\";s:18:\"Translation set ID\";s:30:\"ID del conjunto de traducción\";s:21:\"The type of the node.\";s:16:\"El tipo de nodo.\";s:17:\"Content type name\";s:27:\"Nombre de tipo de contenido\";s:41:\"The human-readable name of the node type.\";s:45:\"El nombre para los usuarios del tipo de nodo.\";s:22:\"The title of the node.\";s:20:\"El título del nodo.\";s:31:\"The main body text of the node.\";s:39:\"El texto del cuerpo principal del nodo.\";s:7:\"Summary\";s:7:\"Resumen\";s:41:\"The summary of the node\'s main body text.\";s:51:\"El resumen del texto del cuerpo principal del nodo.\";s:36:\"The language the node is written in.\";s:42:\"El idioma en el que está escrito el nodo.\";s:20:\"The URL of the node.\";s:16:\"La URL del nodo.\";s:32:\"The URL of the node\'s edit page.\";s:42:\"La URL de la página de edición del nodo.\";s:29:\"The date the node was posted.\";s:37:\"la fecha en la que se envió el nodo.\";s:44:\"The date the node was most recently updated.\";s:50:\"La fecha de actualización más reciente del nodo.\";s:23:\"The author of the node.\";s:18:\"El autor del nodo.\";s:59:\"Tokens for site-wide settings and other global information.\";s:89:\"Comodines relacionados con la configuración de todo el sitio y otra información global.\";s:5:\"Dates\";s:6:\"Fechas\";s:34:\"Tokens related to times and dates.\";s:42:\"Comodines relacionados con fechas y horas.\";s:33:\"Tokens related to uploaded files.\";s:48:\"Comodines relacionados con los archivos subidos.\";s:21:\"The name of the site.\";s:20:\"El nombre del sitio.\";s:6:\"Slogan\";s:4:\"Lema\";s:23:\"The slogan of the site.\";s:18:\"El lema del sitio.\";s:5:\"Email\";s:19:\"Correo electrónico\";s:46:\"The administrative email address for the site.\";s:52:\"El correo electrónico de administración del sitio.\";s:33:\"The URL of the site\'s front page.\";s:41:\"La URL de la página principal del sitio.\";s:11:\"URL (brief)\";s:11:\"URL (corta)\";s:54:\"The URL of the site\'s front page without the protocol.\";s:59:\"La URL de la página principal del sitio, sin el protocolo.\";s:10:\"Login page\";s:28:\"Página de inicio de sesión\";s:33:\"The URL of the site\'s login page.\";s:54:\"La URL de la página de inicio de sesión en el sitio.\";s:12:\"Short format\";s:13:\"Formato corto\";s:33:\"A date in \'short\' format. (%date)\";s:37:\"Una fecha en formato \'breve\' (%date).\";s:13:\"Medium format\";s:13:\"Formato medio\";s:3:\"Sat\";s:4:\"Sáb\";s:34:\"A date in \'medium\' format. (%date)\";s:37:\"Una fecha en formato \'medio\' (%date).\";s:11:\"Long format\";s:13:\"Formato largo\";s:32:\"A date in \'long\' format. (%date)\";s:37:\"Una fecha en formato \'largo\' (%date).\";s:13:\"Custom format\";s:21:\"Formato personalizado\";s:21:\"the PHP documentation\";s:21:\"La documentación PHP\";s:53:\"A date in a custom format. See !php-date for details.\";s:69:\"Una fecha en formato personalizado. Vea !php-date para más detalles.\";s:10:\"Time-since\";s:12:\"Tiempo desde\";s:12:\"@count years\";b:1;s:13:\"@count months\";b:1;s:38:\"A date in \'time-since\' format. (%date)\";s:40:\"Fecha en formato \'tiempo-desde\'. (%date)\";s:13:\"Raw timestamp\";s:26:\"Sello temporal sin filtrar\";s:39:\"A date in UNIX timestamp format (%date)\";s:51:\"Una fecha en formato de sello temporal UNIX (%date)\";s:7:\"File ID\";s:14:\"ID del archivo\";s:35:\"The unique ID of the uploaded file.\";s:44:\"El ID único del archivo subido al servidor.\";s:9:\"File name\";s:17:\"Nombre de archivo\";s:29:\"The name of the file on disk.\";s:34:\"El nombre del archivo en el disco.\";s:49:\"The location of the file relative to Drupal root.\";s:55:\"Localización del fichero relativa a la raiz de Drupal.\";s:9:\"MIME type\";s:9:\"Tipo MIME\";s:26:\"The MIME type of the file.\";s:25:\"El tipo MIME del archivo.\";s:9:\"File size\";s:18:\"Tamaño de archivo\";s:21:\"The size of the file.\";s:25:\"El tamaño del documento.\";s:36:\"The web-accessible URL for the file.\";s:49:\"La URL del archivo accesible a través de la web.\";s:9:\"Timestamp\";s:14:\"Sello temporal\";s:44:\"The date the file was most recently changed.\";s:53:\"La fecha de la alteración más reciente del archivo.\";s:5:\"Owner\";s:11:\"Propietario\";s:42:\"The user who originally uploaded the file.\";s:47:\"El usuario que subió el archivo originalmente.\";s:33:\"Tokens related to taxonomy terms.\";s:55:\"Comodines relacionados con los términos de taxonomía.\";s:12:\"Vocabularies\";s:12:\"Vocabularios\";s:40:\"Tokens related to taxonomy vocabularies.\";s:58:\"Comodines relacionados con los vocabularios de taxonomía.\";s:7:\"Term ID\";s:15:\"ID del término\";s:35:\"The unique ID of the taxonomy term.\";s:40:\"El ID único del término de taxonomía.\";s:50:\"The number of nodes tagged with the taxonomy term.\";s:62:\"El número de nodos etiquetados con el término de taxonomía.\";s:29:\"The URL of the taxonomy term.\";s:34:\"La URL del término de taxonomía.\";s:13:\"Vocabulary ID\";s:18:\"ID del vocabulario\";s:41:\"The unique ID of the taxonomy vocabulary.\";s:42:\"El ID único del vocabulario de taxonomía\";s:10:\"Term count\";s:20:\"Contador de terminos\";s:57:\"The number of terms belonging to the taxonomy vocabulary.\";s:69:\"La cantidad de términos que pertenecen al vocabulario de taxonomía.\";s:11:\"Parent term\";s:14:\"Término padre\";s:43:\"Tokens related to individual user accounts.\";s:59:\"Comodines relacionados con cuentas individuales de usuario.\";s:12:\"Current user\";s:14:\"Usuario actual\";s:47:\"Tokens related to the currently logged in user.\";s:63:\"Comodines relacionados con el usuario actualmente identificado.\";s:7:\"User ID\";s:13:\"ID de usuario\";s:34:\"The unique ID of the user account.\";s:37:\"El ID único de la cuenta de usuario.\";s:35:\"The login name of the user account.\";s:34:\"El nombre de usuario de la cuenta.\";s:38:\"The email address of the user account.\";s:61:\"La dirección de correo electrónico de la cuenta de usuario.\";s:36:\"The URL of the account profile page.\";s:45:\"La URL de la página del perfil de la cuenta.\";s:33:\"The URL of the account edit page.\";s:46:\"La URL de la página de edición de la cuenta.\";s:10:\"Last login\";s:22:\"Ultima identificación\";s:45:\"The date the user last logged in to the site.\";s:73:\"La fecha en la que el usuario se identificó por última vez en el sitio.\";s:38:\"The date the user account was created.\";s:49:\"La fecha en la que se creó la cuenta de usuario.\";s:27:\"Tokens for variable values.\";b:1;s:11:\"Joined path\";s:14:\"Ruta unificada\";s:24:\"Tokens related to views.\";s:33:\"Tokens relacionados con la vista.\";s:36:\"The human-readable name of the view.\";s:40:\"El nombre de la vista para los usuarios.\";s:28:\"The description of the view.\";s:28:\"La descripción de la vista.\";s:38:\"The machine-readable name of the view.\";s:33:\"El nombre de sistema de la vista.\";s:41:\"The title of current display of the view.\";s:50:\"El título de la presentación actual de la vista.\";s:20:\"The URL of the view.\";s:19:\"La URL de la vista.\";s:12:\"Current date\";s:12:\"Fecha actual\";s:44:\"Tokens related to the current date and time.\";s:52:\"Comodines relacionados con la fecha y hora actuales.\";s:16:\"Original @entity\";s:16:\"@entity original\";s:67:\"The original @entity data if the @entity is being updated or saved.\";s:79:\"Los datos originales de @entity si @entity está siendo actualizado o guardado.\";s:12:\"@type field.\";s:20:\"Campo de tipo @type.\";s:62:\"The following tokens or token types are not defined as arrays:\";s:103:\"Los siguientes patrones de reemplazo o tipos de patrón de reemplazo no están definidos como matrices:\";s:57:\"The following token types do not have any tokens defined:\";s:93:\"Los siguientes tipos de patrón de reemplazo no tienen ningún patrón de reemplazo definido.\";s:58:\"The following token types are not defined but have tokens:\";s:106:\"Los siguientes tipos de patrón de reemplazo no se encuentran definidos pero tienen patrones de reemplazo:\";s:67:\"The following token or token types are defined by multiple modules:\";s:100:\"Los siguientes patrones de reemplazo o tipos de patrón de reemplazo se definen por varios módulos:\";s:17:\"Hide descriptions\";s:21:\"Ocultar descripciones\";s:39:\"Compress layout by hiding descriptions.\";s:55:\"Comprimir la presentación ocultando las descripciones.\";s:4:\"i18n\";b:1;s:10:\"i18n_block\";b:1;s:18:\"Built-in interface\";s:20:\"Interfaz incorporada\";s:18:\"English (built-in)\";s:19:\"Inglés (incluído)\";s:30:\"GD2 image manipulation toolkit\";s:59:\"Juego de herramienas GD2 para la manipulación de imágenes\";s:49:\"The GD toolkit is installed and working properly.\";s:70:\"El juego de herramientas GD está instalado y funciona apropiadamente.\";s:12:\"JPEG quality\";s:12:\"Calidad JPEG\";s:1:\"%\";s:1:\"%\";s:6:\"Resize\";s:13:\"Redimensionar\";s:5:\"Scale\";s:6:\"Escala\";s:14:\"Scale and crop\";s:18:\"Escalar y recortar\";s:4:\"Crop\";s:8:\"Recortar\";s:10:\"Desaturate\";s:9:\"Desaturar\";s:42:\"Desaturate converts an image to grayscale.\";s:51:\"Desaturar convierte una imagen en escala de grises.\";s:6:\"Rotate\";s:5:\"Girar\";s:10:\"Style name\";s:16:\"Nombre de estilo\";s:23:\"Public file system path\";s:37:\"Ruta del sistema público de archivos\";s:24:\"Private file system path\";s:35:\"Ruta al sistema privado de archivos\";s:19:\"Temporary directory\";s:19:\"Directorio temporal\";s:23:\"Default download method\";s:34:\"Método predeterminado de descarga\";s:39:\"Transliterate file names during upload.\";s:50:\"Transliterar nombres de archivo durante la subida.\";s:38:\"Transliterate the displayed file name.\";s:44:\"Transliterar el nombre del archivo mostrado.\";s:36:\"Lowercase transliterated file names.\";s:48:\"Nombres de archivo transliterados a minúsculas.\";s:22:\"Unknown variable @name\";b:1;s:13:\"Private files\";s:15:\"Campos privados\";s:37:\"Private local files served by Drupal.\";s:46:\"Archivos privados locales servidos por Drupal.\";s:32:\"Transliteration is not required.\";s:36:\"No es necesaria la transliteración.\";s:67:\"There are currently no files names containing non-ASCII characters.\";s:76:\"En este momento no hay nombres de archivo que contengan caracteres no-ASCII.\";s:23:\"Private files directory\";s:31:\"Directorio de archivos privados\";s:9:\"No editor\";s:10:\"Sin editor\";s:72:\"<a href=\"!vendor-url\">@editor</a> (<a href=\"!download-url\">Download</a>)\";s:73:\"<a href=\"!vendor-url\">@editor</a> (<a href=\"!download-url\">Descargar</a>)\";s:14:\"Not installed.\";s:13:\"No instalado.\";s:74:\"So the actual library can be found at:<br /><code>@library-filepath</code>\";b:1;s:25:\"Installation instructions\";s:29:\"Instrucciones de instalación\";s:4:\"Info\";s:4:\"Info\";s:2:\"OK\";s:2:\"OK\";s:7:\"Warning\";s:11:\"Advertencia\";s:16:\"Select an editor\";b:1;s:6:\"Editor\";s:6:\"Editor\";s:15:\"String contains\";s:17:\"El texto contiene\";s:62:\"Leave blank to show all strings. The search is case sensitive.\";s:96:\"Déjelo vacío para mostrar todos los textos. La búsqueda distingue mayúsculas de minúsculas.\";s:13:\"All languages\";s:17:\"Todos los idiomas\";s:28:\"English (provided by Drupal)\";s:34:\"Inglés (proporcionado por Drupal)\";s:9:\"Search in\";s:6:\"Buscar\";s:40:\"Both translated and untranslated strings\";s:33:\"Textos traducidos y no traducidos\";s:23:\"Only translated strings\";s:27:\"Sólo los textos traducidos\";s:25:\"Only untranslated strings\";s:30:\"Sólo los textos no traducidos\";s:15:\"Limit search to\";s:19:\"Limitar búsqueda a\";s:15:\"All text groups\";s:25:\"Todos los grupos de texto\";s:27:\"Filter translatable strings\";s:26:\"Filtrar textos traducibles\";s:8:\"- None -\";s:11:\"- Ninguno -\";s:10:\"Text group\";s:14:\"Grupo de texto\";s:16:\"Go to first page\";s:23:\"Ir a la primera página\";s:19:\"Go to previous page\";s:24:\"Ir a la página anterior\";s:15:\"Go to next page\";s:25:\"Ir a la página siguiente\";s:15:\"Go to last page\";s:23:\"Ir a la última página\";s:18:\"Go to page @number\";s:23:\"Ir a la página @number\";s:4:\"Afar\";s:8:\"Afarense\";s:9:\"Abkhazian\";s:7:\"Abjazio\";s:7:\"Avestan\";s:9:\"Avéstico\";s:9:\"Afrikaans\";s:10:\"Afrikáans\";s:4:\"Akan\";s:4:\"Akan\";s:7:\"Amharic\";s:9:\"Amhárico\";s:6:\"Arabic\";s:6:\"Árabe\";s:8:\"Assamese\";s:7:\"Asamés\";s:8:\"Asturian\";s:9:\"Asturiano\";s:4:\"Avar\";s:4:\"Avar\";s:6:\"Aymara\";s:6:\"Aymara\";s:11:\"Azerbaijani\";s:6:\"Azerí\";s:7:\"Bashkir\";s:7:\"Bashkir\";s:10:\"Belarusian\";s:10:\"Bielorruso\";s:9:\"Bulgarian\";s:8:\"Búlgaro\";s:6:\"Bihari\";s:7:\"Biharí\";s:7:\"Bislama\";s:7:\"Bislama\";s:7:\"Bambara\";s:7:\"Bambara\";s:7:\"Bengali\";s:8:\"Bengalí\";s:7:\"Tibetan\";s:8:\"Tibetano\";s:6:\"Breton\";s:7:\"Bretón\";s:7:\"Bosnian\";s:6:\"Bosnio\";s:7:\"Catalan\";s:8:\"Catalán\";s:7:\"Chechen\";s:8:\"Checheno\";s:8:\"Chamorro\";s:8:\"Chamorro\";s:8:\"Corsican\";s:5:\"Corso\";s:4:\"Cree\";s:4:\"Cree\";s:5:\"Czech\";s:5:\"Checo\";s:12:\"Old Slavonic\";s:14:\"Eslavo antiguo\";s:7:\"Chuvash\";s:8:\"Chuvasio\";s:5:\"Welsh\";s:6:\"Galés\";s:6:\"Danish\";s:6:\"Danés\";s:6:\"German\";s:7:\"Alemán\";s:9:\"Maldivian\";s:7:\"Maldivo\";s:7:\"Bhutani\";s:8:\"Butanés\";s:3:\"Ewe\";s:3:\"Eue\";s:5:\"Greek\";s:6:\"Griego\";s:16:\"English, British\";s:18:\"Ingles, Británico\";s:9:\"Esperanto\";s:9:\"Esperanto\";s:8:\"Estonian\";s:7:\"Estonio\";s:6:\"Basque\";s:7:\"Euskera\";s:7:\"Persian\";s:5:\"Farsi\";s:5:\"Fulah\";s:5:\"Fulah\";s:7:\"Finnish\";s:10:\"Finlandés\";s:8:\"Filipino\";s:8:\"Filipino\";s:4:\"Fiji\";s:4:\"Fiyi\";s:8:\"Faeroese\";s:7:\"Feroés\";s:6:\"French\";s:8:\"Francés\";s:7:\"Frisian\";s:6:\"Frisio\";s:5:\"Irish\";s:19:\"Gaélico de Irlanda\";s:12:\"Scots Gaelic\";s:17:\"Gaélico escocés\";s:7:\"Guarani\";s:8:\"Guaraní\";s:12:\"Swiss German\";s:13:\"Alemán suizo\";s:8:\"Gujarati\";s:8:\"Gujarati\";s:4:\"Manx\";s:4:\"Manx\";s:5:\"Hausa\";s:5:\"Hausa\";s:6:\"Hebrew\";s:6:\"Hebreo\";s:5:\"Hindi\";s:5:\"Hindi\";s:9:\"Hiri Motu\";s:9:\"Hiri Motu\";s:8:\"Croatian\";s:6:\"Croata\";s:14:\"Haitian Creole\";s:16:\"Criollo haitiano\";s:9:\"Hungarian\";s:8:\"Húngaro\";s:8:\"Armenian\";s:7:\"Armenio\";s:6:\"Herero\";s:6:\"Herero\";s:11:\"Interlingua\";s:11:\"Interlingua\";s:10:\"Indonesian\";s:9:\"Indonesio\";s:11:\"Interlingue\";s:11:\"Interlingua\";s:4:\"Igbo\";s:4:\"Igbo\";s:7:\"Inupiak\";s:7:\"Inupiak\";s:9:\"Icelandic\";s:9:\"Islandés\";s:7:\"Italian\";s:8:\"Italiano\";s:9:\"Inuktitut\";s:9:\"Inuktitut\";s:8:\"Japanese\";s:8:\"Japonés\";s:8:\"Javanese\";s:8:\"Javanés\";s:8:\"Georgian\";s:9:\"Georgiano\";s:5:\"Kongo\";s:9:\"Congolés\";s:6:\"Kikuyu\";s:6:\"Kikuyu\";s:8:\"Kwanyama\";s:8:\"Kwanyama\";s:6:\"Kazakh\";s:6:\"Kazajo\";s:11:\"Greenlandic\";s:12:\"Groenlandés\";s:9:\"Cambodian\";s:9:\"Camboyano\";s:7:\"Kannada\";s:6:\"Kanada\";s:6:\"Korean\";s:7:\"Coreano\";s:6:\"Kanuri\";s:6:\"Kanuri\";s:8:\"Kashmiri\";s:10:\"Cachemirí\";s:7:\"Kurdish\";s:5:\"Kurdo\";s:4:\"Komi\";s:4:\"Komi\";s:7:\"Cornish\";s:8:\"Córnico\";s:6:\"Kyrgyz\";s:8:\"Kirguís\";s:5:\"Latin\";s:6:\"Latín\";s:13:\"Luxembourgish\";s:13:\"Luxemburgués\";s:7:\"Luganda\";s:7:\"Luganda\";s:7:\"Lingala\";s:7:\"Lingala\";s:8:\"Laothian\";s:8:\"Laosiano\";s:10:\"Lithuanian\";s:7:\"Lituano\";s:7:\"Latvian\";s:6:\"Letón\";s:8:\"Malagasy\";s:8:\"Malgache\";s:11:\"Marshallese\";s:11:\"Marshallés\";s:6:\"Māori\";s:6:\"Maorí\";s:10:\"Macedonian\";s:9:\"Macedonio\";s:9:\"Malayalam\";s:9:\"Malayalam\";s:9:\"Mongolian\";s:6:\"Mongol\";s:9:\"Moldavian\";s:7:\"Moldavo\";s:7:\"Marathi\";s:7:\"Márata\";s:5:\"Malay\";s:6:\"Malayo\";s:7:\"Maltese\";s:7:\"Maltés\";s:7:\"Burmese\";s:7:\"Birmano\";s:5:\"Nauru\";s:5:\"Nauru\";s:13:\"North Ndebele\";s:23:\"Ndebele (septentrional)\";s:6:\"Nepali\";s:7:\"Nepalí\";s:6:\"Ndonga\";s:6:\"Ndonga\";s:5:\"Dutch\";s:9:\"Holandés\";s:17:\"Norwegian Bokmål\";s:15:\"Noruego Bokmål\";s:17:\"Norwegian Nynorsk\";s:15:\"Noruego Nynorsk\";s:13:\"South Ndebele\";s:20:\"Ndebele (meridional)\";s:6:\"Navajo\";s:6:\"Navajo\";s:8:\"Chichewa\";s:8:\"Chichewa\";s:7:\"Occitan\";s:8:\"Occitano\";s:5:\"Oromo\";s:5:\"Oromo\";s:5:\"Oriya\";s:5:\"Oriya\";s:8:\"Ossetian\";s:6:\"Osetio\";s:7:\"Punjabi\";s:8:\"Punjabí\";s:4:\"Pali\";s:4:\"Pali\";s:6:\"Polish\";s:6:\"Polaco\";s:6:\"Pashto\";s:6:\"Pashto\";s:25:\"Portuguese, International\";s:25:\"Portugués, internacional\";s:20:\"Portuguese, Portugal\";s:21:\"Portugués (Portugal)\";s:18:\"Portuguese, Brazil\";s:23:\"Portugués (brasileño)\";s:7:\"Quechua\";s:7:\"Quechua\";s:14:\"Rhaeto-Romance\";s:12:\"Retorromance\";s:7:\"Kirundi\";s:7:\"Kirundi\";s:8:\"Romanian\";s:6:\"Rumano\";s:7:\"Russian\";s:4:\"Ruso\";s:11:\"Kinyarwanda\";s:11:\"Kinyarwanda\";s:8:\"Sanskrit\";s:10:\"Sánscrito\";s:9:\"Sardinian\";s:5:\"Sardo\";s:5:\"Scots\";s:5:\"Scots\";s:6:\"Sindhi\";s:6:\"Sindhi\";s:13:\"Northern Sami\";s:20:\"Sami (septentrional)\";s:5:\"Sango\";s:5:\"Sango\";s:14:\"Serbo-Croatian\";s:11:\"Serbocroata\";s:7:\"Sinhala\";s:9:\"Cingalés\";s:6:\"Slovak\";s:8:\"Eslovaco\";s:9:\"Slovenian\";s:8:\"Esloveno\";s:6:\"Samoan\";s:7:\"Samoano\";s:5:\"Shona\";s:5:\"Shona\";s:6:\"Somali\";s:7:\"Somalí\";s:8:\"Albanian\";s:8:\"Albanés\";s:7:\"Serbian\";s:6:\"Serbio\";s:7:\"Siswati\";s:5:\"Suazi\";s:7:\"Sesotho\";s:8:\"Sesotés\";s:8:\"Sudanese\";s:8:\"Sudanés\";s:7:\"Swedish\";s:5:\"Sueco\";s:7:\"Swahili\";s:7:\"Suajili\";s:5:\"Tamil\";s:5:\"Tamil\";s:6:\"Telugu\";s:6:\"Telugo\";s:5:\"Tajik\";s:6:\"Tayiko\";s:4:\"Thai\";s:10:\"Tailandés\";s:8:\"Tigrinya\";s:8:\"Tigriña\";s:7:\"Turkmen\";s:9:\"Turcomano\";s:7:\"Tagalog\";s:6:\"Tagalo\";s:8:\"Setswana\";s:8:\"Setsuana\";s:5:\"Tonga\";s:5:\"Tonga\";s:7:\"Turkish\";s:5:\"Turco\";s:6:\"Tsonga\";s:6:\"Tsonga\";s:5:\"Tatar\";s:8:\"Tártaro\";s:3:\"Twi\";s:3:\"Tui\";s:8:\"Tahitian\";s:9:\"Tahitiano\";s:6:\"Uyghur\";s:5:\"Uigur\";s:9:\"Ukrainian\";s:9:\"Ucraniano\";s:4:\"Urdu\";s:4:\"Urdu\";s:5:\"Uzbek\";s:6:\"Uzbeko\";s:5:\"Venda\";s:5:\"Venda\";s:10:\"Vietnamese\";s:10:\"Vietnamita\";s:5:\"Wolof\";s:5:\"Uolof\";s:5:\"Xhosa\";s:5:\"Xhosa\";s:8:\"Lolspeak\";s:8:\"Lolspeak\";s:7:\"Yiddish\";s:6:\"Yidish\";s:6:\"Yoruba\";s:6:\"Yoruba\";s:6:\"Zhuang\";s:6:\"Zhuang\";s:19:\"Chinese, Simplified\";s:19:\"Chino, simplificado\";s:20:\"Chinese, Traditional\";s:18:\"Chino, tradicional\";s:4:\"Zulu\";s:5:\"Zulú\";s:18:\"Import translation\";s:20:\"Importar traducción\";s:13:\"Language file\";s:18:\"Archivo del idioma\";s:46:\"A Gettext Portable Object (<em>.po</em>) file.\";s:61:\"Un archivo de formato Gettext Portable Object (<em>.po</em>).\";s:11:\"Import into\";s:11:\"Importar en\";s:55:\"Imported translations will be added to this text group.\";s:65:\"Las traducciones importadas se añadirán a este grupo de textos.\";s:4:\"Mode\";s:4:\"Modo\";s:40:\"Missing translations for @count projects\";b:1;s:13:\"Update @title\";s:17:\"Actualizar @title\";s:30:\"Module and theme update status\";s:53:\"Estado de actualización de módulos y temas visuales\";s:5:\"1 sec\";b:1;s:68:\"Checked available interface translation updates for @count projects.\";b:1;s:3:\"Wed\";s:4:\"Mié\";s:3:\"Thu\";s:3:\"Jue\";s:3:\"Fri\";s:3:\"Vie\";s:3:\"Mon\";s:3:\"Lun\";s:3:\"Sun\";s:3:\"Dom\";s:3:\"Tue\";s:3:\"Mar\";s:36:\"Missing translations for one project\";b:1;s:12:\"Created date\";s:18:\"Fecha de creación\";s:4:\"Next\";s:9:\"Siguiente\";s:26:\"Create a new user account.\";s:34:\"Crear una nueva cuenta de usuario.\";s:32:\"Request new password via e-mail.\";s:55:\"Solicita una contraseña nueva por correo electrónico.\";s:6:\"Prefix\";s:7:\"Prefijo\";s:6:\"Suffix\";s:6:\"Sufijo\";s:6:\"E-mail\";s:19:\"Correo electrónico\";s:8:\"Username\";s:17:\"Nombre de usuario\";s:5:\"Group\";s:5:\"Grupo\";s:3:\"yes\";s:3:\"sí\";s:7:\"Confirm\";s:9:\"Confirmar\";s:6:\"Remove\";s:8:\"Eliminar\";s:8:\"RSS feed\";s:9:\"Canal RSS\";s:4:\"More\";s:4:\"Más\";s:12:\"not verified\";s:13:\"no verificado\";s:3:\"new\";s:5:\"nuevo\";s:5:\"error\";s:5:\"error\";s:4:\"Tags\";s:9:\"Etiquetas\";s:11:\"Block title\";s:18:\"Título del bloque\";s:44:\"The title of the block as shown to the user.\";s:43:\"El título del bloque que ven los usuarios.\";s:3:\"Yes\";s:3:\"Sí\";s:2:\"No\";s:2:\"No\";s:4:\"cron\";s:4:\"cron\";s:10:\"Categories\";s:11:\"Categorías\";s:8:\"Download\";s:9:\"Descargar\";s:7:\"updated\";s:11:\"actualizado\";s:16:\"File information\";s:23:\"Información de archivo\";s:13:\"Release notes\";s:20:\"Notas de la versión\";s:4:\"Date\";s:5:\"Fecha\";s:4:\"Size\";s:7:\"Tamaño\";s:14:\"Predeterminado\";b:1;s:5:\"Daily\";s:11:\"Diariamente\";s:7:\"Message\";s:7:\"Mensaje\";s:26:\"No log messages available.\";s:28:\"No hay mensajes disponibles.\";s:8:\"Password\";s:11:\"Contraseña\";s:6:\"Center\";s:8:\"Centrado\";s:4:\"root\";s:5:\"raíz\";s:4:\"Book\";s:5:\"Libro\";s:7:\"Preview\";s:12:\"Vista previa\";s:3:\"Add\";s:7:\"Agregar\";s:6:\"Format\";s:7:\"Formato\";s:7:\"History\";s:9:\"Historial\";s:8:\"Filename\";s:17:\"Nombre de archivo\";s:7:\"Refresh\";s:10:\"Actualizar\";s:6:\"Region\";s:7:\"Región\";s:7:\"Visible\";s:7:\"Visible\";s:6:\"Anchor\";s:7:\"Anclaje\";s:7:\"Display\";s:13:\"Presentación\";s:17:\"Advanced settings\";s:18:\"Opciones avanzadas\";s:5:\"never\";s:5:\"nunca\";s:7:\"actions\";s:8:\"acciones\";s:8:\"Add term\";s:16:\"Agregar término\";s:10:\"Statistics\";s:13:\"Estadísticas\";s:15:\"Advanced search\";s:18:\"Búsqueda avanzada\";s:43:\"You are not authorized to access this page.\";s:52:\"Usted no está autorizado para visitar esta página.\";s:6:\"Upload\";s:17:\"Subir al servidor\";s:2:\"no\";s:2:\"no\";s:6:\"Create\";s:5:\"Crear\";s:6:\"Active\";s:8:\"Aprobado\";s:13:\"Access denied\";s:15:\"Acceso denegado\";s:4:\"Year\";s:4:\"Año\";s:4:\"Logo\";s:4:\"Logo\";s:4:\"Good\";s:5:\"Bueno\";s:19:\"Manual update check\";s:39:\"Comprobación manual de actualizaciones\";s:5:\"Never\";s:5:\"Nunca\";s:16:\"Update available\";s:25:\"Actualización disponible\";s:11:\"Out of date\";s:14:\"Desactualizado\";s:6:\"Inline\";s:8:\"Alineado\";s:8:\"Selected\";s:12:\"Seleccionado\";s:8:\"Hostname\";s:19:\"Nombre del servidor\";s:9:\"Signature\";s:5:\"Firma\";s:6:\"Locale\";s:16:\"Regionalización\";s:9:\"Revisions\";s:10:\"Revisiones\";s:9:\"URL alias\";s:12:\"Alias de URL\";s:15:\"Vocabulary name\";s:22:\"Nombre del vocabulario\";s:11:\"Last access\";s:14:\"Último acceso\";s:8:\"Severity\";s:8:\"Gravedad\";s:10:\"Field name\";s:16:\"Nombre del campo\";s:10:\"Field type\";s:13:\"Tipo de campo\";s:11:\"Widget type\";s:15:\"Tipo de control\";s:10:\"Overridden\";s:11:\"Sobrescrito\";s:8:\"Set name\";s:19:\"Nombre del conjunto\";s:14:\"Original image\";s:15:\"Imagen original\";s:7:\"blocked\";s:9:\"bloqueado\";s:6:\"active\";s:6:\"activo\";s:9:\"configure\";s:10:\"configurar\";s:11:\"Authored by\";s:11:\"Escrito por\";s:5:\"Width\";s:5:\"Ancho\";s:6:\"Height\";s:6:\"Altura\";s:7:\"Maximum\";s:7:\"Máximo\";s:7:\"Caching\";s:6:\"Caché\";s:5:\"Month\";s:3:\"Mes\";s:6:\"Widget\";s:7:\"Control\";s:32:\"Add a role to the selected users\";s:43:\"Añadir un rol a los usuarios seleccionados\";s:37:\"Remove a role from the selected users\";s:45:\"Eliminar un rol de los usuarios seleccionados\";s:5:\"Egypt\";s:6:\"Egipto\";s:7:\"Namibia\";s:7:\"Namibia\";s:6:\"Israel\";s:6:\"Israel\";s:4:\"Iran\";s:5:\"Irán\";s:11:\"New Zealand\";s:13:\"Nueva Zelanda\";s:4:\"Cuba\";s:4:\"Cuba\";s:6:\"Brazil\";s:6:\"Brasil\";s:5:\"Chile\";s:5:\"Chile\";s:8:\"Paraguay\";s:8:\"Paraguay\";s:7:\"Jamaica\";s:7:\"Jamaica\";s:5:\"Japan\";s:6:\"Japón\";s:5:\"Libya\";s:5:\"Libia\";s:6:\"Poland\";s:7:\"Polonia\";s:8:\"Portugal\";s:8:\"Portugal\";s:9:\"Singapore\";s:8:\"Singapur\";s:6:\"Turkey\";s:8:\"Turquía\";s:3:\"Day\";s:4:\"Día\";s:3:\"May\";s:4:\"Mayo\";s:2:\"am\";s:2:\"am\";s:2:\"pm\";s:2:\"pm\";s:9:\"!time ago\";s:10:\"Hace !time\";s:16:\"Background color\";s:14:\"Color de fondo\";s:10:\"Text color\";s:15:\"Color del texto\";s:5:\"Color\";s:5:\"Color\";s:6:\"Log in\";s:15:\"Iniciar sesión\";s:13:\"Not installed\";s:12:\"No instalado\";s:15:\"Text processing\";s:16:\"Procesando texto\";s:14:\"Maximum length\";s:16:\"Longitud máxima\";s:4:\"Rows\";s:5:\"Filas\";s:12:\"Save changes\";s:15:\"Guardar cambios\";s:7:\"Install\";s:8:\"Instalar\";s:5:\"Order\";s:6:\"Pedido\";s:11:\"Set default\";s:30:\"Establecer como predeterminado\";s:7:\"Profile\";s:6:\"Perfil\";s:15:\"Anonymous users\";s:15:\"Usuario anonimo\";s:11:\"Clear cache\";s:13:\"Vaciar caché\";s:19:\"Visibility settings\";s:23:\"Opciones de visibilidad\";s:5:\"Votes\";s:5:\"Votos\";s:8:\"Function\";s:8:\"Función\";s:7:\"Germany\";s:8:\"Alemania\";s:11:\"Afghanistan\";s:11:\"Afganistán\";s:7:\"Albania\";s:7:\"Albania\";s:7:\"Algeria\";s:7:\"Argelia\";s:14:\"American Samoa\";s:15:\"Samoa americana\";s:7:\"Andorra\";s:7:\"Andorra\";s:6:\"Angola\";s:6:\"Angola\";s:8:\"Anguilla\";s:7:\"Anguila\";s:10:\"Antarctica\";s:10:\"Antártida\";s:19:\"Antigua and Barbuda\";s:17:\"Antigua y Barbuda\";s:9:\"Argentina\";s:9:\"Argentina\";s:7:\"Armenia\";s:7:\"Armenia\";s:5:\"Aruba\";s:5:\"Aruba\";s:9:\"Australia\";s:9:\"Australia\";s:7:\"Austria\";s:7:\"Austria\";s:10:\"Azerbaijan\";s:11:\"Azerbaiyán\";s:7:\"Bahamas\";s:7:\"Bahamas\";s:7:\"Bahrain\";s:7:\"Bahrein\";s:10:\"Bangladesh\";s:10:\"Bangladesh\";s:8:\"Barbados\";s:8:\"Barbados\";s:7:\"Belarus\";s:11:\"Bielorrusia\";s:7:\"Belgium\";s:8:\"Bélgica\";s:6:\"Belize\";s:6:\"Belice\";s:5:\"Benin\";s:6:\"Benín\";s:7:\"Bermuda\";s:8:\"Bermudas\";s:6:\"Bhutan\";s:6:\"Bután\";s:7:\"Bolivia\";s:7:\"Bolivia\";s:22:\"Bosnia and Herzegovina\";s:20:\"Bosnia y Herzegovina\";s:8:\"Botswana\";s:8:\"Botsuana\";s:13:\"Bouvet Island\";s:11:\"Isla Bouvet\";s:6:\"Brunei\";s:6:\"Brunei\";s:8:\"Bulgaria\";s:8:\"Bulgaria\";s:12:\"Burkina Faso\";s:12:\"Burkina Faso\";s:7:\"Burundi\";s:7:\"Burundi\";s:8:\"Cambodia\";s:7:\"Camboya\";s:8:\"Cameroon\";s:8:\"Camerún\";s:6:\"Canada\";s:7:\"Canadá\";s:10:\"Cape Verde\";s:10:\"Cabo Verde\";s:14:\"Cayman Islands\";s:13:\"Islas Caimán\";s:24:\"Central African Republic\";s:25:\"República Centroafricana\";s:4:\"Chad\";s:4:\"Chad\";s:5:\"China\";s:5:\"China\";s:16:\"Christmas Island\";s:15:\"Isla de Navidad\";s:23:\"Cocos (Keeling) Islands\";s:11:\"Islas Cocos\";s:8:\"Colombia\";s:8:\"Colombia\";s:7:\"Comoros\";s:7:\"Comoras\";s:12:\"Cook Islands\";s:10:\"Islas Cook\";s:10:\"Costa Rica\";s:10:\"Costa Rica\";s:6:\"Cyprus\";s:6:\"Chipre\";s:14:\"Czech Republic\";s:16:\"República Checa\";s:7:\"Denmark\";s:9:\"Dinamarca\";s:8:\"Djibouti\";s:6:\"Yibuti\";s:8:\"Dominica\";s:8:\"Dominica\";s:18:\"Dominican Republic\";s:21:\"República Dominicana\";s:7:\"Ecuador\";s:7:\"Ecuador\";s:11:\"El Salvador\";s:11:\"El Salvador\";s:17:\"Equatorial Guinea\";s:17:\"Guinea Ecuatorial\";s:7:\"Eritrea\";s:7:\"Eritrea\";s:7:\"Estonia\";s:7:\"Estonia\";s:8:\"Ethiopia\";s:8:\"Etiopía\";s:13:\"Faroe Islands\";s:11:\"Islas Feroe\";s:7:\"Finland\";s:9:\"Finlandia\";s:6:\"France\";s:7:\"Francia\";s:13:\"French Guiana\";s:16:\"Guayana Francesa\";s:16:\"French Polynesia\";s:18:\"Polinesia Francesa\";s:5:\"Gabon\";s:6:\"Gabón\";s:6:\"Gambia\";s:6:\"Gambia\";s:7:\"Georgia\";s:7:\"Georgia\";s:5:\"Ghana\";s:5:\"Ghana\";s:9:\"Gibraltar\";s:9:\"Gibraltar\";s:6:\"Greece\";s:6:\"Grecia\";s:9:\"Greenland\";s:11:\"Groenlandia\";s:7:\"Grenada\";s:7:\"Granada\";s:10:\"Guadeloupe\";s:9:\"Guadalupe\";s:4:\"Guam\";s:4:\"Guam\";s:9:\"Guatemala\";s:9:\"Guatemala\";s:6:\"Guinea\";s:6:\"Guinea\";s:13:\"Guinea-Bissau\";s:13:\"Guinea-Bissau\";s:6:\"Guyana\";s:7:\"Guayana\";s:5:\"Haiti\";s:6:\"Haití\";s:33:\"Heard Island and McDonald Islands\";s:22:\"Islas Heard y McDonald\";s:7:\"Hungary\";s:8:\"Hungría\";s:7:\"Iceland\";s:8:\"Islandia\";s:5:\"India\";s:22:\"República de la India\";s:9:\"Indonesia\";s:9:\"Indonesia\";s:4:\"Iraq\";s:4:\"Irak\";s:7:\"Ireland\";s:7:\"Irlanda\";s:5:\"Italy\";s:6:\"Italia\";s:6:\"Jordan\";s:8:\"Jordania\";s:10:\"Kazakhstan\";s:25:\"República de Kazajistán\";s:5:\"Kenya\";s:5:\"Kenia\";s:8:\"Kiribati\";s:8:\"Kiribati\";s:6:\"Kuwait\";s:6:\"Kuwait\";s:10:\"Kyrgyzstan\";s:11:\"Kirguistán\";s:4:\"Laos\";s:4:\"Laos\";s:6:\"Latvia\";s:7:\"Letonia\";s:7:\"Lebanon\";s:19:\"República Libanesa\";s:7:\"Lesotho\";s:7:\"Lesotho\";s:7:\"Liberia\";s:7:\"Liberia\";s:13:\"Liechtenstein\";s:13:\"Liechtenstein\";s:9:\"Lithuania\";s:8:\"Lituania\";s:10:\"Luxembourg\";s:10:\"Luxemburgo\";s:10:\"Madagascar\";s:10:\"Madagascar\";s:6:\"Malawi\";s:6:\"Malaui\";s:8:\"Malaysia\";s:7:\"Malasia\";s:8:\"Maldives\";s:8:\"Maldivas\";s:4:\"Mali\";s:4:\"Mali\";s:5:\"Malta\";s:5:\"Malta\";s:16:\"Marshall Islands\";s:14:\"Islas Marshall\";s:10:\"Martinique\";s:9:\"Martinica\";s:10:\"Mauritania\";s:10:\"Mauritania\";s:9:\"Mauritius\";s:8:\"Mauricio\";s:7:\"Mayotte\";s:7:\"Mayotte\";s:6:\"Mexico\";s:7:\"México\";s:10:\"Micronesia\";s:10:\"Micronesia\";s:7:\"Moldova\";s:8:\"Moldavia\";s:6:\"Monaco\";s:7:\"Mónaco\";s:8:\"Mongolia\";s:8:\"Mongolia\";s:10:\"Montserrat\";s:10:\"Montserrat\";s:7:\"Morocco\";s:9:\"Marruecos\";s:10:\"Mozambique\";s:10:\"Mozambique\";s:7:\"Myanmar\";s:8:\"Birmania\";s:5:\"Nepal\";s:5:\"Nepal\";s:11:\"Netherlands\";s:13:\"Países Bajos\";s:20:\"Netherlands Antilles\";s:19:\"Antillas Holandesas\";s:13:\"New Caledonia\";s:15:\"Nueva Caledonia\";s:9:\"Nicaragua\";s:9:\"Nicaragua\";s:5:\"Niger\";s:6:\"Níger\";s:7:\"Nigeria\";s:7:\"Nigeria\";s:4:\"Niue\";s:4:\"Niue\";s:14:\"Norfolk Island\";s:15:\"Isla de Norfolk\";s:11:\"North Korea\";s:15:\"Corea del Norte\";s:24:\"Northern Mariana Islands\";s:24:\"Islas Marianas del Norte\";s:6:\"Norway\";s:7:\"Noruega\";s:4:\"Oman\";s:5:\"Omán\";s:8:\"Pakistan\";s:9:\"Pakistán\";s:5:\"Palau\";s:20:\"República de palaos\";s:6:\"Panama\";s:7:\"Panamá\";s:16:\"Papua New Guinea\";s:19:\"Papúa Nueva Guinea\";s:4:\"Peru\";s:5:\"Perú\";s:11:\"Philippines\";s:9:\"Filipinas\";s:11:\"Puerto Rico\";s:11:\"Puerto Rico\";s:5:\"Qatar\";s:15:\"Estado de Catar\";s:7:\"Reunion\";s:8:\"Reunión\";s:7:\"Romania\";s:8:\"Rumanía\";s:6:\"Russia\";s:5:\"Rusia\";s:6:\"Rwanda\";s:6:\"Ruanda\";s:5:\"Samoa\";s:5:\"Samoa\";s:10:\"San Marino\";s:10:\"San Marino\";s:12:\"Saudi Arabia\";s:23:\"Reino de Arabia Saudita\";s:7:\"Senegal\";s:7:\"Senegal\";s:10:\"Seychelles\";s:10:\"Seychelles\";s:12:\"Sierra Leone\";s:12:\"Sierra Leona\";s:8:\"Slovakia\";s:10:\"Eslovaquia\";s:8:\"Slovenia\";s:9:\"Eslovenia\";s:15:\"Solomon Islands\";s:14:\"Islas Salomón\";s:7:\"Somalia\";s:7:\"Somalia\";s:12:\"South Africa\";s:10:\"Sudáfrica\";s:44:\"South Georgia and the South Sandwich Islands\";s:41:\"Islas Georgias del Sur y Sandwich del Sur\";s:5:\"Spain\";s:7:\"España\";s:9:\"Sri Lanka\";s:9:\"Sri Lanka\";s:5:\"Sudan\";s:6:\"Sudán\";s:8:\"Suriname\";s:7:\"Surinam\";s:22:\"Svalbard and Jan Mayen\";s:20:\"Svalbard y Jan Mayen\";s:9:\"Swaziland\";s:11:\"Suazilandia\";s:6:\"Sweden\";s:6:\"Suecia\";s:11:\"Switzerland\";s:5:\"Suiza\";s:5:\"Syria\";s:5:\"Siria\";s:6:\"Taiwan\";s:7:\"Taiwán\";s:10:\"Tajikistan\";s:11:\"Tayikistán\";s:8:\"Tanzania\";s:8:\"Tanzania\";s:8:\"Thailand\";s:9:\"Tailandia\";s:4:\"Togo\";s:4:\"Togo\";s:7:\"Tokelau\";s:7:\"Tokelau\";s:19:\"Trinidad and Tobago\";s:17:\"Trinidad y Tobago\";s:7:\"Tunisia\";s:6:\"Túnez\";s:12:\"Turkmenistan\";s:13:\"Turkmenistán\";s:24:\"Turks and Caicos Islands\";s:21:\"Islas Turcas y Caicos\";s:6:\"Tuvalu\";s:6:\"Tuvalu\";s:6:\"Uganda\";s:6:\"Uganda\";s:7:\"Ukraine\";s:7:\"Ucrania\";s:20:\"United Arab Emirates\";s:23:\"Emiratos Árabes Unidos\";s:14:\"United Kingdom\";s:11:\"Reino Unido\";s:13:\"United States\";s:14:\"Estados Unidos\";s:36:\"United States Minor Outlying Islands\";s:36:\"Islas Ultramarinas de Estados Unidos\";s:7:\"Uruguay\";s:7:\"Uruguay\";s:10:\"Uzbekistan\";s:11:\"Uzbekistán\";s:7:\"Vanuatu\";s:7:\"Vanuatu\";s:9:\"Venezuela\";s:9:\"Venezuela\";s:17:\"Wallis and Futuna\";s:15:\"Wallis y Futuna\";s:5:\"Yemen\";s:5:\"Yemen\";s:6:\"Zambia\";s:6:\"Zambia\";s:8:\"Zimbabwe\";s:8:\"Zimbabue\";s:17:\"Size of textfield\";s:26:\"Tamaño del campo de texto\";s:21:\"Authoring information\";s:24:\"Información de autoría\";s:11:\"Authored on\";s:17:\"Fecha de autoría\";s:27:\"Leave blank for %anonymous.\";s:29:\"Dejar vacío para %anonymous.\";s:17:\"Allowed HTML tags\";s:25:\"Etiquetas HTML permitidas\";s:7:\"Sources\";s:7:\"Fuentes\";s:30:\"The update has been performed.\";s:30:\"Se ejecutó la actualización.\";s:18:\"View user profile.\";s:22:\"Ver perfil de usuario.\";s:14:\"Upload picture\";s:12:\"Subir imagen\";s:28:\"The changes have been saved.\";s:28:\"Se han guardado los cambios.\";s:21:\"Show only users where\";s:37:\"Mostrar sólo los usuarios en los que\";s:6:\"Refine\";s:7:\"Refinar\";s:4:\"Undo\";s:8:\"Deshacer\";s:10:\"Member for\";s:15:\"Miembro durante\";s:9:\"@time ago\";s:10:\"hace @time\";s:10:\"Front page\";s:17:\"Página de Inicio\";s:19:\"Allowed values list\";s:27:\"Lista de valores permitidos\";s:9:\"Edit menu\";s:12:\"Editar menú\";s:14:\"Minimum height\";s:14:\"Altura mínima\";s:13:\"Minimum width\";s:15:\"Anchura mínima\";s:15:\"Configure block\";s:17:\"Configurar bloque\";s:3:\"Jan\";s:3:\"Ene\";s:3:\"Feb\";s:3:\"Feb\";s:3:\"Apr\";s:3:\"Abr\";s:3:\"Jun\";s:3:\"Jun\";s:3:\"Jul\";s:3:\"Jul\";s:3:\"Aug\";s:3:\"Ago\";s:3:\"Sep\";s:3:\"Sep\";s:3:\"Oct\";s:3:\"Oct\";s:3:\"Nov\";s:3:\"Nov\";s:3:\"Dec\";s:3:\"Dic\";s:20:\"Existing system path\";s:28:\"Ruta existente en el sistema\";s:10:\"Path alias\";s:16:\"Alias de la ruta\";s:10:\"characters\";s:10:\"caracteres\";s:18:\"Create new account\";s:18:\"Crear nueva cuenta\";s:4:\"role\";s:3:\"rol\";s:10:\"list terms\";s:18:\"lista de términos\";s:9:\"add terms\";s:17:\"agregar términos\";s:23:\"Created new term %term.\";s:31:\"Creado el término nuevo %term.\";s:48:\"Are you sure you want to delete the term %title?\";s:57:\"¿Está seguro de que quiere eliminar el término %title?\";s:19:\"Deleted term %name.\";s:28:\"Eliminado el término %name.\";s:7:\"warning\";s:11:\"advertencia\";s:7:\"Blocked\";s:9:\"Bloqueado\";s:15:\"Enabled filters\";s:15:\"Filtros activos\";s:8:\"critical\";s:8:\"crítico\";s:7:\"Results\";s:10:\"Resultados\";s:4:\"open\";s:7:\"abierta\";s:12:\"Parent terms\";s:16:\"Términos padres\";s:20:\"Revisions for %title\";s:22:\"Revisiones para %title\";s:18:\"!date by !username\";s:19:\"!date por !username\";s:6:\"revert\";s:8:\"revertir\";s:16:\"current revision\";s:16:\"revisión actual\";s:30:\"Your settings have been saved.\";s:47:\"Se han guardado las opciones de configuración.\";s:10:\"permission\";s:7:\"permiso\";s:13:\"Aland Islands\";s:11:\"Islas Aland\";s:16:\"Falkland Islands\";s:23:\"Islas Malvinas/Falkland\";s:21:\"Saint Kitts and Nevis\";s:23:\"San Cristóbal y Nieves\";s:11:\"South Korea\";s:13:\"Corea del Sur\";s:11:\"Saint Lucia\";s:12:\"Santa Lucía\";s:12:\"Saint Helena\";s:12:\"Santa Helena\";s:21:\"Sao Tome and Principe\";s:23:\"Santo Tomé y Príncipe\";s:27:\"French Southern Territories\";s:31:\"Territorios Australes Franceses\";s:32:\"Saint Vincent and the Grenadines\";s:28:\"San Vicente y las Granadinas\";s:22:\"British Virgin Islands\";s:27:\"Islas Vírgenes Británicas\";s:19:\"U.S. Virgin Islands\";s:37:\"Islas Vírgenes de los Estados Unidos\";s:7:\"Vietnam\";s:7:\"Vietnam\";s:8:\"Guernsey\";s:8:\"Guernsey\";s:6:\"Jersey\";s:6:\"Jersey\";s:14:\"%type settings\";s:17:\"Opciones de %type\";s:23:\"Allowed file extensions\";s:34:\"Extensiones de archivos permitidos\";s:12:\"New comments\";s:18:\"Comentarios nuevos\";s:8:\"Top left\";s:18:\"Superior izquierda\";s:9:\"Top right\";s:16:\"Superior derecha\";s:12:\"Bottom right\";s:16:\"Inferior derecha\";s:11:\"Bottom left\";s:18:\"Inferior izquierda\";s:6:\"Themes\";s:5:\"Temas\";s:24:\"!name field is required.\";s:30:\"El campo !name es obligatorio.\";s:7:\"disable\";s:10:\"desactivar\";s:4:\"date\";s:5:\"fecha\";s:8:\"Timezone\";s:12:\"Zona horaria\";s:18:\"Password strength:\";s:28:\"Fortaleza de la contraseña:\";s:16:\"Passwords match:\";s:27:\"Las contraseñas coinciden:\";s:14:\"Alternate text\";s:17:\"Texto alternativo\";s:39:\"Enter the terms you wish to search for.\";s:29:\"Escriba lo que quiere buscar.\";s:30:\"British Indian Ocean Territory\";s:41:\"Territorio Británico del Océano Índico\";s:7:\"Croatia\";s:7:\"Croacia\";s:9:\"Macedonia\";s:23:\"República de Macedonia\";s:8:\"Pitcairn\";s:14:\"Islas Pitcairn\";s:14:\"Western Sahara\";s:18:\"Sáhara Occidental\";s:17:\"Block description\";s:23:\"Descripción del bloque\";s:11:\"Save blocks\";s:15:\"Guardar bloques\";s:37:\"The block settings have been updated.\";s:43:\"Se han actualizado las opciones del bloque.\";s:13:\"\'%name\' block\";s:14:\"Bloque \'%name\'\";s:29:\"Show block for specific roles\";s:38:\"Mostrar el bloque a roles determinados\";s:28:\"Show block on specific pages\";s:42:\"Mostrar el bloque en páginas específicas\";s:10:\"Save block\";s:17:\"Guardar el bloque\";s:39:\"The block configuration has been saved.\";s:44:\"Se ha guardado la configuración del bloque.\";s:27:\"The block has been created.\";s:23:\"Se ha creado el bloque.\";s:10:\"Block body\";s:17:\"Cuerpo del bloque\";s:46:\"The content of the block as shown to the user.\";s:55:\"El contenido del bloque tal como se muestra al usuario.\";s:15:\"edit vocabulary\";s:18:\"editar vocabulario\";s:29:\"Created new vocabulary %name.\";s:35:\"Creado un vocabulario nuevo, %name.\";s:25:\"Updated vocabulary %name.\";s:39:\"Se ha actualizado el vocabulario %name.\";s:54:\"Are you sure you want to delete the vocabulary %title?\";s:60:\"¿Está seguro de que quiere eliminar el vocabulario %title?\";s:25:\"Deleted vocabulary %name.\";s:37:\"Se ha eliminado el vocabulario %name.\";s:5:\"Above\";s:6:\"Encima\";s:16:\"Number of values\";s:18:\"Número de valores\";s:16:\"Add another item\";s:21:\"Añadir otro elemento\";s:18:\"Add existing field\";s:26:\"Añadir un campo existente\";s:19:\"Save field settings\";s:31:\"Guardar configuración de campo\";s:7:\"Minimum\";s:7:\"Mínimo\";s:14:\"@module module\";s:15:\"módulo @module\";s:16:\"More information\";s:17:\"Más información\";s:70:\"Your signature will be publicly displayed at the end of your comments.\";s:64:\"La firma se mostrará públicamente al final de sus comentarios.\";s:13:\"Language code\";s:17:\"Código de idioma\";s:5:\"debug\";s:7:\"depurar\";s:15:\"Menu link title\";s:29:\"Título del enlace del menú.\";s:72:\"The path \'@link_path\' is either invalid or you do not have access to it.\";s:65:\"La ruta \'@link_path\' es inválida o usted no tiene acceso a ella.\";s:9:\"Menu name\";s:16:\"Nombre del menú\";s:8:\"Profiles\";s:8:\"Perfiles\";s:17:\"URL path settings\";s:20:\"Opciones de ruta URL\";s:19:\"Maximum upload size\";s:25:\"Tamaño máximo de subida\";s:2:\"KB\";s:2:\"KB\";s:14:\"Page not found\";s:21:\"Página no encontrada\";s:15:\"Account blocked\";s:16:\"Cuenta bloqueada\";s:4:\"info\";s:12:\"información\";s:9:\"edit menu\";s:12:\"editar menú\";s:22:\"No comments available.\";s:31:\"No hay comentarios disponibles.\";s:2:\"ok\";s:8:\"correcto\";s:8:\"Add role\";s:11:\"Añadir rol\";s:19:\"Path to custom logo\";s:26:\"Ruta al logo personalizado\";s:19:\"Updated term %term.\";s:32:\"Se actualizó el término %term.\";s:6:\"Parser\";s:11:\"Intérprete\";s:5:\"Alias\";s:5:\"Alias\";s:21:\"Palestinian Territory\";s:20:\"Territorio Palestino\";s:7:\"Vatican\";s:11:\"El Vaticano\";s:15:\"Allow Upscaling\";s:21:\"Permitir ampliaciones\";s:53:\"Let scale make images larger than their original size\";s:79:\"Permitir que la escala haga las imágenes más grandes que su tamaño original.\";s:7:\"Account\";s:6:\"Cuenta\";s:18:\"authenticated user\";s:19:\"usuario autenticado\";s:3:\"Any\";s:10:\"Cualquiera\";s:53:\"E-mail addresses to notify when updates are available\";s:73:\"Direcciones de correo para avisar cuando haya actualizaciones disponibles\";s:18:\"All newer versions\";s:34:\"Todas las versiones más recientes\";s:21:\"Only security updates\";s:34:\"Sólo actualizaciones de seguridad\";s:11:\"Not secure!\";s:15:\"¡No es seguro!\";s:28:\"(version @version available)\";s:30:\"(versión @version disponible)\";s:52:\"See the available updates page for more information:\";s:69:\"Vea la página de actualizaciones disponibles para más información:\";s:39:\"New release(s) available for !site_name\";s:51:\"Nueva(s) versión(es) disponible(s) para !site_name\";s:27:\"No available releases found\";s:39:\"No se encontraron versiones disponibles\";s:20:\"Recommended version:\";s:21:\"Versión recomendada:\";s:15:\"Latest version:\";s:23:\"Versión más reciente:\";s:15:\"Also available:\";s:20:\"También disponible:\";s:6:\"@title\";s:6:\"@title\";s:13:\"Add new field\";s:19:\"Agregar nuevo campo\";s:27:\"Containing any of the words\";s:39:\"Que contenga cualquiera de las palabras\";s:21:\"Containing the phrase\";s:21:\"Que contenga la frase\";s:28:\"Containing none of the words\";s:39:\"Que no contenga ninguna de las palabras\";s:15:\"Content ranking\";s:20:\"Ranking de contenido\";s:17:\"Keyword relevance\";s:19:\"Relevancia de clave\";s:15:\"Recently posted\";s:21:\"Enviado recientemente\";s:18:\"Number of comments\";s:22:\"Número de comentarios\";s:6:\"Factor\";s:6:\"Factor\";s:2:\"Or\";s:1:\"O\";s:24:\"Maximum link text length\";s:37:\"Longitud máxima del texto del enlace\";s:14:\"Toggle display\";s:25:\"Cambiar la visualización\";s:41:\"%percentage of the site has been indexed.\";s:40:\"Se ha indexado el %percentage del sitio.\";s:14:\"File directory\";s:22:\"Directorio de archivos\";s:13:\"Default theme\";s:19:\"Tema predeterminado\";s:10:\"- Select -\";s:15:\"- Seleccionar -\";s:22:\"Up to date translation\";s:23:\"Traducción actualizada\";s:20:\"Outdated translation\";s:26:\"Traducción desactualizada\";s:30:\"@type %title has been deleted.\";s:29:\"Se ha eliminado @type %title.\";s:14:\"anonymous user\";s:16:\"usuario anónimo\";s:16:\"Save permissions\";s:16:\"Guardar permisos\";s:6:\"Effect\";s:6:\"Efecto\";s:16:\"edit permissions\";s:15:\"editar permisos\";s:17:\"Installed version\";s:18:\"Versión instalada\";s:19:\"Recommended version\";s:20:\"Versión recomendada\";s:6:\"notice\";s:5:\"aviso\";s:6:\"pixels\";s:8:\"píxeles\";s:10:\"Save order\";s:14:\"Guardar pedido\";s:4:\"done\";s:5:\"hecho\";s:9:\"edit role\";s:10:\"editar rol\";s:9:\"Relations\";s:10:\"Relaciones\";s:16:\"Confirm password\";s:21:\"Confirmar contraseña\";s:20:\"Administration theme\";s:23:\"Tema de administración\";s:16:\"Congo (Kinshasa)\";s:16:\"Congo (Kinshasa)\";s:19:\"Congo (Brazzaville)\";s:19:\"Congo (Brazzaville)\";s:11:\"Ivory Coast\";s:15:\"Costa de Marfil\";s:23:\"Hong Kong S.A.R., China\";s:26:\"R.A.E. de Hong Kong, China\";s:11:\"Isle of Man\";s:11:\"Isla de Man\";s:10:\"Montenegro\";s:10:\"Montenegro\";s:19:\"Macao S.A.R., China\";s:22:\"R.A.E. de Macao, China\";s:25:\"Saint Pierre and Miquelon\";s:21:\"San Pedro y Miguelón\";s:6:\"Serbia\";s:6:\"Serbia\";s:8:\"Run cron\";s:13:\"Ejecutar cron\";s:47:\"The specified file %name could not be uploaded.\";s:47:\"El archivo especificado %name no se pudo subir.\";s:69:\"Only files with the following extensions are allowed: %files-allowed.\";s:74:\"Sólo se permiten archivos con las siguientes extensiones: %files-allowed.\";s:7:\"New set\";s:14:\"Conjunto nuevo\";s:13:\"Re-index site\";s:25:\"Volver a indexar el sitio\";s:14:\"Maximum height\";s:12:\"Alto máximo\";s:13:\"Maximum width\";s:13:\"Ancho máximo\";s:11:\"Timor-Leste\";s:14:\"Timor Oriental\";s:14:\"Secondary tabs\";s:19:\"Solapas secundarias\";s:55:\"Enable or disable the display of certain page elements.\";s:72:\"Activa o desactiva la visualización de ciertos elementos de la página.\";s:24:\"Maximum image resolution\";s:32:\"Resolución máxima de la imagen\";s:12:\"Not writable\";s:20:\"No se puede escribir\";s:20:\"Revision information\";s:28:\"Información de la revisión\";s:26:\"Notify user of new account\";s:46:\"Notificar al usuario acerca de su nueva cuenta\";s:5:\"Comma\";s:4:\"Coma\";s:19:\"Path to custom icon\";s:27:\"Ruta al icono personalizado\";s:31:\"Unpublish the selected comments\";s:56:\"Retirar la publicación de los comentarios seleccionados\";s:13:\"Default image\";s:21:\"Imagen predeterminada\";s:10:\"List links\";s:14:\"Listar enlaces\";s:23:\"Enter your @s username.\";s:35:\"Escriba su nombre de usuario en @s.\";s:9:\"Posted in\";s:10:\"Enviado en\";s:15:\"Filter settings\";s:18:\"Opciones de filtro\";s:3:\"FTP\";s:3:\"FTP\";s:68:\"The website encountered an unexpected error. Please try again later.\";s:75:\"El sitio web encontró un error inesperado. Vuelva a intentarlo más tarde.\";s:8:\"Add link\";s:14:\"Añadir enlace\";s:17:\"User autocomplete\";s:25:\"Autocompletado de usuario\";s:40:\"The content type %name has been updated.\";s:45:\"Se ha actualizado el tipo de contenido %name.\";s:5:\"alert\";s:6:\"alerta\";s:9:\"emergency\";s:10:\"emergencia\";s:19:\"Filter log messages\";s:29:\"Filtrar mensajes del registro\";s:54:\"Provide a password for the new account in both fields.\";s:65:\"Proporcione una contraseña para la cuenta nueva en ambos campos.\";s:17:\"Language settings\";s:18:\"Opciones de idioma\";s:8:\"Visitors\";s:10:\"Visitantes\";s:46:\"The maximum length of the field in characters.\";s:41:\"Longitud máxima del campo en caracteres.\";s:13:\"Edit language\";s:13:\"Editar idioma\";s:10:\"list links\";s:14:\"listar enlaces\";s:38:\"The content type %name has been added.\";s:42:\"Se ha añadido el tipo de contenido %name.\";s:13:\"Right to left\";s:19:\"Derecha a izquierda\";s:13:\"Save language\";s:14:\"Guardar idioma\";s:24:\"Language name in English\";s:28:\"Nombre del idioma en inglés\";s:20:\"Native language name\";s:24:\"Nombre nativo del idioma\";s:49:\"Name of the language in the language being added.\";s:55:\"Nombre del idioma, en el idioma que se está agregando.\";s:15:\"Language domain\";s:18:\"Dominio del idioma\";s:50:\"Direction that text in this language is presented.\";s:44:\"Dirección en la que se escribe este idioma.\";s:41:\"Language negotiation configuration saved.\";s:60:\"Se ha guardado la configuración de negociación del idioma.\";s:26:\"The string has been saved.\";s:24:\"Se ha guardado el texto.\";s:63:\"Updated JavaScript translation file for the language %language.\";s:74:\"Archivo de traducción de JavaScript actualizado para el idioma %language.\";s:15:\"sort descending\";s:17:\"orden descendente\";s:57:\"Server error. Requested method @methodname not specified.\";s:65:\"Error del servidor. El método @methodname no está especificado.\";s:24:\"No blocks in this region\";s:30:\"No hay bloques en esta región\";s:28:\"Delete the selected comments\";s:38:\"Eliminar los comentarios seleccionados\";s:6:\"Strong\";s:6:\"Fuerte\";s:9:\"Ampersand\";s:9:\"Ampersand\";s:41:\"Lines and paragraphs break automatically.\";s:46:\"Saltos automáticos de líneas y de párrafos.\";s:70:\"Web page addresses and e-mail addresses turn into links automatically.\";s:94:\"Las direcciones de las páginas web y las de correo se convierten en enlaces automáticamente.\";s:44:\"This account\'s default language for e-mails.\";s:64:\"El idioma predeterminado de esta cuenta para mensajes de correo.\";s:25:\"The alias has been saved.\";s:24:\"Se ha guardado el alias.\";s:14:\"Filter aliases\";s:13:\"Filtras alias\";s:10:\"Edit alias\";s:12:\"Editar alias\";s:49:\"Are you sure you want to delete the field %field?\";s:50:\"¿Está seguro que desea eliminar el campo %field?\";s:15:\"Indexing status\";s:21:\"Estado de indexación\";s:17:\"Indexing throttle\";s:29:\"Regulación de la indexación\";s:37:\"Number of items to index per cron run\";s:57:\"Número de elementos a indexar en cada ejecución de cron\";s:17:\"Indexing settings\";s:23:\"Opciones de indexación\";s:28:\"Minimum word length to index\";s:50:\"Longitud mínima de la palabra que se va a indexar\";s:19:\"Simple CJK handling\";s:24:\"Gestión sencilla de CJK\";s:22:\"User pictures in posts\";s:40:\"Imágenes de los usuarios en los envíos\";s:25:\"User pictures in comments\";s:44:\"Imágenes de los usuarios en los comentarios\";s:13:\"Shortcut icon\";s:23:\"Icono de acceso rápido\";s:19:\"Logo image settings\";s:30:\"Opciones de la imagen del logo\";s:52:\"If toggled on, the following logo will be displayed.\";s:48:\"Si está activado, se muestra el logo siguiente.\";s:20:\"Use the default logo\";s:24:\"Usar el logo predefinido\";s:66:\"Check here if you want the theme to use the logo supplied with it.\";s:62:\"Márquelo si quiere que el tema use el logo que viene con él.\";s:56:\"You must enable the @required module to install @module.\";b:1;s:17:\"Upload logo image\";s:25:\"Cargar la imagen del logo\";s:22:\"Shortcut icon settings\";s:36:\"Opciones de iconos de acceso rápido\";s:30:\"Use the default shortcut icon.\";s:44:\"Usar el icono de acceso rápido predefinido.\";s:66:\"Check here if you want the theme to use the default shortcut icon.\";s:75:\"Márquelo si quiere que el tema use el icono de acceso rápido predefinido.\";s:17:\"Upload icon image\";s:22:\"Subir imagen del icono\";s:17:\"Confirm uninstall\";s:28:\"Confirmar la desinstalación\";s:55:\"Would you like to continue with uninstalling the above?\";s:73:\"¿Quiere continuar con la desinstalación de lo indicado precedentemente?\";s:43:\"The selected modules have been uninstalled.\";s:50:\"Los módulos seleccionados han sido desinstalados.\";s:15:\"Caches cleared.\";s:17:\"Cachés vaciadas.\";s:22:\"Cron ran successfully.\";s:34:\"La ejecución de cron tuvo éxito.\";s:38:\"No modules are available to uninstall.\";s:45:\"No hay módulos disponibles para desinstalar.\";s:20:\"Date and time lookup\";s:25:\"Búsqueda de fecha y hora\";s:41:\"The directory %directory is not writable.\";s:48:\"No es posible escribir en la carpeta %directory.\";s:21:\"Reset to alphabetical\";s:25:\"Restablecer a alfabético\";s:49:\"Terms are displayed in ascending order by weight.\";s:58:\"Los términos se muestran en orden ascendente por su peso.\";s:20:\"Translation settings\";s:23:\"Opciones de traducción\";s:29:\"Flag translations as outdated\";s:40:\"Marcar traducciones como desactualizadas\";s:36:\"This translation needs to be updated\";s:41:\"Esta traducción necesita ser actualizada\";s:19:\"Content translation\";s:25:\"Traducción del contenido\";s:23:\"Last checked: @time ago\";s:33:\"Última comprobación: hace @time\";s:19:\"Includes: %includes\";s:18:\"Incluye: %includes\";s:16:\"Disabled modules\";s:21:\"Módulos desactivados\";s:15:\"Disabled themes\";s:28:\"Temas gráficos desactivados\";s:29:\"E-mail notification threshold\";s:40:\"Umbral de correos electrónicos de aviso\";s:50:\"Enter the password that accompanies your username.\";s:55:\"Escriba la contraseña asignada a su nombre de usuario.\";s:18:\"Signature settings\";s:20:\"Opciones de la firma\";s:14:\"Delete picture\";s:15:\"Eliminar imagen\";s:46:\"Check this box to delete your current picture.\";s:49:\"Marque esta casilla para borrar su imagen actual.\";s:26:\"Unblock the selected users\";s:40:\"Desbloquear a los usuarios seleccionados\";s:24:\"Block the selected users\";s:35:\"Bloquear los usuarios seleccionados\";s:18:\"Progress indicator\";s:21:\"Indicador de progreso\";s:23:\"Bar with progress meter\";s:29:\"Barra con medidor de progreso\";s:8:\"Throbber\";s:8:\"Pulsador\";s:8:\"@size KB\";s:8:\"@size KB\";s:8:\"@size MB\";s:8:\"@size MB\";s:8:\"@size GB\";s:8:\"@size GB\";s:8:\"@size TB\";s:8:\"@size TB\";s:8:\"@size PB\";s:8:\"@size PB\";s:8:\"@size EB\";s:8:\"@size EB\";s:8:\"@size ZB\";s:8:\"@size ZB\";s:8:\"@size YB\";s:8:\"@size YB\";s:12:\"All messages\";s:18:\"Todos los mensajes\";s:7:\"(empty)\";s:8:\"(vacío)\";s:15:\"Region settings\";s:19:\"Opciones de región\";s:10:\"Top center\";s:13:\"Arriba centro\";s:13:\"Bottom center\";s:12:\"Abajo centro\";s:13:\"Format string\";s:16:\"Formato de texto\";s:23:\"- Select a field type -\";s:31:\"- Seleccione un tipo de campo -\";s:19:\"- Select a widget -\";s:25:\"- Seleccione un control -\";s:22:\"Type of data to store.\";s:26:\"Tipo de datos a almacenar.\";s:30:\"Form element to edit the data.\";s:45:\"Elemento de formulario para editar los datos.\";s:28:\"- Select an existing field -\";s:33:\"- Seleccione un campo existente -\";s:14:\"Field to share\";s:17:\"Campo a compartir\";s:22:\"@type: @field (@label)\";s:22:\"@type: @field (@label)\";s:56:\"Maximum number of values users can enter for this field.\";s:75:\"El número máximo de valores que los usuarios pueden entrar en este campo.\";s:12:\"width @width\";s:12:\"ancho @width\";s:14:\"height @height\";s:12:\"alto @height\";s:17:\"upscaling allowed\";s:24:\"se permiten ampliaciones\";s:17:\"Translate content\";s:18:\"Traducir contenido\";s:10:\"Edit style\";s:13:\"Editar estilo\";s:7:\"Fetcher\";s:11:\"Recuperador\";s:14:\"Cancel account\";s:15:\"Cancelar cuenta\";s:14:\"Secondary menu\";s:16:\"Menú secundario\";s:18:\"Administrator role\";s:20:\"Rol de administrador\";s:24:\"Site maintenance account\";s:33:\"Cuenta de mantenimiento del sitio\";s:19:\"No pending updates.\";s:34:\"No hay actualizaciones pendientes.\";s:16:\"No active batch.\";s:19:\"No hay lote activo.\";s:22:\"Site under maintenance\";s:35:\"Sitio desconectado en mantenimiento\";s:17:\"Saint Barthélemy\";s:14:\"San Bartolomé\";s:26:\"Saint Martin (French part)\";s:28:\"San Martín (parte francesa)\";s:60:\"Operating in maintenance mode. <a href=\"@url\">Go online.</a>\";s:74:\"Funcionando en modo de mantenimiento. <a href=\"@url\">Volver en línea.</a>\";s:23:\"%module module enabled.\";s:25:\"módulo %module activado.\";s:49:\"Refreshed @count strings for the enabled modules.\";b:1;s:60:\"Specify in which themes and regions this block is displayed.\";s:60:\"Especificar en qué temas y regiones se muestra este bloque.\";s:21:\"Customizable per user\";s:26:\"Personalizable por usuario\";s:16:\"Not customizable\";s:17:\"No personalizable\";s:32:\"Customizable, visible by default\";s:47:\"Personalizable, visible de forma predeterminada\";s:31:\"Customizable, hidden by default\";s:46:\"Personalizable, oculto de forma predeterminada\";s:60:\"Users with the \"Post comments\" permission can post comments.\";s:65:\"Los usuarios con el permiso \"Enviar comentarios\" pueden comentar.\";s:68:\"Users cannot post comments, but existing comments will be displayed.\";s:78:\"Los usuarios no pueden comentar pero se mostrarán los comentarios existentes.\";s:30:\"Comments are hidden from view.\";s:42:\"Los comentarios están ocultos a la vista.\";s:27:\"Users cannot post comments.\";s:44:\"Los usuarios no pueden publicar comentarios.\";s:9:\"DRAG HERE\";s:15:\"ARRASTRAR AQUÍ\";s:18:\"Clear log messages\";s:29:\"Limpiar mensajes del registro\";s:64:\"This will permanently remove the log messages from the database.\";s:82:\"Esto eliminará de forma permanente los mensajes del registro de la base de datos.\";s:34:\"Allowed HTML tags in labels: @tags\";s:44:\"Etiquetas HTML admitidas en etiquetas: @tags\";s:40:\"Filtered text (user selects text format)\";s:58:\"Texto filtrado (el usuario selecciona el formato de texto)\";s:13:\"Summary input\";s:21:\"Resumen de la entrada\";s:61:\"Leave blank to use trimmed value of full text as the summary.\";s:83:\"Déjelo en blanco para usar como resumen un fragmento recortado del texto completo.\";s:41:\"Configuring content types for translation\";s:48:\"Configurando tipos de contenido para traducción\";s:31:\"Assigning a language to content\";s:29:\"Asignando idioma al contenido\";s:19:\"Translating content\";s:21:\"Traduciendo contenido\";s:24:\"Maintaining translations\";s:24:\"Manteniendo traducciones\";s:20:\"Edit field settings.\";s:25:\"Editar opciones de campo.\";s:19:\"Change widget type.\";s:24:\"Cambiar tipo de control.\";s:23:\"Edit instance settings.\";s:29:\"Editar opciones de instancia.\";s:16:\"Delete instance.\";s:19:\"Eliminar instancia.\";s:29:\"%field has no field settings.\";s:34:\"%field no tiene opciones de campo.\";s:36:\"Updated field %label field settings.\";s:43:\"Actualizadas las opciones del campo %label.\";s:13:\"Change widget\";s:15:\"Cambiar control\";s:36:\"Changed the widget for field %label.\";s:41:\"Cambiado el control para el campo %label.\";s:62:\"The field %field has been deleted from the %type content type.\";s:62:\"El campo %field ha sido eliminado del tipo de contenido %type.\";s:74:\"These settings apply only to the %field field when used in the %type type.\";s:86:\"Estas opciones se aplican sólo en el campo %field cuando se utiliza en el tipo %type.\";s:14:\"Required field\";s:17:\"Campo obligatorio\";s:63:\"These settings apply to the %field field everywhere it is used.\";s:80:\"Estas opciones se aplican al campo %field en todos los sitios en los que se usa.\";s:21:\"%field field settings\";s:25:\"Opciones del campo %field\";s:65:\"The default value for this field, used when creating new content.\";s:79:\"El valor predeterminado para este campo. Se usa cuando se crea nuevo contenido.\";s:27:\"Saved %label configuration.\";s:37:\"Guardada la configuración de %label.\";s:19:\"Save and add fields\";s:24:\"Guardar y añadir campos\";s:29:\"Enable <em>Display</em> field\";s:36:\"Activar campo <em>Presentación</em>\";s:26:\"Files displayed by default\";s:42:\"Archivos mostrados de forma predeterminada\";s:65:\"This setting only has an effect if the display option is enabled.\";s:78:\"Esta opción sólo tiene efecto si la opción de presentación está activada.\";s:18:\"Upload destination\";s:32:\"Destino de la subida al servidor\";s:33:\"Enable <em>Description</em> field\";s:35:\"Activar campo <em>Descripción</em>\";s:14:\"Add a new file\";s:21:\"Añadir archivo nuevo\";s:30:\"Files must be less than !size.\";s:41:\"Los archivos deben ser menores que !size.\";s:32:\"Allowed file types: !extensions.\";s:41:\"Tipos de archivo permitidos: !extensions.\";s:54:\"The file in the !name field was unable to be uploaded.\";s:46:\"No se pudo subir el archivo en el campo !name.\";s:29:\"All roles may use this format\";s:40:\"Todos los roles pueden usar este formato\";s:23:\"Filter processing order\";s:37:\"Orden de procesamiento de los filtros\";s:41:\"The text format %format has been updated.\";s:46:\"Se ha actualizado el formato de texto %format.\";s:35:\"More information about text formats\";s:45:\"Más información sobre los formatos de texto\";s:23:\"Limit allowed HTML tags\";s:37:\"Limitar las etiquetas HTML permitidas\";s:23:\"Convert URLs into links\";s:25:\"Convertir URLs en enlaces\";s:35:\"Correct faulty and chopped off HTML\";s:37:\"Corregir HTML defectuoso o incompleto\";s:30:\"Display any HTML as plain text\";s:46:\"Mostrar cualquier HTML como texto sin formato.\";s:43:\"Display basic HTML help in long filter tips\";s:60:\"Mostrar ayuda HTML básica en los consejos largos de filtros\";s:31:\"Add rel=\"nofollow\" to all links\";s:42:\"Añadir rel=\"nofollow\" a todos los enlaces\";s:21:\"No HTML tags allowed.\";s:30:\"No se permiten etiquetas HTML.\";s:9:\"i18n_node\";b:1;s:9:\"i18n_sync\";b:1;s:11:\"translation\";b:1;s:16:\"Edit %name style\";s:19:\"Editar estilo %name\";s:16:\"Image style name\";s:26:\"Nombre de estilo de imagen\";s:19:\"Select a new effect\";s:27:\"Seleccionar un efecto nuevo\";s:6:\"Resumo\";b:1;s:17:\"Override defaults\";s:36:\"Sobrescribir valores predeterminados\";s:12:\"Update style\";s:17:\"Actualizar estilo\";s:42:\"The image effect was successfully applied.\";s:45:\"El efecto de imagen se aplicó correctamente.\";s:74:\"The %style style has been overridden, allowing you to change its settings.\";s:82:\"El estilo %style ha sido sobrescrito, lo que le permite cambiar su configuración.\";s:16:\"Create new style\";s:18:\"Crear estilo nuevo\";s:24:\"Style %name was created.\";s:24:\"Se creo el estilo %name.\";s:18:\"Edit %label effect\";s:20:\"Editar efecto %label\";s:17:\"Add %label effect\";s:21:\"Añadir efecto %label\";s:13:\"Update effect\";s:17:\"Actualizar efecto\";s:10:\"Add effect\";s:14:\"Añadir efecto\";s:60:\"The part of the image that will be retained during the crop.\";s:53:\"La parte de la imagen que se conservará al recortar.\";s:16:\"view actual size\";s:16:\"ver tamaño real\";s:21:\"Sample original image\";s:26:\"Imagen de ejemplo original\";s:21:\"Sample modified image\";s:28:\"Imagen de ejemplo modificada\";s:61:\"If no image is uploaded, this image will be shown on display.\";s:63:\"Si no se sube una imagen, ésta será la imagen que se muestre.\";s:24:\"Minimum image resolution\";s:29:\"Resolución mínima de imagen\";s:25:\"Enable <em>Alt</em> field\";s:26:\"Activar campo <em>Alt</em>\";s:27:\"Enable <em>Title</em> field\";s:30:\"Activar campo <em>Título</em>\";s:19:\"Preview image style\";s:32:\"Vista previa de estilo de imagen\";s:10:\"no preview\";s:16:\"sin vista previa\";s:58:\"The preview image will be shown while editing the content.\";s:65:\"La vista previa de la imagen se mostrará al editar el contenido.\";s:23:\"Error generating image.\";s:24:\"Error al crear la imagen\";s:20:\"Generate image style\";s:22:\"Crear estilo de imagen\";s:25:\"Configure an image style.\";s:31:\"Configurar un estilo de imagen.\";s:17:\"Edit image effect\";s:23:\"Editar efecto de imagen\";s:16:\"Add image effect\";s:24:\"Añadir efecto de imagen\";s:28:\"Add a new effect to a style.\";s:36:\"Agregar un efecto nuevo a un estilo.\";s:25:\"Path prefix language code\";s:37:\"Código de idioma del prefijo de ruta\";s:8:\"add link\";s:14:\"añadir enlace\";s:46:\"The text to be used for this link in the menu.\";s:52:\"El texto que se usará en el menú para este enlace.\";s:63:\"Menu links that are not enabled will not be listed in any menu.\";s:79:\"Los enlaces de menú que no estén activados no se mostrarán en ningún menú.\";s:16:\"Show as expanded\";s:17:\"Mostrar expandido\";s:11:\"Parent link\";s:12:\"Enlace padre\";s:59:\"Are you sure you want to delete the custom menu link %item?\";s:67:\"¿Seguro que desea eliminar el enlace de menú personalizado %item?\";s:38:\"The menu link %title has been deleted.\";s:44:\"El enlace de menú %title ha sido eliminado.\";s:14:\"Edit menu link\";s:22:\"Editar enlace de menú\";s:16:\"Delete menu link\";s:24:\"Eliminar enlace de menú\";s:33:\"Content is sticky at top of lists\";s:47:\"El contenido está fijo en cabeza de las listas\";s:37:\"Content is promoted to the front page\";s:41:\"El contenido está promovido a la portada\";s:37:\"Show block for specific content types\";s:52:\"Mostrar bloques para tipos de contenido específicos\";s:32:\"Choose a set of shortcuts to use\";s:37:\"Elija un conjunto de atajos para usar\";s:45:\"You are now using the %set_name shortcut set.\";s:51:\"Ahora está usando el conjunto de atajos %set_name.\";s:10:\"Change set\";s:16:\"Cambiar conjunto\";s:34:\"The shortcut set has been updated.\";s:42:\"El conjunto de atajos ha sido actualizado.\";s:17:\"Editing @shortcut\";s:18:\"Editando @shorcurt\";s:25:\"The name of the shortcut.\";s:19:\"El nombre del atajo\";s:25:\"The path to the shortcut.\";s:16:\"La ruta al atajo\";s:36:\"The shortcut %link has been updated.\";s:35:\"El atajo %link ha sido actualizado.\";s:28:\"Added a shortcut for %title.\";s:45:\"Se ha añadido un acceso directo para %title.\";s:52:\"Are you sure you want to delete the shortcut %title?\";s:59:\"¿Está seguro que desea eliminar el acceso directo %title?\";s:37:\"The shortcut %title has been deleted.\";s:43:\"El acceso directo %title ha sido eliminado.\";s:12:\"Add shortcut\";s:22:\"Añadir acceso directo\";s:13:\"Edit shortcut\";s:12:\"Editar atajo\";s:15:\"Delete shortcut\";s:14:\"Eliminar atajo\";s:27:\"Screenshot for !theme theme\";s:25:\"Miniatura del tema !theme\";s:25:\"Settings for !theme theme\";s:28:\"Opciones para el tema !theme\";s:20:\"Disable !theme theme\";s:22:\"Desactivar tema !theme\";s:27:\"Set !theme as default theme\";s:42:\"Establecer !theme como tema predeterminado\";s:19:\"Enable !theme theme\";s:19:\"Activar tema !theme\";s:22:\"Enable and set default\";s:40:\"Activar y establecer como predeterminado\";s:30:\"Enable !theme as default theme\";s:48:\"Activar !theme como tema gráfico predeterminado\";s:13:\"default theme\";s:19:\"tema predeterminado\";s:61:\"Use the administration theme when editing or creating content\";s:59:\"Usar el tema de administración al editar o crear contenido\";s:35:\"The %theme theme has been disabled.\";s:35:\"El tema %theme ha sido desactivado.\";s:36:\"User verification status in comments\";s:53:\"Estado de verificación de usuario en los comentarios\";s:46:\"How this is used depends on your site\'s theme.\";s:56:\"Cómo se use esto depende del tema gráfico de su sitio.\";s:29:\"Number of posts on front page\";s:43:\"Cantidad de envíos en la página principal\";s:19:\"Errors and warnings\";s:22:\"Errores y advertencias\";s:16:\"Clear all caches\";s:24:\"Vaciar todas las cachés\";s:22:\"Bandwidth optimization\";s:31:\"Optimización de ancho de banda\";s:10:\"Time zones\";s:14:\"Zonas horarias\";s:59:\"No date types available. <a href=\"@link\">Add date type</a>.\";s:82:\"No hay tipos de fecha disponibles. <a href=\"@link\">Añadir nuevo tipo de fecha</a>\";s:33:\"New date type added successfully.\";s:48:\"Nuevo tipo de fecha añadido satisfactoriamente.\";s:70:\"No custom date formats available. <a href=\"@link\">Add date format</a>.\";s:98:\"No hay formatos de fecha personalizados disponibles. <a href=\"@link\">Añadir formato de fecha</a>.\";s:12:\"Displayed as\";s:15:\"Se muestra como\";s:25:\"Custom date format added.\";s:40:\"Formato de fecha personalizado añadido.\";s:14:\"Update modules\";s:19:\"Actualizar módulos\";s:13:\"Update themes\";s:16:\"Actualizar temas\";s:12:\"@zone: @date\";s:12:\"@zone: @date\";s:42:\"Powered by <a href=\"@poweredby\">Drupal</a>\";s:44:\"Funciona con <a href=\"@poweredby\">Drupal</a>\";s:13:\"AHAH callback\";s:13:\"AHAH callback\";s:13:\"Disable theme\";s:15:\"Desactivar tema\";s:34:\"Your configuration has been saved.\";s:35:\"Su configuración ha sido guardada.\";s:62:\"No vocabularies available. <a href=\"@link\">Add vocabulary</a>.\";s:73:\"No hay vocabularios disponibles. <a href=\"@link\">Agregar vocabulario</a>.\";s:49:\"No terms available. <a href=\"@link\">Add term</a>.\";s:67:\"No hay términos disponibles. <a href=\"@link\">Agregar término</a>.\";s:57:\"The vocabulary which supplies the options for this field.\";s:60:\"El vocabulario que proporciona las opciones para este campo.\";s:18:\"Installing updates\";s:26:\"Instalando actualizaciones\";s:29:\"Preparing to update your site\";s:40:\"Preparando la actualización de su sitio\";s:19:\"Installing %project\";s:19:\"Instalando %project\";s:20:\"Preparing to install\";s:23:\"Preparandose a instalar\";s:24:\"No available update data\";s:42:\"No hay datos de actualización disponibles\";s:30:\"Checking available update data\";s:47:\"Comprobando datos de actualización disponibles\";s:41:\"Trying to check available update data ...\";s:64:\"Intentando comprobar los datos de actualización disponibles ...\";s:37:\"Error checking available update data.\";s:59:\"Error al comprobar los datos de actualización disponibles.\";s:34:\"Checking available update data ...\";s:55:\"Comprobando los datos de actualización disponibles ...\";s:41:\"Checked available update data for %title.\";s:60:\"datos de actualización disponibles para %title comprobados.\";s:15:\"(Release notes)\";s:22:\"(notas de la versión)\";s:36:\"All of your projects are up to date.\";s:40:\"Todos los proyectos están actualizados.\";s:22:\"Download these updates\";s:31:\"Descargar estas actualizaciones\";s:19:\"Downloading updates\";s:27:\"Descargando actualizaciones\";s:38:\"Preparing to download selected updates\";s:59:\"Preparando la descarga de las actualizaciones seleccionadas\";s:32:\"Updates downloaded successfully.\";s:42:\"Actualizaciones descargadas correctamente.\";s:68:\"Perform updates with site in maintenance mode (strongly recommended)\";s:93:\"Realizar las actualizaciones con el sitio en modo de mantenimiento (se recomienda vivamente).\";s:18:\"Install from a URL\";s:22:\"Instalar desde una URL\";s:17:\"For example: %url\";s:17:\"Por ejemplo: %url\";s:43:\"Upload a module or theme archive to install\";s:48:\"Subir un archivo de módulo o tema para instalar\";s:47:\"For example: %filename from your local computer\";s:47:\"Por ejemplo: %filename desde su máquina local.\";s:20:\"Downloading %project\";s:20:\"Descargando %project\";s:23:\"Required by: %subthemes\";s:26:\"Necesario para: %subthemes\";s:15:\"Ready to update\";s:21:\"Listo para actualizar\";s:14:\"Update manager\";s:25:\"Gestor de actualizaciones\";s:20:\"No people available.\";s:28:\"No hay personas disponibles.\";s:29:\"Registration and cancellation\";s:35:\"Creación y cancelación de cuentas\";s:26:\"Who can register accounts?\";s:29:\"¿Quién puede crear cuentas?\";s:19:\"Administrators only\";s:20:\"Solo administradores\";s:48:\"Visitors, but administrator approval is required\";s:67:\"Visitantes, pero es necesaria la aprobación de los administradores\";s:62:\"Require e-mail verification when a visitor creates an account.\";s:90:\"Pedir una verificación por correo electrónico sólo cuando un visitante crea una cuenta.\";s:30:\"When cancelling a user account\";s:39:\"Cuando se cancela una cuenta de usuario\";s:36:\"Select method for cancelling account\";s:47:\"Seleccionar el método para cancelar la cuenta.\";s:15:\"Personalization\";s:16:\"Personalización\";s:18:\"Enable signatures.\";s:16:\"Permitir firmas.\";s:21:\"Enable user pictures.\";s:31:\"Habilitar imágenes de usuario.\";s:21:\"Picture display style\";s:36:\"Estilo de presentación de la imagen\";s:25:\"Picture upload dimensions\";s:30:\"Dimensiones de imágen a subir\";s:24:\"Picture upload file size\";s:36:\"Tamaño de archivo de imagen a subir\";s:7:\"E-mails\";s:21:\"Correos electrónicos\";s:43:\"Welcome (new user created by administrator)\";s:54:\"Bienvenida (nuevo usuario creado por un administrador)\";s:27:\"Welcome (awaiting approval)\";s:37:\"Bienvenida (pendiente de aprobación)\";s:30:\"Welcome (no approval required)\";s:41:\"Bienvenida (sin necesidad de aprobación)\";s:17:\"Password recovery\";s:28:\"Recuperación de contraseña\";s:66:\"Edit the e-mail messages sent to users who request a new password.\";s:106:\"Editar los mensajes de correo electrónico que se envían a los usuarios cuando solicitan una nueva clave.\";s:18:\"Account activation\";s:21:\"Activación de cuenta\";s:16:\"Account canceled\";s:16:\"Cuenta cancelada\";s:37:\"Notify user when account is canceled.\";s:51:\"Notificar al usuario cuando su cuenta es cancelada.\";s:45:\"By default, Drupal comes with two user roles:\";s:60:\"De forma predefinida, Drupal viene con dos roles de usuario:\";s:34:\"User module timezone form element.\";s:66:\"Elemento del formulario de la zona horaria del módulo de usuario.\";s:33:\"User module history view element.\";s:54:\"Elemento de vista de historial del módulo de usuario.\";s:46:\"Account details for [user:name] at [site:name]\";s:51:\"Detalles de la cuenta de [user:name] en [site:name]\";s:58:\"An administrator created an account for you at [site:name]\";s:63:\"Un administrador ha creado para usted una cuenta en [site:name]\";s:71:\"Account details for [user:name] at [site:name] (pending admin approval)\";s:93:\"Detalles de la cuenta de [user:name] en [site:name] (pendiente de aprobación administrativa)\";s:60:\"Replacement login information for [user:name] at [site:name]\";s:78:\"Información de reemplazo de inicio de sesión para [user:name] en [site:name]\";s:57:\"Account details for [user:name] at [site:name] (approved)\";s:62:\"Detalles de la cuenta de [user:name] en [site:name] (aprobada)\";s:56:\"Account details for [user:name] at [site:name] (blocked)\";s:63:\"Detalles de la cuenta de [user:name] en [site:name] (bloqueada)\";s:59:\"Account cancellation request for [user:name] at [site:name]\";s:65:\"Petición de cancelación de cuenta de [user:name] en [site:name]\";s:57:\"Account details for [user:name] at [site:name] (canceled)\";s:63:\"Detalles de la cuenta de [user:name] en [site:name] (cancelada)\";s:33:\"Cancel the selected user accounts\";s:45:\"Cancelar las cuentas de usuario seleccionadas\";s:31:\"To make your password stronger:\";s:34:\"Para que su clave sea más segura:\";s:29:\"Make it at least 6 characters\";s:32:\"Debe tener al menos 6 caracteres\";s:21:\"Add lowercase letters\";s:26:\"Añadir letras minúsculas\";s:21:\"Add uppercase letters\";s:26:\"Añadir letras mayúsculas\";s:11:\"Add numbers\";s:16:\"Añadir números\";s:15:\"Add punctuation\";s:29:\"Añadir signos de puntuación\";s:36:\"Make it different from your username\";s:42:\"Debe ser diferente de su nombre de usuario\";s:4:\"Weak\";s:6:\"Débil\";s:4:\"Fair\";s:9:\"Razonable\";s:65:\"A simple one-column, tableless, fluid width administration theme.\";s:82:\"Un tema visual para admistración de una columna, sin tablas, de anchura variable.\";s:11:\"Image style\";s:16:\"Estilo de imagen\";s:16:\"Author textfield\";s:28:\"Campo de texto para el autor\";s:17:\"Subject textfield\";s:21:\"Campo de texto asunto\";s:25:\"Error messages to display\";s:38:\"Mensajes de error que se deben mostrar\";s:19:\"Term name textfield\";s:38:\"Campo de texto del nombre del término\";s:25:\"Term description textarea\";s:46:\"Área de texto de la descripción del término\";s:71:\"Enter your current password to change the %mail or %pass. !request_new.\";s:73:\"Escriba su contraseña actual para modificar %mail o %pass. !request_new.\";s:16:\"Current password\";s:18:\"Contraseña actual\";s:25:\"%module module installed.\";s:26:\"Módulo %module instalado.\";s:43:\"Use this page to create a new custom block.\";s:58:\"Use esta página para crear un nuevo bloque personalizado.\";s:71:\"The new set is created by copying items from your default shortcut set.\";s:88:\"El nuevo conjunto se creará copiando elementos de su conjunto predeterminado de atajos.\";s:13:\"Edit set name\";s:25:\"Editar nombre de conjunto\";s:16:\"Database support\";s:31:\"Funcionalidad de bases de datos\";s:8:\"On value\";s:19:\"Valor para activado\";s:32:\"If left empty, \"1\" will be used.\";s:40:\"Si lo deja en blanco, se utilizará \"1\".\";s:9:\"Off value\";s:22:\"Valor para desactivado\";s:32:\"If left empty, \"0\" will be used.\";s:40:\"Si lo deja en blanco, se utilizará \"0\".\";s:23:\"@name <em>(locked)</em>\";s:26:\"@name <em>(bloqueado)</em>\";s:48:\"A flexible, recolorable theme with many regions.\";s:77:\"Un tema flexible con muchas regiones al que se le pueden cambiar los colores.\";s:60:\"No URL aliases available. <a href=\"@link\">Add URL alias</a>.\";s:65:\"No hay de alias de URL. <a href=\"@link\">Agregar alias de URL</a>.\";s:12:\"Site details\";s:18:\"Detalles del sitio\";s:20:\"Weight for new field\";s:20:\"Peso del nuevo campo\";s:22:\"Weight for added field\";s:23:\"Peso del campo agregado\";s:23:\"Custom display settings\";s:39:\"Opciones de presentación personalizada\";s:56:\"Use custom display settings for the following view modes\";s:84:\"Usar las opciones de presentación personalizada para los siguientes modos de vistas\";s:39:\"Edit an existing effect within a style.\";s:47:\"Editar un efecto existente dentro de un estilo.\";s:19:\"Node module element\";s:25:\"Elemento del módulo Node\";s:21:\"None (original image)\";s:25:\"Ninguno (imagen original)\";s:14:\"New field name\";s:21:\"Nombre de campo nuevo\";s:29:\"Database log messages to keep\";s:51:\"Mensajes de registro de la base de datos a mantener\";s:18:\"- Select a value -\";s:23:\"- Seleccione un valor -\";s:22:\"No field is displayed.\";s:28:\"No se muestra ningún campo.\";s:19:\"No field is hidden.\";s:28:\"No hay ningún campo oculto.\";s:16:\"Format settings:\";s:20:\"Opciones de formato:\";s:13:\"Link image to\";s:17:\"Vincular imagen a\";s:19:\"Image style: @style\";s:24:\"Estilo de imagen: @style\";s:17:\"Linked to content\";s:21:\"Vinculado a contenido\";s:14:\"Linked to file\";s:19:\"Vinculado a archivo\";s:39:\"Shown when hovering over the menu link.\";s:64:\"Mostrar cuando se pase el cursor por encima del enlace de menú.\";s:66:\"Choose which search modules are active from the available modules.\";s:79:\"Elegir qué módulos de búsqueda están activados de los módulos disponibles.\";s:21:\"Default search module\";s:35:\"Módulo de búsqueda predeterminado\";s:42:\"Choose which search module is the default.\";s:54:\"Eligir qué módulo de búsqueda es el predeterminado.\";s:11:\"Error pages\";s:17:\"Páginas de error\";s:25:\"Last run: %cron-last ago.\";s:35:\"Última ejecución hace %cron-last.\";s:14:\"Run cron every\";s:18:\"ejecutar cron cada\";s:21:\"Weight for added term\";s:26:\"Peso del término agregado\";s:59:\"Pictures larger than this will be scaled down to this size.\";s:56:\"Las imágenes que excedan este tamaño serán reducidas.\";s:23:\"Weight for @block block\";s:22:\"Peso del bloque @block\";s:23:\"Region for @block block\";s:25:\"Región del bloque @block\";s:29:\"and where %property is %value\";s:27:\"y donde %property es %value\";s:25:\"where %property is %value\";s:25:\"donde %property es %value\";s:9:\"and where\";s:7:\"y donde\";s:7:\"Nothing\";s:4:\"Nada\";s:51:\"%type: !message in %function (line %line of %file).\";s:53:\"%type: !message en %function (línea %line de %file).\";s:63:\"The machine-readable name is already in use. It must be unique.\";s:53:\"El nombre de sistema ya está en uso. Debe ser único\";s:22:\"Weight for row @number\";s:25:\"Peso para la fila @number\";s:17:\"Parent for @title\";s:15:\"Padre de @title\";s:15:\"New field label\";s:24:\"Etiqueta del nuevo campo\";s:20:\"Parent for new field\";s:21:\"Padre del nuevo campo\";s:17:\"Type of new field\";s:19:\"Tipo de campo nuevo\";s:20:\"Widget for new field\";s:24:\"Control para campo nuevo\";s:20:\"Existing field label\";s:29:\"Etiqueta para campo existente\";s:25:\"Parent for existing field\";s:25:\"Padre del campo existente\";s:23:\"Existing field to share\";s:30:\"Campo existente para compartir\";s:25:\"Widget for existing field\";s:28:\"Control para campo existente\";s:24:\"Label display for @title\";s:35:\"Presentación de etiqueta de @title\";s:20:\"Formatter for @title\";s:23:\"Formateador para @title\";s:18:\"Parents for @title\";s:16:\"Padres de @title\";s:21:\"Visibility for @title\";s:23:\"Visibilidad para @title\";s:19:\"Weight for new file\";s:22:\"Peso del nuevo archivo\";s:13:\"Choose a file\";s:16:\"Elija un archivo\";s:21:\"Weight for new effect\";s:22:\"Peso para nuevo efecto\";s:23:\"Enable @title menu link\";b:1;s:14:\"Active modules\";s:16:\"Módulos activos\";s:22:\"!theme (default theme)\";s:28:\"!theme (tema predeterminado)\";s:26:\"No fields are present yet.\";s:27:\"No existen campos todavía.\";s:61:\"Read more<span class=\"element-invisible\"> about @title</span>\";s:61:\"Leer más<span class=\"element-invisible\"> sobre @title</span>\";s:24:\"Uninstall @module module\";s:27:\"Desinstalar módulo @module\";s:32:\"Release notes for @project_title\";s:40:\"Notas de la versión para @project_title\";s:41:\"Disable the account and keep its content.\";s:45:\"Desactivar la cuenta y mantener su contenido.\";s:46:\"Disable the account and unpublish its content.\";s:63:\"Desactivar la cuenta y retirar de la publicación su contenido.\";s:35:\"Delete the account and its content.\";s:35:\"Eliminar la cuenta  y su contenido.\";s:50:\"Use field label instead of the \"On value\" as label\";s:65:\"Utilizar etiqueta de campo en lugar de «En valor» como etiqueta\";s:11:\"Center left\";s:16:\"Centro izquierda\";s:12:\"Center right\";s:14:\"Centro derecha\";s:37:\"Changes to the style have been saved.\";s:41:\"Los cambios al estilo han sido guardados.\";s:8:\"Curaçao\";s:7:\"Curazao\";s:12:\"Sint Maarten\";s:12:\"Sint Maarten\";s:46:\"The requested page \"@path\" could not be found.\";s:56:\"La página \"@path\" solicitada no se ha podido encontrar.\";s:21:\"Active search modules\";s:29:\"Módulos de búsqueda activos\";s:59:\"No shortcuts available. <a href=\"@link\">Add a shortcut</a>.\";s:64:\"No hay atajos disponibles. <a href=\"@link\">Añadir un atajo</a>.\";s:22:\"User name and password\";s:31:\"Nombre de usuario y contraseña\";s:34:\"User module account form elements.\";s:52:\"Elementos de formulario en cuentas del módulo User.\";s:51:\"There was a problem creating field %label: !message\";s:56:\"Ha habido un problema al crear el campo %label: !message\";s:24:\"Subscribe to !feed-title\";s:25:\"Suscribirse a !feed-title\";s:27:\"Table @name already exists.\";s:25:\"La table @name ya existe.\";s:11:\"South Sudan\";s:13:\"Sur de Sudán\";s:19:\"Not fully protected\";s:32:\"No está completamente protegido\";s:9:\"Influence\";s:10:\"Influencia\";s:11:\"Binary Data\";s:14:\"Datos Binarios\";s:21:\"Caribbean Netherlands\";s:20:\"Antillas Holandesas.\";s:34:\"Demonstrate block regions (!theme)\";s:38:\"Demostrar regiones de bloques (!theme)\";s:30:\"Microsoft Office document icon\";s:38:\"Icono de documento de Microsoft Office\";s:23:\"Office spreadsheet icon\";s:38:\"Icono de la hoja de cálculo de Office\";s:24:\"Office presentation icon\";s:35:\"Icono de la presentación de Office\";s:8:\"PDF icon\";s:9:\"Icono PDF\";s:10:\"Movie icon\";s:15:\"Icono película\";s:10:\"Audio icon\";s:14:\"Icono de Audio\";s:10:\"Image icon\";s:15:\"Icono de Imagen\";s:12:\"Package icon\";s:16:\"Icono de paquete\";s:9:\"HTML icon\";s:10:\"Icono HTML\";s:15:\"Plain text icon\";s:20:\"Icono de texto plano\";s:13:\"Trimmed limit\";s:17:\"Límite recortado\";s:6:\"Google\";s:6:\"Google\";s:6:\"jQuery\";s:6:\"jQuery\";s:9:\"Microsoft\";s:9:\"Microsoft\";s:24:\"jQuery compression level\";s:30:\"Nivel de compresión de jQuery\";s:21:\"Production (minified)\";s:22:\"Producción (minified)\";s:26:\"Development (uncompressed)\";s:26:\"Desarrollo (sin comprimir)\";s:24:\"jQuery and jQuery UI CDN\";s:22:\"jQuery y jQuery UI CDN\";s:9:\"Libraries\";s:11:\"Bibliotecas\";s:40:\"The %library library could not be found.\";s:38:\"No se encontró la librería %library.\";s:1:\"=\";s:1:\"=\";s:9:\"Validator\";s:9:\"Validador\";s:9:\"Is one of\";s:9:\"Es uno de\";s:20:\"- Basic validation -\";s:23:\"- Validación básica -\";s:11:\"Link Target\";s:18:\"Destino del Enlace\";s:14:\"Optional Title\";s:16:\"Título opcional\";s:14:\"Required Title\";s:19:\"Título obligatorio\";s:8:\"No Title\";s:11:\"Sin título\";s:10:\"Link Title\";s:18:\"Título del enlace\";s:29:\"Default (no target attribute)\";s:37:\"Por defecto (sin atributo de destino)\";s:24:\"Open link in window root\";s:29:\"Abrir enlace en ventana raíz\";s:23:\"Open link in new window\";s:29:\"Abrir enlace en ventana nueva\";s:24:\"Allow the user to choose\";s:26:\"Permitir elegir al usuario\";s:20:\"Additional CSS Class\";s:19:\"Clase CSS Adicional\";s:12:\"Optional URL\";s:12:\"URL opcional\";s:25:\"Allow user-entered tokens\";s:46:\"Permiten símbolos introducidos por el usuario\";s:13:\"Rel Attribute\";s:12:\"Atributo rel\";s:12:\"Validate URL\";s:11:\"Validar URL\";s:12:\"Static Title\";s:17:\"Título estático\";s:12:\"Static title\";s:17:\"Título estático\";s:48:\"Allow the user to enter a link \'title\' attribute\";s:59:\"Permite al usuario introducir un atributo \'title\' de enlace\";s:30:\"Default link \'title\' Attribute\";s:42:\"Atributo \'title\' predeterminado del enlace\";s:25:\"Max length of title field\";s:34:\"Máxima longitud del campo título\";s:44:\"Keep rel as set up above (untouched/default)\";s:70:\"Mantener rel tal como está establecido arriba (sin tocar/por defecto)\";s:36:\"Remove rel if given link is external\";s:36:\"Eliminar rel si el enlace es externo\";s:36:\"Remove rel if given link is internal\";s:48:\"Quitar rel si el enlace proporcionado es interno\";s:59:\"The link title is limited to @maxlength characters maximum.\";s:75:\"El título del enlace está limitado a un máximo de @maxlength caracteres.\";s:34:\"Remove rel attribute automatically\";s:41:\"Eliminar el atributo rel automáticamente\";s:58:\"If checked, the URL will always render as an absolute URL.\";s:61:\"Si se marca, la URL siempre se presentará como URL absoluta.\";s:50:\"If this is checked the field label will be hidden.\";s:61:\"Si se marca esta opción, se ocultará la etiqueta del campo.\";s:52:\"Allow the user to enter a custom link class per link\";s:83:\"Permitir que el usuario introduzca una clase de enlace personalizada en cada enlace\";s:15:\"Security update\";s:27:\"Actualización de seguridad\";s:9:\"Separator\";s:9:\"Separador\";s:33:\"Pattern for all %vocab-name paths\";s:40:\"Patrón para todas las rutas %vocab-name\";s:7:\"Verbose\";s:9:\"Detallado\";s:20:\"Maximum alias length\";s:25:\"Longitud máxima de alias\";s:24:\"Maximum component length\";s:31:\"Longitud máxima de componentes\";s:13:\"Update action\";s:25:\"Acción de actualización\";s:17:\"Strings to Remove\";s:16:\"Texto a eliminar\";s:19:\"administer pathauto\";s:39:\"Administrar alias automáticos de rutas\";s:20:\"Replacement patterns\";s:21:\"Patrones de reemplazo\";s:6:\"Period\";s:8:\"Período\";s:20:\"Change to lower case\";s:21:\"Cambiar a minúsculas\";s:39:\"Do nothing. Leave the old alias intact.\";s:47:\"No hacer nada. Dejar intacto el alias anterior.\";s:57:\"Create a new alias. Leave the existing alias functioning.\";s:56:\"Crear un alias nuevo. Dejar el alias anterior operativo.\";s:41:\"Create a new alias. Delete the old alias.\";s:49:\"Crear un alias nuevo. Eliminar el alias anterior.\";s:37:\"Transliterate prior to creating alias\";s:45:\"Transliterar antes de crear los alias de URLs\";s:28:\"Generate automatic URL alias\";s:33:\"Generar alias de URL automáticos\";s:44:\"Uncheck this to create a custom alias below.\";s:64:\"Desmarcar esta opción para crear un alias personalizado debajo.\";s:29:\"Configure URL alias patterns.\";s:37:\"Configurar patrones de alias de URLs.\";s:35:\"Pattern for user account page paths\";s:49:\"Patrón para las rutas de las cuentas de usuarios\";s:51:\"Display alias changes (except during bulk updates).\";s:76:\"Mostrar todos los cambios de alias (excepto en las actualizaciones masivas).\";s:20:\"Replace by separator\";s:27:\"Reemplazar por el separador\";s:8:\"Asterisk\";s:9:\"Asterisco\";s:32:\"Pattern for all @node_type paths\";s:37:\"Patrón de todas las rutas @node_type\";s:14:\"Character case\";s:25:\"Mayúsculas / Minúsculas\";s:43:\"Leave case the same as source token values.\";s:56:\"Respetar mayúsculas y minúsculas de la fuente original\";s:26:\"No action (do not replace)\";s:28:\"No hacer nada (no remplazar)\";s:22:\"notify of path changes\";s:26:\"Avisar de cambios de rutas\";s:5:\"Colon\";s:10:\"Dos puntos\";s:9:\"Semicolon\";s:12:\"Punto y coma\";s:5:\"Slash\";s:5:\"Barra\";s:11:\"Punctuation\";s:11:\"Puntuación\";s:37:\"Reduce strings to letters and numbers\";s:35:\"Reducir cadenas a letras y números\";s:16:\"language neutral\";s:19:\"Sin idioma definido\";s:42:\"Pattern for all @language @node_type paths\";s:49:\"Patrón para todas las rutas @language @node_type\";s:19:\"Taxonomy term paths\";s:32:\"Rutas de términos de taxonomía\";s:10:\"User paths\";s:16:\"Rutas de usuario\";s:13:\"Content paths\";s:18:\"Rutas de contenido\";s:10:\"Underscore\";s:11:\"Guión bajo\";s:25:\"Path module form elements\";s:40:\"Elementos de formulario del módulo Path\";s:22:\"Double quotation marks\";s:15:\"Comillas dobles\";s:35:\"Single quotation marks (apostrophe)\";s:29:\"Comillas simples (apóstrofo)\";s:9:\"Back tick\";s:12:\"Acento grave\";s:6:\"Hyphen\";s:6:\"Guión\";s:19:\"Vertical bar (pipe)\";s:14:\"Barra vertical\";s:18:\"Left curly bracket\";s:15:\"Llave izquierda\";s:19:\"Left square bracket\";s:18:\"Corchete izquierdo\";s:19:\"Right curly bracket\";s:13:\"Llave derecha\";s:20:\"Right square bracket\";s:16:\"Corchete derecho\";s:9:\"Plus sign\";s:10:\"Signo más\";s:10:\"Equal sign\";s:11:\"Signo igual\";s:12:\"Percent sign\";s:19:\"Signo de porcentaje\";s:5:\"Caret\";s:18:\"Acento circunflejo\";s:11:\"Dollar sign\";s:16:\"Signo del dólar\";s:30:\"Number sign (pound sign, hash)\";s:49:\"Símbolo numérico (Libra Esterlina, almohadilla)\";s:7:\"At sign\";s:6:\"Arroba\";s:16:\"Exclamation mark\";s:21:\"Signo de exclamación\";s:5:\"Tilde\";s:5:\"Tilde\";s:16:\"Left parenthesis\";s:21:\"Paréntesis izquierdo\";s:17:\"Right parenthesis\";s:19:\"Paréntesis derecho\";s:13:\"Question mark\";s:26:\"Símbolo de interrogación\";s:14:\"Less-than sign\";s:18:\"Símbolo menor que\";s:17:\"Greater-than sign\";s:18:\"Símbolo mayor que\";s:9:\"Backslash\";s:15:\"Barra invertida\";s:8:\"settings\";s:14:\"configuración\";s:14:\"User Interface\";s:19:\"Interfaz de usuario\";s:16:\"General Settings\";s:22:\"Configuración General\";s:3:\"CSS\";s:3:\"CSS\";s:14:\"System default\";s:32:\"Valor predeterminado del sistema\";s:6:\"Target\";s:7:\"Destino\";s:32:\"Provide all themes for selection\";s:41:\"Permitir la selección de todos los temas\";s:73:\"Make all installed themes available for selection, not enabled ones only.\";s:120:\"Hacer que todos los temas instalados en Drupal estén disponibles para su selección, no sólo los que estén activados.\";s:41:\"Retain the theme until a new theme is set\";s:51:\"Conservar el tema hasta que se establezca uno nuevo\";s:9:\"New Rule:\";s:12:\"Regla nueva:\";s:9:\"tutorials\";s:10:\"tutoriales\";s:38:\"Property drupal:path is case sensitive\";s:61:\"La propiedad drupal:ruta distingue mayúsculas de minúsculas\";s:25:\"Cron cleans up page cache\";s:33:\"Cron limpia el caché de páginas\";s:15:\"Page<br />Cache\";s:19:\"Caché<br />de pag.\";s:5:\"Token\";s:8:\"Comodín\";s:62:\"Click a token to insert it into the field you\'ve last clicked.\";s:78:\"Haga clic en un token para insertarlo en el último campo que ha seleccionado.\";s:51:\"List of the currently available tokens on this site\";s:53:\"Lista de tokens disponibles actualmente en este sitio\";s:74:\"The %element-title is using the following invalid tokens: @invalid-tokens.\";s:88:\"El %element-title está utilizando los siguientes comodines inválidos: @invalid-tokens.\";s:33:\"A date in \'@type\' format. (%date)\";s:37:\"Una fecha en formato \'@type\'. (%date)\";s:22:\"Also known as %labels.\";s:26:\"También llamados %labels.\";s:19:\"No tokens available\";s:28:\"No hay comodines disponibles\";s:27:\"This field supports tokens.\";s:28:\"Este campo admite comodines.\";s:24:\"Browse available tokens.\";s:28:\"Ojear comodines disponibles.\";s:18:\"Original file name\";s:27:\"Nombre del archivo original\";s:13:\"Transliterate\";s:12:\"Transliterar\";s:59:\"Are you sure you want to transliterate existing file names?\";s:72:\"¿Está seguro que desea transliterar los nombres de archivo existentes?\";s:24:\"Transliterated file name\";s:32:\"Nombre del archivo transliterado\";s:74:\"The database currently lists @x_filenames containing non-ASCII characters.\";s:83:\"Las listas actuales de la base de datos @x_filenames contienen caracteres no ASCII.\";s:48:\"Transliterate search index and searched strings.\";s:60:\"Transliterar el índice de búsqueda y las cadenas buscadas.\";s:34:\"Convert all characters to US-ASCII\";s:41:\"Convertir todos los caracteres a US-ASCII\";s:60:\"Placeholder for characters with no known US-ASCII equivalent\";s:86:\"Marcador de posición para los caracteres que no tienen equivalente US-ASCII conocido.\";s:2:\"On\";s:8:\"Activado\";s:3:\"For\";s:4:\"Para\";s:3:\"Tag\";s:8:\"Etiqueta\";s:9:\"Use count\";s:14:\"Conteo de usos\";s:14:\"Block settings\";s:18:\"Opciones de Bloque\";s:5:\"Depth\";s:11:\"Profundidad\";s:7:\"Node ID\";s:11:\"ID del nodo\";s:7:\"Add new\";s:13:\"Agregar nuevo\";s:6:\"Access\";s:6:\"Acceso\";s:4:\"GUID\";s:4:\"GUID\";s:2:\"ID\";s:2:\"ID\";s:4:\"Mail\";s:6:\"Correo\";s:8:\"Promoted\";s:9:\"Promovido\";s:17:\"Number of columns\";s:19:\"Número de columnas\";s:7:\"Exclude\";s:7:\"Excluir\";s:10:\"Horizontal\";s:10:\"Horizontal\";s:8:\"Vertical\";s:8:\"Vertical\";s:4:\"term\";s:8:\"término\";s:14:\"Override title\";s:20:\"Sobrescribir título\";s:9:\"CSS class\";s:9:\"Clase CSS\";s:6:\"Module\";s:7:\"Módulo\";s:3:\"Off\";s:11:\"Desactivado\";s:5:\"Score\";s:11:\"Puntuación\";s:11:\"Log message\";s:19:\"Mensaje de registro\";s:8:\"Contains\";s:8:\"Contiene\";s:12:\"Is less than\";s:12:\"Es menor que\";s:24:\"Is less than or equal to\";s:20:\"Es menor o igual que\";s:11:\"Is equal to\";s:10:\"Es igual a\";s:27:\"Is greater than or equal to\";s:20:\"Es mayor o igual que\";s:15:\"Is greater than\";s:12:\"Es mayor que\";s:15:\"Is not equal to\";s:13:\"No es igual a\";s:7:\"Average\";s:8:\"Promedio\";s:6:\"Normal\";s:6:\"Normal\";s:10:\"Sort order\";s:22:\"Método de ordenación\";s:7:\"Current\";s:6:\"Actual\";s:2:\"OR\";s:1:\"O\";s:5:\"Align\";s:7:\"Alinear\";s:9:\"List type\";s:13:\"Tipo de lista\";s:10:\"Select all\";s:16:\"Seleccionar todo\";s:9:\"Link text\";s:16:\"Texto del enlace\";s:4:\"Case\";s:23:\"Mayúsculas/minúsculas\";s:9:\"Edit view\";s:12:\"Editar vista\";s:9:\"Ascending\";s:10:\"Ascendente\";s:10:\"Descending\";s:11:\"Descendente\";s:8:\"Operator\";s:8:\"Operador\";s:7:\"Filters\";s:7:\"Filtros\";s:13:\"Uncategorized\";s:15:\"Sin categorizar\";s:8:\"Position\";s:9:\"Posición\";s:13:\"with comments\";s:15:\"con comentarios\";s:16:\"without comments\";s:15:\"sin comentarios\";s:12:\"Updated date\";s:23:\"Fecha de actualización\";s:18:\"Regular expression\";s:18:\"Expresión regular\";s:8:\"Approved\";s:8:\"Aprobado\";s:2:\"in\";s:2:\"en\";s:8:\"Messages\";s:8:\"Mensajes\";s:6:\"Source\";s:6:\"Origen\";s:12:\"Display name\";s:16:\"Nombre a mostrar\";s:5:\"Query\";s:8:\"Consulta\";s:10:\"Block name\";s:17:\"Nombre del bloque\";s:4:\"Hour\";s:4:\"Hora\";s:6:\"Minute\";s:6:\"Minuto\";s:6:\"Second\";s:7:\"Segundo\";s:11:\"Granularity\";s:16:\"Nivel de detalle\";s:9:\"Alignment\";s:11:\"Alineación\";s:6:\"author\";s:5:\"autor\";s:3:\"AND\";s:1:\"Y\";s:4:\"Left\";s:9:\"Izquierda\";s:5:\"Right\";s:7:\"Derecha\";s:2:\"or\";s:1:\"o\";s:8:\"All tags\";s:19:\"Todas las etiquetas\";s:7:\"Reverse\";s:8:\"Revertir\";s:6:\"Plural\";s:6:\"Plural\";s:12:\"Oldest first\";s:23:\"El más antiguo primero\";s:9:\"Base path\";s:9:\"Ruta base\";s:2:\"Ok\";s:2:\"Ok\";s:7:\"Storage\";s:14:\"Almacenamiento\";s:11:\"Information\";s:12:\"Información\";s:11:\"Translation\";s:11:\"Traducción\";s:18:\"Translation status\";s:21:\"Estado de traducción\";s:9:\"Text area\";s:14:\"Área de texto\";s:10:\"Exceptions\";s:11:\"Excepciones\";s:6:\"Thread\";s:6:\"Cadena\";s:10:\"Title text\";s:17:\"Texto del título\";s:8:\"Distinct\";s:9:\"Único(s)\";s:9:\"Rearrange\";s:9:\"Reordenar\";s:5:\"empty\";s:6:\"vacío\";s:9:\"All types\";s:15:\"Todos los tipos\";s:11:\"Cancel link\";s:20:\"Enlace para cancelar\";s:5:\"Pager\";s:9:\"Paginador\";s:10:\"Identifier\";s:13:\"Identificador\";s:16:\"Remove this item\";s:22:\"Eliminar este elemento\";s:13:\"Page settings\";s:19:\"Opciones de página\";s:9:\"Use pager\";s:14:\"Usar paginador\";s:16:\"Items to display\";s:21:\"Elementos que mostrar\";s:9:\"More link\";s:16:\"Enlace \'más...\'\";s:14:\"More link text\";s:26:\"Texto del enlace \'más...\'\";s:8:\"contains\";s:8:\"contiene\";s:4:\"Data\";s:5:\"Datos\";s:12:\"Ordered list\";s:14:\"Lista ordenada\";s:14:\"Unordered list\";s:17:\"Lista sin ordenar\";s:10:\"Link class\";s:16:\"Clase del enlace\";s:5:\"regex\";s:5:\"regex\";s:3:\"and\";s:1:\"y\";s:9:\"Add @type\";s:13:\"Añadir @type\";s:12:\"Not promoted\";s:32:\"No colocado en página principal\";s:10:\"Not sticky\";s:31:\"No fijo en cabeza de las listas\";s:3:\"Nid\";s:3:\"Nid\";s:14:\"Parent comment\";s:16:\"Comentario padre\";s:19:\"The parent comment.\";s:20:\"El comentario padre.\";s:16:\"Author\'s website\";s:19:\"Sitio web del autor\";s:51:\"Display the depth of the comment if it is threaded.\";s:55:\"Muestra la profundidad del comentario si va encadenado.\";s:13:\"Reply-to link\";s:21:\"Enlace de \"Responder\"\";s:46:\"Provide a simple link to reply to the comment.\";s:59:\"Proporciona un enlace directo para contestar al comentario.\";s:15:\"Text to display\";s:18:\"Texto para mostrar\";s:12:\"Newest first\";s:24:\"El más reciente primero\";s:5:\"nodes\";s:5:\"nodos\";s:9:\"Formatter\";s:11:\"Formateador\";s:8:\"Time ago\";s:7:\"Hace...\";s:26:\"The taxonomy vocabulary ID\";s:35:\"El ID del vocabulario de taxonomía\";s:20:\"starting from @count\";s:22:\"empezando desde @count\";s:31:\"The language the content is in.\";s:39:\"El idioma en el que está el contenido.\";s:11:\"Entity type\";s:15:\"Tipo de entidad\";s:10:\"User roles\";s:16:\"Roles de usuario\";s:14:\"More link path\";s:17:\"Enlace \"Ver más\"\";s:11:\"Button text\";s:16:\"Texto del botón\";s:9:\"Mime type\";s:9:\"Tipo MIME\";s:14:\"Display format\";s:24:\"Formato de presentación\";s:35:\"The date the node was last updated.\";s:57:\"La fecha en la que el nodo se actualizó por última vez.\";s:14:\"!group: !field\";s:14:\"!group: !field\";s:12:\"Display type\";s:21:\"Tipo de presentación\";s:13:\"Is not one of\";s:12:\"No es uno de\";s:39:\"Comments are responses to node content.\";s:57:\"Los comentarios son respuestas al contenido de los nodos.\";s:45:\"Users who have created accounts on your site.\";s:61:\"Usuarios que se han registrado y tienen cuenta en este sitio.\";s:14:\"!group: !title\";s:14:\"!group: !title\";s:2:\"!=\";s:2:\"!=\";s:15:\"Is empty (NULL)\";s:19:\"Está vacío (NULL)\";s:9:\"not empty\";s:9:\"no vacío\";s:19:\"Theming information\";s:27:\"Información de tema visual\";s:11:\"Upload date\";s:27:\"Fecha de subida al servidor\";s:12:\"Do not cache\";s:18:\"No poner en caché\";s:7:\"No role\";s:7:\"Sin rol\";s:9:\"View link\";s:15:\"Enlace de vista\";s:11:\"Delete link\";s:17:\"Enlace de borrado\";s:48:\"Filter the view to the currently logged in user.\";s:53:\"Filtrar la vista al usuario actualmente identificado.\";s:34:\"Cache once for everything (global)\";s:51:\"Poner en caché de una sóla vez para todo (global)\";s:8:\"Per page\";s:11:\"Por página\";s:8:\"Per role\";s:7:\"Por rol\";s:17:\"Per role per page\";s:21:\"Por rol y por página\";s:8:\"Per user\";s:11:\"Por usuario\";s:17:\"Per user per page\";s:25:\"Por usuario y por página\";s:10:\"Has Avatar\";s:12:\"Tiene avatar\";s:23:\"Capitalize first letter\";s:36:\"Poner la primera letra en mayúscula\";s:3:\"Uid\";s:3:\"Uid\";s:11:\"Custom text\";s:19:\"Texto personalizado\";s:3:\"Sum\";s:4:\"Suma\";s:9:\"sorted by\";s:12:\"ordenado por\";s:12:\"Not Approved\";s:9:\"Rechazado\";s:9:\"Edit link\";s:18:\"Enlace de edición\";s:18:\"Submit button text\";s:26:\"Texto del botón de envío\";s:16:\"Add comment link\";s:28:\"Añadir enlace de comentario\";s:45:\"Do not display items with no value in summary\";s:44:\"No mostrar elementos sin valor en el resumen\";s:13:\"Glossary mode\";s:13:\"Modo glosario\";s:15:\"Character limit\";s:21:\"Límite de caracteres\";s:12:\"No transform\";s:14:\"No transformar\";s:10:\"Upper case\";s:11:\"Mayúsculas\";s:10:\"Lower case\";s:11:\"Minúsculas\";s:20:\"Capitalize each word\";s:58:\"Poner en mayúscula la primera letra de todas las palabras\";s:12:\"Case in path\";s:34:\"Mayúsculas/Minúsculas en la ruta\";s:33:\"Transform spaces to dashes in URL\";s:41:\"Transformar espacios en guiones en la URL\";s:20:\"Exclude from display\";s:27:\"Excluir de la presentación\";s:32:\"Rewrite the output of this field\";s:33:\"Rescribir la salida de este campo\";s:27:\"Output this field as a link\";s:31:\"Producir este campo como enlace\";s:9:\"Link path\";s:15:\"Ruta del enlace\";s:35:\"The CSS class to apply to the link.\";s:40:\"La clase CSS que se aplicará al enlace.\";s:11:\"Prefix text\";s:13:\"Texto prefijo\";s:59:\"Any text to display before this link. You may include HTML.\";s:75:\"Cualquier texto que se quiera poner delante del enlace. Puede incluir HTML.\";s:11:\"Suffix text\";s:12:\"Texto sufijo\";s:58:\"Any text to display after this link. You may include HTML.\";s:76:\"Cualquier texto que se quiera poner después del enlace. Puede incluir HTML.\";s:35:\"Trim this field to a maximum length\";s:42:\"Recortar este campo a una longitud máxima\";s:28:\"Trim only on a word boundary\";s:29:\"Recortar sólo entre palabras\";s:15:\"Add an ellipsis\";s:26:\"Añadir puntos suspensivos\";s:57:\"If checked, a \"...\" will be added if a field was trimmed.\";s:58:\"si se marca, se añadirá un \"...\" si se recorta el campo.\";s:15:\"Strip HTML tags\";s:23:\"Eliminar etiquetas HTML\";s:43:\"If checked, all HTML tags will be stripped.\";s:53:\"Si se marca, todas las etiquetas HTML se eliminarán.\";s:22:\"Field can contain HTML\";s:28:\"El campo puede contener HTML\";s:16:\"Simple separator\";s:16:\"Separador simple\";s:7:\"- Any -\";s:14:\"- Cualquiera -\";s:10:\"Value type\";s:14:\"Tipo del valor\";s:6:\"not in\";s:5:\"no en\";s:2:\"<>\";s:2:\"<>\";s:9:\"Is all of\";s:18:\"Es la totalidad de\";s:10:\"Is none of\";s:12:\"No es uno de\";s:3:\"not\";s:2:\"no\";s:1:\"<\";s:1:\"<\";s:2:\"<=\";s:2:\"<=\";s:2:\">=\";s:2:\">=\";s:1:\">\";s:1:\">\";s:10:\"Is between\";s:11:\"Está entre\";s:7:\"between\";s:5:\"entre\";s:14:\"Is not between\";s:14:\"No está entre\";s:11:\"not between\";s:8:\"no entre\";s:3:\"And\";s:1:\"Y\";s:25:\"Require this relationship\";s:21:\"Exigir esta relación\";s:3:\"asc\";s:3:\"asc\";s:4:\"desc\";s:4:\"desc\";s:8:\"Displays\";s:14:\"Presentaciones\";s:25:\"This display has no path.\";s:33:\"Esta presentación no tiene ruta.\";s:16:\"No query was run\";s:23:\"No se realizó consulta\";s:9:\"View name\";s:18:\"Nombre de la vista\";s:16:\"View description\";s:21:\"Descripción de vista\";s:8:\"View tag\";s:17:\"Etiqueta de vista\";s:20:\"Paste view code here\";s:34:\"Pegue aquí el código de la vista\";s:38:\"Style plugin @plugin is not available.\";s:52:\"La extensión de estilo @plugin no está disponible.\";s:22:\"Unable to import view.\";s:29:\"No se pudo importar la vista.\";s:45:\"Click on an item to edit that item\'s details.\";s:50:\"Haga clic en un elemento para editar sus detalles.\";s:36:\"Go to the real page for this display\";s:47:\"Ir a la verdadera página de esta presentación\";s:30:\"Change settings for this style\";b:1;s:15:\"Rearrange @type\";s:18:\"Redistribuir @type\";s:56:\"Show other queries run during render during live preview\";s:72:\"Mostrar otras consultas ejecutadas mientras se preparaba la vista previa\";s:25:\"Error: missing @component\";s:23:\"Error: Falta @component\";s:27:\"The comment ID of the field\";s:29:\"El ID de comentario del campo\";s:42:\"Provide a simple link to view the comment.\";s:53:\"Proporciona un enlace directo para ver el comentario.\";s:42:\"Provide a simple link to edit the comment.\";s:56:\"Proporciona un enlace directo para editar el comentario.\";s:44:\"Provide a simple link to delete the comment.\";s:56:\"Proporciona un enlace directo para borrar el comentatio.\";s:36:\"The User ID of the comment\'s author.\";s:42:\"El ID de usuario del autor del comentario.\";s:10:\"Parent CID\";s:9:\"CID padre\";s:37:\"The Comment ID of the parent comment.\";s:41:\"El ID de comentario del comentario padre.\";s:17:\"Last comment time\";s:27:\"Hora del último comentario\";s:50:\"Date and time of when the last comment was posted.\";s:55:\"Fecha y hora de la publicación del último comentario.\";s:19:\"Last comment author\";s:28:\"Autor del último comentario\";s:50:\"The name of the author of the last posted comment.\";s:53:\"El nombre del autor del último comentario publicado.\";s:34:\"The number of comments a node has.\";s:44:\"El número de comentarios que tiene un nodo.\";s:39:\"The number of new comments on the node.\";s:44:\"El número de nuevos comentarios en el nodo.\";s:14:\"Comment status\";s:21:\"Estado del comentario\";s:53:\"Whether comments are enabled or disabled on the node.\";s:53:\"Si los comentarios están permitidos o no en el nodo.\";s:24:\"User posted or commented\";s:37:\"Enviados por los usuarios o comentado\";s:70:\"Display nodes only if a user posted the node or commented on the node.\";s:72:\"Muestra los nodos sólamente si un usuario envío el nodo o lo comentó.\";s:13:\"Locale source\";s:26:\"Origen de regionalización\";s:3:\"LID\";s:3:\"LID\";s:32:\"The group the translation is in.\";s:40:\"El grupo en el que está la traducción.\";s:25:\"The full original string.\";s:27:\"El texto original completo.\";s:51:\"The version of Drupal core that this string is for.\";s:60:\"La versión del núcleo de Drupal para la que es este texto.\";s:47:\"Provide a simple link to edit the translations.\";s:59:\"Proporciona un enlace directo para editar las traducciones.\";s:13:\"Locale target\";s:27:\"Destino de regionalización\";s:28:\"The full translation string.\";s:33:\"El texto completo de traducción.\";s:36:\"The language this translation is in.\";s:43:\"El idioma en el que está esta traducción.\";s:12:\"Singular LID\";s:12:\"LID singular\";s:41:\"Whether or not the translation is plural.\";s:33:\"Si la traducción es plural o no.\";s:18:\"Published or admin\";s:24:\"Publicado o administrado\";s:20:\"Created year + month\";s:20:\"Creado el año + mes\";s:12:\"Created year\";s:17:\"Año de creación\";s:13:\"Created month\";s:16:\"Mes de creación\";s:11:\"Created day\";s:17:\"Día de creación\";s:12:\"Created week\";s:19:\"Semana de creación\";s:20:\"Updated year + month\";s:27:\"Año + mes de modificación\";s:12:\"Updated year\";s:21:\"Año de modificación\";s:13:\"Updated month\";s:20:\"Mes de modificación\";s:11:\"Updated day\";s:21:\"Día de modificación\";s:12:\"Updated week\";s:23:\"Semana de modificación\";s:3:\"Vid\";s:3:\"Vid\";s:54:\"The log message entered when the revision was created.\";s:57:\"El mensaje de registro que se hizo al crear la revisión.\";s:11:\"Revert link\";s:15:\"Invertir enlace\";s:48:\"Provide a simple link to revert to the revision.\";s:57:\"Proporciona un enlace directo para volver a la revisión.\";s:17:\"Filter by access.\";s:18:\"Filtrar por acceso\";s:15:\"Has new content\";s:21:\"Tiene contenido nuevo\";s:10:\"Links from\";s:13:\"Enlaces desde\";s:42:\"Other nodes that are linked from the node.\";s:46:\"Otros nodos a los que se enlaza desde el nodo.\";s:8:\"Links to\";s:9:\"Enlaces a\";s:34:\"Other nodes that link to the node.\";s:32:\"Otros nodos que enlazan al nodo.\";s:12:\"Search Terms\";s:16:\"Buscar términos\";s:24:\"The terms to search for.\";s:34:\"Los términos que se deben buscar.\";s:19:\"The ID of the file.\";s:18:\"El ID del archivo.\";s:21:\"The name of the file.\";s:22:\"El nombre del archivo.\";s:21:\"The path of the file.\";s:20:\"la ruta del archivo.\";s:26:\"The mime type of the file.\";s:27:\"El tipo MIME del documento.\";s:23:\"The status of the file.\";s:24:\"El estado del documento.\";s:31:\"The date the file was uploaded.\";s:40:\"La fecha en la que se subió el archivo.\";s:19:\"Taxonomy term name.\";s:31:\"Nombre de termino de taxonomía\";s:28:\"The parent term of the term.\";s:31:\"El término padre del término.\";s:16:\"Node translation\";s:19:\"Traducción de nodo\";s:18:\"Source translation\";s:21:\"Origen de traducción\";s:49:\"The source that this content was translated from.\";s:46:\"El original del que se tradujo este contenido.\";s:11:\"The user ID\";s:14:\"ID del usuario\";s:24:\"The user or author name.\";s:29:\"El nombre de autor o usuario.\";s:20:\"Language of the user\";s:18:\"Idioma del usuario\";s:31:\"The user\'s picture, if allowed.\";s:46:\"La imagen del usuario, si estuviera permitida.\";s:30:\"The date the user was created.\";s:39:\"La fecha en la que se creó el usuario.\";s:28:\"The user\'s last access date.\";s:40:\"La fecha del último acceso del usuario.\";s:27:\"The user\'s last login date.\";s:65:\"La fecha de la última identificación en el sistema del usuario.\";s:36:\"Whether a user is active or blocked.\";s:39:\"Si un usuario está activo o bloqueado.\";s:21:\"The user\'s signature.\";s:21:\"La firma del usuario.\";s:39:\"Provide a simple link to edit the user.\";s:53:\"Proporciona un enlace directo para editar al usuario.\";s:29:\"Roles that a user belongs to.\";s:37:\"Roles a los que pertenece un usuario.\";s:28:\"Randomize the display order.\";s:27:\"Mostrar en orden aleatorio.\";s:4:\"Null\";s:4:\"Nulo\";s:28:\"Provide custom text or link.\";s:42:\"Porporcionar texto o enlace personalizado.\";s:19:\"View result counter\";s:26:\"Ver contador de resultados\";s:23:\"Current user\'s language\";s:28:\"El idioma del usuario actual\";s:21:\"Default site language\";s:31:\"Idioma predeterminado del sitio\";s:11:\"No language\";s:10:\"Sin idioma\";s:28:\"Node IDs separated by , or +\";s:39:\"Los ID de los nodos separados por , o +\";s:41:\"Link this field to its taxonomy term page\";s:59:\"Enlazar este campo con su página de término de taxonomía\";s:25:\"Limit terms by vocabulary\";s:37:\"Limitar los términos por vocabulario\";s:28:\"Term IDs separated by , or +\";s:39:\"Los ID de términos separados por , o +\";s:17:\"PHP validate code\";s:26:\"Código de validación PHP\";s:44:\"Change the title that this display will use.\";s:49:\"Cambiar el título que usará esta presentación.\";s:8:\"Use AJAX\";s:9:\"Usar AJAX\";s:49:\"Change whether or not this display will use AJAX.\";s:47:\"Cambiar si esta visualización usará AJAX o no\";s:45:\"Specify access control type for this display.\";s:65:\"Especificar el tipo de control de acceso para esta presentación.\";s:37:\"Change settings for this access type.\";s:49:\"Cambiar la configuración de este tipo de acceso.\";s:21:\"Exposed form in block\";s:29:\"Formulario expuesto en bloque\";s:34:\"Display even if view has no result\";s:49:\"Mostrar incluso si esta vista no tiene resultados\";s:30:\"How should this view be styled\";s:37:\"Qué estilo debería tener esta vista\";s:13:\"Style options\";s:18:\"Opciones de estilo\";s:14:\"Display output\";s:23:\"Salida de presentación\";s:12:\"Style output\";s:16:\"Salida de estilo\";s:16:\"Row style output\";s:24:\"Salida de estilo de fila\";s:22:\"Field @field (ID: @id)\";s:22:\"Campo @field (ID: @id)\";s:12:\"Change theme\";s:12:\"Cambiar tema\";s:35:\"File found in folder @template-path\";s:47:\"Archivo hallado en el directorio @template-path\";s:7:\"No menu\";s:9:\"Sin menú\";s:33:\"The menu path or URL of this view\";s:36:\"La ruta de menú o URL de esta vista\";s:52:\"\"%\" may not be used for the first segment of a path.\";s:57:\"\"%\" no se puede usar para el primer segmento de una ruta.\";s:30:\"Display record count with link\";s:38:\"Mostrar cuenta de registros con enlace\";s:35:\"Override number of items to display\";s:47:\"Sobreescribir el número de elementos a mostrar\";s:20:\"Display items inline\";s:31:\"Mostrar los elementos en línea\";s:21:\"Allow multiple values\";s:27:\"Permitir múltiples valores\";s:18:\"Standard deviation\";s:21:\"Desviación estándar\";s:15:\"Sort descending\";s:17:\"Orden descendente\";s:14:\"Sort ascending\";b:1;s:20:\"Administrative title\";s:22:\"Título administrativo\";s:14:\"Style settings\";s:18:\"Opciones de estilo\";s:14:\"@label (!name)\";s:14:\"@label (!name)\";s:17:\"(first item is 0)\";s:25:\"(el primer elemento es 0)\";s:24:\"(start from last values)\";s:37:\"(comenzar desde los últimos valores)\";s:15:\"@argument title\";s:20:\"Título de @argument\";s:15:\"@argument input\";s:20:\"Entrada de @argument\";s:51:\"The maximum number of characters this field can be.\";s:60:\"El número máximo de caracteres que puede tener este campo.\";s:27:\"Count the number 0 as empty\";s:31:\"Contar el número 0 como vacío\";s:13:\"Hide if empty\";s:23:\"Ocultar si está vacío\";s:14:\"Starting value\";s:13:\"Valor inicial\";s:47:\"Specify the number the counter should start at.\";s:63:\"Especificar el numero con el que el contador debería comenzar.\";s:30:\"The view %name has been saved.\";s:30:\"La vista %name se ha guardado.\";s:41:\"Hostname of user that posted the comment.\";s:56:\"Nombre de equipo del usuario que publicó el comentario.\";s:12:\"Exposed form\";s:19:\"Formulario expuesto\";s:69:\"The label for this area that will be displayed only administratively.\";s:74:\"La etiqueta para esta área que se mostrará solo de forma administrativa.\";s:29:\"Operator to use on all groups\";s:38:\"Operador para usar en todos los grupos\";s:19:\"Remove group @group\";s:21:\"Eliminar grupo @group\";s:13:\"Default group\";s:20:\"Grupo predeterminado\";s:12:\"Group @group\";s:12:\"Grupo @group\";s:28:\"The taxonomy vocabulary name\";s:38:\"El nombre de vocabulario de taxonomía\";s:10:\"Name (raw)\";s:20:\"Nombre (sin filtrar)\";s:33:\"Provide markup text for the area.\";s:47:\"Proporcionar el texto de marcado para el área.\";s:12:\"Machine Name\";s:17:\"Nombre de sistema\";s:18:\"Exposed form style\";s:30:\"Estilo del formulario expuesto\";s:9:\"All items\";s:19:\"Todos los elementos\";s:22:\"Group results together\";s:18:\"Agrupar resultados\";s:21:\"Authentication module\";s:27:\"Módulo de autentificación\";s:14:\"Update preview\";s:26:\"Actualizar la vista previa\";s:39:\"Provide a simple link to edit the term.\";s:55:\"Proporciona un enlace sencillo para editar el término.\";s:13:\"Enabled, name\";s:16:\"Activado, nombre\";s:15:\"- Use default -\";s:23:\"- Usar predeterminado -\";s:12:\"HTML element\";s:13:\"Elemento HTML\";s:29:\"Place a colon after the label\";s:42:\"Colocar dos puntos después de la etiqueta\";s:19:\"Add default classes\";s:27:\"Agregar clases predefinidas\";s:17:\"Use absolute path\";s:18:\"Usar ruta absoluta\";s:14:\"Field Language\";s:15:\"Idioma de campo\";s:14:\"Machine name: \";s:19:\"Nombre de sistema: \";s:13:\"Edit @section\";s:15:\"Editar @section\";s:48:\"When the filter value is <em>NOT</em> in the URL\";s:54:\"Cuando el valor del filtro <em>NO</em> está en la URL\";s:15:\"Exception value\";s:22:\"Valor de la excepción\";s:13:\"Provide title\";s:20:\"Proporcionar título\";s:19:\"Override breadcrumb\";s:46:\"Sobrescribir enlaces de ayuda a la navegación\";s:18:\"Provide breadcrumb\";s:46:\"Proporcionar enlaces de ayuda a la navegación\";s:27:\"Specify validation criteria\";s:36:\"Especificar criterios de validación\";s:48:\"Action to take if filter value does not validate\";s:61:\"Acción a tomar si el valor del filtro no pasa la validación\";s:43:\"Display all results for the specified field\";s:55:\"Mostrar todos los resultados para el campo especificado\";s:21:\"Provide default value\";s:33:\"Proporcionar valor predeterminado\";s:21:\"Show \"Page not found\"\";s:31:\"Mostrar \"página no encontrada\"\";s:17:\"Display a summary\";s:18:\"Mostrar un resumen\";s:38:\"Display contents of \"No results found\"\";s:53:\"Mostrar contenido de «No se encontraron resultados»\";s:34:\"Skip default argument for view URL\";s:55:\"Saltar argumento predeterminado para la URL de la vista\";s:14:\"Create a label\";s:18:\"Crear una etiqueta\";s:40:\"Enable to create a label for this field.\";s:47:\"Active para crear una etiqueta para este campo.\";s:15:\"Rewrite results\";s:21:\"Reescribir resultados\";s:26:\"Replace spaces with dashes\";s:30:\"Remplazar espacios con guiones\";s:19:\"External server URL\";s:23:\"URL de servidor externo\";s:13:\"Expose filter\";s:14:\"Exponer filtro\";s:58:\"Enable to hide items that do not contain this relationship\";s:61:\"Active para ocultar elementos que no contienen esta relación\";s:68:\"This sort is not exposed. Expose it to allow the users to change it.\";s:80:\"Este orden no está expuesto. Expóngalo para permitir a los usuarios cambiarlo.\";s:11:\"Expose sort\";s:13:\"Exponer orden\";s:19:\"Provide description\";s:25:\"Proporcionar descripción\";s:22:\"Update \"@title\" choice\";s:29:\"Actualizar opción «@title»\";s:32:\"Update \"@title\" choice (@number)\";s:39:\"Actualizar opción «@title» (@number)\";s:61:\"Modify the display(s) of your view below or add new displays.\";s:81:\"Modificar las visualizaciones de su vista abajo o agregar nuevas visualizaciones.\";s:26:\"edit view name/description\";s:38:\"editar nombre/descripción de la vista\";s:22:\"@display_title details\";s:26:\"Detalles de @display_title\";s:12:\"Auto preview\";b:1;s:32:\"Preview with contextual filters:\";s:43:\"Previsualización con filtros contextuales:\";s:68:\"Separate contextual filter values with a \"/\". For example, %example.\";s:80:\"Separe los valores de los filtros contextuales con un \"/\". Por ejemplo %example.\";s:1:\":\";s:1:\":\";s:18:\"Apply and continue\";s:19:\"Aplicar y continuar\";s:18:\"@current of @total\";s:18:\"@current de @total\";s:32:\"All displays (except overridden)\";s:51:\"Todas las presentaciones (excepto las sobrescritas)\";s:12:\"All displays\";s:24:\"Todas las presentaciones\";s:29:\"This @display_type (override)\";s:33:\"Este @display_type (sobrescribir)\";s:23:\"Create new filter group\";s:28:\"Crear nuevo grupo de filtros\";s:20:\"Drag to add filters.\";s:30:\"Arrastre para agregar filtros.\";s:24:\"Add and configure @types\";s:27:\"Agregar y configurar @types\";s:22:\"Configure @type: @item\";s:23:\"Configurar @type: @item\";s:17:\"Above the preview\";s:25:\"Arriba de la vista previa\";s:17:\"Below the preview\";s:24:\"Abajo de la vista previa\";s:12:\"The node ID.\";s:15:\"El ID del nodo.\";s:34:\"Load default filter from term page\";s:51:\"Cargar filtro predeterminado de página de término\";s:36:\"Change the way content is formatted.\";s:52:\"Cambiar la manera en que se da formato al contenido.\";s:27:\"Hide attachments in summary\";s:30:\"Ocultar adjuntos en el resumen\";s:67:\"You may also adjust the !settings for the currently selected style.\";s:77:\"También puede ajustar las !settings para el estilo seleccionado actualmente.\";s:67:\"You may also adjust the !settings for the currently selected pager.\";s:80:\"También puede ajustar las !settings para el paginador seleccionado actualmente.\";s:11:\"All storage\";s:22:\"Todo el almacenamiento\";s:10:\"All status\";s:17:\"Todos los estados\";s:7:\"No tags\";s:13:\"Sin etiquetas\";s:35:\"No views match the search criteria.\";s:54:\"Ninguna vista coincide con los criterios de búsqueda.\";s:13:\"Create a page\";s:17:\"Crear una página\";s:18:\"Create a menu link\";s:24:\"Crear un enlace de menú\";s:19:\"Include an RSS feed\";s:19:\"Incluir un Feed RSS\";s:9:\"Feed path\";s:21:\"Ruta de la fuente web\";s:14:\"Feed row style\";s:36:\"Estilo de fila del canal de noticias\";s:14:\"Create a block\";s:15:\"Crear un bloque\";s:7:\"of type\";s:7:\"de tipo\";s:11:\"tagged with\";s:14:\"etiquetado con\";s:13:\"without links\";s:11:\"sin enlaces\";s:7:\"teasers\";s:10:\"resúmenes\";s:10:\"full posts\";s:17:\"envíos completos\";s:6:\"titles\";s:8:\"títulos\";s:15:\"titles (linked)\";s:21:\"títulos (con enlace)\";s:41:\"Should links be displayed below each node\";s:51:\"Debería o no mostrarse enlaces debajo de cada nodo\";s:46:\"with links (allow users to add comments, etc.)\";s:67:\"con enlaces (permitiendo a los usuarios escribir comentarios, etc.)\";s:44:\"Should comments be displayed below each node\";s:55:\"Debería o no mostrarse comentarios debajo de cada nodo\";s:9:\"Hide view\";s:13:\"Ocultar vista\";s:8:\"Unsorted\";s:11:\"Sin ordenar\";s:20:\"Customize field HTML\";s:27:\"Personalizar HTML del campo\";s:23:\"Hide rewriting if empty\";s:38:\"Ocultar la reescritura si está vacío\";s:56:\"Do not display rewritten content if this field is empty.\";s:62:\"No mostrar el contenido reescrito, si este campo está vacío.\";s:20:\"clone @display_title\";s:21:\"clonar @display_title\";s:21:\"delete @display_title\";s:23:\"eliminar @display_title\";s:22:\"disable @display_title\";s:25:\"desactivar @display_title\";s:21:\"Appears in: @bundles.\";s:20:\"Aparece en @bundles.\";s:29:\"Delta - Appears in: @bundles.\";s:29:\"Delta - Aparece en: @bundles.\";s:13:\"Query Comment\";s:25:\"Comentario de la consulta\";s:14:\"Count DISTINCT\";s:14:\"Count DISTINCT\";s:17:\"Revert to default\";s:36:\"Volver a los valores predeterminados\";s:11:\"Use a pager\";s:17:\"Usar un paginador\";s:23:\"Display \"Access Denied\"\";s:25:\"Muestra \"Acceso denegado\"\";s:2:\"of\";s:2:\"de\";s:40:\"Configure extra settings for @type %item\";s:42:\"Copfigurar opciones extra para @type %item\";s:22:\"Updated/commented date\";s:36:\"Fecha de actualización o comentario\";s:60:\"The most recent of last comment posted or node updated time.\";s:83:\"El comentario último o más reciente enviado o la hora de actualización del nodo.\";s:73:\"A source string for translation, in English or the default site language.\";s:82:\"Un texto de origen para traducir, en inglés o en idioma predeterminado del sitio.\";s:28:\"The ID of the source string.\";s:26:\"El ID del texto de origen.\";s:55:\"A description of the location or context of the string.\";s:70:\"Una descripción de la ubicación o el contexto de la cadena de texto.\";s:33:\"The ID of the parent translation.\";s:30:\"El ID de la traducción madre.\";s:47:\"Files maintained by Drupal and various modules.\";s:55:\"Documentos que Drupal y sus distintos módulos manejan.\";s:37:\"Taxonomy terms are attached to nodes.\";s:52:\"Los términos de taxonomía se adjuntan a los nodos.\";s:21:\"The term weight field\";s:26:\"Campo de peso del término\";s:48:\"The description associated with a taxonomy term.\";s:55:\"La descripción asociada con un término de taxonomía.\";s:66:\"Filter the results of \"Taxonomy: Term\" to a particular vocabulary.\";s:77:\"Filtrar los resultados de \"Taxonomía: Término\" con un vocabulario concreto.\";s:23:\"Translation set node ID\";s:39:\"ID del conjunto de traducción del nodo\";s:53:\"The ID of the translation set the content belongs to.\";s:59:\"El ID del conjunto de traducción al que pertenece el nodo.\";s:43:\"Versions of content in different languages.\";s:45:\"Versiones del contenido en distintos idiomas.\";s:17:\"Child translation\";s:19:\"Traducción de hijo\";s:8:\"Outdated\";s:9:\"Desfasado\";s:47:\"Displays the actual position of the view result\";s:53:\"Muestra la posición actual del resultado de la vista\";s:44:\"Also look for a node and use the node author\";s:48:\"Buscar también un nodo y usar el autor del nodo\";s:23:\"Only allow numeric UIDs\";s:29:\"Permitir sólo UID numéricos\";s:27:\"Only allow string usernames\";s:42:\"Permitir sólo nombres de usuario de texto\";s:44:\"Allow both numeric UIDs and string usernames\";s:53:\"Permitir UID numéricos y nombres de usuario de texto\";s:27:\"Restrict user based on role\";s:39:\"Restringir usuario basándose en el rol\";s:30:\"Restrict to the selected roles\";s:33:\"Limitar a los roles seleccionados\";s:62:\"If no roles are selected, users from any role will be allowed.\";s:85:\"Si no se ha seleccionado ningún nodo, se permitirán los usuarios con cualquier rol.\";s:36:\"Change this display\'s pager setting.\";s:55:\"Cambia las opciones de paginador de esta presentación.\";s:56:\"Specify whether this display will provide a \"more\" link.\";s:73:\"Indique si esta presentación debe incluir un enlace de tipo \"[más...]\".\";s:38:\"Specify caching type for this display.\";s:54:\"Especificar el tipo de caché para esta presentación.\";s:12:\"Link display\";s:14:\"Mostrar enlace\";s:64:\"Allow the exposed form to appear in a block instead of the view.\";s:79:\"Permite que el formulario expuesto aparezca en un bloque en vez de en la vista.\";s:44:\"Get information on how to theme this display\";s:75:\"Conseguir información se cómo aplicar un tema visual a esta presentación\";s:21:\"Rescan template files\";s:43:\"Volver a explorar los archivos de plantilla\";s:7:\"In code\";s:10:\"En código\";s:13:\"Taxonomy Term\";s:22:\"Término de taxonomía\";s:13:\"revision user\";s:15:\"usuario revisor\";s:9:\"Entity ID\";s:13:\"ID de entidad\";s:40:\"Change the machine name of this display.\";s:51:\"Cambiar el nombre de sistema de esta presentación.\";s:36:\"Change settings for this pager type.\";s:63:\"Cambiar opciones de configuración para este tipo de paginador.\";s:55:\"Allow grouping and aggregation (calculation) of fields.\";s:57:\"Permitir agrupamiento y agregación (cálculo) de campos.\";s:41:\"Select the kind of exposed filter to use.\";s:50:\"Seleccionar el tipo de filtro expuesto a utilizar.\";s:50:\"Exposed form settings for this exposed form style.\";s:90:\"Opciones de configuración de formulario expuesto para este estilo de formulario expuesto.\";s:48:\"Select which pager, if any, to use for this view\";s:75:\"Elija cuál paginador utilizar para esta vista, si es que se utiliza alguno\";s:13:\"Pager options\";s:21:\"Opciones de paginador\";s:11:\"In database\";s:19:\"En la base de datos\";s:15:\"@entity:@bundle\";s:15:\"@entity:@bundle\";s:23:\"Is not empty (NOT NULL)\";s:26:\"No está vacío (NOT NULL)\";s:14:\"Translate link\";s:15:\"Traducir enlace\";s:44:\"Provide a simple link to translate the node.\";s:52:\"Proporciona un enlace directo para traducir el nodo.\";s:10:\"Authmap ID\";s:10:\"ID Authmap\";s:15:\"The Authmap ID.\";s:18:\"El ID del Authmap.\";s:19:\"Authentication name\";s:26:\"Nombre de Autentificación\";s:31:\"The unique authentication name.\";s:37:\"El nombre de autentificación único.\";s:57:\"The name of the module managing the authentication entry.\";s:66:\"El nombre del módulo que administra la entrada de autenticación.\";s:64:\"Change the CSS class name(s) that will be added to this display.\";s:73:\"Cambiar los nombres de clase CSS que se añadirán a esta visualización.\";s:11:\"Choose text\";s:12:\"Elegir texto\";s:66:\"The text that will appear as the selected option in the jump menu.\";s:74:\"El texto que aparecerá como la opción seleccionada en el menú de salto.\";s:14:\"Term edit link\";s:30:\"Enlace de edición de término\";s:20:\"Unknown content type\";s:29:\"Tipo de contenido desconocido\";s:32:\"The name of the item; e.g. node.\";s:42:\"El nombre del elemento; por ejemplo: nodo.\";s:60:\"The type of the item, either module, theme, or theme_engine.\";s:59:\"El tipo de elemento, ya sea módulo, tema o motor de temas.\";s:55:\"Boolean indicating whether or not this item is enabled.\";s:61:\"Valor booleano que indica si este elemento está activo o no.\";s:14:\"Schema version\";s:20:\"Versión del esquema\";s:11:\"View: !view\";s:12:\"Vista: !view\";s:19:\"Human-readable name\";s:30:\"Nombre interno para el sistema\";s:18:\"Label HTML element\";s:25:\"Elemento HTML de etiqueta\";s:20:\"Wrapper HTML element\";s:27:\"Elemento HTML de envoltorio\";s:8:\"Rel Text\";s:13:\"Texto «Rel»\";s:21:\"Preserve certain tags\";s:27:\"Preservar ciertas etiquetas\";s:46:\"Date and time of when the comment was created.\";s:48:\"Fecha y hora de cuando el comentario fue creado.\";s:51:\"Date and time of when the comment was last updated.\";s:69:\"Fecha y hora de cuando el comentario fue actualizado por última vez.\";s:67:\"Whether the comment is approved (or still in the moderation queue).\";s:71:\"Si el comentario fue aprobado (o aún está en la cola de moderación).\";s:16:\"Approved comment\";s:19:\"Comentario aprobado\";s:16:\"Last comment CID\";s:26:\"CID del último comentario\";s:34:\"Display the last comment of a node\";s:40:\"Mostrar el último comentario de un nodo\";s:12:\"Last Comment\";s:18:\"Último Comentario\";s:27:\"The last comment of a node.\";s:33:\"El último comentario de un nodo.\";s:10:\"File Usage\";s:15:\"Uso del Archivo\";s:19:\"Taxonomy Vocabulary\";s:25:\"Vocabulario de taxonomía\";s:43:\"The module managing this file relationship.\";s:49:\"El módulo que maneja esta relación de archivos.\";s:47:\"The type of entity that is related to the file.\";s:56:\"El tipo de entidad que está relacionado con el archivo.\";s:52:\"The number of times the file is used by this entity.\";s:66:\"La cantidad de veces que el archivo es utilizado por esta entidad.\";s:21:\"term from !field_name\";s:23:\"término de !field_name\";s:15:\"Math expression\";s:22:\"Expresión matemática\";s:52:\"Evaluates a mathematical expression and displays it.\";s:48:\"Evalúa una expresión matemática y la muestra.\";s:30:\"Term name converted to Term ID\";s:46:\"Nombre de término convertido a ID de término\";s:10:\"No comment\";s:18:\"No hay comentarios\";s:33:\"Comment or document this display.\";s:42:\"Comentar o documentar esta visualización.\";s:14:\"Query settings\";s:23:\"Opciones de la consulta\";s:56:\"Allow to set some advanced settings for the query plugin\";s:77:\"Permitir establecer algunas opciones avanzadas para la extensión de consulta\";s:13:\"Query options\";s:20:\"Opciones de consulta\";s:21:\"Disable SQL rewriting\";s:29:\"Desactivar reescritura de SQL\";s:16:\"Use Slave Server\";s:21:\"Usar servidor esclavo\";s:12:\"Approve link\";s:14:\"Aprobar enlace\";s:14:\"Content access\";s:19:\"Acceso al contenido\";s:72:\"If this value is received, the filter will be ignored; i.e, \"all values\"\";s:75:\"Si se recibe este valor, el filtro será ignorado; i.e, \"todos los valores\"\";s:69:\"When the filter value <em>IS</em> in the URL or a default is provided\";s:96:\"Cuando el valor del filtro <em>SÍ</em> está en la URL o se proporciona un valor predeterminado\";s:17:\"Number of records\";s:20:\"Número de registros\";s:68:\"Choose the HTML element to wrap around this field, e.g. H1, H2, etc.\";s:80:\"Seleccione el elemento HTML a colocar alrededor de este campo, e.g. H1, H2, etc.\";s:18:\"Create a CSS class\";s:19:\"Crear una clase CSS\";s:68:\"Choose the HTML element to wrap around this label, e.g. H1, H2, etc.\";s:83:\"Seleccione el elemento HTML a colocar alrededor de esta etiqueta, e.g. H1, H2, etc.\";s:58:\"Enable to trim the field to a maximum length of characters\";s:66:\"Active para recortar el campo a una longitud máxima de caracteres\";s:40:\"Convert newlines to HTML &lt;br&gt; tags\";s:55:\"Convertir saltos de línea en etiquetas HTML &lt;br&gt;\";s:15:\"No results text\";s:30:\"Texto de «no hay resultados»\";s:70:\"This filter is not exposed. Expose it to allow the users to change it.\";s:81:\"Este filtro no está expuesto. Expóngalo para permitir a los usuarios cambiarlo.\";s:11:\"Save & exit\";s:15:\"Guardar y salir\";s:15:\"Continue & edit\";s:18:\"Continuar y editar\";s:24:\"Database overriding code\";s:42:\"Código de sobreescritura de base de datos\";s:12:\"analyze view\";s:14:\"analizar vista\";s:10:\"clone view\";s:12:\"clonar vista\";s:11:\"export view\";s:14:\"exportar vista\";s:11:\"revert view\";s:14:\"deshacer vista\";s:11:\"delete view\";s:14:\"eliminar vista\";s:12:\"Add !display\";s:16:\"Agregar !display\";s:25:\"View name and description\";s:33:\"Nombre y descripción de la vista\";s:67:\"A descriptive human-readable name for this view. Spaces are allowed\";s:96:\"Un nombre para esta vista que sea descriptivo para los usuarios. Los espacios están permitidos.\";s:27:\"No filters have been added.\";s:33:\"No se ha agregado ningún filtro.\";s:33:\"Show filters on the list of views\";s:39:\"Mostrar filtros en el listado de vistas\";s:26:\"Show advanced help warning\";s:37:\"Mostrar advertencia de ayuda avanzada\";s:30:\"Always show the master display\";s:41:\"Siempre mostar la presentación principal\";s:37:\"Always show advanced display settings\";s:55:\"Siempre mostrar las opciones avanzadas de presentación\";s:67:\"Label for \"Any\" value on non-required single-select exposed filters\";s:91:\"Etiqueta para «Cualquier» valor en filtros expuestos no obligatorios de selección única\";s:21:\"Live preview settings\";s:38:\"Configuración de vista previa en vivo\";s:39:\"Automatically update preview on changes\";s:58:\"Actualizar la vista previa automáticamente en cada cambio\";s:66:\"Show information and statistics about the view during live preview\";s:87:\"Mostrar información y estadísticas acerca de la vista durante la vista previa en vivo\";s:18:\"Show the SQL query\";s:23:\"Mostrar la consulta SQL\";s:27:\"Show performance statistics\";s:35:\"Mostrar estadísticas de desempeño\";s:47:\"The content to which the comment is a reply to.\";s:57:\"El contenido para el cual el comentario es una respuesta.\";s:18:\"The content title.\";s:25:\"El título del contenido.\";s:32:\"The date the content was posted.\";s:41:\"La fecha en que el contenido fue enviado.\";s:38:\"The date the content was last updated.\";s:61:\"La fecha en que el contenido fue actualizado por última vez.\";s:73:\"The content type (for example, \"blog entry\", \"forum post\", \"story\", etc).\";s:96:\"El tipo de contenido (por ejemplo, «entrada de blog», «envío de foro», «artículo», etc).\";s:40:\"Whether or not the content is published.\";s:37:\"Si el contenido está publicado o no.\";s:67:\"Filters out unpublished content if the current user cannot view it.\";s:69:\"Ignora el contenido sin publicar si el usuario actual no puede verlo.\";s:57:\"Whether or not the content is promoted to the front page.\";s:50:\"Si el contenido está promovido a la portada o no.\";s:37:\"Whether or not the content is sticky.\";s:59:\"Si el contenido está fijo en la cabeza de las listas o no.\";s:37:\"Provide a simple link to the content.\";s:45:\"Proporcionar un enlace sencillo al contenido.\";s:42:\"Provide a simple link to edit the content.\";s:57:\"Proporcionar un enlace sencillo para editar el contenido.\";s:44:\"Provide a simple link to delete the content.\";s:56:\"Proporciona un enlace simple para eliminar el contenido.\";s:33:\"The aliased path to this content.\";s:35:\"La ruta con alias a este contenido.\";s:42:\"Relate content to the user who created it.\";s:51:\"Relacionar el contenido con el usuario que lo creo.\";s:19:\"User has a revision\";s:30:\"El usuario tiene una revisión\";s:45:\"All nodes where a certain user has a revision\";s:61:\"Todos los nodos donde un usuario concreto tiene una revisión\";s:16:\"Content revision\";s:23:\"Revisión del contenido\";s:52:\"Content revision is a history of changes to content.\";s:63:\"Revisión de contenido es un historial de cambios al contenido.\";s:63:\"Relate a content revision to the user who created the revision.\";s:76:\"Relacionar una revisión de contenido con el usuario que creó la revisión.\";s:40:\"The revision ID of the content revision.\";s:49:\"El ID de revisión de la revisión del contenido.\";s:47:\"Get the actual content from a content revision.\";s:56:\"Obtener el contenido real de una revisión de contenido.\";s:53:\"Provide a simple link to delete the content revision.\";s:70:\"Proporciona un enlace simple para eliminar la revisión del contenido.\";s:47:\"Show a marker if the content is new or updated.\";s:59:\"Mostrar un marcador si el contenido es nuevo o actualizado.\";s:41:\"Show only content that is new or updated.\";s:47:\"Mostrar sólo el contenido nuevo o actualizado.\";s:25:\"Module/Theme/Theme engine\";s:26:\"Módulo/Tema/Motor de tema\";s:46:\"Modules/Themes/Theme engines in your codebase.\";s:54:\"Módulos/Temas/Motores de temas en su base de código.\";s:34:\"Module/Theme/Theme engine filename\";s:48:\"Nombre de archivo de Módulo/Tema/Motor de temas\";s:30:\"Module/Theme/Theme engine name\";s:38:\"Nombre del Módulo/Tema/Motor de temas\";s:54:\"Content that is a translation of a source translation.\";s:65:\"Contenido que es una traducción de una traducción de la fuente.\";s:16:\"Content authored\";s:18:\"Contenido generado\";s:41:\"Provide a simple link to cancel the user.\";s:57:\"Proporcionar un enlace sencillo para cancelar el usuario.\";s:35:\"Provide serialized data of the user\";s:43:\"Proporcionar datos serializados del usuario\";s:9:\"View area\";s:14:\"Área de vista\";s:29:\"Insert a view inside an area.\";s:38:\"Insertar una vista dentro de un área.\";s:38:\"Enable to override this field\'s links.\";s:51:\"Active para sobrescribir los enlaces de este campo.\";s:18:\"Use field template\";s:27:\"Utilizar plantilla de campo\";s:23:\"Multiple field settings\";s:35:\"Configuración de campos múltiples\";s:34:\"Display all values in the same row\";s:42:\"Mostrar todos los valores en la misma fila\";s:23:\"Display @count value(s)\";s:24:\"Mostrar @count valor(es)\";s:11:\"Raw @column\";s:19:\"@column sin filtrar\";s:48:\"Link this field to the original piece of content\";s:51:\"Enlazar este campo a la pieza original de contenido\";s:50:\"Choose one or more content types to validate with.\";s:59:\"Elija uno o más tipos de contenido con los cuales validar.\";s:39:\"Validate user has access to the content\";s:50:\"Verificar que el usuario tenga acceso al contenido\";s:25:\"Access operation to check\";s:33:\"Acceder a la operación a revisar\";s:19:\"Filter value format\";s:28:\"Formato del valor del filtro\";s:17:\"Filter value type\";s:23:\"Tipo de valor de filtro\";s:60:\"Transform dashes in URL to spaces in term name filter values\";s:89:\"Transformar guiones en la URL a espacios en los valores de filtro del nombre del término\";s:34:\"Type of user filter value to allow\";s:45:\"Tipo de valor de filtro de usuario a permitir\";s:26:\"PHP contextual filter code\";s:36:\"Código del filtro contextual de PHP\";s:31:\"Change settings for this format\";s:52:\"Cambiar opciones de configuración para este formato\";s:46:\"Change the way each row in the view is styled.\";s:58:\"Cambiar la forma en que se estiliza cada fila en la vista.\";s:13:\"Block caching\";s:17:\"Caché de bloques\";s:24:\"@group (historical data)\";s:26:\"@group (datos históricos)\";s:14:\"Use path alias\";s:21:\"Usar alias de la ruta\";s:41:\"Use replacement tokens from the first row\";s:46:\"Utilice tokens de reemplazo de la primera fila\";s:45:\"Allow multiple filter values to work together\";s:62:\"Permitir que funcionen a la vez múltiples valores de filtros.\";s:73:\"You may use token substitutions from the rewriting section in this class.\";s:84:\"Puede utilizar sustituciones por tokens para sobreescribir la seccion en esta clase.\";s:20:\"Customize label HTML\";s:32:\"Personalizar HTML de la etiqueta\";s:38:\"Customize field and label wrapper HTML\";s:47:\"Personalizar campo y envoltura de etiqueta HTML\";s:17:\"Remove whitespace\";s:27:\"Eliminar espacios en blanco\";s:58:\"Expose this filter to visitors, to allow them to change it\";s:63:\"Exponer este filtro a los visitantes para permitirles cambiarlo\";s:56:\"Expose this sort to visitors, to allow them to change it\";s:78:\"Exponer este criterio de búsqueda a los visitantes para permitirles cambiarlo\";s:16:\"reorder displays\";s:17:\"reordernar vistas\";s:13:\"view @display\";s:14:\"vista @display\";s:47:\"The node ID to which the comment is a reply to.\";s:52:\"El ID del nodo al que hace referencia el comentario.\";s:20:\"Comments of the node\";s:20:\"Comentarios del nodo\";s:14:\"@group: @field\";s:14:\"@group: @field\";s:32:\"@group (historical data): @field\";s:34:\"@group (datos históricos): @field\";s:22:\"@label (!name:!column)\";s:22:\"@label (!name:!column)\";s:14:\"@label:!column\";s:14:\"@label:!column\";s:20:\"@label (!name:delta)\";s:20:\"@label (!name:delta)\";s:12:\"@label:delta\";s:12:\"@label:delta\";s:17:\"User who uploaded\";s:29:\"El usuario que hizo la subida\";s:32:\"The user that uploaded the file.\";s:32:\"Usuario que ha subido el fichero\";s:35:\"The taxonomy vocabulary description\";s:45:\"Descripción del vocabulario de la taxonomía\";s:56:\"Taxonomy term chosen from autocomplete or select widget.\";s:81:\"Término de taxonomía escogido desde un autocompletar o un widget de selección.\";s:19:\"Representative node\";s:19:\"Nodo representativo\";s:23:\"The taxonomy term name.\";s:40:\"El nombre del término de la taxonomía.\";s:17:\"Content with term\";s:22:\"Contenido con término\";s:38:\"Relate all content tagged with a term.\";s:56:\"Relacionar todo el contenido etiquetado con un término.\";s:20:\"Has taxonomy term ID\";s:40:\"Tiene un id de un término de taxonomía\";s:54:\"Display content if it has the selected taxonomy terms.\";s:74:\"Motrar el contenido si tiene los términos de la taxonomía seleccionados.\";s:17:\"Has taxonomy term\";s:31:\"Tiene un término de taxonomía\";s:22:\"Taxonomy terms on node\";s:32:\"Términos de taxonomía del nodo\";s:18:\"All taxonomy terms\";s:36:\"Todos los términos de la taxonomía\";s:33:\"Has taxonomy term ID (with depth)\";s:52:\"Tiene ID de término de taxonomía (con profundidad)\";s:31:\"Has taxonomy terms (with depth)\";s:51:\"Tiene términos de categorización(con profundidad)\";s:35:\"Has taxonomy term ID depth modifier\";s:64:\"Tiene ID de modificador de profundidad de término de taxonomía\";s:20:\"@entity using @field\";s:21:\"@entity usando @field\";s:50:\"Relate each @entity with a @field set to the term.\";s:59:\"Relacionar cada @entity con un @field ajustado al término.\";s:11:\"!field_name\";s:11:\"!field_name\";s:14:\"Path component\";s:18:\"Componente de ruta\";s:15:\"Use aggregation\";s:16:\"Usar agregación\";s:47:\"When the filter value is <em>NOT</em> available\";s:55:\"Cuando el valor del filtro <em>NO</em> está disponible\";s:68:\"When the filter value <em>IS</em> available or a default is provided\";s:55:\"Cuando el valor del filtro <em>SI</em> está disponible\";s:53:\"The number of items to display. Enter 0 for no limit.\";s:68:\"El número de elementos a mostrar. Escriba 0 para que sea ilimitado.\";s:52:\"The contextual filter values is provided by the URL.\";s:54:\"El valor del filtro contextual es otorgado por el URL.\";s:58:\"When needed, add the field language condition to the query\";s:79:\"Cuando sea necesario, añadir la condición de lenguaje del campo a la consulta\";s:20:\"Hide the \"Go\" button\";s:22:\"Ocultar el botón \"Ir\"\";s:42:\"Select the current contextual filter value\";s:49:\"Seleccionar el valor actual del filtro contextual\";s:21:\"file from !field_name\";s:22:\"fichero de !field_name\";s:62:\"Specify which display or custom url this display will link to.\";s:82:\"Especificar a qué presentación o URL personalizada esta presentación enlazará.\";s:18:\"Transform the case\";s:50:\"Transformar de mayúscula a minúscula o viceversa\";s:71:\"When printing url paths, how to transform the case of the filter value.\";s:78:\"Cuando se imprimen rutas de URL, como transformar elcase del valor del filtro.\";s:17:\"And/Or, Rearrange\";s:16:\"Y/O, Reorganizar\";s:35:\"Custom admin theme for the Views UI\";s:47:\"Tema de admin personalizado para la UI de Views\";s:45:\"Provide a simple link to approve the comment.\";s:56:\"Proporcionar un enlace simple para aprobar el comentario\";s:10:\"Author uid\";s:13:\"uid del autor\";s:50:\"Relate each @entity with a @field set to the file.\";s:48:\"Relaciona cada @entity con un @field del fichero\";s:22:\"image from !field_name\";s:21:\"Imagen de !field_name\";s:51:\"Relate each @entity with a @field set to the image.\";s:59:\"Relacionar cada @entity con un @field ajustado a la imagen.\";s:27:\"The tid of a taxonomy term.\";s:39:\"El tid de un término de la taxonomía.\";s:21:\"The user permissions.\";s:25:\"Los permisos del usuario.\";s:19:\"First and last only\";s:27:\"Primero y último solamente\";s:23:\"Multiple-value handling\";s:30:\"Gestión de valores múltiples\";s:36:\"Filter to items that share all terms\";s:56:\"Filtrar para elementos que comparten todos los términos\";s:35:\"Filter to items that share any term\";s:49:\"Filtrar a elementos que comparten algún término\";s:29:\"Date in the form of CCYYMMDD.\";s:28:\"Fecha con la forma SSAAMMDD.\";s:27:\"Date in the form of YYYYMM.\";s:26:\"Fecha con la forma AAAAMM.\";s:25:\"Date in the form of YYYY.\";s:24:\"Fecha en el formato YYYY\";s:33:\"Date in the form of MM (01 - 12).\";s:30:\"Fecha el el formato MM (01-12)\";s:33:\"Date in the form of DD (01 - 31).\";s:30:\"Fecha en el formato DD (01-31)\";s:33:\"Date in the form of WW (01 - 53).\";s:30:\"Fecha en el formato WW (01-53)\";s:73:\"If you need more fields than the uid add the comment: author relationship\";s:92:\"Si son necesarios más campos además del uid, se debe añadir la relación comentario:autor\";s:16:\"Last comment uid\";s:25:\"Uid de último comentario\";s:56:\"The User ID of the author of the last comment of a node.\";s:61:\"El ID de usuario del autor del último comentario de un nodo.\";s:39:\"Convert spaces in term names to hyphens\";s:52:\"Convertir espacios en nombres de términos a guiones\";s:61:\"This allows links to work with Views taxonomy term arguments.\";s:86:\"Esto permite a los enlaces funcionar con los argumentos de términos de Views taxonomy\";s:57:\"Replace an existing view if one exists with the same name\";s:66:\"Sustituir una vista ya existente si existe una con el mismo nombre\";s:34:\"Provide a simple link to the user.\";s:40:\"Proporciona un enlace simple al usuario.\";s:14:\"Result summary\";s:21:\"Resumen de resultados\";s:53:\"Shows result summary, for example the items per page.\";s:67:\"Muestra el resumen de resultados, por ejemplo los items por página\";s:42:\"Add a read-more link if output is trimmed.\";s:55:\"Añadir un enlace de leer más si la salida se recorta.\";s:33:\"Show the embed display in the ui.\";s:46:\"Mostrar la visualización incrustada en la UI.\";s:16:\"Contextual Links\";s:20:\"Enlaces contextuales\";s:42:\"Display fields in a contextual links menu.\";s:51:\"Mostrar campos en un menú de enlaces contextuales.\";s:22:\"Bypass view validation\";s:33:\"Pasar de la validación de vistas\";s:71:\"Bypass the validation of plugins and handlers when importing this view.\";s:74:\"Pasar de la validación de plugins y handlers cuando se importe esta vista\";s:31:\"The language the comment is in.\";s:40:\"El idioma en el que está el comentario.\";s:12:\"- No value -\";s:13:\"- Sin valor -\";s:38:\"Provide a simple link to the revision.\";s:39:\"Añade un enlace simple a la revisión.\";s:49:\"The ID of the entity that is related to the file.\";s:43:\"La ID de la entidad relacionada al archivo.\";s:30:\"The taxonomy vocabulary weight\";s:38:\"El peso del vocabulario de taxonomías\";s:57:\"Filter the results of \"Taxonomy: Term\" by the parent pid.\";s:69:\"Filtrar los resultados de \"Taxonomía: Término\" por el ID del padre.\";s:24:\"The raw numeric user ID.\";s:30:\"El número del ID del usuario.\";s:15:\"Unfiltered text\";s:17:\"Texto sin filtrar\";s:21:\"Combine fields filter\";s:29:\"Combinar los campos de filtro\";s:47:\"Combine two fields together and search by them.\";s:46:\"Combinar dos campos juntos y buscar por ellos.\";s:29:\"Column used for click sorting\";s:43:\"Columna usada para la ordenación por click\";s:40:\"Use path alias instead of internal path.\";s:53:\"Usar el alias de la ruta, en vez, de la ruta interna.\";s:21:\"Hide contextual links\";s:28:\"Ocultar enlaces contextuales\";s:64:\"Change whether or not to display contextual links for this view.\";s:60:\"Elegir si mostrar o no enlaces contextuales para esta vista.\";s:21:\"View: !view: !display\";s:21:\"Vista: !view !display\";s:13:\"Pure Distinct\";s:13:\"Distinct puro\";s:10:\"Query Tags\";s:24:\"Etiquetas de la consulta\";s:41:\"The revision NID of the content revision.\";s:37:\"La NID de la revisión del contenido.\";s:14:\"Selector label\";s:20:\"Etiqueta de selector\";s:32:\"Set this field to display inline\";s:44:\"Seleccionar este campo para mostrar en linea\";s:17:\"Fields comparison\";s:22:\"Comparación de campos\";s:42:\"Compare database fields against eachother.\";s:55:\"Compara los campos de la base de datos uno contra otro.\";s:55:\"Use fields comparison to filter the result of the view.\";s:72:\"Utiliza la comparación de campos para filtrar el resultado de la vista.\";s:30:\"Displays messages in the area.\";s:29:\"Mostrar mensajes en el área.\";s:20:\"Reverse the counter.\";s:21:\"Invertir el contador.\";s:4:\"Font\";s:6:\"Fuente\";s:3:\"Top\";s:8:\"Superior\";s:6:\"Bottom\";s:8:\"Inferior\";s:5:\"Flash\";s:5:\"Flash\";s:6:\"Smiley\";s:9:\"Emoticono\";s:11:\"Basic setup\";s:17:\"Opciones básicas\";s:29:\"Allow users to choose default\";s:52:\"Permitir a los usuarios elegir el editor predefinido\";s:19:\"Buttons and plugins\";s:21:\"Botones y extensiones\";s:17:\"Editor appearance\";s:21:\"Apariencia del editor\";s:16:\"Toolbar location\";s:38:\"Ubicación de la barra de herramientas\";s:22:\"Enable resizing button\";s:36:\"Permitir botón de cambio de tamaño\";s:13:\"Block formats\";s:19:\"Formatos de bloques\";s:18:\"Cleanup and output\";s:36:\"Limpieza y presentación del formato\";s:10:\"Editor CSS\";s:13:\"Editor de CSS\";s:8:\"CSS path\";s:8:\"Ruta CSS\";s:11:\"CSS classes\";s:10:\"Clases CSS\";s:7:\"Replace\";s:10:\"Reemplazar\";s:9:\"Font size\";s:17:\"Tamaño de fuente\";s:11:\"Superscript\";s:12:\"Superíndice\";s:11:\"Show blocks\";s:15:\"Mostrar bloques\";s:4:\"Bold\";s:7:\"Negrita\";s:4:\"Copy\";s:6:\"Copiar\";s:4:\"Redo\";s:7:\"Rehacer\";s:6:\"Italic\";s:7:\"Cursiva\";s:11:\"Source code\";s:14:\"Código fuente\";s:9:\"Subscript\";s:10:\"Subíndice\";s:6:\"Indent\";s:7:\"Sangrar\";s:7:\"Outdent\";s:16:\"Sangria francesa\";s:6:\"Unlink\";s:11:\"Desvincular\";s:18:\"Interface language\";s:21:\"Idioma de la interfaz\";s:9:\"Underline\";s:9:\"Subrayado\";s:3:\"Cut\";s:6:\"Cortar\";s:5:\"Paste\";s:5:\"Pegar\";s:8:\"Example:\";s:8:\"Ejemplo:\";s:12:\"Teaser break\";s:17:\"Final del resumen\";s:18:\"Enabled by default\";s:31:\"Activado de forma prestablecida\";s:50:\"Show <em>enable/disable rich text</em> toggle link\";s:74:\"Mostrar enlace alternador de <em>activar/desactivar texto con formato</em>\";s:13:\"Use theme CSS\";s:17:\"Usar CSS del tema\";s:10:\"Define CSS\";s:11:\"Definir CSS\";s:18:\"Editor default CSS\";s:29:\"CSS predeterminado del editor\";s:43:\"Wysiwyg profile for %format has been saved.\";s:51:\"El perfil de Wysiwyg para %format ha sido guardado.\";s:17:\"Disable rich-text\";s:28:\"Desactivar texto enriquecido\";s:16:\"Enable rich-text\";s:25:\"Activar texto enriquecido\";s:10:\"Align left\";s:22:\"Alinear a la izquierda\";s:11:\"Align right\";s:20:\"Alinear a la derecha\";s:7:\"Justify\";s:11:\"Justificado\";s:15:\"Horizontal rule\";s:17:\"Línea horizontal\";s:10:\"Paste Text\";s:11:\"Pegar texto\";s:15:\"Paste from Word\";s:16:\"Pegar desde Word\";s:13:\"Remove format\";s:16:\"Eliminar formato\";s:13:\"Character map\";s:18:\"Mapa de caracteres\";s:17:\"HTML block format\";s:22:\"Formato de bloque HTML\";s:10:\"Font style\";s:16:\"Estilo de fuente\";s:14:\"Check spelling\";s:26:\"Comprobación ortográfica\";s:13:\"Left-to-right\";s:19:\"Izquierda a derecha\";s:13:\"Right-to-left\";s:19:\"Derecha a izquierda\";s:44:\"Separate the teaser and body of this content\";s:47:\"Separar el resumen del cuerpo de este contenido\";s:13:\"Div container\";s:14:\"Div contenedor\";s:8:\"Maximize\";s:9:\"Maximizar\";s:42:\"Text formats enabled for rich-text editing\";b:1;s:27:\"%editor profile for %format\";s:30:\"Perfil de %editor para %format\";s:14:\"page not found\";b:1;s:14:\"Strike through\";b:1;s:25:\"Insert/Remove Bullet list\";b:1;s:27:\"Insert/Remove Numbered list\";b:1;s:11:\"Block quote\";b:1;s:6:\"IFrame\";b:1;s:23:\"Spell check as you type\";b:1;s:9:\"Templates\";b:1;s:20:\"Texto longo e resumo\";b:1;s:25:\"Área de texto cun resumo\";b:1;s:11:\"Texto longo\";b:1;s:29:\"Área de texto (varias filas)\";b:1;s:23:\"Administer video styles\";b:1;s:45:\"Create and modify styles for embedded videos.\";b:1;s:11:\"video style\";b:1;s:12:\"video styles\";b:1;s:12:\"Video Styles\";b:1;s:12:\"Video Player\";b:1;s:12:\"URL to Video\";s:13:\"URL del video\";s:17:\"Thumbnail Preview\";b:1;s:15:\"Video Embedding\";b:1;s:5:\"White\";s:6:\"Blanco\";s:4:\"Blue\";s:4:\"Azul\";s:8:\"Autoplay\";s:15:\"Auto reproducir\";s:19:\"Show related videos\";b:1;s:4:\"Note\";s:4:\"Nota\";s:4:\"Loop\";s:5:\"Bucle\";s:4:\"Lime\";s:4:\"Lima\";s:6:\"Orange\";s:7:\"Naranja\";s:5:\"Light\";s:5:\"Claro\";s:9:\"Video URL\";s:14:\"URL del vídeo\";s:4:\"Dark\";s:6:\"Oscuro\";s:21:\"!label of field %name\";s:22:\"!label del campo %name\";s:17:\"Video Embed Field\";b:1;s:31:\"Video Embed Field configuration\";b:1;s:33:\"Video Embed Field module settings\";b:1;s:18:\"Video Embed Styles\";b:1;s:44:\"Administer Video Embed Field\'s video styles.\";b:1;s:18:\"Youtube v3 API key\";b:1;s:14:\"Enabled, title\";b:1;s:2:\"Up\";b:1;s:4:\"Down\";b:1;s:71:\"This will appear in the administrative interface to easily identify it.\";b:1;s:31:\"The unique ID for this @export.\";b:1;s:12:\"Player Width\";b:1;s:24:\"The width of the player.\";b:1;s:13:\"Player Height\";b:1;s:25:\"The height of the player.\";b:1;s:16:\"Player CSS class\";b:1;s:30:\"CSS class to add to the player\";b:1;s:18:\"@provider settings\";b:1;s:32:\"The width of the youtube player.\";b:1;s:33:\"The height of the youtube player.\";b:1;s:12:\"Player theme\";b:1;s:27:\"Play the video immediately.\";b:1;s:13:\"Video quality\";b:1;s:12:\"Small (240p)\";b:1;s:13:\"Medium (360p)\";b:1;s:12:\"Large (480p)\";b:1;s:7:\"HD 720p\";b:1;s:9:\"HD 10800p\";b:1;s:58:\"Attempt to play the video in certain quality if available.\";b:1;s:56:\"Show related videos after the video is finished playing.\";b:1;s:9:\"Show info\";b:1;s:17:\"Hide Youtube logo\";b:1;s:42:\"Hide the Youtube logo button on the player\";b:1;s:23:\"Show video annotations.\";b:1;s:23:\"Hide video annotations.\";b:1;s:19:\"Display annotations\";b:1;s:20:\"Hide video controls.\";b:1;s:37:\"Show video controls. Youtube default.\";b:1;s:67:\"Show video controls with performance improvement for iframe embeds.\";b:1;s:31:\"Display Youtube player controls\";b:1;s:72:\"This parameter indicates whether the video player controls will display.\";b:1;s:45:\"Autohide progress bar and the player controls\";b:1;s:62:\"Controls the autohide behavior of the youtube player controls.\";b:1;s:30:\"The width of the vimeo player.\";b:1;s:31:\"The height of the vimeo player.\";b:1;s:7:\"Fuschia\";b:1;s:12:\"Player Color\";b:1;s:37:\"The color to use on the vimeo player.\";b:1;s:24:\"Overlay Author Thumbnail\";b:1;s:58:\"Overlay the author\'s thumbnail before the video is played.\";b:1;s:21:\"Overlay Video\'s Title\";b:1;s:53:\"Overlay the video\'s title before the video is played.\";b:1;s:22:\"Overlay Video\'s Byline\";b:1;s:59:\"Overlay the video\'s description before the video is played.\";b:1;s:25:\"Loop the video\'s playback\";b:1;s:25:\"Enable froogaloop support\";b:1;s:42:\"Enables Froogallop Vimeo\'s library support\";b:1;s:17:\"Playback settings\";b:1;s:15:\"Administer IMCE\";s:16:\"Administrar IMCE\";s:10:\"Dimensions\";s:11:\"Dimensiones\";s:25:\"Permitted file extensions\";s:33:\"Extensiones de archivo permitidas\";s:9:\"User role\";s:14:\"Rol de usuario\";s:12:\"Profile name\";s:17:\"Nombre del perfil\";s:4:\"IMCE\";s:4:\"IMCE\";s:15:\"Common settings\";s:16:\"Opciones comunes\";s:6:\"Browse\";s:8:\"Explorar\";s:12:\"WIDTHxHEIGHT\";s:13:\"ANCHO × ALTO\";s:28:\"Maximum file size per upload\";s:38:\"Tamaño máximo de cada archivo subido\";s:12:\"File Browser\";s:22:\"Explorador de archivos\";s:11:\"Upload file\";s:13:\"Subir archivo\";s:9:\"unlimited\";s:11:\"sin límite\";s:24:\"Changes have been saved.\";s:28:\"Los cambios se han guardado.\";s:2:\"MB\";s:2:\"MB\";s:66:\"Your PHP settings limit the maximum file size per upload to %size.\";s:82:\"Su configuración de PHP limita a %size el tamaño máximo de cada archivo subido.\";s:42:\"Control how your image/file browser works.\";s:52:\"Controla cómo funciona su explorador de documentos.\";s:55:\"Enable inline image/file insertion into plain textareas\";s:75:\"Permitir la inserción de documentos e imágenes en áreas de texto simple.\";s:10:\"Thumbnails\";s:10:\"Miniaturas\";s:15:\"Add new profile\";s:20:\"Agregar nuevo perfil\";s:11:\"Directories\";s:11:\"Directorios\";s:12:\"File browser\";s:24:\"Explorador de documentos\";s:22:\"Configuration profiles\";s:26:\"Configuración de perfiles\";s:13:\"Absolute URLs\";s:14:\"URLs absolutas\";s:52:\"Check if you want IMCE to return absolute file URLs.\";s:78:\"Márquelo si quiere que IMCE proporcione las URLs absolutas de los documentos.\";s:56:\"Default behaviour for existing files during file uploads\";s:89:\"La conducta predefinida para los documentos ya existentes al subir documentos al servidor\";s:43:\"Keep the existing file renaming the new one\";s:53:\"Conservar el documento existente y renombrar el nuevo\";s:44:\"Keep the existing file rejecting the new one\";s:52:\"Conservar el documento existente y rechazar el nuevo\";s:42:\"Replace the existing file with the new one\";s:45:\"Remplazar el documento existente por el nuevo\";s:38:\"Default method for creating thumbnails\";s:49:\"El método predefinido de creación de miniaturas\";s:57:\"Scale the image with respect to the thumbnail dimensions.\";s:65:\"Escalar la imagen con respecto a las dimensiones de la miniatura.\";s:64:\"First scale then crop the image to fit the thumbnail dimensions.\";s:88:\"Primero escale y luego recorte la imagen para que encaje en las dimensiones de miniatura\";s:24:\"Role-profile assignments\";s:28:\"Asignaciones de rol y perfil\";s:28:\"Give a name to this profile.\";s:35:\"Ingrese un nombre para este perfil.\";s:15:\"Directory quota\";s:19:\"Cuota de directorio\";s:16:\"Total user quota\";s:23:\"Cuota total del usuario\";s:35:\"Set to * to remove the restriction.\";s:42:\"Ingrese * para eliminar las restricciones.\";s:37:\"Maximum number of files per operation\";s:43:\"Cantidad máxima de archivos por operación\";s:24:\"Including subdirectories\";s:25:\"Incluyendo subdirectorios\";s:14:\"Directory path\";s:19:\"Ruta del directorio\";s:39:\"The file has been renamed to %filename.\";s:43:\"El archivo se ha renombrado como %filename.\";s:38:\"Define the upload quota per directory.\";s:42:\"Definir la cuota de subida por directorio.\";s:32:\"Disable serving of private files\";s:42:\"Desactivar la entrega de archivos privados\";s:47:\"Display file browser tab in user profile pages.\";s:87:\"Mostrar la pestaña del explorador de archivos en las páginas de perfiles de usuarios.\";s:63:\"Dimensions must be specified in <kbd>WIDTHxHEIGHT</kbd> format.\";s:72:\"Las dimensiones se deben especificar en formato <kbd>ANCHO x ALTO</kbd>.\";s:35:\"Import settings from other profiles\";s:47:\"Importar la configuración desde otros perfiles\";s:52:\"%dirname is not accepted as a proper directory name.\";s:48:\"%dirname no es un nombre de directorio correcto.\";s:17:\"Create thumbnails\";s:16:\"Crear miniaturas\";s:14:\"Selected files\";s:24:\"Documentos seleccionados\";s:14:\"Width x Height\";s:13:\"Ancho × alto\";s:18:\"Create a new image\";s:18:\"Crear imagen nueva\";s:4:\"Tips\";s:8:\"Consejos\";s:65:\"Select a file by clicking the corresponding row in the file list.\";s:94:\"Seleccione un documento haciendo clic con el ratón sobre su nombre en la lista de documentos.\";s:60:\"Sort the files by clicking a column header of the file list.\";s:95:\"Ordene los documentos haciendo clic sobre el encabezado de la columna por la que desea ordenar.\";s:74:\"Resize the work-spaces by dragging the horizontal or vertical resize-bars.\";s:100:\"Redimensione las áreas de trabajo arrastrando las barras verticales u horizontales de redimensión.\";s:68:\"Keyboard shortcuts for file list: up, down, left, home, end, ctrl+A.\";s:114:\"Atajos de teclado (cursor) para las listas de documentos: Arriba, abajo, izquierda, derecha, inicio, fin y Ctrl+A.\";s:72:\"Keyboard shortcuts for directory list: up, down, left, right, home, end.\";s:97:\"Atajos de teclado para el listado de directorios: Arriba, Abajo, Izquierda, Drecha, Inicio y Fin.\";s:11:\"Limitations\";s:12:\"Limitaciones\";s:35:\"!num files using !dirsize of !quota\";s:42:\"!num documentos, usando !dirsize de !quota\";s:15:\"unlimited quota\";s:15:\"cuota ilimitada\";s:28:\"%filename has been uploaded.\";s:36:\"%filename ha sido subido al servidor\";s:24:\"Maximum image dimensions\";s:30:\"Dimensiones máximas de imagen\";s:44:\"Set to 0 to use the maximum value available.\";b:1;s:24:\"Enable on summary fields\";b:1;s:49:\"Attach the editor to summary fields of textareas.\";b:1;s:56:\"Uses the <a href=\"@url\">@setting</a> setting internally.\";b:1;s:30:\"Apply simple source formatting\";b:1;s:12:\"Paste plugin\";b:1;s:30:\"Settings for the paste plugin.\";b:1;s:25:\"Force paste as plain text\";b:1;s:23:\"Advanced Content Filter\";b:1;s:9:\"Automatic\";b:1;s:13:\"Content Rules\";b:1;s:35:\"Use default toolbar button grouping\";b:1;s:16:\"Download feature\";b:1;s:17:\"Add and configure\";b:1;s:12:\"Save and add\";b:1;s:6:\"Submit\";s:6:\"Enviar\";s:5:\"Write\";b:1;s:7:\"Restore\";s:9:\"Restaurar\";s:7:\"Rebuild\";b:1;s:12:\"@count bytes\";b:1;s:8:\"jsDelivr\";b:1;s:9:\"Bootstrap\";b:1;s:15:\"Bootstrap Theme\";b:1;s:19:\"Informative message\";b:1;s:45:\"Custom configuration and plugins for CKEditor\";b:1;s:33:\"Makes date/time fields available.\";s:50:\"Hace que los campos fecha/hora estén disponibles.\";s:45:\"A Date API that can be used by other modules.\";s:53:\"API de fechas que puede ser usada por otros módulos.\";s:42:\"Examples of migrating with the Date module\";s:46:\"Ejemplos de migración con el módulo de fecha\";s:73:\"A Date Repeat API to calculate repeating dates and times from iCal rules.\";s:88:\"Una Date Repeat API para calcular fechas y horas recurrentes a partir de reglas de iCal.\";s:52:\"Tools to import and auto-create dates and calendars.\";s:60:\"Herramientas para importar y autocrear fechas y calendarios.\";s:57:\"Views integration for date fields and date functionality.\";s:62:\"Integración de vistas para campos y funcionalidades de fecha.\";s:55:\"Filter to include videos from Youtube, Google video etc\";s:57:\"Filtro para incluir vídeos de Youtube, Google video etc.\";s:37:\"Provides a YouTube widget for fields.\";b:1;s:70:\"Provides Colorbox support to YouTube Field thumbnail display settings.\";b:1;s:9:\"Date/Time\";s:10:\"Fecha/Hora\";s:8:\"Features\";s:16:\"Características\";s:13:\"Input filters\";s:18:\"Filtros de entrada\";s:7:\"Youtube\";b:1;s:19:\"Referencia de termo\";b:1;s:43:\"Control de autocompretar termo (etiquetado)\";b:1;s:5:\"Imaxe\";b:1;s:17:\"Date (ISO format)\";b:1;s:21:\"Date (Unix timestamp)\";b:1;s:12:\"Date browser\";s:18:\"Navegador de fecha\";s:12:\"Page by date\";s:17:\"Página por fecha\";s:37:\"Page using the value of a date field.\";s:53:\"La página que utiliza el valor de un campo de fecha.\";s:18:\"Date browser style\";s:33:\"Estilo de navegación de fecha.¡\";s:29:\"Creates back/next navigation.\";s:33:\"Crea navegación atrás/adelante.\";s:8:\"End Date\";s:11:\"Fecha Final\";s:3:\"Now\";s:5:\"Ahora\";s:10:\"Start date\";s:15:\"Fecha de inicio\";s:8:\"End date\";s:11:\"Fecha final\";s:5:\"Plain\";s:5:\"Plano\";s:8:\"Duration\";s:9:\"Duración\";s:6:\"Change\";s:7:\"Cambiar\";s:16:\"Site\'s time zone\";s:22:\"Zona horaria del sitio\";s:16:\"Date\'s time zone\";s:24:\"Fecha de la zona horaria\";s:23:\"No time zone conversion\";s:34:\"Sin conversión de la zona horaria\";s:18:\"Time zone handling\";s:27:\"Tratamiento de zona horaria\";s:8:\"Date API\";s:8:\"Date API\";s:8:\"Relative\";s:8:\"Relativo\";s:9:\"strtotime\";s:9:\"strtotime\";s:16:\"User\'s time zone\";s:24:\"Zona horaria del usuario\";s:10:\"Date Popup\";s:20:\"Calendario emergente\";s:8:\"1 minute\";s:8:\"1 minuto\";s:5:\"Popup\";s:9:\"Emergente\";s:20:\"Show @count value(s)\";s:24:\"Mostrar @count valor(es)\";s:7:\"Undated\";s:10:\"Sin fechar\";s:13:\"Format: @date\";s:14:\"Formato: @date\";s:9:\"!timezone\";s:9:\"!timezone\";s:19:\"Custom input format\";s:32:\"Formato de entrada personalizado\";s:18:\"Date (!base_table)\";s:19:\"Fecha (!base_table)\";s:8:\"Display:\";s:8:\"Mostrar:\";s:16:\"Multiple values:\";b:1;s:22:\"starting from @isodate\";s:25:\"comenzando desde @isodate\";s:61:\"Show @count value(s) starting with @date1, ending with @date2\";s:66:\"Mostrar @count valor(es) empezando por @date1 y acabando en @date2\";s:8:\"earliest\";s:15:\"el más antiguo\";s:6:\"latest\";s:16:\"el más reciente\";s:8:\"5 minute\";s:9:\"5 minutos\";s:9:\"15 minute\";s:10:\"15 minutos\";s:17:\"Date field values\";s:23:\"Valores del campo fecha\";s:15:\"The date value.\";s:21:\"El valor de la fecha.\";s:15:\"Pop-up calendar\";s:22:\"Calendario desplegable\";s:19:\"The End date value.\";s:20:\"Valor de Fecha Final\";s:38:\"Choose how users view dates and times:\";s:68:\"Seleccione como los usuarios visualizaran las fechas y los horarios:\";s:24:\"Both Start and End dates\";s:28:\"Ambas fechas de inicio y fin\";s:15:\"Start date only\";s:22:\"Sólo fecha de inicio.\";s:13:\"End date only\";s:28:\"Sólo fecha de finalización\";s:38:\"Display dates using the @format format\";s:37:\"Mostrar fechas con el formato @format\";s:32:\"Display both Start and End dates\";s:42:\"Mostrar la fecha de inicio y finalización\";s:23:\"Display Start date only\";s:32:\"Mostrar sólo la fecha de inicio\";s:21:\"Display End date only\";s:39:\"Mostrar sólo la fecha de finalización\";s:9:\"10 minute\";s:10:\"10 minutos\";s:9:\"30 minute\";s:10:\"30 minutos\";s:24:\"!start-date to !end-date\";s:30:\"De !start-date hasta !end-date\";s:11:\"E.g., @date\";s:18:\"Por ejemplo, @date\";s:3:\"to:\";s:6:\"hasta:\";s:13:\"Select a date\";s:21:\"Seleccionar una fecha\";s:28:\"Position of date part labels\";s:35:\"Posición de las partes de la fecha\";s:13:\"Relative date\";s:14:\"Fecha relativa\";s:13:\"Show End Date\";s:19:\"Mostrar fecha final\";s:14:\"Default values\";s:23:\"Valores predeterminados\";s:25:\"Use ISO-8601 week numbers\";s:42:\"Usar los números de la semana de ISO-8601\";s:62:\"IMPORTANT! If checked, First day of week MUST be set to Monday\";s:75:\"¡IMPORTANTE! Si está marcado, el primer día de la semana debe ser lunes.\";s:20:\"ending with @isodate\";s:23:\"terminando con @isodate\";s:51:\"The duration of the time period given by the dates.\";s:56:\"La duración del período de tiempo dado por las fechas.\";s:34:\"Configure the Date Popup settings.\";s:42:\"Configure las opciones de fecha emergente.\";s:36:\"Tokens related to date field values.\";s:69:\"Patrones de reemplazo relacionados con los valores de campo de fecha.\";s:22:\"Relative default value\";s:29:\"Valor predeterminado relativo\";s:12:\"Default date\";s:20:\"Fecha predeterminada\";s:16:\"No default value\";s:24:\"Sin valor predeterminado\";s:16:\"Default end date\";s:37:\"Fecha de finalización predeterminada\";s:35:\"Relative default value for end date\";s:47:\"Valor relativo por defecto para la fecha de fin\";s:18:\"Date entry options\";s:28:\"Opciones de entrada de fecha\";s:54:\"Control the order and format of the options users see.\";s:74:\"Controla el orden y el formato de las opciones que se muestran al usuario.\";s:15:\"Time increments\";s:21:\"Incrementos de tiempo\";s:48:\"Select the date attributes to collect and store.\";s:56:\"Selecciona los atributos de fecha a recoger y almacenar.\";s:26:\"Date attributes to collect\";s:28:\"Atributos de fecha a recoger\";s:19:\"Collect an end date\";s:34:\"Recoger una fecha de finalización\";s:56:\"Select the timezone handling method for this date field.\";s:75:\"Seleccione la manera de controlar la zona horaria para este campo de fecha.\";s:57:\"Empty \'End date\' values will use the \'Start date\' values.\";s:83:\"Si se deja vacía la \"Fecha Final\", se utilizarán los datos de la fecha de inicio.\";s:22:\"@field_name Start date\";s:24:\"@field_name Fecha inicio\";s:20:\"@field_name End date\";s:23:\"@field_name Fecha final\";s:24:\"More settings and values\";s:30:\"Más configuraciones y valores\";s:10:\"Date entry\";s:16:\"Entrada de fecha\";s:24:\"Starting and ending year\";s:33:\"Año de inicio y de finalización\";s:13:\"Starting year\";s:14:\"Año de inicio\";s:65:\"Enter a relative value (-9, +9) or an absolute year such as 2015.\";s:68:\"Introduzca un valor relativo (-9, + 9) o un año absoluto como 2015.\";s:11:\"Ending year\";s:21:\"Año de finalización\";s:20:\"System date settings\";s:28:\"Configurar Fechas de sistema\";s:28:\"@label -  start date (!name)\";s:32:\"@label - fecha de inicio (!name)\";s:20:\"@label -  start date\";s:24:\"@label - fecha de inicio\";s:33:\"@label - end date (!name:!column)\";s:47:\"@label - fecha de finalización (!name:!column)\";s:25:\"@label - end date:!column\";s:39:\"@label - fecha de finalización:!column\";s:27:\"Date selection form element\";s:46:\"Elemento del formulario de selección de fecha\";s:18:\"Filter granularity\";s:24:\"Filtrar nivel de detalle\";s:19:\"Relative start date\";s:24:\"Fecha relativa de inicio\";s:17:\"Relative end date\";s:21:\"Fecha relativa de fin\";s:20:\"Same as Default date\";s:33:\"Igual que la fecha predeterminada\";s:11:\"Cache dates\";s:15:\"Fechas en cache\";s:23:\"Maximum dates per field\";s:24:\"Fechas maximas por campo\";s:72:\"The timezone has been set to <a href=\"@regional_settings\">@timezone</a>.\";s:80:\"La zona horaria se ha establecido a <a href=\"@regional_settings\"> @timezone</a>.\";s:11:\"@field_name\";s:11:\"@field_name\";s:25:\"Render as a regular field\";s:30:\"Presentar como un campo normal\";s:10:\"Date views\";b:1;s:34:\"Configure settings for date views.\";b:1;s:42:\"Settings for modules the use the Date API.\";b:1;s:8:\"Honduras\";b:1;s:14:\"Africa/Abidjan\";b:1;s:12:\"Africa/Accra\";b:1;s:18:\"Africa/Addis Ababa\";b:1;s:14:\"Africa/Algiers\";b:1;s:13:\"Africa/Asmara\";b:1;s:13:\"Africa/Bamako\";b:1;s:13:\"Africa/Bangui\";b:1;s:13:\"Africa/Banjul\";b:1;s:13:\"Africa/Bissau\";b:1;s:15:\"Africa/Blantyre\";b:1;s:18:\"Africa/Brazzaville\";b:1;s:16:\"Africa/Bujumbura\";b:1;s:12:\"Africa/Cairo\";b:1;s:17:\"Africa/Casablanca\";b:1;s:12:\"Africa/Ceuta\";b:1;s:14:\"Africa/Conakry\";b:1;s:12:\"Africa/Dakar\";b:1;s:20:\"Africa/Dar es Salaam\";b:1;s:15:\"Africa/Djibouti\";b:1;s:13:\"Africa/Douala\";b:1;s:15:\"Africa/El Aaiun\";b:1;s:15:\"Africa/Freetown\";b:1;s:15:\"Africa/Gaborone\";b:1;s:13:\"Africa/Harare\";b:1;s:19:\"Africa/Johannesburg\";b:1;s:11:\"Africa/Juba\";b:1;s:14:\"Africa/Kampala\";b:1;s:15:\"Africa/Khartoum\";b:1;s:13:\"Africa/Kigali\";b:1;s:15:\"Africa/Kinshasa\";b:1;s:12:\"Africa/Lagos\";b:1;s:17:\"Africa/Libreville\";b:1;s:11:\"Africa/Lome\";b:1;s:13:\"Africa/Luanda\";b:1;s:17:\"Africa/Lubumbashi\";b:1;s:13:\"Africa/Lusaka\";b:1;s:13:\"Africa/Malabo\";b:1;s:13:\"Africa/Maputo\";b:1;s:13:\"Africa/Maseru\";b:1;s:14:\"Africa/Mbabane\";b:1;s:16:\"Africa/Mogadishu\";b:1;s:15:\"Africa/Monrovia\";b:1;s:14:\"Africa/Nairobi\";b:1;s:15:\"Africa/Ndjamena\";b:1;s:13:\"Africa/Niamey\";b:1;s:17:\"Africa/Nouakchott\";b:1;s:18:\"Africa/Ouagadougou\";b:1;s:17:\"Africa/Porto-Novo\";b:1;s:15:\"Africa/Sao Tome\";b:1;s:14:\"Africa/Tripoli\";b:1;s:12:\"Africa/Tunis\";b:1;s:15:\"Africa/Windhoek\";b:1;s:12:\"America/Adak\";b:1;s:17:\"America/Anchorage\";b:1;s:16:\"America/Anguilla\";b:1;s:15:\"America/Antigua\";b:1;s:17:\"America/Araguaina\";b:1;s:30:\"America/Argentina/Buenos Aires\";b:1;s:27:\"America/Argentina/Catamarca\";b:1;s:25:\"America/Argentina/Cordoba\";b:1;s:23:\"America/Argentina/Jujuy\";b:1;s:26:\"America/Argentina/La Rioja\";b:1;s:25:\"America/Argentina/Mendoza\";b:1;s:30:\"America/Argentina/Rio Gallegos\";b:1;s:23:\"America/Argentina/Salta\";b:1;s:26:\"America/Argentina/San Juan\";b:1;s:26:\"America/Argentina/San Luis\";b:1;s:25:\"America/Argentina/Tucuman\";b:1;s:25:\"America/Argentina/Ushuaia\";b:1;s:13:\"America/Aruba\";b:1;s:16:\"America/Asuncion\";b:1;s:16:\"America/Atikokan\";b:1;s:13:\"America/Bahia\";b:1;s:22:\"America/Bahia Banderas\";b:1;s:16:\"America/Barbados\";b:1;s:13:\"America/Belem\";b:1;s:14:\"America/Belize\";b:1;s:20:\"America/Blanc-Sablon\";b:1;s:17:\"America/Boa Vista\";b:1;s:14:\"America/Bogota\";b:1;s:13:\"America/Boise\";b:1;s:21:\"America/Cambridge Bay\";b:1;s:20:\"America/Campo Grande\";b:1;s:14:\"America/Cancun\";b:1;s:15:\"America/Caracas\";b:1;s:15:\"America/Cayenne\";b:1;s:14:\"America/Cayman\";b:1;s:15:\"America/Chicago\";b:1;s:17:\"America/Chihuahua\";b:1;s:18:\"America/Costa Rica\";b:1;s:15:\"America/Creston\";b:1;s:14:\"America/Cuiaba\";b:1;s:15:\"America/Curacao\";b:1;s:20:\"America/Danmarkshavn\";b:1;s:14:\"America/Dawson\";b:1;s:20:\"America/Dawson Creek\";b:1;s:14:\"America/Denver\";b:1;s:15:\"America/Detroit\";b:1;s:16:\"America/Dominica\";b:1;s:16:\"America/Edmonton\";b:1;s:16:\"America/Eirunepe\";b:1;s:19:\"America/El Salvador\";b:1;s:19:\"America/Fort Nelson\";b:1;s:17:\"America/Fortaleza\";b:1;s:17:\"America/Glace Bay\";b:1;s:15:\"America/Godthab\";b:1;s:17:\"America/Goose Bay\";b:1;s:18:\"America/Grand Turk\";b:1;s:15:\"America/Grenada\";b:1;s:18:\"America/Guadeloupe\";b:1;s:17:\"America/Guatemala\";b:1;s:17:\"America/Guayaquil\";b:1;s:14:\"America/Guyana\";b:1;s:15:\"America/Halifax\";b:1;s:14:\"America/Havana\";b:1;s:18:\"America/Hermosillo\";b:1;s:28:\"America/Indiana/Indianapolis\";b:1;s:20:\"America/Indiana/Knox\";b:1;s:23:\"America/Indiana/Marengo\";b:1;s:26:\"America/Indiana/Petersburg\";b:1;s:25:\"America/Indiana/Tell City\";b:1;s:21:\"America/Indiana/Vevay\";b:1;s:25:\"America/Indiana/Vincennes\";b:1;s:23:\"America/Indiana/Winamac\";b:1;s:14:\"America/Inuvik\";b:1;s:15:\"America/Iqaluit\";b:1;s:15:\"America/Jamaica\";b:1;s:14:\"America/Juneau\";b:1;s:27:\"America/Kentucky/Louisville\";b:1;s:27:\"America/Kentucky/Monticello\";b:1;s:18:\"America/Kralendijk\";b:1;s:14:\"America/La Paz\";b:1;s:12:\"America/Lima\";b:1;s:19:\"America/Los Angeles\";b:1;s:21:\"America/Lower Princes\";b:1;s:14:\"America/Maceio\";b:1;s:15:\"America/Managua\";b:1;s:14:\"America/Manaus\";b:1;s:15:\"America/Marigot\";b:1;s:18:\"America/Martinique\";b:1;s:17:\"America/Matamoros\";b:1;s:16:\"America/Mazatlan\";b:1;s:17:\"America/Menominee\";b:1;s:14:\"America/Merida\";b:1;s:18:\"America/Metlakatla\";b:1;s:19:\"America/Mexico City\";b:1;s:16:\"America/Miquelon\";b:1;s:15:\"America/Moncton\";b:1;s:17:\"America/Monterrey\";b:1;s:18:\"America/Montevideo\";b:1;s:18:\"America/Montserrat\";b:1;s:14:\"America/Nassau\";b:1;s:16:\"America/New York\";b:1;s:15:\"America/Nipigon\";b:1;s:12:\"America/Nome\";b:1;s:15:\"America/Noronha\";b:1;s:27:\"America/North Dakota/Beulah\";b:1;s:27:\"America/North Dakota/Center\";b:1;s:30:\"America/North Dakota/New Salem\";b:1;s:15:\"America/Ojinaga\";b:1;s:14:\"America/Panama\";b:1;s:19:\"America/Pangnirtung\";b:1;s:18:\"America/Paramaribo\";b:1;s:15:\"America/Phoenix\";b:1;s:22:\"America/Port-au-Prince\";b:1;s:21:\"America/Port of Spain\";b:1;s:19:\"America/Porto Velho\";b:1;s:19:\"America/Puerto Rico\";b:1;s:19:\"America/Rainy River\";b:1;s:20:\"America/Rankin Inlet\";b:1;s:14:\"America/Recife\";b:1;s:14:\"America/Regina\";b:1;s:16:\"America/Resolute\";b:1;s:18:\"America/Rio Branco\";b:1;s:20:\"America/Santa Isabel\";b:1;s:16:\"America/Santarem\";b:1;s:16:\"America/Santiago\";b:1;s:21:\"America/Santo Domingo\";b:1;s:17:\"America/Sao Paulo\";b:1;s:20:\"America/Scoresbysund\";b:1;s:13:\"America/Sitka\";b:1;s:21:\"America/St Barthelemy\";b:1;s:16:\"America/St Johns\";b:1;s:16:\"America/St Kitts\";b:1;s:16:\"America/St Lucia\";b:1;s:17:\"America/St Thomas\";b:1;s:18:\"America/St Vincent\";b:1;s:21:\"America/Swift Current\";b:1;s:19:\"America/Tegucigalpa\";b:1;s:13:\"America/Thule\";b:1;s:19:\"America/Thunder Bay\";b:1;s:15:\"America/Tijuana\";b:1;s:15:\"America/Toronto\";b:1;s:15:\"America/Tortola\";b:1;s:17:\"America/Vancouver\";b:1;s:18:\"America/Whitehorse\";b:1;s:16:\"America/Winnipeg\";b:1;s:15:\"America/Yakutat\";b:1;s:19:\"America/Yellowknife\";b:1;s:16:\"Antarctica/Casey\";b:1;s:16:\"Antarctica/Davis\";b:1;s:25:\"Antarctica/DumontDUrville\";b:1;s:20:\"Antarctica/Macquarie\";b:1;s:17:\"Antarctica/Mawson\";b:1;s:18:\"Antarctica/McMurdo\";b:1;s:17:\"Antarctica/Palmer\";b:1;s:18:\"Antarctica/Rothera\";b:1;s:16:\"Antarctica/Syowa\";b:1;s:16:\"Antarctica/Troll\";b:1;s:17:\"Antarctica/Vostok\";b:1;s:19:\"Arctic/Longyearbyen\";b:1;s:9:\"Asia/Aden\";b:1;s:11:\"Asia/Almaty\";b:1;s:10:\"Asia/Amman\";b:1;s:11:\"Asia/Anadyr\";b:1;s:10:\"Asia/Aqtau\";b:1;s:11:\"Asia/Aqtobe\";b:1;s:13:\"Asia/Ashgabat\";b:1;s:12:\"Asia/Baghdad\";b:1;s:12:\"Asia/Bahrain\";b:1;s:9:\"Asia/Baku\";b:1;s:12:\"Asia/Bangkok\";b:1;s:11:\"Asia/Beirut\";b:1;s:12:\"Asia/Bishkek\";b:1;s:11:\"Asia/Brunei\";b:1;s:10:\"Asia/Chita\";b:1;s:15:\"Asia/Choibalsan\";b:1;s:12:\"Asia/Colombo\";b:1;s:13:\"Asia/Damascus\";b:1;s:10:\"Asia/Dhaka\";b:1;s:9:\"Asia/Dili\";b:1;s:10:\"Asia/Dubai\";b:1;s:13:\"Asia/Dushanbe\";b:1;s:9:\"Asia/Gaza\";b:1;s:11:\"Asia/Hebron\";b:1;s:16:\"Asia/Ho Chi Minh\";b:1;s:14:\"Asia/Hong Kong\";b:1;s:9:\"Asia/Hovd\";b:1;s:12:\"Asia/Irkutsk\";b:1;s:12:\"Asia/Jakarta\";b:1;s:13:\"Asia/Jayapura\";b:1;s:14:\"Asia/Jerusalem\";b:1;s:10:\"Asia/Kabul\";b:1;s:14:\"Asia/Kamchatka\";b:1;s:12:\"Asia/Karachi\";b:1;s:14:\"Asia/Kathmandu\";b:1;s:13:\"Asia/Khandyga\";b:1;s:12:\"Asia/Kolkata\";b:1;s:16:\"Asia/Krasnoyarsk\";b:1;s:17:\"Asia/Kuala Lumpur\";b:1;s:12:\"Asia/Kuching\";b:1;s:11:\"Asia/Kuwait\";b:1;s:10:\"Asia/Macau\";b:1;s:12:\"Asia/Magadan\";b:1;s:13:\"Asia/Makassar\";b:1;s:11:\"Asia/Manila\";b:1;s:11:\"Asia/Muscat\";b:1;s:12:\"Asia/Nicosia\";b:1;s:17:\"Asia/Novokuznetsk\";b:1;s:16:\"Asia/Novosibirsk\";b:1;s:9:\"Asia/Omsk\";b:1;s:9:\"Asia/Oral\";b:1;s:15:\"Asia/Phnom Penh\";b:1;s:14:\"Asia/Pontianak\";b:1;s:14:\"Asia/Pyongyang\";b:1;s:10:\"Asia/Qatar\";b:1;s:14:\"Asia/Qyzylorda\";b:1;s:12:\"Asia/Rangoon\";b:1;s:11:\"Asia/Riyadh\";b:1;s:13:\"Asia/Sakhalin\";b:1;s:14:\"Asia/Samarkand\";b:1;s:10:\"Asia/Seoul\";b:1;s:13:\"Asia/Shanghai\";b:1;s:14:\"Asia/Singapore\";b:1;s:18:\"Asia/Srednekolymsk\";b:1;s:11:\"Asia/Taipei\";b:1;s:13:\"Asia/Tashkent\";b:1;s:12:\"Asia/Tbilisi\";b:1;s:11:\"Asia/Tehran\";b:1;s:12:\"Asia/Thimphu\";b:1;s:10:\"Asia/Tokyo\";b:1;s:16:\"Asia/Ulaanbaatar\";b:1;s:11:\"Asia/Urumqi\";b:1;s:13:\"Asia/Ust-Nera\";b:1;s:14:\"Asia/Vientiane\";b:1;s:16:\"Asia/Vladivostok\";b:1;s:12:\"Asia/Yakutsk\";b:1;s:18:\"Asia/Yekaterinburg\";b:1;s:12:\"Asia/Yerevan\";b:1;s:15:\"Atlantic/Azores\";b:1;s:16:\"Atlantic/Bermuda\";b:1;s:15:\"Atlantic/Canary\";b:1;s:19:\"Atlantic/Cape Verde\";b:1;s:14:\"Atlantic/Faroe\";b:1;s:16:\"Atlantic/Madeira\";b:1;s:18:\"Atlantic/Reykjavik\";b:1;s:22:\"Atlantic/South Georgia\";b:1;s:18:\"Atlantic/St Helena\";b:1;s:16:\"Atlantic/Stanley\";b:1;s:18:\"Australia/Adelaide\";b:1;s:18:\"Australia/Brisbane\";b:1;s:21:\"Australia/Broken Hill\";b:1;s:16:\"Australia/Currie\";b:1;s:16:\"Australia/Darwin\";b:1;s:15:\"Australia/Eucla\";b:1;s:16:\"Australia/Hobart\";b:1;s:18:\"Australia/Lindeman\";b:1;s:19:\"Australia/Lord Howe\";b:1;s:19:\"Australia/Melbourne\";b:1;s:15:\"Australia/Perth\";b:1;s:16:\"Australia/Sydney\";b:1;s:16:\"Europe/Amsterdam\";b:1;s:14:\"Europe/Andorra\";b:1;s:13:\"Europe/Athens\";b:1;s:15:\"Europe/Belgrade\";b:1;s:13:\"Europe/Berlin\";b:1;s:17:\"Europe/Bratislava\";b:1;s:15:\"Europe/Brussels\";b:1;s:16:\"Europe/Bucharest\";b:1;s:15:\"Europe/Budapest\";b:1;s:15:\"Europe/Busingen\";b:1;s:15:\"Europe/Chisinau\";b:1;s:17:\"Europe/Copenhagen\";b:1;s:13:\"Europe/Dublin\";b:1;s:16:\"Europe/Gibraltar\";b:1;s:15:\"Europe/Guernsey\";b:1;s:15:\"Europe/Helsinki\";b:1;s:18:\"Europe/Isle of Man\";b:1;s:15:\"Europe/Istanbul\";b:1;s:13:\"Europe/Jersey\";b:1;s:18:\"Europe/Kaliningrad\";b:1;s:11:\"Europe/Kiev\";b:1;s:13:\"Europe/Lisbon\";b:1;s:16:\"Europe/Ljubljana\";b:1;s:13:\"Europe/London\";b:1;s:17:\"Europe/Luxembourg\";b:1;s:13:\"Europe/Madrid\";b:1;s:12:\"Europe/Malta\";b:1;s:16:\"Europe/Mariehamn\";b:1;s:12:\"Europe/Minsk\";b:1;s:13:\"Europe/Monaco\";b:1;s:13:\"Europe/Moscow\";b:1;s:11:\"Europe/Oslo\";b:1;s:12:\"Europe/Paris\";b:1;s:16:\"Europe/Podgorica\";b:1;s:13:\"Europe/Prague\";b:1;s:11:\"Europe/Riga\";b:1;s:11:\"Europe/Rome\";b:1;s:13:\"Europe/Samara\";b:1;s:17:\"Europe/San Marino\";b:1;s:15:\"Europe/Sarajevo\";b:1;s:17:\"Europe/Simferopol\";b:1;s:13:\"Europe/Skopje\";b:1;s:12:\"Europe/Sofia\";b:1;s:16:\"Europe/Stockholm\";b:1;s:14:\"Europe/Tallinn\";b:1;s:13:\"Europe/Tirane\";b:1;s:15:\"Europe/Uzhgorod\";b:1;s:12:\"Europe/Vaduz\";b:1;s:14:\"Europe/Vatican\";b:1;s:13:\"Europe/Vienna\";b:1;s:14:\"Europe/Vilnius\";b:1;s:16:\"Europe/Volgograd\";b:1;s:13:\"Europe/Warsaw\";b:1;s:13:\"Europe/Zagreb\";b:1;s:17:\"Europe/Zaporozhye\";b:1;s:13:\"Europe/Zurich\";b:1;s:19:\"Indian/Antananarivo\";b:1;s:13:\"Indian/Chagos\";b:1;s:16:\"Indian/Christmas\";b:1;s:12:\"Indian/Cocos\";b:1;s:13:\"Indian/Comoro\";b:1;s:16:\"Indian/Kerguelen\";b:1;s:11:\"Indian/Mahe\";b:1;s:15:\"Indian/Maldives\";b:1;s:16:\"Indian/Mauritius\";b:1;s:14:\"Indian/Mayotte\";b:1;s:14:\"Indian/Reunion\";b:1;s:12:\"Pacific/Apia\";b:1;s:16:\"Pacific/Auckland\";b:1;s:20:\"Pacific/Bougainville\";b:1;s:15:\"Pacific/Chatham\";b:1;s:13:\"Pacific/Chuuk\";b:1;s:14:\"Pacific/Easter\";b:1;s:13:\"Pacific/Efate\";b:1;s:17:\"Pacific/Enderbury\";b:1;s:15:\"Pacific/Fakaofo\";b:1;s:12:\"Pacific/Fiji\";b:1;s:16:\"Pacific/Funafuti\";b:1;s:17:\"Pacific/Galapagos\";b:1;s:15:\"Pacific/Gambier\";b:1;s:19:\"Pacific/Guadalcanal\";b:1;s:12:\"Pacific/Guam\";b:1;s:16:\"Pacific/Honolulu\";b:1;s:16:\"Pacific/Johnston\";b:1;s:18:\"Pacific/Kiritimati\";b:1;s:14:\"Pacific/Kosrae\";b:1;s:17:\"Pacific/Kwajalein\";b:1;s:14:\"Pacific/Majuro\";b:1;s:17:\"Pacific/Marquesas\";b:1;s:14:\"Pacific/Midway\";b:1;s:13:\"Pacific/Nauru\";b:1;s:12:\"Pacific/Niue\";b:1;s:15:\"Pacific/Norfolk\";b:1;s:14:\"Pacific/Noumea\";b:1;s:17:\"Pacific/Pago Pago\";b:1;s:13:\"Pacific/Palau\";b:1;s:16:\"Pacific/Pitcairn\";b:1;s:15:\"Pacific/Pohnpei\";b:1;s:20:\"Pacific/Port Moresby\";b:1;s:17:\"Pacific/Rarotonga\";b:1;s:14:\"Pacific/Saipan\";b:1;s:14:\"Pacific/Tahiti\";b:1;s:14:\"Pacific/Tarawa\";b:1;s:17:\"Pacific/Tongatapu\";b:1;s:12:\"Pacific/Wake\";b:1;s:14:\"Pacific/Wallis\";b:1;s:3:\"UTC\";b:1;s:24:\"Short date format: @date\";b:1;s:20:\"Calendario emerxente\";b:1;s:3:\"Mar\";b:1;s:5:\"Texto\";b:1;s:14:\"Campo de texto\";b:1;s:46:\"Integrate the FlexSlider 2 library with Drupal\";b:1;s:35:\"Sample implementation of FlexSlider\";b:1;s:44:\"Adds a display mode in Fields for FlexSlider\";b:1;s:40:\"Adds a Views style plugin for FlexSlider\";b:1;s:10:\"FlexSlider\";s:10:\"FlexSlider\";s:27:\"Show remaining days: @value\";b:1;s:32:\"Administer the FlexSlider module\";s:33:\"Administrar el módulo FlexSlider\";s:10:\"flexslider\";b:1;s:21:\"Version 2.0 installed\";b:1;s:26:\"Version %version installed\";s:27:\"Versión %version instalada\";s:29:\"FlexSlider library installed.\";b:1;s:9:\"optionset\";b:1;s:10:\"optionsets\";b:1;s:20:\"FlexSlider optionset\";b:1;s:21:\"FlexSlider optionsets\";b:1;s:43:\"Display the results in a FlexSlider widget.\";b:1;s:30:\"Administer FlexSlider presets.\";b:1;s:12:\"Video Filter\";s:16:\"Filtro de vídeo\";s:43:\"Substitutes [video:URL] with embedded HTML.\";s:50:\"Sustituir [video:URL] con código HTML incrustado.\";s:11:\"Archive.org\";s:11:\"Archive.org\";s:7:\"Blip.tv\";s:7:\"Blip.tv\";s:13:\"Candid Career\";b:1;s:6:\"Capped\";s:6:\"Capped\";s:13:\"College Humor\";s:13:\"College Humor\";s:4:\"Coub\";b:1;s:11:\"DailyMotion\";s:11:\"DailyMotion\";s:21:\"DemocracyNow Fullshow\";b:1;s:18:\"DemocracyNow Story\";b:1;s:17:\"Flickr Slideshows\";s:17:\"Flickr Slideshows\";s:12:\"Flickr Video\";s:16:\"Vídeo de Flickr\";s:8:\"Fox News\";b:1;s:13:\"Game Trailers\";s:13:\"Game Trailers\";s:11:\"Game Videos\";s:11:\"Game Videos\";s:5:\"Giphy\";b:1;s:7:\"GodTube\";s:7:\"GodTube\";s:12:\"Google Video\";s:12:\"Google Video\";s:9:\"Instagram\";b:1;s:9:\"Meta Cafe\";s:9:\"Meta Cafe\";s:7:\"Mail.Ru\";b:1;s:7:\"MySpace\";s:7:\"MySpace\";s:7:\"MyVideo\";b:1;s:17:\"Picasa Slideshows\";s:31:\"Pases de diapositivas de Picasa\";s:58:\"You must use the URL of the RSS feed for the Picasa album:\";b:1;s:70:\"View the album in Picasa (you should see thumbnails, not a slideshow).\";b:1;s:33:\"Find the \"RSS\" link and click it.\";b:1;s:62:\"Copy the resulting URL from the browser address bar.  Example:\";b:1;s:6:\"Rutube\";b:1;s:10:\"Slideshare\";s:10:\"Slideshare\";s:12:\"Streamhoster\";s:12:\"Streamhoster\";s:11:\"Teachertube\";s:11:\"Teachertube\";s:3:\"TED\";b:1;s:68:\"Click in Embed and copy the \"Link to this talk\" link and paste here.\";b:1;s:6:\"Twitch\";b:1;s:7:\"Ustream\";b:1;s:5:\"Vbox7\";b:1;s:5:\"Vimeo\";s:5:\"Vimeo\";s:4:\"Vine\";b:1;s:9:\"whatchado\";b:1;s:6:\"Wistia\";s:6:\"Wistia\";s:5:\"YouKu\";b:1;s:7:\"YouTube\";s:7:\"YouTube\";s:18:\"YouTube (Playlist)\";b:1;s:21:\"Default width setting\";s:19:\"Anchura predefinida\";s:22:\"Default height setting\";s:18:\"Altura predefinida\";s:24:\"Default autoplay setting\";s:26:\"Autoejecución predefinida\";s:43:\"Not all video formats support this setting.\";s:53:\"No todos los formatos de vídeo admiten esta opción.\";s:22:\"Related videos setting\";s:38:\"COnfiguración de vídeos relacionados\";s:66:\"Show \"related videos\"? Not all video formats support this setting.\";s:99:\"¿Mostrar los \'vídeos relacionados\'? No todos los formatos de vídeo admiten esta característica.\";s:9:\"Use HTML5\";s:10:\"Usar HTML5\";s:22:\"Allow multiple sources\";b:1;s:70:\"Allow the use of multiple sources (used source is selected at random).\";b:1;s:6:\"Codecs\";b:1;s:38:\"Choose which codecs will be available.\";b:1;s:12:\"Video filter\";s:16:\"Filtro de vídeo\";s:24:\"Videofilter instructions\";b:1;s:12:\"instructions\";b:1;s:12:\"Instructions\";s:13:\"Instrucciones\";s:22:\"Video filter dashboard\";b:1;s:38:\"You may insert videos with [video:URL]\";s:51:\"Puedes insertar vídeos usando la marca [video:URL]\";s:6:\"Manage\";b:1;s:11:\"Video Embed\";b:1;s:5:\"Video\";s:6:\"Vídeo\";s:34:\"Select the allowed video providers\";b:1;s:74:\"The description field allows users to enter a description about the video.\";b:1;s:22:\"Max description length\";b:1;s:19:\"Video style: @style\";b:1;s:48:\"Use field label as the label for the title field\";b:1;s:18:\"URL Display Cutoff\";b:1;s:8:\"Ligazón\";b:1;s:8:\"Booleano\";b:1;s:47:\"Caixas de selección sixelas activo/desactivado\";b:1;s:14:\"Enabled themes\";b:1;s:18:\"Bootstrap Settings\";b:1;s:9:\"Container\";b:1;s:15:\"Fluid container\";b:1;s:7:\"Buttons\";b:1;s:19:\"Default button size\";b:1;s:11:\"Extra Small\";b:1;s:5:\"Small\";s:8:\"Pequeño\";s:5:\"Large\";s:6:\"Grande\";s:16:\"Colorize Buttons\";b:1;s:15:\"Iconize Buttons\";b:1;s:5:\"Forms\";b:1;s:42:\"Make required elements display as an error\";b:1;s:38:\"Smart form descriptions (via Tooltips)\";b:1;s:49:\"\"Smart form descriptions\" maximum character limit\";b:1;s:45:\"\"Smart form descriptions\" allowed (HTML) tags\";b:1;s:6:\"Images\";b:1;s:19:\"Default image shape\";b:1;s:7:\"Rounded\";b:1;s:6:\"Circle\";b:1;s:9:\"Thumbnail\";b:1;s:17:\"Responsive Images\";b:1;s:6:\"Tables\";b:1;s:14:\"Bordered table\";b:1;s:48:\"Add borders on all sides of the table and cells.\";b:1;s:15:\"Condensed table\";b:1;s:57:\"Make tables more compact by cutting cell padding in half.\";b:1;s:10:\"Hover rows\";b:1;s:35:\"Enable a hover state on table rows.\";b:1;s:12:\"Striped rows\";b:1;s:17:\"Responsive tables\";b:1;s:10:\"Components\";b:1;s:11:\"Breadcrumbs\";b:1;s:21:\"Breadcrumb visibility\";b:1;s:19:\"Only in admin areas\";b:1;s:27:\"Show \"Home\" breadcrumb link\";b:1;s:30:\"Show current page title at end\";b:1;s:6:\"Navbar\";b:1;s:15:\"Navbar Position\";b:1;s:28:\"Select your Navbar position.\";b:1;s:10:\"Static Top\";b:1;s:9:\"Fixed Top\";b:1;s:12:\"Fixed Bottom\";b:1;s:20:\"Inverse navbar style\";b:1;s:44:\"Select if you want the inverse navbar style.\";b:1;s:10:\"Pagination\";b:1;s:42:\"Show \"First\" and \"Last\" links in the pager\";b:1;s:14:\".well (normal)\";b:1;s:16:\".well-sm (small)\";b:1;s:16:\".well-lg (large)\";b:1;s:12:\"Region wells\";b:1;s:10:\"JavaScript\";b:1;s:7:\"Anchors\";b:1;s:20:\"Fix anchor positions\";b:1;s:23:\"Enable smooth scrolling\";b:1;s:74:\"Animates page by scrolling to an anchor link target smoothly when clicked.\";b:1;s:64:\"Automatically remove error classes when values have been entered\";b:1;s:8:\"Popovers\";b:1;s:16:\"Enable popovers.\";b:1;s:7:\"animate\";b:1;s:43:\"Apply a CSS fade transition to the popover.\";b:1;s:4:\"HTML\";b:1;s:9:\"placement\";b:1;s:8:\"selector\";b:1;s:7:\"trigger\";b:1;s:27:\"How a popover is triggered.\";b:1;s:28:\"Auto-close on document click\";b:1;s:5:\"title\";b:1;s:55:\"Default title value if \"title\" attribute isn\'t present.\";b:1;s:5:\"delay\";b:1;s:9:\"container\";b:1;s:8:\"Tooltips\";b:1;s:15:\"Enable tooltips\";b:1;s:43:\"Apply a CSS fade transition to the tooltip.\";b:1;s:27:\"How a tooltip is triggered.\";b:1;s:58:\"Appends the tooltip to a specific element. Example: \"body\"\";b:1;s:37:\"Suppress jQuery version error message\";b:1;s:30:\"CDN (Content Delivery Network)\";b:1;s:4:\"NOTE\";b:1;s:12:\"CDN Provider\";b:1;s:19:\"Bootstrap @type URL\";b:1;s:28:\"Minified Bootstrap @type URL\";b:1;s:19:\"Bootstrap (default)\";b:1;s:6:\"1 hour\";b:1;s:34:\"Select bundles you want to export.\";b:1;s:6:\"Bundle\";s:7:\"Paquete\";s:17:\"No bundles found.\";b:1;s:33:\"Select fields you want to export.\";b:1;s:16:\"No fields found.\";b:1;s:8:\"Ficheiro\";b:1;s:51:\"Select the <em>%btype</em> which you want to clone.\";b:1;s:15:\"New Bundle Name\";b:1;s:50:\"Configure the advanced flexslider module settings.\";b:1;s:52:\"Usa <em>arquivos</em> para estudos e documentación.\";b:1;s:33:\"Respond.js integration for Drupal\";b:1;s:10:\"Responsive\";s:10:\"Responsivo\";s:23:\"View location directory\";b:1;s:24:\"View node location table\";b:1;s:24:\"View user location table\";b:1;s:25:\"Submit latitude/longitude\";b:1;s:13:\"View node map\";b:1;s:26:\"See the sitewide node map.\";b:1;s:13:\"View user map\";b:1;s:26:\"See the sitewide user map.\";b:1;s:26:\"View user location details\";b:1;s:63:\"See the users associated with markers on the sitewide user map.\";b:1;s:17:\"Create gmap macro\";b:1;s:62:\"Allows user to create a gmap macro for insertion into content.\";b:1;s:25:\"administer user locations\";s:34:\"administrar ubicaciones de usuario\";s:22:\"view own user location\";b:1;s:23:\"view all user locations\";b:1;s:21:\"set own user location\";b:1;s:11:\"Gmap Marker\";b:1;s:26:\"Choose a Gmap Marker icon.\";b:1;s:33:\"Store a location.module location.\";b:1;s:12:\"Location map\";s:18:\"Mapa de ubicación\";s:10:\"Author map\";s:14:\"Autor del mapa\";s:9:\"Small Red\";s:13:\"Pequeño rojo\";s:16:\"Small Bright red\";s:23:\"Pequeño rojo brillante\";s:12:\"Small Orange\";s:16:\"Pequeño naranja\";s:17:\"Small Pale Yellow\";s:25:\"Pequeño amarillo pálido\";s:12:\"Small Yellow\";s:17:\"Pequeño amarillo\";s:16:\"Small Pale Green\";s:22:\"Pequeño verde pálido\";s:11:\"Small Green\";s:14:\"Pequeño verde\";s:16:\"Small Dark Green\";s:21:\"Pequeño verde oscuro\";s:18:\"Small Flouro Green\";s:27:\"Pequeño verde fluorescente\";s:15:\"Small Pale Blue\";s:21:\"Pequeño azul pálido\";s:16:\"Small Light Blue\";s:19:\"Pequeño azul claro\";s:10:\"Small Blue\";s:13:\"Pequeño azul\";s:15:\"Small Dark Blue\";s:20:\"Pequeño azul oscuro\";s:12:\"Small Purple\";s:17:\"Pequeño púrpura\";s:10:\"Small Pink\";s:13:\"Pequeño rosa\";s:17:\"Small Bright Pink\";s:23:\"Pequeño rosa brillante\";s:11:\"Small Brown\";s:15:\"Pequeño marron\";s:11:\"Small White\";s:15:\"Pequeño blanco\";s:16:\"Small Light Gray\";s:19:\"Pequeño gris claro\";s:10:\"Small Gray\";s:13:\"Pequeño gris\";s:11:\"Small Black\";b:1;s:22:\"Small Blue (Alternate)\";s:27:\"Pequeño azul (alternativo)\";s:21:\"Small Red (Alternate)\";s:27:\"Pequeño rojo (alternativo)\";s:16:\"X marks the spot\";s:19:\"La X marca el lugar\";s:8:\"Big Blue\";s:11:\"Azul grande\";s:7:\"Big Red\";s:11:\"Rojo grande\";s:4:\"Gray\";s:4:\"Gris\";s:5:\"Green\";s:5:\"Verde\";s:10:\"Light Blue\";s:10:\"Azul claro\";s:4:\"Pink\";s:4:\"Rosa\";s:6:\"Purple\";s:8:\"Púrpura\";s:6:\"Yellow\";s:8:\"Amarillo\";s:4:\"Week\";s:6:\"Semana\";s:7:\"Letters\";s:6:\"Letras\";s:5:\"Blank\";s:6:\"Vacío\";s:7:\"Cluster\";s:5:\"Grupo\";s:11:\"Line Vertex\";b:1;s:7:\"Numbers\";s:8:\"Números\";s:5:\"Route\";s:4:\"Ruta\";s:16:\"Location chooser\";s:22:\"Selector de ubicación\";s:48:\"Used to activate location choosing using a gmap.\";b:1;s:16:\"Disable dragging\";s:23:\"Deshabilitar arrastrado\";s:16:\"Disable keyboard\";s:21:\"Desactivar el teclado\";s:31:\"Disable the keyboard shortcuts.\";s:33:\"Desactivar los atajos de teclado.\";s:17:\"Disable mousezoom\";s:43:\"Inhabilitar el acercamiento mediante ratón\";s:47:\"Disable using the scroll wheel to zoom the map.\";s:69:\"Inhabilitar el uso de la rueda de desplazamiento para acercar el mapa\";s:23:\"Disable Continuous Zoom\";b:1;s:12:\"Use AutoZoom\";s:13:\"Usar AutoZoom\";s:69:\"Automatically zoom the map to fit all markers when markers are added.\";s:96:\"Automáticamente zoom del mapa para caber todos los marcadores cuando se agregan los marcadores.\";s:39:\"Unconditionally enable marker interface\";b:1;s:19:\"Enable Overview Map\";s:32:\"Activar visión general del mapa\";s:53:\"Enable the \"overview map\" in the bottom right corner.\";s:69:\"Activar el \"visión general del mapa\" en la esquina inferior derecha.\";s:58:\"Work around bugs when maps appear in collapsible fieldsets\";s:73:\"Solucionar errores cuando mapas aparecen en conjuntos de campos plegables\";s:25:\"Add scale control to map.\";s:37:\"Añadir un control de escala al mapa.\";s:56:\"Adds a scale control to the map in the default position.\";s:68:\"Agrega un control de la escala del mapa en la posición por defecto.\";s:27:\"Enable extra marker events.\";b:1;s:24:\"Enable clickable shapes.\";b:1;s:28:\"Highlight marker on rollover\";b:1;s:60:\"Highlight marker by creating circle on mouse rollover event.\";b:1;s:4:\"GMap\";s:4:\"GMap\";s:23:\"Displays rows as a map.\";b:1;s:13:\"Extended GMap\";b:1;s:26:\"Displays a map of markers.\";b:1;s:2:\"px\";s:2:\"px\";s:6:\"Points\";s:6:\"Puntos\";s:7:\"Address\";s:10:\"Dirección\";s:8:\"Original\";s:8:\"Original\";s:10:\"Do nothing\";s:13:\"No hacer nada\";s:14:\"Default height\";s:16:\"Alto predefinido\";s:13:\"Default width\";s:17:\"Ancho predefinido\";s:20:\"Default map settings\";s:28:\"Ajustes por defecto del mapa\";s:14:\"Default center\";s:18:\"Centro determinado\";s:12:\"Default zoom\";s:19:\"Zoom predeterminado\";s:20:\"Default control type\";s:30:\"Tipo de control predeterminado\";s:16:\"Default map type\";s:27:\"Tipo de mapa predeterminado\";s:14:\"@name : @title\";s:14:\"@name : @title\";s:13:\"Marker action\";s:20:\"Acción del marcador\";s:9:\"Open link\";s:12:\"Abrir enlace\";s:14:\"Marker manager\";s:18:\"Gestor de marcador\";s:12:\"Maximum zoom\";s:12:\"Zoom máximo\";s:13:\"Track markers\";s:25:\"Seguimiento de marcadores\";s:15:\"Marker defaults\";s:35:\"Valores predeterminados de marcador\";s:12:\"Minimum zoom\";s:12:\"Zoom mínimo\";s:18:\"Clusterer settings\";s:27:\"Configuración de clusterer\";s:11:\"Activate on\";s:7:\"Activar\";s:10:\"Cluster on\";s:13:\"Se agrupan en\";s:7:\"at most\";b:1;s:6:\"Marker\";s:8:\"Marcador\";s:12:\"Stroke color\";s:15:\"Color del trazo\";s:13:\"Stroke weight\";s:17:\"Anchura del trazo\";s:10:\"Fill color\";s:16:\"Color de relleno\";s:14:\"User locations\";s:22:\"Ubicaciones de usuario\";s:14:\"Node locations\";s:19:\"Ubicaciones de nodo\";s:13:\"GMap Location\";s:15:\"Ubicación GMap\";s:5:\"Macro\";s:5:\"Macro\";s:11:\"Page header\";s:19:\"Cabecera de página\";s:11:\"Page footer\";s:14:\"Pie de página\";s:16:\"Markers per role\";s:18:\"Marcadores por rol\";s:13:\"Node settings\";s:16:\"Ajustes del nodo\";s:8:\"Latitude\";s:7:\"Latitud\";s:9:\"Longitude\";s:8:\"Longitud\";s:19:\"Google Maps API Key\";s:27:\"Clave de API de Google Maps\";s:21:\"Google Map Initialize\";s:29:\"Inicialización de Google Map\";s:39:\"The default zoom level of a Google map.\";s:52:\"El nivel de acercamiento por defecto del mapa Google\";s:18:\"Map Behavior flags\";s:28:\"Mapa comportamiento banderas\";s:45:\"Perform this action when a marker is clicked.\";s:61:\"Lleve a cabo esta acción cuando se haga clic en un marcador.\";s:16:\"Open info window\";s:29:\"Abrir ventana de información\";s:20:\"Default Line 1 Color\";s:32:\"Color por defecto de la línea 1\";s:20:\"Default Line 2 Color\";s:32:\"Color por defecto de la línea 2\";s:20:\"Default Line 3 Color\";s:32:\"Color por defecto de la línea 3\";s:25:\"Jef Poskanzer\'s Clusterer\";s:26:\"Clusterer de Jef Poskanzer\";s:19:\"Marker for clusters\";s:22:\"Marcador para clusters\";s:42:\"The marker to use when creating a cluster.\";s:44:\"El marcador a utilizar al crear un clúster.\";s:15:\"or more markers\";s:17:\"o más marcadores\";s:37:\"Minimal number of markers per cluster\";s:41:\"Número mínimo de marcadores por cluster\";s:13:\"Lines per box\";s:17:\"Lineas por cuadro\";s:5:\"lines\";s:7:\"líneas\";s:36:\"Maximum number of lines per info box\";s:50:\"Maximo numero de lineas por cuadro de información\";s:23:\"Configure GMap settings\";s:31:\"Configurar las opciones de GMap\";s:14:\"Stroke opacity\";s:18:\"Opacidad del trazo\";s:12:\"Fill opacity\";s:20:\"Opacidad del relleno\";s:33:\"Configure GMap Location settings.\";s:30:\"Configurar la ubicación GMap.\";s:32:\"Text at the top of the user map.\";s:47:\"Texto en la parte superior del mapa de usuario.\";s:35:\"Text at the bottom of the user map.\";s:50:\"El texto en la parte inferior del mapa de usuario.\";s:21:\"%role (Role ID: %rid)\";s:20:\"%role (Rol ID: %rid)\";s:24:\"Markers per content type\";s:30:\"Marcador por tipo de contenido\";s:66:\"Choose a marker to represent each type of content on the node map.\";s:77:\"Elija un marcador para representar cada tipo de contenido en el nodo de mapa.\";s:52:\"This content type is not currently Location enabled.\";s:70:\"Este tipo de contenido no tiene actualmente activada la localización.\";s:18:\"Build a GMap macro\";s:23:\"Construir un macro GMap\";s:9:\"Animation\";s:10:\"Animación\";s:11:\"Google Maps\";s:11:\"Google Maps\";s:10:\"Regenerate\";s:9:\"Regenerar\";s:20:\"Maximum initial zoom\";s:20:\"Zoom inicial máximo\";s:10:\"Popup mode\";s:13:\"Modo de Popup\";s:18:\"Clustering enabled\";s:23:\"Agrupamiento habilitado\";s:18:\"Title for clusters\";s:21:\"Título para clusters\";s:40:\"Javascript is required to view this map.\";s:42:\"Se requiere JavaScript para ver este mapa.\";s:16:\"Marker for %type\";s:19:\"Marcador para %type\";s:12:\"GMap markers\";s:15:\"Marcadores GMap\";s:11:\"GMap Marker\";s:13:\"Marcador GMap\";s:9:\"No Marker\";s:12:\"Sin marcador\";s:15:\"Highlight color\";s:17:\"Resaltar el color\";s:9:\"Grid Size\";s:24:\"Tamaño de la cuadricula\";s:19:\"Find Address on Map\";s:25:\"Buscar Dirección en Mapa\";s:5:\"Phone\";s:9:\"Teléfono\";s:5:\"Allow\";s:8:\"Permitir\";s:13:\"Location name\";s:23:\"Nombre de la ubicación\";s:11:\"Postal code\";s:14:\"Código postal\";s:14:\"State/Province\";s:16:\"Estado/Provincia\";s:11:\"Collapsible\";s:8:\"Plegable\";s:9:\"Collapsed\";s:7:\"Plegada\";s:10:\"Fax number\";s:14:\"Número de fax\";s:12:\"Phone number\";s:20:\"Número de teléfono\";s:14:\"Search options\";s:21:\"Opciones de búsqueda\";s:8:\"location\";s:10:\"ubicación\";s:16:\"Display Settings\";s:25:\"Opciones de presentación\";s:13:\"Main settings\";s:20:\"Opciones principales\";s:3:\"Fax\";s:3:\"Fax\";s:46:\"e.g. a place of business, venue, meeting point\";s:81:\"Por ejemplo: una sede comercial, un lugar de actuaciones, un punto de reunión...\";s:6:\"Street\";s:5:\"Calle\";s:10:\"Additional\";s:9:\"Adicional\";s:4:\"City\";s:6:\"Ciudad\";s:10:\"NOT LISTED\";s:10:\"NO LISTADO\";s:17:\"Geocoding options\";s:28:\"Opciones de geocodificación\";s:28:\"Settings for Location module\";s:37:\"Configuración del módulo Ubicación\";s:15:\"Street location\";s:22:\"Ubicación de la calle\";s:32:\"No service selected for country.\";s:43:\"No hay servicio seleccionado para el país.\";s:20:\"Locative information\";s:26:\"Información de ubicación\";s:19:\"Number of locations\";s:22:\"Número de ubicaciones\";s:34:\"Make the location box collapsible.\";s:36:\"Hacer plegable la caja de ubicación\";s:25:\"Default country selection\";s:34:\"Selección de país predeterminada\";s:23:\"Toggle location display\";s:36:\"Alternar presentación de ubicación\";s:33:\"Disable the display of locations.\";s:43:\"Desactivar la presentación de ubicaciones.\";s:32:\"Enable the display of locations.\";s:40:\"Activar la presentación de ubicaciones.\";s:47:\"Use a Google Map to set latitude and longitude \";s:64:\"Usar un Mapa de Google para establecer la latitud y la longitud \";s:11:\"Coordinates\";s:11:\"Coordenadas\";s:7:\"Website\";s:11:\"Página web\";s:8:\"Province\";s:9:\"Provincia\";s:7:\"Collect\";s:9:\"Recopilar\";s:12:\"Country Name\";s:16:\"Nombre del país\";s:11:\"Postal Code\";s:14:\"Código postal\";s:7:\"Require\";s:9:\"Requerido\";s:27:\"Maximum number of locations\";s:30:\"Número máximo de ubicaciones\";s:22:\"Location chooser macro\";s:33:\"Macro de selección de ubicación\";s:20:\"Enable JIT geocoding\";s:32:\"Activar geocodificación en masa\";s:3:\"Lid\";s:3:\"Lid\";s:38:\"The province of the selected location.\";s:43:\"La provincia de la ubicación seleccionada.\";s:41:\"The postal code of the selected location.\";s:48:\"El código postal de la ubicación seleccionada.\";s:37:\"The country of the selected location.\";s:39:\"El país de la ubicación seleccionada.\";s:38:\"The latitude of the selected location.\";s:41:\"La latitud de la ubicación seleccionada.\";s:39:\"The longitude of the selected location.\";s:41:\"La longitud de la ubicación seleccionada\";s:20:\"Distance / Proximity\";s:22:\"Distancia / Proximidad\";s:19:\"Current coordinates\";s:20:\"Coordenadas actuales\";s:39:\"Check this box to delete this location.\";s:48:\"Marque la casilla para eliminar esta ubicación.\";s:15:\"Location Fields\";s:23:\"Campos de localización\";s:13:\"Province name\";s:22:\"Nombre de la provincia\";s:12:\"Country name\";s:16:\"Nombre del país\";s:8:\"Map link\";s:13:\"Enlace a mapa\";s:27:\"Minimum number of locations\";s:30:\"Número mínimo de ubicaciones\";s:20:\"Location form weight\";s:33:\"Peso del formulario de ubicación\";s:14:\"Display Weight\";s:21:\"Peso de presentación\";s:12:\"RSS Settings\";s:12:\"Opciones RSS\";s:8:\"RSS mode\";s:8:\"Modo RSS\";s:20:\"W3C Geo (deprecated)\";s:23:\"W3C Geo (desaconsejado)\";s:13:\"GeoRSS-Simple\";s:13:\"GeoRSS-Simple\";s:10:\"GeoRSS GML\";s:10:\"GeoRSS GML\";s:14:\"Location Field\";s:19:\"Campo de ubicación\";s:6:\"Origin\";s:6:\"Origen\";s:24:\"Autofill empty locations\";b:1;s:67:\"Find and fill all empty locations with latitude and longtitude data\";b:1;s:35:\"Settings for Location Search module\";b:1;s:23:\"Regenerate marker cache\";b:1;s:18:\"Line default style\";b:1;s:67:\"Lines without a specific style defined will fall back to this style\";b:1;s:21:\"Polygon default style\";b:1;s:70:\"Polygons without a specific style defined will fall back to this style\";b:1;s:16:\"Show Pan control\";b:1;s:24:\"Show Street View control\";b:1;s:16:\"Map Type Control\";b:1;s:50:\"Standard (google.maps.MapTypeControlStyle.DEFAULT)\";b:1;s:63:\"Horizontal bar (google.maps.MapTypeControlStyle.HORIZONTAL_BAR)\";b:1;s:56:\"Dropdown (google.maps.MapTypeControlStyle.DROPDOWN_MENU)\";b:1;s:33:\"Enabled map types (\"base layers\")\";b:1;s:25:\"Map: Standard street map.\";b:1;s:60:\"The standard default street map. Internal name: G_NORMAL_MAP\";b:1;s:34:\"Satellite: Standard satellite map.\";b:1;s:69:\"Satellite view without street overlay. Internal name: G_SATELLITE_MAP\";b:1;s:29:\"Hybrid: Hybrid satellite map.\";b:1;s:63:\"Satellite view with street overlay. Internal name: G_HYBRID_MAP\";b:1;s:30:\"Terrain: Physical feature map.\";b:1;s:34:\"No manager (use GMap API directly)\";b:1;s:35:\"GMaps Utility Library MarkerManager\";b:1;s:37:\"GMaps Utility Library MarkerClusterer\";b:1;s:30:\"Martin Pearman\'s ClusterMarker\";b:1;s:25:\"Unmanaged marker settings\";b:1;s:44:\"There are no settings for unmanaged markers.\";b:1;s:22:\"MarkerManager settings\";b:1;s:67:\"Name of downloaded file in the thirdparty folder. Default: %default\";b:1;s:14:\"Border padding\";b:1;s:24:\"MarkerClusterer settings\";b:1;s:69:\"At this zoom and above, all markers will be shown without clustering.\";b:1;s:49:\"MarkerClusterer styles in JSON. Read description!\";b:1;s:15:\"Zoom to Cluster\";b:1;s:22:\"ClusterMarker settings\";b:1;s:33:\"Whether to use clustering or not.\";b:1;s:35:\"Maximum zoom for zooming to cluster\";b:1;s:71:\"When clicking on a cluster, the map will not zoom in farther than this.\";b:1;s:17:\"Intersect Padding\";b:1;s:19:\"Custom markers path\";b:1;s:51:\"Fill in your custom markers folder (absolute path).\";b:1;s:13:\"Bubble styles\";b:1;s:17:\"infobubble plugin\";b:1;s:18:\"Use custom bubble?\";b:1;s:69:\"If you don\'t intend to style your popup bubble, leave this unchecked.\";b:1;s:22:\"Bubble styles to apply\";b:1;s:18:\"Bubble styles help\";b:1;s:28:\"the infobubble documentation\";b:1;s:23:\"See !link for examples.\";b:1;s:60:\"Options: 0 (no shadow), 1 (default shadow), 2 (sharp shadow)\";b:1;s:49:\"Like the css property, the padding of the bubble.\";b:1;s:58:\"Like the css property, the radius of the bubble\'s corners.\";b:1;s:57:\"Like the css property, the width in pixels of the border.\";b:1;s:58:\"Like the css property, the hex or rgb color of the border.\";b:1;s:34:\"A css class for the entire bubble.\";b:1;s:55:\"Like the css property, the minimum width of the bubble.\";b:1;s:55:\"Like the css property, the maximum width of the bubble.\";b:1;s:56:\"Like the css property, the maximum height of the bubble.\";b:1;s:68:\"The percent from the left of the bubble where the arrow will appear.\";b:1;s:62:\"The url of the image to use as the close button for the bubble\";b:1;s:68:\"Like the css property, the z-index of the close image. Default is 0.\";b:1;s:47:\"The height of the close image. Default is 12px.\";b:1;s:46:\"The width of the close image. Default is 12px.\";b:1;s:73:\"Like the css property, the position the close image. Default is absolute.\";b:1;s:29:\"Thickness of line, in pixels.\";b:1;s:57:\"Hex color value for fill color. Example: #<em>00AA33</em>\";b:1;s:32:\"Opacity of fill, from 0 to 100%.\";b:1;s:28:\"User Map (<em>map/user</em>)\";b:1;s:28:\"Node Map (<em>map/node</em>)\";b:1;s:32:\"Text at the top of the node map.\";b:1;s:35:\"Text at the bottom of the node map.\";b:1;s:16:\"Province display\";b:1;s:27:\"Display full province name.\";b:1;s:28:\"Display province/state code.\";b:1;s:27:\"Open map link in new window\";b:1;s:65:\"Select this if you want the map link to open in a separate window\";b:1;s:25:\"Open in new window method\";b:1;s:9:\"Map links\";b:1;s:18:\"Location utilities\";b:1;s:27:\"Tokens related to location.\";b:1;s:13:\"Location Name\";b:1;s:19:\"State/Province Name\";b:1;s:27:\"The location for this node.\";b:1;s:27:\"The location for this user.\";b:1;s:12:\"Marker title\";b:1;s:10:\"Marker key\";b:1;s:17:\"Default (address)\";b:1;s:16:\"Address with map\";b:1;s:8:\"Map only\";b:1;s:37:\"Multiple field values on a single map\";b:1;s:38:\"Google Maps geocoding minimum accuracy\";b:1;s:16:\"Unknown location\";b:1;s:22:\"Country level accuracy\";b:1;s:57:\"Region (state, province, prefecture, etc.) level accuracy\";b:1;s:54:\"Sub-region (county, municipality, etc.) level accuracy\";b:1;s:35:\"Town (city, village) level accuracy\";b:1;s:35:\"Post code (zip code) level accuracy\";b:1;s:21:\"Street level accuracy\";b:1;s:27:\"Intersection level accuracy\";b:1;s:22:\"Address level accuracy\";b:1;s:20:\"Clear province cache\";b:1;s:28:\"Clear supported country list\";b:1;s:34:\"Use map to pick search coordinates\";b:1;s:25:\"Requires the gmap module.\";b:1;s:41:\"Add geocoding address field to search map\";b:1;s:20:\"Macro for search map\";b:1;s:54:\"Enable choosing a marker for terms in this vocabulary.\";b:1;s:58:\"The number of locations that are required to be filled in.\";b:1;s:55:\"The maximum number of locations that can be associated.\";b:1;s:45:\"Number of locations that can be added at once\";b:1;s:56:\"The number of empty location forms to show when editing.\";b:1;s:19:\"Collection settings\";b:1;s:35:\"Display the location box collapsed.\";b:1;s:18:\"Coordinate Chooser\";b:1;s:10:\"www adress\";b:1;s:24:\"Hide fields from display\";b:1;s:14:\"Do not collect\";b:1;s:13:\"Force Default\";b:1;s:31:\"Display location in teaser view\";b:1;s:29:\"Display location in full view\";b:1;s:66:\"Here, you can change how locative data affects RSS feeds on nodes.\";b:1;s:63:\"Select how to use locations in RSS feeds for this content type.\";b:1;s:46:\"None (Do not put locational data in RSS feeds)\";b:1;s:39:\"Location 1.x-2.x compatible (buggy W3C)\";b:1;s:17:\"Territorio Muller\";b:1;s:18:\"gmap_macro_builder\";b:1;s:40:\"Add another location from node view page\";b:1;s:64:\"Display the \"Add another location\" option on the node view page.\";b:1;s:29:\"Location module form elements\";b:1;s:57:\"Usa <em>lugares</em> para engadir hoteis, restaurantes...\";b:1;s:17:\"Location #%number\";s:22:\"Localización #%number\";s:19:\"GMap Macro expander\";b:1;s:50:\"GMap macros will be displayed as interactive maps.\";b:1;s:22:\"Administer Easy Social\";s:23:\"Administrar Easy Social\";s:28:\"Configure Easy Social module\";b:1;s:22:\"Use Easy Social Wizard\";b:1;s:29:\"Access the Easy Social Wizard\";b:1;s:20:\"Easy Social Settings\";b:1;s:43:\"Configure the social buttons and node types\";b:1;s:18:\"Easy Social Wizard\";b:1;s:49:\"Quickly enable Easy Social for your Content Types\";b:1;s:46:\"Flexible voting options for nodes and comments\";b:1;s:38:\"Add an expiration time to rate widgets\";b:1;s:24:\"Add a slider widget type\";b:1;s:21:\"Administer Voting API\";s:22:\"Administrar Voting API\";s:22:\"View rate results page\";s:52:\"Visualizar la página de resultados de calificación\";s:11:\"Rate widget\";b:1;s:28:\"A rate widget for this node.\";b:1;s:31:\"Easy Social Global Ignore Paths\";b:1;s:30:\"Easy Social Global Widget Type\";b:1;s:26:\"Easy Social Global Widgets\";b:1;s:24:\"Easy Social Widget Order\";b:1;s:42:\"Enable Easy Social for nodes of type %type\";b:1;s:54:\"Enable Easy Social on comments for nodes of type %type\";b:1;s:52:\"Number of Easy Social fields for nodes of type %type\";b:1;s:42:\"Easy Social Widget type for nodes of %type\";b:1;s:38:\"Easy Social Widgets for nodes of %type\";b:1;s:28:\"Number of Easy Social blocks\";b:1;s:32:\"Override settings for this block\";b:1;s:11:\"Widget Type\";b:1;s:15:\"Enabled Widgets\";b:1;s:34:\"Easy Social Global Mention Account\";b:1;s:34:\"Easy Social Global Related Account\";b:1;s:38:\"Easy Social Global Twitter Description\";b:1;s:44:\"Easy Social Global Twitter Show Count option\";b:1;s:23:\"Facebook Application ID\";b:1;s:20:\"Facebook widget type\";b:1;s:24:\"Send Button (XFBML Only)\";b:1;s:10:\"Show faces\";b:1;s:15:\"Verb to display\";b:1;s:12:\"Color Scheme\";s:23:\"Combinación de Colores\";s:10:\"Annotation\";b:1;s:18:\"HTML5 valid syntax\";b:1;s:45:\"Easy Social Global LinkedIn Show Count option\";b:1;s:22:\"Easy Social Block !num\";b:1;s:11:\"Immediately\";s:14:\"Inmediatamente\";s:10:\"Voting API\";s:16:\"API de votación\";s:13:\"Vote tallying\";s:17:\"Recuento de votos\";s:37:\"Tally results whenever a vote is cast\";s:50:\"Recontar resultados siempre que se efectue un voto\";s:26:\"Tally results at cron-time\";s:36:\"Recontar resultados al ejecutar cron\";s:23:\"Anonymous vote rollover\";s:28:\"Vuelta de votación anónima\";s:12:\"Vote results\";s:19:\"Resultados de votos\";s:37:\"The value of an individual cast vote.\";s:39:\"El valor de un voto individual emitido.\";s:60:\"The nature of the vote being cast (points, percentage, etc).\";s:57:\"La naturaleza del voto emitido (puntos, porcentaje, etc).\";s:46:\"An optional tag to group multi-criteria votes.\";s:65:\"Una etiqueta opcional para agrupar votos de múltiples criterios.\";s:27:\"The user who cast the vote.\";s:31:\"El usuario que emitió el voto.\";s:16:\"Individual voter\";s:18:\"Votante individual\";s:49:\"Restrict votes to those cast by the current user.\";s:63:\"Restringir los votos a aquellos emitidos por el usuario actual.\";s:45:\"The IP address of the user who cast the vote.\";s:49:\"La dirección IP del usuario que emitió el voto.\";s:27:\"The time the vote was cast.\";s:35:\"La hora en que fue emitido el voto.\";s:64:\"The nature of the results in question (points, percentage, etc).\";s:71:\"La naturaleza de los resultados en cuestión (puntos, porcentaje, etc).\";s:48:\"An optional tag to group multi-criteria results.\";s:64:\"Una etiqueta opcional para el grupo de resultados multicriterio.\";s:52:\"The aggregate function used to calculate the result.\";s:64:\"La función de agregación utilizado para calcular el resultado.\";s:37:\"The time the results were calculated.\";s:48:\"La hora en que fueron calculados los resultados.\";s:65:\"Configure sitewide settings for user-generated ratings and votes.\";s:87:\"Configurar las opciones generales de calificaciones y votos generados por los usuarios.\";s:7:\"Compact\";s:8:\"Compacto\";s:8:\"Fivestar\";s:8:\"Fivestar\";s:12:\"Node display\";s:21:\"Presentación de nodo\";s:21:\"Machine readable name\";s:22:\"Nombre para el sistema\";s:10:\"Percentage\";s:10:\"Porcentaje\";s:17:\"Display in teaser\";s:27:\"Mostrar en la vista resumen\";s:17:\"Above the content\";s:20:\"Encima del contenido\";s:17:\"Below the content\";s:20:\"Debajo del contenido\";s:53:\"Select the node types on which to enable this widget.\";s:64:\"Seleccionar los tipos de nodos en los que habilitar este widget.\";s:12:\"Rate widgets\";s:24:\"Widgets de calificación\";s:22:\"Manage rating widgets.\";s:40:\"Administrar los widgets de calificación\";s:10:\"Add widget\";s:15:\"Agregar control\";s:45:\"You do not have any rate widgets defined yet.\";s:57:\"No se han definido todavía los widgets de calificación.\";s:24:\"Do not add automatically\";s:27:\"No añadir automáticamente\";s:9:\"Thumbs up\";s:15:\"Pulgares arriba\";s:16:\"Thumbs up / down\";s:23:\"Pulgares arriba / abajo\";s:16:\"You voted !vote.\";s:18:\"Usted votó !vote.\";s:14:\"Voting results\";s:24:\"Resultados de votaciones\";s:34:\"Redirect to login and show message\";s:53:\"Redireccionar a la página de login y mostrar mensaje\";s:43:\"Redirect to login but do not show a message\";s:59:\"Redireccionar a la página de login pero no mostrar mensaje\";s:51:\"Show a disabled widget (with non clickable buttons)\";s:59:\"Mostrar un widget deshabilitado (con botones inutilizables)\";s:11:\"Hide widget\";s:15:\"Esconder widget\";s:45:\"Behaviour when user has no permission to vote\";s:60:\"Comportamiento cuando el usuario no tiene permiso para votar\";s:42:\"Allow author to rate his / her own content\";s:50:\"Permitir a los autores valorar su propio contenido\";s:67:\"Will change the state to disabled. Always true for anonymous users.\";s:86:\"Cambiará el estado a deshabilitado. Es siempre verdadero para los usuarios anónimos.\";s:16:\"Number up / down\";b:1;s:7:\"Emotion\";b:1;s:8:\"Yes / no\";b:1;s:6:\"Slider\";b:1;s:20:\"Easy Social settings\";b:1;s:18:\"Enable Easy Social\";b:1;s:61:\"Check this option to enable easy social for this content type\";b:1;s:28:\"Number of Easy Social fields\";b:1;s:15:\"Type of buttons\";b:1;s:14:\"Social Widgets\";b:1;s:13:\"Extra Widgets\";b:1;s:26:\"Extra settings for widgets\";b:1;s:21:\"Extra Widget Settings\";b:1;s:8:\"Facebook\";s:8:\"Facebook\";s:27:\"Extra settings for Facebook\";b:1;s:7:\"Google+\";s:7:\"Google+\";s:26:\"Extra settings for Google+\";b:1;s:8:\"LinkedIn\";s:8:\"LinkedIn\";s:27:\"Extra settings for LinkedIn\";b:1;s:7:\"Twitter\";s:7:\"Twitter\";s:26:\"Extra settings for Twitter\";b:1;s:12:\"Ignore Paths\";b:1;s:53:\"Global paths to ignore and do not display Easy Social\";b:1;s:19:\"Easy Social Summary\";b:1;s:12:\"Widget Order\";b:1;s:13:\"Bot detection\";b:1;s:18:\"1 minute threshold\";b:1;s:16:\"1 hour threshold\";b:1;s:20:\"BotScout.com API key\";b:1;s:36:\"Define the available voting buttons.\";b:1;s:18:\"Add another option\";b:1;s:17:\"Translate options\";b:1;s:11:\"Full widget\";b:1;s:12:\"Display only\";b:1;s:21:\"Display only, compact\";b:1;s:23:\"Appearance in full node\";b:1;s:20:\"Appearance in teaser\";b:1;s:22:\"Appearance in comments\";b:1;s:62:\"Optional description which will be visible on the rate widget.\";b:1;s:23:\"Display in compact mode\";b:1;s:11:\"Interaction\";b:1;s:14:\"Average rating\";b:1;s:40:\"Users vote if available, empty otherwise\";b:1;s:42:\"Users vote if available, average otherwise\";b:1;s:33:\"Which rating should be displayed?\";b:1;s:10:\"Users vote\";b:1;s:58:\"Which rating should be displayed when the user just voted?\";b:1;s:57:\"Should a second click on the same button delete the vote?\";b:1;s:36:\"Example: the Facebook \"Like\" button.\";b:1;s:22:\"Use source translation\";b:1;s:26:\"The widget has been saved.\";b:1;s:34:\"Display Easy Social share widgets.\";b:1;s:9:\"Slideshow\";s:29:\"Presentación de diapositivas\";s:8:\"Previous\";s:8:\"Anterior\";s:4:\"Move\";s:5:\"Mover\";s:4:\"Sync\";s:15:\"Sincronización\";s:6:\"Linear\";s:6:\"Lineal\";s:8:\"Selector\";s:8:\"Selector\";s:4:\"Fade\";s:10:\"Desvanecer\";s:5:\"Slide\";s:8:\"Deslizar\";s:15:\"Animation Speed\";s:23:\"Velocidad de animación\";s:17:\"Enable debug mode\";s:27:\"Activar modo de depuración\";s:16:\"Advanced Options\";s:18:\"Opciones avanzadas\";s:9:\"Namespace\";s:18:\"Espacio de nombres\";s:5:\"Pause\";s:5:\"Pausa\";s:15:\"Slideshow speed\";s:27:\"Velocidad de la diapositiva\";s:40:\"General Slideshow and Animation Settings\";s:52:\"Presentación general y configuración de animación\";s:26:\"Select your animation type\";s:32:\"Seleccione el tipo de animación\";s:44:\"Set the speed of animations, in milliseconds\";s:56:\"Ajustar la velocidad de las animaciones, en milisegundos\";s:56:\"Select the sliding direction, \"horizontal\" or \"vertical\"\";s:69:\"Seleccione la dirección de desplazamiento, \"horizontal\" o \"vertical\"\";s:32:\"Animate the slides automatically\";s:40:\"Animar las diapositivas automáticamente\";s:41:\"Add controls for previous/next navigation\";s:51:\"Agregar controles de navegación anterior/siguiente\";s:19:\"Keyboard Navigation\";s:31:\"Navegación mediante el teclado\";s:21:\"Mousewheel Navigation\";s:35:\"Navegación con la rueda del ratón\";s:24:\"Add Pause/Play Indicator\";s:40:\"Añadir indicador de pausa/reproducción\";s:17:\"Pause On Controls\";s:18:\"Pausa en controles\";s:26:\"Manual controls (Advanced)\";s:29:\"Controles manuales (avanzado)\";s:6:\"Insert\";s:8:\"Insertar\";s:12:\"Insert Video\";s:15:\"Insertar vídeo\";s:30:\"Enable Easy Social on comments\";b:1;s:72:\"Check this option to enable easy social for this content type\'s comments\";b:1;s:16:\"Easy Social !num\";b:1;s:25:\"Access Backup and Migrate\";s:28:\"Acceder a Backup and Migrate\";s:44:\"Access the Backup and Migrate admin section.\";s:62:\"Acceder a la sección de administración de Backup and Migrate\";s:16:\"Perform a backup\";s:31:\"Realizar una copia de seguridad\";s:39:\"Back up any of the available databases.\";s:73:\"Hacer copia de seguridad de cualquiera de las bases de datos disponibles.\";s:19:\"Access backup files\";s:44:\"Acceder a los archivos de copia de seguridad\";s:56:\"Access and download the previously created backup files.\";s:75:\"Acceder y descargar los archivos de copia de seguridad creados previamente.\";s:19:\"Delete backup files\";s:38:\"Eliminar achivos de copia de seguridad\";s:43:\"Delete the previously created backup files.\";s:66:\"Eliminar los archivos de copia de seguridad creados anteriormente.\";s:16:\"Restore the site\";s:18:\"Restaurar el sitio\";s:47:\"Restore the site\'s database from a backup file.\";s:76:\"Restaurar la base de datos del sitio desde un archivo de copia de seguridad.\";s:29:\"Administer Backup and Migrate\";s:30:\"Administrar Backup and Migrate\";s:61:\"Edit Backup and Migrate profiles, schedules and destinations.\";s:78:\"Editar los perfiles, las planificaciones y los destinos de Backup and Migrate.\";s:17:\"Untitled Schedule\";s:27:\"Tarea programada sin nombre\";s:9:\"Schedules\";s:18:\"Tareas programadas\";s:8:\"Schedule\";s:16:\"Tarea programada\";s:16:\"Server Directory\";s:23:\"Directorio del servidor\";s:61:\"Save the backup files to the NodeSquirrel.com backup service.\";s:88:\"Guarde los archivos de copia de seguridad para el servicio de respaldo NodeSquirrel.com.\";s:16:\"NodeSquirrel.com\";s:16:\"NodeSquirrel.com\";s:58:\"Save the backup files to any a directory on an FTP server.\";s:57:\"Guardar los archivos en un directorio de un servidor FTP.\";s:13:\"FTP Directory\";s:14:\"Directorio FTP\";s:17:\"Amazon S3 account\";s:16:\"Cuenta Amazon S3\";s:48:\"Save the backup files to a bucket on your !link.\";s:69:\"Guardar los archivos de copia de seguridad en un espacio en su !link.\";s:16:\"Amazon S3 Bucket\";s:22:\"Depósito S3 de Amazon\";s:70:\"Send the backup as an email attachment to the specified email address.\";s:118:\"Enviar la copia de seguridad como archivo adjunto en un correo a las direcciones de correo electrónico especificadas.\";s:8:\"Database\";s:13:\"Base de datos\";s:14:\"MySQL Database\";s:19:\"Base de datos MySQL\";s:46:\"A files directory which can be backed up from.\";s:67:\"Un directorio de archivos desde el cual se puede hacer el respaldo.\";s:14:\"File Directory\";s:22:\"Directorio de archivos\";s:38:\"Create an archive of your entire site.\";s:38:\"Crear un archivo de su sitio completo.\";s:12:\"Site Archive\";s:17:\"Archivo del sitio\";s:12:\"Destinations\";s:8:\"Destinos\";s:11:\"Destination\";s:7:\"Destino\";s:24:\"Manual Backups Directory\";s:42:\"Directorio de copias de seguridad manuales\";s:27:\"Scheduled Backups Directory\";s:45:\"Directorio de copias de seguridad programadas\";s:12:\"NodeSquirrel\";s:12:\"NodeSquirrel\";s:14:\"No Compression\";s:15:\"Sin Compresión\";s:4:\"GZip\";s:4:\"GZip\";s:4:\"BZip\";s:4:\"BZip\";s:16:\"Default Database\";s:28:\"Base de datos predeterminada\";s:22:\"Public Files Directory\";s:32:\"Directorio de archivos públicos\";s:23:\"Private Files Directory\";s:31:\"Directorio de archivos privados\";s:30:\"Entire Site (code, files & DB)\";s:50:\"Sitio completo (código, archivos y base de datos)\";s:16:\"Untitled Profile\";s:17:\"Perfil sin nombre\";s:17:\"Settings Profiles\";s:27:\"Perfiles de configuraciones\";s:16:\"Settings Profile\";s:19:\"Opciones del perfil\";s:23:\"Backup Settings Profile\";s:50:\"Perfil de configuraciones de la copia de seguridad\";s:31:\"Backup and Migrate Quick Backup\";s:48:\"Copia de seguridad rápida de Backup and Migrate\";s:15:\"restore feature\";s:25:\"restaurar característica\";s:16:\"Quick Backup Tab\";s:38:\"Pestaña de Copia de Seguridad Rápida\";s:70:\"Use this form to run simple manual backups of your database and files.\";s:108:\"Utilice este formulario para realizar copias de seguridad manuales sencillas de su base de datos y archivos.\";s:19:\"Advanced Backup Tab\";s:39:\"Pestaña de copia de seguridad avanzada\";s:17:\"settings profiles\";s:26:\"perfiles de configuración\";s:11:\"Restore Tab\";s:18:\"Restaurar Pestaña\";s:9:\"schedules\";s:18:\"tareas programadas\";s:14:\"manual backups\";s:28:\"copias de seguridad manuales\";s:10:\"Scheduling\";s:14:\"Planificación\";s:18:\"Importing Settings\";s:26:\"Importando configuraciones\";s:9:\"help page\";s:16:\"página de ayuda\";s:52:\"Visit the !helppage for more help using this module.\";s:60:\"Visite la !helppage para más ayuda del uso de este módulo.\";s:18:\"Backup and Migrate\";s:18:\"Backup and Migrate\";s:12:\"Quick Backup\";s:26:\"Copia de seguridad rápida\";s:13:\"Backup Source\";s:31:\"Origen de la copia de seguridad\";s:5:\"Local\";s:5:\"Local\";s:7:\"Offsite\";s:15:\"Fuera del sitio\";s:18:\"Backup Destination\";s:32:\"Destino de la copia de seguridad\";s:22:\"Create new destination\";s:22:\"Crear un nuevo destino\";s:35:\"Save a copy to a second destination\";s:38:\"Guardar una copia a un segundo destino\";s:25:\"Second Backup Destination\";s:40:\"Destino de la segunda copia de seguridad\";s:16:\"Default Settings\";s:20:\"Opciones por defecto\";s:24:\"Add a note to the backup\";s:40:\"Agregar una nota a la copia de seguridad\";s:10:\"Backup now\";s:30:\"Hacer copia de seguridad ahora\";s:23:\"Save an offsite copy to\";s:48:\"Guarde una copia fuera de las instalaciones para\";s:20:\"Save a local copy to\";s:25:\"Guardar una copia local a\";s:6:\"Backup\";s:18:\"Copia de seguridad\";s:20:\"Backup the database.\";s:45:\"Hacer copia de seguridad de la base de datos.\";s:11:\"Delete File\";b:1;s:20:\"Delete a backup file\";b:1;s:17:\"Destination Files\";b:1;s:19:\"Restore from backup\";b:1;s:49:\"Restore database from a backup file on the server\";b:1;s:15:\"Advanced Backup\";s:27:\"Copia de seguridad avanzada\";s:10:\"List !type\";s:12:\"Listar !type\";s:43:\"Restore the database from a previous backup\";s:59:\"Restaurar la base de datos de una copia de seguridad previa\";s:9:\"Add !type\";b:1;s:13:\"Saved Backups\";s:29:\"Copias de seguridad guardadas\";s:26:\"Previously created backups\";s:41:\"Copias de seguridad creadas anteriormente\";s:16:\"Module settings.\";s:27:\"Configuraciones del módulo\";s:35:\"Import backup and migrate settings.\";s:60:\"Importa configuraciones de copias de seguridad y migración.\";s:37:\"Backup my !from to !to using !profile\";s:44:\"Respaldar mi !from a !to utilizando !profile\";s:31:\"-- Select a Settings Profile --\";s:44:\"-- Seleccione un Perfil de Configuración --\";s:64:\"You can load a profile. Any changes you made below will be lost.\";s:88:\"Usted puede cargar un perfil. Los cambios que se presentan a continuación se perderán.\";s:13:\"Load Settings\";s:15:\"Cargar opciones\";s:12:\"Load Profile\";s:13:\"Cargar perfil\";s:18:\"View as checkboxes\";s:31:\"Ver como casillas de selección\";s:11:\"Backup File\";s:29:\"Archivo de copia de seguridad\";s:16:\"Backup file name\";s:40:\"Nombre del archivo de copia de seguridad\";s:36:\"You can use tokens in the file name.\";s:51:\"Puede utilizar reemplazos en el nombre del archivo.\";s:19:\"Append a timestamp.\";s:25:\"Agregar un sello temporal\";s:16:\"Timestamp format\";s:26:\"Formato del sello temporal\";s:56:\"Should be a PHP <a href=\"!url\">date()</a> format string.\";s:65:\"Debe ser una cadena de formato  <a href=\"!url\">date()</a> de PHP.\";s:32:\"Send an email if backup succeeds\";s:54:\"Enviar un correo electrónico si la copia tiene éxito\";s:33:\"Email Address for Success Notices\";s:63:\"Dirección de correo electrónico para notificaciones de éxito\";s:29:\"Send an email if backup fails\";s:57:\"Enviar correo electrónico si la copia de seguridad falla\";s:33:\"Email Address for Failure Notices\";s:62:\"Dirección de correo electrónico para notificaciones de error\";s:11:\"Compression\";s:11:\"Compresión\";s:39:\"Exclude the following tables altogether\";s:42:\"Excluir las siguientes tablas por completo\";s:57:\"The selected tables will not be added to the backup file.\";s:75:\"Las tablas seleccionadas no se añadirán al archivo de copia de seguridad.\";s:42:\"Exclude the data from the following tables\";s:42:\"Excluir los datos de las tablas siguientes\";s:25:\"Lock tables during backup\";s:34:\"Bloquear tablas durante el copiado\";s:20:\"!name Backup Options\";s:36:\"!name opciones de copia de seguridad\";s:42:\"Exclude the following files or directories\";s:45:\"Excluir los siguientes archivos o directorios\";s:13:\"No Encryption\";s:11:\"Sin cifrado\";s:15:\"File Encryption\";s:18:\"Cifrado de archivo\";s:21:\"AES Encryption Module\";s:22:\"Módulo de cifrado AES\";s:51:\"Install the !link to enable backup file encryption.\";s:81:\"Instale el !link para activar el encriptado del archivo de la copia de seguridad.\";s:17:\"Take site offline\";s:40:\"Cambiar el sitio a modo de mantenimiento\";s:21:\"Site off-line message\";s:29:\"Mensaje de sitio desconectado\";s:59:\"Message to show visitors when the site is in off-line mode.\";s:74:\"Mensaje que se muestra a los vistantes cuando el sitio está desconectado.\";s:10:\"Add a note\";s:16:\"Añadir una nota\";s:36:\"Add a short note to the backup file.\";s:59:\"Añadir una nota corta al archivo de la copia de seguridad.\";s:16:\"Use cli commands\";s:60:\"Utilice comandos de la interfase de línea de comandos (cli)\";s:13:\"Ignore errors\";s:15:\"Ignorar errores\";s:20:\"Save these settings.\";s:28:\"Guardar esta configuración.\";s:20:\"Save the settings as\";s:30:\"Guardar la configuración como\";s:30:\"Replace the \'%profile\' profile\";s:31:\"Reemplazar el perfil \'%profile\'\";s:18:\"Create new profile\";s:21:\"Crear un nuevo perfil\";s:23:\"Save Without Backing Up\";s:39:\"Guardar sin realizar copia de seguridad\";s:27:\"%num SQL commands executed.\";s:29:\"%num comandos SQL ejecutados.\";s:39:\"<a href=\"!restoreurl\">Restore again</a>\";s:46:\"<a href=\"!restoreurl\">Restaurar nuevamente</a>\";s:65:\"%source restored from %dest file %file in !time. !action (!links)\";b:1;s:40:\"Filter any Views !base_table date field.\";b:1;s:11:\"Easy Social\";b:1;s:30:\"@field-label - @property-label\";b:1;s:55:\"The marker name GMap Taxonomy associates with the node.\";b:1;s:44:\"Locations are addresses and map coordinates.\";b:1;s:32:\"The location ID of the location.\";b:1;s:34:\"The name of the selected location.\";b:1;s:44:\"The street address of the selected location.\";b:1;s:51:\"Additional street address of the selected location.\";b:1;s:34:\"The city of the selected location.\";b:1;s:63:\"The coordinates of the selected location in \'lat, long\' format.\";b:1;s:42:\"The entire address block for the location.\";b:1;s:43:\"The email address of the selected location.\";b:1;s:40:\"The fax number of the selected location.\";b:1;s:42:\"The phone number of the selected location.\";b:1;s:3:\"www\";b:1;s:40:\"The www number of the selected location.\";b:1;s:9:\"Locations\";s:11:\"Ubicaciones\";s:17:\"Top rated content\";b:1;s:10:\"Your votes\";b:1;s:19:\"Lista de selección\";b:1;s:14:\"backup_migrate\";b:1;s:5:\"1 day\";b:1;s:11:\"@count days\";b:1;s:6:\"1 week\";b:1;s:29:\"Registered user vote rollover\";b:1;s:10:\"GMap Macro\";b:1;s:11:\"GMap marker\";b:1;s:13:\"Localización\";b:1;s:22:\"Location field: !field\";b:1;s:21:\"Nome da localización\";b:1;s:6:\"Cidade\";b:1;s:21:\"Estado actual: !state\";b:1;s:14:\"Código postal\";b:1;s:5:\"País\";b:1;s:31:\"Enderezo de correo electrónico\";b:1;s:14:\"Número de fax\";b:1;s:20:\"Número de teléfono\";b:1;s:11:\"Edit widget\";b:1;s:22:\"change the widget type\";b:1;s:40:\"This is a %type widget. You may !change.\";b:1;s:29:\"Restore from an uploaded file\";s:45:\"Restaurar desde un fichero subido al servidor\";s:20:\"Upload a Backup File\";s:38:\"Subir un archivo de copia de seguridad\";s:27:\"Restore from a saved backup\";s:46:\"Restaurar desde una copia de seguridad salvada\";s:9:\"Location:\";s:14:\"Localización:\";s:10:\"Restore to\";s:11:\"Restaurar a\";s:11:\"Restore now\";s:15:\"Restaurar ahora\";s:7:\"Source:\";s:7:\"Fuente:\";s:39:\"Showing @start to @end of @total files.\";s:46:\"Mostrando de @start a @end de @total archivos.\";s:70:\"Allow the use of checkboxes or radio buttons for exposed Views filters\";b:1;s:69:\"Enables modules to work with any entity type and to provide entities.\";s:92:\"Habilita módulos para trabajar con cualquier tipo de entidad y para proporcionar entidades.\";s:51:\"Provides a field that can reference other entities.\";b:1;s:71:\"Provides some example code for implementing Entity Reference behaviors.\";b:1;s:69:\"Generates random locations to test IP Geolocation Views & Maps module\";b:1;s:55:\"Provides additional formatters for various field types.\";b:1;s:17:\"administer blocks\";b:1;s:25:\"access backup and migrate\";b:1;s:19:\"access backup files\";b:1;s:29:\"administer backup and migrate\";b:1;s:19:\"delete backup files\";b:1;s:14:\"perform backup\";b:1;s:19:\"restore from backup\";b:1;s:19:\"administer comments\";b:1;s:17:\"edit own comments\";b:1;s:21:\"skip comment approval\";b:1;s:13:\"post comments\";b:1;s:15:\"access comments\";b:1;s:23:\"access contextual links\";b:1;s:17:\"use ctools import\";b:1;s:16:\"access dashboard\";b:1;s:22:\"administer easy social\";b:1;s:22:\"use easy social wizard\";b:1;s:29:\"use text format filtered_html\";b:1;s:25:\"use text format full_html\";b:1;s:18:\"administer filters\";b:1;s:21:\"administer flexslider\";b:1;s:13:\"view node map\";b:1;s:26:\"view user location details\";b:1;s:13:\"view user map\";b:1;s:17:\"create gmap macro\";b:1;s:31:\"administer content translations\";b:1;s:23:\"administer image styles\";b:1;s:15:\"administer imce\";b:1;s:20:\"administer languages\";b:1;s:19:\"translate interface\";b:1;s:25:\"submit latitude/longitude\";b:1;s:23:\"view location directory\";b:1;s:24:\"view node location table\";b:1;s:24:\"view user location table\";b:1;s:15:\"administer menu\";b:1;s:24:\"administer module filter\";b:1;s:27:\"delete own activity content\";b:1;s:23:\"create activity content\";b:1;s:25:\"edit any activity content\";b:1;s:25:\"edit own activity content\";b:1;s:27:\"delete any activity content\";b:1;s:26:\"delete own archive content\";b:1;s:22:\"create archive content\";b:1;s:24:\"edit any archive content\";b:1;s:24:\"edit own archive content\";b:1;s:26:\"delete any archive content\";b:1;s:24:\"delete own place content\";b:1;s:20:\"create place content\";b:1;s:22:\"edit any place content\";b:1;s:22:\"edit own place content\";b:1;s:24:\"delete any place content\";b:1;s:23:\"delete own page content\";b:1;s:19:\"create page content\";b:1;s:21:\"edit any page content\";b:1;s:21:\"edit own page content\";b:1;s:23:\"delete any page content\";b:1;s:16:\"delete revisions\";b:1;s:16:\"revert revisions\";b:1;s:14:\"access content\";b:1;s:28:\"view own unpublished content\";b:1;s:14:\"view revisions\";b:1;s:23:\"access content overview\";b:1;s:16:\"administer nodes\";b:1;s:24:\"administer content types\";b:1;s:18:\"bypass node access\";b:1;s:22:\"administer url aliases\";b:1;s:18:\"create url aliases\";b:1;s:22:\"view rate results page\";b:1;s:17:\"administer search\";b:1;s:14:\"search content\";b:1;s:19:\"use advanced search\";b:1;s:20:\"administer shortcuts\";b:1;s:24:\"customize shortcut links\";b:1;s:20:\"switch shortcut sets\";b:1;s:17:\"administer themes\";b:1;s:18:\"administer actions\";b:1;s:18:\"administer modules\";b:1;s:18:\"block IP addresses\";b:1;s:27:\"access administration pages\";b:1;s:31:\"access site in maintenance mode\";b:1;s:27:\"administer software updates\";b:1;s:29:\"administer site configuration\";b:1;s:19:\"access site reports\";b:1;s:29:\"view the administration theme\";b:1;s:19:\"administer taxonomy\";b:1;s:15:\"edit terms in 1\";b:1;s:15:\"edit terms in 2\";b:1;s:17:\"delete terms in 1\";b:1;s:17:\"delete terms in 2\";b:1;s:14:\"access toolbar\";b:1;s:17:\"translate content\";b:1;s:19:\"change own username\";b:1;s:20:\"access user profiles\";b:1;s:22:\"administer permissions\";b:1;s:16:\"administer users\";b:1;s:14:\"cancel account\";b:1;s:34:\"select account cancellation method\";b:1;s:23:\"administer video styles\";b:1;s:21:\"administer voting api\";b:1;s:23:\"translate admin strings\";b:1;s:30:\"translate user-defined strings\";b:1;s:16:\"administer views\";b:1;s:16:\"access all views\";b:1;s:49:\"Uses the jsDelivr CDN for all CSS and JavaScript.\";b:1;s:56:\"Supports dynamic dependency for entity reference fields.\";b:1;s:44:\"Nodes represent the main site content items.\";s:71:\"Los nodos representan los principales elementos de contenido del sitio.\";s:14:\"Uploaded file.\";s:15:\"Archivo subido.\";s:37:\"Remark or note that refers to a node.\";s:43:\"Comentario o nota que se refiere a un nodo.\";s:48:\"Taxonomy terms are used for classifying content.\";s:64:\"Términos de taxonomía utilizados para clasificar el contenido.\";s:21:\"Taxonomy vocabularies\";s:26:\"Vocabularios de taxonomía\";s:15:\"Rendered entity\";s:20:\"Entidad representada\";s:27:\"The subject of the comment.\";s:25:\"El asunto del comentario.\";s:26:\"The author of the comment.\";s:24:\"El autor del comentario.\";s:48:\"Whether the comment is published or unpublished.\";s:38:\"Si el comentario está publicado o no.\";s:14:\"Field \"@name\".\";s:14:\"Campo \"@name\".\";s:9:\"The file.\";s:11:\"El archivo.\";s:20:\"The file description\";s:27:\"La descripción del archivo\";s:36:\"Whether the file is being displayed.\";s:25:\"Si se muestra el archivo.\";s:15:\"The image file.\";s:21:\"El archivo de imagen.\";s:24:\"The \"Alt\" attribute text\";s:26:\"El atributo de texto \"Alt\"\";s:26:\"The \"Title\" attribute text\";s:28:\"El atributo de texto \"Title\"\";s:22:\"The title of the link.\";b:1;s:20:\"The URL of the link.\";b:1;s:27:\"The attributes of the link.\";b:1;s:26:\"The unique ID of the node.\";s:22:\"El ID único del nodo,\";s:37:\"The unique ID of the node\'s revision.\";s:38:\"El ID único de la revisión del nodo.\";s:6:\"Is new\";s:8:\"Es nuevo\";s:58:\"Whether the node is new and not saved to the database yet.\";s:69:\"Si el nodo es nuevo y no se ha guardado en la base de datos todavía.\";s:45:\"Whether the node is published or unpublished.\";s:32:\"Si el nodo está publicado o no.\";s:21:\"Promoted to frontpage\";s:22:\"Promovido a la portada\";s:46:\"Whether the node is promoted to the frontpage.\";s:53:\"Si el nodo está promocionado a la página principal.\";s:15:\"Sticky in lists\";s:25:\"Fijo arriba en las listas\";s:70:\"Whether the node is displayed at the top of lists in which it appears.\";s:79:\"Si el nodo se muestra en la parte superior de las listas en las cuales aparece.\";s:58:\"The original-language version of this node, if one exists.\";s:62:\"La versión en idioma original de este nodo, si es que existe.\";s:16:\"Creates revision\";s:14:\"Crea revisión\";s:48:\"Whether saving this node creates a new revision.\";s:51:\"Si guardando este nodo se crea una nueva revisión.\";s:72:\"The weight of the term, which is used for ordering terms during display.\";s:92:\"El peso del término, el cual es utilizado para ordenar términos durante la visualización.\";s:38:\"The parent terms of the taxonomy term.\";s:48:\"Los términos padres del término de taxonomía.\";s:16:\"All parent terms\";s:27:\"Todos los términos padres.\";s:65:\"Ancestors of the term, i.e. parent of all above hierarchy levels.\";s:101:\"Los ascendientes ​​del término, es decir, el padre de todos los niveles jerárquicos superiores.\";s:44:\"The machine name of the taxonomy vocabulary.\";s:59:\"El nombre para el sistema del vocabulario de la taxonomía.\";s:33:\"The url of the account edit page.\";s:46:\"la URL de la página de edición de la cuenta.\";s:41:\"The date the user last accessed the site.\";s:62:\"Fecha en la cual el usuario accedió por última vez al sitio.\";s:22:\"The roles of the user.\";s:22:\"Los roles del usuario.\";s:38:\"Whether the user is active or blocked.\";s:39:\"Si el usuario está activo o bloqueado.\";s:25:\"The user\'s default theme.\";s:32:\"El tema por defecto del usuario.\";s:14:\"Logged in user\";s:20:\"Usuario identificado\";s:29:\"The currently logged in user.\";s:33:\"El usuario actualmente conectado.\";s:26:\"The current date and time.\";s:26:\"La fecha y la hora actual.\";s:48:\"Information related to the current page request.\";s:63:\"La información relacionada con la solicitud de página actual.\";s:53:\"The internal Drupal path of the current page request.\";s:60:\"La ruta interna de Drupal de la solicitud de página actual.\";s:41:\"The full URL of the current page request.\";s:61:\"La dirección URL completa de la solicitud de página actual.\";s:35:\"The size of the file, in kilobytes.\";s:37:\"El tamaño del archivo, en kilobytes.\";s:16:\"Comments allowed\";s:22:\"Comentarios permitidos\";s:18:\"The node comments.\";s:24:\"Los comentarios del nodo\";s:18:\"The main body text\";s:29:\"El texto del cuerpo principal\";s:57:\"The language code of the current user interface language.\";s:65:\"El código de idioma del idioma de la interfaz de usuario actual.\";s:16:\"Content language\";s:20:\"Idioma del contenido\";s:50:\"The language code of the current content language.\";s:53:\"El código de idioma del idioma del contenido actual.\";s:26:\"(No information available)\";s:32:\"(No hay información disponible)\";s:21:\"Rendered @entity-type\";s:25:\"Representada @entity-type\";s:72:\"The @entity-type of the current relationship rendered using a view mode.\";s:89:\"El @entity-type de la relación actual representada utilizando un modo de visualización.\";s:6:\"Entity\";s:7:\"Entidad\";s:32:\"Displays a single chosen entity.\";s:33:\"Muestra una sola entidad elegida.\";s:25:\"Location from !field_name\";b:1;s:62:\"Renders a single entity in a specific view mode (e.g. teaser).\";s:93:\"Representa una sola entidad, en un modo de visualización específico (por ejemplo, resumen).\";s:60:\"The following properties may be appended to the token: @keys\";s:78:\"Las siguientes propiedades pueden ser agregadas al patrón de reemplazo: @keys\";s:39:\"Tokens related to the \"@name\" entities.\";s:57:\"Cadenas de reemplazo relacionadas a las entidades \"@name\"\";s:17:\"List of @entities\";s:20:\"Listado de @entities\";s:20:\"List of @type values\";s:27:\"Listado de valores de @type\";s:33:\"Tokens for lists of @type values.\";s:52:\"Cadenas de reemplazo para listas de valores de @type\";s:23:\"@type with delta @delta\";s:22:\"@type con delta @delta\";s:21:\"A partir de que data?\";b:1;s:67:\"Provides the ability to group your fields on both form and display.\";b:1;s:53:\"Table that contains field group entries and settings.\";b:1;s:22:\"Administer fieldgroups\";s:28:\"Administrar grupos de campos\";s:43:\"Display the administration for fieldgroups.\";s:47:\"Mostrar la administración de grupos de campos.\";s:39:\"Language settings for the user account.\";b:1;s:14:\"Wysiwyg status\";b:1;s:13:\"Add new group\";s:22:\"Adicionar nuevo grupo.\";s:3:\"Div\";s:3:\"Div\";s:5:\"HTML5\";s:5:\"HTML5\";s:69:\"This fieldgroup renders the inner content in a semantic HTML5 wrapper\";s:88:\"Este grupo de campos presenta el contenido interior en un contenedor semántico de HTML5\";s:8:\"Fieldset\";s:18:\"Conjunto de campos\";s:19:\"Vertical tabs group\";s:27:\"Grupo de solapas verticales\";s:70:\"This fieldgroup renders child groups in its own vertical tabs wrapper.\";s:95:\"Este grupo de campos presenta los grupos hijos en su propio contenedor de pestañas verticales.\";s:12:\"Vertical tab\";s:15:\"Solapa vertical\";s:21:\"Horizontal tabs group\";s:31:\"Grupo de pestañas horizontales\";s:72:\"This fieldgroup renders child groups in its own horizontal tabs wrapper.\";s:97:\"Este grupo de campos presenta los grupos hijos en su propio contenedor de pestañas horizontales.\";s:14:\"Horizontal tab\";s:19:\"Pestaña horizontal\";s:15:\"Multipage group\";s:18:\"Grupo multipágina\";s:49:\"This fieldgroup renders groups on separate pages.\";s:63:\"Este grupo de campos presenta los grupos en páginas separadas.\";s:9:\"Multipage\";b:1;s:46:\"This fieldgroup renders the content in a page.\";s:58:\"Este grupo de campos presenta el contenido en una página.\";s:15:\"Accordion group\";s:18:\"Grupo de acordeón\";s:57:\"This fieldgroup renders child groups as jQuery accordion.\";s:75:\"Este grupo de campos presenta los grupos hijos como un acordeón de jQuery.\";s:14:\"Accordion item\";s:21:\"Elemento de acordeón\";s:70:\"This fieldgroup renders the content in a div, part of accordion group.\";s:88:\"Este grupo de campos presenta el contenido en un div, como parte del grupo de acordeón.\";s:19:\"Horizontal tab item\";s:29:\"Elemento de solapa horizontal\";s:19:\"Label for new group\";s:25:\"Etiqueta para nuevo grupo\";s:20:\"Weight for new group\";s:24:\"Peso para el nuevo grupo\";s:20:\"Parent for new group\";s:21:\"Padre del nuevo grupo\";s:26:\"Machine name for new group\";s:37:\"Nombre de sistema para el nuevo grupo\";s:24:\"Group name (a-z, 0-9, _)\";s:30:\"Nombre del grupo (a-z, 0-9, _)\";s:11:\"Fieldgroups\";s:16:\"Grupos de campos\";s:31:\"Select source view mode or form\";s:50:\"Seleccione el modo de vista de origen o formulario\";s:64:\"Clone fieldgroups from selected view mode to the current display\";b:1;s:38:\"New group %label successfully created.\";s:40:\"Nuevo grupo %label creado correctamente.\";s:17:\"Field group label\";s:27:\"Etiqueta de grupo de campos\";s:19:\"Fieldgroup settings\";s:34:\"Configuración del grupo de campos\";s:54:\"Mark group as required if it contains required fields.\";s:65:\"Marcar el grupo como obligatorio si contiene campos obligatorios.\";s:17:\"Extra CSS classes\";s:16:\"Clases CSS extra\";s:45:\"Please enter a label for collapsible elements\";b:1;s:8:\"Arquivar\";b:1;s:19:\"Field group format:\";s:28:\"Formato del grupo de campos:\";s:35:\"Usa <em>banners</em> para anuncios.\";b:1;s:25:\"delete own banner content\";b:1;s:21:\"create banner content\";b:1;s:23:\"edit any banner content\";b:1;s:23:\"edit own banner content\";b:1;s:25:\"delete any banner content\";b:1;s:15:\"edit terms in 3\";b:1;s:17:\"delete terms in 3\";b:1;s:22:\"administer fieldgroups\";b:1;s:37:\"View translation overview assignments\";b:1;s:49:\"Allow users to view the translations assignments.\";s:61:\"Permitir a los usuarios ver las asignaciones de traducciones.\";s:48:\"Manage %language translation overview priorities\";s:78:\"Administrar prioridades de la información general de traducción de %language\";s:20:\"Translation overview\";s:32:\"Estado general de la traducción\";s:50:\"View the translation status of the site\'s content.\";s:56:\"Ver el estado de la traducción del contenido del sitio.\";s:41:\"manage es translation overview priorities\";b:1;s:41:\"manage gl translation overview priorities\";b:1;s:41:\"manage en translation overview priorities\";b:1;s:37:\"view translation overview assignments\";b:1;s:22:\"Up-to-date translation\";s:25:\"Traducción a día de hoy\";s:13:\"High priority\";s:14:\"Prioridad alta\";s:7:\"Ignored\";s:8:\"Ignorado\";s:8:\"Complete\";s:8:\"Completo\";s:21:\"completed translation\";s:21:\"traducción terminada\";s:11:\"Out-of-date\";s:8:\"Caducado\";s:23:\"out-of-date translation\";s:20:\"traducción caducada\";s:12:\"Untranslated\";s:12:\"Sin traducir\";s:20:\"untranslated content\";s:22:\"contenido sin traducir\";s:22:\"Translator assignments\";b:1;s:34:\"View the translations assignments.\";s:37:\"Ver las asignaciones de traducciones.\";s:17:\"Toggle navigation\";b:1;s:17:\"File requirements\";b:1;s:19:\"Opens in new window\";b:1;s:5:\"first\";b:1;s:8:\"previous\";b:1;s:4:\"next\";b:1;s:4:\"last\";b:1;s:40:\"There are currently @count users online.\";b:1;s:20:\"translation_overview\";s:21:\"resumen_de_traduccion\";s:7:\"Lateral\";b:1;s:8:\"Opcións\";b:1;s:49:\"Are you sure you want to delete the group %group?\";s:44:\"¿Seguro que desea eliminar el grupo %group?\";s:62:\"The group %group has been deleted from the %type content type.\";s:62:\"El grupo %group ha sido eliminado del tipo de contenido %type.\";s:50:\"Checked available update data for @count projects.\";b:1;s:8:\"download\";s:9:\"descargar\";s:8:\"!time ms\";s:8:\"!time ms\";s:7:\"restore\";s:9:\"restaurar\";s:8:\"view all\";s:8:\"ver todo\";s:7:\"Element\";s:8:\"Elemento\";s:8:\"Header 2\";s:12:\"Encabezado 2\";s:8:\"Header 3\";s:12:\"Encabezado 3\";s:8:\"Priority\";s:9:\"Prioridad\";s:11:\"unpublished\";s:12:\"sin publicar\";s:4:\"High\";s:4:\"Alta\";s:6:\"Ignore\";s:7:\"Ignorar\";s:17:\"Click to edit it.\";s:20:\"Pulse para editarlo.\";s:16:\"Click to add it.\";s:25:\"Pulse aquí para añadir.\";s:17:\"Click to view it.\";s:17:\"Pulse para verlo.\";s:15:\"Submit settings\";s:24:\"Configuraciones de envio\";s:33:\"There is currently 1 user online.\";b:1;s:9:\"See map: \";b:1;s:14:\"User-submitted\";b:1;s:10:\"Re geocode\";b:1;s:38:\"Check this box to re-geocode location.\";b:1;s:32:\"Adds Book support to Node export\";b:1;s:74:\"Supply some common filter options to define node available to be exported.\";b:1;s:11:\"Node export\";b:1;s:46:\"Provides export functionality for url aliases.\";b:1;s:4:\"UUID\";s:4:\"UUID\";s:20:\"Services - resources\";b:1;s:15:\"Administer UUID\";b:1;s:49:\"Allows configuration of the UUID module and APIs.\";b:1;s:12:\"Export nodes\";s:14:\"Exportar nodos\";s:16:\"Export own nodes\";b:1;s:23:\"Use PHP to import nodes\";b:1;s:55:\"Required for importing, but can allow execution of PHP.\";b:1;s:4:\"JSON\";s:4:\"JSON\";s:52:\"<a href=\"!json\">JavaScript Object Notation</a> code.\";b:1;s:17:\"Drupal var export\";b:1;s:45:\"<a href=\"!drupal\">Drupal var export</a> code.\";b:1;s:9:\"Serialize\";b:1;s:3:\"XML\";s:3:\"XML\";s:3:\"DSV\";b:1;s:16:\"General settings\";s:17:\"Ajustes generales\";s:13:\"Download file\";s:17:\"Descargar archivo\";s:10:\"Paste code\";s:13:\"Pegar código\";s:39:\"Configure the settings for Node export.\";b:1;s:30:\"Universally unique identifiers\";b:1;s:41:\"Configure universally unique identifiers.\";b:1;s:16:\"Node export code\";b:1;s:19:\"Node export: import\";b:1;s:42:\"Import content using <em>Node export</em>.\";b:1;s:20:\"Node export filename\";b:1;s:43:\"Tokens related to the Node export filename.\";b:1;s:12:\"Node ID list\";b:1;s:67:\"Comma separated list of Node IDs in square brackets (if available).\";b:1;s:29:\"The number of nodes exported.\";b:1;s:42:\"The timestamp when the file was generated.\";b:1;s:26:\"The format used to export.\";b:1;s:17:\"@entity_type UUID\";b:1;s:40:\"The universally unique ID of the @entity\";b:1;s:26:\"@entity_type revision UUID\";b:1;s:49:\"The universally unique revision ID of the @entity\";b:1;s:39:\"Allows assigning CSS classes to blocks.\";s:51:\"Permite la asignación de clases CSS a los bloques.\";s:51:\"Provide the Basque Services: Zabaldu, Bildu, Aupatu\";b:1;s:48:\"Provide the Dutch Services: eKudos, Hyves, Nujij\";b:1;s:65:\"Provide the Farsi services: Balatarin, Donbaleh, Friendfa, Viwio.\";b:1;s:67:\"Add the page in your favorite, work with Chrome, Firefox, IE, Opera\";b:1;s:69:\"Add the support for Forward module which send the link through email.\";b:1;s:35:\"Provide the Hungarian Service: iWiW\";b:1;s:49:\"Provide the Polish Services: Blip, Wykop, Sledzik\";b:1;s:52:\"Add the ability to handle sprites with Service Links\";b:1;s:43:\"Provide the Swedish Services: Bloggy, Pusha\";b:1;s:24:\"Service Links - Services\";b:1;s:13:\"Service Links\";b:1;s:34:\"Provides additional search blocks.\";b:1;s:47:\"Provides Internationalization to Custom Search.\";b:1;s:41:\"Adds taxonomy selectors to Custom Search.\";b:1;s:24:\"Administer block classes\";b:1;s:27:\"Set CSS classes for blocks.\";b:1;s:16:\"Aside navigation\";b:1;s:13:\"CSS class(es)\";s:12:\"Clase(s) CSS\";s:16:\"Search this site\";s:20:\"Buscar en este sitio\";s:10:\"Search for\";s:9:\"Buscar en\";s:5:\"-Any-\";b:1;s:18:\"Filter the results\";b:1;s:21:\"Customize your search\";b:1;s:24:\"Administer custom search\";b:1;s:48:\"Allow users to administer custom search settings\";b:1;s:17:\"Use custom search\";b:1;s:32:\"Allow users to use custom search\";b:1;s:31:\"Administer custom search blocks\";b:1;s:55:\"Allow users to administer custom search blocks settings\";b:1;s:24:\"Use custom search blocks\";b:1;s:39:\"Allow users to use custom search blocks\";b:1;s:10:\"Search box\";s:19:\"Bloque de búsqueda\";s:16:\"Number of blocks\";s:18:\"Número de bloques\";s:13:\"Display label\";s:18:\"Etiqueta a mostrar\";s:13:\"Radio buttons\";s:21:\"Botones de selección\";s:10:\"Checkboxes\";s:22:\"Casillas de selección\";s:13:\"Custom Search\";s:23:\"Búsqueda personalizada\";s:13:\"Submit button\";s:13:\"Botón enviar\";s:10:\"Label text\";s:17:\"Texto de etiqueta\";s:74:\"Select the content types to present as search options in the search block.\";s:99:\"Seleccione los tipos de contenido a presentar como opciones de búsqueda en el bloque de búsqueda.\";s:64:\"Select the content types to display on the advanced search form.\";s:89:\"Seleccione los tipos de contenido que se mostrarán en la pantalla de búsqueda avanzada.\";s:13:\"Search Blocks\";b:1;s:49:\"Provide additional search blocks by content type.\";b:1;s:73:\"Select the vocabularies to present as search options in the search block.\";b:1;s:23:\"Access to Service Links\";b:1;s:30:\"Use PHP for Service visibility\";b:1;s:38:\"Administer Menu Trail By Path settings\";b:1;s:16:\"Print this label\";s:22:\"Imprimir esta etiqueta\";s:32:\"Label for service links in nodes\";s:46:\"Etiqueta para enlaces de servicio en los nodos\";s:13:\"Service links\";b:1;s:33:\"Service links with FishEye effect\";b:1;s:32:\"Service links for not-node pages\";b:1;s:15:\"Infinite Scroll\";b:1;s:10:\"New window\";s:13:\"Nueva ventana\";s:11:\"Same window\";s:13:\"Misma ventana\";s:33:\"Page specific visibility settings\";s:48:\"Opciones de visibilidad específicas por página\";s:8:\"Services\";s:9:\"Servicios\";s:6:\"@label\";s:6:\"@label\";s:30:\"Bookmark/Search this post with\";s:36:\"Marcar/buscar esta publicación con:\";s:6:\"Always\";s:7:\"Siempre\";s:12:\"Service Name\";s:19:\"Nombre del servicio\";s:10:\"Only Image\";s:14:\"Solo imágenes\";s:14:\"Image and Text\";s:18:\"Imágenes y textos\";s:46:\"Don\'t show links if the content is unpublished\";s:56:\"No mostrar los enlaces si el contenido no esta publicado\";s:13:\"Extra Options\";s:14:\"Opciones extra\";s:15:\"Open link in...\";s:16:\"Abrir link en...\";s:37:\"Append the following text to your URL\";s:35:\"Añadir el siguiente texto a la URL\";s:21:\"Share this on Twitter\";s:20:\"Compartir en Twitter\";s:30:\"Bookmark this post on SlashDot\";s:47:\"Marcar este contenido como favorito en SlashDot\";s:29:\"Publish this post to LinkedIn\";s:20:\"Publicar en LinkedIn\";s:33:\"Bookmark this post on Mister Wong\";s:50:\"Marcar este contenido como favorito en Mister Wong\";s:22:\"No services available.\";s:28:\"Ningún servicio disponible.\";s:36:\"Show for content types or categories\";s:50:\"Mostrar para tipos de contenido o para categorías\";s:27:\"Where to show service links\";s:38:\"Dónde mostrar los enlaces de servicio\";s:36:\"Show Service Links on specific pages\";s:52:\"Mostrar enlaces de servicio en páginas específicas\";s:26:\"Service links in the links\";s:34:\"Enlaces de servicio en los enlaces\";s:28:\"Service links in the content\";s:35:\"Enlaces de servicio en el contenido\";s:18:\"Menu trail by path\";b:1;s:36:\"Configure menu trail by path module.\";b:1;s:55:\"Control which and where service links should be active.\";b:1;s:26:\"Enable breadcrumb handling\";b:1;s:57:\"If checked, breadcrumb will be set according to url path.\";b:1;s:16:\"Search box label\";b:1;s:73:\"Enter the label text for the search box. The default value is \"!default\".\";b:1;s:27:\"Search box placeholder text\";b:1;s:20:\"Search box hint text\";b:1;s:15:\"Search operator\";b:1;s:15:\"Search box size\";b:1;s:32:\"The default value is \"!default\".\";b:1;s:25:\"Search box maximum length\";b:1;s:17:\"Submit image path\";b:1;s:12:\"Submit image\";b:1;s:24:\"Advanced search criteria\";b:1;s:69:\"Enter the label text for this field. The default value is \"!default\".\";b:1;s:6:\"Phrase\";b:1;s:8:\"Negative\";b:1;s:19:\"Custom search paths\";b:1;s:13:\"Selector type\";b:1;s:14:\"Drop-down list\";b:1;s:34:\"Choose which selector type to use.\";b:1;s:71:\"Enter the label text for the selector. The default value is \"!default\".\";b:1;s:17:\"Elements ordering\";b:1;s:29:\"Advanced search criterion: Or\";b:1;s:33:\"Advanced search criterion: Phrase\";b:1;s:35:\"Advanced search criterion: Negative\";b:1;s:24:\"Taxonomy terms separator\";b:1;s:66:\"Change the labels, the default texts and the ordering of elements.\";b:1;s:12:\"Results page\";b:1;s:34:\"Customize the search results page.\";b:1;s:24:\"Manage search languages.\";b:1;s:26:\"No elements in this region\";b:1;s:16:\"Content selector\";b:1;s:14:\"Other searches\";b:1;s:36:\"Drop-down list with multiple choices\";b:1;s:23:\"-Any content type- text\";b:1;s:66:\"Choosing -Any- restricts the search to the selected content types.\";b:1;s:64:\"If not checked, choosing -Any- will search in all content types.\";b:1;s:28:\"Force -Any- to be displayed.\";b:1;s:17:\"Content exclusion\";b:1;s:71:\"Enter the label text for the selector. The default value is \"@default\".\";b:1;s:10:\"-Any- text\";b:1;s:70:\"Enter the text for \"any term\" choice. The default value is \"!default\".\";b:1;s:21:\"Results page opens in\";b:1;s:15:\"the same window\";b:1;s:12:\"a new window\";b:1;s:20:\"Display basic search\";b:1;s:23:\"Display advanced search\";b:1;s:8:\"Criteria\";b:1;s:59:\"Select the criteria to display on the advanced search form.\";b:1;s:60:\"Select the languages to display on the advanced search form.\";b:1;s:41:\"Select data to display below each result.\";b:1;s:48:\"Add links to filter the results by content type.\";b:1;s:13:\"Above results\";b:1;s:13:\"Below results\";b:1;s:67:\"Enter the label text for the list. The default value is \"!default\".\";b:1;s:19:\"Search content from\";b:1;s:12:\"any language\";b:1;s:16:\"current language\";b:1;s:37:\"current language and language neutral\";b:1;s:53:\"Choose which language will be used to search content.\";b:1;s:66:\"Set the content types or categories you want to display links for.\";b:1;s:41:\"Show terms from the selected vocabularies\";b:1;s:67:\"Select for what view mode display the services in the link section.\";b:1;s:71:\"Select for what view modes display the services in the content section.\";b:1;s:28:\"How to display Service Links\";b:1;s:14:\"Choose a style\";b:1;s:9:\"Only Text\";b:1;s:61:\"Don\'t show links if the actual user is the author of the node\";b:1;s:22:\"Service Links in nodes\";b:1;s:15:\"Print the label\";b:1;s:15:\"Assign a weight\";b:1;s:19:\"Service Links icons\";b:1;s:15:\"Standard folder\";b:1;s:32:\"Use the default icons if missing\";b:1;s:25:\"How to fill the title tag\";b:1;s:27:\"Use the original node title\";b:1;s:27:\"Override the original title\";b:1;s:27:\"Parse the string with Token\";b:1;s:10:\"Token help\";b:1;s:11:\"Short Links\";b:1;s:15:\"Use short links\";b:1;s:19:\"Only when requested\";b:1;s:33:\"Bookmark this post on del.icio.us\";b:1;s:26:\"Digg this post on digg.com\";b:1;s:28:\"Thumb this up at StumbleUpon\";b:1;s:17:\"Submit to Ping.fm\";b:1;s:30:\"Submit this post on reddit.com\";b:1;s:32:\"Submit this post on newsvine.com\";b:1;s:28:\"Submit this post on furl.net\";b:1;s:17:\"Share on Facebook\";b:1;s:16:\"Share on MySpace\";b:1;s:28:\"Bookmark this post on Google\";b:1;s:21:\"Share this on Google+\";b:1;s:27:\"Bookmark this post on Yahoo\";b:1;s:40:\"Search Technorati for links to this post\";b:1;s:42:\"Add this post to your Technorati Favorites\";b:1;s:39:\"Search IceRocket for links to this post\";b:1;s:28:\"Submit this post on mixx.com\";b:1;s:7:\"Box it!\";b:1;s:16:\"Add to Blinklist\";b:1;s:22:\"Dent this on identi.ca\";b:1;s:28:\"Kicks this post on NewsKicks\";b:1;s:13:\"Post on Diigo\";b:1;s:20:\"Share this on Viadeo\";b:1;s:15:\"Show %name link\";b:1;s:37:\"There are @count items left to index.\";b:1;s:6:\"<none>\";b:1;s:13:\"service_links\";b:1;s:16:\"Node export link\";b:1;s:51:\"Provide a link to export the node with Node export.\";b:1;s:10:\"@type UUID\";b:1;s:39:\"The universally unique ID of the @type.\";b:1;s:7:\"Arquivo\";b:1;s:5:\"máis\";b:1;s:7:\"Aplicar\";b:1;s:9:\"Reiniciar\";b:1;s:11:\"Ordenar por\";b:1;s:9:\"Show More\";b:1;s:38:\"<div class=\"image\">[field_image]</div>\";b:1;s:36:\"<div class=\"date\">[field_date]</div>\";b:1;s:72:\"<div class=\"author\"><span class=\"label\">por:</span> [field_author]</div>\";b:1;s:3:\"Ler\";b:1;s:20:\"Relevantes - Arquivo\";b:1;s:30:\"Categorías (field_type:delta)\";b:1;s:11:\"Categorías\";b:1;s:7:\"Título\";b:1;s:7:\"Autor/a\";b:1;s:9:\"Etiquetas\";b:1;s:19:\"Texto personalizado\";b:1;s:10:\"Actividade\";b:1;s:6:\"Banner\";b:1;s:7:\"Páxina\";b:1;s:5:\"Lugar\";b:1;s:19:\"Paged, @count items\";b:1;s:24:\"Infinite Scroll: @parent\";b:1;s:11:\"Actividades\";b:1;s:4:\"Mapa\";b:1;s:3:\"[+]\";b:1;s:6:\"Bloque\";b:1;s:5:\"termo\";b:1;s:4:\"Todo\";b:1;s:4:\"Tipo\";b:1;s:4:\"Nome\";b:1;s:9:\"Lonxitude\";b:1;s:5:\"Corpo\";b:1;s:5:\"Valor\";b:1;s:20:\"Bootstrap Components\";b:1;s:18:\"Bootstrap Carousel\";b:1;s:24:\"Bootstrap Carousel Style\";b:1;s:20:\"Bootstrap Thumbnails\";b:1;s:26:\"Bootstrap Thumbnails Style\";b:1;s:14:\"Bootstrap Grid\";b:1;s:20:\"Bootstrap Grid Style\";b:1;s:19:\"Bootstrap Accordion\";b:1;s:25:\"Bootstrap Accordion Style\";b:1;s:13:\"Bootstrap Tab\";b:1;s:19:\"Bootstrap Tab Style\";b:1;s:22:\"Bootstrap Media Object\";b:1;s:28:\"Bootstrap Media Object Style\";b:1;s:15:\"Bootstrap Table\";b:1;s:38:\"Displays rows in Bootstrap Table Style\";b:1;s:57:\"Choose the fields to display in Bootstrap Carousel Style.\";b:1;s:19:\"Bootstrap Thumbnail\";b:1;s:58:\"Choose the fields to display in Bootstrap Thumbnail Style.\";b:1;s:21:\"Elementos por páxina\";b:1;s:8:\"- Todo -\";b:1;s:13:\"Desprazamento\";b:1;s:11:\"« primeira\";b:1;s:12:\"‹ anterior\";b:1;s:12:\"seguinte ›\";b:1;s:10:\"última »\";b:1;s:2:\"by\";s:3:\"por\";s:4:\"Play\";b:1;s:24:\"Image style: %imagestyle\";b:1;s:22:\"Option set: %optionset\";b:1;s:19:\"Show remaining days\";b:1;s:34:\"Image style: None (original image)\";b:1;i:1;b:1;i:2;b:1;i:3;b:1;i:4;b:1;i:5;b:1;s:19:\"Total votes: !count\";b:1;s:10:\"!name logo\";b:1;s:12:\"@count weeks\";b:1;s:33:\"<div class=\"summary\">[body]</div>\";b:1;s:10:\"View Title\";b:1;s:71:\"<p><strong>Últimos materiais <br> incorporados ao arquivo</strong></p>\";b:1;s:9:\"View Link\";b:1;s:63:\"<p><a href=\"/arquivo\"><strong>Arquivo completo</strong></a></p>\";b:1;s:51:\"This form will import bundle and field definitions.\";b:1;s:11:\"Import data\";b:1;s:58:\"Paste the text created by a bundle export into this field.\";b:1;s:32:\"%bundle bundle has been created.\";b:1;s:35:\"%field_name field has been created.\";b:1;s:66:\"%field_name instance has been created for @bundle in @entity_type.\";b:1;s:66:\"%fieldgroup fieldgroup has been saved for @bundle in @entity_type.\";b:1;s:43:\"Usa <em>home</ em> para a portada do sitio.\";b:1;s:10:\"Sección 1\";b:1;s:10:\"Sección 2\";b:1;s:10:\"Sección 3\";b:1;s:10:\"Sección 4\";b:1;s:10:\"Sección 5\";b:1;s:57:\"To clear this field, <a href=\"!reset\">reset the form</a>.\";b:1;s:37:\"Paste the code of a node export here.\";b:1;s:14:\"Reset the form\";b:1;s:25:\"Imported node !nid: !node\";b:1;s:61:\"Retain the theme until a new theme is set for anonymous users\";b:1;s:20:\"Delete ThemeKey Rule\";b:1;s:58:\"Are you sure you want to delete the ThemeKey rule, %title?\";b:1;s:13:\"Enabled theme\";b:1;s:20:\"Compartir en Twitter\";b:1;s:6:\"Enlace\";b:1;s:6:\"Nombre\";b:1;s:7:\"Latitud\";b:1;s:8:\"Longitud\";b:1;s:8:\"término\";b:1;s:66:\"Makes the \'jQuery Easing\' plugin available to Drupal as a library.\";b:1;s:32:\"Administer Isotope Configuration\";b:1;s:37:\"Set configuration options for Isotope\";b:1;s:6:\"config\";b:1;s:7:\"configs\";b:1;s:21:\"Isotope Configuration\";b:1;s:22:\"Isotope Configurations\";b:1;s:12:\"Isotope Grid\";b:1;s:51:\"Display the results using the jQuery Isotope plugin\";b:1;s:14:\"Isotope Filter\";b:1;s:55:\"Display the results formatted to filter an Isotope View\";b:1;s:18:\"Isotope Sort Block\";b:1;s:53:\"Display the results formatted to sort an Isotope View\";b:1;s:34:\"Administer Isotope configurations.\";b:1;s:56:\"A grid layout where items are centered inside each cell.\";b:1;s:67:\"A horizontal grid layout where items are centered inside each cell.\";b:1;s:32:\"Items are arranged horizontally.\";b:1;s:7:\"masonry\";b:1;s:7:\"fitRows\";b:1;s:8:\"vertical\";b:1;s:19:\"Isotope Layout Mode\";b:1;s:18:\"Additional Plugins\";b:1;s:19:\"Transition Duration\";b:1;s:20:\"Use URL for Filters.\";b:1;s:10:\"isFitWidth\";b:1;s:12:\"isHorizontal\";b:1;s:50:\"Arranges items horizontally instead of vertically.\";b:1;s:14:\"Stamp Selector\";b:1;s:44:\"Horizontal Alignment (decimal number 0 to 1)\";b:1;s:42:\"Vertical Alignment (decimal number 0 to 1)\";b:1;s:45:\"Layout direction (implements \"isOriginLeft\").\";b:1;s:15:\"Isotope library\";b:1;s:13:\"jQuery Easing\";b:1;s:21:\"Administer respond.js\";b:1;s:10:\"Respond.js\";b:1;s:29:\"Configure respond.js settings\";b:1;s:17:\"Respond.js script\";b:1;s:55:\"Respond.js will not work with CSS aggregation disabled.\";b:1;s:47:\"Respond.js is not correctly using Libraries API\";b:1;s:71:\"Include Rel attribute for use in lightbox2 or other javascript utility.\";b:1;s:7:\"1 month\";b:1;s:13:\"Download File\";b:1;s:22:\"Download a backup file\";b:1;s:58:\"Aggregates RSS/Atom/RDF feeds, imports CSV files and more.\";s:64:\"Agrega canales RSS/Atom/RDF, importa archivos CSV y otras cosas.\";s:35:\"Administrative UI for Feeds module.\";s:60:\"Interfaz de usuario para administración del modulo Canales.\";s:50:\"An example of a node importer and a user importer.\";s:65:\"Un ejemplo de un importador de nodos y un importador de usuarios.\";s:5:\"Feeds\";s:19:\"Canales de noticias\";s:13:\"Scheduler API\";b:1;s:62:\"Creates scheduler triggers that fire up at certain days, times\";b:1;s:16:\"Administer Feeds\";s:17:\"Administrar Feeds\";s:12:\"Feed node id\";b:1;s:8:\"Feed URL\";s:25:\"URL del canal de noticias\";s:29:\"Your changes have been saved.\";s:28:\"Sus cambios se han guardado.\";s:10:\"Feed title\";s:17:\"Título del canal\";s:9:\"Processor\";s:10:\"Procesador\";s:15:\"Getting started\";s:10:\"Comenzando\";s:7:\"Targets\";s:9:\"Objetivos\";s:8:\"Override\";s:13:\"Sobreescribir\";s:14:\"Basic settings\";s:17:\"Opciones básicas\";s:8:\"Deleting\";s:10:\"Eliminando\";s:7:\"Mapping\";s:13:\"Distribuyendo\";s:23:\"Title of the feed item.\";s:43:\"Título del elemento del canal de noticias.\";s:9:\"Importing\";s:10:\"Importando\";s:8:\"Importer\";s:10:\"Importador\";s:10:\"User email\";s:31:\"Correo electrónico del usuario\";s:11:\"Attached to\";s:9:\"Adjunto a\";s:6:\"Legend\";s:7:\"Rótulo\";s:20:\"As often as possible\";s:35:\"Tan frecuentemente como sea posible\";s:11:\"Author name\";s:16:\"Nombre del autor\";s:14:\"Published date\";s:21:\"Fecha de publicación\";s:6:\"Unique\";s:6:\"Única\";s:12:\"Delete items\";s:18:\"Eliminar elementos\";s:36:\"A description of this configuration.\";s:40:\"Una descripción de esta configuración.\";s:21:\"Select a !plugin_type\";s:26:\"Seleccione un !plugin_type\";s:20:\"Settings for !plugin\";s:28:\"Configuraciones para !plugin\";s:6:\"[none]\";s:9:\"[ninguno]\";s:15:\"every !interval\";s:14:\"cada !interval\";s:23:\"Mapping has been added.\";s:32:\"Se ha agregado la distribución.\";s:20:\"No mappings defined.\";s:32:\"No hay distribuciones definidas.\";s:22:\"Attach to content type\";s:31:\"Adjuntar a un tipo de contenido\";s:11:\"after !time\";s:17:\"después de !time\";s:16:\"Published status\";s:22:\"Estado de publicación\";s:11:\"Feed source\";s:14:\"Fuente de Feed\";s:17:\"Enter a feed URL.\";s:35:\"Introduzca la URL de la fuente web.\";s:12:\"Expire nodes\";s:13:\"Expirar nodos\";s:15:\"Item URL (link)\";s:21:\"Elemento URL (enlace)\";s:9:\"Item GUID\";s:17:\"GUID del elemento\";s:19:\"Use standalone form\";s:29:\"Usar formulario independiente\";s:45:\"The UNIX time when a node has been published.\";s:49:\"La hora UNIX de cuando un nodo ha sido publicado.\";s:18:\"Title of the feed.\";s:16:\"Título del feed\";s:16:\"URL of the feed.\";s:12:\"URL del feed\";s:29:\"Description of the feed item.\";s:22:\"Descripción del feed.\";s:31:\"Name of the feed item\'s author.\";s:44:\"Nombre del autor del elemento de fuente web.\";s:49:\"Published date as UNIX time GMT of the feed item.\";s:68:\"Fecha de publicación como hora UNIX GMT del elemento de fuente web.\";s:21:\"URL of the feed item.\";s:31:\"URL del elemento de fuente web.\";s:42:\"Global Unique Identifier of the feed item.\";s:46:\"Identificador Único Global del elemento feed.\";s:64:\"An array of categories that have been assigned to the feed item.\";s:75:\"Un arreglo de categorías que han sido asignadas al elemento de fuente web.\";s:11:\"Import date\";s:21:\"Fecha de importación\";s:33:\"The end date for the @name field.\";s:46:\"La fecha de finalización para el campo @name.\";s:14:\"Owner feed nid\";s:36:\"Nid de la fuente web del propietario\";s:10:\"Owner feed\";s:26:\"Fuente web del propietario\";s:35:\"Contains the GUID of the feed item.\";s:44:\"Contiene el GUID del elemento de fuente web.\";s:36:\"Filter on a Feeds Item\'s GUID field.\";s:58:\"Filtrar por el campo de GUID de un Elemento de Fuente web.\";s:38:\"Argument on a Feeds Item\'s GUID field.\";s:61:\"Argumentar por el campo de GUID de un Elemento de Fuente web.\";s:34:\"Sort on a Feeds Item\'s GUID field.\";s:58:\"Ordenar por el campo de GUID de un Elemento de Fuente web.\";s:42:\"Contains the import date of the feed item.\";s:57:\"Contiene la fecha de importación del elemento de fuente.\";s:41:\"Sort on a Feeds Item\'s import date field.\";s:69:\"Ordenar por el campo de fecha de importación de un Elemento de Feed.\";s:43:\"Filter on a Feeds Item\'s import date field.\";s:69:\"Filtrar por el campo de fecha de importación de un Elemento de Feed.\";s:45:\"Argument on a Feeds Item\'s import date field.\";s:71:\"Argumentar en el campo de fecha de importación de un Elemento de Feed.\";s:6:\"Unlock\";s:11:\"Desbloquear\";s:16:\"Use PubSubHubbub\";s:17:\"Usar PubSubHubbub\";s:14:\"Designated hub\";s:17:\"«Hub» designado\";s:17:\"Auto detect feeds\";s:33:\"Detección automática de fuentes\";s:38:\"The Drupal user ID of the node author.\";s:46:\"El ID de usuario en Drupal del autor del nodo.\";s:8:\"Item URL\";s:16:\"URL del elemento\";s:34:\"Contains the URL of the feed item.\";s:43:\"Contiene la URL del elemento de fuente web.\";s:35:\"Filter on a Feeds Item\'s URL field.\";s:57:\"Filtrar por el campo de URL de un Elemento de Fuente web.\";s:37:\"Argument on a Feeds Item\'s URL field.\";s:60:\"Argumentar por el campo de URL de un Elemento de Fuente web.\";s:33:\"Sort on a Feeds Item\'s URL field.\";s:57:\"Ordenar por el campo de URL de un Elemento de Fuente web.\";s:32:\"Feed node: Taxonomy: @vocabulary\";s:43:\"Nodo de fuente web: Taxonomía: @vocabulary\";s:50:\"Taxonomy terms from feed node in given vocabulary.\";s:65:\"Términos de taxonomía de nodo de fuente en un vocabulario dado.\";s:18:\"Feed node: User ID\";s:33:\"Nodo de fuente web: ID de usuario\";s:25:\"The feed node author uid.\";s:40:\"El uid del autor del nodo de fuente web.\";s:13:\"Geo Locations\";s:15:\"Geo Ubicaciones\";s:60:\"An array of geographic locations with a name and a position.\";s:69:\"Un arreglo de ubicaciones geográficas con un nombre y una posición.\";s:20:\"Import on submission\";s:18:\"Importar en envío\";s:18:\"Import @name feeds\";s:22:\"Importar fuentes @name\";s:29:\"Delete items from @name feeds\";s:41:\"Borrar elementos de las fuentes web @name\";s:18:\"Attached to: @type\";s:16:\"Adjunto a: @type\";s:15:\"Feeds importers\";s:35:\"Importadores de canales de noticias\";s:29:\"Delete all items from source?\";s:42:\"¿Borrar todos los elementos de la fuente?\";s:22:\"Last import: @ago ago.\";s:32:\"Última importación: hace @ago.\";s:28:\"@count imported items total.\";s:37:\"@count elementos importados en total.\";s:18:\"No imported items.\";s:27:\"No se importaron elementos.\";s:31:\"Periodic import: !import_period\";s:39:\"Importación periódica: !import_period\";s:27:\"Do not import on submission\";s:21:\"No importar al enviar\";s:39:\"A human readable name of this importer.\";s:47:\"El nombre para los usuarios de este importador.\";s:31:\"A description of this importer.\";s:36:\"Una descripción de este importador.\";s:31:\"Requires cron to be configured.\";s:31:\"Requiere que se configure cron.\";s:8:\"Every !p\";s:7:\"Cada !p\";s:15:\"Periodic import\";s:23:\"Importación periódica\";s:58:\"Choose how often a source should be imported periodically.\";s:81:\"Seleccionar con qué frecuencia se debería importar periódicamente una fuente .\";s:21:\"Process in background\";s:24:\"Proceso en segundo plano\";s:27:\"There are no new @entities.\";s:24:\"No hay @entities nuevas.\";s:25:\"Update existing @entities\";s:31:\"Actualizar @entities existentes\";s:32:\"Do not update existing @entities\";s:39:\"No actualizar las @entities excistentes\";s:48:\"The node id of the owner feed node if available.\";s:69:\"El id del nodo del canal de noticias propietario si está disponible.\";s:55:\"Relate a feed item to its owner feed node if available.\";s:97:\"Relacionar un elemento de canal de noticias con su nodo de canal propietario si está disponible.\";s:48:\"Relate a log entry to its importer if available.\";s:73:\"Relacionar una entrada de registro con su importador si está disponible.\";s:9:\"Feed node\";s:25:\"Nodo de canal de noticias\";s:49:\"Relate a log entry to its feed node if available.\";s:89:\"Relacionar una entrada del registro con su nodo de canal de noticias si está disponible.\";s:8:\"Log time\";s:16:\"Hora de registro\";s:22:\"The time of the event.\";s:19:\"La hora del evento.\";s:12:\"Request time\";s:20:\"Hora de la solicitud\";s:41:\"The time of the page request of an event.\";s:45:\"La hora de solicitud de página de un evento.\";s:26:\"Feeds module form elements\";s:58:\"Elementos de formulario del módulo de Canales de noticias\";s:12:\"@name: Start\";s:15:\"@name: Comienzo\";s:12:\"Add importer\";b:1;s:15:\"Import importer\";b:1;s:23:\"No importers available.\";b:1;s:26:\"There are no log messages.\";b:1;s:24:\"Standalone importer page\";b:1;s:14:\"Feed node page\";b:1;s:11:\"All entries\";b:1;s:9:\"Feeds log\";b:1;s:13:\"Imported date\";b:1;s:38:\"The date the source was imported last.\";b:1;s:47:\"Logs events during importing, clearing, expiry.\";b:1;s:6:\"Log id\";b:1;s:26:\"The id of the log message.\";b:1;s:11:\"Importer id\";b:1;s:22:\"The id of an importer.\";b:1;s:25:\"Filter on an importer id.\";b:1;s:20:\"Sort by importer id.\";b:1;s:13:\"Importer name\";b:1;s:39:\"The human readable name of an importer.\";b:1;s:42:\"Filter on a Feeds Source\'s feed_nid field.\";b:1;s:44:\"Argument on a Feeds Source\'s feed_nid field.\";b:1;s:35:\"Sort Feeds Source\'s feed_nid field.\";b:1;s:20:\"Type of log message.\";b:1;s:32:\"The message logged by the event.\";b:1;s:33:\"The severity of the event logged.\";b:1;s:40:\"Filter on the severity of a log message.\";b:1;s:19:\"Mensaxe de rexistro\";b:1;s:10:\"Severidade\";b:1;s:9:\"@importer\";b:1;s:24:\"Automatically add scheme\";b:1;s:15:\"Request timeout\";b:1;s:31:\"Accept invalid SSL certificates\";b:1;s:20:\"Insert new @entities\";b:1;s:27:\"Do not insert new @entities\";b:1;s:26:\"Replace existing @entities\";b:1;s:15:\"Skip hash check\";b:1;s:62:\"Force update of items even if item source data did not change.\";b:1;s:73:\"Action to take when previously imported @entities are missing in the feed\";b:1;s:27:\"Skip non-existent @entities\";b:1;s:29:\"Delete non-existent @entities\";b:1;s:9:\"Authorize\";b:1;s:56:\"Check that the author has permission to create the node.\";b:1;s:6:\"1 year\";b:1;s:28:\"Unpublish non-existent nodes\";b:1;s:8:\"feeds_ui\";b:1;s:58:\"Review log messages of imports and subscriptions to feeds.\";b:1;s:74:\"Tipo de contido empregado polo importador RSS \"Territorio de las mujeres\".\";b:1;s:40:\"The node the feed item was sourced from.\";b:1;s:21:\"Changed @type plugin.\";b:1;s:22:\"Mapping for @processor\";b:1;s:39:\"The Drupal username of the node author.\";b:1;s:37:\"The email address of the node author.\";b:1;s:53:\"The Unix timestamp when a node has been last updated.\";b:1;s:44:\"The two-character language code of the node.\";b:1;s:10:\"@name: End\";b:1;s:11:\"@label: URI\";b:1;s:28:\"The URI of the @label field.\";b:1;s:11:\"@label: Alt\";b:1;s:32:\"The alt tag of the @label field.\";b:1;s:13:\"@label: Title\";b:1;s:30:\"The title of the @label field.\";b:1;s:27:\"URL path alias of the node.\";b:1;s:31:\"The @label field of the entity.\";b:1;s:14:\"@name: Summary\";b:1;s:18:\"Feed node: Node ID\";b:1;s:18:\"The feed node nid.\";b:1;s:19:\"- Select a source -\";b:1;s:25:\"An element from the feed.\";b:1;s:19:\"- Select a target -\";b:1;s:31:\"The field that stores the data.\";b:1;s:10:\"DEPRECATED\";b:1;s:20:\"Target configuration\";b:1;s:19:\"Not used as unique.\";b:1;s:20:\"Text format: %format\";b:1;s:32:\"Used as <strong>unique</strong>.\";b:1;s:25:\"Mapping has been removed.\";b:1;s:3:\"Log\";b:1;s:16:\"Hora de registro\";b:1;s:20:\"Hora de la solicitud\";b:1;s:19:\"Mensaje de registro\";b:1;s:8:\"Gravedad\";b:1;s:11:\"Videofilter\";b:1;s:4:\"e.g.\";b:1;s:17:\"Entrada da Axenda\";b:1;s:31:\"Unlock imports from @name feeds\";b:1;s:12:\"@count items\";b:1;s:9:\"i18n_menu\";b:1;s:25:\"Nodo de canal de noticias\";b:1;s:4:\"más\";b:1;s:23:\"Nombre de la ubicación\";b:1;s:22:\"Ubicación de la calle\";b:1;s:9:\"Adicional\";b:1;s:6:\"Ciudad\";b:1;s:16:\"Estado/Provincia\";b:1;s:33:\"Dirección de correo electrónico\";b:1;s:22:\"Nombre de la provincia\";b:1;s:16:\"Nombre del país\";b:1;s:13:\"Enlace a mapa\";b:1;s:11:\"Coordenadas\";b:1;s:7:\"Resumen\";b:1;s:72:\"A field formatter for rendering values as HTML or comma-separated lists.\";b:1;s:46:\"Textformatter support for contributed modules.\";b:1;s:9:\"Paragraph\";s:8:\"Párrafo\";s:9:\"CSS Class\";s:9:\"Clase CSS\";s:8:\"Header 1\";s:10:\"Cabecera 1\";s:19:\"Unordered HTML list\";b:1;s:24:\"Unordered HTML list (ul)\";b:1;s:22:\"Ordered HTML list (ol)\";b:1;s:20:\"Comma separated list\";b:1;s:34:\"Include \'and\' before the last item\";b:1;s:36:\"Append comma separated list with \'.\'\";b:1;s:24:\"Override comma separator\";b:1;s:68:\"Override the default comma separator with a custom separator string.\";b:1;s:16:\"Custom separator\";b:1;s:22:\"separator HTML wrapper\";b:1;s:37:\"An HTML tag to wrap the separator in.\";b:1;s:11:\"No HTML tag\";b:1;s:4:\"Span\";b:1;s:8:\"Header 4\";b:1;s:8:\"Header 5\";b:1;s:8:\"Header 6\";b:1;s:17:\"Separator classes\";b:1;s:56:\"A CSS class to use in the wrapper tag for the separator.\";b:1;s:12:\"HTML wrapper\";b:1;s:12:\"List classes\";b:1;s:52:\"A CSS class to use in the markup for the field list.\";b:1;s:54:\"Display taxonomy terms as plain text (Not term links).\";b:1;s:66:\"<p><a href=\"/gl/arquivo\"><strong>Arquivo completo</strong></a></p>\";b:1;s:25:\"This is a @name variable.\";b:1;s:46:\"List of variables that can be set for a realm.\";b:1;s:44:\"Override default weight for realm variables.\";b:1;s:42:\"Select variables to be set for this realm.\";b:1;s:53:\"Currently selected variables are: <em>!variables</em>\";b:1;s:18:\"System performance\";b:1;s:72:\"Options related with cache, file compression and bandwidth optimization.\";b:1;s:11:\"User emails\";b:1;s:58:\"Variables that contain metadata about the variable system.\";b:1;s:10:\"Option set\";b:1;s:30:\"Use image title as the caption\";b:1;s:43:\"A human-readable title for this option set.\";b:1;s:15:\"Slide Direction\";b:1;s:5:\"Swing\";b:1;s:6:\"Easing\";b:1;s:47:\"The description appears usually below the item.\";b:1;s:13:\"Smooth Height\";b:1;s:71:\"Animate the height of the slider smoothly for slides of varying height.\";b:1;s:29:\"Animate the slides in reverse\";b:1;s:55:\"Set the speed of the slideshow cycling, in milliseconds\";b:1;s:14:\"Loop Slideshow\";b:1;s:50:\"Loop the slideshow once it reaches the last slide.\";b:1;s:21:\"Randomize Slide Order\";b:1;s:41:\"Randomize the order the slides play back.\";b:1;s:14:\"Starting Slide\";b:1;s:10:\"Item Width\";b:1;s:11:\"Item Margin\";b:1;s:13:\"Minimum Items\";b:1;s:56:\"Minimum number of carousel items that should be visible.\";b:1;s:9:\"Max Items\";b:1;s:56:\"Maximum number of carousel items that should be visible.\";b:1;s:31:\"Navigation and Control Settings\";b:1;s:22:\"Next/Previous Controls\";b:1;s:15:\"Paging Controls\";b:1;s:18:\"Thumbnail Captions\";b:1;s:51:\"Display both thumbnail captions and normal captions\";b:1;s:52:\"Allow slider navigating via keyboard left/right keys\";b:1;s:17:\"Multiple Keyboard\";b:1;s:53:\"Allow keyboard navigation to affect multiple sliders.\";b:1;s:38:\"Allow slider navigating via mousewheel\";b:1;s:5:\"Touch\";b:1;s:29:\"Allow touch swipe navigation.\";b:1;s:18:\"Previous Link Text\";b:1;s:14:\"Next Link Text\";b:1;s:53:\"Must match a simple pattern. \"{container} > {slide}\".\";b:1;s:64:\"Mirror the actions performed on this slider with another slider.\";b:1;s:17:\"Use as navigation\";b:1;s:63:\"Turn the slider into a thumbnail navigation for another slider.\";b:1;s:16:\"Initialize Delay\";b:1;s:45:\"Set an initialization delay, in milliseconds.\";b:1;s:7:\"Use CSS\";b:1;s:47:\"Slider will use CSS3 transitions, if available.\";b:1;s:68:\"Will prevent use of CSS3 3D Transforms, avoiding graphical glitches.\";b:1;s:16:\"Pause State Text\";b:1;s:15:\"Play State Text\";b:1;s:59:\"Pause the slideshow when interacting with control elements.\";b:1;s:14:\"Pause On Hover\";b:1;s:29:\"Controls container (Advanced)\";b:1;s:6:\"Vídeo\";b:1;s:11:\"Video style\";b:1;s:12:\"Video Source\";b:1;s:17:\"Link thumbnail to\";b:1;s:38:\"<div class=\"video\">[field_video]</div>\";b:1;s:13:\"[field_image]\";b:1;s:23:\"Vídeo - Thumbnail path\";b:1;s:38:\"<div class=\"image\">[field_video]</div>\";b:1;s:37:\"A translation was saved successfully.\";b:1;s:2:\"Go\";b:1;s:10:\"- Choose -\";b:1;s:18:\"Views translation.\";b:1;s:7:\"Contido\";b:1;s:22:\"Data de actualización\";b:1;s:4:\"Rúa\";b:1;s:2:\"%2\";b:1;s:2:\"%3\";b:1;s:13:\"Data de envio\";b:1;s:6:\"Posted\";b:1;s:6:\"Rating\";b:1;s:7:\" points\";b:1;s:16:\"Individual votes\";b:1;s:13:\"Tipo de valor\";b:1;s:9:\"Vote type\";b:1;s:14:\"Marca de tempo\";b:1;s:10:\"%1\'s votes\";b:1;s:5:\"autor\";b:1;s:21:\"Conta dos comentarios\";b:1;s:26:\"Data do último comentario\";b:1;s:16:\"Ten novo contido\";b:1;s:17:\"Novos comentarios\";b:1;s:14:\"translate view\";b:1;s:26:\"Internationalization Views\";b:1;s:69:\"Use the locale system as implemented by the Views translation module.\";s:89:\"Utilizar el sistema de localización implementado en el módulo de traducción de vistas.\";s:20:\"Taxonomy term (i18n)\";b:1;s:38:\"Use the locale to interpret arguments.\";b:1;s:20:\"Term ID (translated)\";b:1;s:32:\"The translated taxonomy term ID.\";b:1;s:17:\"Term (translated)\";b:1;s:17:\"Name (translated)\";b:1;s:34:\"The translated taxonomy term name.\";b:1;s:30:\"Translated taxonomy term name.\";b:1;s:29:\"Term description (translated)\";b:1;s:59:\"The translated description associated with a taxonomy term.\";b:1;s:28:\"The language the term is in.\";b:1;s:35:\"Taxonomy terms on node (translated)\";b:1;s:31:\"All taxonomy terms (translated)\";b:1;s:45:\"Has taxonomy term ID (with depth, translated)\";b:1;s:43:\"Has taxonomy terms (with depth, translated)\";b:1;s:33:\"Has taxonomy term ID (translated)\";b:1;s:30:\"Has taxonomy term (translated)\";b:1;s:17:\"Type (translated)\";b:1;s:61:\"Limit this validator to vocabularies that have been localized\";b:1;s:30:\"Localised Term name or synonym\";b:1;s:48:\"Localised Term name/synonym converted to Term ID\";b:1;s:26:\"Created @number @entities.\";b:1;s:23:\";-) Total votes: !count\";b:1;s:51:\"Adds a MediaRSS feed processor to the Feeds module.\";b:1;s:6:\"Title.\";b:1;s:32:\"Author or uploader of the video.\";b:1;s:64:\"This can be imported directly with Taxonomy \"tags\" vocabularies.\";b:1;s:13:\"Media Content\";b:1;s:11:\"Media Adult\";b:1;s:12:\"Media Rating\";b:1;s:11:\"Media Title\";b:1;s:17:\"Media Description\";b:1;s:32:\"Media Keywords (comma separated)\";b:1;s:21:\"Media Thumbnail (URL)\";b:1;s:34:\"Media Categories (comma separated)\";b:1;s:10:\"Media Hash\";b:1;s:18:\"Media Player (URL)\";b:1;s:12:\"Media Credit\";b:1;s:15:\"Media Copyright\";b:1;s:10:\"Media Text\";b:1;s:17:\"Media Restriction\";b:1;s:15:\"Media Community\";b:1;s:32:\"Media Comments (comma separated)\";b:1;s:18:\"Media Embed (HTML)\";b:1;s:33:\"Media Responses (comma separated)\";b:1;s:33:\"Media BackLinks (comma separated)\";b:1;s:12:\"Media Status\";b:1;s:11:\"Media Price\";b:1;s:13:\"Media License\";b:1;s:20:\"Media subTitle (URL)\";b:1;s:20:\"Media peerLink (URL)\";b:1;s:30:\"Media Rights (comma separated)\";b:1;s:30:\"Media Scenes (comma separated)\";b:1;s:44:\"Provides location mappers for feed importers\";b:1;s:40:\"The @label for the location of the node.\";b:1;s:37:\"Map a georss point to location points\";b:1;s:57:\"A generic Feeds parser used to create extensible parsers.\";b:1;s:9:\"Raw value\";s:17:\"valor sin filtrar\";s:3:\"Raw\";s:28:\"Sin modificar <em>(raw)</em>\";s:13:\"Context value\";b:1;s:14:\"Add new source\";b:1;s:9:\"Inner XML\";b:1;s:14:\"Display errors\";b:1;s:15:\"Source encoding\";b:1;s:60:\"The possible encodings of the source files. auto: %encodings\";b:1;s:21:\"Encoding autocomplete\";b:1;s:25:\"The name of source field.\";b:1;s:50:\"Search taxonomy terms by: <strong>@search</strong>\";b:1;s:24:\"Search taxonomy terms by\";b:1;s:11:\"Auto create\";b:1;s:36:\"Create the term if it doesn\'t exist.\";b:1;s:25:\"Deleted @number @entities\";b:1;s:18:\"Africa/Addis_Ababa\";b:1;s:20:\"Africa/Dar_es_Salaam\";b:1;s:15:\"Africa/El_Aaiun\";b:1;s:15:\"Africa/Sao_Tome\";b:1;s:30:\"America/Argentina/Buenos_Aires\";b:1;s:26:\"America/Argentina/La_Rioja\";b:1;s:30:\"America/Argentina/Rio_Gallegos\";b:1;s:26:\"America/Argentina/San_Juan\";b:1;s:26:\"America/Argentina/San_Luis\";b:1;s:22:\"America/Bahia_Banderas\";b:1;s:17:\"America/Boa_Vista\";b:1;s:21:\"America/Cambridge_Bay\";b:1;s:20:\"America/Campo_Grande\";b:1;s:18:\"America/Costa_Rica\";b:1;s:20:\"America/Dawson_Creek\";b:1;s:19:\"America/El_Salvador\";b:1;s:17:\"America/Glace_Bay\";b:1;s:17:\"America/Goose_Bay\";b:1;s:18:\"America/Grand_Turk\";b:1;s:25:\"America/Indiana/Tell_City\";b:1;s:14:\"America/La_Paz\";b:1;s:19:\"America/Los_Angeles\";b:1;s:21:\"America/Lower_Princes\";b:1;s:19:\"America/Mexico_City\";b:1;s:16:\"America/New_York\";b:1;s:27:\"America/North_Dakota/Beulah\";b:1;s:27:\"America/North_Dakota/Center\";b:1;s:30:\"America/North_Dakota/New_Salem\";b:1;s:21:\"America/Port_of_Spain\";b:1;s:19:\"America/Porto_Velho\";b:1;s:19:\"America/Puerto_Rico\";b:1;s:19:\"America/Rainy_River\";b:1;s:20:\"America/Rankin_Inlet\";b:1;s:18:\"America/Rio_Branco\";b:1;s:20:\"America/Santa_Isabel\";b:1;s:21:\"America/Santo_Domingo\";b:1;s:17:\"America/Sao_Paulo\";b:1;s:21:\"America/St_Barthelemy\";b:1;s:16:\"America/St_Johns\";b:1;s:16:\"America/St_Kitts\";b:1;s:16:\"America/St_Lucia\";b:1;s:17:\"America/St_Thomas\";b:1;s:18:\"America/St_Vincent\";b:1;s:21:\"America/Swift_Current\";b:1;s:19:\"America/Thunder_Bay\";b:1;s:16:\"Asia/Ho_Chi_Minh\";b:1;s:14:\"Asia/Hong_Kong\";b:1;s:17:\"Asia/Kuala_Lumpur\";b:1;s:15:\"Asia/Phnom_Penh\";b:1;s:19:\"Atlantic/Cape_Verde\";b:1;s:22:\"Atlantic/South_Georgia\";b:1;s:18:\"Atlantic/St_Helena\";b:1;s:21:\"Australia/Broken_Hill\";b:1;s:19:\"Australia/Lord_Howe\";b:1;s:18:\"Europe/Isle_of_Man\";b:1;s:17:\"Europe/San_Marino\";b:1;s:17:\"Pacific/Pago_Pago\";b:1;s:20:\"Pacific/Port_Moresby\";b:1;s:17:\"@count file names\";b:1;s:11:\"1 file name\";b:1;s:37:\"Updated URL aliases for @count nodes.\";b:1;s:10:\"Categoría\";b:1;s:11:\"Organizador\";b:1;s:8:\"Clone of\";b:1;s:8:\"Frontend\";b:1;s:20:\"Administer Modernizr\";b:1;s:43:\"Perform administration tasks for Modernizr.\";b:1;s:9:\"Modernizr\";b:1;s:13:\"modernizr.com\";b:1;s:58:\"All required tests are present in current Modernizr build.\";b:1;s:15:\"Modernizr Tests\";b:1;s:16:\"1 pending update\";b:1;s:48:\"An overview of libraries installed on this site.\";b:1;s:47:\"Adds support and an API to implement meta tags.\";b:1;s:44:\"Import data from other modules into Metatag.\";b:1;s:44:\"Provides support for applinks.org meta tags.\";b:1;s:49:\"Provides support for Facebook\'s custom meta tags.\";b:1;s:37:\"Provides support for custom favicons.\";b:1;s:51:\"Provides support for Google+ \'itemscope\' meta tags.\";b:1;s:51:\"Provides support for Open Graph Protocol meta tags.\";b:1;s:57:\"Provides Metatag integration within the Panels interface.\";b:1;s:46:\"Provides support for Twitter\'s Card meta tags.\";b:1;s:52:\"Various meta tags for verifying ownership of a site.\";b:1;s:56:\"Provides Metatag integration within the Views interface.\";b:1;s:74:\"Provides additional Open Graph Protocol meta tags for describing products.\";b:1;s:3:\"SEO\";b:1;s:20:\"Administer meta tags\";b:1;s:64:\"Control the main settings pages and modify per-object meta tags.\";b:1;s:14:\"Edit meta tags\";b:1;s:73:\"Modify meta tags on individual entity records (nodes, terms, users, etc).\";b:1;s:7:\"Metatag\";b:1;s:23:\"Configurable meta tags.\";b:1;s:10:\"Basic tags\";b:1;s:13:\"Advanced tags\";b:1;s:8:\"Abstract\";b:1;s:6:\"Robots\";b:1;s:50:\"Allow search engines to index this page (assumed).\";b:1;s:60:\"Allow search engines to follow links on this page (assumed).\";b:1;s:48:\"Prevents search engines from indexing this page.\";b:1;s:58:\"Prevents search engines from following links on this page.\";b:1;s:69:\"Prevents cached copies of this page from appearing in search results.\";b:1;s:57:\"Prevent search engines from indexing images on this page.\";b:1;s:20:\"Google News Keywords\";b:1;s:15:\"Google Standout\";b:1;s:14:\"Content rating\";b:1;s:55:\"Used to indicate the intended audience for the content.\";b:1;s:6:\"Mature\";b:1;s:10:\"Restricted\";b:1;s:17:\"14 years or Older\";b:1;s:13:\"Safe for kids\";b:1;s:15:\"Referrer policy\";b:1;s:11:\"No Referrer\";b:1;s:26:\"No Referrer When Downgrade\";b:1;s:24:\"Origin When Cross-Origin\";b:1;s:10:\"Unsafe URL\";b:1;s:9:\"Generator\";b:1;s:6:\"Rights\";b:1;s:13:\"Canonical URL\";b:1;s:13:\"Shortlink URL\";b:1;s:55:\"A brief URL, often created by a URL shortening service.\";b:1;s:13:\"Publisher URL\";b:1;s:10:\"Author URL\";b:1;s:15:\"Original Source\";b:1;s:17:\"Previous page URL\";b:1;s:13:\"Next page URL\";b:1;s:12:\"Geo position\";b:1;s:14:\"Geo place name\";b:1;s:25:\"A location\'s formal name.\";b:1;s:10:\"Geo region\";b:1;s:4:\"ICBM\";b:1;s:13:\"Revisit After\";b:1;s:6:\"Pragma\";b:1;s:13:\"Cache-Control\";b:1;s:7:\"Expires\";b:1;s:21:\"Metatag configuration\";b:1;s:19:\"Node form meta tags\";b:1;s:27:\"Meta tags on the node form.\";b:1;s:27:\"Configure Metatag defaults.\";b:1;s:17:\"403 access denied\";b:1;s:18:\"404 page not found\";b:1;s:33:\"Inherits meta tags from: @parents\";b:1;s:35:\"No meta tag defaults available yet.\";b:1;s:21:\"Add default meta tags\";b:1;s:11:\"Bulk revert\";b:1;s:32:\"Master controls for all entities\";b:1;s:4:\"Nodo\";b:1;s:19:\"Termo de taxonomía\";b:1;s:15:\"RSS Categorías\";b:1;s:9:\"Usuario/a\";b:1;s:19:\"Additional settings\";b:1;s:19:\"Custom pager string\";b:1;s:28:\"Internationalization options\";b:1;s:24:\"Disable i18n integration\";b:1;s:16:\"Translate output\";b:1;s:43:\"Optionally translate the final page output.\";b:1;s:42:\"Enable logging of translations to Watchdog\";b:1;s:51:\"Optionally log to Watchdog any changes that happen.\";b:1;s:51:\"Output meta tags even if only global settings apply\";b:1;s:31:\"Output meta tags on admin pages\";b:1;s:20:\"Advanced permissions\";b:1;s:65:\"Don\'t load entity\'s default language values if no languages match\";b:1;s:40:\"Load the module\'s default configurations\";b:1;s:21:\"Cache meta tag output\";b:1;s:28:\"Leave core\'s meta tags as-is\";b:1;s:18:\"Page region to use\";b:1;s:9:\"Meta tags\";b:1;s:57:\"This will be able to extract the URL from an image field.\";b:1;s:15:\"!title interval\";b:1;s:20:\"!title interval type\";b:1;s:8:\"- none -\";b:1;s:6:\"Day(s)\";b:1;s:7:\"Week(s)\";b:1;s:8:\"Month(s)\";b:1;s:7:\"Year(s)\";b:1;s:18:\"Título da páxina\";b:1;s:11:\"Descrición\";b:1;s:14:\"Palabras chave\";b:1;s:10:\"Actualizar\";b:1;s:33:\"Meta tags for this taxonomy term.\";b:1;s:24:\"Meta tags for this node.\";b:1;s:24:\"Meta tags for this user.\";b:1;s:12:\"Custom pager\";b:1;s:49:\"The meta tag defaults for @label have been saved.\";b:1;s:30:\"Meta tag module form elements.\";b:1;s:21:\"Título de la página\";b:1;s:12:\"Descripción\";b:1;s:14:\"Palabras clave\";b:1;s:6:\"Imagen\";b:1;s:20:\"Idioma del contenido\";b:1;s:43:\"The Imagecache Token module is recommended.\";b:1;s:62:\"Feeds is currently using this module for one or more importers\";b:1;s:18:\"Modernizr settings\";b:1;s:45:\"Administrative settings for Modernizr module.\";b:1;s:17:\"Rebuild Modernizr\";b:1;s:13:\"textformatter\";b:1;s:13:\"i18n_taxonomy\";b:1;s:9:\"i18nviews\";b:1;s:9:\"libraries\";b:1;s:7:\"metatag\";b:1;s:16:\"Meta tag: !label\";b:1;s:29:\"Add multiple value identifier\";b:1;s:26:\"Ver contador de resultados\";b:1;s:55:\"Load subsequent pages manually instead of automatically\";b:1;s:17:\"Manual load label\";b:1;s:32:\"Label to use on the manual link.\";b:1;s:59:\"Metatag support has been enabled for the @label vocabulary.\";b:1;s:56:\"Makes the jquery touch swipe library available to drupal\";b:1;s:59:\"Administrate the configuration of jquery touch swipe module\";b:1;s:41:\"Permissions for jQuery touch swipe module\";b:1;s:27:\"JQuery touch swipe settings\";b:1;s:29:\"JQuery touch swipe admin form\";b:1;s:51:\"Enable jQuery touch swipe library on specific pages\";b:1;s:60:\"The configuration of jQuery touch swipe is correctly updated\";b:1;s:27:\"Administer Google Analytics\";b:1;s:47:\"Perform maintenance tasks for Google Analytics.\";b:1;s:25:\"Opt-in or out of tracking\";b:1;s:69:\"Allow users to decide if tracking code will be added to pages or not.\";b:1;s:31:\"Use PHP for tracking visibility\";b:1;s:61:\"Enter PHP code in the field for tracking visibility settings.\";b:1;s:16:\"Google Analytics\";b:1;s:15:\"Web Property ID\";b:1;s:14:\"Tracking scope\";b:1;s:7:\"Domains\";b:1;s:22:\"What are you tracking?\";b:1;s:25:\"A single domain (default)\";b:1;s:15:\"Domain: @domain\";b:1;s:35:\"One domain with multiple subdomains\";b:1;s:18:\"Examples: @domains\";b:1;s:26:\"Multiple top-level domains\";b:1;s:25:\"List of top-level domains\";b:1;s:34:\"Every page except the listed pages\";b:1;s:21:\"The listed pages only\";b:1;s:30:\"Add tracking to specific pages\";b:1;s:31:\"Add tracking for specific roles\";b:1;s:30:\"Add to the selected roles only\";b:1;s:42:\"Add to every role except the selected ones\";b:1;s:25:\"opt-in or out of tracking\";b:1;s:55:\"Allow users to customize tracking on their account page\";b:1;s:24:\"No customization allowed\";b:1;s:69:\"Tracking on by default, users with %permission permission can opt out\";b:1;s:69:\"Tracking off by default, users with %permission permission can opt in\";b:1;s:13:\"Track User ID\";b:1;s:19:\"Links and downloads\";b:1;s:30:\"Track clicks on outbound links\";b:1;s:28:\"Track clicks on mailto links\";b:1;s:67:\"Track downloads (clicks on file links) for the following extensions\";b:1;s:32:\"List of download file extensions\";b:1;s:39:\"Track content in colorbox modal dialogs\";b:1;s:60:\"Enable to track the content shown in colorbox modal windows.\";b:1;s:31:\"Track enhanced link attribution\";b:1;s:41:\"Track changing URL fragments as pageviews\";b:1;s:22:\"Track messages of type\";b:1;s:22:\"Search and Advertising\";b:1;s:21:\"Track internal search\";b:1;s:17:\"Track AdSense ads\";b:1;s:22:\"Track display features\";b:1;s:7:\"Privacy\";b:1;s:29:\"Anonymize visitors IP address\";b:1;s:30:\"Universal web tracking opt-out\";b:1;s:17:\"Custom dimensions\";b:1;s:12:\"Index number\";b:1;s:30:\"Custom dimension index #@index\";b:1;s:27:\"The custom dimension value.\";b:1;s:30:\"Custom dimension value #@index\";b:1;s:14:\"Custom metrics\";b:1;s:27:\"Custom metric index #@index\";b:1;s:24:\"The custom metric value.\";b:1;s:27:\"Custom metric value #@index\";b:1;s:32:\"Locally cache tracking code file\";b:1;s:34:\"Track translation sets as one unit\";b:1;s:22:\"Custom JavaScript code\";b:1;s:18:\"Create only fields\";b:1;s:21:\"Code snippet (before)\";b:1;s:20:\"Code snippet (after)\";b:1;s:16:\"Enable debugging\";b:1;s:30:\"Google Analytics configuration\";b:1;s:37:\"Google Analytics module form element.\";b:1;s:23:\"Google Analytics module\";b:1;s:14:\"Not configured\";b:1;s:15:\"User role names\";b:1;s:71:\"The role names the user account is a member of as comma separated list.\";b:1;s:13:\"User role ids\";b:1;s:69:\"The role ids the user account is a member of as comma separated list.\";b:1;s:15:\"Version options\";b:1;s:22:\"Default jQuery Version\";b:1;s:28:\"Default (provided by Drupal)\";b:1;s:46:\"Select which jQuery version to use by default.\";b:1;s:49:\"Alternate jQuery version for administrative pages\";b:1;s:24:\"Created @number @entity.\";b:1;s:28:\"Metatag:Views configurations\";b:1;s:29:\"Provides meta tags for views.\";b:1;s:6:\"Admins\";b:1;s:14:\"Application ID\";b:1;s:23:\"Mobile & UI Adjustments\";b:1;s:11:\"Apple & iOS\";b:1;s:60:\"Custom meta tags used by Apple\'s software, iOS, Safari, etc.\";b:1;s:7:\"Android\";b:1;s:54:\"Custom meta tags used by the Android OS, browser, etc.\";b:1;s:24:\"Windows & Windows Mobile\";b:1;s:11:\"Theme Color\";b:1;s:16:\"Mobile Optimized\";b:1;s:17:\"Handheld-Friendly\";b:1;s:8:\"Viewport\";b:1;s:9:\"Cleartype\";b:1;s:18:\"iTunes App details\";b:1;s:16:\"Web app capable?\";b:1;s:16:\"Status bar color\";b:1;s:16:\"Format detection\";b:1;s:24:\"iOS app link alternative\";b:1;s:28:\"Android app link alternative\";b:1;s:8:\"Manifest\";b:1;s:15:\"X-UA-Compatible\";b:1;s:16:\"Application name\";b:1;s:38:\"MSApplication - Allow domain API calls\";b:1;s:38:\"MSApplication - Allow domain meta tags\";b:1;s:21:\"MSApplication - Badge\";b:1;s:22:\"MSApplication - Config\";b:1;s:32:\"MSApplication - Nav button color\";b:1;s:28:\"MSApplication - Notification\";b:1;s:42:\"MSApplication - Square logo, 150px x 150px\";b:1;s:46:\"The URL to a logo file that is 150px by 150px.\";b:1;s:42:\"MSApplication - Square logo, 310px x 310px\";b:1;s:46:\"The URL to a logo file that is 310px by 310px.\";b:1;s:40:\"MSApplication - Square logo, 70px x 70px\";b:1;s:44:\"The URL to a logo file that is 70px by 70px.\";b:1;s:40:\"MSApplication - Wide logo, 310px x 150px\";b:1;s:46:\"The URL to a logo file that is 310px by 150px.\";b:1;s:25:\"MSApplication - Start URL\";b:1;s:37:\"The URL to the root page of the site.\";b:1;s:20:\"MSApplication - Task\";b:1;s:30:\"MSApplication - Task separator\";b:1;s:26:\"MSApplication - Tile color\";b:1;s:64:\"The HTML color to use as the background color for the live tile.\";b:1;s:26:\"MSApplication - Tile image\";b:1;s:63:\"The URL to an image to use as the background for the live tile.\";b:1;s:23:\"MSApplication - Tooltip\";b:1;s:70:\"Controls the text shown in the tooltip for the pinned site\'s shortcut.\";b:1;s:22:\"MSApplication - Window\";b:1;s:47:\"Nid of the Feed Node that imported this entity.\";b:1;s:36:\"Feed Node that imported this entity.\";b:1;s:26:\"The universally unique ID.\";b:1;s:13:\"Revision UUID\";b:1;s:37:\"The revision\'s universally unique ID.\";b:1;s:15:\"googleanalytics\";b:1;s:10:\"Open Graph\";b:1;s:56:\"A human-readable name for the site, e.g., <em>IMDb</em>.\";b:1;s:46:\"The type of the content, e.g., <em>movie</em>.\";b:1;s:10:\"Activities\";b:1;s:8:\"Activity\";b:1;s:5:\"Sport\";b:1;s:10:\"Businesses\";b:1;s:3:\"Bar\";b:1;s:7:\"Company\";b:1;s:4:\"Cafe\";b:1;s:5:\"Hotel\";b:1;s:10:\"Restaurant\";b:1;s:5:\"Cause\";b:1;s:13:\"Sports league\";b:1;s:11:\"Sports team\";b:1;s:13:\"Organizations\";b:1;s:4:\"Band\";b:1;s:10:\"Government\";b:1;s:10:\"Non-profit\";b:1;s:6:\"School\";b:1;s:10:\"University\";b:1;s:5:\"Actor\";b:1;s:7:\"Athlete\";b:1;s:8:\"Director\";b:1;s:8:\"Musician\";b:1;s:10:\"Politician\";b:1;s:13:\"Public figure\";b:1;s:6:\"Places\";b:1;s:8:\"Landmark\";b:1;s:17:\"State or province\";b:1;s:26:\"Products and Entertainment\";b:1;s:5:\"Album\";b:1;s:5:\"Drink\";b:1;s:4:\"Food\";b:1;s:4:\"Game\";b:1;s:7:\"Product\";b:1;s:4:\"Song\";b:1;s:5:\"Movie\";b:1;s:7:\"TV show\";b:1;s:15:\"TV show episode\";b:1;s:19:\"Miscellaneous video\";b:1;s:8:\"Websites\";b:1;s:18:\"Article (inc blog)\";b:1;s:8:\"Page URL\";b:1;s:13:\"Content title\";b:1;s:50:\"The title of the content, e.g., <em>The Rock</em>.\";b:1;s:24:\"Content title determiner\";b:1;s:10:\"- Ignore -\";b:1;s:19:\"Content description\";b:1;s:49:\"A one to two sentence description of the content.\";b:1;s:32:\"Content modification date & time\";b:1;s:8:\"See also\";b:1;s:24:\"URLs to related content.\";b:1;s:9:\"Image URL\";b:1;s:16:\"Secure image URL\";b:1;s:10:\"Image type\";b:1;s:11:\"Image width\";b:1;s:12:\"Image height\";b:1;s:14:\"Street address\";b:1;s:8:\"Locality\";b:1;s:15:\"Postal/ZIP code\";b:1;s:19:\"Alternative locales\";b:1;s:14:\"Article author\";b:1;s:17:\"Article publisher\";b:1;s:48:\"Links an article to a publisher\'s Facebook page.\";b:1;s:15:\"Article section\";b:1;s:59:\"The primary section of this website the content belongs to.\";b:1;s:14:\"Article tag(s)\";b:1;s:38:\"Appropriate keywords for this content.\";b:1;s:31:\"Article publication date & time\";b:1;s:32:\"Article modification date & time\";b:1;s:30:\"Article expiration date & time\";b:1;s:10:\"First name\";b:1;s:56:\"The first name of the person who\'s Profile page this is.\";b:1;s:9:\"Last name\";b:1;s:23:\"The person\'s last name.\";b:1;s:35:\"A pseudonym / alias of this person.\";b:1;s:6:\"Gender\";b:1;s:9:\"Audio URL\";b:1;s:54:\"The URL to an audio file that complements this object.\";b:1;s:16:\"Audio secure URL\";b:1;s:10:\"Audio type\";b:1;s:13:\"Book\'s author\";b:1;s:11:\"Book\'s ISBN\";b:1;s:17:\"Book release date\";b:1;s:9:\"Book tags\";b:1;s:35:\"Appropriate keywords for this book.\";b:1;s:53:\"The URL to a video file that complements this object.\";b:1;s:16:\"Video secure URL\";b:1;s:11:\"Video width\";b:1;s:23:\"The width of the video.\";b:1;s:12:\"Video height\";b:1;s:24:\"The height of the video.\";b:1;s:10:\"Video type\";b:1;s:8:\"Actor(s)\";b:1;s:69:\"Links to the Facebook profiles for actor(s) that appear in the video.\";b:1;s:12:\"Actors\' role\";b:1;s:26:\"The roles of the actor(s).\";b:1;s:11:\"Director(s)\";b:1;s:72:\"Links to the Facebook profiles for director(s) that worked on the video.\";b:1;s:15:\"Scriptwriter(s)\";b:1;s:65:\"Links to the Facebook profiles for scriptwriter(s) for the video.\";b:1;s:24:\"Video duration (seconds)\";b:1;s:34:\"The length of the video in seconds\";b:1;s:12:\"Release date\";b:1;s:32:\"The date the video was released.\";b:1;s:37:\"Tag words associated with this video.\";b:1;s:6:\"Series\";b:1;s:35:\"The TV show this series belongs to.\";b:1;s:13:\"Nome do sitio\";b:1;s:15:\"Tipo de contido\";b:1;s:5:\"Área\";b:1;s:19:\"Correo electrónico\";b:1;s:17:\"Nome de usuario/a\";b:1;s:8:\"Etiqueta\";b:1;s:21:\"Open Graph - Products\";b:1;s:51:\"These Open Graph meta tags for describing products.\";b:1;s:5:\"Price\";b:1;s:8:\"Currency\";b:1;s:36:\"The currency for the price (if any).\";b:1;s:12:\"Availability\";b:1;s:5:\"Brand\";b:1;s:3:\"UPC\";b:1;s:3:\"EAN\";b:1;s:4:\"ISBN\";b:1;s:12:\"Plural Title\";b:1;s:11:\"Retailer ID\";b:1;s:13:\"Retailer Name\";b:1;s:27:\"Retailer SKU/Product Number\";b:1;s:28:\"Manufacturer SKU/Part Number\";b:1;s:12:\"Product Link\";b:1;s:8:\"Material\";b:1;s:7:\"Pattern\";b:1;s:20:\"Shipping Cost Amount\";b:1;s:22:\"Shipping Cost Currency\";b:1;s:14:\"Product Weight\";b:1;s:20:\"Product Weight Units\";b:1;s:15:\"Shipping Weight\";b:1;s:21:\"Shipping Weight Units\";b:1;s:10:\"Expiration\";b:1;s:9:\"Condition\";b:1;s:61:\"A title to be used to describe multiple items of this product\";b:1;s:60:\"A Facebook ID (or reference to the profile) of the retailer.\";b:1;s:25:\"The name of the retailer.\";b:1;s:23:\"A retailer part number.\";b:1;s:27:\"A manufacturer part number.\";b:1;s:7:\"Tamaño\";b:1;s:47:\"A size describing the product, such as S, M, L.\";b:1;s:41:\"A link to find out more about the product\";b:1;s:3:\"Cor\";b:1;s:55:\"A description of the material used to make the product.\";b:1;s:34:\"A description of the pattern used.\";b:1;s:19:\"The shipping costs.\";b:1;s:27:\"The shipping cost currency.\";b:1;s:39:\"The weight, without shipping materials.\";b:1;s:19:\"The unit of weight.\";b:1;s:20:\"The shipping weight.\";b:1;s:28:\"The unit of shipping weight.\";b:1;s:61:\"A time representing when the product expired, or will expire.\";b:1;s:29:\"The condition of the product.\";b:1;s:16:\"Unable to create\";b:1;s:25:\"No description available.\";b:1;s:23:\"Current Modernizr Tests\";b:1;s:40:\"Download your Modernizr production build\";b:1;s:16:\"clear your cache\";b:1;s:20:\"Nombre del sitio web\";b:1;s:17:\"Tipo de contenido\";b:1;s:7:\"Región\";b:1;s:16:\"Regionalización\";b:1;s:17:\"Nombre de usuario\";b:1;s:14:\"URL del vídeo\";b:1;s:42:\"Are you sure you want to delete this item?\";b:1;s:15:\"Deleted 1 post.\";b:1;s:40:\"Exclude certain pages from being cached.\";b:1;s:16:\"Cache exclusions\";b:1;s:40:\"Configure pages to exclude from caching.\";b:1;s:29:\"Pages to exclude from caching\";b:1;s:37:\"Content types to exclude from caching\";b:1;s:58:\"Check all content types that you do not want to be cached.\";b:1;s:24:\"administer block classes\";b:1;s:37:\"clear territorio_de_las_mujeres feeds\";b:1;s:38:\"import territorio_de_las_mujeres feeds\";b:1;s:16:\"administer feeds\";b:1;s:38:\"unlock territorio_de_las_mujeres feeds\";b:1;s:27:\"administer google analytics\";b:1;s:31:\"use PHP for tracking visibility\";b:1;s:29:\"administer menu_trail_by_path\";b:1;s:14:\"edit meta tags\";b:1;s:20:\"administer meta tags\";b:1;s:29:\"delete own diary_item content\";b:1;s:25:\"create diary_item content\";b:1;s:27:\"edit any diary_item content\";b:1;s:27:\"edit own diary_item content\";b:1;s:29:\"delete any diary_item content\";b:1;s:23:\"delete own home content\";b:1;s:19:\"create home content\";b:1;s:21:\"edit any home content\";b:1;s:21:\"edit own home content\";b:1;s:23:\"delete any home content\";b:1;s:12:\"export nodes\";b:1;s:16:\"export own nodes\";b:1;s:23:\"use PHP to import nodes\";b:1;s:20:\"administer respondjs\";b:1;s:20:\"access service links\";b:1;s:30:\"use PHP for service visibility\";b:1;s:15:\"edit terms in 4\";b:1;s:17:\"delete terms in 4\";b:1;s:15:\"administer uuid\";b:1;s:20:\"administer modernizr\";b:1;s:31:\"administer custom search blocks\";b:1;s:24:\"use custom search blocks\";b:1;s:24:\"administer custom search\";b:1;s:17:\"use custom search\";b:1;}s:4:\"ampm\";a:2:{s:2:\"am\";s:2:\"am\";s:2:\"pm\";s:2:\"pm\";}s:18:\"compression format\";a:1:{s:3:\"Zip\";s:40:\"Zip\r\nen contexto: formato de compresión\";}s:8:\"datetime\";a:7:{s:4:\"Year\";s:4:\"Año\";s:5:\"Month\";s:3:\"Mes\";s:3:\"Day\";s:4:\"Día\";s:4:\"Hour\";s:4:\"Hora\";s:6:\"Minute\";s:6:\"Minuto\";s:6:\"Second\";s:7:\"Segundo\";s:4:\"Date\";s:5:\"Fecha\";}s:11:\"geolocation\";a:1:{s:8:\"Location\";s:10:\"Ubicación\";}s:15:\"Long month name\";a:10:{s:5:\"April\";s:5:\"Abril\";s:7:\"January\";s:5:\"Enero\";s:5:\"March\";s:5:\"Marzo\";s:3:\"May\";s:4:\"Mayo\";s:4:\"June\";s:5:\"Junio\";s:4:\"July\";s:5:\"Julio\";s:9:\"September\";s:10:\"Septiembre\";s:7:\"October\";s:7:\"Octubre\";s:8:\"November\";s:9:\"Noviembre\";s:8:\"December\";s:9:\"Diciembre\";}s:10:\"Sort order\";a:2:{s:12:\"Alphabetical\";s:11:\"Alfabético\";s:9:\"Numerical\";s:9:\"Numérico\";}}',0,1473282231,1),('locale:gl','a:7:{s:0:\"\";a:7179:{s:4:\"Show\";s:6:\"Amosar\";s:3:\"All\";s:4:\"Todo\";s:14:\"Hide shortcuts\";s:15:\"Ocultar atallos\";s:12:\"(active tab)\";s:15:\"(solapa activa)\";s:4:\"Edit\";s:6:\"Editar\";s:7:\"Enabled\";s:8:\"Activado\";s:8:\"Disabled\";s:11:\"Desactivado\";s:12:\"Public files\";s:18:\"Arquivos públicos\";s:43:\"Public local files served by the webserver.\";s:53:\"Arquivos locais públicos servidos polo servidor web.\";s:15:\"Temporary files\";s:18:\"Arquivos temporais\";s:46:\"Temporary local files for upload and previews.\";s:56:\"Arquivos locais temporais para subidas e vistas previas.\";s:9:\"Languages\";s:7:\"Idiomas\";s:55:\"Configure languages for content and the user interface.\";s:63:\"Configura os idiomas para o contido e a interface de usuario/a.\";s:4:\"Long\";s:5:\"Longo\";s:6:\"Medium\";s:5:\"Medio\";s:5:\"Short\";s:5:\"Curto\";s:25:\"Drupal core update status\";s:45:\"Estado de actualización do núcleo de Drupal\";s:24:\"No update data available\";s:55:\"Non hai información sobre actualizacións dispoñíbel\";s:17:\"Weight for @title\";s:16:\"Peso para @title\";s:13:\"Left to right\";s:18:\"Esquerda a dereita\";s:17:\"Enabled languages\";s:17:\"Lenguaxes activos\";s:16:\"Default language\";s:22:\"Língua predeterminada\";s:18:\"Save configuration\";s:23:\"Gardar a configuración\";s:7:\"Content\";s:7:\"Contido\";s:4:\"Help\";s:5:\"Axuda\";s:8:\"Page top\";s:25:\"Parte superior da páxina\";s:11:\"Page bottom\";s:24:\"Zona inferior da páxina\";s:13:\"First sidebar\";s:22:\"Primeira barra lateral\";s:16:\"Dashboard (main)\";b:1;s:19:\"Dashboard (sidebar)\";b:1;s:20:\"Dashboard (inactive)\";b:1;s:4:\"List\";s:5:\"Lista\";s:12:\"Add language\";s:17:\"Engadir un idioma\";s:23:\"Detection and selection\";s:23:\"Detección e selección\";s:10:\"My account\";s:13:\"A miña conta\";s:7:\"Log out\";s:14:\"Cerrar sesión\";s:4:\"Home\";s:6:\"Inicio\";s:14:\"Administration\";s:15:\"Administración\";s:10:\"Appearance\";s:10:\"Apariencia\";s:33:\"Select and configure your themes.\";s:37:\"Selecciona e configura os teus temas.\";s:13:\"Configuration\";s:14:\"Configuración\";s:20:\"Administer settings.\";s:29:\"Administrar a configuración.\";s:17:\"Content authoring\";s:19:\"Autoría do contido\";s:53:\"Settings related to formatting and authoring content.\";s:55:\"Opcións relacionadas co formato e autoría do contido.\";s:11:\"Development\";s:16:\"Desenvolvemento.\";s:18:\"Development tools.\";s:31:\"Ferramentas de desenvolvemento.\";s:5:\"Media\";s:6:\"Medios\";s:12:\"Media tools.\";s:23:\"Ferramentas multimedia.\";s:6:\"People\";s:7:\"Persoas\";s:24:\"Configure user accounts.\";s:29:\"Configurar contas de usuario.\";s:21:\"Regional and language\";s:21:\"Rexionais e de idioma\";s:48:\"Regional settings, localization and translation.\";s:56:\"Configuración rexionais, de localización e tradución.\";s:13:\"Date and time\";s:11:\"Data e hora\";s:44:\"Configure display formats for date and time.\";s:54:\"Configurar formatos de presentación para data e hora.\";s:17:\"Regional settings\";s:23:\"Configuración rexional\";s:54:\"Settings for the site\'s default time zone and country.\";s:65:\"Opcións predeterminadas para o sitio de fuso horario e do país.\";s:19:\"Translate interface\";s:18:\"Traducir interface\";s:59:\"Translate the built in interface and optionally other text.\";s:61:\"Traducir a interface integrada e opcionalmente outros textos.\";s:19:\"Search and metadata\";s:17:\"Busca e metadatos\";s:36:\"Local site search, metadata and SEO.\";s:40:\"Busca interna do sitio, metadatos e SEO.\";s:6:\"System\";s:7:\"Sistema\";s:37:\"General system related configuration.\";s:44:\"Configuración relacionada co sistema xeral.\";s:14:\"User interface\";s:20:\"Interface de usuario\";s:38:\"Tools that enhance the user interface.\";s:48:\"Ferramentas que melloran a interface de usuario.\";s:12:\"Web services\";s:12:\"Servizos web\";s:30:\"Tools related to web services.\";s:42:\"Ferramentas relacionadas con servizos web.\";s:8:\"Workflow\";s:17:\"Fluxo de traballo\";s:43:\"Content workflow, editorial workflow tools.\";s:73:\"Fluxo de traballo do contido, ferramentas de fluxo de traballo editorial.\";s:32:\"Administer content and comments.\";s:34:\"Administrar contido e comentarios.\";s:9:\"Dashboard\";s:16:\"Panel de control\";s:34:\"View and customize your dashboard.\";s:31:\"Ver e personalizar o seu panel.\";s:48:\"Reference for usage, configuration, and modules.\";s:46:\"Referencia de uso, configuración, e módulos.\";s:5:\"Index\";s:7:\"Índice\";s:7:\"Modules\";s:8:\"Módulos\";s:26:\"Extend site functionality.\";s:39:\"Estender a funcionalidade do sitio web.\";s:45:\"Manage user accounts, roles, and permissions.\";s:48:\"Xestionar contas de usuarios, papeis e permisos.\";s:7:\"Reports\";s:8:\"Informes\";s:34:\"View reports, updates, and errors.\";s:38:\"Ver informes, actualizacións e erros.\";s:9:\"Structure\";s:9:\"Estrutura\";s:45:\"Administer blocks, content types, menus, etc.\";s:51:\"Administrar bloques, tipos de contido, menús, etc.\";s:5:\"Tasks\";s:7:\"Tarefas\";s:30:\"Add to %shortcut_set shortcuts\";s:34:\"Engadir a atallos to %shortcut_set\";s:12:\"You are here\";s:19:\"Vostede está aquí\";s:14:\"Status message\";s:17:\"Mensaxe de estado\";s:13:\"Error message\";s:15:\"Mensaxe de erro\";s:15:\"Warning message\";s:16:\"Mensaxe de aviso\";s:12:\"Primary tabs\";s:19:\"Pestanas principais\";s:24:\"!local-task-title!active\";s:24:\"!local-task-title!active\";s:13:\"Enable !title\";s:14:\"Activar @title\";s:21:\"Set !title as default\";s:38:\"Seleccionar !title como predeterminada\";s:16:\"!title !required\";s:16:\"!title !required\";s:4:\"edit\";s:6:\"editar\";s:6:\"delete\";s:8:\"eliminar\";s:12:\"English name\";s:15:\"Nome en inglés\";s:11:\"Native name\";s:11:\"Nome nativo\";s:4:\"Code\";s:7:\"Código\";s:9:\"Direction\";s:10:\"Dirección\";s:7:\"Default\";s:14:\"Predeterminado\";s:6:\"Weight\";s:4:\"Peso\";s:10:\"Operations\";s:11:\"Operacións\";s:22:\"Administrative toolbar\";s:35:\"Barra de ferramentas administrativa\";s:32:\"Hello <strong>@username</strong>\";s:35:\"Benvido, <strong>@username</strong>\";s:12:\"User account\";s:16:\"Conta de usuario\";s:11:\"Add content\";s:15:\"Agregar contido\";s:14:\"Edit shortcuts\";s:14:\"Editar atallos\";s:20:\"Skip to main content\";s:22:\"Ir o contido principal\";s:20:\"Configuration saved.\";s:23:\"Configuración gardada.\";s:19:\"User interface text\";s:29:\"Texto da interfaze do usuario\";s:3:\"URL\";s:3:\"URL\";s:60:\"Determine the language from the URL (Path prefix or domain).\";s:65:\"Determinar a lingua a partir da URL (prefixo da ruta ou dominio).\";s:7:\"Session\";s:7:\"Sesión\";s:56:\"Determine the language from a request/session parameter.\";s:68:\"Determinar a lingua a partir dun parámetro de petición ou sesión.\";s:4:\"User\";s:9:\"Usuario/a\";s:38:\"Follow the user\'s language preference.\";s:44:\"Seguir as preferencias de lingua do usuario.\";s:7:\"Browser\";s:9:\"Navegador\";s:60:\"Determine the language from the browser\'s language settings.\";s:70:\"Determinar o idioma a partir da configuración de idioma do navegador.\";s:9:\"Interface\";s:9:\"Interface\";s:36:\"Use the detected interface language.\";s:41:\"Utilizar o idioma de interface detectado.\";s:12:\"URL fallback\";s:15:\"URl alternativa\";s:59:\"Use an already detected language for URLs if none is found.\";s:64:\"Usa unha linguaxe xa detectada para a URL se non atopa ningunha.\";s:47:\"Use the default site language (@language_name).\";s:59:\"Empregar a lingua predeterminada do sitio (@language_name).\";s:24:\"@type language detection\";s:29:\"detección de lingua de @type\";s:24:\"@title language provider\";s:26:\"Proveedor de idioma @title\";s:9:\"Configure\";s:10:\"Configurar\";s:13:\"Save settings\";s:17:\"Gardar os axustes\";s:40:\"Session language detection configuration\";s:49:\"Configuración da detección de idioma da sesión\";s:36:\"URL language detection configuration\";s:45:\"Configuración da detección de idioma da URL\";s:16:\"Detection method\";s:21:\"Método de detección\";s:11:\"Description\";s:11:\"Descrición\";s:64:\"Field type(s) in use - see <a href=\"@fields-page\">Field list</a>\";s:75:\"Tipo(s) de campo en uso - vexa a <a href=\"@fields-page\">lista de campos</a>\";s:54:\"@module (<span class=\"admin-disabled\">disabled</span>)\";s:57:\"@module (<span class=\"admin-disabled\">desactivado</span>)\";s:18:\"Manages web fonts.\";b:1;s:6:\"Enable\";s:7:\"Activar\";s:52:\"@module (<span class=\"admin-enabled\">enabled</span>)\";s:53:\"@module (<span class=\"admin-enabled\">activado</span>)\";s:44:\"Administrative interface for managing fonts.\";b:1;s:57:\"Aggregates syndicated content (RSS, RDF, and Atom feeds).\";s:54:\"Agrega o contido distribuido (orixes RSS, RDF e Atom).\";s:5:\"About\";s:12:\"Información\";s:4:\"Uses\";s:4:\"Usos\";s:19:\"Positioning content\";s:20:\"Posicionando contido\";s:22:\"Controlling visibility\";s:26:\"Controlando a visibilidade\";s:22:\"Creating custom blocks\";s:30:\"Creando bloques personalizados\";s:11:\"Permissions\";s:8:\"Permisos\";s:21:\"Configure permissions\";s:19:\"Configurar permisos\";s:6:\"Blocks\";s:7:\"Bloques\";s:68:\"Enables language selector for blocks and optional block translation.\";b:1;s:25:\"Enables multi-user blogs.\";s:30:\"Activa os blogs multi usuario.\";s:66:\"Allows users to create and organize related content in an outline.\";s:75:\"Permite os usuarios crear e organizar os contidos relacionados nun índice.\";s:67:\"Performs bulk exporting of data objects known about by Chaos tools.\";b:1;s:42:\"Import and exports bundles through the UI.\";b:1;s:46:\"A library of helpful tools by Merlin of Chaos.\";b:1;s:41:\"Shows how to use the power of Chaos AJAX.\";b:1;s:52:\"@module (<span class=\"admin-missing\">missing</span>)\";s:56:\"@module (<span class=\"admin-missing\">non atopado</span>)\";s:15:\"Changing colors\";s:15:\"Cambiando cores\";s:70:\"Allows administrators to change the color scheme of compatible themes.\";s:82:\"Permite os administradores cambiar o esquema de cor dos temas compatibles con él.\";s:27:\"Default and custom settings\";s:41:\"Opcións predeterminadas e personalizadas\";s:16:\"Comment approval\";s:25:\"Aprobación do comentario\";s:8:\"Comments\";s:11:\"Comentarios\";s:59:\"List and edit site comments and the comment approval queue.\";s:81:\"Enumerar e editar os comentarios do sitio e a cola de aprobación de comentarios.\";s:57:\"Allows users to comment on and discuss published content.\";s:60:\"Permite aos usuarios comentar e debatir o contido publicado.\";s:61:\"Enables the use of both personal and site-wide contact forms.\";s:70:\"Permite o uso tanto de formularios de contacto persoais como de sitio.\";s:63:\"Makes contact categories and replies available for translation.\";b:1;s:57:\"Allows content to be translated into different languages.\";s:58:\"Permite que o contido sexa traducido a diferentes idiomas.\";s:27:\"Displaying contextual links\";s:31:\"Presentando enlaces contextuais\";s:22:\"Tracking user activity\";s:37:\"Monitorizando a actividade do usuario\";s:25:\"Tracking content activity\";s:37:\"Monitorizando a actividade do contido\";s:19:\"Customize dashboard\";s:30:\"Personalizar panel de control.\";s:25:\"Customize your dashboard.\";s:36:\"Personalizar o seu panel de control.\";s:20:\"Monitoring your site\";s:25:\"Monitorizando o seu sitio\";s:23:\"Debugging site problems\";s:29:\"Depurando problemas do sitio.\";s:47:\"Logs and records system events to the database.\";s:56:\"Rexistra e garda os eventos do sistema na base de datos.\";s:40:\"@font-your-face provider for Edge Fonts.\";b:1;s:43:\"Remove default content from the front page.\";b:1;s:20:\"Enabling field types\";s:24:\"Activando tipos de campo\";s:27:\"Managing field data storage\";s:46:\"Xestionando o almacenamento de datos de campo.\";s:57:\"Field API to add fields to entities like nodes and users.\";s:64:\"API para engadir campos a entidades tales coma nodos e usuarios.\";s:37:\"Stores field data in an SQL database.\";s:51:\"Almacena os datos do campo nunha base de datos SQL.\";s:26:\"Translate field properties\";b:1;s:15:\"Planning fields\";s:24:\"Campos de planificación\";s:29:\"What the field will be called\";s:25:\"Cómo se chamará o campo\";s:38:\"What type of data the field will store\";s:37:\"Tipo de datos que almacenará o campo\";s:40:\"How the data will be input and displayed\";s:43:\"Como se introducirán e mostrarán os datos\";s:36:\"How many values the field will store\";s:42:\"Número de valores que almacenará o campo\";s:14:\"Reusing fields\";s:19:\"Reutilizando campos\";s:23:\"Fields on content items\";s:31:\"Campos nos elementos de contido\";s:24:\"Fields on taxonomy terms\";s:33:\"Campos en términos de taxonomía\";s:23:\"Fields on user accounts\";s:28:\"Campos en contas de usuarios\";s:18:\"Fields on comments\";s:21:\"Campos en comentarios\";s:33:\"User interface for the Field API.\";s:42:\"Interfaze de usuario para o API de campos.\";s:26:\"Attaching files to content\";s:27:\"Anexando arquivos o contido\";s:27:\"Managing attachment display\";s:38:\"Xestionando presentación dos adxuntos\";s:23:\"Managing file locations\";s:34:\"Xestionando ubicación de arquivos\";s:26:\"Defines a file field type.\";s:33:\"Define un tipo de campo ficheiro.\";s:24:\"Configuring text formats\";s:30:\"Configurando formatos de texto\";s:24:\"Applying filters to text\";s:26:\"Aplicando filtros ó texto\";s:21:\"Defining text formats\";s:27:\"Definindo formatos de texto\";s:22:\"Choosing a text format\";s:30:\"Escollendo un formato de texto\";s:12:\"Text formats\";s:17:\"Formatos do texto\";s:43:\"Filters content in preparation for display.\";s:61:\"Filtros de contido en preparación para a sua visualización.\";s:48:\"Enables fivestar ratings on content, users, etc.\";b:1;s:52:\"Iconic font designed for use with Twitter Bootstrap.\";b:1;s:56:\"Defines a field type for referencing a font from a node.\";b:1;s:50:\"@font-your-face provider with Font Squirrel fonts.\";b:1;s:52:\"@font-your-face provider of fonts from Fontdeck.com.\";b:1;s:49:\"@font-your-face provider of fonts from Fonts.com.\";b:1;s:27:\"Provides discussion forums.\";s:32:\"Proporciona foros de discusión.\";s:59:\"Provide the ability to use infinite pager on defined url\'s.\";b:1;s:48:\"Views plugins to show Google Maps from entities.\";b:1;s:48:\"GMap field types, currently only a marker field.\";b:1;s:50:\"Display location.module information on Google Maps\";b:1;s:28:\"UI for building GMap macros.\";b:1;s:66:\"A module that lets you add more styles to your gmap popup bubbles.\";b:1;s:22:\"Taxonomy based markers\";b:1;s:43:\"@font-your-face provider with Google fonts.\";b:1;s:26:\"Providing a help reference\";s:31:\"Proporciona axuda de referencia\";s:32:\"Providing context-sensitive help\";s:40:\"Proporciona axuda dependente do contexto\";s:35:\"Manages the display of online help.\";s:44:\"Xestiona a visualización da axuda en liña.\";s:19:\"Manipulating images\";s:18:\"Manipulando imaxes\";s:60:\"Based on where it will be used: eg. <em>profile-picture</em>\";s:69:\"Basándose ónde se empregará; por exemplo: <em>imaxe-de_perfil</em>\";s:52:\"Describing its appearance: eg. <em>square-85x85</em>\";s:68:\"Describindo a sua apariencia; por exemplo: <em>cadrado - 85×85</em>\";s:37:\"Attaching images to content as fields\";s:37:\"Anexando imaxes o contido como campos\";s:12:\"Image styles\";s:16:\"Estilos de imaxe\";s:34:\"Provides image manipulation tools.\";s:51:\"Proporciona ferramentas de manipulación de imaxes.\";s:49:\"Extends Drupal support for multilingual features.\";b:1;s:39:\"Create reusable Isotope configurations.\";b:1;s:44:\"An example of how to use the Isotope module.\";b:1;s:40:\"Create isotope views from views queries.\";b:1;s:13:\"jQuery update\";b:1;s:53:\"Update jQuery and jQuery UI to a more recent version.\";b:1;s:39:\"Add jQuery Waypoints plugin to the site\";b:1;s:64:\"Allows version-dependent and shared usage of external libraries.\";b:1;s:32:\"Defines simple link field types.\";b:1;s:69:\"Defines list field types. Use with Options to create selection lists.\";s:85:\"Define tipos de campos de listas. Úseo con opcións para crear listas de selección.\";s:26:\"Translating interface text\";s:29:\"Traducindo texto da interface\";s:64:\"Translations of text in the Drupal interface may be provided by:\";s:69:\"As traducións do texto da interface de Drupal as poden proporcionar:\";s:31:\"Configuring a multilingual site\";s:34:\"Configurando un sitio multi idioma\";s:58:\"Provides automatic downloads and updates for translations.\";s:72:\"Proporciona descargas e actualizaciós automáticas para as traducións.\";s:65:\"Adds a \'Find Address\' button to all location fields that use gmap\";b:1;s:39:\"Fill up all locations with lat&lon data\";b:1;s:30:\"Defines a Location field type.\";b:1;s:13:\"Content types\";s:16:\"Tipos de contido\";s:49:\"Allows you to add an email address to a location.\";b:1;s:58:\"Provide information about Location field to Entity module.\";b:1;s:5:\"Menus\";s:6:\"Menús\";s:45:\"Allows you to add a fax number to a location.\";b:1;s:52:\"Bulk assign random latitude and longitudes to nodes.\";b:1;s:8:\"Taxonomy\";s:10:\"Taxonomía\";s:47:\"Allows you to add a phone number to a location.\";b:1;s:67:\"Manage tagging, categorization, and classification of your content.\";s:76:\"Xestiona o etiquetado, a categorización, e a clasificación do seu contido.\";s:35:\"Advanced search page for locations.\";b:1;s:4:\"view\";s:5:\"vista\";s:40:\"Associate locations with taxonomy terms.\";b:1;s:4:\"View\";s:3:\"Ver\";s:45:\"Allows you to add a www adress to a location.\";b:1;s:5:\"views\";s:6:\"vistas\";s:5:\"Views\";s:6:\"Vistas\";s:14:\"Managing menus\";s:18:\"Xestionando menús\";s:73:\"This action will permanently remove any customizations made to this view.\";s:95:\"Esta acción eliminará permanentemente cualquera personalización que foxe feita a esta vista.\";s:27:\"The view has been reverted.\";s:25:\"Esta vista foi revertida.\";s:16:\"Displaying menus\";s:18:\"Presentando menús\";s:64:\"This action will permanently remove the view from your database.\";s:69:\"Esta acción eliminará permanentemente a vista da sua base de datos.\";s:26:\"The view has been deleted.\";s:22:\"A vista foi eliminada.\";s:60:\"Allows administrators to customize the site navigation menu.\";s:73:\"Permite aos administradores personalizar o menú de navegación do sitio.\";s:40:\"Supports translatable custom menu items.\";b:1;s:7:\"Disable\";s:10:\"Desactivar\";s:13:\"Module filter\";b:1;s:6:\"Revert\";s:6:\"Volver\";s:46:\"Configure how the modules page looks and acts.\";b:1;s:6:\"Delete\";s:6:\"Borrar\";s:24:\"Filter the modules list.\";b:1;s:5:\"Clone\";s:6:\"Clonar\";s:46:\"Extended node options for multilingual content\";b:1;s:6:\"Import\";s:8:\"Importar\";s:60:\"Enables multilingual forum, translates names and containers.\";b:1;s:6:\"Export\";s:8:\"Exportar\";s:45:\"API module for multilingual content selection\";b:1;s:17:\"Add a new @plugin\";b:1;s:19:\"Edit @plugin %title\";b:1;s:16:\"Creating content\";s:15:\"Creando contido\";s:20:\"Clone @plugin %title\";b:1;s:14:\"Import @plugin\";b:1;s:29:\"Creating custom content types\";s:39:\"Creando tipos de contido personalizados\";s:21:\"Export @plugin %title\";b:1;s:39:\"Are you sure you want to revert %title?\";b:1;s:21:\"Administering content\";s:21:\"Administrando contido\";s:73:\"This action will permanently remove any customizations made to this item.\";b:1;s:27:\"The item has been reverted.\";b:1;s:18:\"Creating revisions\";s:18:\"Creando revisións\";s:39:\"Are you sure you want to delete %title?\";s:39:\"Está seguro de querer eliminar %title?\";s:66:\"This action will permanently remove this item from your database..\";b:1;s:16:\"User permissions\";s:19:\"Permisos de usuario\";s:26:\"The item has been deleted.\";b:1;s:24:\"%title has been created.\";b:1;s:66:\"Allows content to be submitted to the site and displayed on pages.\";s:68:\"Permite que se envíe contido ao sitio e que se mostre nas páxinas.\";s:28:\"%title could not be created.\";b:1;s:31:\"Associate locations with nodes.\";b:1;s:24:\"%title has been updated.\";b:1;s:28:\"%title could not be updated.\";b:1;s:28:\"Defines numeric field types.\";s:34:\"Define tipos de campos numéricos.\";s:48:\"Allows users to log into your site using OpenID.\";s:55:\"Permite ó usuarios acceder ó sitio empregando OpenID.\";s:27:\"@plugin %title was enabled.\";b:1;s:28:\"@plugin %title was disabled.\";b:1;s:32:\"There are no @titles to display.\";b:1;s:59:\"Displays the Drupal administration interface in an overlay.\";s:68:\"Presenta a interface administrativa de Drupal nunha capa superposta.\";s:35:\"Manage customized lists of content.\";b:1;s:54:\"Provides a UI and API to manage pages within the site.\";b:1;s:16:\"Creating aliases\";s:13:\"Creando alias\";s:69:\"<em>member/jane-smith</em> aliased to internal path <em>user/123</em>\";s:72:\"<em>membro/xoel-castro</em> é o alias da ruta interna <em>user/123</em>\";s:65:\"<em>about-us/team</em> aliased to internal path <em>node/456</em>\";s:70:\"<em>sobre-nos/equipo</em> é o alias da ruta interna <em>nodo/456</em>\";s:16:\"Managing aliases\";s:17:\"Xestionando alias\";s:11:\"URL aliases\";s:12:\"Alias de URL\";s:46:\"Change your site\'s URL paths by aliasing them.\";s:51:\"Cambiar as rutas URL do seu sitio polos seus alias.\";s:28:\"Allows users to rename URLs.\";s:35:\"Permite aos usuarios renomear URLs.\";s:37:\"Define translations for generic paths\";b:1;s:8:\"Settings\";s:7:\"Axustes\";s:34:\"Maximum alias and component length\";b:1;s:8:\"Patterns\";s:8:\"Patróns\";s:50:\"Allows embedded PHP code/snippets to be evaluated.\";s:61:\"Permite que o código/anacos de PHP embebido sexan avaliados.\";s:27:\"Searching content and users\";s:28:\"Buscando contidos e usuarios\";s:26:\"Indexing content with cron\";s:26:\"Indexando contido con cron\";s:18:\"Content reindexing\";s:21:\"Reindexando o contido\";s:27:\"Configuring search settings\";b:1;s:12:\"Search block\";s:15:\"Bloque de busca\";s:23:\"Extending Search module\";s:28:\"Ampliando o módulo de busca\";s:15:\"Search settings\";s:15:\"Axuste da busca\";s:67:\"Configure relevance settings for search and other indexing options.\";s:82:\"Configurar os axustes de relevancia para a busca e outras opcións de indexación.\";s:36:\"Enables site-wide keyword searching.\";s:50:\"Activa a busca de palabras clave  en todo o sitio.\";s:23:\"Administering shortcuts\";s:21:\"Administrando atallos\";s:22:\"Choosing shortcut sets\";s:31:\"Escollendo conxuntos de atallos\";s:29:\"Adding and removing shortcuts\";s:30:\"Engadindo e eliminando atallos\";s:20:\"Displaying shortcuts\";s:17:\"Mostrando atallos\";s:9:\"Shortcuts\";s:7:\"Atallos\";s:29:\"Add and modify shortcut sets.\";s:41:\"Engadir e modificar conxuntos de atallos.\";s:60:\"Allows users to manage customizable lists of shortcut links.\";s:79:\"Permitir os usuarios xestionar as listas personalizables de enlaces de atallos.\";s:37:\"Logs access statistics for your site.\";s:46:\"Rexistra estatísticas de acceso ao sitio web.\";s:57:\"Provides support for translation of user defined strings.\";b:1;s:53:\"Create custom styles for applications such as Panels.\";b:1;s:74:\"Synchronizes taxonomy and fields accross translations of the same content.\";b:1;s:41:\"Logs and records system events to syslog.\";s:49:\"Rexistra e garda os eventos de sistema no syslog.\";s:16:\"Managing modules\";s:18:\"Xestionar módulos\";s:15:\"Managing themes\";s:15:\"Xestionar temas\";s:16:\"Managing caching\";s:18:\"Xestionar a caché\";s:29:\"Performing system maintenance\";s:34:\"Realizando o mantemento do sistema\";s:31:\"Configuring basic site settings\";s:39:\"Configurar os axustes básicos do sitio\";s:19:\"Configuring actions\";s:19:\"Configurar accións\";s:54:\"Handles general site configuration for administrators.\";s:62:\"Xestiona a configuración xeral do sitio para administradores.\";s:21:\"Creating vocabularies\";s:20:\"Creando vocabularios\";s:26:\"<em>vocabulary</em>: Music\";s:29:\"<em>vocabulario</em>: Música\";s:19:\"<em>term</em>: Jazz\";s:20:\"<em>termo</em>: Jazz\";s:24:\"<em>sub-term</em>: Swing\";s:24:\"<em>subtermo</em>: Swing\";s:25:\"<em>sub-term</em>: Fusion\";s:26:\"<em>subtermo</em>: Fusión\";s:19:\"<em>term</em>: Rock\";s:20:\"<em>termo</em>: Rock\";s:31:\"<em>sub-term</em>: Country rock\";s:31:\"<em>subtermo</em>: Country rock\";s:28:\"<em>sub-term</em>: Hard rock\";s:28:\"<em>subtermo</em>: Hard rock\";s:39:\"Assigning vocabularies to content types\";s:41:\"asignando vocabularios a tipos de contido\";s:19:\"Classifying content\";s:20:\"Clasificando contido\";s:38:\"Viewing listings and RSS feeds by term\";s:53:\"Ver os listados e as canles de noticias RSS por termo\";s:25:\"Extending Taxonomy module\";s:33:\"Ampliando o módulo de taxonomía\";s:38:\"Enables the categorization of content.\";s:36:\"Activa a clasificación de contidos.\";s:30:\"Enables multilingual taxonomy.\";b:1;s:48:\"Controls access to context based upon term depth\";b:1;s:53:\"Provides a framework for unit and functional testing.\";s:71:\"Proporciona un entorno para execución de probas unificado e funcional.\";s:32:\"Defines simple text field types.\";s:39:\"Define tipos de campo de texto simples.\";s:9:\"Tutorials\";b:1;s:6:\"Author\";s:7:\"Autor/a\";s:5:\"!path\";b:1;s:74:\"ThemeKey rule that switches the theme if the user\'s role is \"premium user\"\";b:1;s:63:\"ThemeKey rule that switches the theme on content creation forms\";b:1;s:55:\"ThemeKey rule chain selecting special theme for iPhones\";b:1;s:33:\"Sophisticated ThemeKey rule chain\";b:1;s:9:\"Have Fun!\";b:1;s:37:\"Versions used to create this tutorial\";b:1;s:8:\"ThemeKey\";b:1;s:19:\"ThemeKey Properties\";b:1;s:8:\"Examples\";s:8:\"Exemplos\";s:42:\"Set a special theme for site administrator\";b:1;s:31:\"Create a Theme Switching Rules:\";b:1;s:55:\"Select a theme for Firefox 3.0.x, but not Firefox 3.5.x\";b:1;s:40:\"Cascade following Theme Switching Rules:\";b:1;s:23:\"Select a theme for IE 6\";b:1;s:33:\"Select a theme for Christmas 2009\";b:1;s:32:\"Select a theme for New Year 2010\";b:1;s:30:\"Create a Theme Switching Rule:\";b:1;s:9:\"Supported\";s:9:\"Soportado\";s:20:\"Properties explained\";b:1;s:10:\"Page Cache\";b:1;s:10:\"Deprecated\";b:1;s:19:\"Operators explained\";b:1;s:34:\"<strong>!</strong><br />not equals\";b:1;s:32:\"<strong>*</strong><br />contains\";b:1;s:37:\"<strong>!*</strong><br />not contains\";b:1;s:10:\"PHP Manual\";b:1;s:48:\"Map themes to Drupal paths or object properties.\";b:1;s:66:\"Define rules to dynamically add CSS files to a page. Experimental!\";b:1;s:66:\"Implements parts of the ThemeKey API as an example for Developers.\";b:1;s:34:\"Export single rules with Features.\";b:1;s:71:\"Provides an additional rule chain to define rules to redirect the user.\";b:1;s:48:\"Just a fake module for testing ThemeKey plugins.\";b:1;s:53:\"Integrates ThemeKey with Drupal administration forms.\";b:1;s:73:\"Provides a user interface for the Token API and some missing core tokens.\";b:1;s:31:\"Displaying administrative links\";s:34:\"Amosando vínculos administrativos\";s:45:\"Enables tracking of recent content for users.\";s:57:\"Activar o seguimento do contido recente para os usuarios.\";s:69:\"Provides an overview of the translation status of the site\'s content.\";b:1;s:71:\"Redirect to translated page when available. SEO for multilingual sites.\";b:1;s:47:\"Simple translation sets API for generic objects\";b:1;s:11:\"File system\";s:20:\"Sistema de ficheiros\";s:68:\"Tell Drupal where to store uploaded files and how they are accessed.\";s:79:\"Dígalle a Drupal onde almacenar os ficheiros cargados e como se accede a eles.\";s:61:\"Converts non-latin text to US-ASCII and sanitizes file names.\";b:1;s:48:\"@font-your-face provider with Typekit.com fonts.\";b:1;s:30:\"Checking for available updates\";s:37:\"Buscando actualizacións dispoñibles\";s:45:\"Performing updates through the user interface\";s:46:\"Actualizando a través da interface de usuario\";s:60:\"Installing new modules and themes through the user interface\";s:67:\"Instalando novos módulos e temas a través da interface de usuario\";s:27:\"Creating and managing users\";s:32:\"Creación e xestión de usuarios\";s:26:\"User roles and permissions\";s:29:\"Papeis de usuarios e permisos\";s:16:\"Account settings\";s:23:\"Configuración de conta\";s:47:\"Manages the user registration and login system.\";s:46:\"Xestiona o rexistro de usuarios/as e o acceso.\";s:31:\"Associate locations with users.\";b:1;s:43:\"Translate emails sent from the User module.\";b:1;s:43:\"Variable Information and basic variable API\";b:1;s:26:\"Variable Administration UI\";b:1;s:49:\"API to use variable realms from different modules\";b:1;s:4:\"Name\";s:4:\"Nome\";s:60:\"Database storage for variable realms. This is an API module.\";b:1;s:71:\"Multilingual variables that switch language depending on page language.\";b:1;s:21:\"(Machine name: @type)\";s:24:\"(Nome de sistema: @type)\";s:13:\"manage fields\";s:18:\"administrar campos\";s:51:\"Provides Brightcove handler for Video Embed Fields.\";b:1;s:14:\"manage display\";s:23:\"xestionar presentación\";s:65:\"No content types available. <a href=\"@link\">Add content type</a>.\";s:82:\"Ningún tipo de contido dispoñíbel. <a href=\"@link\">Agregar tipo de contido</a>.\";s:63:\"Expose a field type for embedding videos from youtube or vimeo.\";b:1;s:55:\"Create customized lists and queries from your database.\";s:57:\"Crear listas e consultas personalizadas da base de datos.\";s:16:\"Add content type\";s:26:\"Engadir un tipo de contido\";s:46:\"Provides an Infinite Scrolling pager for Views\";b:1;s:9:\"Void Menu\";b:1;s:20:\"Configure Void Menu.\";b:1;s:71:\"Provides a series of new menu items that will accept any custom values.\";b:1;s:47:\"Provides a shared voting API for other modules.\";b:1;s:16:\"Wysiwyg profiles\";s:15:\"Perfís Wysiwyg\";s:30:\"Configure client-side editors.\";s:42:\"Configurar os editores do lado do cliente.\";s:48:\"Allows to edit content with client-side editors.\";s:57:\"Permite editar o contido do lado do cliente cos editores.\";s:38:\"Adds list of enabled fonts to WYSIWYG.\";b:1;s:15:\"@font-your-face\";b:1;s:7:\"Version\";s:8:\"Versión\";s:4:\"Core\";s:7:\"Núcleo\";s:35:\"Multilingual - Internationalization\";b:1;s:16:\"Chaos tool suite\";b:1;s:6:\"Fields\";s:6:\"Campos\";s:5:\"Other\";s:5:\"Outro\";s:6:\"Voting\";s:7:\"Votando\";s:14:\"user-interface\";b:1;s:8:\"Location\";s:13:\"Localización\";s:12:\"Multilingual\";s:12:\"Multilingüe\";s:15:\"Example modules\";b:1;s:8:\"Variable\";s:9:\"Variábel\";s:4:\"Menu\";s:5:\"Menú\";s:8:\"Required\";s:11:\"Obrigatorio\";s:11:\"Unavailable\";s:16:\"Non dispoñíbel\";s:11:\"Filter list\";b:1;s:6:\"Update\";s:10:\"Actualizar\";s:9:\"Uninstall\";s:11:\"Desinstalar\";s:18:\"Install new module\";s:21:\"Instalar novo módulo\";s:5:\"Links\";s:9:\"Ligazóns\";s:24:\"Version: !module-version\";b:1;s:25:\"Required by: !module-list\";s:27:\"Requerido por: !module-list\";s:22:\"Requires: !module-list\";s:21:\"Precisa: !module-list\";s:15:\"Add new content\";s:20:\"Engadir novo contido\";s:24:\"Submission form settings\";s:30:\"Axustes do formulario de envio\";s:17:\"Title field label\";s:28:\"Etiqueta do campo de título\";s:25:\"Preview before submitting\";s:29:\"Previsualizar antes de enviar\";s:8:\"Optional\";s:8:\"Opcional\";s:36:\"Explanation or submission guidelines\";s:43:\"Explicación ou directrices de publicación\";s:18:\"Publishing options\";s:24:\"Opcións de publicación\";s:15:\"Default options\";s:24:\"Opcións predeterminadas\";s:9:\"Published\";s:9:\"Publicado\";s:22:\"Promoted to front page\";s:33:\"Promocionado á páxina principal\";s:22:\"Sticky at top of lists\";s:30:\"Pegañoso no comezo das listas\";s:19:\"Create new revision\";s:20:\"Crear nova revisión\";s:16:\"Display settings\";s:25:\"Axustes da visualización\";s:36:\"Display author and date information.\";s:36:\"Amosar información do autor e data.\";s:51:\"Author username and publish date will be displayed.\";s:53:\"Amosaránse o nome do autor e a data de publicación.\";s:17:\"Save content type\";s:24:\"Gardar o tipo de contido\";s:19:\"Delete content type\";s:24:\"Eliminar tipo de contido\";s:16:\"Comment settings\";s:30:\"Configuración dos comentarios\";s:39:\"Default comment setting for new content\";s:64:\"Configuración predeterminada de comentarios para o novo contido\";s:4:\"Open\";s:6:\"Aberta\";s:6:\"Closed\";s:7:\"Pechada\";s:6:\"Hidden\";s:6:\"Oculto\";s:9:\"Threading\";s:20:\"Fíos de comentarios\";s:40:\"Show comment replies in a threaded list.\";s:56:\"Amosar as respostas os comentarios nunha lista de fíos.\";s:17:\"Comments per page\";s:23:\"Comentarios por páxina\";s:20:\"Anonymous commenting\";s:23:\"Comentando anonimamente\";s:57:\"Anonymous posters may not enter their contact information\";s:72:\"Os remitentes anónimos poden non deixar a súa información de contacto\";s:53:\"Anonymous posters may leave their contact information\";s:68:\"Os remitentes anónimos poden deixar a súa información de contacto\";s:54:\"Anonymous posters must leave their contact information\";s:68:\"Os remitentes anónimos deben deixar a súa información de contacto\";s:19:\"Allow comment title\";s:30:\"Permitir título de comentario\";s:44:\"Show reply form on the same page as comments\";s:62:\"Amosar formulario de resposta na mesma páxina cos comentarios\";s:15:\"Preview comment\";s:26:\"Vista previa do comentario\";s:20:\"Multilingual support\";s:31:\"Soporte para múltiples idiomas\";s:9:\"Main menu\";s:15:\"Menú principal\";s:10:\"Management\";b:1;s:10:\"Navigation\";s:11:\"Navegación\";s:9:\"User menu\";b:1;s:13:\"Menu settings\";s:23:\"Configuración do menú\";s:15:\"Available menus\";s:19:\"Menús dispoñibles\";s:60:\"The menus available to place links in for this content type.\";s:69:\"Os menús dispoñibles para situar enlaces para este tipo de contido.\";s:31:\"Select and configure your theme\";s:33:\"Seleccione e configure o seu tema\";s:46:\"Configure default and theme specific settings.\";s:64:\"Configurar as opcións predeterminadas e específicas dos temas.\";s:6:\"Bartik\";s:6:\"Bartik\";s:15:\"Global settings\";s:21:\"Configuración global\";s:5:\"Seven\";s:5:\"Seven\";s:16:\"Bootstrap Agency\";b:1;s:25:\"Bootstrap Sub-Theme (CDN)\";b:1;s:17:\"Install new theme\";s:18:\"Instalar novo tema\";s:15:\"Add text format\";s:27:\"Engadir un formato de texto\";s:18:\"Logging and errors\";s:16:\"Rexistro e erros\";s:16:\"Maintenance mode\";s:18:\"Modo de mantemento\";s:62:\"Take the site offline for maintenance or bring it back online.\";s:64:\"Desconectar o sitio para o seu mantemento ou volvelo a conectar.\";s:11:\"Performance\";s:10:\"Rendemento\";s:15:\"Transliteration\";s:16:\"Transliteración\";s:40:\"Convert existing file names to US-ASCII.\";b:1;s:9:\"Add style\";s:14:\"Añadir estilo\";s:22:\"Add a new image style.\";s:32:\"Engadir un novo estilo de imaxe.\";s:42:\"List the current image styles on the site.\";s:48:\"Listar os estilos de imaxe actuais no sitio web.\";s:13:\"Image toolkit\";s:20:\"Ferramentas de Imaxe\";s:74:\"Choose which image toolkit to use if you have installed optional toolkits.\";s:101:\"Escoller qué xogo de ferramentas de imaxes usar se ten instalado outros xogos ferramentas opcionais.\";s:14:\"Manage display\";s:26:\"Xestionar a visualización\";s:7:\"Comment\";s:10:\"Comentario\";s:12:\"Full comment\";s:19:\"Comentario completo\";s:18:\"@node_type comment\";s:24:\"comentario de @node_type\";s:4:\"Node\";s:4:\"Nodo\";s:12:\"Full content\";s:16:\"Contido completo\";s:6:\"Teaser\";s:6:\"Resumo\";s:3:\"RSS\";s:3:\"RSS\";s:12:\"Search index\";s:17:\"Índice de búsca\";s:32:\"Search result highlighting input\";s:33:\"Resaltando o resultado da procura\";s:4:\"File\";s:8:\"Ficheiro\";s:13:\"Taxonomy term\";s:19:\"Termo de taxonomía\";s:18:\"Taxonomy term page\";s:32:\"Páxina de térmos de taxonomía\";s:19:\"Taxonomy vocabulary\";s:25:\"Vocabulario de taxonomía\";s:15:\"Wysiwyg profile\";s:15:\"Perfíl Wysiwyg\";s:6:\"Tokens\";s:9:\"Comodines\";s:13:\"Manage fields\";s:18:\"Administrar campos\";s:19:\"IP address blocking\";s:24:\"Bloqueo de dirección IP\";s:28:\"Manage blocked IP addresses.\";s:36:\"Xestionar direccións IP bloqueadas.\";s:7:\"Formats\";s:8:\"Formatos\";s:51:\"Configure display format strings for date and time.\";s:46:\"Configurar formato de cadeas para data e hora.\";s:10:\"Add format\";s:15:\"Engadir formato\";s:43:\"Allow users to add additional date formats.\";s:56:\"Permite aos usuario engadir formatos de data adicionais.\";s:5:\"Types\";s:5:\"Tipos\";s:13:\"Add date type\";s:20:\"Engadir tipo de data\";s:18:\"Add new date type.\";s:26:\"Engadir novo tipo de data.\";s:8:\"Localize\";s:12:\"Rexionalizar\";s:38:\"Configure date formats for each locale\";s:54:\"Configurar os formatos de data para cada localización\";s:8:\"Overview\";s:11:\"Vista xeral\";s:9:\"Translate\";s:8:\"Traducir\";s:10:\"Clean URLs\";s:10:\"URL limpos\";s:43:\"Enable or disable clean URLs for your site.\";s:51:\"Activar ou desactivar URLs limpas para o seu sitio.\";s:11:\"Clear index\";s:14:\"Limpar índice\";s:9:\"Add alias\";s:16:\"Engadir un alias\";s:13:\"Bulk generate\";b:1;s:14:\"Delete aliases\";b:1;s:7:\"Actions\";s:8:\"Accións\";s:41:\"Manage the actions defined for your site.\";s:49:\"Xestionar as accións definidas para o seu sitio.\";s:28:\"Configure an advanced action\";s:32:\"Configurar unha acción avanzada\";s:14:\"Manage actions\";s:21:\"Xestionar as accións\";s:4:\"Cron\";s:4:\"Cron\";s:40:\"Manage automatic site maintenance tasks.\";s:57:\"Xestionar as tarefas de mantemento automáticas do sitio.\";s:16:\"Site information\";s:21:\"Información do sitio\";s:16:\"Add shortcut set\";s:27:\"Engadir conxunto de atallos\";s:4:\"Ajax\";b:1;s:7:\"General\";s:5:\"Xeral\";s:26:\"Theme Switching Rule Chain\";b:1;s:14:\"RSS publishing\";s:16:\"Publicación RSS\";s:18:\"Published comments\";s:22:\"Comentarios publicados\";s:28:\"Unapproved comments (@count)\";s:32:\"Comentarios sen aprobar (@count)\";s:36:\"Configure available dashboard blocks\";s:54:\"Configurar os bloques do panel de control dispoñibles\";s:53:\"Configure which blocks can be shown on the dashboard.\";s:63:\"Configurar os bloques que se poden mostrar no panel de control.\";s:5:\"block\";b:1;s:5:\"color\";b:1;s:7:\"comment\";b:1;s:10:\"contextual\";b:1;s:9:\"dashboard\";b:1;s:5:\"dblog\";b:1;s:5:\"field\";s:5:\"campo\";s:17:\"field_sql_storage\";b:1;s:8:\"field_ui\";b:1;s:4:\"file\";s:8:\"ficheiro\";s:6:\"filter\";s:6:\"filtro\";s:4:\"help\";b:1;s:5:\"image\";s:5:\"imaxe\";s:4:\"list\";b:1;s:4:\"menu\";s:5:\"menú\";s:4:\"node\";s:4:\"nodo\";s:7:\"options\";b:1;s:6:\"system\";s:7:\"sistema\";s:8:\"taxonomy\";s:10:\"taxonomía\";s:4:\"text\";b:1;s:4:\"user\";s:9:\"usuario/a\";s:6:\"number\";b:1;s:4:\"path\";b:1;s:3:\"rdf\";b:1;s:6:\"search\";s:5:\"busca\";s:8:\"shortcut\";b:1;s:7:\"toolbar\";b:1;s:6:\"update\";s:14:\"actualización\";s:8:\"themekey\";b:1;s:13:\"jquery_update\";b:1;s:6:\"locale\";s:13:\"localización\";s:8:\"pathauto\";b:1;s:5:\"token\";b:1;s:7:\"wysiwyg\";b:1;s:8:\"Add user\";s:17:\"Engadir usuario/a\";s:50:\"Find and manage people interacting with your site.\";s:65:\"Localizar e xestionar qué persoas interactúan co seu sitio web.\";s:64:\"Determine access to features by selecting permissions for roles.\";s:87:\"Determinar o acceso a características mediante a selección de permisos para os roles.\";s:5:\"Roles\";s:5:\"Roles\";s:30:\"List, edit, or add user roles.\";s:45:\"Listar, editar ou engadir roles de usuario/a.\";s:10:\"Field list\";s:15:\"Lista de campos\";s:39:\"Overview of fields on all entity types.\";s:61:\"Información xeral dos campos en todos os tipos de entidades.\";s:13:\"Used in views\";s:20:\"Utilizado nas vistas\";s:37:\"Overview of fields used in all views.\";s:48:\"Resumo dos campos empregados en todas as vistas.\";s:19:\"Recent log messages\";s:29:\"Mensaxes recentes do rexistro\";s:43:\"View events that have recently been logged.\";s:37:\"Ver eventos rexistrados recentemente.\";s:13:\"Status report\";s:17:\"Informe de estado\";s:74:\"Get a status report about your site\'s operation and any detected problems.\";s:92:\"Obter un informe de estado sobre o funcionamento do seu sitio e calquera problema detectado.\";s:26:\"Top \'access denied\' errors\";s:37:\"Principais erros de \"acceso denegado\"\";s:35:\"View \'access denied\' errors (403s).\";s:37:\"Ver erros de \"acceso denegado\" (403).\";s:27:\"Top \'page not found\' errors\";s:41:\"Principais erros de \"páxina non atopada\"\";s:36:\"View \'page not found\' errors (404s).\";s:41:\"Ver erros de \"páxina non atopada\" (404).\";s:18:\"Top search phrases\";s:21:\"Cadeas máis buscadas\";s:33:\"View most popular search phrases.\";s:39:\"Ver as frases de busca máis habituais.\";s:17:\"Available updates\";s:28:\"Actualizacións dispoñibles\";s:27:\"Install new module or theme\";s:29:\"Instalar módulo ou tema novo\";s:13:\"Views plugins\";s:16:\"Plugins de Views\";s:38:\"Overview of plugins used in all views.\";s:56:\"Visión xeral dos plugins utilizados en todas as vistas.\";s:9:\"Add block\";s:17:\"Engadir un bloque\";s:8:\"Add menu\";s:13:\"Engadir menú\";s:10:\"List menus\";s:15:\"Lista de menús\";s:14:\"Add vocabulary\";s:19:\"Engadir vocabulario\";s:12:\"Add new view\";s:23:\"Engadir unha nova vista\";s:22:\"Add view from template\";s:29:\"Engadir vista dende plantilla\";s:8:\"Advanced\";s:8:\"Avanzado\";s:5:\"Basic\";s:7:\"Básico\";s:12:\"Compose tips\";s:27:\"Consellos para composición\";s:6:\"Search\";s:6:\"Buscar\";s:5:\"Users\";s:8:\"Usuarios\";s:8:\"disabled\";s:11:\"desactivado\";s:20:\"Request new password\";s:29:\"Solicitar un novo contrasinal\";s:19:\"Default parent item\";s:36:\"Elemento de menú pai predeterminado\";s:21:\"Machine-readable name\";s:27:\"Nome lexíbel pola máquina\";s:12:\"Machine name\";s:15:\"Nome de sistema\";s:14:\"Comment fields\";s:14:\"Comment fields\";s:15:\"Comment display\";s:28:\"Presentación de comentarios\";s:23:\"This field is required.\";s:24:\"Este campo é necesario.\";s:13:\"Vertical Tabs\";s:17:\"Solapas verticais\";s:13:\"Not published\";s:13:\"Non publicado\";s:17:\"Parent menu items\";s:22:\"Elementos de menú pai\";s:57:\"You must enable the @required modules to install @module.\";b:1;s:37:\"Some required modules must be enabled\";s:48:\"Deben estar activados algún módulos requiridos\";s:42:\"Would you like to continue with the above?\";s:28:\"Quere continuar co anterior?\";s:8:\"Continue\";s:9:\"Continuar\";s:6:\"Cancel\";s:8:\"Cancelar\";s:5:\"Files\";s:9:\"Ficheiros\";s:5:\"Title\";s:7:\"Título\";s:17:\"Content revisions\";s:21:\"Revisións de contido\";s:14:\"Taxonomy terms\";s:20:\"Termos de taxonomía\";s:3:\"...\";s:3:\"...\";s:30:\"Translate user-defined strings\";b:1;s:23:\"Translate admin strings\";b:1;s:17:\"Administer blocks\";s:19:\"Administrar bloques\";s:40:\"Administer comments and comment settings\";s:50:\"Administrar comentarios e opcións dos comentarios\";s:13:\"View comments\";s:15:\"Ver comentarios\";s:13:\"Post comments\";s:20:\"Publicar comentarios\";s:21:\"Skip comment approval\";s:32:\"Omitir aprobación de comentario\";s:17:\"Edit own comments\";s:26:\"Editar comentarios propios\";s:20:\"Use contextual links\";s:24:\"Usar enlaces contextuais\";s:70:\"Use contextual links to perform actions related to elements on a page.\";s:93:\"Empregar enlaces contextuais para executar accións relacionadas cos elementos dunha páxina.\";s:19:\"Use CTools importer\";b:1;s:33:\"View the administrative dashboard\";s:37:\"Ver o panel de control administrativo\";s:16:\"Vocabulary terms\";b:1;s:30:\"All the terms in a vocabulary.\";b:1;s:10:\"Vocabulary\";s:11:\"Vocabulario\";s:10:\"User links\";b:1;s:34:\"User links of the referenced user.\";b:1;s:12:\"User picture\";s:16:\"Imaxe do usuario\";s:22:\"The picture of a user.\";b:1;s:12:\"User profile\";b:1;s:22:\"The profile of a user.\";b:1;s:14:\"User signature\";b:1;s:24:\"The signature of a user.\";b:1;s:16:\"Term description\";s:20:\"Descrición do termo\";s:17:\"Term description.\";b:1;s:4:\"Term\";s:5:\"Termo\";s:21:\"List of related terms\";b:1;s:71:\"Terms related to an existing term; may be child, siblings or top level.\";b:1;s:9:\"Term name\";s:13:\"Nome do termo\";s:31:\"The name of this taxonomy term.\";b:1;s:20:\"Advanced search form\";b:1;s:36:\"A search form with advanced options.\";b:1;s:8:\"Keywords\";s:14:\"Palabras chave\";s:7:\"Widgets\";b:1;s:14:\"Search results\";s:19:\"Resultados da busca\";s:39:\"The results of a search using keywords.\";b:1;s:46:\"Add the action links (local tasks) as content.\";b:1;s:13:\"Page elements\";b:1;s:10:\"Breadcrumb\";b:1;s:36:\"Add the breadcrumb trail as content.\";b:1;s:10:\"Feed icons\";b:1;s:45:\"Add the site feed_icons statement as content.\";b:1;s:49:\"Add the help text of the current page as content.\";b:1;s:9:\"Site logo\";b:1;s:30:\"Add the logo trail as content.\";b:1;s:15:\"Status messages\";b:1;s:55:\"Add the status messages of the current page as content.\";b:1;s:24:\"Primary navigation links\";b:1;s:47:\"Add the primary_links (local tasks) as content.\";b:1;s:26:\"Secondary navigation links\";b:1;s:49:\"Add the secondary_links (local tasks) as content.\";b:1;s:9:\"Site name\";s:13:\"Nome do sitio\";s:57:\"The name of the site, optionally links to the front page.\";b:1;s:11:\"Site slogan\";s:16:\"Eslogan do sitio\";s:33:\"Add the site\'s slogan as content.\";b:1;s:4:\"Tabs\";b:1;s:38:\"Add the tabs (local tasks) as content.\";b:1;s:10:\"Page title\";s:18:\"Título da páxina\";s:30:\"Add the page title as content.\";b:1;s:28:\"Node form author information\";b:1;s:36:\"Author information on the Node form.\";b:1;s:4:\"Form\";s:10:\"Formulario\";s:24:\"Node form submit buttons\";b:1;s:33:\"Submit buttons for the node form.\";b:1;s:26:\"Node form comment settings\";b:1;s:34:\"Comment settings on the Node form.\";b:1;s:19:\"Node form languages\";b:1;s:28:\"The language selection form.\";b:1;s:30:\"Node form revision log message\";b:1;s:34:\"Revision log message for the node.\";b:1;s:23:\"Node form menu settings\";b:1;s:31:\"Menu settings on the Node form.\";b:1;s:27:\"Node form url path settings\";b:1;s:36:\"Publishing options on the Node form.\";b:1;s:28:\"Node form publishing options\";b:1;s:21:\"Node form title field\";b:1;s:20:\"The node title form.\";b:1;s:14:\"Attached files\";b:1;s:37:\"A list of files attached to the node.\";b:1;s:11:\"Node author\";b:1;s:34:\"The author of the referenced node.\";b:1;s:9:\"Node body\";b:1;s:32:\"The body of the referenced node.\";b:1;s:13:\"Node comments\";b:1;s:36:\"The comments of the referenced node.\";b:1;s:12:\"Comment form\";b:1;s:28:\"A form to add a new comment.\";b:1;s:26:\"Comments and comment form.\";b:1;s:54:\"The comments and comment form for the referenced node.\";b:1;s:12:\"Node content\";b:1;s:35:\"The content of the referenced node.\";b:1;s:17:\"Node created date\";b:1;s:41:\"The date the referenced node was created.\";b:1;s:10:\"Node links\";b:1;s:34:\"Node links of the referenced node.\";b:1;s:10:\"Node terms\";b:1;s:38:\"Taxonomy terms of the referenced node.\";b:1;s:10:\"Node title\";b:1;s:33:\"The title of the referenced node.\";b:1;s:21:\"Node type description\";b:1;s:22:\"Node type description.\";b:1;s:22:\"Node last updated date\";b:1;s:46:\"The date the referenced node was last updated.\";b:1;s:13:\"Existing node\";b:1;s:37:\"Add a node from your site as content.\";b:1;s:6:\"Custom\";s:13:\"Personalizado\";s:12:\"Entity field\";b:1;s:12:\"General form\";b:1;s:62:\"Everything in the form that is not displayed by other content.\";b:1;s:18:\"Entity extra field\";b:1;s:14:\"Custom content\";b:1;s:20:\"Comment created date\";b:1;s:44:\"The date the referenced comment was created.\";b:1;s:13:\"Comment links\";b:1;s:40:\"Comment links of the referenced comment.\";b:1;s:18:\"Comment Reply Form\";b:1;s:34:\"A form to add a new comment reply.\";b:1;s:5:\"Block\";s:6:\"Bloque\";s:47:\"Display the comment with standard comment view.\";s:55:\"Mostrar o comentario coa vista estándar de comentario.\";s:27:\"Display the comment as RSS.\";s:33:\"Visualizar o comentario como RSS.\";s:44:\"Display the content with standard node view.\";b:1;s:19:\"Content ID from URL\";s:25:\"ID do contido desde a URL\";s:25:\"Taxonomy term ID from URL\";b:1;s:41:\"Display the user with standard user view.\";b:1;s:16:\"User ID from URL\";b:1;s:27:\"User ID from logged in user\";b:1;s:6:\"Master\";s:6:\"Master\";s:31:\"Default settings for this view.\";s:40:\"Axustes predeterminados para esta vista.\";s:4:\"Page\";s:7:\"Páxina\";s:54:\"Display the view as a page, with a URL and menu links.\";s:59:\"Mostrar a vista como páxina, cunha URL e enlaces de menú.\";s:28:\"Display the view as a block.\";s:29:\"Amosa a vista como un bloque.\";s:10:\"Attachment\";s:5:\"Anexo\";s:4:\"Feed\";s:5:\"Orixe\";s:48:\"Display the view as a feed, such as an RSS feed.\";s:51:\"Amosar a vista como unha fonte, com unha fonte RSS.\";s:5:\"Embed\";s:9:\"Incrustar\";s:60:\"Provide a display which can be embedded using the views api.\";b:1;s:22:\"Empty display extender\";b:1;s:16:\"Unformatted list\";s:17:\"Lista sen formato\";s:32:\"Displays rows one after another.\";s:38:\"Amosar as filas unha detras das otras.\";s:9:\"HTML list\";s:10:\"Lista HTML\";s:30:\"Displays rows as an HTML list.\";s:37:\"Amosar as filas como unha lista HTML.\";s:4:\"Grid\";s:6:\"Grella\";s:24:\"Displays rows in a grid.\";s:29:\"Amosar as filas nunha grella.\";s:5:\"Table\";s:6:\"Táboa\";s:25:\"Displays rows in a table.\";s:29:\"Amosar as filas nunha táboa.\";s:39:\"Displays the default summary as a list.\";s:50:\"Presenta o sumario predeterminado como unha lista.\";s:11:\"Unformatted\";s:11:\"Sen formato\";s:8:\"RSS Feed\";s:9:\"Orixe RSS\";s:34:\"Generates an RSS feed from a view.\";s:38:\"Xera unha canle  RSS dende unha vista.\";s:46:\"Displays the fields with an optional template.\";s:44:\"Presenta os campos cunha plantilla opcional.\";s:28:\"Display fields as RSS items.\";s:34:\"Mostrar os campos como ítems RSS.\";s:11:\"Fixed value\";b:1;s:8:\"PHP Code\";s:11:\"Código PHP\";s:18:\"Raw value from URL\";b:1;s:7:\"Numeric\";s:9:\"Numérico\";s:4:\"None\";s:7:\"Ningún\";s:31:\"Will be available to all users.\";s:44:\"Estará dispoñíbel para todos os usuarios.\";s:4:\"Role\";s:3:\"Rol\";s:64:\"Access will be granted to users with any of the specified roles.\";s:69:\"O acceso darase aos usuarios con algunha das funcións especificadas.\";s:10:\"Permission\";s:7:\"Permiso\";s:69:\"Access will be granted to users with the specified permission string.\";s:66:\"Concederase acceso aos usuarios coa cadea de permiso especificada.\";s:9:\"SQL Query\";s:12:\"Consulta SQL\";s:62:\"Query will be generated and run using the Drupal database API.\";s:74:\"A consulta crearase e executará usando a API de bases de datos de Drupal.\";s:25:\"No caching of Views data.\";b:1;s:10:\"Time-based\";b:1;s:34:\"Simple time-based caching of data.\";b:1;s:18:\"Basic exposed form\";b:1;s:14:\"Input required\";b:1;s:73:\"An exposed form that only renders a view if the form contains user input.\";b:1;s:17:\"Display all items\";s:25:\"Amosar todos os elementos\";s:43:\"Display all items that this view might find\";b:1;s:35:\"Display a specified number of items\";s:42:\"Amosar un número específico de elementos\";s:57:\"Display a limited number items that this view might find.\";s:72:\"Mostrar un número limitado de elementos que esta vista podería atopar.\";s:24:\"Paged output, full pager\";s:35:\"Saída paxinada, paxinador completo\";s:4:\"Full\";s:8:\"Completo\";s:31:\"Paged output, full Drupal style\";s:39:\"Saída paginada, estilo Drupal completo\";s:24:\"Paged output, mini pager\";s:31:\"Saída paxinada, paxinador mini\";s:4:\"Mini\";s:4:\"Mini\";s:26:\"Use the mini pager output.\";b:1;s:42:\"Do not pass admin strings for translation.\";b:1;s:9:\"Jump menu\";b:1;s:67:\"Customizing the dashboard requires the !permission-name permission.\";s:74:\"Para personalizar o panel de control requirese o permiso !permission-name.\";s:35:\"Administer text formats and filters\";s:39:\"Administrar formatos de texto e filtros\";s:32:\"Use the !text_format text format\";s:35:\"Use o formato de texto !text_format\";s:23:\"Administer image styles\";s:28:\"Administrar estilos de imaxe\";s:20:\"Administer languages\";b:1;s:25:\"Translate interface texts\";s:28:\"Traducir textos da interface\";s:31:\"Administer menus and menu items\";s:39:\"Administrar menús e elementos de menú\";s:24:\"Administer Module Filter\";b:1;s:37:\"Configure how Module Filter performs.\";b:1;s:29:\"Bypass content access control\";s:36:\"Sortear control de acceso de contido\";s:72:\"View, edit and delete all content regardless of permission restrictions.\";s:83:\"Ver, editar e borrar todo o contido, independentemente das restricións de permiso.\";s:24:\"Administer content types\";s:28:\"Administrar tipos de contido\";s:18:\"Administer content\";s:21:\"Administrar o contido\";s:32:\"Access the content overview page\";s:46:\"Acceder a páxina de visión xeral de contidos\";s:50:\"Get an overview of <a href=\"@url\">all content</a>.\";b:1;s:22:\"View published content\";s:21:\"Ver contido publicado\";s:28:\"View own unpublished content\";s:33:\"Ver o contido propio sen publicar\";s:22:\"View content revisions\";s:25:\"Ver revisións do contido\";s:24:\"Revert content revisions\";s:33:\"Restablecer revisións do contido\";s:24:\"Delete content revisions\";s:28:\"Borrar revisións de contido\";s:30:\"%type_name: Create new content\";s:33:\"%type_name: Crear un novo contido\";s:28:\"%type_name: Edit own content\";s:33:\"%type_name: Editar contido propio\";s:28:\"%type_name: Edit any content\";s:35:\"%type_name: Editar calquera contido\";s:30:\"%type_name: Delete own content\";s:33:\"%type_name: Borrar contido propio\";s:30:\"%type_name: Delete any content\";s:37:\"%type_name: Eliminar calquera contido\";s:22:\"Administer URL aliases\";s:24:\"Administrar alias da URL\";s:27:\"Create and edit URL aliases\";s:27:\"Crear e editar alias da URL\";s:17:\"Administer search\";s:17:\"Administrar busca\";s:10:\"Use search\";s:10:\"Usar busca\";s:19:\"Use advanced search\";s:19:\"Usar busca avanzada\";s:20:\"Administer shortcuts\";s:19:\"Administrar atallos\";s:25:\"Edit current shortcut set\";s:35:\"Editar o actual conxunto de atallos\";s:23:\"Select any shortcut set\";s:40:\"Seleccionar cualquer conxunto de atallos\";s:18:\"Administer modules\";s:20:\"Administrar módulos\";s:29:\"Administer site configuration\";s:35:\"Administrar configuración do sitio\";s:17:\"Administer themes\";b:1;s:27:\"Administer software updates\";s:42:\"Administrar as actualizacións de software\";s:18:\"Administer actions\";s:20:\"Administrar accións\";s:37:\"Use the administration pages and help\";s:43:\"Usar as páxinas de administración e axuda\";s:32:\"Use the site in maintenance mode\";s:33:\"Use o sitio en modo de mantemento\";s:29:\"View the administration theme\";s:29:\"Ver o tema de administración\";s:17:\"View site reports\";s:21:\"Ver informes do sitio\";s:18:\"Block IP addresses\";s:23:\"Bloquear direccións IP\";s:33:\"Administer vocabularies and terms\";s:33:\"Administrar vocabularios e termos\";s:25:\"Edit terms in %vocabulary\";s:28:\"Editar termos de %vocabulary\";s:29:\"Delete terms from %vocabulary\";s:30:\"Eliminar termos de %vocabulary\";s:28:\"administer theme assignments\";b:1;s:57:\"TODO Add a description for \'administer theme assignments\'\";b:1;s:28:\"administer themekey settings\";b:1;s:57:\"TODO Add a description for \'administer themekey settings\'\";b:1;s:30:\"Use the administration toolbar\";s:46:\"Usar a barra de ferramentas de administración\";s:22:\"Administer permissions\";s:20:\"Administrar permisos\";s:16:\"Administer users\";s:20:\"Administrar usuarios\";s:18:\"View user profiles\";s:21:\"Ver pefís de usuario\";s:19:\"Change own username\";s:32:\"Cambiar o nome de usuario propio\";s:23:\"Cancel own user account\";s:34:\"Cancelar a propia conta de usuario\";s:9:\"Anonymous\";s:8:\"Anónimo\";s:40:\"Select method for cancelling own account\";s:54:\"Seleccione método de cancelación para a propia conta\";s:19:\"Administer pathauto\";s:37:\"Administrar alias de URL automáticos\";s:22:\"Notify of Path Changes\";b:1;s:45:\"Determines whether or not users are notified.\";b:1;s:16:\"Administer views\";b:1;s:38:\"Access the views administration pages.\";s:50:\"Acceder as páxinas de administración das vistas.\";s:27:\"Bypass views access control\";s:37:\"Saltar o control de acceso das vistas\";s:43:\"Bypass access control when accessing views.\";s:51:\"Saltar o control de acceso cando accedes as vistas.\";s:19:\"Default SQL storage\";s:32:\"Almacenamento SQL predeterminado\";s:64:\"Stores fields in the local SQL database, using per-field tables.\";s:61:\"Almacena campos na base SQL local, usando táboas por campos.\";s:55:\"This field stores the ID of a file as an integer value.\";s:70:\"Este campo almacena o ID dun arquivo coma un valor de número enteiro.\";s:5:\"Image\";s:5:\"Imaxe\";s:62:\"This field stores the ID of an image file as an integer value.\";s:79:\"Este campo almacena o ID dun arquivo da imaxe como un valor de número enteiro.\";s:4:\"Link\";s:8:\"Ligazón\";s:71:\"Store a title, href, and attributes in the database to assemble a link.\";b:1;s:14:\"List (integer)\";b:1;s:12:\"List (float)\";s:23:\"Lista (número decimal)\";s:11:\"List (text)\";s:16:\"Lista (de texto)\";s:7:\"Boolean\";s:8:\"Booleano\";s:50:\"This field stores simple on/off or yes/no options.\";s:71:\"Este campo garda valores sinxelos coma activado/desactivado ou sí/non.\";s:7:\"Integer\";s:7:\"Enteiro\";s:57:\"This field stores a number in the database as an integer.\";s:72:\"Este campo almacena un número na base de datos coma un número enteiro.\";s:7:\"Decimal\";s:7:\"Decimal\";s:69:\"This field stores a number in the database in a fixed decimal format.\";s:73:\"Este campo almacena un número na base de datos nun formato decimal fixo.\";s:5:\"Float\";s:13:\"Coma flotante\";s:70:\"This field stores a number in the database in a floating point format.\";s:76:\"Este campo almacena na base de datos un número en formato de coma flotante.\";s:14:\"Term reference\";s:19:\"Referencia de termo\";s:49:\"This field stores a reference to a taxonomy term.\";s:58:\"Este campo garda unha referencia a un termo de taxonomía.\";s:4:\"Text\";s:5:\"Texto\";s:47:\"This field stores varchar text in the database.\";s:51:\"Este campo almacena texto varchar na base de datos.\";s:9:\"Long text\";s:11:\"Texto longo\";s:44:\"This field stores long text in the database.\";s:49:\"Este campo almacena texto longo na base de datos.\";s:21:\"Long text and summary\";s:20:\"Texto longo e resumo\";s:8:\"Galician\";s:6:\"Galego\";s:7:\"Spanish\";s:8:\"Español\";s:7:\"English\";s:7:\"Inglés\";s:21:\"Updating translations\";b:1;s:33:\"Error importing translation files\";b:1;s:10:\"Processing\";s:10:\"Procesando\";s:13:\"Initializing.\";s:14:\"Inicializando.\";s:29:\"Completed @current of @total.\";s:33:\"Completaronse @current de @total.\";s:22:\"An error has occurred.\";s:19:\"Produciuse un erro.\";s:36:\"Node: Title - The title of the node.\";b:1;s:10:\"Text field\";s:14:\"Campo de texto\";s:11:\"Select list\";s:19:\"Lista de selección\";s:25:\"Check boxes/radio buttons\";s:45:\"Caixas de comprobación/Botóns de selección\";s:22:\"Single on/off checkbox\";s:47:\"Caixas de selección sixelas activo/desactivado\";s:34:\"Autocomplete term widget (tagging)\";s:43:\"Control de autocompretar termo (etiquetado)\";s:25:\"Text area (multiple rows)\";s:29:\"Área de texto (varias filas)\";s:24:\"Text area with a summary\";s:25:\"Área de texto cun resumo\";s:12:\"Generic file\";s:17:\"Arquivo genérico\";s:14:\"Table of files\";s:18:\"Táboa de arquivos\";s:11:\"URL to file\";s:15:\"URL do ficheiro\";s:24:\"Title, as link (default)\";b:1;s:20:\"Title, as plain text\";b:1;s:19:\"Host, as plain text\";b:1;s:12:\"URL, as link\";b:1;s:18:\"URL, as plain text\";b:1;s:13:\"URL, absolute\";b:1;s:15:\"Domain, as link\";b:1;s:32:\"Short, as link with title \"Link\"\";b:1;s:34:\"Label, as link with label as title\";b:1;s:22:\"Separate title and URL\";b:1;s:3:\"Key\";s:5:\"Clave\";s:10:\"Plain text\";s:9:\"Só texto\";s:12:\"RSS category\";s:14:\"Categoría RSS\";s:7:\"Trimmed\";s:9:\"Recortado\";s:18:\"Summary or trimmed\";s:19:\"Resumo ou recortado\";s:53:\"Path: Node alias - The path alias assigned to a node.\";b:1;s:8:\"Browscap\";b:1;s:17:\"Mobile Detect API\";b:1;s:13:\"Mobile Detect\";b:1;s:68:\"System: Date - Current time formatted as Y-m-d (example: 2009-12-24)\";b:1;s:62:\"System: Month - Current month formatted as \'Jan\' through \'Dec\'\";b:1;s:66:\"System: Time - Current time formatted as H:i:s (example: 18:30:10)\";b:1;s:67:\"System: Day of Month - Current day of the month formatted as 1 - 31\";b:1;s:55:\"System: Dummy - Dummy property. Value is always \'dummy\'\";b:1;s:56:\"System: Random - A random value that could be \'0\' or 1\'.\";b:1;s:72:\"Wildcard of \"drupal:path\". See explanation of \"drupal:path\" for details.\";b:1;s:66:\"Drupal: $_GET[\'q\'] - Current value of Drupal\'s query parameter \"q\"\";b:1;s:54:\"Taxonomy: Term - The term id (tid) of a taxonomy term.\";b:1;s:64:\"User: Name - The username of the user. See !link for your users.\";b:1;s:36:\"Views: VID - The vid of a view (vid)\";b:1;s:48:\"Views: Machine Name - The machine name of a view\";b:1;s:55:\"Views: Human Name - The (human readable) name of a view\";b:1;s:21:\"Site default language\";s:27:\"Idioma predefinido do sitio\";s:8:\"Language\";s:6:\"Idioma\";s:9:\"Node type\";s:12:\"Tipo de nodo\";s:11:\"Text length\";b:1;s:11:\"Drupal path\";b:1;s:9:\"File path\";s:16:\"Ruta do ficheiro\";s:11:\"Day of week\";b:1;s:5:\"Theme\";s:4:\"Tema\";s:7:\"Country\";s:5:\"País\";s:9:\"Time zone\";s:12:\"Fuso horario\";s:9:\"Date type\";s:12:\"Tipo de data\";s:11:\"Date format\";s:15:\"Formato de data\";s:13:\"Time interval\";b:1;s:14:\"User mail text\";b:1;s:5:\"Array\";b:1;s:10:\"Properties\";b:1;s:8:\"Multiple\";s:9:\"Múltiple\";s:14:\"E-mail address\";s:20:\"Enderezo de correo-e\";s:9:\"Mail text\";b:1;s:7:\"Subject\";s:6:\"Asunto\";s:4:\"Body\";s:5:\"Corpo\";s:6:\"Number\";s:7:\"Número\";s:7:\"Options\";s:8:\"Opcións\";s:6:\"Select\";s:20:\"Selección múltiple\";s:6:\"String\";s:5:\"Cadea\";s:7:\"Unknown\";s:12:\"Descoñecido\";s:10:\"Mail parts\";b:1;s:14:\"Formatted text\";b:1;s:17:\"Multiple language\";b:1;s:25:\"Source for the Main links\";s:28:\"Fonte dos enlaces principais\";s:13:\"No Main links\";s:22:\"Sen enlaces principais\";s:30:\"Source for the Secondary links\";s:29:\"Fonte dos enlaces secundarios\";s:18:\"No Secondary links\";s:23:\"Sen enlaces secundarios\";s:42:\"Select the source for the Secondary links.\";b:1;s:11:\"Menu parent\";b:1;s:22:\"Select the menu parent\";b:1;s:12:\"Menu options\";b:1;s:26:\"Select the available menus\";b:1;s:23:\"Length of trimmed posts\";s:32:\"Lonxitude dos envíos recortados\";s:43:\"Must users preview posts before submitting?\";s:71:\"Deben os usuarios facer unha vista previa do contido antes de o enviar?\";s:25:\"The name of this website.\";s:23:\"O nome deste sitio web.\";s:18:\"Site email address\";b:1;s:14:\"Anonymous user\";s:16:\"Usuario anónimo\";s:42:\"The name used to indicate anonymous users.\";s:61:\"O nome utilizado para indicar os/as usuarios/as anónimos/as.\";s:18:\"Default front page\";s:32:\"Páxina principal predeterminada\";s:28:\"Number of posts on main page\";s:40:\"Número de entradas na páxina principal\";s:32:\"Default 403 (access denied) page\";s:41:\"Páxina 403 (acceso denegado) predefinida\";s:28:\"Default 404 (not found) page\";s:41:\"Páxina predeterminada 404 (non se atopa)\";s:16:\"Feed description\";s:21:\"Descripción da orixe\";s:48:\"Description of your site, included in each feed.\";s:60:\"A descrición do seu sitio, incluida en cada canle de novas.\";s:28:\"Number of items in each feed\";s:30:\"Número de elementos por orixe\";s:48:\"Default number of items to include in each feed.\";s:61:\"O número predeterminado de elementos a incluír nunha orixe.\";s:12:\"Feed content\";s:16:\"Contido da orixe\";s:11:\"Titles only\";s:12:\"Só títulos\";s:18:\"Titles plus teaser\";s:18:\"Títulos e avances\";s:9:\"Full text\";s:14:\"Texto completo\";s:69:\"Global setting for the default display of content items in each feed.\";s:85:\"Configuración global predeterminada de elementos de contido mostrados en cada fonte.\";s:15:\"Default country\";s:17:\"País predefinido\";s:17:\"First day of week\";s:23:\"Primeiro día da semana\";s:17:\"Default time zone\";s:27:\"Fuso horario predeterminado\";s:34:\"Users may set their own time zone.\";s:48:\"Os usuarios poden establecer o seu fuso horario.\";s:52:\"Remind users at login if their time zone is not set.\";s:86:\"Recordar os usuarios cando se identifiquen se o sue fuso horario non foi especificado.\";s:50:\"Only applied if users may set their own time zone.\";s:72:\"Só se aplica se os usuarios poden establecer o seu propio fuso horario.\";s:23:\"Time zone for new users\";s:33:\"Fuso horario para usuarios novos.\";s:18:\"Default time zone.\";s:28:\"Fuso horario predeterminado.\";s:16:\"Empty time zone.\";s:21:\"Fuso horario valeiro.\";s:50:\"Users may set their own time zone at registration.\";s:68:\"O usuarios poden establecer o seu propio fuso horario o rexistrarse.\";s:30:\"Put site into maintenance mode\";s:36:\"Poñer o sitio en modo de mantemento\";s:24:\"Maintenance mode message\";s:29:\"Mensaxe do modo de mantemento\";s:62:\"Message to show visitors when the site is in maintenance mode.\";s:78:\"Mensaxe para mostrar aos visitantes cando o sitio está en modo de mantemento.\";s:22:\"Global theme settings.\";b:1;s:14:\"Theme settings\";b:1;s:46:\"Logo, icons and other specific theme settings.\";b:1;s:31:\"Cache pages for anonymous users\";s:42:\"Caché de páxinas para usuarios anónimos\";s:12:\"Cache blocks\";s:17:\"Caché de bloques\";s:22:\"Minimum cache lifetime\";s:29:\"Permanencia mínima en caché\";s:26:\"Expiration of cached pages\";s:33:\"Caducidade das páxinas en caché\";s:68:\"The maximum time an external cache can use an old version of a page.\";s:89:\"O tempo máximo que unha caché externa pode empregar unha versión antiga dunha páxina.\";s:22:\"Compress cached pages.\";s:29:\"Comprimir páxinas en caché.\";s:33:\"Aggregate and compress CSS files.\";s:35:\"Xuntar e comprimir os arquivos CSS.\";s:27:\"Aggregate JavaScript files.\";s:30:\"Xuntar os arquivos JavaScript.\";s:20:\"Public registrations\";s:15:\"Altas públicas\";s:61:\"Require e-mail verification when a visitor creates an account\";s:73:\"Requirir verificación por correo-e cando un/ha usuario/a crea unha conta\";s:28:\"User registration guidelines\";s:31:\"Guías para a alta de usuarios.\";s:42:\"Welcome, new user created by administrator\";s:47:\"Benvido, novo usuario creado polo administrador\";s:29:\"Welcome, no approval required\";s:39:\"Benvido, non é necesaria a aprobación\";s:40:\"Welcome, awaiting administrator approval\";s:48:\"Benvido, esperase a aprovación do administrador\";s:23:\"Password recovery email\";s:41:\"Correo-e de recuperación de contrasinal.\";s:67:\"Customize e-mail messages sent to users who request a new password.\";s:103:\"Activar e personalizar as mensaxes de correo-e enviadas aos usuarios que solicitan un novo contrasinal.\";s:24:\"Account activation email\";s:29:\"Email de activación de conta\";s:38:\"Notify user when account is activated.\";s:45:\"Notificar ao usuario cando se active a conta.\";s:21:\"Account blocked email\";s:35:\"O correo-e da conta está bloqueado\";s:36:\"Notify user when account is blocked.\";s:51:\"Notificar ao usuario cando a conta esté bloqueada.\";s:33:\"Account cancellation confirmation\";s:38:\"Confirmación da cancelación da conta\";s:21:\"Account deleted email\";s:44:\"Correo electrónico de eliminación de conta\";s:36:\"Notify user when account is deleted.\";s:44:\"Notificar ao usuario cando se borre a conta.\";s:17:\"Signature support\";s:22:\"Soporte para sinaturas\";s:15:\"Picture support\";s:25:\"Compatibilidade de imaxes\";s:17:\"Picture directory\";s:20:\"Directorio de imaxes\";s:72:\"Subdirectory in the file upload directory where pictures will be stored.\";s:78:\"Subdirectorio das carpetas de arquivos subidos no que se gardarán as imáxes.\";s:15:\"Default picture\";s:20:\"Imaxe predeterminada\";s:26:\"Picture maximum dimensions\";s:29:\"Dimensións máximas da imaxe\";s:43:\"Maximum dimensions for pictures, in pixels.\";s:47:\"Dimensións máxima das de imaxes, en píxeles.\";s:25:\"Picture maximum file size\";s:38:\"Tamaño máximo de ficheiros de imaxes\";s:38:\"Maximum file size for pictures, in kB.\";s:52:\"O tamaño máximo de ficheiro para as imaxes, en kB.\";s:18:\"Picture guidelines\";s:21:\"Directrices de imaxes\";s:21:\"Languages for content\";b:1;s:64:\"Determines which languages will be allowed for content creation.\";b:1;s:31:\"Enable translation for language\";b:1;s:25:\"Translatable text formats\";b:1;s:15:\"Source language\";s:12:\"Lingua fonte\";s:24:\"Debug string translation\";b:1;s:39:\"Configurable blocks titles and content.\";b:1;s:4:\"more\";s:5:\"máis\";s:8:\"Defaults\";s:15:\"Predeterminados\";s:13:\"Image gallery\";s:18:\"Galería de imaxes\";s:5:\"Apply\";s:7:\"Aplicar\";s:5:\"Reset\";s:9:\"Reiniciar\";s:7:\"Sort by\";s:11:\"Ordenar por\";s:3:\"Asc\";b:1;s:4:\"Desc\";s:4:\"Desc\";s:14:\"Items per page\";s:21:\"Elementos por páxina\";s:7:\"- All -\";s:8:\"- Todo -\";s:6:\"Offset\";s:13:\"Desprazamento\";s:12:\"Gallery page\";b:1;s:15:\"Recent comments\";s:20:\"Comentarios recentes\";s:8:\"Reply to\";b:1;s:12:\"Recent posts\";s:17:\"Entradas recentes\";s:4:\"Type\";s:4:\"Tipo\";s:7:\"Replies\";s:9:\"Respostas\";s:1:\".\";s:1:\".\";s:1:\",\";s:1:\",\";s:9:\"Last Post\";s:14:\"Último envío\";s:4:\" new\";b:1;s:19:\"Recent posts for %1\";s:25:\"Entradas recentes para %1\";s:15:\"Monthly archive\";b:1;s:2:\"%1\";s:2:\"%1\";s:15:\"Front page feed\";s:26:\"Fonte da páxina de inicio\";s:11:\"Last update\";s:22:\"Última actualización\";s:19:\"No backlinks found.\";b:1;s:21:\"Pages that link to %1\";b:1;s:15:\"What links here\";s:18:\"O que enlaza aquí\";s:15:\"Publish comment\";s:19:\"Publicar comentario\";s:17:\"Unpublish comment\";s:22:\"Despublicar comentario\";s:39:\"Unpublish comment containing keyword(s)\";s:54:\"Despublicar comentario que conteñan as palabras clave\";s:12:\"Save comment\";s:17:\"Gardar comentario\";s:15:\"Publish content\";s:16:\"Publicar contido\";s:17:\"Unpublish content\";s:19:\"Despublicar contido\";s:19:\"Make content sticky\";s:51:\"Facer que o contido quede fixo na cabeza das listas\";s:21:\"Make content unsticky\";s:55:\"Facer que o contido non quede fixo na cabeza das listas\";s:29:\"Promote content to front page\";s:33:\"Levar contido a páxina principal\";s:30:\"Remove content from front page\";s:35:\"Quitar contido da páxina principal\";s:28:\"Change the author of content\";s:27:\"Cambiar autoría do contido\";s:12:\"Save content\";s:14:\"Gardar contido\";s:39:\"Unpublish content containing keyword(s)\";s:64:\"Retirar da publicación o contenido que conten as palabras chave\";s:29:\"Display a message to the user\";s:30:\"Amosar unha mensaxe ao usuario\";s:11:\"Send e-mail\";s:18:\"Enviar un correo-e\";s:30:\"Ban IP address of current user\";s:36:\"Bloquear o enderezo IP deste usuario\";s:15:\"Redirect to URL\";s:19:\"Reenviar a unha URL\";s:18:\"Block current user\";s:25:\"Bloquear o usuario actual\";s:17:\"Update node alias\";b:1;s:26:\"Update taxonomy term alias\";b:1;s:17:\"Update user alias\";b:1;s:6:\"Header\";s:10:\"Encabezado\";s:11:\"Highlighted\";s:9:\"Resaltado\";s:8:\"Featured\";s:9:\"Destacado\";s:13:\"Sidebar first\";s:22:\"Primeira barra lateral\";s:14:\"Sidebar second\";s:21:\"Segunda barra lateral\";s:14:\"Triptych first\";s:21:\"Tríptico o principio\";s:15:\"Triptych middle\";s:17:\"Tríptico o medio\";s:13:\"Triptych last\";s:17:\"Tríptico o final\";s:19:\"Footer first column\";s:34:\"Primeira columna do pé de páxina\";s:20:\"Footer second column\";s:33:\"Segunda columna do pé de páxina\";s:19:\"Footer third column\";s:34:\"Terceira columna do pé de páxina\";s:20:\"Footer fourth column\";s:32:\"Cuarta columna do pé de páxina\";s:6:\"Footer\";s:3:\"Pé\";s:25:\"Language switcher (@type)\";s:28:\"Alternador de idioma (@type)\";s:9:\"Syndicate\";s:10:\"Distribuir\";s:14:\"Recent content\";s:15:\"Contido recente\";s:11:\"Search form\";s:19:\"Formulario de busca\";s:17:\"Main page content\";s:28:\"Contido da páxina principal\";s:17:\"Powered by Drupal\";s:17:\"Powered by Drupal\";s:11:\"System help\";s:16:\"Axuda do sistema\";s:10:\"User login\";s:15:\"Iniciar sesión\";s:9:\"Who\'s new\";s:14:\"Novos usuarios\";s:12:\"Who\'s online\";s:19:\"Usuarios conectados\";s:6:\"fields\";s:6:\"campos\";s:5:\"Field\";s:5:\"Campo\";s:18:\"Contextual filters\";s:19:\"Filtros contextuais\";s:18:\"contextual filters\";s:19:\"filtros contextuais\";s:17:\"Contextual filter\";s:17:\"Filtro contextual\";s:17:\"contextual filter\";b:1;s:13:\"Sort criteria\";s:23:\"Criterio de ordenación\";s:13:\"sort criteria\";s:23:\"criterio de ordenación\";s:14:\"Sort criterion\";s:23:\"Criterio de ordenación\";s:14:\"sort criterion\";s:23:\"criterio de ordenación\";s:15:\"Filter criteria\";s:21:\"Criterios de filtrado\";s:15:\"filter criteria\";s:20:\"criterio de filtrado\";s:16:\"Filter criterion\";b:1;s:16:\"filter criterion\";b:1;s:13:\"Relationships\";s:10:\"Relacións\";s:13:\"relationships\";s:10:\"relacións\";s:12:\"Relationship\";s:9:\"Relación\";s:6:\"header\";s:9:\"cabeceira\";s:6:\"footer\";s:3:\"pé\";s:19:\"No results behavior\";s:35:\"Comportamento se non hai resultados\";s:19:\"no results behavior\";s:28:\"comportamento sen resultados\";s:11:\"Page splash\";b:1;s:7:\"Primary\";b:1;s:9:\"Secondary\";b:1;s:11:\"Footer left\";b:1;s:13:\"Footer center\";b:1;s:12:\"Footer right\";b:1;s:7:\"Contact\";s:8:\"Contacto\";s:7:\"Top Bar\";b:1;s:42:\"The configuration options have been saved.\";s:42:\"Gardáronse as opcións de configuración.\";s:58:\"Please continue to <a href=\"@error_url\">the error page</a>\";s:56:\"Continúe ata a <a href=\"@error_url\">páxina de erro</a>\";s:17:\"Translation files\";b:1;s:18:\"Translation files.\";b:1;s:0:\"\";b:1;s:33:\"Checked translation for %project.\";b:1;s:10:\"@count sec\";b:1;s:5:\"1 min\";b:1;s:36:\"Downloaded translation for %project.\";b:1;s:35:\"Importing translation for %project.\";b:1;s:17:\"Reset to defaults\";s:37:\"Restaurar cos valores predeterminados\";s:5:\"Value\";s:5:\"Valor\";s:6:\"Groups\";s:6:\"Grupos\";s:18:\"Node type settings\";s:30:\"Configuración do tipo de nodo\";s:3:\"all\";s:5:\"todos\";s:4:\"none\";s:7:\"ningún\";s:4:\"True\";s:10:\"Verdadeiro\";s:6:\"Sunday\";s:7:\"domingo\";s:6:\"Monday\";s:4:\"luns\";s:7:\"Tuesday\";s:6:\"martes\";s:9:\"Wednesday\";s:9:\"mércores\";s:8:\"Thursday\";s:5:\"xoves\";s:6:\"Friday\";s:6:\"venres\";s:8:\"Saturday\";s:7:\"sábado\";s:13:\"User settings\";s:25:\"Configuración de usuario\";s:9:\"Unlimited\";s:9:\"Ilimitado\";s:9:\"Undefined\";s:11:\"Sen definir\";s:13:\"Feed settings\";s:18:\"Axustes das orixes\";s:5:\"Empty\";s:7:\"Valeiro\";s:5:\"Debug\";s:11:\"Depuración\";s:6:\"Global\";s:6:\"Global\";s:25:\"Enabled, with translation\";s:25:\"Activado, con traducción\";s:11:\"Text format\";s:16:\"Formato do texto\";s:34:\"Imported translation for %project.\";b:1;s:9:\"Variables\";b:1;s:4:\"Keys\";b:1;s:21:\"!message (@percent%).\";b:1;s:28:\"Settings for each node type.\";b:1;s:14:\"Variable realm\";b:1;s:37:\"Site information and maintenance mode\";b:1;s:47:\"Variables that don\'t belong to any other group.\";b:1;s:30:\"Debug and development options.\";b:1;s:13:\"All variables\";b:1;s:38:\"There are %name variables in this form\";b:1;s:10:\"Realm list\";b:1;s:12:\"Realm weight\";b:1;s:5:\"Pages\";s:8:\"Páxinas\";s:6:\"Status\";s:6:\"Estado\";s:7:\"content\";s:7:\"contido\";s:29:\"This action cannot be undone.\";s:35:\"Esta acción non pode ser desfeita.\";s:9:\"Help text\";s:14:\"Texto de axuda\";s:8:\"Category\";s:10:\"Categoría\";s:5:\"Label\";s:8:\"Etiqueta\";s:4:\"Save\";s:6:\"Gardar\";s:4:\"Path\";s:4:\"Ruta\";s:7:\"Updated\";s:11:\"Actualizado\";s:21:\"Submission guidelines\";s:22:\"Instrucións de envío\";s:3:\"n/a\";s:3:\"n/d\";s:5:\"Paths\";s:5:\"Rutas\";s:7:\"Created\";s:6:\"Creado\";s:10:\"Node types\";s:13:\"Tipos de nodo\";s:9:\"Menu link\";s:17:\"Ligazón de menú\";s:5:\"Items\";s:9:\"Elementos\";s:21:\"Autocomplete taxonomy\";s:26:\"Autocompletar a taxonomía\";s:8:\"Revision\";s:9:\"Revisión\";s:12:\"Translations\";s:12:\"Traduccións\";s:6:\"Sticky\";s:9:\"Pegañoso\";s:13:\"Default value\";s:17:\"Valor predefinido\";s:20:\"Multilingual options\";s:21:\"Opcións multi idioma\";s:7:\"Strings\";s:6:\"Textos\";s:24:\"Synchronize translations\";s:27:\"Sincronizar as traduccións\";s:16:\"Language neutral\";s:14:\"Idioma neutral\";s:7:\"Context\";s:8:\"Contexto\";s:14:\"Field settings\";s:24:\"Configuracións do campo\";s:17:\"Save translations\";s:22:\"Gardar as traduccións\";s:12:\"Create @name\";s:11:\"Crear @name\";s:13:\"Original text\";s:14:\"Texto orixinal\";s:8:\"original\";s:8:\"orixinal\";s:9:\"translate\";s:8:\"traducir\";s:40:\"<strong>@language_name</strong> (source)\";s:39:\"<strong>@language_name</strong> (fonte)\";s:15:\"add translation\";s:19:\"engadir traducción\";s:22:\"Translations of %title\";s:22:\"Traduccións de %title\";s:30:\"@type %title has been created.\";s:21:\"Creouse @type %title.\";s:30:\"@type %title has been updated.\";s:31:\"O @type %title foi actualizado.\";s:11:\"Edit string\";s:12:\"Editar cadea\";s:9:\"Post date\";s:13:\"Data de envio\";s:19:\"Update translations\";s:26:\"Actualizar as traduccións\";s:18:\"Content type names\";s:26:\"Nomes dos tipos de contido\";s:23:\"Already added languages\";s:29:\"Os idiomas xa foron engadidos\";s:22:\"Create new translation\";s:27:\"Crear unha nova traducción\";s:16:\"Translation mode\";s:19:\"Modo de traducción\";s:23:\"Languages not yet added\";s:28:\"Idiomas aínda non engadidos\";s:24:\"Allowed HTML tags: @tags\";s:32:\"Etiquetas HTML permitidas: @tags\";s:30:\"The name of the taxonomy term.\";s:30:\"O nome do termo de taxonomía.\";s:46:\"The optional description of the taxonomy term.\";s:46:\"A descrición opcional do termo de taxonomía.\";s:44:\"The vocabulary the taxonomy term belongs to.\";s:51:\"O vocabulario de taxonomía o que pertence o termo.\";s:52:\"The parent term of the taxonomy term, if one exists.\";s:46:\"O termo pai do término de taxonomía, se hai.\";s:36:\"The name of the taxonomy vocabulary.\";s:36:\"O nome do vocabulario de taxonomía.\";s:52:\"The optional description of the taxonomy vocabulary.\";s:52:\"A descrición opcional do vocabulario de taxonomía.\";s:29:\"All pages except those listed\";s:44:\"Todas as páxinas excepto as que se enumeran\";s:21:\"Only the listed pages\";s:26:\"Só as páxinas enumeradas\";s:26:\"<em>Edit @type</em> @title\";s:28:\"<em>Editar @type</em> @title\";s:14:\"[empty string]\";s:15:\"[cadea valeira]\";s:11:\"Title label\";b:1;s:5:\"Terms\";b:1;s:8:\"Moderate\";b:1;s:5:\"terms\";b:1;s:7:\"Promote\";b:1;s:8:\"(source)\";b:1;s:19:\"Multilingual system\";b:1;s:29:\"Reset language for all terms.\";b:1;s:47:\"Normal - All enabled languages will be allowed.\";b:1;s:49:\"Extended - All defined languages will be allowed.\";b:1;s:21:\"Multilingual settings\";b:1;s:12:\"Node options\";b:1;s:10:\"vocabulary\";b:1;s:16:\"Save translation\";b:1;s:30:\"Hide content translation links\";b:1;s:30:\"Select translations for %title\";b:1;s:70:\"This module improves support for multilingual content in Drupal sites:\";b:1;s:41:\"Shows content depending on page language.\";b:1;s:31:\"Handles multilingual variables.\";b:1;s:69:\"This is the base module for several others adding different features:\";b:1;s:24:\"Multilingual menu items.\";b:1;s:25:\"Extended language support\";b:1;s:69:\"Configure extended options for multilingual content and translations.\";b:1;s:53:\"This module provides support for multilingual blocks.\";b:1;s:67:\"You can set up a language for a block or define it as translatable:\";b:1;s:74:\"Blocks with a language will be displayed only in pages with that language.\";b:1;s:71:\"Translatable blocks can be translated using the localization interface.\";b:1;s:18:\"Select text groups\";b:1;s:15:\"Refresh strings\";b:1;s:70:\"This will create all the missing strings for the selected text groups.\";b:1;s:72:\"On this page you can refresh and update values for user defined strings.\";b:1;s:58:\"Updated string %location for textgroup %textgroup: %string\";b:1;s:59:\"Created string %location for text group %textgroup: %string\";b:1;s:74:\"This module synchronizes content taxonomy and fields accross translations:\";b:1;s:52:\"A language can be assigned globaly for a vocabulary.\";b:1;s:65:\"Different terms for each language with translation relationships.\";b:1;s:59:\"Terms can be common to all languages, but may be localized.\";b:1;s:15:\"Add translation\";b:1;s:70:\"Extended multilingual options provided by Internationalization module.\";b:1;s:48:\"Set current language as default for new content.\";b:1;s:49:\"Require language (Do not allow Language Neutral).\";b:1;s:34:\"Lock language (Cannot be changed).\";b:1;s:34:\"Cannot refresh strings for %group.\";b:1;s:47:\"Translatable menu items: title and description.\";b:1;s:54:\"Provides some extended multilingual options for nodes.\";b:1;s:45:\"Content type names, descriptions, help texts.\";b:1;s:11:\"i18n_string\";b:1;s:29:\"Refresh user defined strings.\";b:1;s:62:\"Vocabulary titles and term names for localizable vocabularies.\";b:1;s:29:\"The name of the content type.\";b:1;s:45:\"The optional description of the content type.\";b:1;s:23:\"Enabled languages only.\";b:1;s:38:\"All defined languages will be allowed.\";b:1;s:37:\"Mixed options for multilingual sites.\";b:1;s:67:\"If no language is selected, block will show regardless of language.\";b:1;s:31:\"Administer content translations\";b:1;s:51:\"Add or remove existing content to translation sets.\";b:1;s:18:\"Text format: @name\";b:1;s:33:\"Options for user defined strings.\";b:1;s:41:\"Create also new revision for translations\";b:1;s:20:\"Standard node fields\";b:1;s:19:\"Configurable fields\";b:1;s:44:\"Multilingual variables, main variable names.\";b:1;s:44:\"Multilingual variables, real variable names.\";b:1;s:33:\"Configure multilingual variables.\";b:1;s:18:\"Language selection\";b:1;s:54:\"Updated @count string names from %oldname to %newname.\";b:1;s:33:\"Synchronize fields for node type.\";b:1;s:16:\"Name (localized)\";b:1;s:23:\"Description (localized)\";b:1;s:22:\"Vocabulary (localized)\";b:1;s:23:\"Parent term (localized)\";b:1;s:16:\"Link (localized)\";b:1;s:22:\"Plain text (localized)\";b:1;s:15:\"Translation set\";b:1;s:16:\"Translation sets\";b:1;s:26:\"Translation sets overview.\";b:1;s:38:\"Overview of existing translation sets.\";b:1;s:66:\"Enter items that will be considered as translations of each other.\";b:1;s:72:\"This item belongs to a multilingual menu. You can set a language for it.\";b:1;s:30:\"No translation sets available.\";b:1;s:25:\"Extended language options\";b:1;s:19:\"Select translations\";b:1;s:56:\"Predefined language. If set, it will apply to all items.\";b:1;s:27:\"Clean up left over strings.\";b:1;s:31:\"Refreshing user defined strings\";b:1;s:23:\"Starting string refresh\";b:1;s:37:\"Error refreshing user defined strings\";b:1;s:48:\"Successfully refreshed @count strings for %group\";b:1;s:33:\"Deleted @count left over strings.\";b:1;s:72:\"This block has generated content, only the title can be translated here.\";b:1;s:28:\"Make this block translatable\";b:1;s:35:\"Show this block for these languages\";b:1;s:18:\"Save and translate\";b:1;s:10:\"menu items\";b:1;s:53:\"Menus can also be configured to have no translations.\";b:1;s:10:\"translated\";b:1;s:14:\"not translated\";b:1;s:27:\"Translations of term %title\";b:1;s:36:\"%language translation of term %title\";b:1;s:21:\"- Select a language -\";b:1;s:59:\"Updated string %location for text group %textgroup: %string\";b:1;s:25:\"Multilingual node options\";b:1;s:45:\"Extended node options for multilingual sites.\";b:1;s:70:\"Default language for content types with Multilingual support disabled.\";b:1;s:48:\"The site\'s default language (Default behaviour).\";b:1;s:31:\"Language neutral (Recommended).\";b:1;s:22:\"Translate to !language\";b:1;s:15:\"Translate !name\";b:1;s:12:\"multilingual\";b:1;s:6:\"Weekly\";s:12:\"Semanalmente\";s:14:\"Check manually\";s:21:\"Comprobar manualmente\";s:10:\"Up to date\";s:11:\"Actualizado\";s:17:\"Check for updates\";s:32:\"Comprobar se hai actualizacións\";s:11:\"Drupal core\";s:17:\"Núcleo de Drupal\";s:19:\"Translation updates\";s:30:\"Actualizacións de traducións\";s:48:\"Check for updates of disabled modules and themes\";s:59:\"Comprobar actualizacións de módulos e temas non activados\";s:21:\"No strings available.\";s:26:\"Ningún texto dispoñible.\";s:11:\"l10n_update\";s:11:\"l10n_update\";s:30:\"Automatic update configuration\";s:44:\"Configuración de actualización automática\";s:50:\"@count disallowed HTML string(s) in files: @files.\";b:1;s:21:\"File not found: @uri.\";b:1;s:71:\"Translations imported: %number added, %update updated, %delete removed.\";b:1;s:21:\"Checking translations\";b:1;s:35:\"Error checking translation updates.\";b:1;s:22:\"Updating translations.\";b:1;s:69:\"No translation status available. <a href=\"@check\">Check manually</a>.\";b:1;s:59:\"No translation files are provided for development releases.\";b:1;s:49:\"File not found at %remote_path nor at %local_path\";b:1;s:15:\"@module (@date)\";b:1;s:19:\"@module (@version).\";b:1;s:25:\"Missing translations for:\";b:1;s:17:\"Updates available\";b:1;s:20:\"Missing translations\";b:1;s:21:\"Updates for: @modules\";b:1;s:23:\"Last checked: !time ago\";b:1;s:67:\"Status of interface translations for each of the enabled languages.\";b:1;s:5:\"0 sec\";s:5:\"0 seg\";s:6:\"status\";s:6:\"estado\";s:3:\"any\";s:8:\"calquera\";s:9:\"published\";s:9:\"publicado\";s:13:\"not published\";s:13:\"non publicado\";s:8:\"promoted\";s:12:\"promocionado\";s:12:\"not promoted\";s:16:\"non promocionado\";s:6:\"sticky\";s:9:\"pegañoso\";s:10:\"not sticky\";s:13:\"non pegañoso\";s:4:\"type\";s:4:\"tipo\";s:8:\"language\";s:6:\"idioma\";s:21:\"Show only items where\";s:31:\"Amosar só os elementos nos que\";s:6:\"Filter\";s:6:\"Filtro\";s:14:\"Update options\";s:19:\"Actualizar opcións\";s:24:\"Publish selected content\";s:31:\"Publicar o contido seleccionado\";s:26:\"Unpublish selected content\";s:34:\"Despublicar o contido seleccionado\";s:38:\"Promote selected content to front page\";s:52:\"Promover o contido seleccionado á páxina de inicio\";s:39:\"Demote selected content from front page\";s:52:\"Rebaixar o contido seleccionado da páxina principal\";s:28:\"Make selected content sticky\";s:37:\"Fai pegañento o contido seleccionado\";s:32:\"Make selected content not sticky\";s:41:\"Fai non pegañento o contido seleccionado\";s:23:\"Delete selected content\";s:30:\"Elimine o contido seleccionado\";s:16:\"Update URL alias\";s:23:\"Actualizar alias da URL\";s:9:\"Operation\";s:10:\"Operación\";s:21:\"No content available.\";s:23:\"Contido non dispoñible\";s:8:\"« first\";s:11:\"« primeira\";s:12:\"‹ previous\";s:12:\"‹ anterior\";s:8:\"next ›\";s:12:\"seguinte ›\";s:7:\"last »\";s:10:\"última »\";s:35:\"Remove from %shortcut_set shortcuts\";s:33:\"Eliminar de atallos %shortcut_set\";s:10:\"sort by @s\";s:14:\"ordenar por @s\";s:14:\"sort ascending\";s:19:\"arranxar ascendente\";s:22:\"GD library PNG support\";s:35:\"Funcionalidade PNG da biblioteca GD\";s:16:\"CTools CSS Cache\";b:1;s:6:\"Exists\";b:1;s:11:\"Not enabled\";s:11:\"Desactivado\";s:15:\"Upload progress\";s:18:\"Progreso da subida\";s:40:\"GD library rotate and desaturate effects\";s:50:\"Efectos de rotación e desaturado da biblioteca GD\";s:13:\"jQuery Update\";b:1;s:64:\"jQuery %jquery (<a href=\"@link\">configure</a>) and jQuery UI %ui\";b:1;s:23:\"Node Access Permissions\";s:25:\"Permisos de acceso o nodo\";s:19:\"Rebuild permissions\";s:21:\"Reconstruír permisos\";s:6:\"Drupal\";s:6:\"Drupal\";s:10:\"Web server\";s:12:\"Servidor web\";s:3:\"PHP\";s:3:\"PHP\";s:16:\"more information\";s:18:\"máis información\";s:20:\"PHP register globals\";s:20:\"PHP register globals\";s:14:\"PHP extensions\";s:15:\"Extensións PHP\";s:15:\"Database system\";s:24:\"Sistema de base de datos\";s:23:\"Database system version\";s:36:\"Versión do sistema de base de datos\";s:16:\"PHP memory limit\";s:25:\"Límite de memoria de PHP\";s:9:\"Protected\";s:9:\"Protexido\";s:18:\"Configuration file\";s:26:\"Ficheiro de configuración\";s:22:\"Public files directory\";s:32:\"Directorio de ficheiros público\";s:25:\"Temporary files directory\";s:33:\"Directorio de ficheiros temporais\";s:12:\"@count hours\";b:1;s:10:\"@count min\";b:1;s:18:\"Last run !time ago\";s:28:\"Última execución fai !time\";s:46:\"You can <a href=\"@cron\">run cron manually</a>.\";s:51:\"Pode <a href=\"@cron\">executar cron manualmente</a>.\";s:66:\"To run cron from outside the site, go to <a href=\"!cron\">!cron</a>\";s:72:\"Para executar cron de fóra do sitio web, ir a <a href=\"!cron\">!cron</a>\";s:22:\"Cron maintenance tasks\";s:30:\"Tarefas de mantemento de cron.\";s:42:\"Writable (<em>public</em> download method)\";s:56:\"Pódese escribir (método <em>público</em> de descarga)\";s:16:\"Database updates\";s:32:\"Actualizacións da base de datos\";s:20:\"Access to update.php\";s:19:\"Acceso a update.php\";s:12:\"Standard PHP\";s:13:\"PHP Estándar\";s:22:\"PHP Mbstring Extension\";s:26:\"Extensión Mbstring de PHP\";s:5:\"Error\";s:4:\"Erro\";s:15:\"Unicode library\";s:17:\"Librería Unicode\";s:20:\"Update notifications\";s:32:\"Notificacións de actualización\";s:23:\"Translation source node\";b:1;s:56:\"The source node for this current node\'s translation set.\";b:1;s:20:\"Revision log message\";s:34:\"Mensaxe do histotial de revisións\";s:60:\"The explanation of the most recent changes made to the node.\";s:64:\"A explicación dos cambios máis recentes realizados no contido.\";s:12:\"Content type\";s:15:\"Tipo de contido\";s:29:\"The content type of the node.\";b:1;s:32:\"Tokens related to content types.\";b:1;s:53:\"The unique machine-readable name of the content type.\";b:1;s:10:\"Node count\";s:15:\"Conteo de nodos\";s:50:\"The number of nodes belonging to the content type.\";b:1;s:8:\"Edit URL\";s:10:\"Editar URL\";s:40:\"The URL of the content type\'s edit page.\";b:1;s:41:\"The URL of the taxonomy term\'s edit page.\";b:1;s:7:\"Parents\";s:4:\"Pais\";s:59:\"An array of all the term\'s parents, starting with the root.\";b:1;s:9:\"Root term\";b:1;s:35:\"The root term of the taxonomy term.\";b:1;s:51:\"The unique machine-readable name of the vocabulary.\";b:1;s:38:\"The URL of the vocabulary\'s edit page.\";b:1;s:9:\"Base name\";b:1;s:26:\"The base name of the file.\";b:1;s:9:\"Extension\";s:10:\"Extensión\";s:26:\"The extension of the file.\";b:1;s:14:\"File byte size\";b:1;s:31:\"The size of the file, in bytes.\";b:1;s:24:\"Account cancellation URL\";b:1;s:56:\"The URL of the confirm delete page for the user account.\";b:1;s:18:\"One-time login URL\";b:1;s:56:\"The URL of the one-time login page for the user account.\";b:1;s:7:\"Picture\";s:5:\"Imaxe\";s:24:\"The picture of the user.\";b:1;s:48:\"The user roles associated with the user account.\";b:1;s:10:\"IP address\";s:11:\"Enderezo IP\";s:10:\"Menu links\";b:1;s:29:\"Tokens related to menu links.\";b:1;s:7:\"Link ID\";b:1;s:31:\"The unique ID of the menu link.\";b:1;s:27:\"The title of the menu link.\";b:1;s:25:\"The URL of the menu link.\";b:1;s:6:\"Parent\";s:10:\"Ascendente\";s:23:\"The menu link\'s parent.\";b:1;s:64:\"An array of all the menu link\'s parents, starting with the root.\";b:1;s:4:\"Root\";s:5:\"Raíz\";s:21:\"The menu link\'s root.\";b:1;s:12:\"Current page\";b:1;s:43:\"Tokens related to the current page request.\";b:1;s:30:\"The title of the current page.\";b:1;s:28:\"The URL of the current page.\";b:1;s:11:\"Page number\";b:1;s:61:\"The page number of the current page when viewing paged lists.\";b:1;s:18:\"Query string value\";b:1;s:63:\"The value of a specific query string field of the current page.\";b:1;s:23:\"Tokens related to URLs.\";b:1;s:30:\"The path component of the URL.\";b:1;s:12:\"Relative URL\";b:1;s:17:\"The relative URL.\";b:1;s:12:\"Absolute URL\";b:1;s:17:\"The absolute URL.\";b:1;s:9:\"Brief URL\";b:1;s:52:\"The URL without the protocol and trailing backslash.\";b:1;s:13:\"Unaliased URL\";b:1;s:18:\"The unaliased URL.\";b:1;s:9:\"Arguments\";s:10:\"Argumentos\";s:36:\"Tokens related to arrays of strings.\";b:1;s:5:\"First\";b:1;s:31:\"The first element of the array.\";b:1;s:4:\"Last\";b:1;s:30:\"The last element of the array.\";b:1;s:5:\"Count\";s:6:\"Contar\";s:36:\"The number of elements in the array.\";b:1;s:8:\"Reversed\";s:9:\"Invertido\";s:19:\"The array reversed.\";b:1;s:31:\"The array of keys of the array.\";b:1;s:8:\"Imploded\";b:1;s:32:\"The specific value of the array.\";b:1;s:6:\"Random\";s:9:\"Aleatorio\";s:31:\"A random number from 0 to @max.\";b:1;s:4:\"Hash\";b:1;s:64:\"A random hash. The possible hashing algorithms are: @hash-algos.\";b:1;s:39:\"Tokens for comments posted on the site.\";s:44:\"Tokens para os comentarios enviados o sitio.\";s:13:\"Comment count\";s:21:\"Conta dos comentarios\";s:40:\"The number of comments posted on a node.\";s:44:\"O número de comentarios enviados a un nodo.\";s:17:\"New comment count\";s:25:\"Nova conta de comentarios\";s:72:\"The number of comments posted on a node since the reader last viewed it.\";s:89:\"A cantidade de comentarios enviados a un nodo dende a última vez que o usuario o visitou\";s:10:\"Comment ID\";s:16:\"ID do comentario\";s:29:\"The unique ID of the comment.\";s:26:\"O ID único do comentario.\";s:10:\"IP Address\";s:11:\"Enderezo IP\";s:59:\"The IP address of the computer the comment was posted from.\";s:66:\"A dirección IP do ordenador dende a que foi enviado o comentario.\";s:36:\"The name left by the comment author.\";s:37:\"O nome deixado polo autor comentario.\";s:13:\"Email address\";s:31:\"Enderezo de correo electrónico\";s:45:\"The email address left by the comment author.\";s:55:\"O correo electrónico deixado polo autor do comentario.\";s:9:\"Home page\";s:17:\"Páxina de inicio\";s:45:\"The home page URL left by the comment author.\";s:40:\"A URL da páxina do autor do comentario.\";s:25:\"The title of the comment.\";s:24:\"O título do comentario.\";s:44:\"The formatted content of the comment itself.\";s:41:\"O contido formateado do comentario mesmo.\";s:23:\"The URL of the comment.\";s:20:\"A URL do comentario.\";s:35:\"The URL of the comment\'s edit page.\";s:43:\"A URL da páxina de edición do comentario.\";s:12:\"Date created\";s:17:\"Data de creación\";s:32:\"The date the comment was posted.\";s:37:\"Data na que foi enviado o comentario.\";s:12:\"Date changed\";s:15:\"Data modificada\";s:47:\"The date the comment was most recently updated.\";s:59:\"A data na que foi actualizado por última vez o comentario.\";s:53:\"The comment\'s parent, if comment threading is active.\";s:58:\"O comentario pai, se o fío de comentarios está activado.\";s:35:\"The node the comment was posted to.\";s:32:\"O nó o que enviou o comentario.\";s:50:\"The author of the comment, if they were logged in.\";s:62:\"O autor do comentario, se estuviese identificado como usuario.\";s:24:\"Tokens related to menus.\";b:1;s:21:\"The name of the menu.\";s:16:\"O nome do menú.\";s:45:\"The unique machine-readable name of the menu.\";b:1;s:37:\"The optional description of the menu.\";b:1;s:15:\"Menu link count\";b:1;s:47:\"The number of menu links belonging to the menu.\";b:1;s:32:\"The URL of the menu\'s edit page.\";b:1;s:26:\"The menu of the menu link.\";b:1;s:37:\"The URL of the menu link\'s edit page.\";b:1;s:28:\"The menu link for this node.\";b:1;s:5:\"Nodes\";s:5:\"Nodos\";s:55:\"Tokens related to individual content items, or \"nodes\".\";s:79:\"Comodins (Tokens) relacionados con elementos individuais de contido ou \"nodos\".\";s:10:\"Content ID\";s:13:\"ID do contido\";s:45:\"The unique ID of the content item, or \"node\".\";s:45:\"O ID único do elemento de contido ou \"nodo\".\";s:11:\"Revision ID\";s:15:\"ID da revisión\";s:44:\"The unique ID of the node\'s latest revision.\";s:40:\"O ID único da ultima revisión do nodo.\";s:18:\"Translation set ID\";s:28:\"ID do conxunto de tradución\";s:21:\"The type of the node.\";s:15:\"O tipo de nodo.\";s:17:\"Content type name\";s:23:\"Nome do tipo de contido\";s:41:\"The human-readable name of the node type.\";s:40:\"O nome para os usuarios do tipo de nodo.\";s:22:\"The title of the node.\";s:18:\"O título do nodo.\";s:31:\"The main body text of the node.\";s:35:\"O texto do corpo principal do nodo.\";s:7:\"Summary\";s:6:\"Resumo\";s:41:\"The summary of the node\'s main body text.\";s:45:\"O resumo do texto do corpo principal do nodo.\";s:36:\"The language the node is written in.\";s:37:\"O idioma no que está escrito o nodo.\";s:20:\"The URL of the node.\";s:14:\"A URL do nodo.\";s:32:\"The URL of the node\'s edit page.\";s:37:\"A URL da páxina de edición do nodo.\";s:29:\"The date the node was posted.\";s:30:\"A data que o nodo foi enviado.\";s:44:\"The date the node was most recently updated.\";s:47:\"A data de actualización máis recente do nodo.\";s:23:\"The author of the node.\";s:16:\"O autor do nodo.\";s:59:\"Tokens for site-wide settings and other global information.\";s:82:\"Tokens relacionados ca configuración de todo o sitio e outra información global.\";s:5:\"Dates\";s:5:\"Datas\";s:34:\"Tokens related to times and dates.\";s:38:\"Tokens relacionados con horas e datas.\";s:33:\"Tokens related to uploaded files.\";s:41:\"Tokens relacionados cos arquivos subidos.\";s:21:\"The name of the site.\";s:16:\"O nome do sitio.\";s:6:\"Slogan\";s:7:\"Eslogan\";s:23:\"The slogan of the site.\";s:18:\"O eslogan do sitio\";s:5:\"Email\";s:19:\"Correo electrónico\";s:46:\"The administrative email address for the site.\";s:50:\"O correo electrónico de administración do sitio.\";s:33:\"The URL of the site\'s front page.\";s:36:\"A URL da páxina principal do sitio.\";s:11:\"URL (brief)\";s:11:\"URL (corta)\";s:54:\"The URL of the site\'s front page without the protocol.\";s:53:\"A URL da páxina principal do sitio, sen o protocolo.\";s:10:\"Login page\";s:28:\"Páxina de inicio de sesión\";s:33:\"The URL of the site\'s login page.\";s:47:\"a URL da páxina de inicio de sesión no sitio.\";s:12:\"Short format\";s:13:\"Formato curto\";s:33:\"A date in \'short\' format. (%date)\";s:38:\"Unha data en formato \'curto\'. (%date).\";s:13:\"Medium format\";s:13:\"Formato medio\";s:3:\"Sat\";s:4:\"Sáb\";s:34:\"A date in \'medium\' format. (%date)\";s:37:\"Unha data en formato \'medio\'. (%date)\";s:11:\"Long format\";s:13:\"Formato longo\";s:32:\"A date in \'long\' format. (%date)\";s:37:\"Unha data en formato \'longo\'. (%date)\";s:13:\"Custom format\";s:21:\"Formato personalizado\";s:21:\"the PHP documentation\";s:23:\"a documentación de PHP\";s:53:\"A date in a custom format. See !php-date for details.\";s:71:\"Unha data en formato personalizado. Vexa !php-date para máis detalles.\";s:10:\"Time-since\";s:11:\"Tempo-dende\";s:12:\"@count years\";b:1;s:13:\"@count months\";b:1;s:38:\"A date in \'time-since\' format. (%date)\";s:38:\"Data en formato \'tempo-dende\'. (%date)\";s:13:\"Raw timestamp\";s:25:\"Selo temporal sen filtrar\";s:39:\"A date in UNIX timestamp format (%date)\";s:50:\"Unha data en formato de selo temporal UNIX (%date)\";s:7:\"File ID\";s:14:\"ID do ficheiro\";s:35:\"The unique ID of the uploaded file.\";s:41:\"O ID único do arquivo subido o servidor.\";s:9:\"File name\";s:16:\"Nome do ficheiro\";s:29:\"The name of the file on disk.\";s:27:\"O nome do arquivo no disco.\";s:49:\"The location of the file relative to Drupal root.\";s:56:\"A localización do ficheiro relativo á raíz de Drupal.\";s:9:\"MIME type\";s:9:\"Tipo MIME\";s:26:\"The MIME type of the file.\";s:23:\"O tipo MIME do arquivo.\";s:9:\"File size\";s:19:\"Tamaño do ficheiro\";s:21:\"The size of the file.\";s:22:\"O tamaño do ficheiro.\";s:36:\"The web-accessible URL for the file.\";s:44:\"A URL do arquivo accesible a través da web.\";s:9:\"Timestamp\";s:14:\"Marca de tempo\";s:44:\"The date the file was most recently changed.\";s:49:\"A data da modificación máis recente do arquivo.\";s:5:\"Owner\";s:11:\"Propietario\";s:42:\"The user who originally uploaded the file.\";s:45:\"O usuario que orixinalmente subiu o ficheiro.\";s:33:\"Tokens related to taxonomy terms.\";s:47:\"Comodins relacionados con termos de taxonomía.\";s:12:\"Vocabularies\";s:12:\"Vocabularios\";s:40:\"Tokens related to taxonomy vocabularies.\";s:53:\"Comodins relacionados cos vocabularios de taxonomía.\";s:7:\"Term ID\";s:11:\"ID do termo\";s:35:\"The unique ID of the taxonomy term.\";s:35:\"O ID único do termo de taxonomía.\";s:50:\"The number of nodes tagged with the taxonomy term.\";s:54:\"O número de nodos etiquetados co termo de taxonomía.\";s:29:\"The URL of the taxonomy term.\";s:30:\"La URL do termo de taxonomía.\";s:13:\"Vocabulary ID\";s:17:\"ID do vocabulario\";s:41:\"The unique ID of the taxonomy vocabulary.\";s:40:\"O ID único do vocabulario de taxonomía\";s:10:\"Term count\";s:16:\"Conteo de termos\";s:57:\"The number of terms belonging to the taxonomy vocabulary.\";s:62:\"O número de termos pertencentes ao vocabulario de taxonomía.\";s:11:\"Parent term\";s:9:\"Termo pai\";s:43:\"Tokens related to individual user accounts.\";s:54:\"Tokens relacionados con contas individuais de usuario.\";s:12:\"Current user\";s:14:\"Usuario actual\";s:47:\"Tokens related to the currently logged in user.\";s:56:\"Comodíns relacionados co usuario conectado actualmente.\";s:7:\"User ID\";s:15:\"ID de usuario/a\";s:34:\"The unique ID of the user account.\";s:32:\"O ID único da conta de usuario.\";s:35:\"The login name of the user account.\";s:48:\"O nome de inicio de sesión da conta de usuario.\";s:38:\"The email address of the user account.\";s:53:\"O enderezo de correo-eletrónico da conta de usuario.\";s:36:\"The URL of the account profile page.\";s:36:\"A URL da páxina do perfil da conta.\";s:33:\"The URL of the account edit page.\";s:35:\"A URL da páxina de edición conta.\";s:10:\"Last login\";s:25:\"Último inicio de sesión\";s:45:\"The date the user last logged in to the site.\";s:61:\"A data na que o último usuario identificouse na páxina web.\";s:38:\"The date the user account was created.\";s:42:\"A data na que se creou a conta de usuario.\";s:27:\"Tokens for variable values.\";b:1;s:11:\"Joined path\";b:1;s:24:\"Tokens related to views.\";s:30:\"Comodíns relativos as vistas.\";s:36:\"The human-readable name of the view.\";s:33:\"O nome da vista para os usuarios.\";s:28:\"The description of the view.\";s:21:\"Descrición da vista.\";s:38:\"The machine-readable name of the view.\";s:31:\"O nome da vista para o sistema.\";s:41:\"The title of current display of the view.\";s:41:\"Título da presentación actual da vista.\";s:20:\"The URL of the view.\";s:15:\"A URL da vista.\";s:12:\"Current date\";s:11:\"Data actual\";s:44:\"Tokens related to the current date and time.\";b:1;s:16:\"Original @entity\";b:1;s:67:\"The original @entity data if the @entity is being updated or saved.\";b:1;s:12:\"@type field.\";b:1;s:62:\"The following tokens or token types are not defined as arrays:\";b:1;s:57:\"The following token types do not have any tokens defined:\";b:1;s:58:\"The following token types are not defined but have tokens:\";b:1;s:67:\"The following token or token types are defined by multiple modules:\";b:1;s:17:\"Hide descriptions\";s:20:\"Ocultar descricións\";s:39:\"Compress layout by hiding descriptions.\";s:62:\"Produce un deseño menos compacto que inclúe as descricións.\";s:4:\"i18n\";b:1;s:10:\"i18n_block\";b:1;s:18:\"Built-in interface\";s:19:\"Interface integrado\";s:18:\"English (built-in)\";s:17:\"Ingles (built-in)\";s:30:\"GD2 image manipulation toolkit\";s:42:\"Ferramentas de manipulación de imaxes GD2\";s:49:\"The GD toolkit is installed and working properly.\";s:60:\"A utilidade GD2 está instalada e funcionando correctamente.\";s:12:\"JPEG quality\";s:13:\"Calidade JPEG\";s:1:\"%\";s:1:\"%\";s:6:\"Resize\";s:13:\"Redimensionar\";s:5:\"Scale\";s:6:\"Escala\";s:14:\"Scale and crop\";s:18:\"Escalar e recortar\";s:4:\"Crop\";s:8:\"Recortar\";s:10:\"Desaturate\";s:9:\"Desaturar\";s:42:\"Desaturate converts an image to grayscale.\";s:50:\"Desaturar convirte unha imaxe en escala de grises.\";s:6:\"Rotate\";s:5:\"Rotar\";s:10:\"Style name\";s:14:\"Nome do estilo\";s:23:\"Public file system path\";s:36:\"Ruta do sistema público de arquivos\";s:24:\"Private file system path\";s:34:\"Ruta o sistema privado de arquivos\";s:19:\"Temporary directory\";s:17:\"Cartafol temporal\";s:23:\"Default download method\";s:34:\"Método predeterminado de descarga\";s:39:\"Transliterate file names during upload.\";b:1;s:38:\"Transliterate the displayed file name.\";b:1;s:36:\"Lowercase transliterated file names.\";b:1;s:22:\"Unknown variable @name\";b:1;s:13:\"Private files\";s:17:\"Arquivos privados\";s:37:\"Private local files served by Drupal.\";s:45:\"Arquivos privados locais servidos por Drupal.\";s:32:\"Transliteration is not required.\";b:1;s:67:\"There are currently no files names containing non-ASCII characters.\";b:1;s:23:\"Private files directory\";s:32:\"Directorio de ficheiros privados\";s:9:\"No editor\";s:10:\"Sin editor\";s:72:\"<a href=\"!vendor-url\">@editor</a> (<a href=\"!download-url\">Download</a>)\";s:73:\"<a href=\"!vendor-url\">@editor</a> (<a href=\"!download-url\">Descargar</a>)\";s:14:\"Not installed.\";s:14:\"Non instalado.\";s:74:\"So the actual library can be found at:<br /><code>@library-filepath</code>\";s:83:\"Así que a biblioteca actual pódese atopar en:<br /><code>@library-filepath</code>\";s:25:\"Installation instructions\";s:29:\"Instruccións de instalación\";s:4:\"Info\";s:12:\"Información\";s:2:\"OK\";s:7:\"Aceptar\";s:7:\"Warning\";s:6:\"Alerta\";s:16:\"Select an editor\";b:1;s:6:\"Editor\";s:6:\"Editor\";s:15:\"String contains\";s:15:\"A cadea contén\";s:62:\"Leave blank to show all strings. The search is case sensitive.\";s:91:\"Deixar en branco para mostrar todas as cadeas. A busca distingue maiúsculas e minúsculas.\";s:13:\"All languages\";s:16:\"Todos os idiomas\";s:28:\"English (provided by Drupal)\";s:34:\"Inglés (proporcionado por Drupal)\";s:9:\"Search in\";s:9:\"Buscar en\";s:40:\"Both translated and untranslated strings\";s:40:\"Ambas cadeas traducidas e non traducidas\";s:23:\"Only translated strings\";s:21:\"Só cadeas traducidas\";s:25:\"Only untranslated strings\";s:23:\"Só cadeas sen traducir\";s:15:\"Limit search to\";s:17:\"Limitar a busca a\";s:15:\"All text groups\";s:24:\"Todos os grupos de texto\";s:27:\"Filter translatable strings\";s:26:\"Filtrar textos traducibles\";s:8:\"- None -\";s:11:\"- Ningún -\";s:10:\"Text group\";s:14:\"Grupo de texto\";s:16:\"Go to first page\";s:22:\"Ir á primeira páxina\";s:19:\"Go to previous page\";s:22:\"Ir á páxina anterior\";s:15:\"Go to next page\";s:22:\"Ir á seguinte páxina\";s:15:\"Go to last page\";s:21:\"Ir á última páxina\";s:18:\"Go to page @number\";s:21:\"Ir á páxina @number\";s:4:\"Afar\";s:8:\"Afarense\";s:9:\"Abkhazian\";s:7:\"Abxasio\";s:7:\"Avestan\";s:7:\"Avestan\";s:9:\"Afrikaans\";s:9:\"Afrikaans\";s:4:\"Akan\";s:4:\"Akan\";s:7:\"Amharic\";s:8:\"Amárico\";s:6:\"Arabic\";s:6:\"Árabe\";s:8:\"Assamese\";s:7:\"Asamés\";s:8:\"Asturian\";s:9:\"Asturiano\";s:4:\"Avar\";s:4:\"Avar\";s:6:\"Aymara\";s:6:\"Aimara\";s:11:\"Azerbaijani\";s:12:\"Azerbaianés\";s:7:\"Bashkir\";s:10:\"Bashkirés\";s:10:\"Belarusian\";s:10:\"Bielorruso\";s:9:\"Bulgarian\";s:8:\"Búlgaro\";s:6:\"Bihari\";s:7:\"Biharí\";s:7:\"Bislama\";s:7:\"Bislama\";s:7:\"Bambara\";s:7:\"Bambara\";s:7:\"Bengali\";s:8:\"Bengalí\";s:7:\"Tibetan\";s:8:\"Tibetano\";s:6:\"Breton\";s:7:\"Bretón\";s:7:\"Bosnian\";s:6:\"Bosnio\";s:7:\"Catalan\";s:8:\"Catalán\";s:7:\"Chechen\";s:8:\"Checheno\";s:8:\"Chamorro\";s:8:\"Chamorro\";s:8:\"Corsican\";s:5:\"Corso\";s:4:\"Cree\";s:4:\"Cree\";s:5:\"Czech\";s:12:\"Checoslovaco\";s:12:\"Old Slavonic\";s:13:\"Eslavo antigo\";s:7:\"Chuvash\";s:7:\"Chuvash\";s:5:\"Welsh\";s:6:\"Galés\";s:6:\"Danish\";s:12:\"Dinamarqués\";s:6:\"German\";s:7:\"Alemán\";s:9:\"Maldivian\";s:7:\"Maldivo\";s:7:\"Bhutani\";s:8:\"Bhutaní\";s:3:\"Ewe\";s:3:\"Ewe\";s:5:\"Greek\";s:5:\"Grego\";s:16:\"English, British\";s:18:\"Ingles, Británico\";s:9:\"Esperanto\";s:9:\"Esperanto\";s:8:\"Estonian\";s:7:\"Estonio\";s:6:\"Basque\";s:5:\"Vasco\";s:7:\"Persian\";s:5:\"Persa\";s:5:\"Fulah\";s:5:\"Fulah\";s:7:\"Finnish\";s:6:\"Finés\";s:8:\"Filipino\";s:8:\"Filipino\";s:4:\"Fiji\";s:4:\"Fixi\";s:8:\"Faeroese\";s:7:\"Feroés\";s:6:\"French\";s:8:\"Francés\";s:7:\"Frisian\";s:6:\"Frisio\";s:5:\"Irish\";s:9:\"Irlandés\";s:12:\"Scots Gaelic\";s:17:\"Gaélico Escocés\";s:7:\"Guarani\";s:8:\"Guaraní\";s:12:\"Swiss German\";s:14:\"Suízo Alemán\";s:8:\"Gujarati\";s:9:\"Guxaratí\";s:4:\"Manx\";s:4:\"Manx\";s:5:\"Hausa\";s:5:\"Hausa\";s:6:\"Hebrew\";s:6:\"Hebreo\";s:5:\"Hindi\";s:6:\"Hindú\";s:9:\"Hiri Motu\";s:9:\"Hiri Motu\";s:8:\"Croatian\";s:6:\"Croata\";s:14:\"Haitian Creole\";s:16:\"Crioulo haitiano\";s:9:\"Hungarian\";s:8:\"Húngaro\";s:8:\"Armenian\";s:7:\"Armenio\";s:6:\"Herero\";s:6:\"Herero\";s:11:\"Interlingua\";s:11:\"Interlingua\";s:10:\"Indonesian\";s:9:\"Indonesio\";s:11:\"Interlingue\";s:11:\"Interlingue\";s:4:\"Igbo\";s:4:\"Igbo\";s:7:\"Inupiak\";s:7:\"Inupiak\";s:9:\"Icelandic\";s:9:\"Islandés\";s:7:\"Italian\";s:8:\"Italiano\";s:9:\"Inuktitut\";s:9:\"Inuktitut\";s:8:\"Japanese\";s:8:\"Xaponés\";s:8:\"Javanese\";s:8:\"Xavanés\";s:8:\"Georgian\";s:9:\"Xeorxiano\";s:5:\"Kongo\";s:5:\"Kongo\";s:6:\"Kikuyu\";s:6:\"Kikuyu\";s:8:\"Kwanyama\";s:8:\"Kwanyama\";s:6:\"Kazakh\";s:7:\"Kazaxio\";s:11:\"Greenlandic\";s:12:\"Groenlandés\";s:9:\"Cambodian\";s:9:\"Camboiano\";s:7:\"Kannada\";s:6:\"Kanada\";s:6:\"Korean\";s:7:\"Coreano\";s:6:\"Kanuri\";s:6:\"Kanuri\";s:8:\"Kashmiri\";s:11:\"Cachemirés\";s:7:\"Kurdish\";s:5:\"Curdo\";s:4:\"Komi\";s:7:\"Cómico\";s:7:\"Cornish\";s:8:\"Córnico\";s:6:\"Kyrgyz\";s:8:\"Kirguís\";s:5:\"Latin\";s:6:\"Latín\";s:13:\"Luxembourgish\";s:13:\"Luxemburgués\";s:7:\"Luganda\";s:7:\"Luganda\";s:7:\"Lingala\";s:7:\"Lingala\";s:8:\"Laothian\";s:8:\"Laosiano\";s:10:\"Lithuanian\";s:7:\"Lituano\";s:7:\"Latvian\";s:6:\"Letón\";s:8:\"Malagasy\";s:8:\"Malgache\";s:11:\"Marshallese\";s:10:\"Marsellés\";s:6:\"Māori\";s:5:\"Maori\";s:10:\"Macedonian\";s:9:\"Macedonio\";s:9:\"Malayalam\";s:9:\"Malayalam\";s:9:\"Mongolian\";s:6:\"Mongol\";s:9:\"Moldavian\";s:7:\"Moldavo\";s:7:\"Marathi\";s:7:\"Márata\";s:5:\"Malay\";s:6:\"Malayo\";s:7:\"Maltese\";s:7:\"Maltés\";s:7:\"Burmese\";s:7:\"Birmano\";s:5:\"Nauru\";s:8:\"Nauruano\";s:13:\"North Ndebele\";s:15:\"Ndebele (norte)\";s:6:\"Nepali\";s:8:\"Nepalés\";s:6:\"Ndonga\";s:6:\"Ndonga\";s:5:\"Dutch\";s:9:\"Holandés\";s:17:\"Norwegian Bokmål\";s:15:\"Noruego Bokmål\";s:17:\"Norwegian Nynorsk\";s:15:\"Noruego Nynorsk\";s:13:\"South Ndebele\";s:13:\"Ndebele (sur)\";s:6:\"Navajo\";s:6:\"Navaxo\";s:8:\"Chichewa\";s:8:\"Chichewa\";s:7:\"Occitan\";s:8:\"Occitano\";s:5:\"Oromo\";s:5:\"Oromo\";s:5:\"Oriya\";s:8:\"Orillés\";s:8:\"Ossetian\";s:5:\"Oseto\";s:7:\"Punjabi\";s:9:\"Punxabés\";s:4:\"Pali\";s:4:\"Pali\";s:6:\"Polish\";s:6:\"Polaco\";s:6:\"Pashto\";s:6:\"Pashto\";s:25:\"Portuguese, International\";s:25:\"Portugués, Internacional\";s:20:\"Portuguese, Portugal\";s:20:\"Portugués, Portugal\";s:18:\"Portuguese, Brazil\";s:18:\"Portugués, Brasil\";s:7:\"Quechua\";s:7:\"Quechua\";s:14:\"Rhaeto-Romance\";s:14:\"Retorrománico\";s:7:\"Kirundi\";s:7:\"Kirundi\";s:8:\"Romanian\";s:8:\"Romanés\";s:7:\"Russian\";s:4:\"Ruso\";s:11:\"Kinyarwanda\";s:11:\"Kiniarwanda\";s:8:\"Sanskrit\";s:10:\"Sánscrito\";s:9:\"Sardinian\";s:5:\"Sardo\";s:5:\"Scots\";s:8:\"Escocés\";s:6:\"Sindhi\";s:7:\"Sindino\";s:13:\"Northern Sami\";s:12:\"Sami (norte)\";s:5:\"Sango\";s:5:\"Sango\";s:14:\"Serbo-Croatian\";s:12:\"Serbo-Croata\";s:7:\"Sinhala\";s:7:\"Sinhala\";s:6:\"Slovak\";s:8:\"Eslovaco\";s:9:\"Slovenian\";s:8:\"Esloveno\";s:6:\"Samoan\";s:7:\"Samoano\";s:5:\"Shona\";s:6:\"Sonés\";s:6:\"Somali\";s:7:\"Somalí\";s:8:\"Albanian\";s:8:\"Albanés\";s:7:\"Serbian\";s:6:\"Serbio\";s:7:\"Siswati\";s:12:\"Suazilandés\";s:7:\"Sesotho\";s:8:\"Sesotés\";s:8:\"Sudanese\";s:8:\"Sudanés\";s:7:\"Swedish\";s:5:\"Sueco\";s:7:\"Swahili\";s:7:\"Suaxili\";s:5:\"Tamil\";s:5:\"Tamil\";s:6:\"Telugu\";s:6:\"Telugo\";s:5:\"Tajik\";s:6:\"Taxiko\";s:4:\"Thai\";s:10:\"Tailandés\";s:8:\"Tigrinya\";s:10:\"Tigriñés\";s:7:\"Turkmen\";s:9:\"Turcomano\";s:7:\"Tagalog\";s:8:\"Tagalés\";s:8:\"Setswana\";s:10:\"Sechuanés\";s:5:\"Tonga\";s:8:\"Tongués\";s:7:\"Turkish\";s:5:\"Turco\";s:6:\"Tsonga\";s:6:\"Tsonga\";s:5:\"Tatar\";s:8:\"Tártaro\";s:3:\"Twi\";s:3:\"Tui\";s:8:\"Tahitian\";s:9:\"Tahitiano\";s:6:\"Uyghur\";s:5:\"Uigur\";s:9:\"Ukrainian\";s:9:\"Ucraniano\";s:4:\"Urdu\";s:4:\"Urdu\";s:5:\"Uzbek\";s:9:\"Uzbequés\";s:5:\"Venda\";s:5:\"Venda\";s:10:\"Vietnamese\";s:10:\"Vietnamita\";s:5:\"Wolof\";s:5:\"Uolof\";s:5:\"Xhosa\";s:5:\"Xhosa\";s:8:\"Lolspeak\";s:8:\"Lolspeak\";s:7:\"Yiddish\";s:6:\"Xidish\";s:6:\"Yoruba\";s:6:\"Ioruba\";s:6:\"Zhuang\";s:6:\"Zhuang\";s:19:\"Chinese, Simplified\";s:21:\"Chinés, simplificado\";s:20:\"Chinese, Traditional\";s:20:\"Chinés, tradicional\";s:4:\"Zulu\";s:5:\"Zulú\";s:18:\"Import translation\";s:20:\"Importar traducción\";s:13:\"Language file\";s:18:\"Ficheiro de idioma\";s:46:\"A Gettext Portable Object (<em>.po</em>) file.\";s:51:\"Un ficheiro Gettext Portable Object (<em>.po</em>).\";s:11:\"Import into\";s:11:\"Importar en\";s:55:\"Imported translations will be added to this text group.\";s:61:\"As traduccións importadas engadiranse a este grupo de texto.\";s:4:\"Mode\";s:4:\"Modo\";s:40:\"Missing translations for @count projects\";b:1;s:13:\"Update @title\";s:17:\"Actualizar @title\";s:30:\"Module and theme update status\";s:51:\"Estado das actualizacións de módulos e plantillas\";s:5:\"1 sec\";b:1;s:68:\"Checked available interface translation updates for @count projects.\";b:1;s:3:\"Wed\";s:4:\"Mér\";s:3:\"Thu\";s:3:\"Xov\";s:3:\"Fri\";s:3:\"Ven\";s:3:\"Mon\";s:3:\"Lun\";s:3:\"Sun\";s:3:\"Dom\";s:3:\"Tue\";s:3:\"Mar\";s:36:\"Missing translations for one project\";b:1;s:12:\"Created date\";s:17:\"Data de creación\";s:4:\"Next\";s:8:\"Seguinte\";s:26:\"Create a new user account.\";s:35:\"Crear unha nova conta de usuario/a.\";s:32:\"Request new password via e-mail.\";s:43:\"Solicitar un novo contrasinal por correo-e.\";s:6:\"Prefix\";s:7:\"Prefixo\";s:6:\"Suffix\";s:6:\"Sufixo\";s:6:\"E-mail\";s:8:\"Correo-e\";s:8:\"Username\";s:17:\"Nome de usuario/a\";s:5:\"Group\";s:5:\"Grupo\";s:3:\"yes\";s:2:\"si\";s:7:\"Confirm\";s:9:\"Confirmar\";s:6:\"Remove\";s:6:\"Quitar\";s:8:\"RSS feed\";s:9:\"Canle RSS\";s:4:\"More\";s:5:\"Máis\";s:12:\"not verified\";s:14:\"non verificado\";s:3:\"new\";s:4:\"novo\";s:5:\"error\";s:4:\"erro\";s:4:\"Tags\";s:9:\"Etiquetas\";s:11:\"Block title\";s:17:\"Título do bloque\";s:44:\"The title of the block as shown to the user.\";s:50:\"O título do bloque como se mostra a/ao usuario/a.\";s:3:\"Yes\";s:2:\"Si\";s:2:\"No\";s:3:\"Non\";s:4:\"cron\";s:4:\"cron\";s:10:\"Categories\";s:11:\"Categorías\";s:8:\"Download\";s:9:\"Descargar\";s:7:\"updated\";s:11:\"actualizado\";s:16:\"File information\";s:24:\"Información do ficheiro\";s:13:\"Release notes\";s:17:\"Notas da versión\";s:4:\"Date\";s:4:\"Data\";s:4:\"Size\";s:7:\"Tamaño\";s:14:\"Predeterminado\";b:1;s:5:\"Daily\";s:11:\"Diariamente\";s:7:\"Message\";s:7:\"Mensaxe\";s:26:\"No log messages available.\";s:42:\"Non hai mensaxes de rexistro dispoñibles.\";s:8:\"Password\";s:11:\"Contrasinal\";s:6:\"Center\";s:7:\"Centrar\";s:4:\"root\";s:5:\"raíz\";s:4:\"Book\";s:5:\"Libro\";s:7:\"Preview\";s:12:\"Vista previa\";s:3:\"Add\";s:7:\"Engadir\";s:6:\"Format\";s:7:\"Formato\";s:7:\"History\";s:9:\"Historial\";s:8:\"Filename\";s:16:\"Nome de ficheiro\";s:7:\"Refresh\";s:10:\"Actualizar\";s:6:\"Region\";s:5:\"Área\";s:7:\"Visible\";s:8:\"Visíbel\";s:6:\"Anchor\";s:7:\"Áncora\";s:7:\"Display\";s:14:\"Visualización\";s:17:\"Advanced settings\";s:23:\"Configuración avanzada\";s:5:\"never\";s:5:\"nunca\";s:7:\"actions\";s:8:\"accións\";s:8:\"Add term\";s:13:\"Engadir termo\";s:10:\"Statistics\";s:13:\"Estatísticas\";s:15:\"Advanced search\";s:14:\"Busca avanzada\";s:43:\"You are not authorized to access this page.\";s:51:\"Non está autorizado/a para acceder a esta páxina.\";s:6:\"Upload\";s:5:\"Subir\";s:2:\"no\";s:3:\"non\";s:6:\"Create\";s:5:\"Crear\";s:6:\"Active\";s:6:\"Activo\";s:13:\"Access denied\";s:15:\"Acceso denegado\";s:4:\"Year\";s:3:\"Ano\";s:4:\"Logo\";s:8:\"Logotipo\";s:4:\"Good\";s:2:\"Bo\";s:19:\"Manual update check\";s:40:\"Comprobación manual das actualizacións\";s:5:\"Never\";s:5:\"Nunca\";s:16:\"Update available\";s:26:\"Actualización dispoñible\";s:11:\"Out of date\";s:8:\"Obsoleto\";s:6:\"Inline\";s:8:\"En liña\";s:8:\"Selected\";s:12:\"Seleccionado\";s:8:\"Hostname\";s:25:\"Nome do equipo anfitrión\";s:9:\"Signature\";s:8:\"Sinatura\";s:6:\"Locale\";s:13:\"Localización\";s:9:\"Revisions\";s:9:\"Revisión\";s:9:\"URL alias\";s:12:\"Alias de URL\";s:15:\"Vocabulary name\";s:19:\"Nome do vocabulario\";s:11:\"Last access\";s:14:\"Último acceso\";s:8:\"Severity\";s:10:\"Severidade\";s:10:\"Field name\";s:13:\"Nome de campo\";s:10:\"Field type\";s:13:\"Tipo de campo\";s:11:\"Widget type\";s:14:\"Tipo de widget\";s:10:\"Overridden\";s:12:\"Sobreescrito\";s:8:\"Set name\";s:16:\"Nome do conxunto\";s:14:\"Original image\";s:14:\"Imaxe orixinal\";s:7:\"blocked\";s:9:\"bloqueado\";s:6:\"active\";s:6:\"activo\";s:9:\"configure\";s:10:\"configurar\";s:11:\"Authored by\";s:10:\"Creado por\";s:5:\"Width\";s:5:\"Ancho\";s:6:\"Height\";s:4:\"Alto\";s:7:\"Maximum\";s:7:\"Máximo\";s:7:\"Caching\";s:6:\"Caché\";s:5:\"Month\";s:3:\"Mes\";s:6:\"Widget\";s:7:\"Control\";s:32:\"Add a role to the selected users\";s:45:\"Engadir un rol para os usuarios seleccionados\";s:37:\"Remove a role from the selected users\";s:43:\"Eliminar un rol dos usuarios seleccionados.\";s:5:\"Egypt\";s:6:\"Exipto\";s:7:\"Namibia\";s:7:\"Namibia\";s:6:\"Israel\";s:6:\"Israel\";s:4:\"Iran\";s:5:\"Irán\";s:11:\"New Zealand\";s:12:\"Nova Zelanda\";s:4:\"Cuba\";s:4:\"Cuba\";s:6:\"Brazil\";s:6:\"Brasil\";s:5:\"Chile\";s:5:\"Chile\";s:8:\"Paraguay\";s:8:\"Paraguai\";s:7:\"Jamaica\";s:7:\"Xamaica\";s:5:\"Japan\";s:6:\"Xapón\";s:5:\"Libya\";s:5:\"Libia\";s:6:\"Poland\";s:7:\"Polonia\";s:8:\"Portugal\";s:8:\"Portugal\";s:9:\"Singapore\";s:8:\"Singapur\";s:6:\"Turkey\";s:8:\"Turquía\";s:3:\"Day\";s:4:\"Día\";s:3:\"May\";s:3:\"Mai\";s:2:\"am\";s:2:\"am\";s:2:\"pm\";s:2:\"pm\";s:9:\"!time ago\";s:9:\"Fai !time\";s:16:\"Background color\";s:12:\"Cor de fondo\";s:10:\"Text color\";s:12:\"Cor do texto\";s:5:\"Color\";s:3:\"Cor\";s:6:\"Log in\";s:15:\"Iniciar sesión\";s:13:\"Not installed\";s:13:\"Non instalado\";s:15:\"Text processing\";s:16:\"Procesando texto\";s:14:\"Maximum length\";s:17:\"Lonxitude máxima\";s:4:\"Rows\";s:5:\"Filas\";s:12:\"Save changes\";s:14:\"Gardar cambios\";s:7:\"Install\";s:8:\"Instalar\";s:5:\"Order\";s:4:\"Orde\";s:11:\"Set default\";s:27:\"Establecer como predefinido\";s:7:\"Profile\";s:6:\"Perfil\";s:15:\"Anonymous users\";s:24:\"Usuarios/as anónimos/as\";s:11:\"Clear cache\";s:15:\"Limpar a caché\";s:19:\"Visibility settings\";s:30:\"Configuración da visibilidade\";s:5:\"Votes\";s:5:\"Votos\";s:8:\"Function\";s:8:\"Función\";s:7:\"Germany\";s:8:\"Alemaña\";s:11:\"Afghanistan\";s:11:\"Afganistán\";s:7:\"Albania\";s:7:\"Albania\";s:7:\"Algeria\";s:7:\"Argelia\";s:14:\"American Samoa\";s:15:\"Samoa americana\";s:7:\"Andorra\";s:7:\"Andorra\";s:6:\"Angola\";s:6:\"Angola\";s:8:\"Anguilla\";s:8:\"Anguilla\";s:10:\"Antarctica\";s:10:\"Antártida\";s:19:\"Antigua and Barbuda\";s:16:\"Antiga e Barbuda\";s:9:\"Argentina\";s:9:\"Argentina\";s:7:\"Armenia\";s:7:\"Armenia\";s:5:\"Aruba\";s:5:\"Aruba\";s:9:\"Australia\";s:9:\"Australia\";s:7:\"Austria\";s:7:\"Austria\";s:10:\"Azerbaijan\";s:11:\"Acerbaixán\";s:7:\"Bahamas\";s:7:\"Bahamas\";s:7:\"Bahrain\";s:7:\"Bahrein\";s:10:\"Bangladesh\";s:10:\"Bangladesh\";s:8:\"Barbados\";s:8:\"Barbados\";s:7:\"Belarus\";s:11:\"Bielorrusia\";s:7:\"Belgium\";s:8:\"Bélxica\";s:6:\"Belize\";s:6:\"Belice\";s:5:\"Benin\";s:5:\"Benin\";s:7:\"Bermuda\";s:7:\"Bermuda\";s:6:\"Bhutan\";s:6:\"Bután\";s:7:\"Bolivia\";s:7:\"Bolivia\";s:22:\"Bosnia and Herzegovina\";s:20:\"Bosnia e Herzegovina\";s:8:\"Botswana\";s:8:\"Botswana\";s:13:\"Bouvet Island\";s:11:\"Illa Bouvet\";s:6:\"Brunei\";s:6:\"Brunei\";s:8:\"Bulgaria\";s:8:\"Bulgaria\";s:12:\"Burkina Faso\";s:12:\"Burkina Faso\";s:7:\"Burundi\";s:7:\"Burundi\";s:8:\"Cambodia\";s:7:\"Camboxa\";s:8:\"Cameroon\";s:8:\"Camerún\";s:6:\"Canada\";s:7:\"Canadá\";s:10:\"Cape Verde\";s:10:\"Cabo Verde\";s:14:\"Cayman Islands\";s:13:\"Illas Caimán\";s:24:\"Central African Republic\";s:25:\"República Centroafricana\";s:4:\"Chad\";s:4:\"Chad\";s:5:\"China\";s:5:\"China\";s:16:\"Christmas Island\";s:13:\"Illa de Nadal\";s:23:\"Cocos (Keeling) Islands\";s:21:\"Illas Cocos (Keeling)\";s:8:\"Colombia\";s:8:\"Colombia\";s:7:\"Comoros\";s:7:\"Comores\";s:12:\"Cook Islands\";s:10:\"Illas Cook\";s:10:\"Costa Rica\";s:10:\"Costa Rica\";s:6:\"Cyprus\";s:6:\"Chipre\";s:14:\"Czech Republic\";s:16:\"República Checa\";s:7:\"Denmark\";s:9:\"Dinamarca\";s:8:\"Djibouti\";s:7:\"Xibutí\";s:8:\"Dominica\";s:8:\"Dominica\";s:18:\"Dominican Republic\";s:21:\"República Dominicana\";s:7:\"Ecuador\";s:7:\"Ecuador\";s:11:\"El Salvador\";s:11:\"El Salvador\";s:17:\"Equatorial Guinea\";s:17:\"Guinea Ecuatorial\";s:7:\"Eritrea\";s:7:\"Eritrea\";s:7:\"Estonia\";s:7:\"Estonia\";s:8:\"Ethiopia\";s:8:\"Etiopía\";s:13:\"Faroe Islands\";s:11:\"Illas Feroe\";s:7:\"Finland\";s:9:\"Finlandia\";s:6:\"France\";s:7:\"Francia\";s:13:\"French Guiana\";s:16:\"Güiana Francesa\";s:16:\"French Polynesia\";s:18:\"Polinesia Francesa\";s:5:\"Gabon\";s:6:\"Gabón\";s:6:\"Gambia\";s:6:\"Gambia\";s:7:\"Georgia\";s:7:\"Georgia\";s:5:\"Ghana\";s:5:\"Ghana\";s:9:\"Gibraltar\";s:9:\"Gibraltar\";s:6:\"Greece\";s:6:\"Grecia\";s:9:\"Greenland\";s:11:\"Groenlandia\";s:7:\"Grenada\";s:7:\"Granada\";s:10:\"Guadeloupe\";s:9:\"Guadalupe\";s:4:\"Guam\";s:4:\"Guam\";s:9:\"Guatemala\";s:9:\"Guatemala\";s:6:\"Guinea\";s:6:\"Guinea\";s:13:\"Guinea-Bissau\";s:13:\"Guinea-Bissau\";s:6:\"Guyana\";s:7:\"Güiana\";s:5:\"Haiti\";s:6:\"Haití\";s:33:\"Heard Island and McDonald Islands\";s:22:\"Illas Heard e McDonald\";s:7:\"Hungary\";s:8:\"Hungría\";s:7:\"Iceland\";s:8:\"Islandia\";s:5:\"India\";s:5:\"India\";s:9:\"Indonesia\";s:9:\"Indonesia\";s:4:\"Iraq\";s:4:\"Irak\";s:7:\"Ireland\";s:7:\"Irlanda\";s:5:\"Italy\";s:6:\"Italia\";s:6:\"Jordan\";s:8:\"Jordania\";s:10:\"Kazakhstan\";s:12:\"Casaquistán\";s:5:\"Kenya\";s:6:\"Quenia\";s:8:\"Kiribati\";s:9:\"Quiribati\";s:6:\"Kuwait\";s:6:\"Kuwait\";s:10:\"Kyrgyzstan\";s:13:\"Kirguizistán\";s:4:\"Laos\";s:4:\"Laos\";s:6:\"Latvia\";s:7:\"Letonia\";s:7:\"Lebanon\";s:7:\"Líbano\";s:7:\"Lesotho\";s:6:\"Lesoto\";s:7:\"Liberia\";s:7:\"Liberia\";s:13:\"Liechtenstein\";s:13:\"Liechtenstein\";s:9:\"Lithuania\";s:8:\"Lituania\";s:10:\"Luxembourg\";s:10:\"Luxemburgo\";s:10:\"Madagascar\";s:10:\"Madagascar\";s:6:\"Malawi\";s:6:\"Malaui\";s:8:\"Malaysia\";s:8:\"Malaisia\";s:8:\"Maldives\";s:8:\"Maldivas\";s:4:\"Mali\";s:4:\"Mali\";s:5:\"Malta\";s:5:\"Malta\";s:16:\"Marshall Islands\";s:14:\"Illas Marshall\";s:10:\"Martinique\";s:10:\"Martinique\";s:10:\"Mauritania\";s:10:\"Mauritania\";s:9:\"Mauritius\";s:8:\"Mauricio\";s:7:\"Mayotte\";s:7:\"Mayotte\";s:6:\"Mexico\";s:7:\"México\";s:10:\"Micronesia\";s:10:\"Micronesia\";s:7:\"Moldova\";s:8:\"Moldavia\";s:6:\"Monaco\";s:7:\"Mónaco\";s:8:\"Mongolia\";s:8:\"Mongolia\";s:10:\"Montserrat\";s:10:\"Montserrat\";s:7:\"Morocco\";s:8:\"Marrocos\";s:10:\"Mozambique\";s:10:\"Mozambique\";s:7:\"Myanmar\";s:8:\"Birmania\";s:5:\"Nepal\";s:5:\"Nepal\";s:11:\"Netherlands\";s:7:\"Holanda\";s:20:\"Netherlands Antilles\";s:19:\"Antillas Holandesas\";s:13:\"New Caledonia\";s:14:\"Nova Caledonia\";s:9:\"Nicaragua\";s:9:\"Nicaragua\";s:5:\"Niger\";s:5:\"Niger\";s:7:\"Nigeria\";s:7:\"Nigeria\";s:4:\"Niue\";s:4:\"Niue\";s:14:\"Norfolk Island\";s:12:\"Illa Norfolk\";s:11:\"North Korea\";s:14:\"Corea do Norte\";s:24:\"Northern Mariana Islands\";s:23:\"Illas Marianas do Norte\";s:6:\"Norway\";s:7:\"Noruega\";s:4:\"Oman\";s:4:\"Oman\";s:8:\"Pakistan\";s:8:\"Pakistan\";s:5:\"Palau\";s:5:\"Palau\";s:6:\"Panama\";s:7:\"Panamá\";s:16:\"Papua New Guinea\";s:18:\"Papúa Nova Guinea\";s:4:\"Peru\";s:5:\"Perú\";s:11:\"Philippines\";s:9:\"Filipinas\";s:11:\"Puerto Rico\";s:10:\"Porto Rico\";s:5:\"Qatar\";s:5:\"Qatar\";s:7:\"Reunion\";s:8:\"Reunión\";s:7:\"Romania\";s:8:\"Romanía\";s:6:\"Russia\";s:5:\"Rusia\";s:6:\"Rwanda\";s:6:\"Ruanda\";s:5:\"Samoa\";s:5:\"Samoa\";s:10:\"San Marino\";s:10:\"San Marino\";s:12:\"Saudi Arabia\";s:14:\"Arabia Saudita\";s:7:\"Senegal\";s:7:\"Senegal\";s:10:\"Seychelles\";s:8:\"Seixeles\";s:12:\"Sierra Leone\";s:10:\"Serra Leoa\";s:8:\"Slovakia\";s:10:\"Eslovaquia\";s:8:\"Slovenia\";s:9:\"Eslovenia\";s:15:\"Solomon Islands\";s:14:\"Illas Salomón\";s:7:\"Somalia\";s:7:\"Somalia\";s:12:\"South Africa\";s:14:\"África do Sur\";s:44:\"South Georgia and the South Sandwich Islands\";s:38:\"Xeorxia do Sur e Illas Sandwich do Sur\";s:5:\"Spain\";s:7:\"España\";s:9:\"Sri Lanka\";s:9:\"Sri Lanka\";s:5:\"Sudan\";s:6:\"Sudán\";s:8:\"Suriname\";s:7:\"Surinam\";s:22:\"Svalbard and Jan Mayen\";s:20:\"Svalbard e Jan Mayen\";s:9:\"Swaziland\";s:11:\"Suacilandia\";s:6:\"Sweden\";s:6:\"Suecia\";s:11:\"Switzerland\";s:6:\"Suíza\";s:5:\"Syria\";s:5:\"Siria\";s:6:\"Taiwan\";s:7:\"Taiwán\";s:10:\"Tajikistan\";s:12:\"Taxiquistán\";s:8:\"Tanzania\";s:8:\"Tanzania\";s:8:\"Thailand\";s:9:\"Tailandia\";s:4:\"Togo\";s:4:\"Togo\";s:7:\"Tokelau\";s:7:\"Tokelau\";s:19:\"Trinidad and Tobago\";s:17:\"Trindade e Tobago\";s:7:\"Tunisia\";s:7:\"Tunisia\";s:12:\"Turkmenistan\";s:14:\"Turcomenistán\";s:24:\"Turks and Caicos Islands\";s:21:\"Illas Turcas e Caicos\";s:6:\"Tuvalu\";s:6:\"Tuvalu\";s:6:\"Uganda\";s:6:\"Uganda\";s:7:\"Ukraine\";s:8:\"Ucraína\";s:20:\"United Arab Emirates\";s:23:\"Emiratos Árabes Unidos\";s:14:\"United Kingdom\";s:11:\"Reino Unido\";s:13:\"United States\";s:14:\"Estados Unidos\";s:36:\"United States Minor Outlying Islands\";s:36:\"Illas Ultramarinas de Estados Unidos\";s:7:\"Uruguay\";s:7:\"Uruguai\";s:10:\"Uzbekistan\";s:12:\"Usbequistán\";s:7:\"Vanuatu\";s:7:\"Vanuatu\";s:9:\"Venezuela\";s:9:\"Venezuela\";s:17:\"Wallis and Futuna\";s:15:\"Wallis e Futuna\";s:5:\"Yemen\";s:5:\"Iemen\";s:6:\"Zambia\";s:6:\"Zambia\";s:8:\"Zimbabwe\";s:8:\"Zimbabue\";s:17:\"Size of textfield\";s:25:\"Tamaño do campo de texto\";s:21:\"Authoring information\";s:21:\"Información do autor\";s:11:\"Authored on\";s:9:\"Creado en\";s:27:\"Leave blank for %anonymous.\";s:34:\"Déixeo en branco para %anonymous.\";s:17:\"Allowed HTML tags\";s:25:\"Etiquetas HTML permitidas\";s:7:\"Sources\";s:6:\"Fontes\";s:30:\"The update has been performed.\";s:28:\"Realizouse a actualización.\";s:18:\"View user profile.\";s:26:\"Ver o perfil de usuario/a.\";s:14:\"Upload picture\";s:12:\"Cargar imaxe\";s:28:\"The changes have been saved.\";s:23:\"Gardáronse os cambios.\";s:21:\"Show only users where\";s:25:\"Mostrar só usuarios onde\";s:6:\"Refine\";s:7:\"Refinar\";s:4:\"Undo\";s:8:\"Desfacer\";s:10:\"Member for\";s:14:\"Membro durante\";s:9:\"@time ago\";s:9:\"fai @time\";s:10:\"Front page\";s:17:\"Páxina de inicio\";s:19:\"Allowed values list\";s:27:\"Lista de valores permitidos\";s:9:\"Edit menu\";s:11:\"Editar menu\";s:14:\"Minimum height\";s:14:\"Altura mínima\";s:13:\"Minimum width\";s:15:\"Anchura mínima\";s:15:\"Configure block\";s:19:\"Configurar o bloque\";s:3:\"Jan\";s:3:\"Xan\";s:3:\"Feb\";s:3:\"Feb\";s:3:\"Apr\";s:3:\"Abr\";s:3:\"Jun\";s:4:\"Xuñ\";s:3:\"Jul\";s:3:\"Xul\";s:3:\"Aug\";s:3:\"Ago\";s:3:\"Sep\";s:3:\"Set\";s:3:\"Oct\";s:3:\"Out\";s:3:\"Nov\";s:3:\"Nov\";s:3:\"Dec\";s:3:\"Dec\";s:20:\"Existing system path\";s:25:\"Ruta existente no sistema\";s:10:\"Path alias\";s:13:\"Alias de ruta\";s:10:\"characters\";s:10:\"caracteres\";s:18:\"Create new account\";s:16:\"Crear nova conta\";s:4:\"role\";s:3:\"rol\";s:10:\"list terms\";s:15:\"lista de termos\";s:9:\"add terms\";s:14:\"engadir termos\";s:23:\"Created new term %term.\";s:27:\"Creouse o novo termo %term.\";s:48:\"Are you sure you want to delete the term %title?\";s:50:\"Está seguro de que quere eliminar o termo %title?\";s:19:\"Deleted term %name.\";s:20:\"Termo %term borrado.\";s:7:\"warning\";s:11:\"advertencia\";s:7:\"Blocked\";s:9:\"Bloqueado\";s:15:\"Enabled filters\";s:15:\"Filtros activos\";s:8:\"critical\";s:8:\"crítico\";s:7:\"Results\";s:10:\"Resultados\";s:4:\"open\";s:6:\"aberta\";s:12:\"Parent terms\";s:11:\"Termos pais\";s:20:\"Revisions for %title\";s:22:\"Revisións para %title\";s:18:\"!date by !username\";s:19:\"!date por !username\";s:6:\"revert\";s:6:\"volver\";s:16:\"current revision\";s:16:\"revisión actual\";s:30:\"Your settings have been saved.\";s:26:\"Os axustes foron gardados.\";s:10:\"permission\";s:7:\"permiso\";s:13:\"Aland Islands\";s:11:\"Illas Aland\";s:16:\"Falkland Islands\";s:13:\"Illa Malvinas\";s:21:\"Saint Kitts and Nevis\";s:20:\"San Cristovo e Nevis\";s:11:\"South Korea\";s:12:\"Corea do Sur\";s:11:\"Saint Lucia\";s:12:\"Santa Lucía\";s:12:\"Saint Helena\";s:12:\"Santa Helena\";s:21:\"Sao Tome and Principe\";s:21:\"San Tomé e Príncipe\";s:27:\"French Southern Territories\";s:28:\"Territorios Franceses do Sur\";s:32:\"Saint Vincent and the Grenadines\";s:24:\"San Vicente e Granadinas\";s:22:\"British Virgin Islands\";s:24:\"Illas Virxes Británicas\";s:19:\"U.S. Virgin Islands\";s:31:\"Illas Virxes dos Estados Unidos\";s:7:\"Vietnam\";s:7:\"Vietnam\";s:8:\"Guernsey\";s:8:\"Guernsey\";s:6:\"Jersey\";s:6:\"Xersei\";s:14:\"%type settings\";s:16:\"Axustes de %type\";s:23:\"Allowed file extensions\";s:33:\"Extensións de arquivo permitidas\";s:12:\"New comments\";s:17:\"Novos comentarios\";s:8:\"Top left\";s:18:\"Arriba á esquerda\";s:9:\"Top right\";s:17:\"Arriba á dereita\";s:12:\"Bottom right\";s:17:\"Abaixo á dereita\";s:11:\"Bottom left\";s:18:\"Abaixo á esquerda\";s:6:\"Themes\";s:5:\"Temas\";s:24:\"!name field is required.\";s:27:\"O campo !name é necesario.\";s:7:\"disable\";s:10:\"desactivar\";s:4:\"date\";s:4:\"data\";s:8:\"Timezone\";s:12:\"Fuso horario\";s:18:\"Password strength:\";s:25:\"Fortaleza do contrasinal:\";s:16:\"Passwords match:\";s:26:\"Os contrasinais coinciden:\";s:14:\"Alternate text\";s:17:\"Texto alternativo\";s:39:\"Enter the terms you wish to search for.\";s:38:\"Introduza os termos que queira buscar.\";s:30:\"British Indian Ocean Territory\";s:40:\"Territorio Británico do Océano Índico\";s:7:\"Croatia\";s:7:\"Croacia\";s:9:\"Macedonia\";s:9:\"Macedonia\";s:8:\"Pitcairn\";s:8:\"Pitcairn\";s:14:\"Western Sahara\";s:18:\"Sáhara Occidental\";s:17:\"Block description\";s:21:\"Descrición do bloque\";s:11:\"Save blocks\";s:17:\"Gardar os bloques\";s:37:\"The block settings have been updated.\";s:40:\"Actualizouse a configuración do bloque.\";s:13:\"\'%name\' block\";s:14:\"bloque \'%name\'\";s:29:\"Show block for specific roles\";s:36:\"Amosar o bloque a roles específicos\";s:28:\"Show block on specific pages\";s:40:\"Amosar o bloque en páxinas específicas\";s:10:\"Save block\";s:15:\"Gardar o bloque\";s:39:\"The block configuration has been saved.\";s:36:\"Gardouse a configuración do bloque.\";s:27:\"The block has been created.\";s:17:\"Creouse o bloque.\";s:10:\"Block body\";s:15:\"Corpo do bloque\";s:46:\"The content of the block as shown to the user.\";s:50:\"O contido do bloque como se mostra ao/a usuario/a.\";s:15:\"edit vocabulary\";s:18:\"editar vocabulario\";s:29:\"Created new vocabulary %name.\";s:33:\"Creado un novo vocabulario %name.\";s:25:\"Updated vocabulary %name.\";s:32:\"Actualizado o vocabulario %name.\";s:54:\"Are you sure you want to delete the vocabulary %title?\";s:56:\"Está seguro de que quere eliminar o vocabulario %title?\";s:25:\"Deleted vocabulary %name.\";s:28:\"Borrado o vocabulario %name.\";s:5:\"Above\";s:6:\"Enriba\";s:16:\"Number of values\";s:18:\"Número de valores\";s:16:\"Add another item\";s:22:\"Engadir outro elemento\";s:18:\"Add existing field\";s:27:\"Engadir un campos existente\";s:19:\"Save field settings\";s:26:\"Gardar os axustes do campo\";s:7:\"Minimum\";s:7:\"Mínimo\";s:14:\"@module module\";s:15:\"módulo @module\";s:16:\"More information\";s:18:\"Máis información\";s:70:\"Your signature will be publicly displayed at the end of your comments.\";s:64:\"A sinatura amosarase publicamente ao final dos seus comentarios.\";s:13:\"Language code\";s:17:\"Código do idioma\";s:5:\"debug\";s:11:\"depuración\";s:15:\"Menu link title\";s:28:\"Título da ligazón do menú\";s:72:\"The path \'@link_path\' is either invalid or you do not have access to it.\";s:69:\"A ruta \'@link_path\' non é unha ruta válida ou non ten acceso a ela.\";s:9:\"Menu name\";s:13:\"Nome do menú\";s:8:\"Profiles\";s:8:\"Perfiles\";s:17:\"URL path settings\";s:19:\"Axustes de ruta URL\";s:19:\"Maximum upload size\";s:25:\"Tamaño máximo de subida\";s:2:\"KB\";s:2:\"KB\";s:14:\"Page not found\";s:19:\"Páxina non atopada\";s:15:\"Account blocked\";s:15:\"Conta bloqueada\";s:4:\"info\";s:12:\"información\";s:9:\"edit menu\";s:12:\"editar menú\";s:22:\"No comments available.\";s:33:\"Non hai comentarios dispoñibles.\";s:2:\"ok\";s:8:\"correcto\";s:8:\"Add role\";s:11:\"Engadir rol\";s:19:\"Path to custom logo\";s:30:\"Ruta ao logotipo personalizado\";s:19:\"Updated term %term.\";s:24:\"Termo %term actualizado.\";s:6:\"Parser\";s:11:\"Intérprete\";s:5:\"Alias\";s:5:\"Alias\";s:21:\"Palestinian Territory\";s:20:\"Territorio Palestino\";s:7:\"Vatican\";s:18:\"Cidade do Vaticano\";s:15:\"Allow Upscaling\";s:21:\"Permitir ampliacións\";s:53:\"Let scale make images larger than their original size\";s:75:\"Permitir que a escala faga as imaxes máis grandes co seu tamaño orixinal.\";s:7:\"Account\";s:5:\"Conta\";s:18:\"authenticated user\";s:19:\"usuario autenticado\";s:3:\"Any\";s:8:\"Calquera\";s:53:\"E-mail addresses to notify when updates are available\";s:91:\"Enderezo de correo electrónico ao que se avisará cando haxa actualizacións dispoñíbeis\";s:18:\"All newer versions\";s:23:\"Todas as versión novas\";s:21:\"Only security updates\";s:33:\"Só actualizacións de seguridade\";s:11:\"Not secure!\";s:9:\"Inseguro!\";s:28:\"(version @version available)\";s:31:\"(version @version dispoñíbel)\";s:52:\"See the available updates page for more information:\";s:81:\"Pode ver a páxina de actualizacións dispoñibles para obter máis información:\";s:39:\"New release(s) available for !site_name\";s:50:\"Nova(s) versión(s) dispoñible(s) para !site_name\";s:27:\"No available releases found\";s:43:\"Non hai liberacións dispoñíbeis atopadas\";s:20:\"Recommended version:\";s:21:\"Versión recomendada:\";s:15:\"Latest version:\";s:17:\"Última versión:\";s:15:\"Also available:\";s:20:\"Tamén dispoñíbel:\";s:6:\"@title\";s:6:\"@title\";s:13:\"Add new field\";s:18:\"Engadir novo campo\";s:27:\"Containing any of the words\";s:30:\"Contendo calquera das palabras\";s:21:\"Containing the phrase\";s:20:\"Que conteña a frase\";s:28:\"Containing none of the words\";s:38:\"Que non conteña ningunha das palabras\";s:15:\"Content ranking\";s:18:\"Ranking de contido\";s:17:\"Keyword relevance\";s:19:\"Relevancia da clave\";s:15:\"Recently posted\";s:20:\"Enviado recentemente\";s:18:\"Number of comments\";s:22:\"Número de comentarios\";s:6:\"Factor\";s:6:\"Factor\";s:2:\"Or\";s:2:\"Ou\";s:24:\"Maximum link text length\";s:36:\"Lonxitude máxima do texto do enlace\";s:14:\"Toggle display\";s:24:\"Cambiar a visualización\";s:41:\"%percentage of the site has been indexed.\";s:33:\"Indexouse o %percentage do sitio.\";s:14:\"File directory\";s:22:\"Directorio de arquivos\";s:13:\"Default theme\";s:19:\"Tema predeterminado\";s:10:\"- Select -\";s:14:\"- Seleccione -\";s:22:\"Up to date translation\";s:22:\"Tradución actualizada\";s:20:\"Outdated translation\";s:20:\"Traducción atrasada\";s:30:\"@type %title has been deleted.\";s:27:\"O @type %title foi borrado.\";s:14:\"anonymous user\";s:20:\"usuario/a anónimo/a\";s:16:\"Save permissions\";s:15:\"Gardar permisos\";s:6:\"Effect\";s:6:\"Efecto\";s:16:\"edit permissions\";s:15:\"editar permisos\";s:17:\"Installed version\";s:18:\"Versión instalada\";s:19:\"Recommended version\";s:20:\"Versión recomendada\";s:6:\"notice\";s:5:\"aviso\";s:6:\"pixels\";s:8:\"píxeles\";s:10:\"Save order\";s:13:\"Gardar pedido\";s:4:\"done\";s:5:\"feito\";s:9:\"edit role\";s:10:\"editar rol\";s:9:\"Relations\";s:10:\"Relacións\";s:16:\"Confirm password\";s:23:\"Confirmar o contrasinal\";s:20:\"Administration theme\";s:23:\"Tema de administración\";s:16:\"Congo (Kinshasa)\";s:16:\"Congo (Kinshasa)\";s:19:\"Congo (Brazzaville)\";s:19:\"Congo (Brazzaville)\";s:11:\"Ivory Coast\";s:15:\"Costa de Marfil\";s:23:\"Hong Kong S.A.R., China\";s:23:\"R.A.E. Hong Kong, China\";s:11:\"Isle of Man\";s:11:\"Illa de Man\";s:10:\"Montenegro\";s:10:\"Montenegro\";s:19:\"Macao S.A.R., China\";s:22:\"R.A.E. de Macau, China\";s:25:\"Saint Pierre and Miquelon\";s:21:\"San Pedro e Miguelón\";s:6:\"Serbia\";s:6:\"Serbia\";s:8:\"Run cron\";s:13:\"Executar cron\";s:47:\"The specified file %name could not be uploaded.\";s:47:\"O arquivo especificado %name non puido subirse.\";s:69:\"Only files with the following extensions are allowed: %files-allowed.\";s:77:\"So están permitidos os ficheiros coas seguintes extensións: %files-allowed.\";s:7:\"New set\";s:13:\"Conxunto novo\";s:13:\"Re-index site\";s:24:\"Volver a indexar o sitio\";s:14:\"Maximum height\";s:14:\"Altura máxima\";s:13:\"Maximum width\";s:15:\"Anchura máxima\";s:11:\"Timor-Leste\";s:11:\"Timor-Leste\";s:14:\"Secondary tabs\";s:20:\"Pestanas secundarias\";s:55:\"Enable or disable the display of certain page elements.\";s:70:\"Activar ou desactivar a visualización de certos elementos da páxina.\";s:24:\"Maximum image resolution\";s:28:\"Máxima resolución da imaxe\";s:12:\"Not writable\";s:20:\"Non se pode escribir\";s:20:\"Revision information\";s:25:\"Información da revisión\";s:26:\"Notify user of new account\";s:39:\"Notificar ao/á usuario/a da nova conta\";s:5:\"Comma\";s:4:\"Coma\";s:19:\"Path to custom icon\";s:27:\"Ruta á icona personalizada\";s:31:\"Unpublish the selected comments\";s:36:\"Retirar os comentarios seleccionados\";s:13:\"Default image\";s:17:\"Imaxe predifinida\";s:10:\"List links\";s:15:\"Mostrar enlaces\";s:23:\"Enter your @s username.\";s:35:\"Insira o seu nome de usuario en @s.\";s:9:\"Posted in\";s:10:\"Enviado en\";s:15:\"Filter settings\";s:17:\"Axustes do filtro\";s:3:\"FTP\";s:3:\"FTP\";s:68:\"The website encountered an unexpected error. Please try again later.\";s:81:\"O sitio web atopou un erro inesperado.\r\nPor favor, inténteo de novo máis tarde.\";s:8:\"Add link\";s:14:\"Engadir enlace\";s:17:\"User autocomplete\";s:25:\"Autocompletado de usuario\";s:40:\"The content type %name has been updated.\";s:37:\"Actualizouse o tipo de contido %name.\";s:5:\"alert\";s:6:\"alerta\";s:9:\"emergency\";s:10:\"emerxencia\";s:19:\"Filter log messages\";s:28:\"Filtrar mensaxes do rexistro\";s:54:\"Provide a password for the new account in both fields.\";s:61:\"Proporcione un contrasinal para a nova conta en ambos campos.\";s:17:\"Language settings\";s:18:\"Opcións de idioma\";s:8:\"Visitors\";s:10:\"Visitantes\";s:46:\"The maximum length of the field in characters.\";s:44:\"A lonxitude máxima do campo en carácteres.\";s:13:\"Edit language\";s:13:\"Editar idioma\";s:10:\"list links\";s:15:\"mostrar enlaces\";s:38:\"The content type %name has been added.\";s:34:\"Engadiuse o tipo de contido %name.\";s:13:\"Right to left\";s:21:\"De dereita a esquerda\";s:13:\"Save language\";s:15:\"Gardar o idioma\";s:24:\"Language name in English\";s:25:\"Nome do idioma en inglés\";s:20:\"Native language name\";s:21:\"Nome nativo do idioma\";s:49:\"Name of the language in the language being added.\";s:34:\"Engadiuse o nome nativo do idioma.\";s:15:\"Language domain\";s:17:\"Dominio do idioma\";s:50:\"Direction that text in this language is presented.\";s:51:\"Dirección na que se presenta o texto neste idioma.\";s:41:\"Language negotiation configuration saved.\";s:52:\"Gardouse a configuración da negociación de idioma.\";s:26:\"The string has been saved.\";s:17:\"Gardouse a cadea.\";s:63:\"Updated JavaScript translation file for the language %language.\";s:73:\"Actualizouse o ficheiro de tradución JavaScript para o idioma %language.\";s:15:\"sort descending\";s:20:\"arranxar descendente\";s:57:\"Server error. Requested method @methodname not specified.\";s:67:\"Erro do servidor.  Método solicitado @methodname non especificado.\";s:24:\"No blocks in this region\";s:29:\"Non hai bloques nesta rexión\";s:28:\"Delete the selected comments\";s:35:\"Borrar os comentarios seleccionados\";s:6:\"Strong\";s:5:\"Forte\";s:9:\"Ampersand\";s:9:\"Ampersand\";s:41:\"Lines and paragraphs break automatically.\";s:42:\"Saltos de liña e parágrafo automáticos.\";s:70:\"Web page addresses and e-mail addresses turn into links automatically.\";s:100:\"Os enderezos de páxinas web e os de correo electrónico son convertidos automaticamente en enlaces.\";s:44:\"This account\'s default language for e-mails.\";s:48:\"A lingua predifinida da conta para os correos-e.\";s:25:\"The alias has been saved.\";s:17:\"Gardouse o alias.\";s:14:\"Filter aliases\";s:13:\"Filtrar alias\";s:10:\"Edit alias\";s:14:\"Editar o alias\";s:49:\"Are you sure you want to delete the field %field?\";s:48:\"Está seguro de que quere borrar o campo %field?\";s:15:\"Indexing status\";s:21:\"Estado de indexación\";s:17:\"Indexing throttle\";s:26:\"Regulación da indexación\";s:37:\"Number of items to index per cron run\";s:64:\"Número de elementos que se indexan cada vez que se executa cron\";s:17:\"Indexing settings\";s:23:\"Opcións de indexación\";s:28:\"Minimum word length to index\";s:38:\"Lonxitude mínima da palabra a indexar\";s:19:\"Simple CJK handling\";s:23:\"Xestión sinxela de CJK\";s:22:\"User pictures in posts\";s:34:\"Imaxe do usuario nas suas entradas\";s:25:\"User pictures in comments\";s:37:\"Imaxes do/a usuario/a nos comentarios\";s:13:\"Shortcut icon\";s:23:\"Icona de acceso rápido\";s:19:\"Logo image settings\";s:35:\"Configuración da imaxe do logotipo\";s:52:\"If toggled on, the following logo will be displayed.\";s:45:\"Se se activa, mostrarase o seguinte logotipo.\";s:20:\"Use the default logo\";s:27:\"Usar o logotipo predefinido\";s:66:\"Check here if you want the theme to use the logo supplied with it.\";s:66:\"Marca esta casilla se queres que o tema use o seu propio logotipo.\";s:56:\"You must enable the @required module to install @module.\";b:1;s:17:\"Upload logo image\";s:26:\"Cargar a imaxe de logotipo\";s:22:\"Shortcut icon settings\";s:36:\"Opcións de iconas de acceso rápido\";s:30:\"Use the default shortcut icon.\";s:43:\"Usar a icona de acceso rápido predefinida.\";s:66:\"Check here if you want the theme to use the default shortcut icon.\";s:80:\"Marque aquí se quere que o tema empregue a icona de acceso rápido predefinido.\";s:17:\"Upload icon image\";s:20:\"Subir imaxe da icona\";s:17:\"Confirm uninstall\";s:25:\"Confirmar desinstalación\";s:55:\"Would you like to continue with uninstalling the above?\";s:42:\"¿Quere continuar desintalando o seguinte?\";s:43:\"The selected modules have been uninstalled.\";s:46:\"Os módulos seleccionados foron desinstalados.\";s:15:\"Caches cleared.\";s:25:\"As caches foron limpadas.\";s:22:\"Cron ran successfully.\";s:30:\"Cron executouse correctamente.\";s:38:\"No modules are available to uninstall.\";s:47:\"Non hai módulos dispoñibles para desinstalar.\";s:20:\"Date and time lookup\";s:22:\"Procura de data e hora\";s:41:\"The directory %directory is not writable.\";s:44:\"Non se pode escribir no cartafol %directory.\";s:21:\"Reset to alphabetical\";s:23:\"Restaurar a alfabético\";s:49:\"Terms are displayed in ascending order by weight.\";s:54:\"Os termos móstranse en orde ascendente polo seu peso.\";s:20:\"Translation settings\";s:28:\"Configuración de tradución\";s:29:\"Flag translations as outdated\";s:37:\"Marcar as traduccións como atrasadas\";s:36:\"This translation needs to be updated\";s:36:\"Esta tradución precisa ser revisada\";s:19:\"Content translation\";s:22:\"Traducción do Contido\";s:23:\"Last checked: @time ago\";s:32:\"Última comprobación: fai @time\";s:19:\"Includes: %includes\";s:18:\"Inclúe: %includes\";s:16:\"Disabled modules\";s:21:\"Módulos desactivados\";s:15:\"Disabled themes\";s:18:\"Temas desactivados\";s:29:\"E-mail notification threshold\";s:35:\"Umbral da notificación de correo-e\";s:50:\"Enter the password that accompanies your username.\";s:54:\"Escriba o contrasinal asignado ao seu nome de usuario.\";s:18:\"Signature settings\";s:21:\"Axustes das sinaturas\";s:14:\"Delete picture\";s:14:\"Borrar a imaxe\";s:46:\"Check this box to delete your current picture.\";s:52:\"Marque esta caixa para eliminar a súa imaxe actual.\";s:26:\"Unblock the selected users\";s:36:\"Desbloquear os usuarios selecionados\";s:24:\"Block the selected users\";s:34:\"Bloquear os usuarios seleccionados\";s:18:\"Progress indicator\";s:21:\"Indicador de progreso\";s:23:\"Bar with progress meter\";s:30:\"Barra co indicador de progreso\";s:8:\"Throbber\";s:8:\"Pulsador\";s:8:\"@size KB\";s:8:\"@size KB\";s:8:\"@size MB\";s:8:\"@size MB\";s:8:\"@size GB\";s:8:\"@size GB\";s:8:\"@size TB\";s:8:\"@size TB\";s:8:\"@size PB\";s:8:\"@size PB\";s:8:\"@size EB\";s:8:\"@size EB\";s:8:\"@size ZB\";s:8:\"@size ZB\";s:8:\"@size YB\";s:8:\"@size YB\";s:12:\"All messages\";s:17:\"Todas as mensaxes\";s:7:\"(empty)\";s:9:\"(valeiro)\";s:15:\"Region settings\";s:19:\"Opcións de rexión\";s:10:\"Top center\";s:15:\"Arriba centrado\";s:13:\"Bottom center\";s:15:\"Abaixo centrado\";s:13:\"Format string\";s:16:\"Cadea de formato\";s:23:\"- Select a field type -\";s:31:\"- Selecciona un tipo de campo -\";s:19:\"- Select a widget -\";s:25:\"- Seleccionar un widget -\";s:22:\"Type of data to store.\";s:33:\"Tipo de información a almacenar.\";s:30:\"Form element to edit the data.\";s:44:\"Elemento de formulario para editar os datos.\";s:28:\"- Select an existing field -\";s:33:\"- Selecciona un campo existente -\";s:14:\"Field to share\";s:20:\"Campo para compartir\";s:22:\"@type: @field (@label)\";s:22:\"@type: @field (@label)\";s:56:\"Maximum number of values users can enter for this field.\";s:71:\"Número máximo de valores que os usuario poden introducir neste campo.\";s:12:\"width @width\";s:12:\"largo @width\";s:14:\"height @height\";s:12:\"alto @height\";s:17:\"upscaling allowed\";s:23:\"permitense ampliacións\";s:17:\"Translate content\";s:16:\"Traducir contido\";s:10:\"Edit style\";s:13:\"Editar estilo\";s:7:\"Fetcher\";s:8:\"Colector\";s:14:\"Cancel account\";s:14:\"Cancelar conta\";s:14:\"Secondary menu\";s:16:\"Menú secundario\";s:18:\"Administrator role\";s:22:\"Papel de administrador\";s:24:\"Site maintenance account\";s:28:\"Conta de mantemento do sitio\";s:19:\"No pending updates.\";s:34:\"Non hai actualizacións pendentes.\";s:16:\"No active batch.\";s:15:\"Lote non activo\";s:22:\"Site under maintenance\";s:18:\"Modo de mantemento\";s:17:\"Saint Barthélemy\";s:14:\"San Bartolomé\";s:26:\"Saint Martin (French part)\";s:29:\"San Martiño (parte francesa)\";s:60:\"Operating in maintenance mode. <a href=\"@url\">Go online.</a>\";s:67:\"Operando en modo de mantemento. <a href=\"@url\">Voltar en liña.</a>\";s:23:\"%module module enabled.\";s:25:\"módulo %module activado.\";s:49:\"Refreshed @count strings for the enabled modules.\";b:1;s:60:\"Specify in which themes and regions this block is displayed.\";s:59:\"Especificar en qué temas e rexións se mostra este bloque.\";s:21:\"Customizable per user\";s:26:\"Personalizable por usuario\";s:16:\"Not customizable\";s:18:\"Non personalizable\";s:32:\"Customizable, visible by default\";s:35:\"Personalizable, visible por defecto\";s:31:\"Customizable, hidden by default\";s:34:\"Personalizable, oculto por defecto\";s:60:\"Users with the \"Post comments\" permission can post comments.\";s:59:\"Os usuarios co permiso \"Enviar comentarios\" poden comentar.\";s:68:\"Users cannot post comments, but existing comments will be displayed.\";s:75:\"Os usuarios non poden comentar pero se amosarán os comentarios existentes.\";s:30:\"Comments are hidden from view.\";s:39:\"Os comentarios están ocultos á vista.\";s:27:\"Users cannot post comments.\";s:43:\"Os usuarios non poden publicar comentarios.\";s:9:\"DRAG HERE\";s:15:\"ARRASTRAR AQUÍ\";s:18:\"Clear log messages\";s:30:\"Borrar as mensaxes do rexistro\";s:64:\"This will permanently remove the log messages from the database.\";s:74:\"Isto ha eliminar permanentemente as mensaxes do rexistro da base de datos.\";s:34:\"Allowed HTML tags in labels: @tags\";s:44:\"Etiquetas HTML admitidas en etiquetas: @tags\";s:40:\"Filtered text (user selects text format)\";s:56:\"Texto filtrado (o usuario selecciona o formato do texto)\";s:13:\"Summary input\";s:17:\"Resumo da entrada\";s:61:\"Leave blank to use trimmed value of full text as the summary.\";s:80:\"Deixar en branco para usar como resumo un fragmento recortado do texto completo.\";s:41:\"Configuring content types for translation\";s:46:\"Configurando tipos de contidos para tradución\";s:31:\"Assigning a language to content\";s:34:\"Asignando unha linguaxe ao contido\";s:19:\"Translating content\";s:18:\"Traducindo contido\";s:24:\"Maintaining translations\";s:21:\"Mantendo traduccións\";s:20:\"Edit field settings.\";s:25:\"Editar opcións de campo.\";s:19:\"Change widget type.\";s:24:\"Cambiar tipo de control.\";s:23:\"Edit instance settings.\";s:29:\"Editar opcións de instancia.\";s:16:\"Delete instance.\";s:19:\"Eliminar instancia.\";s:29:\"%field has no field settings.\";s:33:\"%field non ten opcións de campo.\";s:36:\"Updated field %label field settings.\";s:41:\"Actualizadas as opcións do campo %label.\";s:13:\"Change widget\";s:15:\"Cambiar control\";s:36:\"Changed the widget for field %label.\";s:39:\"Cambiado o control para o campo %label.\";s:62:\"The field %field has been deleted from the %type content type.\";s:54:\"O campo %field foi eliminado do tipo de contido %type.\";s:74:\"These settings apply only to the %field field when used in the %type type.\";s:76:\"Estas opcións aplicanse só no campo %field cando se utiliza no tipo %type.\";s:14:\"Required field\";s:15:\"Campo necesario\";s:63:\"These settings apply to the %field field everywhere it is used.\";s:74:\"Estas opcións aplicanse o campo %field en todos os sitios nos que se usa.\";s:21:\"%field field settings\";s:31:\"Configuracións do campo %field\";s:65:\"The default value for this field, used when creating new content.\";s:73:\"O valor predeterminado para este campo. Usase cando se crea novo contido.\";s:27:\"Saved %label configuration.\";s:35:\"Gardada a configuración de %label.\";s:19:\"Save and add fields\";s:23:\"Gardar e engadir campos\";s:29:\"Enable <em>Display</em> field\";s:36:\"Activar campo <em>Presentación</em>\";s:26:\"Files displayed by default\";s:41:\"Arquivos amosados de forma predeterminada\";s:65:\"This setting only has an effect if the display option is enabled.\";s:73:\"Esta opción só ten efecto se a opción de presentación está activada.\";s:18:\"Upload destination\";s:17:\"Destino da subida\";s:33:\"Enable <em>Description</em> field\";s:35:\"Activar campo <em>Descripción</em>\";s:14:\"Add a new file\";s:23:\"Engadir un arquivo novo\";s:30:\"Files must be less than !size.\";s:40:\"Os ficheiros deben ser menores de !size.\";s:32:\"Allowed file types: !extensions.\";s:43:\"Tipos de ficheiros permitidos: !extensions.\";s:54:\"The file in the !name field was unable to be uploaded.\";s:44:\"Non se puido subir o arquivo no campo !name.\";s:29:\"All roles may use this format\";s:39:\"Todos os roles deben usar este formato.\";s:23:\"Filter processing order\";s:33:\"Orden de procesamento dos filtros\";s:41:\"The text format %format has been updated.\";s:40:\"Actualizouse o formato de texto %format.\";s:35:\"More information about text formats\";s:45:\"Máis información sobre os formatos de texto\";s:23:\"Limit allowed HTML tags\";s:36:\"Limitar as etiquetas HTML permitidas\";s:23:\"Convert URLs into links\";s:27:\"Convertir as URL en enlaces\";s:35:\"Correct faulty and chopped off HTML\";s:38:\"Correxir HTML defectuoso ou incompleto\";s:30:\"Display any HTML as plain text\";s:44:\"Mostrar cualquer HTML como texto sen formato\";s:43:\"Display basic HTML help in long filter tips\";s:58:\"Mostrar axuda HTML básica nos consellos longos de filtros\";s:31:\"Add rel=\"nofollow\" to all links\";s:41:\"Engadir rel=\"nofollow\" a todos os enlaces\";s:21:\"No HTML tags allowed.\";s:31:\"Non se permiten etiquetas HTML.\";s:9:\"i18n_node\";b:1;s:9:\"i18n_sync\";b:1;s:11:\"translation\";b:1;s:16:\"Edit %name style\";s:19:\"Editar estilo %name\";s:16:\"Image style name\";s:23:\"Nome de estilo de imaxe\";s:19:\"Select a new effect\";s:26:\"Seleccionar un efecto novo\";s:6:\"Resumo\";b:1;s:17:\"Override defaults\";s:36:\"Sobrescribir valores predeterminados\";s:12:\"Update style\";s:17:\"Actualizar estilo\";s:42:\"The image effect was successfully applied.\";s:45:\"O efecto da imaxe foi aplicado correctamente.\";s:74:\"The %style style has been overridden, allowing you to change its settings.\";s:80:\"O estilo %style foi sobrescrito, o que lle permite cambiar a sua configuración.\";s:16:\"Create new style\";s:17:\"Crear estilo novo\";s:24:\"Style %name was created.\";s:22:\"Creose o estilo %name.\";s:18:\"Edit %label effect\";s:20:\"Editar efecto %label\";s:17:\"Add %label effect\";s:22:\"Engadir efecto %label.\";s:13:\"Update effect\";s:17:\"Actualizar efecto\";s:10:\"Add effect\";s:14:\"Engadir efecto\";s:60:\"The part of the image that will be retained during the crop.\";s:48:\"A parte da imaxe que se conservará ó recortar.\";s:16:\"view actual size\";s:16:\"ver tamaño real\";s:21:\"Sample original image\";s:25:\"Imaxen de mostra orixinal\";s:21:\"Sample modified image\";s:26:\"Imaxe de mostra modificada\";s:61:\"If no image is uploaded, this image will be shown on display.\";s:65:\"Se non se sube ningunha imaxe, ésta será a imaxe que se mostre.\";s:24:\"Minimum image resolution\";s:28:\"Resolución mínima da imaxe\";s:25:\"Enable <em>Alt</em> field\";s:26:\"Activar campo <em>Alt</em>\";s:27:\"Enable <em>Title</em> field\";s:30:\"Activar campo <em>Título</em>\";s:19:\"Preview image style\";s:31:\"Vista previa do estilo de imaxe\";s:10:\"no preview\";s:16:\"sen vista previa\";s:58:\"The preview image will be shown while editing the content.\";s:57:\"A vista previa da imaxe mostraráse o editar o contenido.\";s:23:\"Error generating image.\";s:21:\"Erro o xerar a imaxe.\";s:20:\"Generate image style\";s:21:\"Crear estilo de imaxe\";s:25:\"Configure an image style.\";s:30:\"Configurar un estilo de imaxe.\";s:17:\"Edit image effect\";s:22:\"Editar efecto de imaxe\";s:16:\"Add image effect\";s:23:\"Engadir efecto de imaxe\";s:28:\"Add a new effect to a style.\";s:35:\"Engadir un efecto novo a un estilo.\";s:25:\"Path prefix language code\";s:36:\"Código de idioma do prefixo de ruta\";s:8:\"add link\";s:14:\"engadir enlace\";s:46:\"The text to be used for this link in the menu.\";s:48:\"O texto que se usará no menú para este enlace.\";s:63:\"Menu links that are not enabled will not be listed in any menu.\";s:80:\"Os enlaces de menú que non estén activados non se mostrarán en ningún menú.\";s:16:\"Show as expanded\";s:17:\"Mostrar expandido\";s:11:\"Parent link\";s:24:\"Enlace pai (Parent link)\";s:59:\"Are you sure you want to delete the custom menu link %item?\";s:65:\"Seguro que desexa eliminar o enlace de menú personalizado %item?\";s:38:\"The menu link %title has been deleted.\";s:39:\"O enlace de menú %title foi eliminado.\";s:14:\"Edit menu link\";s:22:\"Editar enlace de menú\";s:16:\"Delete menu link\";s:24:\"Eliminar enlace de menú\";s:33:\"Content is sticky at top of lists\";s:41:\"O contido está fixo na cabeza das listas\";s:37:\"Content is promoted to the front page\";s:44:\"O contido esta colocado na páxina principal\";s:37:\"Show block for specific content types\";s:50:\"Mostrar bloques para tipos de contido específicos\";s:32:\"Choose a set of shortcuts to use\";s:38:\"Elixa un conxunto de atallos para usar\";s:45:\"You are now using the %set_name shortcut set.\";s:51:\"Agora está usando o conxunto de atallos %set_name.\";s:10:\"Change set\";s:16:\"Cambiar conxunto\";s:34:\"The shortcut set has been updated.\";s:38:\"O conxunto de atallos foi actualizado.\";s:17:\"Editing @shortcut\";s:18:\"Editando @shorcurt\";s:25:\"The name of the shortcut.\";s:16:\"O nome do atallo\";s:25:\"The path to the shortcut.\";s:15:\"A ruta o atallo\";s:36:\"The shortcut %link has been updated.\";s:31:\"O atallo %link foi actualizado.\";s:28:\"Added a shortcut for %title.\";s:32:\"Engadiuse un atallo para %title.\";s:52:\"Are you sure you want to delete the shortcut %title?\";s:53:\"¿Seguro que desexa eliminar o acceso directo %title?\";s:37:\"The shortcut %title has been deleted.\";s:38:\"O acceso directo %title foi eliminado.\";s:12:\"Add shortcut\";s:14:\"Engadir atallo\";s:13:\"Edit shortcut\";s:13:\"Editar atallo\";s:15:\"Delete shortcut\";s:15:\"Eliminar atallo\";s:27:\"Screenshot for !theme theme\";s:24:\"Miniatura do tema !theme\";s:25:\"Settings for !theme theme\";s:27:\"Opcións para o tema !theme\";s:20:\"Disable !theme theme\";s:22:\"Desactivar tema !theme\";s:27:\"Set !theme as default theme\";s:42:\"Establecer !theme como tema predeterminado\";s:19:\"Enable !theme theme\";s:19:\"Activar tema !theme\";s:22:\"Enable and set default\";s:40:\"Activar e establecer como predeterminado\";s:30:\"Enable !theme as default theme\";s:48:\"Activar !theme como tema gráfico predeterminado\";s:13:\"default theme\";s:19:\"tema predeterminado\";s:61:\"Use the administration theme when editing or creating content\";s:58:\"Usar o tema de administración o editar ou crear contenido\";s:35:\"The %theme theme has been disabled.\";s:30:\"O tema %theme foi desactivado.\";s:36:\"User verification status in comments\";s:50:\"Estado de verificación de usuario nos comentarios\";s:46:\"How this is used depends on your site\'s theme.\";s:45:\"Como se usa iso depende do tema do seu sitio.\";s:29:\"Number of posts on front page\";s:39:\"Número de artigos na páxina principal\";s:19:\"Errors and warnings\";s:20:\"Erros e advertencias\";s:16:\"Clear all caches\";s:23:\"Vaciar todas as cachés\";s:22:\"Bandwidth optimization\";s:31:\"Optimización de ancho de banda\";s:10:\"Time zones\";s:14:\"Fusos horarios\";s:59:\"No date types available. <a href=\"@link\">Add date type</a>.\";s:80:\"No hai tipos de data dispoñibles. <a href=\"@link\">Engadir novo tipo de data</a>\";s:33:\"New date type added successfully.\";s:46:\"Novo tipo de data engadido satisfactoriamente.\";s:70:\"No custom date formats available. <a href=\"@link\">Add date format</a>.\";s:95:\"Non hai formatos de data personalizados dispoñibles. href=\"@link\">Agregar formato de data</a>.\";s:12:\"Displayed as\";s:12:\"Amosase como\";s:25:\"Custom date format added.\";s:39:\"Formato de data personalizado engadido.\";s:14:\"Update modules\";s:19:\"Actualizar módulos\";s:13:\"Update themes\";s:16:\"Actualizar temas\";s:12:\"@zone: @date\";s:12:\"@zone: @date\";s:42:\"Powered by <a href=\"@poweredby\">Drupal</a>\";s:48:\"Desenrrolado con <a href=\"@poweredby\">Drupal</a>\";s:13:\"AHAH callback\";s:13:\"AHAH callback\";s:13:\"Disable theme\";s:15:\"Desactivar tema\";s:34:\"Your configuration has been saved.\";s:33:\"A sua configuración foi gardada.\";s:62:\"No vocabularies available. <a href=\"@link\">Add vocabulary</a>.\";s:75:\"Non hai vocabularios dispoñibles. <a href=\"@link\">Engadir vocabulario</a>.\";s:49:\"No terms available. <a href=\"@link\">Add term</a>.\";s:63:\"Non hai termos dispoñibles. <a href=\"@link\">Engadir termo</a>.\";s:57:\"The vocabulary which supplies the options for this field.\";s:54:\"O vocabulario que contén as opcións para este campo.\";s:18:\"Installing updates\";s:24:\"Instalar actualizacións\";s:29:\"Preparing to update your site\";s:45:\"Preparándose para actualizar o seu sitio web\";s:19:\"Installing %project\";s:19:\"Instalando %project\";s:20:\"Preparing to install\";s:27:\"Preparándose para instalar\";s:24:\"No available update data\";s:55:\"Non hai información sobre actualizacións dispoñíbel\";s:30:\"Checking available update data\";s:48:\"Comprobando datos de actualización dispoñibles\";s:41:\"Trying to check available update data ...\";s:62:\"Tentando comprobar os datos de actualización dispoñibles ...\";s:37:\"Error checking available update data.\";s:57:\"Erro o comprobar os datos de actualización dispoñibles.\";s:34:\"Checking available update data ...\";s:55:\"Comprobando os datos de actualización dispoñibles ...\";s:41:\"Checked available update data for %title.\";s:61:\"Datos de actualización dispoñibles para %title comprobados.\";s:15:\"(Release notes)\";s:19:\"(Notas da versión)\";s:36:\"All of your projects are up to date.\";s:44:\"Todos os seus proxectos están actualizados.\";s:22:\"Download these updates\";s:31:\"Descargar estas actualizacións\";s:19:\"Downloading updates\";s:24:\"Baixando actualizacións\";s:38:\"Preparing to download selected updates\";s:56:\"Preparándo a descarga das actualizacións seleccionadas\";s:32:\"Updates downloaded successfully.\";s:36:\"Actualizacións baixadas con éxito.\";s:68:\"Perform updates with site in maintenance mode (strongly recommended)\";s:83:\"Realizar actualizacións co sitio web en modo de mantemento (Altamente recomendado)\";s:18:\"Install from a URL\";s:23:\"Instalar dende unha URL\";s:17:\"For example: %url\";s:17:\"Por exemplo: %url\";s:43:\"Upload a module or theme archive to install\";s:49:\"Subir un arquivo de módulo ou tema para instalar\";s:47:\"For example: %filename from your local computer\";s:39:\"Por exemplo: %filename do seu ordenador\";s:20:\"Downloading %project\";s:20:\"Descargando %project\";s:23:\"Required by: %subthemes\";s:26:\"Necesario para: %subthemes\";s:15:\"Ready to update\";s:25:\"Preparado para actualizar\";s:14:\"Update manager\";s:24:\"Xestor de actualización\";s:20:\"No people available.\";s:29:\"Non hai persoas dispoñibles.\";s:29:\"Registration and cancellation\";s:34:\"Creación e cancelación de contas\";s:26:\"Who can register accounts?\";s:23:\"Quen pode crear contas?\";s:19:\"Administrators only\";s:19:\"Só administradores\";s:48:\"Visitors, but administrator approval is required\";s:63:\"Visitantes, pero é necesaria a aprobación dos administradores\";s:62:\"Require e-mail verification when a visitor creates an account.\";s:78:\"Pedir verificación de correo electrónico cando un visitante crea unha conta.\";s:30:\"When cancelling a user account\";s:33:\"Ao cancelar unha conta de usuario\";s:36:\"Select method for cancelling account\";s:44:\"Seleccionar o método para cancelar a conta.\";s:15:\"Personalization\";s:16:\"Personalización\";s:18:\"Enable signatures.\";s:15:\"Activar firmas.\";s:21:\"Enable user pictures.\";s:26:\"Activar imaxes de usuario.\";s:21:\"Picture display style\";s:33:\"Estilo de presentación de imaxes\";s:25:\"Picture upload dimensions\";s:30:\"Dimensións da imáxen a subir\";s:24:\"Picture upload file size\";s:36:\"Tamaño do archivo de imaxen a subir\";s:7:\"E-mails\";s:21:\"Correos electrónicos\";s:43:\"Welcome (new user created by administrator)\";s:47:\"Benvida (novo usuario creado polo adminstrador)\";s:27:\"Welcome (awaiting approval)\";s:33:\"Benvida (pendente de aprobación)\";s:30:\"Welcome (no approval required)\";s:39:\"Benvida (sen necesidade de aprobación)\";s:17:\"Password recovery\";s:28:\"Recuperación de contrasinal\";s:66:\"Edit the e-mail messages sent to users who request a new password.\";s:106:\"Editar as mensaxes de correo electrónico que se envían os usuarios cando solicitan una nova contrasinal.\";s:18:\"Account activation\";s:20:\"Activación da conta\";s:16:\"Account canceled\";s:15:\"Conta cancelada\";s:37:\"Notify user when account is canceled.\";s:42:\"Avisar o usuario cando se cancela a conta.\";s:45:\"By default, Drupal comes with two user roles:\";s:50:\"Por defecto, Drupal ven con dous roles de usuario:\";s:34:\"User module timezone form element.\";s:61:\"Elemento do formulario da zona horaria do módulo de usuario.\";s:33:\"User module history view element.\";s:53:\"Elemento de vista de historial do módulo de usuario.\";s:46:\"Account details for [user:name] at [site:name]\";s:47:\"Detalles da conta de [user:name] en [site:name]\";s:58:\"An administrator created an account for you at [site:name]\";s:61:\"Un administrador creou para vostede unha conta en [site:name]\";s:71:\"Account details for [user:name] at [site:name] (pending admin approval)\";s:88:\"Detalles da conta de [user:name] en [site:name] (pendente de aprobación administrativa)\";s:60:\"Replacement login information for [user:name] at [site:name]\";s:87:\"Información sobre a substitución de inicio de sesión para [user:name] en [site:name]\";s:57:\"Account details for [user:name] at [site:name] (approved)\";s:58:\"Detalles da conta de [user:name] en [site:name] (aprobado)\";s:56:\"Account details for [user:name] at [site:name] (blocked)\";s:59:\"Detalles da conta de [user:name] en [site:name] (bloqueada)\";s:59:\"Account cancellation request for [user:name] at [site:name]\";s:64:\"Petición de cancelación de conta de [user:name] en [site:name]\";s:57:\"Account details for [user:name] at [site:name] (canceled)\";s:59:\"Detalles da conta de [user:name] en [site:name] (cancelada)\";s:33:\"Cancel the selected user accounts\";s:43:\"Cancelar as contas de usuario seleccionadas\";s:31:\"To make your password stronger:\";s:42:\"Para facer o voso contrasinal máis forte:\";s:29:\"Make it at least 6 characters\";s:30:\"Darlle polo menos 6 caracteres\";s:21:\"Add lowercase letters\";s:26:\"Engadir letras minúsculas\";s:21:\"Add uppercase letters\";s:26:\"Engadir letras maiúsculas\";s:11:\"Add numbers\";s:16:\"Engadir números\";s:15:\"Add punctuation\";s:19:\"Engadir puntuación\";s:36:\"Make it different from your username\";s:46:\"Facer que sexa distinta do seu nome de usuario\";s:4:\"Weak\";s:6:\"Débil\";s:4:\"Fair\";s:8:\"Razoable\";s:65:\"A simple one-column, tableless, fluid width administration theme.\";s:79:\"Un tema visual para admistración dunha columna, sen tablas, de ancho variable.\";s:11:\"Image style\";s:15:\"Estilo de imaxe\";s:16:\"Author textfield\";s:20:\"Campo de texto autor\";s:17:\"Subject textfield\";s:21:\"Campo de texto asunto\";s:25:\"Error messages to display\";s:36:\"Mensaxes de erro que se deben amosar\";s:19:\"Term name textfield\";s:31:\"Campo de texto do nome do termo\";s:25:\"Term description textarea\";s:38:\"Área de texto da descrición do termo\";s:71:\"Enter your current password to change the %mail or %pass. !request_new.\";s:77:\"Escriba o seu contrasinal actual para modificar %mail ou %pass. !request_new.\";s:16:\"Current password\";s:18:\"Contrasinal actual\";s:25:\"%module module installed.\";s:25:\"Modulo %module instalado.\";s:43:\"Use this page to create a new custom block.\";s:57:\"Use esta páxina para crear un novo bloque personalizado.\";s:71:\"The new set is created by copying items from your default shortcut set.\";s:87:\"O novo conxunto crearáse copiando elementos do seu conxunto predeterminado de atallos.\";s:13:\"Edit set name\";s:23:\"Editar nome de conxunto\";s:16:\"Database support\";s:24:\"Soporte de base de datos\";s:8:\"On value\";s:19:\"Valor para activado\";s:32:\"If left empty, \"1\" will be used.\";s:40:\"Se o deixa en branco, se empregará \"1\".\";s:9:\"Off value\";s:22:\"Valor para desactivado\";s:32:\"If left empty, \"0\" will be used.\";s:40:\"Se o deixa en branco, se empregará \"0\".\";s:23:\"@name <em>(locked)</em>\";s:26:\"@name <em>(bloqueado)</em>\";s:48:\"A flexible, recolorable theme with many regions.\";s:71:\"Un tema flexible con moitas rexiones que se lle poden cambiar as cores.\";s:60:\"No URL aliases available. <a href=\"@link\">Add URL alias</a>.\";s:75:\"No hai alias de URL dispoñibles. <a href=\"@link\">Engadir alias de URL</a>.\";s:12:\"Site details\";s:17:\"Detalles do sitio\";s:20:\"Weight for new field\";s:18:\"Peso do novo campo\";s:22:\"Weight for added field\";s:22:\"Peso do campo agregado\";s:23:\"Custom display settings\";s:39:\"Opcións de presentación personalizada\";s:56:\"Use custom display settings for the following view modes\";s:81:\"Usar as opcións de presentación personalizada para os seguintes modos de vistas\";s:39:\"Edit an existing effect within a style.\";s:45:\"Editar un efecto existente dentro dun estilo.\";s:19:\"Node module element\";s:24:\"Elemento do módulo Nodo\";s:21:\"None (original image)\";s:24:\"Ningún (imaxe orixinal)\";s:14:\"New field name\";s:20:\"Nombre de campo novo\";s:29:\"Database log messages to keep\";s:46:\"Mensaxes de rexistro da base de datos a manter\";s:18:\"- Select a value -\";s:23:\"- Seleccione un valor -\";s:22:\"No field is displayed.\";s:27:\"Non se amosa ningún campo.\";s:19:\"No field is hidden.\";s:28:\"No hai ningún campo oculto.\";s:16:\"Format settings:\";s:20:\"Opcións de formato:\";s:13:\"Link image to\";s:16:\"Vincular imaxe a\";s:19:\"Image style: @style\";s:23:\"Estilo de imaxe: @style\";s:17:\"Linked to content\";s:19:\"Vinculado a contido\";s:14:\"Linked to file\";s:19:\"Vinculado a arquivo\";s:39:\"Shown when hovering over the menu link.\";s:56:\"Mostrar cando pase o cursor por riba do enlace de menú.\";s:66:\"Choose which search modules are active from the available modules.\";s:75:\"Escoller qué módulos de busca están activados dos módulos dispoñibles.\";s:21:\"Default search module\";s:31:\"Módulo de busca predeterminado\";s:42:\"Choose which search module is the default.\";s:48:\"Escoller que módulo de busca e o predeterminado\";s:11:\"Error pages\";s:16:\"Páxinas de erro\";s:25:\"Last run: %cron-last ago.\";s:34:\"Última execución fai %cron-last.\";s:14:\"Run cron every\";s:18:\"Executar cron cada\";s:21:\"Weight for added term\";s:26:\"Peso para o termo engadido\";s:59:\"Pictures larger than this will be scaled down to this size.\";s:53:\"As imáxes que excedan este tamaño serán reducidas.\";s:23:\"Weight for @block block\";s:21:\"Peso do bloque @block\";s:23:\"Region for @block block\";s:24:\"Rexión do bloque @block\";s:29:\"and where %property is %value\";s:26:\"e onde %property é %value\";s:25:\"where %property is %value\";s:24:\"onde %property é %value\";s:9:\"and where\";s:6:\"e onde\";s:7:\"Nothing\";s:4:\"Nada\";s:51:\"%type: !message in %function (line %line of %file).\";s:52:\"%type: !message en %function (liña %line de %file).\";s:63:\"The machine-readable name is already in use. It must be unique.\";s:50:\"O nome de sistema xa está en uso. Debe ser único\";s:22:\"Weight for row @number\";s:25:\"Peso para la fila @number\";s:17:\"Parent for @title\";s:13:\"Pai de @title\";s:15:\"New field label\";s:22:\"Etiqueta do novo campo\";s:20:\"Parent for new field\";s:17:\"Pai do novo campo\";s:17:\"Type of new field\";s:18:\"Tipo de campo novo\";s:20:\"Widget for new field\";s:23:\"Control para campo novo\";s:20:\"Existing field label\";s:29:\"Etiqueta para campo existente\";s:25:\"Parent for existing field\";s:22:\"Pai do campo existente\";s:23:\"Existing field to share\";s:30:\"Campo existente para compartir\";s:25:\"Widget for existing field\";s:28:\"Control para campo existente\";s:24:\"Label display for @title\";s:35:\"Presentación de etiqueta de @title\";s:20:\"Formatter for @title\";s:23:\"Formateador para @title\";s:18:\"Parents for @title\";s:14:\"Pais de @title\";s:21:\"Visibility for @title\";s:24:\"Visibilidade para @title\";s:19:\"Weight for new file\";s:20:\"Peso do novo arquivo\";s:13:\"Choose a file\";s:21:\"Seleccione un arquivo\";s:21:\"Weight for new effect\";s:19:\"Peso do novo efecto\";s:23:\"Enable @title menu link\";s:31:\"Activar o enlace do menu @title\";s:14:\"Active modules\";s:16:\"Módulos activos\";s:22:\"!theme (default theme)\";s:28:\"!theme (tema predeterminado)\";s:26:\"No fields are present yet.\";s:32:\"Non hai campos presentes aínda.\";s:61:\"Read more<span class=\"element-invisible\"> about @title</span>\";s:65:\"Ler máis<span class=\"element-invisible\"> acerca de @title</span>\";s:24:\"Uninstall @module module\";s:27:\"Desinstalar módulo @module\";s:32:\"Release notes for @project_title\";s:39:\"Notas de lanzamento para @project_title\";s:41:\"Disable the account and keep its content.\";s:42:\"Desactivar a conta e manter o seu contido.\";s:46:\"Disable the account and unpublish its content.\";s:59:\"Desactivar a conta e retirar da publicación o seu contido.\";s:35:\"Delete the account and its content.\";s:33:\"Eliminar a conta, eo seu contido.\";s:50:\"Use field label instead of the \"On value\" as label\";s:60:\"Usa a etiqueta do campo en lugar da \"En valor\" como etiqueta\";s:11:\"Center left\";s:20:\"Centrado á esquerda\";s:12:\"Center right\";s:19:\"Centrado á dereita\";s:37:\"Changes to the style have been saved.\";s:35:\"Os cambios o estilo foron gardados.\";s:8:\"Curaçao\";s:8:\"Curaçao\";s:12:\"Sint Maarten\";s:12:\"Sint Maarten\";s:46:\"The requested page \"@path\" could not be found.\";s:45:\"A páxina solicitada \"@path\" non foi atopada.\";s:21:\"Active search modules\";s:25:\"Módulos de busca activos\";s:59:\"No shortcuts available. <a href=\"@link\">Add a shortcut</a>.\";s:67:\"No hai atallos dispoñibles. <a href=\"@link\">Engadir un atallo</a>.\";s:22:\"User name and password\";s:29:\"Nome de usuario e contrasinal\";s:34:\"User module account form elements.\";s:50:\"Elementos de formulario en contas do módulo User.\";s:51:\"There was a problem creating field %label: !message\";s:50:\"Houbo un problema creando o campo %label: !message\";s:24:\"Subscribe to !feed-title\";s:26:\"Subscribirse a !feed-title\";s:27:\"Table @name already exists.\";s:22:\"Taboa @name xa existe.\";s:11:\"South Sudan\";s:13:\"Sudán do Sur\";s:19:\"Not fully protected\";s:33:\"Non está completamente protexido\";s:9:\"Influence\";s:9:\"Influenza\";s:11:\"Binary Data\";b:1;s:21:\"Caribbean Netherlands\";b:1;s:34:\"Demonstrate block regions (!theme)\";b:1;s:30:\"Microsoft Office document icon\";b:1;s:23:\"Office spreadsheet icon\";b:1;s:24:\"Office presentation icon\";b:1;s:8:\"PDF icon\";b:1;s:10:\"Movie icon\";b:1;s:10:\"Audio icon\";b:1;s:10:\"Image icon\";b:1;s:12:\"Package icon\";b:1;s:9:\"HTML icon\";b:1;s:15:\"Plain text icon\";b:1;s:13:\"Trimmed limit\";b:1;s:6:\"Google\";s:6:\"Google\";s:6:\"jQuery\";b:1;s:9:\"Microsoft\";b:1;s:24:\"jQuery compression level\";b:1;s:21:\"Production (minified)\";b:1;s:26:\"Development (uncompressed)\";b:1;s:24:\"jQuery and jQuery UI CDN\";b:1;s:9:\"Libraries\";b:1;s:40:\"The %library library could not be found.\";b:1;s:1:\"=\";s:1:\"=\";s:9:\"Validator\";s:9:\"Validador\";s:9:\"Is one of\";s:8:\"É un de\";s:20:\"- Basic validation -\";s:23:\"- Validación básica -\";s:11:\"Link Target\";b:1;s:14:\"Optional Title\";b:1;s:14:\"Required Title\";b:1;s:8:\"No Title\";b:1;s:10:\"Link Title\";b:1;s:29:\"Default (no target attribute)\";b:1;s:24:\"Open link in window root\";b:1;s:23:\"Open link in new window\";b:1;s:24:\"Allow the user to choose\";b:1;s:20:\"Additional CSS Class\";b:1;s:12:\"Optional URL\";b:1;s:25:\"Allow user-entered tokens\";b:1;s:13:\"Rel Attribute\";b:1;s:12:\"Validate URL\";b:1;s:12:\"Static Title\";b:1;s:12:\"Static title\";b:1;s:48:\"Allow the user to enter a link \'title\' attribute\";b:1;s:30:\"Default link \'title\' Attribute\";b:1;s:25:\"Max length of title field\";b:1;s:44:\"Keep rel as set up above (untouched/default)\";b:1;s:36:\"Remove rel if given link is external\";b:1;s:36:\"Remove rel if given link is internal\";b:1;s:59:\"The link title is limited to @maxlength characters maximum.\";s:73:\"O título do enlace está limitado a un máximo de @maxlength caracteres.\";s:34:\"Remove rel attribute automatically\";b:1;s:58:\"If checked, the URL will always render as an absolute URL.\";b:1;s:50:\"If this is checked the field label will be hidden.\";b:1;s:52:\"Allow the user to enter a custom link class per link\";b:1;s:15:\"Security update\";b:1;s:9:\"Separator\";s:9:\"Separador\";s:33:\"Pattern for all %vocab-name paths\";s:39:\"Patrón para todas as rutas %vocab-name\";s:7:\"Verbose\";s:9:\"Detallado\";s:20:\"Maximum alias length\";s:26:\"Lonxitude máxima do alias\";s:24:\"Maximum component length\";s:31:\"Lonxitude máxima do componente\";s:13:\"Update action\";s:19:\"Actualizar acción.\";s:17:\"Strings to Remove\";s:15:\"Textos a borrar\";s:19:\"administer pathauto\";s:37:\"administrar alias de URL automáticos\";s:20:\"Replacement patterns\";s:21:\"Patróns de reemplazo\";s:6:\"Period\";s:7:\"Periodo\";s:20:\"Change to lower case\";s:21:\"Cambiar a minúsculas\";s:39:\"Do nothing. Leave the old alias intact.\";s:45:\"Non facer nada. Deixar o alias vello intacto.\";s:57:\"Create a new alias. Leave the existing alias functioning.\";s:58:\"Crear un novo alias. Deixar o alias existente funcionando.\";s:41:\"Create a new alias. Delete the old alias.\";s:44:\"Cear un novo alias. Borrar o anterior alias.\";s:37:\"Transliterate prior to creating alias\";s:35:\"Transliterar antes de crear o alias\";s:28:\"Generate automatic URL alias\";s:33:\"Xerar un alias automático da URL\";s:44:\"Uncheck this to create a custom alias below.\";s:64:\"Desmarque esta opción para crear un alias personalizado abaixo.\";s:29:\"Configure URL alias patterns.\";s:35:\"Configurar patróns do alias da URL\";s:35:\"Pattern for user account page paths\";b:1;s:51:\"Display alias changes (except during bulk updates).\";b:1;s:20:\"Replace by separator\";b:1;s:8:\"Asterisk\";b:1;s:32:\"Pattern for all @node_type paths\";b:1;s:14:\"Character case\";b:1;s:43:\"Leave case the same as source token values.\";b:1;s:26:\"No action (do not replace)\";b:1;s:22:\"notify of path changes\";b:1;s:5:\"Colon\";b:1;s:9:\"Semicolon\";b:1;s:5:\"Slash\";b:1;s:11:\"Punctuation\";b:1;s:37:\"Reduce strings to letters and numbers\";b:1;s:16:\"language neutral\";b:1;s:42:\"Pattern for all @language @node_type paths\";b:1;s:19:\"Taxonomy term paths\";b:1;s:10:\"User paths\";b:1;s:13:\"Content paths\";b:1;s:10:\"Underscore\";b:1;s:25:\"Path module form elements\";b:1;s:22:\"Double quotation marks\";b:1;s:35:\"Single quotation marks (apostrophe)\";b:1;s:9:\"Back tick\";b:1;s:6:\"Hyphen\";b:1;s:19:\"Vertical bar (pipe)\";b:1;s:18:\"Left curly bracket\";b:1;s:19:\"Left square bracket\";b:1;s:19:\"Right curly bracket\";b:1;s:20:\"Right square bracket\";b:1;s:9:\"Plus sign\";b:1;s:10:\"Equal sign\";b:1;s:12:\"Percent sign\";b:1;s:5:\"Caret\";b:1;s:11:\"Dollar sign\";b:1;s:30:\"Number sign (pound sign, hash)\";b:1;s:7:\"At sign\";b:1;s:16:\"Exclamation mark\";b:1;s:5:\"Tilde\";b:1;s:16:\"Left parenthesis\";b:1;s:17:\"Right parenthesis\";b:1;s:13:\"Question mark\";b:1;s:14:\"Less-than sign\";b:1;s:17:\"Greater-than sign\";b:1;s:9:\"Backslash\";b:1;s:8:\"settings\";s:8:\"opcións\";s:14:\"User Interface\";s:20:\"Interface de usuario\";s:16:\"General Settings\";s:20:\"Configuración xeral\";s:3:\"CSS\";s:3:\"CSS\";s:14:\"System default\";s:34:\"Opcións predefinidas polo sistema\";s:6:\"Target\";s:7:\"Destino\";s:32:\"Provide all themes for selection\";b:1;s:73:\"Make all installed themes available for selection, not enabled ones only.\";b:1;s:41:\"Retain the theme until a new theme is set\";b:1;s:9:\"New Rule:\";b:1;s:9:\"tutorials\";b:1;s:38:\"Property drupal:path is case sensitive\";b:1;s:25:\"Cron cleans up page cache\";b:1;s:15:\"Page<br />Cache\";b:1;s:5:\"Token\";s:9:\"Símbolos\";s:62:\"Click a token to insert it into the field you\'ve last clicked.\";b:1;s:51:\"List of the currently available tokens on this site\";b:1;s:74:\"The %element-title is using the following invalid tokens: @invalid-tokens.\";b:1;s:33:\"A date in \'@type\' format. (%date)\";b:1;s:22:\"Also known as %labels.\";b:1;s:19:\"No tokens available\";b:1;s:27:\"This field supports tokens.\";b:1;s:24:\"Browse available tokens.\";b:1;s:18:\"Original file name\";b:1;s:13:\"Transliterate\";b:1;s:59:\"Are you sure you want to transliterate existing file names?\";b:1;s:24:\"Transliterated file name\";b:1;s:74:\"The database currently lists @x_filenames containing non-ASCII characters.\";b:1;s:48:\"Transliterate search index and searched strings.\";b:1;s:34:\"Convert all characters to US-ASCII\";b:1;s:60:\"Placeholder for characters with no known US-ASCII equivalent\";b:1;s:2:\"On\";s:6:\"Activo\";s:3:\"For\";s:4:\"Para\";s:3:\"Tag\";s:8:\"Etiqueta\";s:9:\"Use count\";s:13:\"Conta de usos\";s:14:\"Block settings\";s:17:\"Axustes do bloque\";s:5:\"Depth\";s:12:\"Profundidade\";s:7:\"Node ID\";s:10:\"ID do nodo\";s:7:\"Add new\";s:12:\"Engadir novo\";s:6:\"Access\";s:6:\"Acceso\";s:4:\"GUID\";s:4:\"GUID\";s:2:\"ID\";s:2:\"ID\";s:4:\"Mail\";s:8:\"Correo-e\";s:8:\"Promoted\";s:12:\"Promocionado\";s:17:\"Number of columns\";s:19:\"Número de columnas\";s:7:\"Exclude\";s:8:\"Excluír\";s:10:\"Horizontal\";s:10:\"Horizontal\";s:8:\"Vertical\";s:8:\"Vertical\";s:4:\"term\";s:5:\"termo\";s:14:\"Override title\";s:20:\"Sobrescribir título\";s:9:\"CSS class\";s:9:\"Clase CSS\";s:6:\"Module\";s:7:\"Módulo\";s:3:\"Off\";s:11:\"Desactivado\";s:5:\"Score\";s:11:\"Puntuación\";s:11:\"Log message\";s:19:\"Mensaxe de rexistro\";s:8:\"Contains\";s:7:\"Contén\";s:12:\"Is less than\";s:12:\"É menor que\";s:24:\"Is less than or equal to\";s:19:\"É menor ou igual a\";s:11:\"Is equal to\";s:10:\"É igual a\";s:27:\"Is greater than or equal to\";s:19:\"É maior ou igual a\";s:15:\"Is greater than\";s:12:\"É maior que\";s:15:\"Is not equal to\";s:15:\"É diferente de\";s:7:\"Average\";s:5:\"Media\";s:6:\"Normal\";s:6:\"Normal\";s:10:\"Sort order\";s:19:\"Orde predeterminada\";s:7:\"Current\";s:6:\"Actual\";s:2:\"OR\";s:2:\"OU\";s:5:\"Align\";s:7:\"Aliñar\";s:9:\"List type\";s:13:\"Tipo de lista\";s:10:\"Select all\";s:16:\"Seleccionar todo\";s:9:\"Link text\";s:15:\"Texto do enlace\";s:4:\"Case\";s:11:\"Maiúsculas\";s:9:\"Edit view\";s:12:\"Editar vista\";s:9:\"Ascending\";s:10:\"Ascendente\";s:10:\"Descending\";s:11:\"Descendente\";s:8:\"Operator\";s:8:\"Operador\";s:7:\"Filters\";s:7:\"Filtros\";s:13:\"Uncategorized\";s:15:\"Sen categorizar\";s:8:\"Position\";s:9:\"Posición\";s:13:\"with comments\";s:15:\"con comentarios\";s:16:\"without comments\";s:15:\"sen comentarios\";s:12:\"Updated date\";s:22:\"Data de actualización\";s:18:\"Regular expression\";s:18:\"Expresión regular\";s:8:\"Approved\";s:8:\"Aprobado\";s:2:\"in\";s:2:\"en\";s:8:\"Messages\";s:8:\"Mensaxes\";s:6:\"Source\";s:5:\"Orixe\";s:12:\"Display name\";s:13:\"Nome a amosar\";s:5:\"Query\";s:8:\"Consulta\";s:10:\"Block name\";s:14:\"Nome do bloque\";s:4:\"Hour\";s:4:\"Hora\";s:6:\"Minute\";s:6:\"Minuto\";s:6:\"Second\";s:7:\"Segundo\";s:11:\"Granularity\";s:13:\"Granularidade\";s:9:\"Alignment\";s:11:\"Aliñamento\";s:6:\"author\";s:5:\"autor\";s:3:\"AND\";s:1:\"E\";s:4:\"Left\";s:8:\"Esquerda\";s:5:\"Right\";s:7:\"Dereita\";s:2:\"or\";s:2:\"ou\";s:8:\"All tags\";s:18:\"Todas as etiquetas\";s:7:\"Reverse\";s:9:\"Invertido\";s:6:\"Plural\";s:6:\"Plural\";s:12:\"Oldest first\";s:23:\"O máis antigo primeiro\";s:9:\"Base path\";s:9:\"Ruta base\";s:2:\"Ok\";s:8:\"Correcto\";s:7:\"Storage\";s:13:\"Almacenamento\";s:11:\"Information\";s:12:\"Información\";s:11:\"Translation\";s:11:\"Traducción\";s:18:\"Translation status\";s:21:\"Estado da traducción\";s:9:\"Text area\";s:14:\"Área de texto\";s:10:\"Exceptions\";s:11:\"Excepcións\";s:6:\"Thread\";s:4:\"Fío\";s:10:\"Title text\";s:16:\"Texto do título\";s:8:\"Distinct\";s:9:\"Distintos\";s:9:\"Rearrange\";s:9:\"Reordenar\";s:5:\"empty\";s:7:\"valeiro\";s:9:\"All types\";s:14:\"Todos os tipos\";s:11:\"Cancel link\";s:20:\"Enlace para cancelar\";s:5:\"Pager\";s:9:\"Paxinador\";s:10:\"Identifier\";s:14:\"Indentificador\";s:16:\"Remove this item\";s:21:\"Engadir este elemento\";s:13:\"Page settings\";s:18:\"Axustes da páxina\";s:9:\"Use pager\";s:14:\"Usar paxinador\";s:16:\"Items to display\";s:18:\"Elementos a amosar\";s:9:\"More link\";s:14:\"Ligazón máis\";s:14:\"More link text\";s:26:\"Texto do enlace \'máis...\'\";s:8:\"contains\";s:7:\"contén\";s:4:\"Data\";s:4:\"Data\";s:12:\"Ordered list\";s:14:\"Lista ordenada\";s:14:\"Unordered list\";s:18:\"Lista non ordenada\";s:10:\"Link class\";s:17:\"Clase de ligazón\";s:5:\"regex\";s:5:\"regex\";s:3:\"and\";s:1:\"e\";s:9:\"Add @type\";s:13:\"Engadir @type\";s:12:\"Not promoted\";s:16:\"Non promocionado\";s:10:\"Not sticky\";s:13:\"Non pegañoso\";s:3:\"Nid\";s:3:\"Nid\";s:14:\"Parent comment\";s:14:\"Comentario pai\";s:19:\"The parent comment.\";s:16:\"O comentario pai\";s:16:\"Author\'s website\";s:18:\"Sitio web do autor\";s:51:\"Display the depth of the comment if it is threaded.\";s:48:\"Mostra a profundidade do comentario se ten fios.\";s:13:\"Reply-to link\";s:21:\"Enlace de \"Responder\"\";s:46:\"Provide a simple link to reply to the comment.\";s:58:\"Proveer unha ligazón simple para respostar ao comentario.\";s:15:\"Text to display\";s:14:\"Texto a amosar\";s:12:\"Newest first\";s:24:\"O máis recente primeiro\";s:5:\"nodes\";s:5:\"nodos\";s:9:\"Formatter\";s:11:\"Formateador\";s:8:\"Time ago\";s:15:\"Tempo que pasou\";s:26:\"The taxonomy vocabulary ID\";s:34:\"O ID do vocabulario da taxonomía.\";s:20:\"starting from @count\";s:20:\"comezando por @count\";s:31:\"The language the content is in.\";s:32:\"A lingua na que está o contido.\";s:11:\"Entity type\";s:16:\"Tipo de entidade\";s:10:\"User roles\";s:16:\"Roles de usuario\";s:14:\"More link path\";s:18:\"Enlace \"Ver máis\"\";s:11:\"Button text\";s:15:\"Texto do botón\";s:9:\"Mime type\";s:9:\"Tipo mime\";s:14:\"Display format\";s:24:\"Formato de presentación\";s:35:\"The date the node was last updated.\";s:34:\"A data que o nodo foi actualizado.\";s:14:\"!group: !field\";s:14:\"!group: !field\";s:12:\"Display type\";s:13:\"Tipo de vista\";s:13:\"Is not one of\";s:12:\"Non é un de\";s:39:\"Comments are responses to node content.\";s:50:\"Os comentarios son respostas ao contido dos nodos.\";s:45:\"Users who have created accounts on your site.\";s:55:\"Usuarios que se rexistraron e teñen conta neste sitio.\";s:14:\"!group: !title\";s:14:\"!group: !title\";s:2:\"!=\";s:2:\"!=\";s:15:\"Is empty (NULL)\";s:20:\"Está valeiro (NULL)\";s:9:\"not empty\";s:11:\"non valeiro\";s:19:\"Theming information\";s:25:\"Información de plantilla\";s:11:\"Upload date\";s:14:\"Data de subida\";s:12:\"Do not cache\";s:21:\"Non incluir na caché\";s:7:\"No role\";s:7:\"Sen rol\";s:9:\"View link\";s:12:\"Ver ligazón\";s:11:\"Delete link\";s:17:\"Eliminar ligazón\";s:48:\"Filter the view to the currently logged in user.\";s:52:\"Filtrar a vista ao usuario actualmente identificado.\";s:34:\"Cache once for everything (global)\";s:51:\"Poñer en caché dunha sóla vez para todo (global)\";s:8:\"Per page\";s:11:\"Por páxina\";s:8:\"Per role\";s:7:\"Por rol\";s:17:\"Per role per page\";s:19:\"Por rol por páxina\";s:8:\"Per user\";s:11:\"Por usuario\";s:17:\"Per user per page\";s:23:\"Por usuario por páxina\";s:10:\"Has Avatar\";s:10:\"Ten Avatar\";s:23:\"Capitalize first letter\";s:31:\"A primeira letra en maiúsculas\";s:3:\"Uid\";s:3:\"Uid\";s:11:\"Custom text\";s:19:\"Texto personalizado\";s:3:\"Sum\";s:4:\"Suma\";s:9:\"sorted by\";s:11:\"ordeado por\";s:12:\"Not Approved\";s:9:\"Rexeitado\";s:9:\"Edit link\";s:15:\"Editar ligazón\";s:18:\"Submit button text\";s:25:\"Texto do botón de envío\";s:16:\"Add comment link\";s:27:\"Vínculo engadir comentario\";s:45:\"Do not display items with no value in summary\";s:41:\"Non amosar elementos sen valor no sumario\";s:13:\"Glossary mode\";s:13:\"Modo glosario\";s:15:\"Character limit\";s:21:\"Límite de caracteres\";s:12:\"No transform\";s:15:\"Non transformar\";s:10:\"Upper case\";s:11:\"Maiúsculas\";s:10:\"Lower case\";s:11:\"Minúsculas\";s:20:\"Capitalize each word\";s:37:\"Poñer en maiúsculas en cada palabra\";s:12:\"Case in path\";s:31:\"Maiúsculas/Minúsculas na ruta\";s:33:\"Transform spaces to dashes in URL\";s:39:\"Transformar os espazos en barras na URL\";s:20:\"Exclude from display\";s:25:\"Excluir da visualización\";s:32:\"Rewrite the output of this field\";s:31:\"Reescribir a saída deste campo\";s:27:\"Output this field as a link\";s:36:\"Amosar este campo como unha ligazón\";s:9:\"Link path\";s:16:\"Ruta da ligazón\";s:35:\"The CSS class to apply to the link.\";s:33:\"A clase CSS a asignar á ligazón\";s:11:\"Prefix text\";s:16:\"Texto do prefixo\";s:59:\"Any text to display before this link. You may include HTML.\";s:64:\"Calquera texto a amosar antes desta ligazón. Pode incluir HTML.\";s:11:\"Suffix text\";s:15:\"Texto do sufixo\";s:58:\"Any text to display after this link. You may include HTML.\";s:66:\"Calquera texto a amosar despois desta ligazón. Pode incluir HTML.\";s:35:\"Trim this field to a maximum length\";s:44:\"Recortar este campo a unha lonxitude máxima\";s:28:\"Trim only on a word boundary\";s:27:\"Recortar só entre palabras\";s:15:\"Add an ellipsis\";s:26:\"Engadir puntos suspensivos\";s:57:\"If checked, a \"...\" will be added if a field was trimmed.\";s:57:\"si se marca, engadirase un \"...\" si se recortase o campo.\";s:15:\"Strip HTML tags\";s:23:\"Eliminar etiquetas HTML\";s:43:\"If checked, all HTML tags will be stripped.\";s:50:\"si se marca, todas as etiquetas HTML eliminaranse.\";s:22:\"Field can contain HTML\";s:24:\"O campo pode conter HTML\";s:16:\"Simple separator\";s:17:\"Separador sinxelo\";s:7:\"- Any -\";s:12:\"- Calquera -\";s:10:\"Value type\";s:13:\"Tipo de valor\";s:6:\"not in\";s:6:\"non en\";s:2:\"<>\";s:2:\"<>\";s:9:\"Is all of\";s:12:\"Son todos de\";s:10:\"Is none of\";s:7:\"ningún\";s:3:\"not\";s:3:\"non\";s:1:\"<\";s:1:\"<\";s:2:\"<=\";s:2:\"<=\";s:2:\">=\";s:2:\">=\";s:1:\">\";s:1:\">\";s:10:\"Is between\";s:11:\"Está entre\";s:7:\"between\";s:5:\"entre\";s:14:\"Is not between\";s:15:\"Non está entre\";s:11:\"not between\";s:9:\"non entre\";s:3:\"And\";s:1:\"E\";s:25:\"Require this relationship\";s:22:\"Precisa esta relación\";s:3:\"asc\";s:3:\"asc\";s:4:\"desc\";s:4:\"desc\";s:8:\"Displays\";s:13:\"Presentación\";s:25:\"This display has no path.\";s:32:\"Esta presentación non ten ruta.\";s:16:\"No query was run\";s:30:\"Sen se realizou ningunha busca\";s:9:\"View name\";s:13:\"Nome da vista\";s:16:\"View description\";s:17:\"Ver a descrición\";s:8:\"View tag\";s:9:\"Ver marca\";s:20:\"Paste view code here\";s:29:\"Pega o código da vista aquí\";s:38:\"Style plugin @plugin is not available.\";s:48:\"O plugin de estilo @plugin no está dispoñíbel\";s:22:\"Unable to import view.\";s:33:\"Non é posíbel importar a vista.\";s:45:\"Click on an item to edit that item\'s details.\";s:58:\"Preme en un elemento para editar os detalles do elementos.\";s:36:\"Go to the real page for this display\";s:44:\"Ir á verdadeira páxina desta presentación\";s:30:\"Change settings for this style\";s:36:\"Cambiar os axustes para este estilo.\";s:15:\"Rearrange @type\";s:15:\"Reordenar @type\";s:56:\"Show other queries run during render during live preview\";s:71:\"Mostrar outras consultas executadas mentres se preparaba a vista previa\";s:25:\"Error: missing @component\";s:24:\"Erro: @component perdido\";s:27:\"The comment ID of the field\";s:27:\"O ID do comentario do campo\";s:42:\"Provide a simple link to view the comment.\";s:50:\"Provee unha ligazón simple para ver o comentario.\";s:42:\"Provide a simple link to edit the comment.\";s:53:\"Provee unha ligazón simple para editar o comentario.\";s:44:\"Provide a simple link to delete the comment.\";s:54:\"Provee unha ligazón simple para eliminar o comentario\";s:36:\"The User ID of the comment\'s author.\";s:39:\"O ID de usuario do autor do comentario.\";s:10:\"Parent CID\";s:7:\"CID pai\";s:37:\"The Comment ID of the parent comment.\";s:37:\"O ID de comentario do comentario pai.\";s:17:\"Last comment time\";s:26:\"Data do último comentario\";s:50:\"Date and time of when the last comment was posted.\";s:56:\"Data e hora de cando foi publicado o último comentario.\";s:19:\"Last comment author\";s:27:\"Autor do último comentario\";s:50:\"The name of the author of the last posted comment.\";s:47:\"O nome do autor do último comentario publicado\";s:34:\"The number of comments a node has.\";s:40:\"O número de comentario que ten un nodo.\";s:39:\"The number of new comments on the node.\";s:39:\"O número de novos comentarios do nodo.\";s:14:\"Comment status\";s:22:\"Estado dos comentarios\";s:53:\"Whether comments are enabled or disabled on the node.\";s:58:\"Se os comentario están activados ou desactivados no nodo.\";s:24:\"User posted or commented\";s:26:\"Usuario envío ou comentou\";s:70:\"Display nodes only if a user posted the node or commented on the node.\";s:69:\"Mostra os nodos sóamente si un usuario envíou o nodo ou o comentou.\";s:13:\"Locale source\";s:25:\"Orixe de regionalización\";s:3:\"LID\";s:3:\"LID\";s:32:\"The group the translation is in.\";s:34:\"O grupo no que está a tradución.\";s:25:\"The full original string.\";s:26:\"A cadea orixinal completa.\";s:51:\"The version of Drupal core that this string is for.\";s:57:\"A versión do núcleo de Drupal para o que é esta cadea.\";s:47:\"Provide a simple link to edit the translations.\";s:49:\"Provee unha ligazón para editar as traduccións.\";s:13:\"Locale target\";s:27:\"Destino de regionalización\";s:28:\"The full translation string.\";s:32:\"A cadea de traducción completa.\";s:36:\"The language this translation is in.\";s:36:\"A lingua na que está a traducción.\";s:12:\"Singular LID\";s:12:\"LID singular\";s:41:\"Whether or not the translation is plural.\";s:33:\"Si a tradución é plural ou non.\";s:18:\"Published or admin\";s:25:\"Publicado ou administrado\";s:20:\"Created year + month\";s:18:\"Creado o ano + mes\";s:12:\"Created year\";s:16:\"Ano de creación\";s:13:\"Created month\";s:10:\"Mes creado\";s:11:\"Created day\";s:11:\"Día creado\";s:12:\"Created week\";s:13:\"Semana creada\";s:20:\"Updated year + month\";s:26:\"Ano + mes de modificación\";s:12:\"Updated year\";s:20:\"Ano de modificación\";s:13:\"Updated month\";s:20:\"Mes de modificación\";s:11:\"Updated day\";s:21:\"Día de modificación\";s:12:\"Updated week\";s:23:\"Semana de modificación\";s:3:\"Vid\";s:3:\"Vid\";s:54:\"The log message entered when the revision was created.\";s:55:\"A mensaxe de rexistro que se fixo ao crear a revisión.\";s:11:\"Revert link\";s:17:\"Revertir o enlace\";s:48:\"Provide a simple link to revert to the revision.\";s:55:\"Proporciona un enlace directo para volver á revisión.\";s:17:\"Filter by access.\";s:18:\"Filtrar por acceso\";s:15:\"Has new content\";s:16:\"Ten novo contido\";s:10:\"Links from\";s:14:\"Ligazón desde\";s:42:\"Other nodes that are linked from the node.\";s:37:\"Outros nodos ligados desde este nodo.\";s:8:\"Links to\";s:10:\"Ligazón a\";s:34:\"Other nodes that link to the node.\";s:37:\"Outros nodos que ligan con este nodo.\";s:12:\"Search Terms\";s:19:\"Termos de Búsqueda\";s:24:\"The terms to search for.\";s:19:\"Os termos a buscar.\";s:19:\"The ID of the file.\";s:17:\"O ID do ficheiro.\";s:21:\"The name of the file.\";s:19:\"O nome do ficheiro.\";s:21:\"The path of the file.\";s:19:\"A ruta do ficheiro.\";s:26:\"The mime type of the file.\";s:24:\"O tipo mime do ficheiro.\";s:23:\"The status of the file.\";s:21:\"O estado do ficheiro.\";s:31:\"The date the file was uploaded.\";s:33:\"A data que o ficheiro foi subido.\";s:19:\"Taxonomy term name.\";s:28:\"Nome de termo da taxonomía.\";s:28:\"The parent term of the term.\";s:21:\"O termo pai do termo.\";s:16:\"Node translation\";s:18:\"Tradución do nodo\";s:18:\"Source translation\";s:19:\"Orixe de tradución\";s:49:\"The source that this content was translated from.\";s:43:\"O orixinal do que se traduciu este contido.\";s:11:\"The user ID\";s:15:\"A ID do usuario\";s:24:\"The user or author name.\";s:27:\"O nome do usuario ou autor.\";s:20:\"Language of the user\";s:17:\"Lingua do usuario\";s:31:\"The user\'s picture, if allowed.\";s:39:\"A imaxe do usuario, se está permitida.\";s:30:\"The date the user was created.\";s:32:\"A data que o usuario foi creado.\";s:28:\"The user\'s last access date.\";s:36:\"A última data de acceso do usuario.\";s:27:\"The user\'s last login date.\";s:47:\"A última data de inicio de sesión do usuario.\";s:36:\"Whether a user is active or blocked.\";s:40:\"Se un usuario está activo ou bloqueado.\";s:21:\"The user\'s signature.\";s:22:\"A sinatura do usuario.\";s:39:\"Provide a simple link to edit the user.\";s:50:\"Provee unha ligazón simple para editar o usuario.\";s:29:\"Roles that a user belongs to.\";s:29:\"Roles asignados a un usuario.\";s:28:\"Randomize the display order.\";s:32:\"Orde de presentación aleatorio.\";s:4:\"Null\";s:4:\"Null\";s:28:\"Provide custom text or link.\";s:47:\"Provee un texto personalizado ou unha ligazón.\";s:19:\"View result counter\";s:26:\"Ver contador de resultados\";s:23:\"Current user\'s language\";s:24:\"Lingua do usuario actual\";s:21:\"Default site language\";s:27:\"Lingua predefinida do sitio\";s:11:\"No language\";s:10:\"Sen lingua\";s:28:\"Node IDs separated by , or +\";s:34:\"IDs dos nodos separados por , ou +\";s:41:\"Link this field to its taxonomy term page\";s:39:\"Liga este campo á páxina do seu termo\";s:25:\"Limit terms by vocabulary\";s:33:\"Limitar os termos por vocabulario\";s:28:\"Term IDs separated by , or +\";s:34:\"IDs dos termos separados por, ou +\";s:17:\"PHP validate code\";s:19:\"Validar código PHP\";s:44:\"Change the title that this display will use.\";s:51:\"Cambiar o título que vai usar esta visualización.\";s:8:\"Use AJAX\";s:9:\"Usar AJAX\";s:49:\"Change whether or not this display will use AJAX.\";s:43:\"Cambiar se esta visualización usará AJAX.\";s:45:\"Specify access control type for this display.\";s:65:\"Especificar o tipo de control de acceso para esta visualización.\";s:37:\"Change settings for this access type.\";s:44:\"Cambiar os axustes para este tipo de acceso.\";s:21:\"Exposed form in block\";s:32:\"Expoñer o formulario nun bloque\";s:34:\"Display even if view has no result\";s:47:\"Amosar incluso si esta vista non ten resultados\";s:30:\"How should this view be styled\";s:33:\"Cal debe ser o estilo desta vista\";s:13:\"Style options\";s:18:\"Opcións de estilo\";s:14:\"Display output\";s:14:\"Amosar a saida\";s:12:\"Style output\";s:16:\"Estilo de saída\";s:16:\"Row style output\";s:24:\"Saída do estilo de fila\";s:22:\"Field @field (ID: @id)\";s:22:\"Campo @field (ID: @id)\";s:12:\"Change theme\";s:14:\"Cambiar o tema\";s:35:\"File found in folder @template-path\";s:43:\"Ficheiro atopado no cartafol @template-path\";s:7:\"No menu\";s:9:\"Sen menú\";s:33:\"The menu path or URL of this view\";s:34:\"A ruta do menú ou URL desta vista\";s:52:\"\"%\" may not be used for the first segment of a path.\";s:59:\"\"%\" non pode ser usado como o primeiro segmento dunha ruta.\";s:30:\"Display record count with link\";s:36:\"Amosar conta de rexistros con enlace\";s:35:\"Override number of items to display\";s:45:\"Sobreescribir o número de elementos a amosar\";s:20:\"Display items inline\";s:25:\"Amosar elementos en liña\";s:21:\"Allow multiple values\";s:27:\"Permitir múltiples valores\";s:18:\"Standard deviation\";s:21:\"Desviación estándar\";s:15:\"Sort descending\";s:30:\"Ordenar de maneira descendente\";s:14:\"Sort ascending\";s:28:\"Ordenar de maneira ascedente\";s:20:\"Administrative title\";s:22:\"Título administrativo\";s:14:\"Style settings\";s:24:\"Configuración do estilo\";s:14:\"@label (!name)\";s:14:\"@label (!name)\";s:17:\"(first item is 0)\";s:26:\"(o primeiro elemento é 0)\";s:24:\"(start from last values)\";s:31:\"(comezar desde o último valor)\";s:15:\"@argument title\";s:20:\"Título de @argument\";s:15:\"@argument input\";s:20:\"Entrada de @argument\";s:51:\"The maximum number of characters this field can be.\";s:56:\"O número máximo de caracteres que este campo pode ter.\";s:27:\"Count the number 0 as empty\";s:31:\"Contar o número 0 como valeiro\";s:13:\"Hide if empty\";s:24:\"Ocultar se está valeiro\";s:14:\"Starting value\";s:13:\"Valor inicial\";s:47:\"Specify the number the counter should start at.\";s:56:\"Especificar o numero co que o contador debería comezar.\";s:30:\"The view %name has been saved.\";s:23:\"Gardouse a vista %name.\";s:41:\"Hostname of user that posted the comment.\";s:50:\"Nome do equipo do usuario que enviou o comentario.\";s:12:\"Exposed form\";s:18:\"Formulario exposto\";s:69:\"The label for this area that will be displayed only administratively.\";s:71:\"A etiqueta para esta área que se amosará só de forma administrativa.\";s:29:\"Operator to use on all groups\";s:37:\"Operador para usar en todos os grupos\";s:19:\"Remove group @group\";s:21:\"Quitar o grupo @group\";s:13:\"Default group\";s:19:\"Grupos predefinidos\";s:12:\"Group @group\";s:12:\"Grupo @group\";s:28:\"The taxonomy vocabulary name\";s:35:\"O nome do vocabulario da taxonomía\";s:10:\"Name (raw)\";s:12:\"Nome (crudo)\";s:33:\"Provide markup text for the area.\";s:45:\"Proporcionar o texto de marcado para a área.\";s:12:\"Machine Name\";s:15:\"Nome de sistema\";s:18:\"Exposed form style\";s:28:\"Estilo do formulario exposto\";s:9:\"All items\";s:18:\"Todos os elementos\";s:22:\"Group results together\";s:18:\"Agrupar resultados\";s:21:\"Authentication module\";s:27:\"Módulo de autentificación\";s:14:\"Update preview\";s:30:\"Vista previa da actualización\";s:39:\"Provide a simple link to edit the term.\";s:41:\"Prover unha ligazón para editar o termo.\";s:13:\"Enabled, name\";s:14:\"Activado, nome\";s:15:\"- Use default -\";s:23:\"- Usar predeterminado -\";s:12:\"HTML element\";s:13:\"Elemento HTML\";s:29:\"Place a colon after the label\";s:41:\"Poñer os dous puntos despois da etiqueta\";s:19:\"Add default classes\";s:27:\"Engadir clases predefinidas\";s:17:\"Use absolute path\";s:18:\"Usar ruta absoluta\";s:14:\"Field Language\";s:15:\"Idioma de campo\";s:14:\"Machine name: \";s:17:\"Nome de sistema: \";s:13:\"Edit @section\";s:15:\"Editar @section\";s:48:\"When the filter value is <em>NOT</em> in the URL\";s:49:\"Cando o valor do filtro <em>NON</em> está na URL\";s:15:\"Exception value\";s:19:\"Valor da excepción\";s:13:\"Provide title\";s:20:\"Proporcionar título\";s:19:\"Override breadcrumb\";s:38:\"Sobrescribir migas de pan (breadcrumb)\";s:18:\"Provide breadcrumb\";s:38:\"Proporcionar migas de pan (breadcrumb)\";s:27:\"Specify validation criteria\";s:36:\"Especificar criterios de validación\";s:48:\"Action to take if filter value does not validate\";s:59:\"Acción a tomar se o valor do filtro non pasa a validación\";s:43:\"Display all results for the specified field\";s:52:\"Mostra todos os resultados para o campo especificado\";s:21:\"Provide default value\";s:33:\"Proporcionar valor predeterminado\";s:21:\"Show \"Page not found\"\";s:28:\"Amosar \"Páxina non atopada\"\";s:17:\"Display a summary\";s:16:\"Amosar un resumo\";s:38:\"Display contents of \"No results found\"\";s:48:\"Amosar contido de «Non se atoparon resultados»\";s:34:\"Skip default argument for view URL\";s:51:\"Saltar argumento predeterminado para o URL da vista\";s:14:\"Create a label\";s:19:\"Crear unha etiqueta\";s:40:\"Enable to create a label for this field.\";s:48:\"Active para crear unha etiqueta para este campo.\";s:15:\"Rewrite results\";s:21:\"Reescribir resultados\";s:26:\"Replace spaces with dashes\";s:29:\"Remprazar espazos con guións\";s:19:\"External server URL\";s:23:\"URL de servidor externo\";s:13:\"Expose filter\";s:15:\"Expoñer filtro\";s:58:\"Enable to hide items that do not contain this relationship\";s:62:\"Active para ocultar elementos que non conteñen esta relación\";s:68:\"This sort is not exposed. Expose it to allow the users to change it.\";s:75:\"Esta orde non está exposto. Expóñao para permitir aos usuarios cambialo.\";s:11:\"Expose sort\";s:13:\"Expoñer orde\";s:19:\"Provide description\";s:24:\"Proporcionar descrición\";s:22:\"Update \"@title\" choice\";s:29:\"Actualizar opción «@title»\";s:32:\"Update \"@title\" choice (@number)\";s:39:\"Actualizar opción «@title» (@number)\";s:61:\"Modify the display(s) of your view below or add new displays.\";s:83:\"Modificar as visualizacións da súa vista abaixo ou engadir novas visualizacións.\";s:26:\"edit view name/description\";s:32:\"editar nome/descrición da vista\";s:22:\"@display_title details\";s:26:\"Detalles de @display_title\";s:12:\"Auto preview\";s:29:\"Previsualización automática\";s:32:\"Preview with contextual filters:\";s:43:\"Previsualización con filtros contextuales:\";s:68:\"Separate contextual filter values with a \"/\". For example, %example.\";s:76:\"Separe os valores dos filtros contextuales cun «/». Por exemplo, %example.\";s:1:\":\";s:1:\":\";s:18:\"Apply and continue\";s:19:\"Aplicar e continuar\";s:18:\"@current of @total\";s:18:\"@current de @total\";s:32:\"All displays (except overridden)\";s:49:\"Todas as presentacións (excepto as sobrescritas)\";s:12:\"All displays\";s:23:\"Todas as presentacións\";s:29:\"This @display_type (override)\";s:33:\"Este @display_type (sobrescribir)\";s:23:\"Create new filter group\";s:27:\"Crear novo grupo de filtros\";s:20:\"Drag to add filters.\";s:30:\"Arrastre para agregar filtros.\";s:24:\"Add and configure @types\";s:27:\"Agregar e configurar @types\";s:22:\"Configure @type: @item\";s:23:\"Configurar @type: @item\";s:17:\"Above the preview\";s:22:\"Arriba da vista previa\";s:17:\"Below the preview\";s:22:\"Abaixo da vista previa\";s:12:\"The node ID.\";s:11:\"ID do nodo.\";s:34:\"Load default filter from term page\";s:49:\"Cargar filtro predeterminado da páxina de térmo\";s:36:\"Change the way content is formatted.\";s:47:\"Cambiar o xeito en que se da formato o contido.\";s:27:\"Hide attachments in summary\";s:26:\"Ocultar adxuntos no resumo\";s:67:\"You may also adjust the !settings for the currently selected style.\";s:72:\"Tamén pode axustar as !settings para o estilo seleccionado actualmente.\";s:67:\"You may also adjust the !settings for the currently selected pager.\";s:75:\"Tamén pode axustar as !settings para o paxinador seleccionado actualmente.\";s:11:\"All storage\";s:20:\"Todo o almacenamento\";s:10:\"All status\";s:16:\"Todos os estados\";s:7:\"No tags\";s:13:\"Sin etiquetas\";s:35:\"No views match the search criteria.\";s:47:\"Ninguna vista coincide cos criterios de búsca.\";s:13:\"Create a page\";s:18:\"Crear unha páxina\";s:18:\"Create a menu link\";s:24:\"Crear un enlace de menú\";s:19:\"Include an RSS feed\";s:20:\"Incluír un Feed RSS\";s:9:\"Feed path\";s:17:\"Ruta da fonte web\";s:14:\"Feed row style\";s:32:\"Estilo da fila do canle de novas\";s:14:\"Create a block\";s:15:\"Crear un bloque\";s:7:\"of type\";s:7:\"de tipo\";s:11:\"tagged with\";s:14:\"etiquetado con\";s:13:\"without links\";s:11:\"sin enlaces\";s:7:\"teasers\";s:8:\"resúmos\";s:10:\"full posts\";s:17:\"envíos completos\";s:6:\"titles\";s:8:\"títulos\";s:15:\"titles (linked)\";s:21:\"títulos (con enlace)\";s:41:\"Should links be displayed below each node\";s:51:\"No caso de enlaces aparecerán debaixo de cada nodo\";s:46:\"with links (allow users to add comments, etc.)\";s:63:\"con enlaces (permitindo os usuarios escribir comentarios, etc.)\";s:44:\"Should comments be displayed below each node\";s:56:\"En caso de comentarios mostraránse debaixo de cada nodo\";s:9:\"Hide view\";s:13:\"Ocultar vista\";s:8:\"Unsorted\";s:11:\"Sen ordenar\";s:20:\"Customize field HTML\";s:22:\"Personaliza campo HTML\";s:23:\"Hide rewriting if empty\";s:36:\"Ocultar reescritura se está valeiro\";s:56:\"Do not display rewritten content if this field is empty.\";s:57:\"Non amosar contido reescrito se este campo está valeiro.\";s:20:\"clone @display_title\";s:21:\"clonar @display_title\";s:21:\"delete @display_title\";s:23:\"eliminar @display_title\";s:22:\"disable @display_title\";s:25:\"desactivar @display_title\";s:21:\"Appears in: @bundles.\";s:20:\"Aparece en @bundles.\";s:29:\"Delta - Appears in: @bundles.\";s:29:\"Delta - Aparece en: @bundles.\";s:13:\"Query Comment\";s:22:\"Comentario da consulta\";s:14:\"Count DISTINCT\";s:14:\"Count DISTINCT\";s:17:\"Revert to default\";s:23:\"Volver ao valor inicial\";s:11:\"Use a pager\";s:17:\"Usar unha páxina\";s:23:\"Display \"Access Denied\"\";s:24:\"Amosar \"Acceso denegado\"\";s:2:\"of\";b:1;s:40:\"Configure extra settings for @type %item\";b:1;s:22:\"Updated/commented date\";b:1;s:60:\"The most recent of last comment posted or node updated time.\";b:1;s:73:\"A source string for translation, in English or the default site language.\";b:1;s:28:\"The ID of the source string.\";b:1;s:55:\"A description of the location or context of the string.\";b:1;s:33:\"The ID of the parent translation.\";b:1;s:47:\"Files maintained by Drupal and various modules.\";b:1;s:37:\"Taxonomy terms are attached to nodes.\";b:1;s:21:\"The term weight field\";b:1;s:48:\"The description associated with a taxonomy term.\";b:1;s:66:\"Filter the results of \"Taxonomy: Term\" to a particular vocabulary.\";b:1;s:23:\"Translation set node ID\";b:1;s:53:\"The ID of the translation set the content belongs to.\";b:1;s:43:\"Versions of content in different languages.\";b:1;s:17:\"Child translation\";b:1;s:8:\"Outdated\";b:1;s:47:\"Displays the actual position of the view result\";b:1;s:44:\"Also look for a node and use the node author\";b:1;s:23:\"Only allow numeric UIDs\";b:1;s:27:\"Only allow string usernames\";b:1;s:44:\"Allow both numeric UIDs and string usernames\";b:1;s:27:\"Restrict user based on role\";b:1;s:30:\"Restrict to the selected roles\";b:1;s:62:\"If no roles are selected, users from any role will be allowed.\";b:1;s:36:\"Change this display\'s pager setting.\";b:1;s:56:\"Specify whether this display will provide a \"more\" link.\";b:1;s:38:\"Specify caching type for this display.\";b:1;s:12:\"Link display\";b:1;s:64:\"Allow the exposed form to appear in a block instead of the view.\";b:1;s:44:\"Get information on how to theme this display\";b:1;s:21:\"Rescan template files\";b:1;s:7:\"In code\";b:1;s:13:\"Taxonomy Term\";b:1;s:13:\"revision user\";b:1;s:9:\"Entity ID\";b:1;s:40:\"Change the machine name of this display.\";b:1;s:36:\"Change settings for this pager type.\";b:1;s:55:\"Allow grouping and aggregation (calculation) of fields.\";b:1;s:41:\"Select the kind of exposed filter to use.\";b:1;s:50:\"Exposed form settings for this exposed form style.\";b:1;s:48:\"Select which pager, if any, to use for this view\";b:1;s:13:\"Pager options\";b:1;s:11:\"In database\";b:1;s:15:\"@entity:@bundle\";b:1;s:23:\"Is not empty (NOT NULL)\";b:1;s:14:\"Translate link\";b:1;s:44:\"Provide a simple link to translate the node.\";b:1;s:10:\"Authmap ID\";b:1;s:15:\"The Authmap ID.\";b:1;s:19:\"Authentication name\";b:1;s:31:\"The unique authentication name.\";b:1;s:57:\"The name of the module managing the authentication entry.\";b:1;s:64:\"Change the CSS class name(s) that will be added to this display.\";b:1;s:11:\"Choose text\";b:1;s:66:\"The text that will appear as the selected option in the jump menu.\";b:1;s:14:\"Term edit link\";b:1;s:20:\"Unknown content type\";b:1;s:32:\"The name of the item; e.g. node.\";b:1;s:60:\"The type of the item, either module, theme, or theme_engine.\";b:1;s:55:\"Boolean indicating whether or not this item is enabled.\";b:1;s:14:\"Schema version\";b:1;s:11:\"View: !view\";b:1;s:19:\"Human-readable name\";b:1;s:18:\"Label HTML element\";b:1;s:20:\"Wrapper HTML element\";b:1;s:8:\"Rel Text\";b:1;s:21:\"Preserve certain tags\";b:1;s:46:\"Date and time of when the comment was created.\";b:1;s:51:\"Date and time of when the comment was last updated.\";b:1;s:67:\"Whether the comment is approved (or still in the moderation queue).\";b:1;s:16:\"Approved comment\";b:1;s:16:\"Last comment CID\";b:1;s:34:\"Display the last comment of a node\";b:1;s:12:\"Last Comment\";b:1;s:27:\"The last comment of a node.\";b:1;s:10:\"File Usage\";b:1;s:19:\"Taxonomy Vocabulary\";b:1;s:43:\"The module managing this file relationship.\";b:1;s:47:\"The type of entity that is related to the file.\";b:1;s:52:\"The number of times the file is used by this entity.\";b:1;s:21:\"term from !field_name\";b:1;s:15:\"Math expression\";b:1;s:52:\"Evaluates a mathematical expression and displays it.\";b:1;s:30:\"Term name converted to Term ID\";b:1;s:10:\"No comment\";b:1;s:33:\"Comment or document this display.\";b:1;s:14:\"Query settings\";b:1;s:56:\"Allow to set some advanced settings for the query plugin\";b:1;s:13:\"Query options\";b:1;s:21:\"Disable SQL rewriting\";b:1;s:16:\"Use Slave Server\";b:1;s:12:\"Approve link\";b:1;s:14:\"Content access\";b:1;s:72:\"If this value is received, the filter will be ignored; i.e, \"all values\"\";b:1;s:69:\"When the filter value <em>IS</em> in the URL or a default is provided\";b:1;s:17:\"Number of records\";b:1;s:68:\"Choose the HTML element to wrap around this field, e.g. H1, H2, etc.\";b:1;s:18:\"Create a CSS class\";b:1;s:68:\"Choose the HTML element to wrap around this label, e.g. H1, H2, etc.\";b:1;s:58:\"Enable to trim the field to a maximum length of characters\";b:1;s:40:\"Convert newlines to HTML &lt;br&gt; tags\";b:1;s:15:\"No results text\";b:1;s:70:\"This filter is not exposed. Expose it to allow the users to change it.\";b:1;s:11:\"Save & exit\";b:1;s:15:\"Continue & edit\";b:1;s:24:\"Database overriding code\";b:1;s:12:\"analyze view\";b:1;s:10:\"clone view\";b:1;s:11:\"export view\";b:1;s:11:\"revert view\";b:1;s:11:\"delete view\";b:1;s:12:\"Add !display\";b:1;s:25:\"View name and description\";b:1;s:67:\"A descriptive human-readable name for this view. Spaces are allowed\";b:1;s:27:\"No filters have been added.\";b:1;s:33:\"Show filters on the list of views\";b:1;s:26:\"Show advanced help warning\";b:1;s:30:\"Always show the master display\";b:1;s:37:\"Always show advanced display settings\";b:1;s:67:\"Label for \"Any\" value on non-required single-select exposed filters\";b:1;s:21:\"Live preview settings\";b:1;s:39:\"Automatically update preview on changes\";b:1;s:66:\"Show information and statistics about the view during live preview\";b:1;s:18:\"Show the SQL query\";b:1;s:27:\"Show performance statistics\";b:1;s:47:\"The content to which the comment is a reply to.\";b:1;s:18:\"The content title.\";b:1;s:32:\"The date the content was posted.\";b:1;s:38:\"The date the content was last updated.\";b:1;s:73:\"The content type (for example, \"blog entry\", \"forum post\", \"story\", etc).\";b:1;s:40:\"Whether or not the content is published.\";b:1;s:67:\"Filters out unpublished content if the current user cannot view it.\";b:1;s:57:\"Whether or not the content is promoted to the front page.\";b:1;s:37:\"Whether or not the content is sticky.\";b:1;s:37:\"Provide a simple link to the content.\";b:1;s:42:\"Provide a simple link to edit the content.\";b:1;s:44:\"Provide a simple link to delete the content.\";b:1;s:33:\"The aliased path to this content.\";b:1;s:42:\"Relate content to the user who created it.\";b:1;s:19:\"User has a revision\";b:1;s:45:\"All nodes where a certain user has a revision\";b:1;s:16:\"Content revision\";b:1;s:52:\"Content revision is a history of changes to content.\";b:1;s:63:\"Relate a content revision to the user who created the revision.\";b:1;s:40:\"The revision ID of the content revision.\";b:1;s:47:\"Get the actual content from a content revision.\";b:1;s:53:\"Provide a simple link to delete the content revision.\";b:1;s:47:\"Show a marker if the content is new or updated.\";b:1;s:41:\"Show only content that is new or updated.\";b:1;s:25:\"Module/Theme/Theme engine\";b:1;s:46:\"Modules/Themes/Theme engines in your codebase.\";b:1;s:34:\"Module/Theme/Theme engine filename\";b:1;s:30:\"Module/Theme/Theme engine name\";b:1;s:54:\"Content that is a translation of a source translation.\";b:1;s:16:\"Content authored\";b:1;s:41:\"Provide a simple link to cancel the user.\";b:1;s:35:\"Provide serialized data of the user\";b:1;s:9:\"View area\";b:1;s:29:\"Insert a view inside an area.\";b:1;s:38:\"Enable to override this field\'s links.\";b:1;s:18:\"Use field template\";b:1;s:23:\"Multiple field settings\";b:1;s:34:\"Display all values in the same row\";b:1;s:23:\"Display @count value(s)\";b:1;s:11:\"Raw @column\";b:1;s:48:\"Link this field to the original piece of content\";b:1;s:50:\"Choose one or more content types to validate with.\";b:1;s:39:\"Validate user has access to the content\";b:1;s:25:\"Access operation to check\";b:1;s:19:\"Filter value format\";b:1;s:17:\"Filter value type\";b:1;s:60:\"Transform dashes in URL to spaces in term name filter values\";b:1;s:34:\"Type of user filter value to allow\";b:1;s:26:\"PHP contextual filter code\";b:1;s:31:\"Change settings for this format\";b:1;s:46:\"Change the way each row in the view is styled.\";b:1;s:13:\"Block caching\";b:1;s:24:\"@group (historical data)\";b:1;s:14:\"Use path alias\";b:1;s:41:\"Use replacement tokens from the first row\";b:1;s:45:\"Allow multiple filter values to work together\";b:1;s:73:\"You may use token substitutions from the rewriting section in this class.\";b:1;s:20:\"Customize label HTML\";b:1;s:38:\"Customize field and label wrapper HTML\";b:1;s:17:\"Remove whitespace\";b:1;s:58:\"Expose this filter to visitors, to allow them to change it\";b:1;s:56:\"Expose this sort to visitors, to allow them to change it\";b:1;s:16:\"reorder displays\";b:1;s:13:\"view @display\";b:1;s:47:\"The node ID to which the comment is a reply to.\";b:1;s:20:\"Comments of the node\";b:1;s:14:\"@group: @field\";b:1;s:32:\"@group (historical data): @field\";b:1;s:22:\"@label (!name:!column)\";b:1;s:14:\"@label:!column\";b:1;s:20:\"@label (!name:delta)\";b:1;s:12:\"@label:delta\";b:1;s:17:\"User who uploaded\";b:1;s:32:\"The user that uploaded the file.\";b:1;s:35:\"The taxonomy vocabulary description\";b:1;s:56:\"Taxonomy term chosen from autocomplete or select widget.\";b:1;s:19:\"Representative node\";b:1;s:23:\"The taxonomy term name.\";b:1;s:17:\"Content with term\";b:1;s:38:\"Relate all content tagged with a term.\";b:1;s:20:\"Has taxonomy term ID\";b:1;s:54:\"Display content if it has the selected taxonomy terms.\";b:1;s:17:\"Has taxonomy term\";b:1;s:22:\"Taxonomy terms on node\";b:1;s:18:\"All taxonomy terms\";b:1;s:33:\"Has taxonomy term ID (with depth)\";b:1;s:31:\"Has taxonomy terms (with depth)\";b:1;s:35:\"Has taxonomy term ID depth modifier\";b:1;s:20:\"@entity using @field\";b:1;s:50:\"Relate each @entity with a @field set to the term.\";b:1;s:11:\"!field_name\";b:1;s:14:\"Path component\";b:1;s:15:\"Use aggregation\";b:1;s:47:\"When the filter value is <em>NOT</em> available\";b:1;s:68:\"When the filter value <em>IS</em> available or a default is provided\";b:1;s:53:\"The number of items to display. Enter 0 for no limit.\";b:1;s:52:\"The contextual filter values is provided by the URL.\";b:1;s:58:\"When needed, add the field language condition to the query\";b:1;s:20:\"Hide the \"Go\" button\";b:1;s:42:\"Select the current contextual filter value\";b:1;s:21:\"file from !field_name\";b:1;s:62:\"Specify which display or custom url this display will link to.\";b:1;s:18:\"Transform the case\";b:1;s:71:\"When printing url paths, how to transform the case of the filter value.\";b:1;s:17:\"And/Or, Rearrange\";b:1;s:35:\"Custom admin theme for the Views UI\";b:1;s:45:\"Provide a simple link to approve the comment.\";b:1;s:10:\"Author uid\";b:1;s:50:\"Relate each @entity with a @field set to the file.\";b:1;s:22:\"image from !field_name\";b:1;s:51:\"Relate each @entity with a @field set to the image.\";b:1;s:27:\"The tid of a taxonomy term.\";b:1;s:21:\"The user permissions.\";b:1;s:19:\"First and last only\";b:1;s:23:\"Multiple-value handling\";b:1;s:36:\"Filter to items that share all terms\";b:1;s:35:\"Filter to items that share any term\";b:1;s:29:\"Date in the form of CCYYMMDD.\";b:1;s:27:\"Date in the form of YYYYMM.\";b:1;s:25:\"Date in the form of YYYY.\";b:1;s:33:\"Date in the form of MM (01 - 12).\";b:1;s:33:\"Date in the form of DD (01 - 31).\";b:1;s:33:\"Date in the form of WW (01 - 53).\";b:1;s:73:\"If you need more fields than the uid add the comment: author relationship\";b:1;s:16:\"Last comment uid\";b:1;s:56:\"The User ID of the author of the last comment of a node.\";b:1;s:39:\"Convert spaces in term names to hyphens\";b:1;s:61:\"This allows links to work with Views taxonomy term arguments.\";b:1;s:57:\"Replace an existing view if one exists with the same name\";b:1;s:34:\"Provide a simple link to the user.\";b:1;s:14:\"Result summary\";b:1;s:53:\"Shows result summary, for example the items per page.\";b:1;s:42:\"Add a read-more link if output is trimmed.\";b:1;s:33:\"Show the embed display in the ui.\";b:1;s:16:\"Contextual Links\";b:1;s:42:\"Display fields in a contextual links menu.\";b:1;s:22:\"Bypass view validation\";b:1;s:71:\"Bypass the validation of plugins and handlers when importing this view.\";b:1;s:31:\"The language the comment is in.\";b:1;s:12:\"- No value -\";b:1;s:38:\"Provide a simple link to the revision.\";b:1;s:49:\"The ID of the entity that is related to the file.\";b:1;s:30:\"The taxonomy vocabulary weight\";b:1;s:57:\"Filter the results of \"Taxonomy: Term\" by the parent pid.\";b:1;s:24:\"The raw numeric user ID.\";b:1;s:15:\"Unfiltered text\";b:1;s:21:\"Combine fields filter\";b:1;s:47:\"Combine two fields together and search by them.\";b:1;s:29:\"Column used for click sorting\";b:1;s:40:\"Use path alias instead of internal path.\";b:1;s:21:\"Hide contextual links\";b:1;s:64:\"Change whether or not to display contextual links for this view.\";b:1;s:21:\"View: !view: !display\";b:1;s:13:\"Pure Distinct\";b:1;s:10:\"Query Tags\";b:1;s:41:\"The revision NID of the content revision.\";b:1;s:14:\"Selector label\";b:1;s:32:\"Set this field to display inline\";b:1;s:17:\"Fields comparison\";b:1;s:42:\"Compare database fields against eachother.\";b:1;s:55:\"Use fields comparison to filter the result of the view.\";b:1;s:30:\"Displays messages in the area.\";b:1;s:20:\"Reverse the counter.\";b:1;s:4:\"Font\";s:5:\"Fonte\";s:3:\"Top\";s:8:\"Superior\";s:6:\"Bottom\";s:6:\"Botón\";s:5:\"Flash\";s:5:\"Flash\";s:6:\"Smiley\";s:6:\"Smiley\";s:11:\"Basic setup\";s:22:\"Configuración básica\";s:29:\"Allow users to choose default\";s:48:\"Permitir os usuarios elexir o editor predefinido\";s:19:\"Buttons and plugins\";s:21:\"Botóns e extensións\";s:17:\"Editor appearance\";s:19:\"Aparencia do editor\";s:16:\"Toolbar location\";s:34:\"Ubicación da barra de ferramentas\";s:22:\"Enable resizing button\";s:36:\"Permitir botón de cambio de tamaño\";s:13:\"Block formats\";s:19:\"Formatos de bloques\";s:18:\"Cleanup and output\";s:25:\"Limpeza e saída de datos\";s:10:\"Editor CSS\";s:10:\"Editor CSS\";s:8:\"CSS path\";s:11:\"Ruta ao CSS\";s:11:\"CSS classes\";s:10:\"Clases CSS\";s:7:\"Replace\";s:10:\"Reemplazar\";s:9:\"Font size\";s:24:\"Tamaño do tipo de letra\";s:11:\"Superscript\";s:12:\"Superíndice\";s:11:\"Show blocks\";s:14:\"Amosar bloques\";s:4:\"Bold\";s:8:\"Negriña\";s:4:\"Copy\";s:6:\"Copiar\";s:4:\"Redo\";s:7:\"Refacer\";s:6:\"Italic\";s:7:\"Cursiva\";s:11:\"Source code\";s:14:\"Código fuente\";s:9:\"Subscript\";s:10:\"Subíndice\";s:6:\"Indent\";s:7:\"Sangrar\";s:7:\"Outdent\";s:16:\"Sangria francesa\";s:6:\"Unlink\";s:11:\"Desvincular\";s:18:\"Interface language\";s:19:\"Idioma da interface\";s:9:\"Underline\";s:10:\"Subliñado\";s:3:\"Cut\";s:6:\"Cortar\";s:5:\"Paste\";s:5:\"Pegar\";s:8:\"Example:\";s:8:\"Exemplo:\";s:12:\"Teaser break\";s:15:\"Final do resumo\";s:18:\"Enabled by default\";s:31:\"Activado de forma prestablecida\";s:50:\"Show <em>enable/disable rich text</em> toggle link\";s:73:\"Amosar enlace alternador de <em>activar/desactivar texto con formato</em>\";s:13:\"Use theme CSS\";s:12:\"Use tema CSS\";s:10:\"Define CSS\";s:11:\"Definir CSS\";s:18:\"Editor default CSS\";s:28:\"CSS predeterminado do editor\";s:43:\"Wysiwyg profile for %format has been saved.\";s:45:\"O perfil de Wysiwyg para %format foi gardado.\";s:17:\"Disable rich-text\";s:28:\"Desactivar texto enriquecido\";s:16:\"Enable rich-text\";s:25:\"Activar texto enriquecido\";s:10:\"Align left\";s:19:\"Aliñar á esquerda\";s:11:\"Align right\";s:18:\"Aliñar á dereita\";s:7:\"Justify\";s:11:\"Xustificado\";s:15:\"Horizontal rule\";s:17:\"Línea horizontal\";s:10:\"Paste Text\";s:11:\"Pegar texto\";s:15:\"Paste from Word\";s:16:\"Pegar dende Word\";s:13:\"Remove format\";s:16:\"Eliminar formato\";s:13:\"Character map\";s:18:\"Mapa de caracteres\";s:17:\"HTML block format\";s:22:\"Formato de bloque HTML\";s:10:\"Font style\";s:15:\"Estilo de fonte\";s:14:\"Check spelling\";s:21:\"Comprobar ortografía\";s:13:\"Left-to-right\";s:18:\"Esquerda a Dereita\";s:13:\"Right-to-left\";s:18:\"Dereita a esquerda\";s:44:\"Separate the teaser and body of this content\";s:39:\"Separar o resumo do corpo deste contido\";s:13:\"Div container\";s:14:\"Div contenedor\";s:8:\"Maximize\";s:9:\"Maximizar\";s:42:\"Text formats enabled for rich-text editing\";s:63:\"Formatos de texto habilitado para edición de texto enriquecido\";s:27:\"%editor profile for %format\";b:1;s:14:\"page not found\";b:1;s:14:\"Strike through\";b:1;s:25:\"Insert/Remove Bullet list\";b:1;s:27:\"Insert/Remove Numbered list\";b:1;s:11:\"Block quote\";b:1;s:6:\"IFrame\";b:1;s:23:\"Spell check as you type\";b:1;s:9:\"Templates\";b:1;s:20:\"Texto longo e resumo\";b:1;s:25:\"Área de texto cun resumo\";b:1;s:11:\"Texto longo\";b:1;s:29:\"Área de texto (varias filas)\";b:1;s:23:\"Administer video styles\";b:1;s:45:\"Create and modify styles for embedded videos.\";b:1;s:11:\"video style\";b:1;s:12:\"video styles\";b:1;s:12:\"Video Styles\";b:1;s:12:\"Video Player\";b:1;s:12:\"URL to Video\";b:1;s:17:\"Thumbnail Preview\";b:1;s:15:\"Video Embedding\";b:1;s:5:\"White\";s:6:\"Branco\";s:4:\"Blue\";s:4:\"Azul\";s:8:\"Autoplay\";s:25:\"Reproducción automática\";s:19:\"Show related videos\";s:29:\"Amosar os videos relacionados\";s:4:\"Note\";b:1;s:4:\"Loop\";b:1;s:4:\"Lime\";b:1;s:6:\"Orange\";b:1;s:5:\"Light\";b:1;s:9:\"Video URL\";b:1;s:4:\"Dark\";b:1;s:21:\"!label of field %name\";b:1;s:17:\"Video Embed Field\";b:1;s:31:\"Video Embed Field configuration\";b:1;s:33:\"Video Embed Field module settings\";b:1;s:18:\"Video Embed Styles\";b:1;s:44:\"Administer Video Embed Field\'s video styles.\";b:1;s:18:\"Youtube v3 API key\";b:1;s:14:\"Enabled, title\";b:1;s:2:\"Up\";b:1;s:4:\"Down\";b:1;s:71:\"This will appear in the administrative interface to easily identify it.\";b:1;s:31:\"The unique ID for this @export.\";b:1;s:12:\"Player Width\";b:1;s:24:\"The width of the player.\";b:1;s:13:\"Player Height\";b:1;s:25:\"The height of the player.\";b:1;s:16:\"Player CSS class\";b:1;s:30:\"CSS class to add to the player\";b:1;s:18:\"@provider settings\";b:1;s:32:\"The width of the youtube player.\";b:1;s:33:\"The height of the youtube player.\";b:1;s:12:\"Player theme\";b:1;s:27:\"Play the video immediately.\";b:1;s:13:\"Video quality\";b:1;s:12:\"Small (240p)\";b:1;s:13:\"Medium (360p)\";b:1;s:12:\"Large (480p)\";b:1;s:7:\"HD 720p\";b:1;s:9:\"HD 10800p\";b:1;s:58:\"Attempt to play the video in certain quality if available.\";b:1;s:56:\"Show related videos after the video is finished playing.\";b:1;s:9:\"Show info\";b:1;s:17:\"Hide Youtube logo\";b:1;s:42:\"Hide the Youtube logo button on the player\";b:1;s:23:\"Show video annotations.\";b:1;s:23:\"Hide video annotations.\";b:1;s:19:\"Display annotations\";b:1;s:20:\"Hide video controls.\";b:1;s:37:\"Show video controls. Youtube default.\";b:1;s:67:\"Show video controls with performance improvement for iframe embeds.\";b:1;s:31:\"Display Youtube player controls\";b:1;s:72:\"This parameter indicates whether the video player controls will display.\";b:1;s:45:\"Autohide progress bar and the player controls\";b:1;s:62:\"Controls the autohide behavior of the youtube player controls.\";b:1;s:30:\"The width of the vimeo player.\";b:1;s:31:\"The height of the vimeo player.\";b:1;s:7:\"Fuschia\";b:1;s:12:\"Player Color\";b:1;s:37:\"The color to use on the vimeo player.\";b:1;s:24:\"Overlay Author Thumbnail\";b:1;s:58:\"Overlay the author\'s thumbnail before the video is played.\";b:1;s:21:\"Overlay Video\'s Title\";b:1;s:53:\"Overlay the video\'s title before the video is played.\";b:1;s:22:\"Overlay Video\'s Byline\";b:1;s:59:\"Overlay the video\'s description before the video is played.\";b:1;s:25:\"Loop the video\'s playback\";b:1;s:25:\"Enable froogaloop support\";b:1;s:42:\"Enables Froogallop Vimeo\'s library support\";b:1;s:17:\"Playback settings\";b:1;s:15:\"Administer IMCE\";s:16:\"Administrar IMCE\";s:10:\"Dimensions\";s:11:\"Dimensións\";s:25:\"Permitted file extensions\";s:34:\"Extensións de ficheiro permitidas\";s:9:\"User role\";s:14:\"Rol de usuario\";s:12:\"Profile name\";s:14:\"Nome do perfil\";s:4:\"IMCE\";s:4:\"IMCE\";s:15:\"Common settings\";s:15:\"Opcións comuns\";s:6:\"Browse\";s:8:\"Explorar\";s:12:\"WIDTHxHEIGHT\";s:10:\"ANCHOxALTO\";s:28:\"Maximum file size per upload\";s:38:\"Tamaño máximo de ficheiro por subida\";s:12:\"File Browser\";s:23:\"Explorador de ficheiros\";s:11:\"Upload file\";s:37:\"Limpar os nomes dos ficheiros subidos\";s:9:\"unlimited\";s:9:\"Ilimitado\";s:24:\"Changes have been saved.\";s:26:\"Os cambios foron gardados.\";s:2:\"MB\";s:2:\"MB\";s:66:\"Your PHP settings limit the maximum file size per upload to %size.\";s:80:\"A configuración de PHP limita o tamaño máximo de ficheiro para subir a %size.\";s:42:\"Control how your image/file browser works.\";s:55:\"Controla cómo funciona o seu explorador de documentos.\";s:55:\"Enable inline image/file insertion into plain textareas\";s:72:\"Permitir a inserción de documentos e imáxes en áreas de texto simple.\";s:10:\"Thumbnails\";s:10:\"Miniaturas\";s:15:\"Add new profile\";s:22:\"Engadir un novo perfil\";s:11:\"Directories\";s:11:\"Directorios\";s:12:\"File browser\";s:23:\"Explorador de ficheiros\";s:22:\"Configuration profiles\";s:25:\"Configuración de perfís\";s:13:\"Absolute URLs\";s:14:\"URLs absolutas\";s:52:\"Check if you want IMCE to return absolute file URLs.\";s:72:\"Márqueo se quere que IMCE proporcione as URLs absolutas dos documentos.\";s:56:\"Default behaviour for existing files during file uploads\";s:85:\"A conducta predefinida para os documentos xa existentes o subir documentos o servidor\";s:43:\"Keep the existing file renaming the new one\";s:49:\"Conservar o documento existente e renomear o novo\";s:44:\"Keep the existing file rejecting the new one\";s:49:\"Conservar o documento existente e rexeitar o novo\";s:42:\"Replace the existing file with the new one\";s:41:\"Remprazar o documento existente polo novo\";s:38:\"Default method for creating thumbnails\";s:48:\"O método predefinido de creación de miniaturas\";s:57:\"Scale the image with respect to the thumbnail dimensions.\";s:56:\"Escalar a imaxe con respecto as dimensiós da miniatura.\";s:64:\"First scale then crop the image to fit the thumbnail dimensions.\";s:84:\"Primeiro escale e logo recorte a imaxe para que encaixe nas dimensións da miniatura\";s:24:\"Role-profile assignments\";s:28:\"Asignacións de rol e perfil\";s:28:\"Give a name to this profile.\";s:32:\"Asigne un nome para este perfil.\";s:15:\"Directory quota\";s:19:\"Cuota de directorio\";s:16:\"Total user quota\";s:22:\"Cuota total do usuario\";s:35:\"Set to * to remove the restriction.\";s:39:\"Poña * para eliminar as restriccións.\";s:37:\"Maximum number of files per operation\";s:44:\"Cantidade máxima de arquivos por operación\";s:24:\"Including subdirectories\";s:24:\"Incluindo subdirectorios\";s:14:\"Directory path\";s:18:\"Ruta do directorio\";s:39:\"The file has been renamed to %filename.\";s:37:\"O arquivo renombrouse como %filename.\";s:38:\"Define the upload quota per directory.\";s:41:\"Definir a cuota de subida por directorio.\";s:32:\"Disable serving of private files\";s:41:\"Desactivar a entrega de arquivos privados\";s:47:\"Display file browser tab in user profile pages.\";s:77:\"Amosar pestana do explorador de archivos nas páxinas de perfís de usuarios.\";s:63:\"Dimensions must be specified in <kbd>WIDTHxHEIGHT</kbd> format.\";s:70:\"As dimensións debense especificar en formato <kbd>ANCHO x ALTO</kbd>.\";s:35:\"Import settings from other profiles\";b:1;s:52:\"%dirname is not accepted as a proper directory name.\";b:1;s:17:\"Create thumbnails\";b:1;s:14:\"Selected files\";b:1;s:14:\"Width x Height\";b:1;s:18:\"Create a new image\";b:1;s:4:\"Tips\";b:1;s:65:\"Select a file by clicking the corresponding row in the file list.\";b:1;s:60:\"Sort the files by clicking a column header of the file list.\";b:1;s:74:\"Resize the work-spaces by dragging the horizontal or vertical resize-bars.\";b:1;s:68:\"Keyboard shortcuts for file list: up, down, left, home, end, ctrl+A.\";b:1;s:72:\"Keyboard shortcuts for directory list: up, down, left, right, home, end.\";b:1;s:11:\"Limitations\";b:1;s:35:\"!num files using !dirsize of !quota\";b:1;s:15:\"unlimited quota\";b:1;s:28:\"%filename has been uploaded.\";b:1;s:24:\"Maximum image dimensions\";b:1;s:44:\"Set to 0 to use the maximum value available.\";b:1;s:24:\"Enable on summary fields\";b:1;s:49:\"Attach the editor to summary fields of textareas.\";b:1;s:56:\"Uses the <a href=\"@url\">@setting</a> setting internally.\";b:1;s:30:\"Apply simple source formatting\";b:1;s:12:\"Paste plugin\";b:1;s:30:\"Settings for the paste plugin.\";b:1;s:25:\"Force paste as plain text\";b:1;s:23:\"Advanced Content Filter\";b:1;s:9:\"Automatic\";b:1;s:13:\"Content Rules\";b:1;s:35:\"Use default toolbar button grouping\";b:1;s:16:\"Download feature\";b:1;s:17:\"Add and configure\";b:1;s:12:\"Save and add\";b:1;s:6:\"Submit\";s:6:\"Enviar\";s:5:\"Write\";b:1;s:7:\"Restore\";b:1;s:7:\"Rebuild\";b:1;s:12:\"@count bytes\";b:1;s:8:\"jsDelivr\";b:1;s:9:\"Bootstrap\";b:1;s:15:\"Bootstrap Theme\";b:1;s:19:\"Informative message\";b:1;s:45:\"Custom configuration and plugins for CKEditor\";b:1;s:33:\"Makes date/time fields available.\";b:1;s:45:\"A Date API that can be used by other modules.\";s:60:\"Unha API  para datas que pode ser usada por outros módulos.\";s:42:\"Examples of migrating with the Date module\";b:1;s:73:\"A Date Repeat API to calculate repeating dates and times from iCal rules.\";b:1;s:52:\"Tools to import and auto-create dates and calendars.\";s:70:\"Ferramentas para importar e crear automaticamente datas e calendarios.\";s:57:\"Views integration for date fields and date functionality.\";b:1;s:55:\"Filter to include videos from Youtube, Google video etc\";b:1;s:37:\"Provides a YouTube widget for fields.\";b:1;s:70:\"Provides Colorbox support to YouTube Field thumbnail display settings.\";b:1;s:9:\"Date/Time\";s:9:\"Data/hora\";s:8:\"Features\";s:15:\"Funcionalidades\";s:13:\"Input filters\";b:1;s:7:\"Youtube\";b:1;s:19:\"Referencia de termo\";b:1;s:43:\"Control de autocompretar termo (etiquetado)\";b:1;s:5:\"Imaxe\";b:1;s:17:\"Date (ISO format)\";b:1;s:21:\"Date (Unix timestamp)\";b:1;s:12:\"Date browser\";s:18:\"Navegador de datas\";s:12:\"Page by date\";s:17:\"Páxinas por data\";s:37:\"Page using the value of a date field.\";b:1;s:18:\"Date browser style\";s:28:\"Estilo do navegador de datas\";s:29:\"Creates back/next navigation.\";b:1;s:8:\"End Date\";s:11:\"Data de Fin\";s:3:\"Now\";s:5:\"Agora\";s:10:\"Start date\";s:14:\"Data de Inicio\";s:8:\"End date\";s:11:\"Data de fin\";s:5:\"Plain\";s:6:\"Simple\";s:8:\"Duration\";s:20:\"Duración da enquisa\";s:6:\"Change\";s:7:\"Cambiar\";s:16:\"Site\'s time zone\";s:23:\"Franxa horaria do sitio\";s:16:\"Date\'s time zone\";s:29:\"Franxa horaria predeterminada\";s:23:\"No time zone conversion\";s:31:\"Sen conversión de fuso horario\";s:18:\"Time zone handling\";s:24:\"Xestión de fuso horario\";s:8:\"Date API\";s:8:\"Date API\";s:8:\"Relative\";s:8:\"Relativo\";s:9:\"strtotime\";s:9:\"strtotime\";s:16:\"User\'s time zone\";s:23:\"Fuxo horario do usuario\";s:10:\"Date Popup\";s:10:\"Date Popup\";s:8:\"1 minute\";s:8:\"1 minuto\";s:5:\"Popup\";s:9:\"Emerxente\";s:20:\"Show @count value(s)\";s:23:\"Amosar @count valor(es)\";s:7:\"Undated\";s:8:\"Sen data\";s:13:\"Format: @date\";s:14:\"Formato: @date\";s:9:\"!timezone\";s:9:\"!timezone\";s:19:\"Custom input format\";s:32:\"Formato de entrada personalizado\";s:18:\"Date (!base_table)\";s:18:\"Data (!base_table)\";s:8:\"Display:\";s:14:\"Presentación:\";s:16:\"Multiple values:\";s:15:\"Varios valores:\";s:22:\"starting from @isodate\";s:20:\"a partir de @isodate\";s:61:\"Show @count value(s) starting with @date1, ending with @date2\";s:66:\"Amosar @count valor(es) comezando por @date1 e rematando en @date2\";s:8:\"earliest\";s:14:\"o máis antigo\";s:6:\"latest\";s:15:\"o máis recente\";s:8:\"5 minute\";s:9:\"5 minutos\";s:9:\"15 minute\";s:10:\"15 minutos\";s:17:\"Date field values\";s:21:\"Valores do campo Data\";s:15:\"The date value.\";s:16:\"O valor de data.\";s:15:\"Pop-up calendar\";s:20:\"Calendario emerxente\";s:19:\"The End date value.\";s:36:\"O valor de data de fin (\'end date\').\";s:38:\"Choose how users view dates and times:\";s:43:\"Escolla como usuarios ven as datas e horas:\";s:24:\"Both Start and End dates\";s:33:\"Tanto as datas de inicio e de fin\";s:15:\"Start date only\";s:33:\"Só data de inicio (\'start date\')\";s:13:\"End date only\";s:30:\"Só a data de fin (\'end date\')\";s:38:\"Display dates using the @format format\";s:31:\"Amosar datas co formato @format\";s:32:\"Display both Start and End dates\";s:36:\"Amosar a data inicio e finalización\";s:23:\"Display Start date only\";s:27:\"Amosar só a data de inicio\";s:21:\"Display End date only\";s:24:\"Amosar só a data de fin\";s:9:\"10 minute\";s:10:\"10 minutos\";s:9:\"30 minute\";s:10:\"30 minutos\";s:24:\"!start-date to !end-date\";s:23:\"!start-date a !end-date\";s:11:\"E.g., @date\";s:10:\"Ex., @date\";s:3:\"to:\";s:2:\"a:\";s:13:\"Select a date\";b:1;s:28:\"Position of date part labels\";b:1;s:13:\"Relative date\";b:1;s:13:\"Show End Date\";b:1;s:14:\"Default values\";b:1;s:25:\"Use ISO-8601 week numbers\";b:1;s:62:\"IMPORTANT! If checked, First day of week MUST be set to Monday\";b:1;s:20:\"ending with @isodate\";b:1;s:51:\"The duration of the time period given by the dates.\";b:1;s:34:\"Configure the Date Popup settings.\";b:1;s:36:\"Tokens related to date field values.\";b:1;s:22:\"Relative default value\";b:1;s:12:\"Default date\";b:1;s:16:\"No default value\";b:1;s:16:\"Default end date\";b:1;s:35:\"Relative default value for end date\";b:1;s:18:\"Date entry options\";b:1;s:54:\"Control the order and format of the options users see.\";b:1;s:15:\"Time increments\";b:1;s:48:\"Select the date attributes to collect and store.\";b:1;s:26:\"Date attributes to collect\";b:1;s:19:\"Collect an end date\";b:1;s:56:\"Select the timezone handling method for this date field.\";b:1;s:57:\"Empty \'End date\' values will use the \'Start date\' values.\";b:1;s:22:\"@field_name Start date\";b:1;s:20:\"@field_name End date\";b:1;s:24:\"More settings and values\";b:1;s:10:\"Date entry\";b:1;s:24:\"Starting and ending year\";b:1;s:13:\"Starting year\";b:1;s:65:\"Enter a relative value (-9, +9) or an absolute year such as 2015.\";b:1;s:11:\"Ending year\";b:1;s:20:\"System date settings\";b:1;s:28:\"@label -  start date (!name)\";b:1;s:20:\"@label -  start date\";b:1;s:33:\"@label - end date (!name:!column)\";b:1;s:25:\"@label - end date:!column\";b:1;s:27:\"Date selection form element\";b:1;s:18:\"Filter granularity\";b:1;s:19:\"Relative start date\";b:1;s:17:\"Relative end date\";b:1;s:20:\"Same as Default date\";b:1;s:11:\"Cache dates\";b:1;s:23:\"Maximum dates per field\";b:1;s:72:\"The timezone has been set to <a href=\"@regional_settings\">@timezone</a>.\";b:1;s:11:\"@field_name\";b:1;s:25:\"Render as a regular field\";b:1;s:10:\"Date views\";b:1;s:34:\"Configure settings for date views.\";b:1;s:42:\"Settings for modules the use the Date API.\";b:1;s:8:\"Honduras\";b:1;s:14:\"Africa/Abidjan\";b:1;s:12:\"Africa/Accra\";b:1;s:18:\"Africa/Addis Ababa\";b:1;s:14:\"Africa/Algiers\";b:1;s:13:\"Africa/Asmara\";b:1;s:13:\"Africa/Bamako\";b:1;s:13:\"Africa/Bangui\";b:1;s:13:\"Africa/Banjul\";b:1;s:13:\"Africa/Bissau\";b:1;s:15:\"Africa/Blantyre\";b:1;s:18:\"Africa/Brazzaville\";b:1;s:16:\"Africa/Bujumbura\";b:1;s:12:\"Africa/Cairo\";b:1;s:17:\"Africa/Casablanca\";b:1;s:12:\"Africa/Ceuta\";b:1;s:14:\"Africa/Conakry\";b:1;s:12:\"Africa/Dakar\";b:1;s:20:\"Africa/Dar es Salaam\";b:1;s:15:\"Africa/Djibouti\";b:1;s:13:\"Africa/Douala\";b:1;s:15:\"Africa/El Aaiun\";b:1;s:15:\"Africa/Freetown\";b:1;s:15:\"Africa/Gaborone\";b:1;s:13:\"Africa/Harare\";b:1;s:19:\"Africa/Johannesburg\";b:1;s:11:\"Africa/Juba\";b:1;s:14:\"Africa/Kampala\";b:1;s:15:\"Africa/Khartoum\";b:1;s:13:\"Africa/Kigali\";b:1;s:15:\"Africa/Kinshasa\";b:1;s:12:\"Africa/Lagos\";b:1;s:17:\"Africa/Libreville\";b:1;s:11:\"Africa/Lome\";b:1;s:13:\"Africa/Luanda\";b:1;s:17:\"Africa/Lubumbashi\";b:1;s:13:\"Africa/Lusaka\";b:1;s:13:\"Africa/Malabo\";b:1;s:13:\"Africa/Maputo\";b:1;s:13:\"Africa/Maseru\";b:1;s:14:\"Africa/Mbabane\";b:1;s:16:\"Africa/Mogadishu\";b:1;s:15:\"Africa/Monrovia\";b:1;s:14:\"Africa/Nairobi\";b:1;s:15:\"Africa/Ndjamena\";b:1;s:13:\"Africa/Niamey\";b:1;s:17:\"Africa/Nouakchott\";b:1;s:18:\"Africa/Ouagadougou\";b:1;s:17:\"Africa/Porto-Novo\";b:1;s:15:\"Africa/Sao Tome\";b:1;s:14:\"Africa/Tripoli\";b:1;s:12:\"Africa/Tunis\";b:1;s:15:\"Africa/Windhoek\";b:1;s:12:\"America/Adak\";b:1;s:17:\"America/Anchorage\";b:1;s:16:\"America/Anguilla\";b:1;s:15:\"America/Antigua\";b:1;s:17:\"America/Araguaina\";b:1;s:30:\"America/Argentina/Buenos Aires\";b:1;s:27:\"America/Argentina/Catamarca\";b:1;s:25:\"America/Argentina/Cordoba\";b:1;s:23:\"America/Argentina/Jujuy\";b:1;s:26:\"America/Argentina/La Rioja\";b:1;s:25:\"America/Argentina/Mendoza\";b:1;s:30:\"America/Argentina/Rio Gallegos\";b:1;s:23:\"America/Argentina/Salta\";b:1;s:26:\"America/Argentina/San Juan\";b:1;s:26:\"America/Argentina/San Luis\";b:1;s:25:\"America/Argentina/Tucuman\";b:1;s:25:\"America/Argentina/Ushuaia\";b:1;s:13:\"America/Aruba\";b:1;s:16:\"America/Asuncion\";b:1;s:16:\"America/Atikokan\";b:1;s:13:\"America/Bahia\";b:1;s:22:\"America/Bahia Banderas\";b:1;s:16:\"America/Barbados\";b:1;s:13:\"America/Belem\";b:1;s:14:\"America/Belize\";b:1;s:20:\"America/Blanc-Sablon\";b:1;s:17:\"America/Boa Vista\";b:1;s:14:\"America/Bogota\";b:1;s:13:\"America/Boise\";b:1;s:21:\"America/Cambridge Bay\";b:1;s:20:\"America/Campo Grande\";b:1;s:14:\"America/Cancun\";b:1;s:15:\"America/Caracas\";b:1;s:15:\"America/Cayenne\";b:1;s:14:\"America/Cayman\";b:1;s:15:\"America/Chicago\";b:1;s:17:\"America/Chihuahua\";b:1;s:18:\"America/Costa Rica\";b:1;s:15:\"America/Creston\";b:1;s:14:\"America/Cuiaba\";b:1;s:15:\"America/Curacao\";b:1;s:20:\"America/Danmarkshavn\";b:1;s:14:\"America/Dawson\";b:1;s:20:\"America/Dawson Creek\";b:1;s:14:\"America/Denver\";b:1;s:15:\"America/Detroit\";b:1;s:16:\"America/Dominica\";b:1;s:16:\"America/Edmonton\";b:1;s:16:\"America/Eirunepe\";b:1;s:19:\"America/El Salvador\";b:1;s:19:\"America/Fort Nelson\";b:1;s:17:\"America/Fortaleza\";b:1;s:17:\"America/Glace Bay\";b:1;s:15:\"America/Godthab\";b:1;s:17:\"America/Goose Bay\";b:1;s:18:\"America/Grand Turk\";b:1;s:15:\"America/Grenada\";b:1;s:18:\"America/Guadeloupe\";b:1;s:17:\"America/Guatemala\";b:1;s:17:\"America/Guayaquil\";b:1;s:14:\"America/Guyana\";b:1;s:15:\"America/Halifax\";b:1;s:14:\"America/Havana\";b:1;s:18:\"America/Hermosillo\";b:1;s:28:\"America/Indiana/Indianapolis\";b:1;s:20:\"America/Indiana/Knox\";b:1;s:23:\"America/Indiana/Marengo\";b:1;s:26:\"America/Indiana/Petersburg\";b:1;s:25:\"America/Indiana/Tell City\";b:1;s:21:\"America/Indiana/Vevay\";b:1;s:25:\"America/Indiana/Vincennes\";b:1;s:23:\"America/Indiana/Winamac\";b:1;s:14:\"America/Inuvik\";b:1;s:15:\"America/Iqaluit\";b:1;s:15:\"America/Jamaica\";b:1;s:14:\"America/Juneau\";b:1;s:27:\"America/Kentucky/Louisville\";b:1;s:27:\"America/Kentucky/Monticello\";b:1;s:18:\"America/Kralendijk\";b:1;s:14:\"America/La Paz\";b:1;s:12:\"America/Lima\";b:1;s:19:\"America/Los Angeles\";b:1;s:21:\"America/Lower Princes\";b:1;s:14:\"America/Maceio\";b:1;s:15:\"America/Managua\";b:1;s:14:\"America/Manaus\";b:1;s:15:\"America/Marigot\";b:1;s:18:\"America/Martinique\";b:1;s:17:\"America/Matamoros\";b:1;s:16:\"America/Mazatlan\";b:1;s:17:\"America/Menominee\";b:1;s:14:\"America/Merida\";b:1;s:18:\"America/Metlakatla\";b:1;s:19:\"America/Mexico City\";b:1;s:16:\"America/Miquelon\";b:1;s:15:\"America/Moncton\";b:1;s:17:\"America/Monterrey\";b:1;s:18:\"America/Montevideo\";b:1;s:18:\"America/Montserrat\";b:1;s:14:\"America/Nassau\";b:1;s:16:\"America/New York\";b:1;s:15:\"America/Nipigon\";b:1;s:12:\"America/Nome\";b:1;s:15:\"America/Noronha\";b:1;s:27:\"America/North Dakota/Beulah\";b:1;s:27:\"America/North Dakota/Center\";b:1;s:30:\"America/North Dakota/New Salem\";b:1;s:15:\"America/Ojinaga\";b:1;s:14:\"America/Panama\";b:1;s:19:\"America/Pangnirtung\";b:1;s:18:\"America/Paramaribo\";b:1;s:15:\"America/Phoenix\";b:1;s:22:\"America/Port-au-Prince\";b:1;s:21:\"America/Port of Spain\";b:1;s:19:\"America/Porto Velho\";b:1;s:19:\"America/Puerto Rico\";b:1;s:19:\"America/Rainy River\";b:1;s:20:\"America/Rankin Inlet\";b:1;s:14:\"America/Recife\";b:1;s:14:\"America/Regina\";b:1;s:16:\"America/Resolute\";b:1;s:18:\"America/Rio Branco\";b:1;s:20:\"America/Santa Isabel\";b:1;s:16:\"America/Santarem\";b:1;s:16:\"America/Santiago\";b:1;s:21:\"America/Santo Domingo\";b:1;s:17:\"America/Sao Paulo\";b:1;s:20:\"America/Scoresbysund\";b:1;s:13:\"America/Sitka\";b:1;s:21:\"America/St Barthelemy\";b:1;s:16:\"America/St Johns\";b:1;s:16:\"America/St Kitts\";b:1;s:16:\"America/St Lucia\";b:1;s:17:\"America/St Thomas\";b:1;s:18:\"America/St Vincent\";b:1;s:21:\"America/Swift Current\";b:1;s:19:\"America/Tegucigalpa\";b:1;s:13:\"America/Thule\";b:1;s:19:\"America/Thunder Bay\";b:1;s:15:\"America/Tijuana\";b:1;s:15:\"America/Toronto\";b:1;s:15:\"America/Tortola\";b:1;s:17:\"America/Vancouver\";b:1;s:18:\"America/Whitehorse\";b:1;s:16:\"America/Winnipeg\";b:1;s:15:\"America/Yakutat\";b:1;s:19:\"America/Yellowknife\";b:1;s:16:\"Antarctica/Casey\";b:1;s:16:\"Antarctica/Davis\";b:1;s:25:\"Antarctica/DumontDUrville\";b:1;s:20:\"Antarctica/Macquarie\";b:1;s:17:\"Antarctica/Mawson\";b:1;s:18:\"Antarctica/McMurdo\";b:1;s:17:\"Antarctica/Palmer\";b:1;s:18:\"Antarctica/Rothera\";b:1;s:16:\"Antarctica/Syowa\";b:1;s:16:\"Antarctica/Troll\";b:1;s:17:\"Antarctica/Vostok\";b:1;s:19:\"Arctic/Longyearbyen\";b:1;s:9:\"Asia/Aden\";b:1;s:11:\"Asia/Almaty\";b:1;s:10:\"Asia/Amman\";b:1;s:11:\"Asia/Anadyr\";b:1;s:10:\"Asia/Aqtau\";b:1;s:11:\"Asia/Aqtobe\";b:1;s:13:\"Asia/Ashgabat\";b:1;s:12:\"Asia/Baghdad\";b:1;s:12:\"Asia/Bahrain\";b:1;s:9:\"Asia/Baku\";b:1;s:12:\"Asia/Bangkok\";b:1;s:11:\"Asia/Beirut\";b:1;s:12:\"Asia/Bishkek\";b:1;s:11:\"Asia/Brunei\";b:1;s:10:\"Asia/Chita\";b:1;s:15:\"Asia/Choibalsan\";b:1;s:12:\"Asia/Colombo\";b:1;s:13:\"Asia/Damascus\";b:1;s:10:\"Asia/Dhaka\";b:1;s:9:\"Asia/Dili\";b:1;s:10:\"Asia/Dubai\";b:1;s:13:\"Asia/Dushanbe\";b:1;s:9:\"Asia/Gaza\";b:1;s:11:\"Asia/Hebron\";b:1;s:16:\"Asia/Ho Chi Minh\";b:1;s:14:\"Asia/Hong Kong\";b:1;s:9:\"Asia/Hovd\";b:1;s:12:\"Asia/Irkutsk\";b:1;s:12:\"Asia/Jakarta\";b:1;s:13:\"Asia/Jayapura\";b:1;s:14:\"Asia/Jerusalem\";b:1;s:10:\"Asia/Kabul\";b:1;s:14:\"Asia/Kamchatka\";b:1;s:12:\"Asia/Karachi\";b:1;s:14:\"Asia/Kathmandu\";b:1;s:13:\"Asia/Khandyga\";b:1;s:12:\"Asia/Kolkata\";b:1;s:16:\"Asia/Krasnoyarsk\";b:1;s:17:\"Asia/Kuala Lumpur\";b:1;s:12:\"Asia/Kuching\";b:1;s:11:\"Asia/Kuwait\";b:1;s:10:\"Asia/Macau\";b:1;s:12:\"Asia/Magadan\";b:1;s:13:\"Asia/Makassar\";b:1;s:11:\"Asia/Manila\";b:1;s:11:\"Asia/Muscat\";b:1;s:12:\"Asia/Nicosia\";b:1;s:17:\"Asia/Novokuznetsk\";b:1;s:16:\"Asia/Novosibirsk\";b:1;s:9:\"Asia/Omsk\";b:1;s:9:\"Asia/Oral\";b:1;s:15:\"Asia/Phnom Penh\";b:1;s:14:\"Asia/Pontianak\";b:1;s:14:\"Asia/Pyongyang\";b:1;s:10:\"Asia/Qatar\";b:1;s:14:\"Asia/Qyzylorda\";b:1;s:12:\"Asia/Rangoon\";b:1;s:11:\"Asia/Riyadh\";b:1;s:13:\"Asia/Sakhalin\";b:1;s:14:\"Asia/Samarkand\";b:1;s:10:\"Asia/Seoul\";b:1;s:13:\"Asia/Shanghai\";b:1;s:14:\"Asia/Singapore\";b:1;s:18:\"Asia/Srednekolymsk\";b:1;s:11:\"Asia/Taipei\";b:1;s:13:\"Asia/Tashkent\";b:1;s:12:\"Asia/Tbilisi\";b:1;s:11:\"Asia/Tehran\";b:1;s:12:\"Asia/Thimphu\";b:1;s:10:\"Asia/Tokyo\";b:1;s:16:\"Asia/Ulaanbaatar\";b:1;s:11:\"Asia/Urumqi\";b:1;s:13:\"Asia/Ust-Nera\";b:1;s:14:\"Asia/Vientiane\";b:1;s:16:\"Asia/Vladivostok\";b:1;s:12:\"Asia/Yakutsk\";b:1;s:18:\"Asia/Yekaterinburg\";b:1;s:12:\"Asia/Yerevan\";b:1;s:15:\"Atlantic/Azores\";b:1;s:16:\"Atlantic/Bermuda\";b:1;s:15:\"Atlantic/Canary\";b:1;s:19:\"Atlantic/Cape Verde\";b:1;s:14:\"Atlantic/Faroe\";b:1;s:16:\"Atlantic/Madeira\";b:1;s:18:\"Atlantic/Reykjavik\";b:1;s:22:\"Atlantic/South Georgia\";b:1;s:18:\"Atlantic/St Helena\";b:1;s:16:\"Atlantic/Stanley\";b:1;s:18:\"Australia/Adelaide\";b:1;s:18:\"Australia/Brisbane\";b:1;s:21:\"Australia/Broken Hill\";b:1;s:16:\"Australia/Currie\";b:1;s:16:\"Australia/Darwin\";b:1;s:15:\"Australia/Eucla\";b:1;s:16:\"Australia/Hobart\";b:1;s:18:\"Australia/Lindeman\";b:1;s:19:\"Australia/Lord Howe\";b:1;s:19:\"Australia/Melbourne\";b:1;s:15:\"Australia/Perth\";b:1;s:16:\"Australia/Sydney\";b:1;s:16:\"Europe/Amsterdam\";b:1;s:14:\"Europe/Andorra\";b:1;s:13:\"Europe/Athens\";b:1;s:15:\"Europe/Belgrade\";b:1;s:13:\"Europe/Berlin\";b:1;s:17:\"Europe/Bratislava\";b:1;s:15:\"Europe/Brussels\";b:1;s:16:\"Europe/Bucharest\";b:1;s:15:\"Europe/Budapest\";b:1;s:15:\"Europe/Busingen\";b:1;s:15:\"Europe/Chisinau\";b:1;s:17:\"Europe/Copenhagen\";b:1;s:13:\"Europe/Dublin\";b:1;s:16:\"Europe/Gibraltar\";b:1;s:15:\"Europe/Guernsey\";b:1;s:15:\"Europe/Helsinki\";b:1;s:18:\"Europe/Isle of Man\";b:1;s:15:\"Europe/Istanbul\";b:1;s:13:\"Europe/Jersey\";b:1;s:18:\"Europe/Kaliningrad\";b:1;s:11:\"Europe/Kiev\";b:1;s:13:\"Europe/Lisbon\";b:1;s:16:\"Europe/Ljubljana\";b:1;s:13:\"Europe/London\";b:1;s:17:\"Europe/Luxembourg\";b:1;s:13:\"Europe/Madrid\";b:1;s:12:\"Europe/Malta\";b:1;s:16:\"Europe/Mariehamn\";b:1;s:12:\"Europe/Minsk\";b:1;s:13:\"Europe/Monaco\";b:1;s:13:\"Europe/Moscow\";b:1;s:11:\"Europe/Oslo\";b:1;s:12:\"Europe/Paris\";b:1;s:16:\"Europe/Podgorica\";b:1;s:13:\"Europe/Prague\";b:1;s:11:\"Europe/Riga\";b:1;s:11:\"Europe/Rome\";b:1;s:13:\"Europe/Samara\";b:1;s:17:\"Europe/San Marino\";b:1;s:15:\"Europe/Sarajevo\";b:1;s:17:\"Europe/Simferopol\";b:1;s:13:\"Europe/Skopje\";b:1;s:12:\"Europe/Sofia\";b:1;s:16:\"Europe/Stockholm\";b:1;s:14:\"Europe/Tallinn\";b:1;s:13:\"Europe/Tirane\";b:1;s:15:\"Europe/Uzhgorod\";b:1;s:12:\"Europe/Vaduz\";b:1;s:14:\"Europe/Vatican\";b:1;s:13:\"Europe/Vienna\";b:1;s:14:\"Europe/Vilnius\";b:1;s:16:\"Europe/Volgograd\";b:1;s:13:\"Europe/Warsaw\";b:1;s:13:\"Europe/Zagreb\";b:1;s:17:\"Europe/Zaporozhye\";b:1;s:13:\"Europe/Zurich\";b:1;s:19:\"Indian/Antananarivo\";b:1;s:13:\"Indian/Chagos\";b:1;s:16:\"Indian/Christmas\";b:1;s:12:\"Indian/Cocos\";b:1;s:13:\"Indian/Comoro\";b:1;s:16:\"Indian/Kerguelen\";b:1;s:11:\"Indian/Mahe\";b:1;s:15:\"Indian/Maldives\";b:1;s:16:\"Indian/Mauritius\";b:1;s:14:\"Indian/Mayotte\";b:1;s:14:\"Indian/Reunion\";b:1;s:12:\"Pacific/Apia\";b:1;s:16:\"Pacific/Auckland\";b:1;s:20:\"Pacific/Bougainville\";b:1;s:15:\"Pacific/Chatham\";b:1;s:13:\"Pacific/Chuuk\";b:1;s:14:\"Pacific/Easter\";b:1;s:13:\"Pacific/Efate\";b:1;s:17:\"Pacific/Enderbury\";b:1;s:15:\"Pacific/Fakaofo\";b:1;s:12:\"Pacific/Fiji\";b:1;s:16:\"Pacific/Funafuti\";b:1;s:17:\"Pacific/Galapagos\";b:1;s:15:\"Pacific/Gambier\";b:1;s:19:\"Pacific/Guadalcanal\";b:1;s:12:\"Pacific/Guam\";b:1;s:16:\"Pacific/Honolulu\";b:1;s:16:\"Pacific/Johnston\";b:1;s:18:\"Pacific/Kiritimati\";b:1;s:14:\"Pacific/Kosrae\";b:1;s:17:\"Pacific/Kwajalein\";b:1;s:14:\"Pacific/Majuro\";b:1;s:17:\"Pacific/Marquesas\";b:1;s:14:\"Pacific/Midway\";b:1;s:13:\"Pacific/Nauru\";b:1;s:12:\"Pacific/Niue\";b:1;s:15:\"Pacific/Norfolk\";b:1;s:14:\"Pacific/Noumea\";b:1;s:17:\"Pacific/Pago Pago\";b:1;s:13:\"Pacific/Palau\";b:1;s:16:\"Pacific/Pitcairn\";b:1;s:15:\"Pacific/Pohnpei\";b:1;s:20:\"Pacific/Port Moresby\";b:1;s:17:\"Pacific/Rarotonga\";b:1;s:14:\"Pacific/Saipan\";b:1;s:14:\"Pacific/Tahiti\";b:1;s:14:\"Pacific/Tarawa\";b:1;s:17:\"Pacific/Tongatapu\";b:1;s:12:\"Pacific/Wake\";b:1;s:14:\"Pacific/Wallis\";b:1;s:3:\"UTC\";b:1;s:24:\"Short date format: @date\";b:1;s:20:\"Calendario emerxente\";b:1;s:3:\"Mar\";b:1;s:5:\"Texto\";b:1;s:14:\"Campo de texto\";b:1;s:46:\"Integrate the FlexSlider 2 library with Drupal\";b:1;s:35:\"Sample implementation of FlexSlider\";b:1;s:44:\"Adds a display mode in Fields for FlexSlider\";b:1;s:40:\"Adds a Views style plugin for FlexSlider\";b:1;s:10:\"FlexSlider\";b:1;s:27:\"Show remaining days: @value\";b:1;s:32:\"Administer the FlexSlider module\";b:1;s:10:\"flexslider\";b:1;s:21:\"Version 2.0 installed\";b:1;s:26:\"Version %version installed\";b:1;s:29:\"FlexSlider library installed.\";b:1;s:9:\"optionset\";b:1;s:10:\"optionsets\";b:1;s:20:\"FlexSlider optionset\";b:1;s:21:\"FlexSlider optionsets\";b:1;s:43:\"Display the results in a FlexSlider widget.\";b:1;s:30:\"Administer FlexSlider presets.\";b:1;s:12:\"Video Filter\";b:1;s:43:\"Substitutes [video:URL] with embedded HTML.\";b:1;s:11:\"Archive.org\";b:1;s:7:\"Blip.tv\";s:7:\"Blip.tv\";s:13:\"Candid Career\";b:1;s:6:\"Capped\";b:1;s:13:\"College Humor\";b:1;s:4:\"Coub\";b:1;s:11:\"DailyMotion\";b:1;s:21:\"DemocracyNow Fullshow\";b:1;s:18:\"DemocracyNow Story\";b:1;s:17:\"Flickr Slideshows\";b:1;s:12:\"Flickr Video\";b:1;s:8:\"Fox News\";b:1;s:13:\"Game Trailers\";b:1;s:11:\"Game Videos\";b:1;s:5:\"Giphy\";b:1;s:7:\"GodTube\";b:1;s:12:\"Google Video\";b:1;s:9:\"Instagram\";b:1;s:9:\"Meta Cafe\";b:1;s:7:\"Mail.Ru\";b:1;s:7:\"MySpace\";s:7:\"MySpace\";s:7:\"MyVideo\";b:1;s:17:\"Picasa Slideshows\";b:1;s:58:\"You must use the URL of the RSS feed for the Picasa album:\";b:1;s:70:\"View the album in Picasa (you should see thumbnails, not a slideshow).\";b:1;s:33:\"Find the \"RSS\" link and click it.\";b:1;s:62:\"Copy the resulting URL from the browser address bar.  Example:\";b:1;s:6:\"Rutube\";b:1;s:10:\"Slideshare\";b:1;s:12:\"Streamhoster\";b:1;s:11:\"Teachertube\";b:1;s:3:\"TED\";b:1;s:68:\"Click in Embed and copy the \"Link to this talk\" link and paste here.\";b:1;s:6:\"Twitch\";b:1;s:7:\"Ustream\";b:1;s:5:\"Vbox7\";b:1;s:5:\"Vimeo\";s:5:\"Vimeo\";s:4:\"Vine\";b:1;s:9:\"whatchado\";b:1;s:6:\"Wistia\";b:1;s:5:\"YouKu\";b:1;s:7:\"YouTube\";s:7:\"YouTube\";s:18:\"YouTube (Playlist)\";b:1;s:21:\"Default width setting\";b:1;s:22:\"Default height setting\";b:1;s:24:\"Default autoplay setting\";b:1;s:43:\"Not all video formats support this setting.\";b:1;s:22:\"Related videos setting\";b:1;s:66:\"Show \"related videos\"? Not all video formats support this setting.\";b:1;s:9:\"Use HTML5\";b:1;s:22:\"Allow multiple sources\";b:1;s:70:\"Allow the use of multiple sources (used source is selected at random).\";b:1;s:6:\"Codecs\";b:1;s:38:\"Choose which codecs will be available.\";b:1;s:12:\"Video filter\";b:1;s:24:\"Videofilter instructions\";b:1;s:12:\"instructions\";b:1;s:12:\"Instructions\";s:13:\"Instruccións\";s:22:\"Video filter dashboard\";b:1;s:38:\"You may insert videos with [video:URL]\";s:48:\"Podes inserir vídeos usando a marca [video:URL]\";s:6:\"Manage\";b:1;s:11:\"Video Embed\";b:1;s:5:\"Video\";s:5:\"Video\";s:34:\"Select the allowed video providers\";b:1;s:74:\"The description field allows users to enter a description about the video.\";b:1;s:22:\"Max description length\";b:1;s:19:\"Video style: @style\";b:1;s:48:\"Use field label as the label for the title field\";b:1;s:18:\"URL Display Cutoff\";b:1;s:8:\"Ligazón\";b:1;s:8:\"Booleano\";b:1;s:47:\"Caixas de selección sixelas activo/desactivado\";b:1;s:14:\"Enabled themes\";b:1;s:18:\"Bootstrap Settings\";b:1;s:9:\"Container\";b:1;s:15:\"Fluid container\";b:1;s:7:\"Buttons\";b:1;s:19:\"Default button size\";b:1;s:11:\"Extra Small\";b:1;s:5:\"Small\";s:7:\"Pequeno\";s:5:\"Large\";s:6:\"Grande\";s:16:\"Colorize Buttons\";b:1;s:15:\"Iconize Buttons\";b:1;s:5:\"Forms\";b:1;s:42:\"Make required elements display as an error\";b:1;s:38:\"Smart form descriptions (via Tooltips)\";b:1;s:49:\"\"Smart form descriptions\" maximum character limit\";b:1;s:45:\"\"Smart form descriptions\" allowed (HTML) tags\";b:1;s:6:\"Images\";b:1;s:19:\"Default image shape\";b:1;s:7:\"Rounded\";b:1;s:6:\"Circle\";b:1;s:9:\"Thumbnail\";b:1;s:17:\"Responsive Images\";b:1;s:6:\"Tables\";b:1;s:14:\"Bordered table\";b:1;s:48:\"Add borders on all sides of the table and cells.\";b:1;s:15:\"Condensed table\";b:1;s:57:\"Make tables more compact by cutting cell padding in half.\";b:1;s:10:\"Hover rows\";b:1;s:35:\"Enable a hover state on table rows.\";b:1;s:12:\"Striped rows\";b:1;s:17:\"Responsive tables\";b:1;s:10:\"Components\";b:1;s:11:\"Breadcrumbs\";b:1;s:21:\"Breadcrumb visibility\";b:1;s:19:\"Only in admin areas\";b:1;s:27:\"Show \"Home\" breadcrumb link\";b:1;s:30:\"Show current page title at end\";b:1;s:6:\"Navbar\";b:1;s:15:\"Navbar Position\";b:1;s:28:\"Select your Navbar position.\";b:1;s:10:\"Static Top\";b:1;s:9:\"Fixed Top\";b:1;s:12:\"Fixed Bottom\";b:1;s:20:\"Inverse navbar style\";b:1;s:44:\"Select if you want the inverse navbar style.\";b:1;s:10:\"Pagination\";b:1;s:42:\"Show \"First\" and \"Last\" links in the pager\";b:1;s:14:\".well (normal)\";b:1;s:16:\".well-sm (small)\";b:1;s:16:\".well-lg (large)\";b:1;s:12:\"Region wells\";b:1;s:10:\"JavaScript\";b:1;s:7:\"Anchors\";b:1;s:20:\"Fix anchor positions\";b:1;s:23:\"Enable smooth scrolling\";b:1;s:74:\"Animates page by scrolling to an anchor link target smoothly when clicked.\";b:1;s:64:\"Automatically remove error classes when values have been entered\";b:1;s:8:\"Popovers\";b:1;s:16:\"Enable popovers.\";b:1;s:7:\"animate\";b:1;s:43:\"Apply a CSS fade transition to the popover.\";b:1;s:4:\"HTML\";b:1;s:9:\"placement\";b:1;s:8:\"selector\";b:1;s:7:\"trigger\";b:1;s:27:\"How a popover is triggered.\";b:1;s:28:\"Auto-close on document click\";b:1;s:5:\"title\";b:1;s:55:\"Default title value if \"title\" attribute isn\'t present.\";b:1;s:5:\"delay\";b:1;s:9:\"container\";b:1;s:8:\"Tooltips\";b:1;s:15:\"Enable tooltips\";b:1;s:43:\"Apply a CSS fade transition to the tooltip.\";b:1;s:27:\"How a tooltip is triggered.\";b:1;s:58:\"Appends the tooltip to a specific element. Example: \"body\"\";b:1;s:37:\"Suppress jQuery version error message\";b:1;s:30:\"CDN (Content Delivery Network)\";b:1;s:4:\"NOTE\";b:1;s:12:\"CDN Provider\";b:1;s:19:\"Bootstrap @type URL\";b:1;s:28:\"Minified Bootstrap @type URL\";b:1;s:19:\"Bootstrap (default)\";b:1;s:6:\"1 hour\";b:1;s:34:\"Select bundles you want to export.\";b:1;s:6:\"Bundle\";b:1;s:17:\"No bundles found.\";b:1;s:33:\"Select fields you want to export.\";b:1;s:16:\"No fields found.\";b:1;s:8:\"Ficheiro\";b:1;s:51:\"Select the <em>%btype</em> which you want to clone.\";b:1;s:15:\"New Bundle Name\";b:1;s:50:\"Configure the advanced flexslider module settings.\";b:1;s:52:\"Usa <em>arquivos</em> para estudos e documentación.\";b:1;s:33:\"Respond.js integration for Drupal\";b:1;s:10:\"Responsive\";b:1;s:23:\"View location directory\";b:1;s:24:\"View node location table\";b:1;s:24:\"View user location table\";b:1;s:25:\"Submit latitude/longitude\";b:1;s:13:\"View node map\";b:1;s:26:\"See the sitewide node map.\";b:1;s:13:\"View user map\";b:1;s:26:\"See the sitewide user map.\";b:1;s:26:\"View user location details\";b:1;s:63:\"See the users associated with markers on the sitewide user map.\";b:1;s:17:\"Create gmap macro\";b:1;s:62:\"Allows user to create a gmap macro for insertion into content.\";b:1;s:25:\"administer user locations\";b:1;s:22:\"view own user location\";b:1;s:23:\"view all user locations\";b:1;s:21:\"set own user location\";b:1;s:11:\"Gmap Marker\";b:1;s:26:\"Choose a Gmap Marker icon.\";b:1;s:33:\"Store a location.module location.\";b:1;s:12:\"Location map\";s:21:\"Mapa de localización\";s:10:\"Author map\";s:21:\"Información do autor\";s:9:\"Small Red\";b:1;s:16:\"Small Bright red\";b:1;s:12:\"Small Orange\";b:1;s:17:\"Small Pale Yellow\";b:1;s:12:\"Small Yellow\";b:1;s:16:\"Small Pale Green\";b:1;s:11:\"Small Green\";b:1;s:16:\"Small Dark Green\";b:1;s:18:\"Small Flouro Green\";b:1;s:15:\"Small Pale Blue\";b:1;s:16:\"Small Light Blue\";b:1;s:10:\"Small Blue\";b:1;s:15:\"Small Dark Blue\";b:1;s:12:\"Small Purple\";b:1;s:10:\"Small Pink\";b:1;s:17:\"Small Bright Pink\";b:1;s:11:\"Small Brown\";b:1;s:11:\"Small White\";b:1;s:16:\"Small Light Gray\";b:1;s:10:\"Small Gray\";b:1;s:11:\"Small Black\";b:1;s:22:\"Small Blue (Alternate)\";b:1;s:21:\"Small Red (Alternate)\";b:1;s:16:\"X marks the spot\";b:1;s:8:\"Big Blue\";b:1;s:7:\"Big Red\";b:1;s:4:\"Gray\";s:4:\"Gris\";s:5:\"Green\";s:5:\"Verde\";s:10:\"Light Blue\";b:1;s:4:\"Pink\";b:1;s:6:\"Purple\";b:1;s:6:\"Yellow\";s:7:\"Amarelo\";s:4:\"Week\";s:6:\"Semana\";s:7:\"Letters\";b:1;s:5:\"Blank\";s:9:\"En blanco\";s:7:\"Cluster\";b:1;s:11:\"Line Vertex\";b:1;s:7:\"Numbers\";b:1;s:5:\"Route\";s:4:\"Ruta\";s:16:\"Location chooser\";s:26:\"Localización do SWFObject\";s:48:\"Used to activate location choosing using a gmap.\";b:1;s:16:\"Disable dragging\";s:19:\"Desactivar un país\";s:16:\"Disable keyboard\";s:19:\"Desactivar un país\";s:31:\"Disable the keyboard shortcuts.\";b:1;s:17:\"Disable mousezoom\";s:19:\"Desactivar un país\";s:47:\"Disable using the scroll wheel to zoom the map.\";b:1;s:23:\"Disable Continuous Zoom\";b:1;s:12:\"Use AutoZoom\";s:14:\"Usar SWFObject\";s:69:\"Automatically zoom the map to fit all markers when markers are added.\";b:1;s:39:\"Unconditionally enable marker interface\";b:1;s:19:\"Enable Overview Map\";b:1;s:53:\"Enable the \"overview map\" in the bottom right corner.\";b:1;s:58:\"Work around bugs when maps appear in collapsible fieldsets\";b:1;s:25:\"Add scale control to map.\";b:1;s:56:\"Adds a scale control to the map in the default position.\";b:1;s:27:\"Enable extra marker events.\";b:1;s:24:\"Enable clickable shapes.\";b:1;s:28:\"Highlight marker on rollover\";b:1;s:60:\"Highlight marker by creating circle on mouse rollover event.\";b:1;s:4:\"GMap\";b:1;s:23:\"Displays rows as a map.\";b:1;s:13:\"Extended GMap\";b:1;s:26:\"Displays a map of markers.\";b:1;s:2:\"px\";s:2:\"px\";s:6:\"Points\";s:6:\"Puntos\";s:7:\"Address\";s:20:\"Enderezo de correo-e\";s:8:\"Original\";s:8:\"Orixinal\";s:10:\"Do nothing\";s:15:\"Non facer nada.\";s:14:\"Default height\";s:19:\"Altura da miniatura\";s:13:\"Default width\";s:18:\"Ancho da miniatura\";s:20:\"Default map settings\";s:35:\"Usar os axustes predefinidos de RSS\";s:14:\"Default center\";s:19:\"Orde predeterminada\";s:12:\"Default zoom\";s:19:\"Orde predeterminada\";s:20:\"Default control type\";s:32:\"Tipos de argumentos predefinidos\";s:16:\"Default map type\";s:32:\"Tipos de argumentos predefinidos\";s:14:\"@name : @title\";s:16:\"!title por !name\";s:13:\"Marker action\";s:27:\"Acción \'%action\' engadida.\";s:9:\"Open link\";s:19:\"Color das ligazóns\";s:14:\"Marker manager\";s:15:\"Xestor do grupo\";s:12:\"Maximum zoom\";s:15:\"Tamaño máximo\";s:13:\"Track markers\";s:21:\"Seguimento de artigos\";s:15:\"Marker defaults\";s:18:\"Separador de Miles\";s:12:\"Minimum zoom\";s:32:\"Mínimo de permanencia en caché\";s:18:\"Clusterer settings\";s:16:\"opcións de !key\";s:11:\"Activate on\";s:9:\"Creado en\";s:10:\"Cluster on\";s:9:\"Creado en\";s:7:\"at most\";s:21:\"Enquisa máis recente\";s:6:\"Marker\";s:18:\"Separador de Miles\";s:12:\"Stroke color\";s:14:\"Esquema de cor\";s:13:\"Stroke weight\";s:15:\"Peso da pestana\";s:10:\"Fill color\";s:14:\"Esquema de cor\";s:14:\"User locations\";s:17:\"Lista de usuarios\";s:14:\"Node locations\";s:21:\"O {node}.nid do nodo.\";s:13:\"GMap Location\";s:26:\"Localización do SWFObject\";s:5:\"Macro\";s:5:\"Macro\";s:11:\"Page header\";s:20:\"Cabeceira da páxina\";s:11:\"Page footer\";s:14:\"Pé de páxina\";s:16:\"Markers per role\";s:19:\"Por rol por páxina\";s:13:\"Node settings\";s:15:\"Axustes do nodo\";s:8:\"Latitude\";s:8:\"Latitude\";s:9:\"Longitude\";s:9:\"Lonxitude\";s:19:\"Google Maps API Key\";b:1;s:21:\"Google Map Initialize\";b:1;s:39:\"The default zoom level of a Google map.\";b:1;s:18:\"Map Behavior flags\";b:1;s:45:\"Perform this action when a marker is clicked.\";b:1;s:16:\"Open info window\";b:1;s:20:\"Default Line 1 Color\";b:1;s:20:\"Default Line 2 Color\";b:1;s:20:\"Default Line 3 Color\";b:1;s:25:\"Jef Poskanzer\'s Clusterer\";b:1;s:19:\"Marker for clusters\";b:1;s:42:\"The marker to use when creating a cluster.\";b:1;s:15:\"or more markers\";b:1;s:37:\"Minimal number of markers per cluster\";b:1;s:13:\"Lines per box\";b:1;s:5:\"lines\";b:1;s:36:\"Maximum number of lines per info box\";b:1;s:23:\"Configure GMap settings\";b:1;s:14:\"Stroke opacity\";b:1;s:12:\"Fill opacity\";b:1;s:33:\"Configure GMap Location settings.\";b:1;s:32:\"Text at the top of the user map.\";b:1;s:35:\"Text at the bottom of the user map.\";b:1;s:21:\"%role (Role ID: %rid)\";b:1;s:24:\"Markers per content type\";b:1;s:66:\"Choose a marker to represent each type of content on the node map.\";b:1;s:52:\"This content type is not currently Location enabled.\";b:1;s:18:\"Build a GMap macro\";b:1;s:9:\"Animation\";b:1;s:11:\"Google Maps\";b:1;s:10:\"Regenerate\";b:1;s:20:\"Maximum initial zoom\";b:1;s:10:\"Popup mode\";b:1;s:18:\"Clustering enabled\";b:1;s:18:\"Title for clusters\";b:1;s:40:\"Javascript is required to view this map.\";b:1;s:16:\"Marker for %type\";b:1;s:12:\"GMap markers\";b:1;s:11:\"GMap Marker\";b:1;s:9:\"No Marker\";b:1;s:15:\"Highlight color\";b:1;s:9:\"Grid Size\";b:1;s:19:\"Find Address on Map\";s:25:\"Buscar Dirección no Mapa\";s:5:\"Phone\";s:9:\"Teléfono\";s:5:\"Allow\";s:8:\"Permitir\";s:13:\"Location name\";s:21:\"Nome da localización\";s:11:\"Postal code\";s:14:\"Código postal\";s:14:\"State/Province\";s:21:\"Estado actual: !state\";s:11:\"Collapsible\";s:8:\"Plegable\";s:9:\"Collapsed\";s:9:\"Contraida\";s:10:\"Fax number\";s:14:\"Número de fax\";s:12:\"Phone number\";s:20:\"Número de teléfono\";s:14:\"Search options\";s:22:\"Opcións de selección\";s:8:\"location\";s:10:\"ubicación\";s:16:\"Display Settings\";b:1;s:13:\"Main settings\";b:1;s:3:\"Fax\";b:1;s:46:\"e.g. a place of business, venue, meeting point\";s:82:\"Por exemplo: unha sede comercial, un lugar de actuacións, un punto de reunión...\";s:6:\"Street\";s:4:\"Rúa\";s:10:\"Additional\";b:1;s:4:\"City\";s:6:\"Cidade\";s:10:\"NOT LISTED\";b:1;s:17:\"Geocoding options\";b:1;s:28:\"Settings for Location module\";b:1;s:15:\"Street location\";b:1;s:32:\"No service selected for country.\";b:1;s:20:\"Locative information\";b:1;s:19:\"Number of locations\";b:1;s:34:\"Make the location box collapsible.\";b:1;s:25:\"Default country selection\";b:1;s:23:\"Toggle location display\";b:1;s:33:\"Disable the display of locations.\";b:1;s:32:\"Enable the display of locations.\";b:1;s:47:\"Use a Google Map to set latitude and longitude \";b:1;s:11:\"Coordinates\";b:1;s:7:\"Website\";b:1;s:8:\"Province\";b:1;s:7:\"Collect\";b:1;s:12:\"Country Name\";b:1;s:11:\"Postal Code\";b:1;s:7:\"Require\";b:1;s:27:\"Maximum number of locations\";b:1;s:22:\"Location chooser macro\";b:1;s:20:\"Enable JIT geocoding\";b:1;s:3:\"Lid\";b:1;s:38:\"The province of the selected location.\";b:1;s:41:\"The postal code of the selected location.\";b:1;s:37:\"The country of the selected location.\";b:1;s:38:\"The latitude of the selected location.\";b:1;s:39:\"The longitude of the selected location.\";b:1;s:20:\"Distance / Proximity\";b:1;s:19:\"Current coordinates\";b:1;s:39:\"Check this box to delete this location.\";b:1;s:15:\"Location Fields\";b:1;s:13:\"Province name\";b:1;s:12:\"Country name\";b:1;s:8:\"Map link\";b:1;s:27:\"Minimum number of locations\";b:1;s:20:\"Location form weight\";b:1;s:14:\"Display Weight\";b:1;s:12:\"RSS Settings\";b:1;s:8:\"RSS mode\";b:1;s:20:\"W3C Geo (deprecated)\";b:1;s:13:\"GeoRSS-Simple\";b:1;s:10:\"GeoRSS GML\";b:1;s:14:\"Location Field\";b:1;s:6:\"Origin\";b:1;s:24:\"Autofill empty locations\";b:1;s:67:\"Find and fill all empty locations with latitude and longtitude data\";b:1;s:35:\"Settings for Location Search module\";b:1;s:23:\"Regenerate marker cache\";b:1;s:18:\"Line default style\";b:1;s:67:\"Lines without a specific style defined will fall back to this style\";b:1;s:21:\"Polygon default style\";b:1;s:70:\"Polygons without a specific style defined will fall back to this style\";b:1;s:16:\"Show Pan control\";b:1;s:24:\"Show Street View control\";b:1;s:16:\"Map Type Control\";b:1;s:50:\"Standard (google.maps.MapTypeControlStyle.DEFAULT)\";b:1;s:63:\"Horizontal bar (google.maps.MapTypeControlStyle.HORIZONTAL_BAR)\";b:1;s:56:\"Dropdown (google.maps.MapTypeControlStyle.DROPDOWN_MENU)\";b:1;s:33:\"Enabled map types (\"base layers\")\";b:1;s:25:\"Map: Standard street map.\";b:1;s:60:\"The standard default street map. Internal name: G_NORMAL_MAP\";b:1;s:34:\"Satellite: Standard satellite map.\";b:1;s:69:\"Satellite view without street overlay. Internal name: G_SATELLITE_MAP\";b:1;s:29:\"Hybrid: Hybrid satellite map.\";b:1;s:63:\"Satellite view with street overlay. Internal name: G_HYBRID_MAP\";b:1;s:30:\"Terrain: Physical feature map.\";b:1;s:34:\"No manager (use GMap API directly)\";b:1;s:35:\"GMaps Utility Library MarkerManager\";b:1;s:37:\"GMaps Utility Library MarkerClusterer\";b:1;s:30:\"Martin Pearman\'s ClusterMarker\";b:1;s:25:\"Unmanaged marker settings\";b:1;s:44:\"There are no settings for unmanaged markers.\";b:1;s:22:\"MarkerManager settings\";b:1;s:67:\"Name of downloaded file in the thirdparty folder. Default: %default\";b:1;s:14:\"Border padding\";b:1;s:24:\"MarkerClusterer settings\";b:1;s:69:\"At this zoom and above, all markers will be shown without clustering.\";b:1;s:49:\"MarkerClusterer styles in JSON. Read description!\";b:1;s:15:\"Zoom to Cluster\";b:1;s:22:\"ClusterMarker settings\";b:1;s:33:\"Whether to use clustering or not.\";b:1;s:35:\"Maximum zoom for zooming to cluster\";b:1;s:71:\"When clicking on a cluster, the map will not zoom in farther than this.\";b:1;s:17:\"Intersect Padding\";b:1;s:19:\"Custom markers path\";b:1;s:51:\"Fill in your custom markers folder (absolute path).\";b:1;s:13:\"Bubble styles\";b:1;s:17:\"infobubble plugin\";b:1;s:18:\"Use custom bubble?\";b:1;s:69:\"If you don\'t intend to style your popup bubble, leave this unchecked.\";b:1;s:22:\"Bubble styles to apply\";b:1;s:18:\"Bubble styles help\";b:1;s:28:\"the infobubble documentation\";b:1;s:23:\"See !link for examples.\";b:1;s:60:\"Options: 0 (no shadow), 1 (default shadow), 2 (sharp shadow)\";b:1;s:49:\"Like the css property, the padding of the bubble.\";b:1;s:58:\"Like the css property, the radius of the bubble\'s corners.\";b:1;s:57:\"Like the css property, the width in pixels of the border.\";b:1;s:58:\"Like the css property, the hex or rgb color of the border.\";b:1;s:34:\"A css class for the entire bubble.\";b:1;s:55:\"Like the css property, the minimum width of the bubble.\";b:1;s:55:\"Like the css property, the maximum width of the bubble.\";b:1;s:56:\"Like the css property, the maximum height of the bubble.\";b:1;s:68:\"The percent from the left of the bubble where the arrow will appear.\";b:1;s:62:\"The url of the image to use as the close button for the bubble\";b:1;s:68:\"Like the css property, the z-index of the close image. Default is 0.\";b:1;s:47:\"The height of the close image. Default is 12px.\";b:1;s:46:\"The width of the close image. Default is 12px.\";b:1;s:73:\"Like the css property, the position the close image. Default is absolute.\";b:1;s:29:\"Thickness of line, in pixels.\";b:1;s:57:\"Hex color value for fill color. Example: #<em>00AA33</em>\";b:1;s:32:\"Opacity of fill, from 0 to 100%.\";b:1;s:28:\"User Map (<em>map/user</em>)\";b:1;s:28:\"Node Map (<em>map/node</em>)\";b:1;s:32:\"Text at the top of the node map.\";b:1;s:35:\"Text at the bottom of the node map.\";b:1;s:16:\"Province display\";b:1;s:27:\"Display full province name.\";b:1;s:28:\"Display province/state code.\";b:1;s:27:\"Open map link in new window\";b:1;s:65:\"Select this if you want the map link to open in a separate window\";b:1;s:25:\"Open in new window method\";b:1;s:9:\"Map links\";b:1;s:18:\"Location utilities\";b:1;s:27:\"Tokens related to location.\";b:1;s:13:\"Location Name\";b:1;s:19:\"State/Province Name\";b:1;s:27:\"The location for this node.\";b:1;s:27:\"The location for this user.\";b:1;s:12:\"Marker title\";b:1;s:10:\"Marker key\";b:1;s:17:\"Default (address)\";b:1;s:16:\"Address with map\";b:1;s:8:\"Map only\";b:1;s:37:\"Multiple field values on a single map\";b:1;s:38:\"Google Maps geocoding minimum accuracy\";b:1;s:16:\"Unknown location\";b:1;s:22:\"Country level accuracy\";b:1;s:57:\"Region (state, province, prefecture, etc.) level accuracy\";b:1;s:54:\"Sub-region (county, municipality, etc.) level accuracy\";b:1;s:35:\"Town (city, village) level accuracy\";b:1;s:35:\"Post code (zip code) level accuracy\";b:1;s:21:\"Street level accuracy\";b:1;s:27:\"Intersection level accuracy\";b:1;s:22:\"Address level accuracy\";b:1;s:20:\"Clear province cache\";b:1;s:28:\"Clear supported country list\";b:1;s:34:\"Use map to pick search coordinates\";b:1;s:25:\"Requires the gmap module.\";b:1;s:41:\"Add geocoding address field to search map\";b:1;s:20:\"Macro for search map\";b:1;s:54:\"Enable choosing a marker for terms in this vocabulary.\";b:1;s:58:\"The number of locations that are required to be filled in.\";b:1;s:55:\"The maximum number of locations that can be associated.\";b:1;s:45:\"Number of locations that can be added at once\";b:1;s:56:\"The number of empty location forms to show when editing.\";b:1;s:19:\"Collection settings\";b:1;s:35:\"Display the location box collapsed.\";b:1;s:18:\"Coordinate Chooser\";b:1;s:10:\"www adress\";b:1;s:24:\"Hide fields from display\";b:1;s:14:\"Do not collect\";b:1;s:13:\"Force Default\";b:1;s:31:\"Display location in teaser view\";b:1;s:29:\"Display location in full view\";b:1;s:66:\"Here, you can change how locative data affects RSS feeds on nodes.\";b:1;s:63:\"Select how to use locations in RSS feeds for this content type.\";b:1;s:46:\"None (Do not put locational data in RSS feeds)\";b:1;s:39:\"Location 1.x-2.x compatible (buggy W3C)\";b:1;s:17:\"Territorio Muller\";b:1;s:18:\"gmap_macro_builder\";b:1;s:40:\"Add another location from node view page\";b:1;s:64:\"Display the \"Add another location\" option on the node view page.\";b:1;s:29:\"Location module form elements\";b:1;s:57:\"Usa <em>lugares</em> para engadir hoteis, restaurantes...\";b:1;s:17:\"Location #%number\";s:22:\"Localización #%number\";s:19:\"GMap Macro expander\";b:1;s:50:\"GMap macros will be displayed as interactive maps.\";b:1;s:22:\"Administer Easy Social\";b:1;s:28:\"Configure Easy Social module\";b:1;s:22:\"Use Easy Social Wizard\";b:1;s:29:\"Access the Easy Social Wizard\";b:1;s:20:\"Easy Social Settings\";b:1;s:43:\"Configure the social buttons and node types\";b:1;s:18:\"Easy Social Wizard\";b:1;s:49:\"Quickly enable Easy Social for your Content Types\";b:1;s:46:\"Flexible voting options for nodes and comments\";b:1;s:38:\"Add an expiration time to rate widgets\";b:1;s:24:\"Add a slider widget type\";b:1;s:21:\"Administer Voting API\";b:1;s:22:\"View rate results page\";b:1;s:11:\"Rate widget\";b:1;s:28:\"A rate widget for this node.\";b:1;s:31:\"Easy Social Global Ignore Paths\";b:1;s:30:\"Easy Social Global Widget Type\";b:1;s:26:\"Easy Social Global Widgets\";b:1;s:24:\"Easy Social Widget Order\";b:1;s:42:\"Enable Easy Social for nodes of type %type\";b:1;s:54:\"Enable Easy Social on comments for nodes of type %type\";b:1;s:52:\"Number of Easy Social fields for nodes of type %type\";b:1;s:42:\"Easy Social Widget type for nodes of %type\";b:1;s:38:\"Easy Social Widgets for nodes of %type\";b:1;s:28:\"Number of Easy Social blocks\";b:1;s:32:\"Override settings for this block\";b:1;s:11:\"Widget Type\";b:1;s:15:\"Enabled Widgets\";b:1;s:34:\"Easy Social Global Mention Account\";b:1;s:34:\"Easy Social Global Related Account\";b:1;s:38:\"Easy Social Global Twitter Description\";b:1;s:44:\"Easy Social Global Twitter Show Count option\";b:1;s:23:\"Facebook Application ID\";b:1;s:20:\"Facebook widget type\";b:1;s:24:\"Send Button (XFBML Only)\";b:1;s:10:\"Show faces\";b:1;s:15:\"Verb to display\";b:1;s:12:\"Color Scheme\";b:1;s:10:\"Annotation\";b:1;s:18:\"HTML5 valid syntax\";b:1;s:45:\"Easy Social Global LinkedIn Show Count option\";b:1;s:22:\"Easy Social Block !num\";b:1;s:11:\"Immediately\";s:14:\"Inmediatamente\";s:10:\"Voting API\";b:1;s:13:\"Vote tallying\";b:1;s:37:\"Tally results whenever a vote is cast\";b:1;s:26:\"Tally results at cron-time\";b:1;s:23:\"Anonymous vote rollover\";b:1;s:12:\"Vote results\";b:1;s:37:\"The value of an individual cast vote.\";b:1;s:60:\"The nature of the vote being cast (points, percentage, etc).\";b:1;s:46:\"An optional tag to group multi-criteria votes.\";b:1;s:27:\"The user who cast the vote.\";b:1;s:16:\"Individual voter\";b:1;s:49:\"Restrict votes to those cast by the current user.\";b:1;s:45:\"The IP address of the user who cast the vote.\";b:1;s:27:\"The time the vote was cast.\";b:1;s:64:\"The nature of the results in question (points, percentage, etc).\";b:1;s:48:\"An optional tag to group multi-criteria results.\";b:1;s:52:\"The aggregate function used to calculate the result.\";b:1;s:37:\"The time the results were calculated.\";b:1;s:65:\"Configure sitewide settings for user-generated ratings and votes.\";b:1;s:7:\"Compact\";s:8:\"Compacto\";s:8:\"Fivestar\";s:8:\"Fivestar\";s:12:\"Node display\";b:1;s:21:\"Machine readable name\";b:1;s:10:\"Percentage\";b:1;s:17:\"Display in teaser\";b:1;s:17:\"Above the content\";b:1;s:17:\"Below the content\";b:1;s:53:\"Select the node types on which to enable this widget.\";b:1;s:12:\"Rate widgets\";b:1;s:22:\"Manage rating widgets.\";b:1;s:10:\"Add widget\";b:1;s:45:\"You do not have any rate widgets defined yet.\";b:1;s:24:\"Do not add automatically\";b:1;s:9:\"Thumbs up\";b:1;s:16:\"Thumbs up / down\";b:1;s:16:\"You voted !vote.\";b:1;s:14:\"Voting results\";b:1;s:34:\"Redirect to login and show message\";b:1;s:43:\"Redirect to login but do not show a message\";b:1;s:51:\"Show a disabled widget (with non clickable buttons)\";b:1;s:11:\"Hide widget\";b:1;s:45:\"Behaviour when user has no permission to vote\";b:1;s:42:\"Allow author to rate his / her own content\";b:1;s:67:\"Will change the state to disabled. Always true for anonymous users.\";b:1;s:16:\"Number up / down\";b:1;s:7:\"Emotion\";b:1;s:8:\"Yes / no\";b:1;s:6:\"Slider\";b:1;s:20:\"Easy Social settings\";b:1;s:18:\"Enable Easy Social\";b:1;s:61:\"Check this option to enable easy social for this content type\";b:1;s:28:\"Number of Easy Social fields\";b:1;s:15:\"Type of buttons\";s:16:\"Tipos de botóns\";s:14:\"Social Widgets\";s:15:\"Widgets sociais\";s:13:\"Extra Widgets\";b:1;s:26:\"Extra settings for widgets\";b:1;s:21:\"Extra Widget Settings\";b:1;s:8:\"Facebook\";b:1;s:27:\"Extra settings for Facebook\";b:1;s:7:\"Google+\";b:1;s:26:\"Extra settings for Google+\";b:1;s:8:\"LinkedIn\";b:1;s:27:\"Extra settings for LinkedIn\";b:1;s:7:\"Twitter\";s:7:\"Twitter\";s:26:\"Extra settings for Twitter\";b:1;s:12:\"Ignore Paths\";b:1;s:53:\"Global paths to ignore and do not display Easy Social\";b:1;s:19:\"Easy Social Summary\";b:1;s:12:\"Widget Order\";b:1;s:13:\"Bot detection\";b:1;s:18:\"1 minute threshold\";b:1;s:16:\"1 hour threshold\";b:1;s:20:\"BotScout.com API key\";b:1;s:36:\"Define the available voting buttons.\";b:1;s:18:\"Add another option\";b:1;s:17:\"Translate options\";b:1;s:11:\"Full widget\";b:1;s:12:\"Display only\";b:1;s:21:\"Display only, compact\";b:1;s:23:\"Appearance in full node\";b:1;s:20:\"Appearance in teaser\";b:1;s:22:\"Appearance in comments\";b:1;s:62:\"Optional description which will be visible on the rate widget.\";b:1;s:23:\"Display in compact mode\";b:1;s:11:\"Interaction\";b:1;s:14:\"Average rating\";b:1;s:40:\"Users vote if available, empty otherwise\";b:1;s:42:\"Users vote if available, average otherwise\";b:1;s:33:\"Which rating should be displayed?\";b:1;s:10:\"Users vote\";b:1;s:58:\"Which rating should be displayed when the user just voted?\";b:1;s:57:\"Should a second click on the same button delete the vote?\";b:1;s:36:\"Example: the Facebook \"Like\" button.\";b:1;s:22:\"Use source translation\";b:1;s:26:\"The widget has been saved.\";b:1;s:34:\"Display Easy Social share widgets.\";s:32:\"Amosar os widgets de Easy Social\";s:9:\"Slideshow\";s:13:\"Presentación\";s:8:\"Previous\";s:8:\"Anterior\";s:4:\"Move\";b:1;s:4:\"Sync\";b:1;s:6:\"Linear\";b:1;s:8:\"Selector\";b:1;s:4:\"Fade\";b:1;s:5:\"Slide\";b:1;s:15:\"Animation Speed\";b:1;s:17:\"Enable debug mode\";b:1;s:16:\"Advanced Options\";b:1;s:9:\"Namespace\";b:1;s:5:\"Pause\";b:1;s:15:\"Slideshow speed\";b:1;s:40:\"General Slideshow and Animation Settings\";b:1;s:26:\"Select your animation type\";b:1;s:44:\"Set the speed of animations, in milliseconds\";b:1;s:56:\"Select the sliding direction, \"horizontal\" or \"vertical\"\";b:1;s:32:\"Animate the slides automatically\";b:1;s:41:\"Add controls for previous/next navigation\";b:1;s:19:\"Keyboard Navigation\";b:1;s:21:\"Mousewheel Navigation\";b:1;s:24:\"Add Pause/Play Indicator\";b:1;s:17:\"Pause On Controls\";b:1;s:26:\"Manual controls (Advanced)\";b:1;s:6:\"Insert\";b:1;s:12:\"Insert Video\";b:1;s:30:\"Enable Easy Social on comments\";b:1;s:72:\"Check this option to enable easy social for this content type\'s comments\";b:1;s:16:\"Easy Social !num\";b:1;s:25:\"Access Backup and Migrate\";s:28:\"Acceder a Backup and Migrate\";s:44:\"Access the Backup and Migrate admin section.\";s:60:\"Acceder á sección de administración de Backup and Migrate\";s:16:\"Perform a backup\";s:33:\"Realizar unha copia de seguridade\";s:39:\"Back up any of the available databases.\";s:70:\"Facer copia de seguridade de calquera das bases de datos dispoñibles.\";s:19:\"Access backup files\";s:43:\"Acceder aos arquivos de copia de seguridade\";s:56:\"Access and download the previously created backup files.\";s:75:\"Acceder e descargar os arquivos de copia de seguridade creados previamente.\";s:19:\"Delete backup files\";s:39:\"Eliminar achivos de copia de seguridade\";s:43:\"Delete the previously created backup files.\";s:66:\"Eliminar os arquivos de copia de seguridade creados anteriormente.\";s:16:\"Restore the site\";s:17:\"Restaurar o sitio\";s:47:\"Restore the site\'s database from a backup file.\";s:75:\"Restaurar a base de datos do sitio desde un arquivo de copia de seguridade.\";s:29:\"Administer Backup and Migrate\";s:30:\"Administrar Backup and Migrate\";s:61:\"Edit Backup and Migrate profiles, schedules and destinations.\";s:74:\"Editar os perfís, as planificaciones e os destinos de Backup and Migrate.\";s:17:\"Untitled Schedule\";s:26:\"Tarefa programada sen nome\";s:9:\"Schedules\";b:1;s:8:\"Schedule\";s:13:\"Programación\";s:16:\"Server Directory\";s:22:\"Directorio do servidor\";s:61:\"Save the backup files to the NodeSquirrel.com backup service.\";s:85:\"Garde os arquivos de copia de seguridade para o servizo de respaldo NodeSquirrel.com.\";s:16:\"NodeSquirrel.com\";s:16:\"NodeSquirrel.com\";s:58:\"Save the backup files to any a directory on an FTP server.\";s:51:\"Gardar os arquivos nun directorio dun servidor FTP.\";s:13:\"FTP Directory\";s:14:\"Directorio FTP\";s:17:\"Amazon S3 account\";s:15:\"Conta Amazon S3\";s:48:\"Save the backup files to a bucket on your !link.\";s:66:\"Gardar os arquivos de copia de seguridade nun espazo no seu !link.\";s:16:\"Amazon S3 Bucket\";s:16:\"Amazon S3 Bucket\";s:70:\"Send the backup as an email attachment to the specified email address.\";s:113:\"Enviar a copia de seguridade como arquivo achego nun correo ás direccións de correo electrónico especificadas.\";s:8:\"Database\";b:1;s:14:\"MySQL Database\";s:19:\"Base de datos MySQL\";s:46:\"A files directory which can be backed up from.\";s:63:\"Un directorio de arquivos desde o cal pódese facer o respaldo.\";s:14:\"File Directory\";s:22:\"Directorio de arquivos\";s:38:\"Create an archive of your entire site.\";b:1;s:12:\"Site Archive\";s:16:\"Arquivo do sitio\";s:12:\"Destinations\";s:8:\"Destinos\";s:11:\"Destination\";b:1;s:24:\"Manual Backups Directory\";s:42:\"Directorio de copias de seguridade manuais\";s:27:\"Scheduled Backups Directory\";s:46:\"Directorio de copias de seguridade programadas\";s:12:\"NodeSquirrel\";s:12:\"NodeSquirrel\";s:14:\"No Compression\";b:1;s:4:\"GZip\";s:4:\"GZip\";s:4:\"BZip\";s:4:\"BZip\";s:16:\"Default Database\";s:28:\"Base de datos predeterminada\";s:22:\"Public Files Directory\";s:32:\"Directorio público de ficheiros\";s:23:\"Private Files Directory\";s:31:\"Directorio de arquivos privados\";s:30:\"Entire Site (code, files & DB)\";s:50:\"Sitio completo (código, arquivos e base de datos)\";s:16:\"Untitled Profile\";s:15:\"Perfil sen nome\";s:17:\"Settings Profiles\";s:26:\"Perfís de configuracións\";s:16:\"Settings Profile\";s:18:\"Opcións do perfil\";s:23:\"Backup Settings Profile\";s:48:\"Perfil de configuracións da copia de seguridade\";s:31:\"Backup and Migrate Quick Backup\";s:49:\"Copia de seguridade rápida de Backup and Migrate\";s:15:\"restore feature\";s:32:\"Característica de recuperación\";s:16:\"Quick Backup Tab\";s:25:\"Pestana de backup rápido\";s:70:\"Use this form to run simple manual backups of your database and files.\";s:100:\"Empregue este formulario para facer copias de seguridade manuais da súa base de datos ou ficheiros.\";s:19:\"Advanced Backup Tab\";s:26:\"Pestana de backup avanzado\";s:17:\"settings profiles\";s:24:\"Perfil de configuración\";s:11:\"Restore Tab\";s:24:\"Pestana de recuperación\";s:9:\"schedules\";s:15:\"Planificacións\";s:14:\"manual backups\";s:15:\"backups manuais\";s:10:\"Scheduling\";s:14:\"Planificación\";s:18:\"Importing Settings\";s:25:\"Importando configuración\";s:9:\"help page\";s:16:\"páxina de axuda\";s:52:\"Visit the !helppage for more help using this module.\";s:57:\"Visite a !helppage para máis axuda do uso deste módulo.\";s:18:\"Backup and Migrate\";s:18:\"Backup and Migrate\";s:12:\"Quick Backup\";s:14:\"Backup rápido\";s:13:\"Backup Source\";s:28:\"Orixe da copia de seguridade\";s:5:\"Local\";b:1;s:7:\"Offsite\";s:13:\"Sitio externo\";s:18:\"Backup Destination\";s:30:\"Destino da copia de seguridade\";s:22:\"Create new destination\";s:21:\"Crear un novo destino\";s:35:\"Save a copy to a second destination\";s:38:\"Gardar unha copia a un segundo destino\";s:25:\"Second Backup Destination\";s:38:\"Destino da segunda copia de seguridade\";s:16:\"Default Settings\";b:1;s:24:\"Add a note to the backup\";s:40:\"Engadir unha nota á copia de seguridade\";s:10:\"Backup now\";s:31:\"Facer copia de seguridade agora\";s:23:\"Save an offsite copy to\";s:45:\"Garde unha copia fóra das instalacións para\";s:20:\"Save a local copy to\";s:25:\"Gardar unha copia local a\";s:6:\"Backup\";b:1;s:20:\"Backup the database.\";b:1;s:11:\"Delete File\";b:1;s:20:\"Delete a backup file\";b:1;s:17:\"Destination Files\";b:1;s:19:\"Restore from backup\";b:1;s:49:\"Restore database from a backup file on the server\";b:1;s:15:\"Advanced Backup\";s:28:\"Copia de seguridade avanzada\";s:10:\"List !type\";s:12:\"Listar !type\";s:43:\"Restore the database from a previous backup\";b:1;s:9:\"Add !type\";b:1;s:13:\"Saved Backups\";s:15:\"Copias gardadas\";s:26:\"Previously created backups\";s:42:\"Copias de seguridade creadas anteriormente\";s:16:\"Module settings.\";s:26:\"Configuracións do módulo\";s:35:\"Import backup and migrate settings.\";s:61:\"Importa configuracións de copias de seguridade e migración.\";s:37:\"Backup my !from to !to using !profile\";s:44:\"Apoiar o meu !from a !to utilizando !profile\";s:31:\"-- Select a Settings Profile --\";s:44:\"-- Seleccione un Perfil de Configuración --\";s:64:\"You can load a profile. Any changes you made below will be lost.\";b:1;s:13:\"Load Settings\";b:1;s:12:\"Load Profile\";b:1;s:18:\"View as checkboxes\";s:31:\"Ver como casillas de selección\";s:11:\"Backup File\";s:30:\"Arquivo de copia de seguridade\";s:16:\"Backup file name\";b:1;s:36:\"You can use tokens in the file name.\";s:44:\"Pode utilizar reemplazos no nome do arquivo.\";s:19:\"Append a timestamp.\";s:24:\"Agregar un selo temporal\";s:16:\"Timestamp format\";s:24:\"Formato do selo temporal\";s:56:\"Should be a PHP <a href=\"!url\">date()</a> format string.\";s:65:\"Debe ser unha cadea de formato  <a href=\"!url\">date()</a> de PHP.\";s:32:\"Send an email if backup succeeds\";s:51:\"Enviar un correo electrónico si a copia ten éxito\";s:33:\"Email Address for Success Notices\";s:63:\"Dirección de correo electrónico para notificaciones de éxito\";s:29:\"Send an email if backup fails\";s:57:\"Enviar correo electrónico si a copia de seguridade falla\";s:33:\"Email Address for Failure Notices\";s:61:\"Dirección de correo electrónico para notificaciones de erro\";s:11:\"Compression\";s:11:\"Compresión\";s:39:\"Exclude the following tables altogether\";b:1;s:57:\"The selected tables will not be added to the backup file.\";b:1;s:42:\"Exclude the data from the following tables\";b:1;s:25:\"Lock tables during backup\";s:34:\"Bloquear táboas durante o copiado\";s:20:\"!name Backup Options\";s:37:\"!name opcións de copia de seguridade\";s:42:\"Exclude the following files or directories\";s:45:\"Excluír os seguintes arquivos ou directorios\";s:13:\"No Encryption\";b:1;s:15:\"File Encryption\";s:18:\"Cifrado de arquivo\";s:21:\"AES Encryption Module\";s:22:\"Módulo de cifrado AES\";s:51:\"Install the !link to enable backup file encryption.\";s:76:\"Instale o !link para activar o encriptado do arquivo da copia de seguridade.\";s:17:\"Take site offline\";s:36:\"Cambiar o sitio a modo de mantemento\";s:21:\"Site off-line message\";s:29:\"Mensaxe de sitio desconectado\";s:59:\"Message to show visitors when the site is in off-line mode.\";s:69:\"Mensaxe que se amosa aos visitantes cando o sitio está desconectado.\";s:10:\"Add a note\";s:17:\"Engadir unha nota\";s:36:\"Add a short note to the backup file.\";s:58:\"Engadir unha nota curta ao arquivo da copia de seguridade.\";s:16:\"Use cli commands\";s:56:\"Utilice comandos da interfase de liña de comandos (cli)\";s:13:\"Ignore errors\";s:13:\"Ignorar erros\";s:20:\"Save these settings.\";s:27:\"Gardar esta configuración.\";s:20:\"Save the settings as\";s:28:\"Gardar a configuración como\";s:30:\"Replace the \'%profile\' profile\";s:30:\"Reemplazar o perfil \'%profile\'\";s:18:\"Create new profile\";s:17:\"Crear novo perfil\";s:23:\"Save Without Backing Up\";s:39:\"Gardar sen realizar copia de seguridade\";s:27:\"%num SQL commands executed.\";s:29:\"%num comandos SQL executados.\";s:39:\"<a href=\"!restoreurl\">Restore again</a>\";b:1;s:65:\"%source restored from %dest file %file in !time. !action (!links)\";b:1;s:40:\"Filter any Views !base_table date field.\";b:1;s:11:\"Easy Social\";b:1;s:30:\"@field-label - @property-label\";b:1;s:55:\"The marker name GMap Taxonomy associates with the node.\";b:1;s:44:\"Locations are addresses and map coordinates.\";b:1;s:32:\"The location ID of the location.\";b:1;s:34:\"The name of the selected location.\";b:1;s:44:\"The street address of the selected location.\";b:1;s:51:\"Additional street address of the selected location.\";b:1;s:34:\"The city of the selected location.\";b:1;s:63:\"The coordinates of the selected location in \'lat, long\' format.\";b:1;s:42:\"The entire address block for the location.\";b:1;s:43:\"The email address of the selected location.\";b:1;s:40:\"The fax number of the selected location.\";b:1;s:42:\"The phone number of the selected location.\";b:1;s:3:\"www\";b:1;s:40:\"The www number of the selected location.\";b:1;s:9:\"Locations\";s:11:\"Ubicacións\";s:17:\"Top rated content\";b:1;s:10:\"Your votes\";b:1;s:19:\"Lista de selección\";b:1;s:14:\"backup_migrate\";b:1;s:5:\"1 day\";b:1;s:11:\"@count days\";b:1;s:6:\"1 week\";b:1;s:29:\"Registered user vote rollover\";b:1;s:10:\"GMap Macro\";b:1;s:11:\"GMap marker\";b:1;s:13:\"Localización\";b:1;s:22:\"Location field: !field\";b:1;s:21:\"Nome da localización\";b:1;s:6:\"Cidade\";b:1;s:21:\"Estado actual: !state\";b:1;s:14:\"Código postal\";b:1;s:5:\"País\";b:1;s:31:\"Enderezo de correo electrónico\";b:1;s:14:\"Número de fax\";b:1;s:20:\"Número de teléfono\";b:1;s:11:\"Edit widget\";b:1;s:22:\"change the widget type\";b:1;s:40:\"This is a %type widget. You may !change.\";b:1;s:29:\"Restore from an uploaded file\";s:45:\"Restaurar desde un fichero subido ao servidor\";s:20:\"Upload a Backup File\";s:39:\"Subir un arquivo de copia de seguridade\";s:27:\"Restore from a saved backup\";s:48:\"Restaurar desde unha copia de seguridade salvada\";s:9:\"Location:\";s:14:\"Localización:\";s:10:\"Restore to\";s:11:\"Restaurar a\";s:11:\"Restore now\";b:1;s:7:\"Source:\";b:1;s:39:\"Showing @start to @end of @total files.\";s:46:\"Mostrando de @start a @end de @total arquivos.\";s:70:\"Allow the use of checkboxes or radio buttons for exposed Views filters\";b:1;s:69:\"Enables modules to work with any entity type and to provide entities.\";b:1;s:51:\"Provides a field that can reference other entities.\";b:1;s:71:\"Provides some example code for implementing Entity Reference behaviors.\";b:1;s:69:\"Generates random locations to test IP Geolocation Views & Maps module\";b:1;s:55:\"Provides additional formatters for various field types.\";b:1;s:17:\"administer blocks\";b:1;s:25:\"access backup and migrate\";b:1;s:19:\"access backup files\";b:1;s:29:\"administer backup and migrate\";b:1;s:19:\"delete backup files\";b:1;s:14:\"perform backup\";b:1;s:19:\"restore from backup\";b:1;s:19:\"administer comments\";b:1;s:17:\"edit own comments\";b:1;s:21:\"skip comment approval\";b:1;s:13:\"post comments\";b:1;s:15:\"access comments\";b:1;s:23:\"access contextual links\";b:1;s:17:\"use ctools import\";b:1;s:16:\"access dashboard\";b:1;s:22:\"administer easy social\";b:1;s:22:\"use easy social wizard\";b:1;s:29:\"use text format filtered_html\";b:1;s:25:\"use text format full_html\";b:1;s:18:\"administer filters\";b:1;s:21:\"administer flexslider\";b:1;s:13:\"view node map\";b:1;s:26:\"view user location details\";b:1;s:13:\"view user map\";b:1;s:17:\"create gmap macro\";b:1;s:31:\"administer content translations\";b:1;s:23:\"administer image styles\";b:1;s:15:\"administer imce\";b:1;s:20:\"administer languages\";b:1;s:19:\"translate interface\";b:1;s:25:\"submit latitude/longitude\";b:1;s:23:\"view location directory\";b:1;s:24:\"view node location table\";b:1;s:24:\"view user location table\";b:1;s:15:\"administer menu\";b:1;s:24:\"administer module filter\";b:1;s:27:\"delete own activity content\";b:1;s:23:\"create activity content\";b:1;s:25:\"edit any activity content\";b:1;s:25:\"edit own activity content\";b:1;s:27:\"delete any activity content\";b:1;s:26:\"delete own archive content\";b:1;s:22:\"create archive content\";b:1;s:24:\"edit any archive content\";b:1;s:24:\"edit own archive content\";b:1;s:26:\"delete any archive content\";b:1;s:24:\"delete own place content\";b:1;s:20:\"create place content\";b:1;s:22:\"edit any place content\";b:1;s:22:\"edit own place content\";b:1;s:24:\"delete any place content\";b:1;s:23:\"delete own page content\";b:1;s:19:\"create page content\";b:1;s:21:\"edit any page content\";b:1;s:21:\"edit own page content\";b:1;s:23:\"delete any page content\";b:1;s:16:\"delete revisions\";b:1;s:16:\"revert revisions\";b:1;s:14:\"access content\";b:1;s:28:\"view own unpublished content\";b:1;s:14:\"view revisions\";b:1;s:23:\"access content overview\";b:1;s:16:\"administer nodes\";b:1;s:24:\"administer content types\";b:1;s:18:\"bypass node access\";b:1;s:22:\"administer url aliases\";b:1;s:18:\"create url aliases\";b:1;s:22:\"view rate results page\";b:1;s:17:\"administer search\";b:1;s:14:\"search content\";b:1;s:19:\"use advanced search\";b:1;s:20:\"administer shortcuts\";b:1;s:24:\"customize shortcut links\";b:1;s:20:\"switch shortcut sets\";b:1;s:17:\"administer themes\";b:1;s:18:\"administer actions\";b:1;s:18:\"administer modules\";b:1;s:18:\"block IP addresses\";b:1;s:27:\"access administration pages\";b:1;s:31:\"access site in maintenance mode\";b:1;s:27:\"administer software updates\";b:1;s:29:\"administer site configuration\";b:1;s:19:\"access site reports\";b:1;s:29:\"view the administration theme\";b:1;s:19:\"administer taxonomy\";b:1;s:15:\"edit terms in 1\";b:1;s:15:\"edit terms in 2\";b:1;s:17:\"delete terms in 1\";b:1;s:17:\"delete terms in 2\";b:1;s:14:\"access toolbar\";b:1;s:17:\"translate content\";b:1;s:19:\"change own username\";b:1;s:20:\"access user profiles\";b:1;s:22:\"administer permissions\";b:1;s:16:\"administer users\";b:1;s:14:\"cancel account\";b:1;s:34:\"select account cancellation method\";b:1;s:23:\"administer video styles\";b:1;s:21:\"administer voting api\";b:1;s:23:\"translate admin strings\";b:1;s:30:\"translate user-defined strings\";b:1;s:16:\"administer views\";b:1;s:16:\"access all views\";b:1;s:49:\"Uses the jsDelivr CDN for all CSS and JavaScript.\";b:1;s:56:\"Supports dynamic dependency for entity reference fields.\";b:1;s:44:\"Nodes represent the main site content items.\";b:1;s:14:\"Uploaded file.\";b:1;s:37:\"Remark or note that refers to a node.\";b:1;s:48:\"Taxonomy terms are used for classifying content.\";b:1;s:21:\"Taxonomy vocabularies\";b:1;s:15:\"Rendered entity\";b:1;s:27:\"The subject of the comment.\";b:1;s:26:\"The author of the comment.\";b:1;s:48:\"Whether the comment is published or unpublished.\";b:1;s:14:\"Field \"@name\".\";b:1;s:9:\"The file.\";b:1;s:20:\"The file description\";b:1;s:36:\"Whether the file is being displayed.\";b:1;s:15:\"The image file.\";b:1;s:24:\"The \"Alt\" attribute text\";b:1;s:26:\"The \"Title\" attribute text\";b:1;s:22:\"The title of the link.\";b:1;s:20:\"The URL of the link.\";b:1;s:27:\"The attributes of the link.\";b:1;s:26:\"The unique ID of the node.\";b:1;s:37:\"The unique ID of the node\'s revision.\";b:1;s:6:\"Is new\";b:1;s:58:\"Whether the node is new and not saved to the database yet.\";b:1;s:45:\"Whether the node is published or unpublished.\";b:1;s:21:\"Promoted to frontpage\";b:1;s:46:\"Whether the node is promoted to the frontpage.\";b:1;s:15:\"Sticky in lists\";b:1;s:70:\"Whether the node is displayed at the top of lists in which it appears.\";b:1;s:58:\"The original-language version of this node, if one exists.\";b:1;s:16:\"Creates revision\";b:1;s:48:\"Whether saving this node creates a new revision.\";b:1;s:72:\"The weight of the term, which is used for ordering terms during display.\";b:1;s:38:\"The parent terms of the taxonomy term.\";b:1;s:16:\"All parent terms\";s:20:\"Todos os termos pais\";s:65:\"Ancestors of the term, i.e. parent of all above hierarchy levels.\";b:1;s:44:\"The machine name of the taxonomy vocabulary.\";b:1;s:33:\"The url of the account edit page.\";b:1;s:41:\"The date the user last accessed the site.\";b:1;s:22:\"The roles of the user.\";b:1;s:38:\"Whether the user is active or blocked.\";b:1;s:25:\"The user\'s default theme.\";b:1;s:14:\"Logged in user\";b:1;s:29:\"The currently logged in user.\";b:1;s:26:\"The current date and time.\";b:1;s:48:\"Information related to the current page request.\";b:1;s:53:\"The internal Drupal path of the current page request.\";b:1;s:41:\"The full URL of the current page request.\";b:1;s:35:\"The size of the file, in kilobytes.\";b:1;s:16:\"Comments allowed\";b:1;s:18:\"The node comments.\";b:1;s:18:\"The main body text\";b:1;s:57:\"The language code of the current user interface language.\";b:1;s:16:\"Content language\";b:1;s:50:\"The language code of the current content language.\";b:1;s:26:\"(No information available)\";b:1;s:21:\"Rendered @entity-type\";b:1;s:72:\"The @entity-type of the current relationship rendered using a view mode.\";b:1;s:6:\"Entity\";b:1;s:32:\"Displays a single chosen entity.\";b:1;s:25:\"Location from !field_name\";b:1;s:62:\"Renders a single entity in a specific view mode (e.g. teaser).\";b:1;s:60:\"The following properties may be appended to the token: @keys\";b:1;s:39:\"Tokens related to the \"@name\" entities.\";b:1;s:17:\"List of @entities\";b:1;s:20:\"List of @type values\";b:1;s:33:\"Tokens for lists of @type values.\";b:1;s:23:\"@type with delta @delta\";b:1;s:21:\"A partir de que data?\";b:1;s:67:\"Provides the ability to group your fields on both form and display.\";b:1;s:53:\"Table that contains field group entries and settings.\";s:68:\"Táboa que contén as entradas de campo de grupos e configuracións.\";s:22:\"Administer fieldgroups\";b:1;s:43:\"Display the administration for fieldgroups.\";b:1;s:39:\"Language settings for the user account.\";s:52:\"Configuración de idioma para esta conta de usuario.\";s:14:\"Wysiwyg status\";s:14:\"estado WYSIWYG\";s:13:\"Add new group\";s:21:\"Engadir un novo grupo\";s:3:\"Div\";s:3:\"Div\";s:5:\"HTML5\";b:1;s:69:\"This fieldgroup renders the inner content in a semantic HTML5 wrapper\";b:1;s:8:\"Fieldset\";s:18:\"Conxunto de campos\";s:19:\"Vertical tabs group\";s:25:\"Grupo vertical de solapas\";s:70:\"This fieldgroup renders child groups in its own vertical tabs wrapper.\";b:1;s:12:\"Vertical tab\";s:25:\"Grupo vertical de solapas\";s:21:\"Horizontal tabs group\";b:1;s:72:\"This fieldgroup renders child groups in its own horizontal tabs wrapper.\";b:1;s:14:\"Horizontal tab\";b:1;s:15:\"Multipage group\";b:1;s:49:\"This fieldgroup renders groups on separate pages.\";b:1;s:9:\"Multipage\";s:12:\"Multipáxina\";s:46:\"This fieldgroup renders the content in a page.\";b:1;s:15:\"Accordion group\";s:18:\"Grupo de acordeón\";s:57:\"This fieldgroup renders child groups as jQuery accordion.\";b:1;s:14:\"Accordion item\";s:21:\"Elemento de acordeón\";s:70:\"This fieldgroup renders the content in a div, part of accordion group.\";b:1;s:19:\"Horizontal tab item\";s:29:\"Elemento de solapa horizontal\";s:19:\"Label for new group\";b:1;s:20:\"Weight for new group\";s:22:\"Peso para o novo grupo\";s:20:\"Parent for new group\";b:1;s:26:\"Machine name for new group\";b:1;s:24:\"Group name (a-z, 0-9, _)\";s:27:\"Nome do grupo (a-z, 0-9, _)\";s:11:\"Fieldgroups\";s:16:\"Grupos de campos\";s:31:\"Select source view mode or form\";b:1;s:64:\"Clone fieldgroups from selected view mode to the current display\";b:1;s:38:\"New group %label successfully created.\";b:1;s:17:\"Field group label\";s:27:\"Etiqueta do grupo de campos\";s:19:\"Fieldgroup settings\";b:1;s:54:\"Mark group as required if it contains required fields.\";b:1;s:17:\"Extra CSS classes\";s:16:\"Clases CSS extra\";s:45:\"Please enter a label for collapsible elements\";b:1;s:8:\"Arquivar\";b:1;s:19:\"Field group format:\";b:1;s:35:\"Usa <em>banners</em> para anuncios.\";b:1;s:25:\"delete own banner content\";b:1;s:21:\"create banner content\";b:1;s:23:\"edit any banner content\";b:1;s:23:\"edit own banner content\";b:1;s:25:\"delete any banner content\";b:1;s:15:\"edit terms in 3\";b:1;s:17:\"delete terms in 3\";b:1;s:22:\"administer fieldgroups\";b:1;s:37:\"View translation overview assignments\";b:1;s:49:\"Allow users to view the translations assignments.\";b:1;s:48:\"Manage %language translation overview priorities\";b:1;s:20:\"Translation overview\";s:21:\"Resumo da traducción\";s:50:\"View the translation status of the site\'s content.\";b:1;s:41:\"manage es translation overview priorities\";b:1;s:41:\"manage gl translation overview priorities\";b:1;s:41:\"manage en translation overview priorities\";b:1;s:37:\"view translation overview assignments\";b:1;s:22:\"Up-to-date translation\";s:22:\"Tradución actualizada\";s:13:\"High priority\";s:15:\"Prioridade alta\";s:7:\"Ignored\";s:8:\"Ignorado\";s:8:\"Complete\";s:8:\"Completa\";s:21:\"completed translation\";s:20:\"traducción completa\";s:11:\"Out-of-date\";s:8:\"Caducado\";s:23:\"out-of-date translation\";s:19:\"tradución caducada\";s:12:\"Untranslated\";s:12:\"Sen traducir\";s:20:\"untranslated content\";s:21:\"contido non traducido\";s:22:\"Translator assignments\";b:1;s:34:\"View the translations assignments.\";b:1;s:17:\"Toggle navigation\";b:1;s:17:\"File requirements\";b:1;s:19:\"Opens in new window\";b:1;s:5:\"first\";b:1;s:8:\"previous\";b:1;s:4:\"next\";b:1;s:4:\"last\";b:1;s:40:\"There are currently @count users online.\";b:1;s:20:\"translation_overview\";s:20:\"translation_overview\";s:7:\"Lateral\";b:1;s:8:\"Opcións\";b:1;s:49:\"Are you sure you want to delete the group %group?\";b:1;s:62:\"The group %group has been deleted from the %type content type.\";b:1;s:50:\"Checked available update data for @count projects.\";b:1;s:8:\"download\";b:1;s:8:\"!time ms\";s:8:\"!time ms\";s:7:\"restore\";s:9:\"restaurar\";s:8:\"view all\";s:8:\"ver todo\";s:7:\"Element\";b:1;s:8:\"Header 2\";s:11:\"Cabeceira 2\";s:8:\"Header 3\";s:11:\"Cabeceira 3\";s:8:\"Priority\";s:10:\"Prioridade\";s:11:\"unpublished\";s:12:\"sen publicar\";s:4:\"High\";s:4:\"Alta\";s:6:\"Ignore\";s:7:\"Ignorar\";s:17:\"Click to edit it.\";b:1;s:16:\"Click to add it.\";b:1;s:17:\"Click to view it.\";b:1;s:15:\"Submit settings\";b:1;s:33:\"There is currently 1 user online.\";b:1;s:9:\"See map: \";b:1;s:14:\"User-submitted\";b:1;s:10:\"Re geocode\";b:1;s:38:\"Check this box to re-geocode location.\";b:1;s:32:\"Adds Book support to Node export\";b:1;s:74:\"Supply some common filter options to define node available to be exported.\";b:1;s:11:\"Node export\";b:1;s:46:\"Provides export functionality for url aliases.\";b:1;s:4:\"UUID\";b:1;s:20:\"Services - resources\";b:1;s:15:\"Administer UUID\";b:1;s:49:\"Allows configuration of the UUID module and APIs.\";b:1;s:12:\"Export nodes\";b:1;s:16:\"Export own nodes\";b:1;s:23:\"Use PHP to import nodes\";b:1;s:55:\"Required for importing, but can allow execution of PHP.\";b:1;s:4:\"JSON\";b:1;s:52:\"<a href=\"!json\">JavaScript Object Notation</a> code.\";b:1;s:17:\"Drupal var export\";b:1;s:45:\"<a href=\"!drupal\">Drupal var export</a> code.\";b:1;s:9:\"Serialize\";b:1;s:3:\"XML\";b:1;s:3:\"DSV\";b:1;s:16:\"General settings\";s:20:\"Configuración xeral\";s:13:\"Download file\";b:1;s:10:\"Paste code\";b:1;s:39:\"Configure the settings for Node export.\";b:1;s:30:\"Universally unique identifiers\";b:1;s:41:\"Configure universally unique identifiers.\";b:1;s:16:\"Node export code\";b:1;s:19:\"Node export: import\";b:1;s:42:\"Import content using <em>Node export</em>.\";b:1;s:20:\"Node export filename\";b:1;s:43:\"Tokens related to the Node export filename.\";b:1;s:12:\"Node ID list\";b:1;s:67:\"Comma separated list of Node IDs in square brackets (if available).\";b:1;s:29:\"The number of nodes exported.\";b:1;s:42:\"The timestamp when the file was generated.\";b:1;s:26:\"The format used to export.\";b:1;s:17:\"@entity_type UUID\";b:1;s:40:\"The universally unique ID of the @entity\";b:1;s:26:\"@entity_type revision UUID\";b:1;s:49:\"The universally unique revision ID of the @entity\";b:1;s:39:\"Allows assigning CSS classes to blocks.\";b:1;s:51:\"Provide the Basque Services: Zabaldu, Bildu, Aupatu\";b:1;s:48:\"Provide the Dutch Services: eKudos, Hyves, Nujij\";b:1;s:65:\"Provide the Farsi services: Balatarin, Donbaleh, Friendfa, Viwio.\";b:1;s:67:\"Add the page in your favorite, work with Chrome, Firefox, IE, Opera\";b:1;s:69:\"Add the support for Forward module which send the link through email.\";b:1;s:35:\"Provide the Hungarian Service: iWiW\";b:1;s:49:\"Provide the Polish Services: Blip, Wykop, Sledzik\";b:1;s:52:\"Add the ability to handle sprites with Service Links\";b:1;s:43:\"Provide the Swedish Services: Bloggy, Pusha\";b:1;s:24:\"Service Links - Services\";b:1;s:13:\"Service Links\";b:1;s:34:\"Provides additional search blocks.\";b:1;s:47:\"Provides Internationalization to Custom Search.\";b:1;s:41:\"Adds taxonomy selectors to Custom Search.\";b:1;s:24:\"Administer block classes\";b:1;s:27:\"Set CSS classes for blocks.\";b:1;s:16:\"Aside navigation\";b:1;s:13:\"CSS class(es)\";b:1;s:16:\"Search this site\";s:18:\"Buscar neste sitio\";s:10:\"Search for\";b:1;s:5:\"-Any-\";b:1;s:18:\"Filter the results\";b:1;s:21:\"Customize your search\";b:1;s:24:\"Administer custom search\";b:1;s:48:\"Allow users to administer custom search settings\";b:1;s:17:\"Use custom search\";b:1;s:32:\"Allow users to use custom search\";b:1;s:31:\"Administer custom search blocks\";b:1;s:55:\"Allow users to administer custom search blocks settings\";b:1;s:24:\"Use custom search blocks\";b:1;s:39:\"Allow users to use custom search blocks\";b:1;s:10:\"Search box\";s:14:\"Caixa de busca\";s:16:\"Number of blocks\";b:1;s:13:\"Display label\";b:1;s:13:\"Radio buttons\";b:1;s:10:\"Checkboxes\";b:1;s:13:\"Custom Search\";b:1;s:13:\"Submit button\";b:1;s:10:\"Label text\";b:1;s:74:\"Select the content types to present as search options in the search block.\";b:1;s:64:\"Select the content types to display on the advanced search form.\";b:1;s:13:\"Search Blocks\";b:1;s:49:\"Provide additional search blocks by content type.\";b:1;s:73:\"Select the vocabularies to present as search options in the search block.\";b:1;s:23:\"Access to Service Links\";b:1;s:30:\"Use PHP for Service visibility\";b:1;s:38:\"Administer Menu Trail By Path settings\";b:1;s:16:\"Print this label\";b:1;s:32:\"Label for service links in nodes\";b:1;s:13:\"Service links\";b:1;s:33:\"Service links with FishEye effect\";b:1;s:32:\"Service links for not-node pages\";b:1;s:15:\"Infinite Scroll\";b:1;s:10:\"New window\";s:11:\"Nova ventá\";s:11:\"Same window\";s:12:\"Mesma ventá\";s:33:\"Page specific visibility settings\";s:42:\"Configuración da visibilidade por páxina\";s:8:\"Services\";s:8:\"Servizos\";s:6:\"@label\";s:6:\"@label\";s:30:\"Bookmark/Search this post with\";s:30:\"Marque/Busque este envío con:\";s:6:\"Always\";b:1;s:12:\"Service Name\";b:1;s:10:\"Only Image\";b:1;s:14:\"Image and Text\";b:1;s:46:\"Don\'t show links if the content is unpublished\";b:1;s:13:\"Extra Options\";b:1;s:15:\"Open link in...\";b:1;s:37:\"Append the following text to your URL\";b:1;s:21:\"Share this on Twitter\";b:1;s:30:\"Bookmark this post on SlashDot\";b:1;s:29:\"Publish this post to LinkedIn\";b:1;s:33:\"Bookmark this post on Mister Wong\";b:1;s:22:\"No services available.\";b:1;s:36:\"Show for content types or categories\";b:1;s:27:\"Where to show service links\";b:1;s:36:\"Show Service Links on specific pages\";b:1;s:26:\"Service links in the links\";b:1;s:28:\"Service links in the content\";b:1;s:18:\"Menu trail by path\";b:1;s:36:\"Configure menu trail by path module.\";b:1;s:55:\"Control which and where service links should be active.\";b:1;s:26:\"Enable breadcrumb handling\";b:1;s:57:\"If checked, breadcrumb will be set according to url path.\";b:1;s:16:\"Search box label\";b:1;s:73:\"Enter the label text for the search box. The default value is \"!default\".\";b:1;s:27:\"Search box placeholder text\";b:1;s:20:\"Search box hint text\";b:1;s:15:\"Search operator\";b:1;s:15:\"Search box size\";b:1;s:32:\"The default value is \"!default\".\";b:1;s:25:\"Search box maximum length\";b:1;s:17:\"Submit image path\";b:1;s:12:\"Submit image\";b:1;s:24:\"Advanced search criteria\";b:1;s:69:\"Enter the label text for this field. The default value is \"!default\".\";b:1;s:6:\"Phrase\";b:1;s:8:\"Negative\";b:1;s:19:\"Custom search paths\";b:1;s:13:\"Selector type\";b:1;s:14:\"Drop-down list\";b:1;s:34:\"Choose which selector type to use.\";b:1;s:71:\"Enter the label text for the selector. The default value is \"!default\".\";b:1;s:17:\"Elements ordering\";b:1;s:29:\"Advanced search criterion: Or\";b:1;s:33:\"Advanced search criterion: Phrase\";b:1;s:35:\"Advanced search criterion: Negative\";b:1;s:24:\"Taxonomy terms separator\";b:1;s:66:\"Change the labels, the default texts and the ordering of elements.\";b:1;s:12:\"Results page\";b:1;s:34:\"Customize the search results page.\";b:1;s:24:\"Manage search languages.\";b:1;s:26:\"No elements in this region\";b:1;s:16:\"Content selector\";b:1;s:14:\"Other searches\";b:1;s:36:\"Drop-down list with multiple choices\";b:1;s:23:\"-Any content type- text\";b:1;s:66:\"Choosing -Any- restricts the search to the selected content types.\";b:1;s:64:\"If not checked, choosing -Any- will search in all content types.\";b:1;s:28:\"Force -Any- to be displayed.\";b:1;s:17:\"Content exclusion\";b:1;s:71:\"Enter the label text for the selector. The default value is \"@default\".\";b:1;s:10:\"-Any- text\";b:1;s:70:\"Enter the text for \"any term\" choice. The default value is \"!default\".\";b:1;s:21:\"Results page opens in\";b:1;s:15:\"the same window\";b:1;s:12:\"a new window\";b:1;s:20:\"Display basic search\";b:1;s:23:\"Display advanced search\";b:1;s:8:\"Criteria\";b:1;s:59:\"Select the criteria to display on the advanced search form.\";b:1;s:60:\"Select the languages to display on the advanced search form.\";b:1;s:41:\"Select data to display below each result.\";b:1;s:48:\"Add links to filter the results by content type.\";b:1;s:13:\"Above results\";b:1;s:13:\"Below results\";b:1;s:67:\"Enter the label text for the list. The default value is \"!default\".\";b:1;s:19:\"Search content from\";b:1;s:12:\"any language\";b:1;s:16:\"current language\";b:1;s:37:\"current language and language neutral\";b:1;s:53:\"Choose which language will be used to search content.\";b:1;s:66:\"Set the content types or categories you want to display links for.\";b:1;s:41:\"Show terms from the selected vocabularies\";b:1;s:67:\"Select for what view mode display the services in the link section.\";b:1;s:71:\"Select for what view modes display the services in the content section.\";b:1;s:28:\"How to display Service Links\";b:1;s:14:\"Choose a style\";b:1;s:9:\"Only Text\";b:1;s:61:\"Don\'t show links if the actual user is the author of the node\";b:1;s:22:\"Service Links in nodes\";b:1;s:15:\"Print the label\";b:1;s:15:\"Assign a weight\";b:1;s:19:\"Service Links icons\";b:1;s:15:\"Standard folder\";b:1;s:32:\"Use the default icons if missing\";b:1;s:25:\"How to fill the title tag\";b:1;s:27:\"Use the original node title\";b:1;s:27:\"Override the original title\";b:1;s:27:\"Parse the string with Token\";b:1;s:10:\"Token help\";b:1;s:11:\"Short Links\";b:1;s:15:\"Use short links\";b:1;s:19:\"Only when requested\";b:1;s:33:\"Bookmark this post on del.icio.us\";b:1;s:26:\"Digg this post on digg.com\";b:1;s:28:\"Thumb this up at StumbleUpon\";b:1;s:17:\"Submit to Ping.fm\";b:1;s:30:\"Submit this post on reddit.com\";b:1;s:32:\"Submit this post on newsvine.com\";b:1;s:28:\"Submit this post on furl.net\";b:1;s:17:\"Share on Facebook\";b:1;s:16:\"Share on MySpace\";b:1;s:28:\"Bookmark this post on Google\";b:1;s:21:\"Share this on Google+\";b:1;s:27:\"Bookmark this post on Yahoo\";b:1;s:40:\"Search Technorati for links to this post\";b:1;s:42:\"Add this post to your Technorati Favorites\";b:1;s:39:\"Search IceRocket for links to this post\";b:1;s:28:\"Submit this post on mixx.com\";b:1;s:7:\"Box it!\";b:1;s:16:\"Add to Blinklist\";b:1;s:22:\"Dent this on identi.ca\";b:1;s:28:\"Kicks this post on NewsKicks\";b:1;s:13:\"Post on Diigo\";b:1;s:20:\"Share this on Viadeo\";b:1;s:15:\"Show %name link\";b:1;s:37:\"There are @count items left to index.\";b:1;s:6:\"<none>\";b:1;s:13:\"service_links\";b:1;s:16:\"Node export link\";b:1;s:51:\"Provide a link to export the node with Node export.\";b:1;s:10:\"@type UUID\";b:1;s:39:\"The universally unique ID of the @type.\";b:1;s:7:\"Arquivo\";b:1;s:5:\"máis\";b:1;s:7:\"Aplicar\";b:1;s:9:\"Reiniciar\";b:1;s:11:\"Ordenar por\";b:1;s:9:\"Show More\";b:1;s:38:\"<div class=\"image\">[field_image]</div>\";b:1;s:36:\"<div class=\"date\">[field_date]</div>\";b:1;s:72:\"<div class=\"author\"><span class=\"label\">por:</span> [field_author]</div>\";b:1;s:3:\"Ler\";b:1;s:20:\"Relevantes - Arquivo\";b:1;s:30:\"Categorías (field_type:delta)\";b:1;s:11:\"Categorías\";b:1;s:7:\"Título\";b:1;s:7:\"Autor/a\";b:1;s:9:\"Etiquetas\";b:1;s:19:\"Texto personalizado\";b:1;s:10:\"Actividade\";b:1;s:6:\"Banner\";b:1;s:7:\"Páxina\";b:1;s:5:\"Lugar\";b:1;s:19:\"Paged, @count items\";b:1;s:24:\"Infinite Scroll: @parent\";b:1;s:11:\"Actividades\";b:1;s:4:\"Mapa\";b:1;s:3:\"[+]\";b:1;s:6:\"Bloque\";b:1;s:5:\"termo\";b:1;s:4:\"Todo\";b:1;s:4:\"Tipo\";b:1;s:4:\"Nome\";b:1;s:9:\"Lonxitude\";b:1;s:5:\"Corpo\";b:1;s:5:\"Valor\";b:1;s:20:\"Bootstrap Components\";b:1;s:18:\"Bootstrap Carousel\";b:1;s:24:\"Bootstrap Carousel Style\";b:1;s:20:\"Bootstrap Thumbnails\";b:1;s:26:\"Bootstrap Thumbnails Style\";b:1;s:14:\"Bootstrap Grid\";b:1;s:20:\"Bootstrap Grid Style\";b:1;s:19:\"Bootstrap Accordion\";b:1;s:25:\"Bootstrap Accordion Style\";b:1;s:13:\"Bootstrap Tab\";b:1;s:19:\"Bootstrap Tab Style\";b:1;s:22:\"Bootstrap Media Object\";b:1;s:28:\"Bootstrap Media Object Style\";b:1;s:15:\"Bootstrap Table\";b:1;s:38:\"Displays rows in Bootstrap Table Style\";b:1;s:57:\"Choose the fields to display in Bootstrap Carousel Style.\";b:1;s:19:\"Bootstrap Thumbnail\";b:1;s:58:\"Choose the fields to display in Bootstrap Thumbnail Style.\";b:1;s:21:\"Elementos por páxina\";b:1;s:8:\"- Todo -\";b:1;s:13:\"Desprazamento\";b:1;s:11:\"« primeira\";b:1;s:12:\"‹ anterior\";b:1;s:12:\"seguinte ›\";b:1;s:10:\"última »\";b:1;s:2:\"by\";s:3:\"por\";s:4:\"Play\";b:1;s:24:\"Image style: %imagestyle\";b:1;s:22:\"Option set: %optionset\";b:1;s:19:\"Show remaining days\";b:1;s:34:\"Image style: None (original image)\";b:1;i:1;b:1;i:2;b:1;i:3;b:1;i:4;b:1;i:5;b:1;s:19:\"Total votes: !count\";b:1;s:10:\"!name logo\";b:1;s:12:\"@count weeks\";b:1;s:33:\"<div class=\"summary\">[body]</div>\";b:1;s:10:\"View Title\";b:1;s:71:\"<p><strong>Últimos materiais <br> incorporados ao arquivo</strong></p>\";b:1;s:9:\"View Link\";b:1;s:63:\"<p><a href=\"/arquivo\"><strong>Arquivo completo</strong></a></p>\";b:1;s:51:\"This form will import bundle and field definitions.\";b:1;s:11:\"Import data\";b:1;s:58:\"Paste the text created by a bundle export into this field.\";b:1;s:32:\"%bundle bundle has been created.\";b:1;s:35:\"%field_name field has been created.\";b:1;s:66:\"%field_name instance has been created for @bundle in @entity_type.\";b:1;s:66:\"%fieldgroup fieldgroup has been saved for @bundle in @entity_type.\";b:1;s:43:\"Usa <em>home</ em> para a portada do sitio.\";b:1;s:10:\"Sección 1\";b:1;s:10:\"Sección 2\";b:1;s:10:\"Sección 3\";b:1;s:10:\"Sección 4\";b:1;s:10:\"Sección 5\";b:1;s:57:\"To clear this field, <a href=\"!reset\">reset the form</a>.\";b:1;s:37:\"Paste the code of a node export here.\";b:1;s:14:\"Reset the form\";b:1;s:25:\"Imported node !nid: !node\";b:1;s:61:\"Retain the theme until a new theme is set for anonymous users\";b:1;s:20:\"Delete ThemeKey Rule\";b:1;s:58:\"Are you sure you want to delete the ThemeKey rule, %title?\";b:1;s:13:\"Enabled theme\";b:1;s:20:\"Compartir en Twitter\";b:1;s:6:\"Enlace\";b:1;s:6:\"Nombre\";b:1;s:7:\"Latitud\";b:1;s:8:\"Longitud\";b:1;s:8:\"término\";b:1;s:66:\"Makes the \'jQuery Easing\' plugin available to Drupal as a library.\";b:1;s:32:\"Administer Isotope Configuration\";b:1;s:37:\"Set configuration options for Isotope\";b:1;s:6:\"config\";b:1;s:7:\"configs\";b:1;s:21:\"Isotope Configuration\";b:1;s:22:\"Isotope Configurations\";b:1;s:12:\"Isotope Grid\";b:1;s:51:\"Display the results using the jQuery Isotope plugin\";b:1;s:14:\"Isotope Filter\";b:1;s:55:\"Display the results formatted to filter an Isotope View\";b:1;s:18:\"Isotope Sort Block\";b:1;s:53:\"Display the results formatted to sort an Isotope View\";b:1;s:34:\"Administer Isotope configurations.\";b:1;s:56:\"A grid layout where items are centered inside each cell.\";b:1;s:67:\"A horizontal grid layout where items are centered inside each cell.\";b:1;s:32:\"Items are arranged horizontally.\";b:1;s:7:\"masonry\";b:1;s:7:\"fitRows\";b:1;s:8:\"vertical\";b:1;s:19:\"Isotope Layout Mode\";b:1;s:18:\"Additional Plugins\";b:1;s:19:\"Transition Duration\";b:1;s:20:\"Use URL for Filters.\";b:1;s:10:\"isFitWidth\";b:1;s:12:\"isHorizontal\";b:1;s:50:\"Arranges items horizontally instead of vertically.\";b:1;s:14:\"Stamp Selector\";b:1;s:44:\"Horizontal Alignment (decimal number 0 to 1)\";b:1;s:42:\"Vertical Alignment (decimal number 0 to 1)\";b:1;s:45:\"Layout direction (implements \"isOriginLeft\").\";b:1;s:15:\"Isotope library\";b:1;s:13:\"jQuery Easing\";b:1;s:21:\"Administer respond.js\";b:1;s:10:\"Respond.js\";b:1;s:29:\"Configure respond.js settings\";b:1;s:17:\"Respond.js script\";b:1;s:55:\"Respond.js will not work with CSS aggregation disabled.\";b:1;s:47:\"Respond.js is not correctly using Libraries API\";b:1;s:71:\"Include Rel attribute for use in lightbox2 or other javascript utility.\";b:1;s:7:\"1 month\";b:1;s:13:\"Download File\";b:1;s:22:\"Download a backup file\";b:1;s:58:\"Aggregates RSS/Atom/RDF feeds, imports CSV files and more.\";b:1;s:35:\"Administrative UI for Feeds module.\";b:1;s:50:\"An example of a node importer and a user importer.\";b:1;s:5:\"Feeds\";b:1;s:13:\"Scheduler API\";b:1;s:62:\"Creates scheduler triggers that fire up at certain days, times\";b:1;s:16:\"Administer Feeds\";b:1;s:12:\"Feed node id\";b:1;s:8:\"Feed URL\";b:1;s:29:\"Your changes have been saved.\";b:1;s:10:\"Feed title\";b:1;s:9:\"Processor\";b:1;s:15:\"Getting started\";b:1;s:7:\"Targets\";b:1;s:8:\"Override\";s:13:\"Sobreescribir\";s:14:\"Basic settings\";s:16:\"Axustes básicos\";s:8:\"Deleting\";b:1;s:7:\"Mapping\";b:1;s:23:\"Title of the feed item.\";b:1;s:9:\"Importing\";b:1;s:8:\"Importer\";b:1;s:10:\"User email\";s:19:\"Correo-e do usuario\";s:11:\"Attached to\";b:1;s:6:\"Legend\";b:1;s:20:\"As often as possible\";b:1;s:11:\"Author name\";s:13:\"Nome do autor\";s:14:\"Published date\";b:1;s:6:\"Unique\";b:1;s:12:\"Delete items\";b:1;s:36:\"A description of this configuration.\";b:1;s:21:\"Select a !plugin_type\";b:1;s:20:\"Settings for !plugin\";b:1;s:6:\"[none]\";b:1;s:15:\"every !interval\";b:1;s:23:\"Mapping has been added.\";b:1;s:20:\"No mappings defined.\";b:1;s:22:\"Attach to content type\";b:1;s:11:\"after !time\";b:1;s:16:\"Published status\";b:1;s:11:\"Feed source\";b:1;s:17:\"Enter a feed URL.\";b:1;s:12:\"Expire nodes\";b:1;s:15:\"Item URL (link)\";b:1;s:9:\"Item GUID\";b:1;s:19:\"Use standalone form\";b:1;s:45:\"The UNIX time when a node has been published.\";b:1;s:18:\"Title of the feed.\";b:1;s:16:\"URL of the feed.\";b:1;s:29:\"Description of the feed item.\";b:1;s:31:\"Name of the feed item\'s author.\";b:1;s:49:\"Published date as UNIX time GMT of the feed item.\";b:1;s:21:\"URL of the feed item.\";b:1;s:42:\"Global Unique Identifier of the feed item.\";b:1;s:64:\"An array of categories that have been assigned to the feed item.\";b:1;s:11:\"Import date\";b:1;s:33:\"The end date for the @name field.\";b:1;s:14:\"Owner feed nid\";b:1;s:10:\"Owner feed\";b:1;s:35:\"Contains the GUID of the feed item.\";b:1;s:36:\"Filter on a Feeds Item\'s GUID field.\";b:1;s:38:\"Argument on a Feeds Item\'s GUID field.\";b:1;s:34:\"Sort on a Feeds Item\'s GUID field.\";b:1;s:42:\"Contains the import date of the feed item.\";b:1;s:41:\"Sort on a Feeds Item\'s import date field.\";b:1;s:43:\"Filter on a Feeds Item\'s import date field.\";b:1;s:45:\"Argument on a Feeds Item\'s import date field.\";b:1;s:6:\"Unlock\";b:1;s:16:\"Use PubSubHubbub\";b:1;s:14:\"Designated hub\";b:1;s:17:\"Auto detect feeds\";b:1;s:38:\"The Drupal user ID of the node author.\";b:1;s:8:\"Item URL\";b:1;s:34:\"Contains the URL of the feed item.\";b:1;s:35:\"Filter on a Feeds Item\'s URL field.\";b:1;s:37:\"Argument on a Feeds Item\'s URL field.\";b:1;s:33:\"Sort on a Feeds Item\'s URL field.\";b:1;s:32:\"Feed node: Taxonomy: @vocabulary\";b:1;s:50:\"Taxonomy terms from feed node in given vocabulary.\";b:1;s:18:\"Feed node: User ID\";b:1;s:25:\"The feed node author uid.\";b:1;s:13:\"Geo Locations\";b:1;s:60:\"An array of geographic locations with a name and a position.\";b:1;s:20:\"Import on submission\";b:1;s:18:\"Import @name feeds\";b:1;s:29:\"Delete items from @name feeds\";b:1;s:18:\"Attached to: @type\";b:1;s:15:\"Feeds importers\";b:1;s:29:\"Delete all items from source?\";b:1;s:22:\"Last import: @ago ago.\";b:1;s:28:\"@count imported items total.\";b:1;s:18:\"No imported items.\";b:1;s:31:\"Periodic import: !import_period\";b:1;s:27:\"Do not import on submission\";b:1;s:39:\"A human readable name of this importer.\";b:1;s:31:\"A description of this importer.\";b:1;s:31:\"Requires cron to be configured.\";b:1;s:8:\"Every !p\";b:1;s:15:\"Periodic import\";b:1;s:58:\"Choose how often a source should be imported periodically.\";b:1;s:21:\"Process in background\";b:1;s:27:\"There are no new @entities.\";b:1;s:25:\"Update existing @entities\";b:1;s:32:\"Do not update existing @entities\";b:1;s:48:\"The node id of the owner feed node if available.\";b:1;s:55:\"Relate a feed item to its owner feed node if available.\";b:1;s:48:\"Relate a log entry to its importer if available.\";b:1;s:9:\"Feed node\";b:1;s:49:\"Relate a log entry to its feed node if available.\";b:1;s:8:\"Log time\";b:1;s:22:\"The time of the event.\";b:1;s:12:\"Request time\";b:1;s:41:\"The time of the page request of an event.\";b:1;s:26:\"Feeds module form elements\";b:1;s:12:\"@name: Start\";b:1;s:12:\"Add importer\";b:1;s:15:\"Import importer\";b:1;s:23:\"No importers available.\";b:1;s:26:\"There are no log messages.\";b:1;s:24:\"Standalone importer page\";b:1;s:14:\"Feed node page\";b:1;s:11:\"All entries\";b:1;s:9:\"Feeds log\";b:1;s:13:\"Imported date\";b:1;s:38:\"The date the source was imported last.\";b:1;s:47:\"Logs events during importing, clearing, expiry.\";b:1;s:6:\"Log id\";b:1;s:26:\"The id of the log message.\";b:1;s:11:\"Importer id\";b:1;s:22:\"The id of an importer.\";b:1;s:25:\"Filter on an importer id.\";b:1;s:20:\"Sort by importer id.\";b:1;s:13:\"Importer name\";b:1;s:39:\"The human readable name of an importer.\";b:1;s:42:\"Filter on a Feeds Source\'s feed_nid field.\";b:1;s:44:\"Argument on a Feeds Source\'s feed_nid field.\";b:1;s:35:\"Sort Feeds Source\'s feed_nid field.\";b:1;s:20:\"Type of log message.\";b:1;s:32:\"The message logged by the event.\";b:1;s:33:\"The severity of the event logged.\";b:1;s:40:\"Filter on the severity of a log message.\";b:1;s:19:\"Mensaxe de rexistro\";b:1;s:10:\"Severidade\";b:1;s:9:\"@importer\";b:1;s:24:\"Automatically add scheme\";b:1;s:15:\"Request timeout\";b:1;s:31:\"Accept invalid SSL certificates\";b:1;s:20:\"Insert new @entities\";b:1;s:27:\"Do not insert new @entities\";b:1;s:26:\"Replace existing @entities\";b:1;s:15:\"Skip hash check\";b:1;s:62:\"Force update of items even if item source data did not change.\";b:1;s:73:\"Action to take when previously imported @entities are missing in the feed\";b:1;s:27:\"Skip non-existent @entities\";b:1;s:29:\"Delete non-existent @entities\";b:1;s:9:\"Authorize\";b:1;s:56:\"Check that the author has permission to create the node.\";b:1;s:6:\"1 year\";b:1;s:28:\"Unpublish non-existent nodes\";b:1;s:8:\"feeds_ui\";b:1;s:58:\"Review log messages of imports and subscriptions to feeds.\";b:1;s:74:\"Tipo de contido empregado polo importador RSS \"Territorio de las mujeres\".\";b:1;s:40:\"The node the feed item was sourced from.\";b:1;s:21:\"Changed @type plugin.\";b:1;s:22:\"Mapping for @processor\";b:1;s:39:\"The Drupal username of the node author.\";b:1;s:37:\"The email address of the node author.\";b:1;s:53:\"The Unix timestamp when a node has been last updated.\";b:1;s:44:\"The two-character language code of the node.\";b:1;s:10:\"@name: End\";b:1;s:11:\"@label: URI\";b:1;s:28:\"The URI of the @label field.\";b:1;s:11:\"@label: Alt\";b:1;s:32:\"The alt tag of the @label field.\";b:1;s:13:\"@label: Title\";b:1;s:30:\"The title of the @label field.\";b:1;s:27:\"URL path alias of the node.\";b:1;s:31:\"The @label field of the entity.\";b:1;s:14:\"@name: Summary\";b:1;s:18:\"Feed node: Node ID\";b:1;s:18:\"The feed node nid.\";b:1;s:19:\"- Select a source -\";b:1;s:25:\"An element from the feed.\";b:1;s:19:\"- Select a target -\";b:1;s:31:\"The field that stores the data.\";b:1;s:10:\"DEPRECATED\";b:1;s:20:\"Target configuration\";b:1;s:19:\"Not used as unique.\";b:1;s:20:\"Text format: %format\";b:1;s:32:\"Used as <strong>unique</strong>.\";b:1;s:25:\"Mapping has been removed.\";b:1;s:3:\"Log\";b:1;s:16:\"Hora de registro\";b:1;s:20:\"Hora de la solicitud\";b:1;s:19:\"Mensaje de registro\";b:1;s:8:\"Gravedad\";b:1;s:11:\"Videofilter\";b:1;s:4:\"e.g.\";b:1;s:17:\"Entrada da Axenda\";b:1;s:31:\"Unlock imports from @name feeds\";b:1;s:12:\"@count items\";b:1;s:9:\"i18n_menu\";b:1;s:25:\"Nodo de canal de noticias\";b:1;s:4:\"más\";b:1;s:23:\"Nombre de la ubicación\";b:1;s:22:\"Ubicación de la calle\";b:1;s:9:\"Adicional\";b:1;s:6:\"Ciudad\";b:1;s:16:\"Estado/Provincia\";b:1;s:33:\"Dirección de correo electrónico\";b:1;s:22:\"Nombre de la provincia\";b:1;s:16:\"Nombre del país\";b:1;s:13:\"Enlace a mapa\";b:1;s:11:\"Coordenadas\";b:1;s:7:\"Resumen\";b:1;s:72:\"A field formatter for rendering values as HTML or comma-separated lists.\";b:1;s:46:\"Textformatter support for contributed modules.\";b:1;s:9:\"Paragraph\";b:1;s:9:\"CSS Class\";b:1;s:8:\"Header 1\";b:1;s:19:\"Unordered HTML list\";b:1;s:24:\"Unordered HTML list (ul)\";b:1;s:22:\"Ordered HTML list (ol)\";b:1;s:20:\"Comma separated list\";b:1;s:34:\"Include \'and\' before the last item\";b:1;s:36:\"Append comma separated list with \'.\'\";b:1;s:24:\"Override comma separator\";b:1;s:68:\"Override the default comma separator with a custom separator string.\";b:1;s:16:\"Custom separator\";b:1;s:22:\"separator HTML wrapper\";b:1;s:37:\"An HTML tag to wrap the separator in.\";b:1;s:11:\"No HTML tag\";b:1;s:4:\"Span\";b:1;s:8:\"Header 4\";b:1;s:8:\"Header 5\";b:1;s:8:\"Header 6\";b:1;s:17:\"Separator classes\";b:1;s:56:\"A CSS class to use in the wrapper tag for the separator.\";b:1;s:12:\"HTML wrapper\";b:1;s:12:\"List classes\";b:1;s:52:\"A CSS class to use in the markup for the field list.\";b:1;s:54:\"Display taxonomy terms as plain text (Not term links).\";b:1;s:66:\"<p><a href=\"/gl/arquivo\"><strong>Arquivo completo</strong></a></p>\";b:1;s:25:\"This is a @name variable.\";b:1;s:46:\"List of variables that can be set for a realm.\";b:1;s:44:\"Override default weight for realm variables.\";b:1;s:42:\"Select variables to be set for this realm.\";b:1;s:53:\"Currently selected variables are: <em>!variables</em>\";b:1;s:18:\"System performance\";b:1;s:72:\"Options related with cache, file compression and bandwidth optimization.\";b:1;s:11:\"User emails\";b:1;s:58:\"Variables that contain metadata about the variable system.\";b:1;s:10:\"Option set\";b:1;s:30:\"Use image title as the caption\";b:1;s:43:\"A human-readable title for this option set.\";b:1;s:15:\"Slide Direction\";b:1;s:5:\"Swing\";b:1;s:6:\"Easing\";b:1;s:47:\"The description appears usually below the item.\";b:1;s:13:\"Smooth Height\";b:1;s:71:\"Animate the height of the slider smoothly for slides of varying height.\";b:1;s:29:\"Animate the slides in reverse\";b:1;s:55:\"Set the speed of the slideshow cycling, in milliseconds\";b:1;s:14:\"Loop Slideshow\";b:1;s:50:\"Loop the slideshow once it reaches the last slide.\";b:1;s:21:\"Randomize Slide Order\";b:1;s:41:\"Randomize the order the slides play back.\";b:1;s:14:\"Starting Slide\";b:1;s:10:\"Item Width\";b:1;s:11:\"Item Margin\";b:1;s:13:\"Minimum Items\";b:1;s:56:\"Minimum number of carousel items that should be visible.\";b:1;s:9:\"Max Items\";b:1;s:56:\"Maximum number of carousel items that should be visible.\";b:1;s:31:\"Navigation and Control Settings\";b:1;s:22:\"Next/Previous Controls\";b:1;s:15:\"Paging Controls\";b:1;s:18:\"Thumbnail Captions\";b:1;s:51:\"Display both thumbnail captions and normal captions\";b:1;s:52:\"Allow slider navigating via keyboard left/right keys\";b:1;s:17:\"Multiple Keyboard\";b:1;s:53:\"Allow keyboard navigation to affect multiple sliders.\";b:1;s:38:\"Allow slider navigating via mousewheel\";b:1;s:5:\"Touch\";b:1;s:29:\"Allow touch swipe navigation.\";b:1;s:18:\"Previous Link Text\";b:1;s:14:\"Next Link Text\";b:1;s:53:\"Must match a simple pattern. \"{container} > {slide}\".\";b:1;s:64:\"Mirror the actions performed on this slider with another slider.\";b:1;s:17:\"Use as navigation\";b:1;s:63:\"Turn the slider into a thumbnail navigation for another slider.\";b:1;s:16:\"Initialize Delay\";b:1;s:45:\"Set an initialization delay, in milliseconds.\";b:1;s:7:\"Use CSS\";b:1;s:47:\"Slider will use CSS3 transitions, if available.\";b:1;s:68:\"Will prevent use of CSS3 3D Transforms, avoiding graphical glitches.\";b:1;s:16:\"Pause State Text\";b:1;s:15:\"Play State Text\";b:1;s:59:\"Pause the slideshow when interacting with control elements.\";b:1;s:14:\"Pause On Hover\";b:1;s:29:\"Controls container (Advanced)\";b:1;s:6:\"Vídeo\";b:1;s:11:\"Video style\";b:1;s:12:\"Video Source\";b:1;s:17:\"Link thumbnail to\";b:1;s:38:\"<div class=\"video\">[field_video]</div>\";b:1;s:13:\"[field_image]\";b:1;s:23:\"Vídeo - Thumbnail path\";b:1;s:38:\"<div class=\"image\">[field_video]</div>\";b:1;s:37:\"A translation was saved successfully.\";b:1;s:2:\"Go\";b:1;s:10:\"- Choose -\";b:1;s:18:\"Views translation.\";b:1;s:7:\"Contido\";b:1;s:22:\"Data de actualización\";b:1;s:4:\"Rúa\";b:1;s:2:\"%2\";b:1;s:2:\"%3\";b:1;s:13:\"Data de envio\";b:1;s:6:\"Posted\";b:1;s:6:\"Rating\";b:1;s:7:\" points\";b:1;s:16:\"Individual votes\";b:1;s:13:\"Tipo de valor\";b:1;s:9:\"Vote type\";b:1;s:14:\"Marca de tempo\";b:1;s:10:\"%1\'s votes\";b:1;s:5:\"autor\";b:1;s:21:\"Conta dos comentarios\";b:1;s:26:\"Data do último comentario\";b:1;s:16:\"Ten novo contido\";b:1;s:17:\"Novos comentarios\";b:1;s:14:\"translate view\";b:1;s:26:\"Internationalization Views\";b:1;s:69:\"Use the locale system as implemented by the Views translation module.\";b:1;s:20:\"Taxonomy term (i18n)\";b:1;s:38:\"Use the locale to interpret arguments.\";b:1;s:20:\"Term ID (translated)\";b:1;s:32:\"The translated taxonomy term ID.\";b:1;s:17:\"Term (translated)\";b:1;s:17:\"Name (translated)\";b:1;s:34:\"The translated taxonomy term name.\";b:1;s:30:\"Translated taxonomy term name.\";b:1;s:29:\"Term description (translated)\";b:1;s:59:\"The translated description associated with a taxonomy term.\";b:1;s:28:\"The language the term is in.\";b:1;s:35:\"Taxonomy terms on node (translated)\";b:1;s:31:\"All taxonomy terms (translated)\";b:1;s:45:\"Has taxonomy term ID (with depth, translated)\";b:1;s:43:\"Has taxonomy terms (with depth, translated)\";b:1;s:33:\"Has taxonomy term ID (translated)\";b:1;s:30:\"Has taxonomy term (translated)\";b:1;s:17:\"Type (translated)\";b:1;s:61:\"Limit this validator to vocabularies that have been localized\";b:1;s:30:\"Localised Term name or synonym\";b:1;s:48:\"Localised Term name/synonym converted to Term ID\";b:1;s:26:\"Created @number @entities.\";b:1;s:23:\";-) Total votes: !count\";b:1;s:51:\"Adds a MediaRSS feed processor to the Feeds module.\";b:1;s:6:\"Title.\";b:1;s:32:\"Author or uploader of the video.\";b:1;s:64:\"This can be imported directly with Taxonomy \"tags\" vocabularies.\";b:1;s:13:\"Media Content\";b:1;s:11:\"Media Adult\";b:1;s:12:\"Media Rating\";b:1;s:11:\"Media Title\";b:1;s:17:\"Media Description\";b:1;s:32:\"Media Keywords (comma separated)\";b:1;s:21:\"Media Thumbnail (URL)\";b:1;s:34:\"Media Categories (comma separated)\";b:1;s:10:\"Media Hash\";b:1;s:18:\"Media Player (URL)\";b:1;s:12:\"Media Credit\";b:1;s:15:\"Media Copyright\";b:1;s:10:\"Media Text\";b:1;s:17:\"Media Restriction\";b:1;s:15:\"Media Community\";b:1;s:32:\"Media Comments (comma separated)\";b:1;s:18:\"Media Embed (HTML)\";b:1;s:33:\"Media Responses (comma separated)\";b:1;s:33:\"Media BackLinks (comma separated)\";b:1;s:12:\"Media Status\";b:1;s:11:\"Media Price\";b:1;s:13:\"Media License\";b:1;s:20:\"Media subTitle (URL)\";b:1;s:20:\"Media peerLink (URL)\";b:1;s:30:\"Media Rights (comma separated)\";b:1;s:30:\"Media Scenes (comma separated)\";b:1;s:44:\"Provides location mappers for feed importers\";b:1;s:40:\"The @label for the location of the node.\";b:1;s:37:\"Map a georss point to location points\";b:1;s:57:\"A generic Feeds parser used to create extensible parsers.\";b:1;s:9:\"Raw value\";b:1;s:3:\"Raw\";b:1;s:13:\"Context value\";b:1;s:14:\"Add new source\";b:1;s:9:\"Inner XML\";b:1;s:14:\"Display errors\";b:1;s:15:\"Source encoding\";b:1;s:60:\"The possible encodings of the source files. auto: %encodings\";b:1;s:21:\"Encoding autocomplete\";b:1;s:25:\"The name of source field.\";b:1;s:50:\"Search taxonomy terms by: <strong>@search</strong>\";b:1;s:24:\"Search taxonomy terms by\";b:1;s:11:\"Auto create\";b:1;s:36:\"Create the term if it doesn\'t exist.\";b:1;s:25:\"Deleted @number @entities\";b:1;s:18:\"Africa/Addis_Ababa\";b:1;s:20:\"Africa/Dar_es_Salaam\";b:1;s:15:\"Africa/El_Aaiun\";b:1;s:15:\"Africa/Sao_Tome\";b:1;s:30:\"America/Argentina/Buenos_Aires\";b:1;s:26:\"America/Argentina/La_Rioja\";b:1;s:30:\"America/Argentina/Rio_Gallegos\";b:1;s:26:\"America/Argentina/San_Juan\";b:1;s:26:\"America/Argentina/San_Luis\";b:1;s:22:\"America/Bahia_Banderas\";b:1;s:17:\"America/Boa_Vista\";b:1;s:21:\"America/Cambridge_Bay\";b:1;s:20:\"America/Campo_Grande\";b:1;s:18:\"America/Costa_Rica\";b:1;s:20:\"America/Dawson_Creek\";b:1;s:19:\"America/El_Salvador\";b:1;s:17:\"America/Glace_Bay\";b:1;s:17:\"America/Goose_Bay\";b:1;s:18:\"America/Grand_Turk\";b:1;s:25:\"America/Indiana/Tell_City\";b:1;s:14:\"America/La_Paz\";b:1;s:19:\"America/Los_Angeles\";b:1;s:21:\"America/Lower_Princes\";b:1;s:19:\"America/Mexico_City\";b:1;s:16:\"America/New_York\";b:1;s:27:\"America/North_Dakota/Beulah\";b:1;s:27:\"America/North_Dakota/Center\";b:1;s:30:\"America/North_Dakota/New_Salem\";b:1;s:21:\"America/Port_of_Spain\";b:1;s:19:\"America/Porto_Velho\";b:1;s:19:\"America/Puerto_Rico\";b:1;s:19:\"America/Rainy_River\";b:1;s:20:\"America/Rankin_Inlet\";b:1;s:18:\"America/Rio_Branco\";b:1;s:20:\"America/Santa_Isabel\";b:1;s:21:\"America/Santo_Domingo\";b:1;s:17:\"America/Sao_Paulo\";b:1;s:21:\"America/St_Barthelemy\";b:1;s:16:\"America/St_Johns\";b:1;s:16:\"America/St_Kitts\";b:1;s:16:\"America/St_Lucia\";b:1;s:17:\"America/St_Thomas\";b:1;s:18:\"America/St_Vincent\";b:1;s:21:\"America/Swift_Current\";b:1;s:19:\"America/Thunder_Bay\";b:1;s:16:\"Asia/Ho_Chi_Minh\";b:1;s:14:\"Asia/Hong_Kong\";b:1;s:17:\"Asia/Kuala_Lumpur\";b:1;s:15:\"Asia/Phnom_Penh\";b:1;s:19:\"Atlantic/Cape_Verde\";b:1;s:22:\"Atlantic/South_Georgia\";b:1;s:18:\"Atlantic/St_Helena\";b:1;s:21:\"Australia/Broken_Hill\";b:1;s:19:\"Australia/Lord_Howe\";b:1;s:18:\"Europe/Isle_of_Man\";b:1;s:17:\"Europe/San_Marino\";b:1;s:17:\"Pacific/Pago_Pago\";b:1;s:20:\"Pacific/Port_Moresby\";b:1;s:17:\"@count file names\";b:1;s:11:\"1 file name\";b:1;s:37:\"Updated URL aliases for @count nodes.\";b:1;s:10:\"Categoría\";b:1;s:11:\"Organizador\";b:1;s:8:\"Clone of\";b:1;s:8:\"Frontend\";b:1;s:20:\"Administer Modernizr\";b:1;s:43:\"Perform administration tasks for Modernizr.\";b:1;s:9:\"Modernizr\";b:1;s:13:\"modernizr.com\";b:1;s:58:\"All required tests are present in current Modernizr build.\";b:1;s:15:\"Modernizr Tests\";b:1;s:16:\"1 pending update\";b:1;s:48:\"An overview of libraries installed on this site.\";b:1;s:47:\"Adds support and an API to implement meta tags.\";b:1;s:44:\"Import data from other modules into Metatag.\";b:1;s:44:\"Provides support for applinks.org meta tags.\";b:1;s:49:\"Provides support for Facebook\'s custom meta tags.\";b:1;s:37:\"Provides support for custom favicons.\";b:1;s:51:\"Provides support for Google+ \'itemscope\' meta tags.\";b:1;s:51:\"Provides support for Open Graph Protocol meta tags.\";b:1;s:57:\"Provides Metatag integration within the Panels interface.\";b:1;s:46:\"Provides support for Twitter\'s Card meta tags.\";b:1;s:52:\"Various meta tags for verifying ownership of a site.\";b:1;s:56:\"Provides Metatag integration within the Views interface.\";b:1;s:74:\"Provides additional Open Graph Protocol meta tags for describing products.\";b:1;s:3:\"SEO\";b:1;s:20:\"Administer meta tags\";b:1;s:64:\"Control the main settings pages and modify per-object meta tags.\";b:1;s:14:\"Edit meta tags\";b:1;s:73:\"Modify meta tags on individual entity records (nodes, terms, users, etc).\";b:1;s:7:\"Metatag\";b:1;s:23:\"Configurable meta tags.\";b:1;s:10:\"Basic tags\";b:1;s:13:\"Advanced tags\";b:1;s:8:\"Abstract\";b:1;s:6:\"Robots\";b:1;s:50:\"Allow search engines to index this page (assumed).\";b:1;s:60:\"Allow search engines to follow links on this page (assumed).\";b:1;s:48:\"Prevents search engines from indexing this page.\";b:1;s:58:\"Prevents search engines from following links on this page.\";b:1;s:69:\"Prevents cached copies of this page from appearing in search results.\";b:1;s:57:\"Prevent search engines from indexing images on this page.\";b:1;s:20:\"Google News Keywords\";b:1;s:15:\"Google Standout\";b:1;s:14:\"Content rating\";b:1;s:55:\"Used to indicate the intended audience for the content.\";b:1;s:6:\"Mature\";b:1;s:10:\"Restricted\";b:1;s:17:\"14 years or Older\";b:1;s:13:\"Safe for kids\";b:1;s:15:\"Referrer policy\";b:1;s:11:\"No Referrer\";b:1;s:26:\"No Referrer When Downgrade\";b:1;s:24:\"Origin When Cross-Origin\";b:1;s:10:\"Unsafe URL\";b:1;s:9:\"Generator\";b:1;s:6:\"Rights\";b:1;s:13:\"Canonical URL\";b:1;s:13:\"Shortlink URL\";b:1;s:55:\"A brief URL, often created by a URL shortening service.\";b:1;s:13:\"Publisher URL\";b:1;s:10:\"Author URL\";b:1;s:15:\"Original Source\";b:1;s:17:\"Previous page URL\";b:1;s:13:\"Next page URL\";b:1;s:12:\"Geo position\";b:1;s:14:\"Geo place name\";b:1;s:25:\"A location\'s formal name.\";b:1;s:10:\"Geo region\";b:1;s:4:\"ICBM\";b:1;s:13:\"Revisit After\";b:1;s:6:\"Pragma\";b:1;s:13:\"Cache-Control\";b:1;s:7:\"Expires\";b:1;s:21:\"Metatag configuration\";b:1;s:19:\"Node form meta tags\";b:1;s:27:\"Meta tags on the node form.\";b:1;s:27:\"Configure Metatag defaults.\";b:1;s:17:\"403 access denied\";b:1;s:18:\"404 page not found\";b:1;s:33:\"Inherits meta tags from: @parents\";b:1;s:35:\"No meta tag defaults available yet.\";b:1;s:21:\"Add default meta tags\";b:1;s:11:\"Bulk revert\";b:1;s:32:\"Master controls for all entities\";b:1;s:4:\"Nodo\";b:1;s:19:\"Termo de taxonomía\";b:1;s:15:\"RSS Categorías\";b:1;s:9:\"Usuario/a\";b:1;s:19:\"Additional settings\";b:1;s:19:\"Custom pager string\";b:1;s:28:\"Internationalization options\";b:1;s:24:\"Disable i18n integration\";b:1;s:16:\"Translate output\";b:1;s:43:\"Optionally translate the final page output.\";b:1;s:42:\"Enable logging of translations to Watchdog\";b:1;s:51:\"Optionally log to Watchdog any changes that happen.\";b:1;s:51:\"Output meta tags even if only global settings apply\";b:1;s:31:\"Output meta tags on admin pages\";b:1;s:20:\"Advanced permissions\";b:1;s:65:\"Don\'t load entity\'s default language values if no languages match\";b:1;s:40:\"Load the module\'s default configurations\";b:1;s:21:\"Cache meta tag output\";b:1;s:28:\"Leave core\'s meta tags as-is\";b:1;s:18:\"Page region to use\";b:1;s:9:\"Meta tags\";b:1;s:57:\"This will be able to extract the URL from an image field.\";b:1;s:15:\"!title interval\";b:1;s:20:\"!title interval type\";b:1;s:8:\"- none -\";b:1;s:6:\"Day(s)\";b:1;s:7:\"Week(s)\";b:1;s:8:\"Month(s)\";b:1;s:7:\"Year(s)\";b:1;s:18:\"Título da páxina\";b:1;s:11:\"Descrición\";b:1;s:14:\"Palabras chave\";b:1;s:10:\"Actualizar\";b:1;s:33:\"Meta tags for this taxonomy term.\";b:1;s:24:\"Meta tags for this node.\";b:1;s:24:\"Meta tags for this user.\";b:1;s:12:\"Custom pager\";b:1;s:49:\"The meta tag defaults for @label have been saved.\";b:1;s:30:\"Meta tag module form elements.\";b:1;s:21:\"Título de la página\";b:1;s:12:\"Descripción\";b:1;s:14:\"Palabras clave\";b:1;s:6:\"Imagen\";b:1;s:20:\"Idioma del contenido\";b:1;s:43:\"The Imagecache Token module is recommended.\";b:1;s:62:\"Feeds is currently using this module for one or more importers\";b:1;s:18:\"Modernizr settings\";b:1;s:45:\"Administrative settings for Modernizr module.\";b:1;s:17:\"Rebuild Modernizr\";b:1;s:13:\"textformatter\";b:1;s:13:\"i18n_taxonomy\";b:1;s:9:\"i18nviews\";b:1;s:9:\"libraries\";b:1;s:7:\"metatag\";b:1;s:16:\"Meta tag: !label\";b:1;s:29:\"Add multiple value identifier\";b:1;s:26:\"Ver contador de resultados\";b:1;s:55:\"Load subsequent pages manually instead of automatically\";b:1;s:17:\"Manual load label\";b:1;s:32:\"Label to use on the manual link.\";b:1;s:59:\"Metatag support has been enabled for the @label vocabulary.\";b:1;s:56:\"Makes the jquery touch swipe library available to drupal\";b:1;s:59:\"Administrate the configuration of jquery touch swipe module\";b:1;s:41:\"Permissions for jQuery touch swipe module\";b:1;s:27:\"JQuery touch swipe settings\";b:1;s:29:\"JQuery touch swipe admin form\";b:1;s:51:\"Enable jQuery touch swipe library on specific pages\";b:1;s:60:\"The configuration of jQuery touch swipe is correctly updated\";b:1;s:27:\"Administer Google Analytics\";b:1;s:47:\"Perform maintenance tasks for Google Analytics.\";b:1;s:25:\"Opt-in or out of tracking\";b:1;s:69:\"Allow users to decide if tracking code will be added to pages or not.\";b:1;s:31:\"Use PHP for tracking visibility\";b:1;s:61:\"Enter PHP code in the field for tracking visibility settings.\";b:1;s:16:\"Google Analytics\";b:1;s:15:\"Web Property ID\";b:1;s:14:\"Tracking scope\";b:1;s:7:\"Domains\";b:1;s:22:\"What are you tracking?\";b:1;s:25:\"A single domain (default)\";b:1;s:15:\"Domain: @domain\";b:1;s:35:\"One domain with multiple subdomains\";b:1;s:18:\"Examples: @domains\";b:1;s:26:\"Multiple top-level domains\";b:1;s:25:\"List of top-level domains\";b:1;s:34:\"Every page except the listed pages\";b:1;s:21:\"The listed pages only\";b:1;s:30:\"Add tracking to specific pages\";b:1;s:31:\"Add tracking for specific roles\";b:1;s:30:\"Add to the selected roles only\";b:1;s:42:\"Add to every role except the selected ones\";b:1;s:25:\"opt-in or out of tracking\";b:1;s:55:\"Allow users to customize tracking on their account page\";b:1;s:24:\"No customization allowed\";b:1;s:69:\"Tracking on by default, users with %permission permission can opt out\";b:1;s:69:\"Tracking off by default, users with %permission permission can opt in\";b:1;s:13:\"Track User ID\";b:1;s:19:\"Links and downloads\";b:1;s:30:\"Track clicks on outbound links\";b:1;s:28:\"Track clicks on mailto links\";b:1;s:67:\"Track downloads (clicks on file links) for the following extensions\";b:1;s:32:\"List of download file extensions\";b:1;s:39:\"Track content in colorbox modal dialogs\";b:1;s:60:\"Enable to track the content shown in colorbox modal windows.\";b:1;s:31:\"Track enhanced link attribution\";b:1;s:41:\"Track changing URL fragments as pageviews\";b:1;s:22:\"Track messages of type\";b:1;s:22:\"Search and Advertising\";b:1;s:21:\"Track internal search\";b:1;s:17:\"Track AdSense ads\";b:1;s:22:\"Track display features\";b:1;s:7:\"Privacy\";b:1;s:29:\"Anonymize visitors IP address\";b:1;s:30:\"Universal web tracking opt-out\";b:1;s:17:\"Custom dimensions\";b:1;s:12:\"Index number\";b:1;s:30:\"Custom dimension index #@index\";b:1;s:27:\"The custom dimension value.\";b:1;s:30:\"Custom dimension value #@index\";b:1;s:14:\"Custom metrics\";b:1;s:27:\"Custom metric index #@index\";b:1;s:24:\"The custom metric value.\";b:1;s:27:\"Custom metric value #@index\";b:1;s:32:\"Locally cache tracking code file\";b:1;s:34:\"Track translation sets as one unit\";b:1;s:22:\"Custom JavaScript code\";b:1;s:18:\"Create only fields\";b:1;s:21:\"Code snippet (before)\";b:1;s:20:\"Code snippet (after)\";b:1;s:16:\"Enable debugging\";b:1;s:30:\"Google Analytics configuration\";b:1;s:37:\"Google Analytics module form element.\";b:1;s:23:\"Google Analytics module\";b:1;s:14:\"Not configured\";b:1;s:15:\"User role names\";b:1;s:71:\"The role names the user account is a member of as comma separated list.\";b:1;s:13:\"User role ids\";b:1;s:69:\"The role ids the user account is a member of as comma separated list.\";b:1;s:15:\"Version options\";b:1;s:22:\"Default jQuery Version\";b:1;s:28:\"Default (provided by Drupal)\";b:1;s:46:\"Select which jQuery version to use by default.\";b:1;s:49:\"Alternate jQuery version for administrative pages\";b:1;s:24:\"Created @number @entity.\";b:1;s:28:\"Metatag:Views configurations\";b:1;s:29:\"Provides meta tags for views.\";b:1;s:6:\"Admins\";b:1;s:14:\"Application ID\";b:1;s:23:\"Mobile & UI Adjustments\";b:1;s:11:\"Apple & iOS\";b:1;s:60:\"Custom meta tags used by Apple\'s software, iOS, Safari, etc.\";b:1;s:7:\"Android\";b:1;s:54:\"Custom meta tags used by the Android OS, browser, etc.\";b:1;s:24:\"Windows & Windows Mobile\";b:1;s:11:\"Theme Color\";b:1;s:16:\"Mobile Optimized\";b:1;s:17:\"Handheld-Friendly\";b:1;s:8:\"Viewport\";b:1;s:9:\"Cleartype\";b:1;s:18:\"iTunes App details\";b:1;s:16:\"Web app capable?\";b:1;s:16:\"Status bar color\";b:1;s:16:\"Format detection\";b:1;s:24:\"iOS app link alternative\";b:1;s:28:\"Android app link alternative\";b:1;s:8:\"Manifest\";b:1;s:15:\"X-UA-Compatible\";b:1;s:16:\"Application name\";b:1;s:38:\"MSApplication - Allow domain API calls\";b:1;s:38:\"MSApplication - Allow domain meta tags\";b:1;s:21:\"MSApplication - Badge\";b:1;s:22:\"MSApplication - Config\";b:1;s:32:\"MSApplication - Nav button color\";b:1;s:28:\"MSApplication - Notification\";b:1;s:42:\"MSApplication - Square logo, 150px x 150px\";b:1;s:46:\"The URL to a logo file that is 150px by 150px.\";b:1;s:42:\"MSApplication - Square logo, 310px x 310px\";b:1;s:46:\"The URL to a logo file that is 310px by 310px.\";b:1;s:40:\"MSApplication - Square logo, 70px x 70px\";b:1;s:44:\"The URL to a logo file that is 70px by 70px.\";b:1;s:40:\"MSApplication - Wide logo, 310px x 150px\";b:1;s:46:\"The URL to a logo file that is 310px by 150px.\";b:1;s:25:\"MSApplication - Start URL\";b:1;s:37:\"The URL to the root page of the site.\";b:1;s:20:\"MSApplication - Task\";b:1;s:30:\"MSApplication - Task separator\";b:1;s:26:\"MSApplication - Tile color\";b:1;s:64:\"The HTML color to use as the background color for the live tile.\";b:1;s:26:\"MSApplication - Tile image\";b:1;s:63:\"The URL to an image to use as the background for the live tile.\";b:1;s:23:\"MSApplication - Tooltip\";b:1;s:70:\"Controls the text shown in the tooltip for the pinned site\'s shortcut.\";b:1;s:22:\"MSApplication - Window\";b:1;s:47:\"Nid of the Feed Node that imported this entity.\";b:1;s:36:\"Feed Node that imported this entity.\";b:1;s:26:\"The universally unique ID.\";b:1;s:13:\"Revision UUID\";b:1;s:37:\"The revision\'s universally unique ID.\";b:1;s:15:\"googleanalytics\";b:1;s:10:\"Open Graph\";b:1;s:56:\"A human-readable name for the site, e.g., <em>IMDb</em>.\";b:1;s:46:\"The type of the content, e.g., <em>movie</em>.\";b:1;s:10:\"Activities\";b:1;s:8:\"Activity\";b:1;s:5:\"Sport\";b:1;s:10:\"Businesses\";b:1;s:3:\"Bar\";b:1;s:7:\"Company\";b:1;s:4:\"Cafe\";b:1;s:5:\"Hotel\";b:1;s:10:\"Restaurant\";b:1;s:5:\"Cause\";b:1;s:13:\"Sports league\";b:1;s:11:\"Sports team\";b:1;s:13:\"Organizations\";b:1;s:4:\"Band\";b:1;s:10:\"Government\";b:1;s:10:\"Non-profit\";b:1;s:6:\"School\";b:1;s:10:\"University\";b:1;s:5:\"Actor\";b:1;s:7:\"Athlete\";b:1;s:8:\"Director\";b:1;s:8:\"Musician\";b:1;s:10:\"Politician\";b:1;s:13:\"Public figure\";b:1;s:6:\"Places\";b:1;s:8:\"Landmark\";b:1;s:17:\"State or province\";b:1;s:26:\"Products and Entertainment\";b:1;s:5:\"Album\";b:1;s:5:\"Drink\";b:1;s:4:\"Food\";b:1;s:4:\"Game\";b:1;s:7:\"Product\";b:1;s:4:\"Song\";b:1;s:5:\"Movie\";b:1;s:7:\"TV show\";b:1;s:15:\"TV show episode\";b:1;s:19:\"Miscellaneous video\";b:1;s:8:\"Websites\";b:1;s:18:\"Article (inc blog)\";b:1;s:8:\"Page URL\";b:1;s:13:\"Content title\";b:1;s:50:\"The title of the content, e.g., <em>The Rock</em>.\";b:1;s:24:\"Content title determiner\";b:1;s:10:\"- Ignore -\";b:1;s:19:\"Content description\";b:1;s:49:\"A one to two sentence description of the content.\";b:1;s:32:\"Content modification date & time\";b:1;s:8:\"See also\";b:1;s:24:\"URLs to related content.\";b:1;s:9:\"Image URL\";b:1;s:16:\"Secure image URL\";b:1;s:10:\"Image type\";b:1;s:11:\"Image width\";b:1;s:12:\"Image height\";b:1;s:14:\"Street address\";b:1;s:8:\"Locality\";b:1;s:15:\"Postal/ZIP code\";b:1;s:19:\"Alternative locales\";b:1;s:14:\"Article author\";b:1;s:17:\"Article publisher\";b:1;s:48:\"Links an article to a publisher\'s Facebook page.\";b:1;s:15:\"Article section\";b:1;s:59:\"The primary section of this website the content belongs to.\";b:1;s:14:\"Article tag(s)\";b:1;s:38:\"Appropriate keywords for this content.\";b:1;s:31:\"Article publication date & time\";b:1;s:32:\"Article modification date & time\";b:1;s:30:\"Article expiration date & time\";b:1;s:10:\"First name\";b:1;s:56:\"The first name of the person who\'s Profile page this is.\";b:1;s:9:\"Last name\";b:1;s:23:\"The person\'s last name.\";b:1;s:35:\"A pseudonym / alias of this person.\";b:1;s:6:\"Gender\";b:1;s:9:\"Audio URL\";b:1;s:54:\"The URL to an audio file that complements this object.\";b:1;s:16:\"Audio secure URL\";b:1;s:10:\"Audio type\";b:1;s:13:\"Book\'s author\";b:1;s:11:\"Book\'s ISBN\";b:1;s:17:\"Book release date\";b:1;s:9:\"Book tags\";b:1;s:35:\"Appropriate keywords for this book.\";b:1;s:53:\"The URL to a video file that complements this object.\";b:1;s:16:\"Video secure URL\";b:1;s:11:\"Video width\";b:1;s:23:\"The width of the video.\";b:1;s:12:\"Video height\";b:1;s:24:\"The height of the video.\";b:1;s:10:\"Video type\";b:1;s:8:\"Actor(s)\";b:1;s:69:\"Links to the Facebook profiles for actor(s) that appear in the video.\";b:1;s:12:\"Actors\' role\";b:1;s:26:\"The roles of the actor(s).\";b:1;s:11:\"Director(s)\";b:1;s:72:\"Links to the Facebook profiles for director(s) that worked on the video.\";b:1;s:15:\"Scriptwriter(s)\";b:1;s:65:\"Links to the Facebook profiles for scriptwriter(s) for the video.\";b:1;s:24:\"Video duration (seconds)\";b:1;s:34:\"The length of the video in seconds\";b:1;s:12:\"Release date\";b:1;s:32:\"The date the video was released.\";b:1;s:37:\"Tag words associated with this video.\";b:1;s:6:\"Series\";b:1;s:35:\"The TV show this series belongs to.\";b:1;s:13:\"Nome do sitio\";b:1;s:15:\"Tipo de contido\";b:1;s:5:\"Área\";b:1;s:19:\"Correo electrónico\";b:1;s:17:\"Nome de usuario/a\";b:1;s:8:\"Etiqueta\";b:1;s:21:\"Open Graph - Products\";b:1;s:51:\"These Open Graph meta tags for describing products.\";b:1;s:5:\"Price\";b:1;s:8:\"Currency\";b:1;s:36:\"The currency for the price (if any).\";b:1;s:12:\"Availability\";b:1;s:5:\"Brand\";b:1;s:3:\"UPC\";b:1;s:3:\"EAN\";b:1;s:4:\"ISBN\";b:1;s:12:\"Plural Title\";b:1;s:11:\"Retailer ID\";b:1;s:13:\"Retailer Name\";b:1;s:27:\"Retailer SKU/Product Number\";b:1;s:28:\"Manufacturer SKU/Part Number\";b:1;s:12:\"Product Link\";b:1;s:8:\"Material\";b:1;s:7:\"Pattern\";b:1;s:20:\"Shipping Cost Amount\";b:1;s:22:\"Shipping Cost Currency\";b:1;s:14:\"Product Weight\";b:1;s:20:\"Product Weight Units\";b:1;s:15:\"Shipping Weight\";b:1;s:21:\"Shipping Weight Units\";b:1;s:10:\"Expiration\";b:1;s:9:\"Condition\";b:1;s:61:\"A title to be used to describe multiple items of this product\";b:1;s:60:\"A Facebook ID (or reference to the profile) of the retailer.\";b:1;s:25:\"The name of the retailer.\";b:1;s:23:\"A retailer part number.\";b:1;s:27:\"A manufacturer part number.\";b:1;s:7:\"Tamaño\";b:1;s:47:\"A size describing the product, such as S, M, L.\";b:1;s:41:\"A link to find out more about the product\";b:1;s:3:\"Cor\";b:1;s:55:\"A description of the material used to make the product.\";b:1;s:34:\"A description of the pattern used.\";b:1;s:19:\"The shipping costs.\";b:1;s:27:\"The shipping cost currency.\";b:1;s:39:\"The weight, without shipping materials.\";b:1;s:19:\"The unit of weight.\";b:1;s:20:\"The shipping weight.\";b:1;s:28:\"The unit of shipping weight.\";b:1;s:61:\"A time representing when the product expired, or will expire.\";b:1;s:29:\"The condition of the product.\";b:1;s:16:\"Unable to create\";b:1;s:25:\"No description available.\";b:1;s:23:\"Current Modernizr Tests\";b:1;s:40:\"Download your Modernizr production build\";b:1;s:16:\"clear your cache\";b:1;s:20:\"Nombre del sitio web\";b:1;s:17:\"Tipo de contenido\";b:1;s:7:\"Región\";b:1;s:16:\"Regionalización\";b:1;s:17:\"Nombre de usuario\";b:1;s:14:\"URL del vídeo\";b:1;s:42:\"Are you sure you want to delete this item?\";b:1;s:15:\"Deleted 1 post.\";b:1;s:40:\"Exclude certain pages from being cached.\";b:1;s:16:\"Cache exclusions\";b:1;s:40:\"Configure pages to exclude from caching.\";b:1;s:29:\"Pages to exclude from caching\";b:1;s:37:\"Content types to exclude from caching\";b:1;s:58:\"Check all content types that you do not want to be cached.\";b:1;s:24:\"administer block classes\";b:1;s:37:\"clear territorio_de_las_mujeres feeds\";b:1;s:38:\"import territorio_de_las_mujeres feeds\";b:1;s:16:\"administer feeds\";b:1;s:38:\"unlock territorio_de_las_mujeres feeds\";b:1;s:27:\"administer google analytics\";b:1;s:31:\"use PHP for tracking visibility\";b:1;s:29:\"administer menu_trail_by_path\";b:1;s:14:\"edit meta tags\";b:1;s:20:\"administer meta tags\";b:1;s:29:\"delete own diary_item content\";b:1;s:25:\"create diary_item content\";b:1;s:27:\"edit any diary_item content\";b:1;s:27:\"edit own diary_item content\";b:1;s:29:\"delete any diary_item content\";b:1;s:23:\"delete own home content\";b:1;s:19:\"create home content\";b:1;s:21:\"edit any home content\";b:1;s:21:\"edit own home content\";b:1;s:23:\"delete any home content\";b:1;s:12:\"export nodes\";b:1;s:16:\"export own nodes\";b:1;s:23:\"use PHP to import nodes\";b:1;s:20:\"administer respondjs\";b:1;s:20:\"access service links\";b:1;s:30:\"use PHP for service visibility\";b:1;s:15:\"edit terms in 4\";b:1;s:17:\"delete terms in 4\";b:1;s:15:\"administer uuid\";b:1;s:20:\"administer modernizr\";b:1;s:31:\"administer custom search blocks\";b:1;s:24:\"use custom search blocks\";b:1;s:24:\"administer custom search\";b:1;s:17:\"use custom search\";b:1;}s:4:\"ampm\";a:2:{s:2:\"am\";b:1;s:2:\"pm\";b:1;}s:18:\"compression format\";a:1:{s:3:\"Zip\";s:40:\"Zip\r\nen contexto: formato de compresión\";}s:8:\"datetime\";a:7:{s:4:\"Year\";b:1;s:5:\"Month\";b:1;s:3:\"Day\";b:1;s:4:\"Hour\";b:1;s:6:\"Minute\";b:1;s:6:\"Second\";b:1;s:4:\"Date\";b:1;}s:11:\"geolocation\";a:1:{s:8:\"Location\";s:13:\"Localización\";}s:15:\"Long month name\";a:10:{s:5:\"April\";s:5:\"Abril\";s:7:\"January\";s:7:\"Xaneiro\";s:5:\"March\";s:5:\"Marzo\";s:3:\"May\";s:4:\"Maio\";s:4:\"June\";s:5:\"Xuño\";s:4:\"July\";s:5:\"Xullo\";s:9:\"September\";s:8:\"Setembro\";s:7:\"October\";s:7:\"Outubro\";s:8:\"November\";s:8:\"Novembro\";s:8:\"December\";s:8:\"Decembro\";}s:10:\"Sort order\";a:2:{s:12:\"Alphabetical\";s:31:\"Alfabético\r\nen contexto: Orden\";s:9:\"Numerical\";b:1;}}',0,1473282028,1),('node_types:es','O:8:\"stdClass\":2:{s:5:\"types\";a:7:{s:8:\"activity\";O:8:\"stdClass\":14:{s:4:\"type\";s:8:\"activity\";s:4:\"name\";s:10:\"Actividade\";s:4:\"base\";s:12:\"node_content\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:107:\"Usa <em>actividades</em> para contidos sensibles ao tempo, como noticias, comunicados de prensa ou artigos.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:7:\"Título\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:8:\"disabled\";s:1:\"0\";s:9:\"orig_type\";s:7:\"article\";s:16:\"disabled_changed\";b:0;}s:7:\"archive\";O:8:\"stdClass\":14:{s:4:\"type\";s:7:\"archive\";s:4:\"name\";s:7:\"Arquivo\";s:4:\"base\";s:12:\"node_content\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:52:\"Usa <em>arquivos</em> para estudos e documentación.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:7:\"Título\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:8:\"disabled\";s:1:\"0\";s:9:\"orig_type\";s:7:\"archive\";s:16:\"disabled_changed\";b:0;}s:6:\"banner\";O:8:\"stdClass\":14:{s:4:\"type\";s:6:\"banner\";s:4:\"name\";s:6:\"Banner\";s:4:\"base\";s:12:\"node_content\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:35:\"Usa <em>banners</em> para anuncios.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:7:\"Título\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:8:\"disabled\";s:1:\"0\";s:9:\"orig_type\";s:6:\"banner\";s:16:\"disabled_changed\";b:0;}s:10:\"diary_item\";O:8:\"stdClass\":14:{s:4:\"type\";s:10:\"diary_item\";s:4:\"name\";s:17:\"Entrada da Axenda\";s:4:\"base\";s:12:\"node_content\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:74:\"Tipo de contido empregado polo importador RSS \"Territorio de las mujeres\".\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:7:\"Título\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:8:\"disabled\";s:1:\"0\";s:9:\"orig_type\";s:5:\"diary\";s:16:\"disabled_changed\";b:0;}s:4:\"home\";O:8:\"stdClass\":14:{s:4:\"type\";s:4:\"home\";s:4:\"name\";s:4:\"Home\";s:4:\"base\";s:12:\"node_content\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:43:\"Usa <em>home</ em> para a portada do sitio.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:7:\"Título\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:8:\"disabled\";s:1:\"0\";s:9:\"orig_type\";s:4:\"home\";s:16:\"disabled_changed\";b:0;}s:4:\"page\";O:8:\"stdClass\":14:{s:4:\"type\";s:4:\"page\";s:4:\"name\";s:7:\"Páxina\";s:4:\"base\";s:12:\"node_content\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:81:\"Usa <em>páxinas</ em> para o teu contido estático, como a páxina \"Quen somos\".\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:7:\"Título\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:8:\"disabled\";s:1:\"0\";s:9:\"orig_type\";s:4:\"page\";s:16:\"disabled_changed\";b:0;}s:5:\"place\";O:8:\"stdClass\":14:{s:4:\"type\";s:5:\"place\";s:4:\"name\";s:5:\"Lugar\";s:4:\"base\";s:12:\"node_content\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:57:\"Usa <em>lugares</em> para engadir hoteis, restaurantes...\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:7:\"Título\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:8:\"disabled\";s:1:\"0\";s:9:\"orig_type\";s:5:\"place\";s:16:\"disabled_changed\";b:0;}}s:5:\"names\";a:7:{s:8:\"activity\";s:10:\"Actividade\";s:7:\"archive\";s:7:\"Arquivo\";s:6:\"banner\";s:6:\"Banner\";s:10:\"diary_item\";s:17:\"Entrada da Axenda\";s:4:\"home\";s:4:\"Home\";s:5:\"place\";s:5:\"Lugar\";s:4:\"page\";s:7:\"Páxina\";}}',0,1469579890,1),('node_types:gl','O:8:\"stdClass\":2:{s:5:\"types\";a:7:{s:8:\"activity\";O:8:\"stdClass\":14:{s:4:\"type\";s:8:\"activity\";s:4:\"name\";s:10:\"Actividade\";s:4:\"base\";s:12:\"node_content\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:107:\"Usa <em>actividades</em> para contidos sensibles ao tempo, como noticias, comunicados de prensa ou artigos.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:7:\"Título\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:8:\"disabled\";s:1:\"0\";s:9:\"orig_type\";s:7:\"article\";s:16:\"disabled_changed\";b:0;}s:7:\"archive\";O:8:\"stdClass\":14:{s:4:\"type\";s:7:\"archive\";s:4:\"name\";s:7:\"Arquivo\";s:4:\"base\";s:12:\"node_content\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:52:\"Usa <em>arquivos</em> para estudos e documentación.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:7:\"Título\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:8:\"disabled\";s:1:\"0\";s:9:\"orig_type\";s:7:\"archive\";s:16:\"disabled_changed\";b:0;}s:6:\"banner\";O:8:\"stdClass\":14:{s:4:\"type\";s:6:\"banner\";s:4:\"name\";s:6:\"Banner\";s:4:\"base\";s:12:\"node_content\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:35:\"Usa <em>banners</em> para anuncios.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:7:\"Título\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:8:\"disabled\";s:1:\"0\";s:9:\"orig_type\";s:6:\"banner\";s:16:\"disabled_changed\";b:0;}s:10:\"diary_item\";O:8:\"stdClass\":14:{s:4:\"type\";s:10:\"diary_item\";s:4:\"name\";s:17:\"Entrada da Axenda\";s:4:\"base\";s:12:\"node_content\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:74:\"Tipo de contido empregado polo importador RSS \"Territorio de las mujeres\".\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:7:\"Título\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:8:\"disabled\";s:1:\"0\";s:9:\"orig_type\";s:5:\"diary\";s:16:\"disabled_changed\";b:0;}s:4:\"home\";O:8:\"stdClass\":14:{s:4:\"type\";s:4:\"home\";s:4:\"name\";s:4:\"Home\";s:4:\"base\";s:12:\"node_content\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:43:\"Usa <em>home</ em> para a portada do sitio.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:7:\"Título\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:8:\"disabled\";s:1:\"0\";s:9:\"orig_type\";s:4:\"home\";s:16:\"disabled_changed\";b:0;}s:4:\"page\";O:8:\"stdClass\":14:{s:4:\"type\";s:4:\"page\";s:4:\"name\";s:7:\"Páxina\";s:4:\"base\";s:12:\"node_content\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:81:\"Usa <em>páxinas</ em> para o teu contido estático, como a páxina \"Quen somos\".\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:7:\"Título\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:8:\"disabled\";s:1:\"0\";s:9:\"orig_type\";s:4:\"page\";s:16:\"disabled_changed\";b:0;}s:5:\"place\";O:8:\"stdClass\":14:{s:4:\"type\";s:5:\"place\";s:4:\"name\";s:5:\"Lugar\";s:4:\"base\";s:12:\"node_content\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:57:\"Usa <em>lugares</em> para engadir hoteis, restaurantes...\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:7:\"Título\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:8:\"disabled\";s:1:\"0\";s:9:\"orig_type\";s:5:\"place\";s:16:\"disabled_changed\";b:0;}}s:5:\"names\";a:7:{s:8:\"activity\";s:10:\"Actividade\";s:7:\"archive\";s:7:\"Arquivo\";s:6:\"banner\";s:6:\"Banner\";s:10:\"diary_item\";s:17:\"Entrada da Axenda\";s:4:\"home\";s:4:\"Home\";s:5:\"place\";s:5:\"Lugar\";s:4:\"page\";s:7:\"Páxina\";}}',0,1469579868,1),('pathauto:punctuation:es','a:32:{s:13:\"double_quotes\";a:2:{s:5:\"value\";s:1:\"\"\";s:4:\"name\";s:15:\"Comillas dobles\";}s:6:\"quotes\";a:2:{s:5:\"value\";s:1:\"\'\";s:4:\"name\";s:29:\"Comillas simples (apóstrofo)\";}s:8:\"backtick\";a:2:{s:5:\"value\";s:1:\"`\";s:4:\"name\";s:12:\"Acento grave\";}s:5:\"comma\";a:2:{s:5:\"value\";s:1:\",\";s:4:\"name\";s:4:\"Coma\";}s:6:\"period\";a:2:{s:5:\"value\";s:1:\".\";s:4:\"name\";s:8:\"Período\";}s:6:\"hyphen\";a:2:{s:5:\"value\";s:1:\"-\";s:4:\"name\";s:6:\"Guión\";}s:10:\"underscore\";a:2:{s:5:\"value\";s:1:\"_\";s:4:\"name\";s:11:\"Guión bajo\";}s:5:\"colon\";a:2:{s:5:\"value\";s:1:\":\";s:4:\"name\";s:10:\"Dos puntos\";}s:9:\"semicolon\";a:2:{s:5:\"value\";s:1:\";\";s:4:\"name\";s:12:\"Punto y coma\";}s:4:\"pipe\";a:2:{s:5:\"value\";s:1:\"|\";s:4:\"name\";s:14:\"Barra vertical\";}s:10:\"left_curly\";a:2:{s:5:\"value\";s:1:\"{\";s:4:\"name\";s:15:\"Llave izquierda\";}s:11:\"left_square\";a:2:{s:5:\"value\";s:1:\"[\";s:4:\"name\";s:18:\"Corchete izquierdo\";}s:11:\"right_curly\";a:2:{s:5:\"value\";s:1:\"}\";s:4:\"name\";s:13:\"Llave derecha\";}s:12:\"right_square\";a:2:{s:5:\"value\";s:1:\"]\";s:4:\"name\";s:16:\"Corchete derecho\";}s:4:\"plus\";a:2:{s:5:\"value\";s:1:\"+\";s:4:\"name\";s:10:\"Signo más\";}s:5:\"equal\";a:2:{s:5:\"value\";s:1:\"=\";s:4:\"name\";s:11:\"Signo igual\";}s:8:\"asterisk\";a:2:{s:5:\"value\";s:1:\"*\";s:4:\"name\";s:9:\"Asterisco\";}s:9:\"ampersand\";a:2:{s:5:\"value\";s:1:\"&\";s:4:\"name\";s:9:\"Ampersand\";}s:7:\"percent\";a:2:{s:5:\"value\";s:1:\"%\";s:4:\"name\";s:19:\"Signo de porcentaje\";}s:5:\"caret\";a:2:{s:5:\"value\";s:1:\"^\";s:4:\"name\";s:18:\"Acento circunflejo\";}s:6:\"dollar\";a:2:{s:5:\"value\";s:1:\"$\";s:4:\"name\";s:16:\"Signo del dólar\";}s:4:\"hash\";a:2:{s:5:\"value\";s:1:\"#\";s:4:\"name\";s:49:\"Símbolo numérico (Libra Esterlina, almohadilla)\";}s:2:\"at\";a:2:{s:5:\"value\";s:1:\"@\";s:4:\"name\";s:6:\"Arroba\";}s:11:\"exclamation\";a:2:{s:5:\"value\";s:1:\"!\";s:4:\"name\";s:21:\"Signo de exclamación\";}s:5:\"tilde\";a:2:{s:5:\"value\";s:1:\"~\";s:4:\"name\";s:5:\"Tilde\";}s:16:\"left_parenthesis\";a:2:{s:5:\"value\";s:1:\"(\";s:4:\"name\";s:21:\"Paréntesis izquierdo\";}s:17:\"right_parenthesis\";a:2:{s:5:\"value\";s:1:\")\";s:4:\"name\";s:19:\"Paréntesis derecho\";}s:13:\"question_mark\";a:2:{s:5:\"value\";s:1:\"?\";s:4:\"name\";s:26:\"Símbolo de interrogación\";}s:9:\"less_than\";a:2:{s:5:\"value\";s:1:\"<\";s:4:\"name\";s:18:\"Símbolo menor que\";}s:12:\"greater_than\";a:2:{s:5:\"value\";s:1:\">\";s:4:\"name\";s:18:\"Símbolo mayor que\";}s:5:\"slash\";a:2:{s:5:\"value\";s:1:\"/\";s:4:\"name\";s:5:\"Barra\";}s:10:\"back_slash\";a:2:{s:5:\"value\";s:1:\"\\\";s:4:\"name\";s:15:\"Barra invertida\";}}',0,1469613567,1),('pathauto:punctuation:gl','a:32:{s:13:\"double_quotes\";a:2:{s:5:\"value\";s:1:\"\"\";s:4:\"name\";s:22:\"Double quotation marks\";}s:6:\"quotes\";a:2:{s:5:\"value\";s:1:\"\'\";s:4:\"name\";s:35:\"Single quotation marks (apostrophe)\";}s:8:\"backtick\";a:2:{s:5:\"value\";s:1:\"`\";s:4:\"name\";s:9:\"Back tick\";}s:5:\"comma\";a:2:{s:5:\"value\";s:1:\",\";s:4:\"name\";s:4:\"Coma\";}s:6:\"period\";a:2:{s:5:\"value\";s:1:\".\";s:4:\"name\";s:7:\"Periodo\";}s:6:\"hyphen\";a:2:{s:5:\"value\";s:1:\"-\";s:4:\"name\";s:6:\"Hyphen\";}s:10:\"underscore\";a:2:{s:5:\"value\";s:1:\"_\";s:4:\"name\";s:10:\"Underscore\";}s:5:\"colon\";a:2:{s:5:\"value\";s:1:\":\";s:4:\"name\";s:5:\"Colon\";}s:9:\"semicolon\";a:2:{s:5:\"value\";s:1:\";\";s:4:\"name\";s:9:\"Semicolon\";}s:4:\"pipe\";a:2:{s:5:\"value\";s:1:\"|\";s:4:\"name\";s:19:\"Vertical bar (pipe)\";}s:10:\"left_curly\";a:2:{s:5:\"value\";s:1:\"{\";s:4:\"name\";s:18:\"Left curly bracket\";}s:11:\"left_square\";a:2:{s:5:\"value\";s:1:\"[\";s:4:\"name\";s:19:\"Left square bracket\";}s:11:\"right_curly\";a:2:{s:5:\"value\";s:1:\"}\";s:4:\"name\";s:19:\"Right curly bracket\";}s:12:\"right_square\";a:2:{s:5:\"value\";s:1:\"]\";s:4:\"name\";s:20:\"Right square bracket\";}s:4:\"plus\";a:2:{s:5:\"value\";s:1:\"+\";s:4:\"name\";s:9:\"Plus sign\";}s:5:\"equal\";a:2:{s:5:\"value\";s:1:\"=\";s:4:\"name\";s:10:\"Equal sign\";}s:8:\"asterisk\";a:2:{s:5:\"value\";s:1:\"*\";s:4:\"name\";s:8:\"Asterisk\";}s:9:\"ampersand\";a:2:{s:5:\"value\";s:1:\"&\";s:4:\"name\";s:9:\"Ampersand\";}s:7:\"percent\";a:2:{s:5:\"value\";s:1:\"%\";s:4:\"name\";s:12:\"Percent sign\";}s:5:\"caret\";a:2:{s:5:\"value\";s:1:\"^\";s:4:\"name\";s:5:\"Caret\";}s:6:\"dollar\";a:2:{s:5:\"value\";s:1:\"$\";s:4:\"name\";s:11:\"Dollar sign\";}s:4:\"hash\";a:2:{s:5:\"value\";s:1:\"#\";s:4:\"name\";s:30:\"Number sign (pound sign, hash)\";}s:2:\"at\";a:2:{s:5:\"value\";s:1:\"@\";s:4:\"name\";s:7:\"At sign\";}s:11:\"exclamation\";a:2:{s:5:\"value\";s:1:\"!\";s:4:\"name\";s:16:\"Exclamation mark\";}s:5:\"tilde\";a:2:{s:5:\"value\";s:1:\"~\";s:4:\"name\";s:5:\"Tilde\";}s:16:\"left_parenthesis\";a:2:{s:5:\"value\";s:1:\"(\";s:4:\"name\";s:16:\"Left parenthesis\";}s:17:\"right_parenthesis\";a:2:{s:5:\"value\";s:1:\")\";s:4:\"name\";s:17:\"Right parenthesis\";}s:13:\"question_mark\";a:2:{s:5:\"value\";s:1:\"?\";s:4:\"name\";s:13:\"Question mark\";}s:9:\"less_than\";a:2:{s:5:\"value\";s:1:\"<\";s:4:\"name\";s:14:\"Less-than sign\";}s:12:\"greater_than\";a:2:{s:5:\"value\";s:1:\">\";s:4:\"name\";s:17:\"Greater-than sign\";}s:5:\"slash\";a:2:{s:5:\"value\";s:1:\"/\";s:4:\"name\";s:5:\"Slash\";}s:10:\"back_slash\";a:2:{s:5:\"value\";s:1:\"\\\";s:4:\"name\";s:9:\"Backslash\";}}',0,1469613489,1),('plugins:feeds:plugins','a:17:{s:11:\"FeedsPlugin\";a:8:{s:6:\"hidden\";b:1;s:7:\"handler\";a:3:{s:5:\"class\";s:11:\"FeedsPlugin\";s:4:\"file\";s:15:\"FeedsPlugin.inc\";s:4:\"path\";s:31:\"sites/all/modules/feeds/plugins\";}s:6:\"module\";s:5:\"feeds\";s:4:\"name\";s:11:\"FeedsPlugin\";s:4:\"path\";s:23:\"sites/all/modules/feeds\";s:4:\"file\";N;s:13:\"plugin module\";s:5:\"feeds\";s:11:\"plugin type\";s:7:\"plugins\";}s:18:\"FeedsMissingPlugin\";a:8:{s:4:\"name\";s:14:\"Missing plugin\";s:11:\"description\";s:43:\"There is a problem with your configuration.\";s:7:\"handler\";a:3:{s:5:\"class\";s:18:\"FeedsMissingPlugin\";s:4:\"file\";s:15:\"FeedsPlugin.inc\";s:4:\"path\";s:31:\"sites/all/modules/feeds/plugins\";}s:6:\"module\";s:5:\"feeds\";s:4:\"path\";s:23:\"sites/all/modules/feeds\";s:4:\"file\";N;s:13:\"plugin module\";s:5:\"feeds\";s:11:\"plugin type\";s:7:\"plugins\";}s:12:\"FeedsFetcher\";a:8:{s:6:\"hidden\";b:1;s:7:\"handler\";a:4:{s:6:\"parent\";s:11:\"FeedsPlugin\";s:5:\"class\";s:12:\"FeedsFetcher\";s:4:\"file\";s:16:\"FeedsFetcher.inc\";s:4:\"path\";s:31:\"sites/all/modules/feeds/plugins\";}s:6:\"module\";s:5:\"feeds\";s:4:\"name\";s:12:\"FeedsFetcher\";s:4:\"path\";s:23:\"sites/all/modules/feeds\";s:4:\"file\";N;s:13:\"plugin module\";s:5:\"feeds\";s:11:\"plugin type\";s:7:\"plugins\";}s:11:\"FeedsParser\";a:8:{s:6:\"hidden\";b:1;s:7:\"handler\";a:4:{s:6:\"parent\";s:11:\"FeedsPlugin\";s:5:\"class\";s:11:\"FeedsParser\";s:4:\"file\";s:15:\"FeedsParser.inc\";s:4:\"path\";s:31:\"sites/all/modules/feeds/plugins\";}s:6:\"module\";s:5:\"feeds\";s:4:\"name\";s:11:\"FeedsParser\";s:4:\"path\";s:23:\"sites/all/modules/feeds\";s:4:\"file\";N;s:13:\"plugin module\";s:5:\"feeds\";s:11:\"plugin type\";s:7:\"plugins\";}s:14:\"FeedsProcessor\";a:8:{s:6:\"hidden\";b:1;s:7:\"handler\";a:4:{s:6:\"parent\";s:11:\"FeedsPlugin\";s:5:\"class\";s:14:\"FeedsProcessor\";s:4:\"file\";s:18:\"FeedsProcessor.inc\";s:4:\"path\";s:31:\"sites/all/modules/feeds/plugins\";}s:6:\"module\";s:5:\"feeds\";s:4:\"name\";s:14:\"FeedsProcessor\";s:4:\"path\";s:23:\"sites/all/modules/feeds\";s:4:\"file\";N;s:13:\"plugin module\";s:5:\"feeds\";s:11:\"plugin type\";s:7:\"plugins\";}s:16:\"FeedsHTTPFetcher\";a:8:{s:4:\"name\";s:12:\"HTTP Fetcher\";s:11:\"description\";s:28:\"Download content from a URL.\";s:7:\"handler\";a:4:{s:6:\"parent\";s:12:\"FeedsFetcher\";s:5:\"class\";s:16:\"FeedsHTTPFetcher\";s:4:\"file\";s:20:\"FeedsHTTPFetcher.inc\";s:4:\"path\";s:31:\"sites/all/modules/feeds/plugins\";}s:6:\"module\";s:5:\"feeds\";s:4:\"path\";s:23:\"sites/all/modules/feeds\";s:4:\"file\";N;s:13:\"plugin module\";s:5:\"feeds\";s:11:\"plugin type\";s:7:\"plugins\";}s:16:\"FeedsFileFetcher\";a:8:{s:4:\"name\";s:11:\"File upload\";s:11:\"description\";s:33:\"Upload content from a local file.\";s:7:\"handler\";a:4:{s:6:\"parent\";s:12:\"FeedsFetcher\";s:5:\"class\";s:16:\"FeedsFileFetcher\";s:4:\"file\";s:20:\"FeedsFileFetcher.inc\";s:4:\"path\";s:31:\"sites/all/modules/feeds/plugins\";}s:6:\"module\";s:5:\"feeds\";s:4:\"path\";s:23:\"sites/all/modules/feeds\";s:4:\"file\";N;s:13:\"plugin module\";s:5:\"feeds\";s:11:\"plugin type\";s:7:\"plugins\";}s:14:\"FeedsCSVParser\";a:8:{s:4:\"name\";s:10:\"CSV parser\";s:11:\"description\";s:43:\"Parse data in Comma Separated Value format.\";s:7:\"handler\";a:4:{s:6:\"parent\";s:11:\"FeedsParser\";s:5:\"class\";s:14:\"FeedsCSVParser\";s:4:\"file\";s:18:\"FeedsCSVParser.inc\";s:4:\"path\";s:31:\"sites/all/modules/feeds/plugins\";}s:6:\"module\";s:5:\"feeds\";s:4:\"path\";s:23:\"sites/all/modules/feeds\";s:4:\"file\";N;s:13:\"plugin module\";s:5:\"feeds\";s:11:\"plugin type\";s:7:\"plugins\";}s:22:\"FeedsSyndicationParser\";a:9:{s:4:\"name\";s:25:\"Common syndication parser\";s:11:\"description\";s:25:\"Parse RSS and Atom feeds.\";s:4:\"help\";s:48:\"Parse XML feeds in RSS 1, RSS 2 and Atom format.\";s:7:\"handler\";a:4:{s:6:\"parent\";s:11:\"FeedsParser\";s:5:\"class\";s:22:\"FeedsSyndicationParser\";s:4:\"file\";s:26:\"FeedsSyndicationParser.inc\";s:4:\"path\";s:31:\"sites/all/modules/feeds/plugins\";}s:6:\"module\";s:5:\"feeds\";s:4:\"path\";s:23:\"sites/all/modules/feeds\";s:4:\"file\";N;s:13:\"plugin module\";s:5:\"feeds\";s:11:\"plugin type\";s:7:\"plugins\";}s:15:\"FeedsOPMLParser\";a:8:{s:4:\"name\";s:11:\"OPML parser\";s:11:\"description\";s:17:\"Parse OPML files.\";s:7:\"handler\";a:4:{s:6:\"parent\";s:11:\"FeedsParser\";s:5:\"class\";s:15:\"FeedsOPMLParser\";s:4:\"file\";s:19:\"FeedsOPMLParser.inc\";s:4:\"path\";s:31:\"sites/all/modules/feeds/plugins\";}s:6:\"module\";s:5:\"feeds\";s:4:\"path\";s:23:\"sites/all/modules/feeds\";s:4:\"file\";N;s:13:\"plugin module\";s:5:\"feeds\";s:11:\"plugin type\";s:7:\"plugins\";}s:18:\"FeedsSitemapParser\";a:8:{s:4:\"name\";s:14:\"Sitemap parser\";s:11:\"description\";s:31:\"Parse Sitemap XML format feeds.\";s:7:\"handler\";a:4:{s:6:\"parent\";s:11:\"FeedsParser\";s:5:\"class\";s:18:\"FeedsSitemapParser\";s:4:\"file\";s:22:\"FeedsSitemapParser.inc\";s:4:\"path\";s:31:\"sites/all/modules/feeds/plugins\";}s:6:\"module\";s:5:\"feeds\";s:4:\"path\";s:23:\"sites/all/modules/feeds\";s:4:\"file\";N;s:13:\"plugin module\";s:5:\"feeds\";s:11:\"plugin type\";s:7:\"plugins\";}s:18:\"FeedsNodeProcessor\";a:9:{s:4:\"name\";s:14:\"Node processor\";s:11:\"description\";s:24:\"Create and update nodes.\";s:4:\"help\";s:44:\"Create and update nodes from parsed content.\";s:7:\"handler\";a:4:{s:6:\"parent\";s:14:\"FeedsProcessor\";s:5:\"class\";s:18:\"FeedsNodeProcessor\";s:4:\"file\";s:22:\"FeedsNodeProcessor.inc\";s:4:\"path\";s:31:\"sites/all/modules/feeds/plugins\";}s:6:\"module\";s:5:\"feeds\";s:4:\"path\";s:23:\"sites/all/modules/feeds\";s:4:\"file\";N;s:13:\"plugin module\";s:5:\"feeds\";s:11:\"plugin type\";s:7:\"plugins\";}s:18:\"FeedsUserProcessor\";a:9:{s:4:\"name\";s:14:\"User processor\";s:11:\"description\";s:13:\"Create users.\";s:4:\"help\";s:33:\"Create users from parsed content.\";s:7:\"handler\";a:4:{s:6:\"parent\";s:14:\"FeedsProcessor\";s:5:\"class\";s:18:\"FeedsUserProcessor\";s:4:\"file\";s:22:\"FeedsUserProcessor.inc\";s:4:\"path\";s:31:\"sites/all/modules/feeds/plugins\";}s:6:\"module\";s:5:\"feeds\";s:4:\"path\";s:23:\"sites/all/modules/feeds\";s:4:\"file\";N;s:13:\"plugin module\";s:5:\"feeds\";s:11:\"plugin type\";s:7:\"plugins\";}s:18:\"FeedsTermProcessor\";a:9:{s:4:\"name\";s:23:\"Taxonomy term processor\";s:11:\"description\";s:22:\"Create taxonomy terms.\";s:4:\"help\";s:42:\"Create taxonomy terms from parsed content.\";s:7:\"handler\";a:4:{s:6:\"parent\";s:14:\"FeedsProcessor\";s:5:\"class\";s:18:\"FeedsTermProcessor\";s:4:\"file\";s:22:\"FeedsTermProcessor.inc\";s:4:\"path\";s:31:\"sites/all/modules/feeds/plugins\";}s:6:\"module\";s:5:\"feeds\";s:4:\"path\";s:23:\"sites/all/modules/feeds\";s:4:\"file\";N;s:13:\"plugin module\";s:5:\"feeds\";s:11:\"plugin type\";s:7:\"plugins\";}s:11:\"FeedsExBase\";a:8:{s:6:\"hidden\";b:1;s:7:\"handler\";a:4:{s:6:\"parent\";s:11:\"FeedsParser\";s:5:\"class\";s:11:\"FeedsExBase\";s:4:\"file\";s:15:\"FeedsExBase.inc\";s:4:\"path\";s:30:\"sites/all/modules/feeds_ex/src\";}s:6:\"module\";s:8:\"feeds_ex\";s:4:\"name\";s:11:\"FeedsExBase\";s:4:\"path\";s:26:\"sites/all/modules/feeds_ex\";s:4:\"file\";N;s:13:\"plugin module\";s:5:\"feeds\";s:11:\"plugin type\";s:7:\"plugins\";}s:10:\"FeedsExXml\";a:8:{s:4:\"name\";s:16:\"XML Xpath parser\";s:11:\"description\";s:21:\"Parse XML with XPath.\";s:7:\"handler\";a:4:{s:6:\"parent\";s:11:\"FeedsExBase\";s:5:\"class\";s:10:\"FeedsExXml\";s:4:\"file\";s:14:\"FeedsExXml.inc\";s:4:\"path\";s:30:\"sites/all/modules/feeds_ex/src\";}s:6:\"module\";s:8:\"feeds_ex\";s:4:\"path\";s:26:\"sites/all/modules/feeds_ex\";s:4:\"file\";N;s:13:\"plugin module\";s:5:\"feeds\";s:11:\"plugin type\";s:7:\"plugins\";}s:11:\"FeedsExHtml\";a:8:{s:4:\"name\";s:17:\"HTML Xpath parser\";s:11:\"description\";s:22:\"Parse HTML with XPath.\";s:7:\"handler\";a:4:{s:6:\"parent\";s:10:\"FeedsExXml\";s:5:\"class\";s:11:\"FeedsExHtml\";s:4:\"file\";s:15:\"FeedsExHtml.inc\";s:4:\"path\";s:30:\"sites/all/modules/feeds_ex/src\";}s:6:\"module\";s:8:\"feeds_ex\";s:4:\"path\";s:26:\"sites/all/modules/feeds_ex\";s:4:\"file\";N;s:13:\"plugin module\";s:5:\"feeds\";s:11:\"plugin type\";s:7:\"plugins\";}}',0,1469579872,1);
INSERT INTO `cache` VALUES ('schema','a:177:{s:14:\"variable_store\";a:5:{s:6:\"fields\";a:5:{s:5:\"realm\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:50;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:9:\"realm_key\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:50;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:4:\"name\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:5:\"value\";a:3:{s:4:\"type\";s:4:\"text\";s:8:\"not null\";b:1;s:4:\"size\";s:3:\"big\";}s:10:\"serialized\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:5:\"small\";s:8:\"not null\";b:1;s:7:\"default\";i:1;}}s:11:\"primary key\";a:3:{i:0;s:5:\"realm\";i:1;s:9:\"realm_key\";i:2;s:4:\"name\";}s:7:\"indexes\";a:1:{s:11:\"realm_value\";a:2:{i:0;s:5:\"realm\";i:1;s:9:\"realm_key\";}}s:6:\"module\";s:14:\"variable_store\";s:4:\"name\";s:14:\"variable_store\";}s:5:\"block\";a:6:{s:6:\"fields\";a:14:{s:3:\"bid\";a:2:{s:4:\"type\";s:6:\"serial\";s:8:\"not null\";b:1;}s:6:\"module\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:64;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:5:\"delta\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;s:7:\"default\";s:1:\"0\";}s:5:\"theme\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:64;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:6:\"status\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;s:4:\"size\";s:4:\"tiny\";}s:6:\"weight\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:6:\"region\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:64;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:6:\"custom\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;s:4:\"size\";s:4:\"tiny\";}s:10:\"visibility\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;s:4:\"size\";s:4:\"tiny\";}s:5:\"pages\";a:2:{s:4:\"type\";s:4:\"text\";s:8:\"not null\";b:1;}s:5:\"title\";a:5:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";s:12:\"translatable\";b:1;}s:5:\"cache\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:1;s:4:\"size\";s:4:\"tiny\";}s:9:\"css_class\";a:5:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";s:11:\"description\";s:44:\"String containing the classes for the block.\";}s:9:\"i18n_mode\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;s:11:\"description\";s:24:\"Block multilingual mode.\";}}s:11:\"primary key\";a:1:{i:0;s:3:\"bid\";}s:11:\"unique keys\";a:1:{s:3:\"tmd\";a:3:{i:0;s:5:\"theme\";i:1;s:6:\"module\";i:2;s:5:\"delta\";}}s:7:\"indexes\";a:1:{s:4:\"list\";a:5:{i:0;s:5:\"theme\";i:1;s:6:\"status\";i:2;s:6:\"region\";i:3;s:6:\"weight\";i:4;s:6:\"module\";}}s:6:\"module\";s:5:\"block\";s:4:\"name\";s:5:\"block\";}s:10:\"block_role\";a:5:{s:6:\"fields\";a:3:{s:6:\"module\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:64;s:8:\"not null\";b:1;}s:5:\"delta\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;}s:3:\"rid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}}s:11:\"primary key\";a:3:{i:0;s:6:\"module\";i:1;s:5:\"delta\";i:2;s:3:\"rid\";}s:7:\"indexes\";a:1:{s:3:\"rid\";a:1:{i:0;s:3:\"rid\";}}s:6:\"module\";s:5:\"block\";s:4:\"name\";s:10:\"block_role\";}s:12:\"block_custom\";a:5:{s:6:\"fields\";a:4:{s:3:\"bid\";a:3:{s:4:\"type\";s:6:\"serial\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:4:\"body\";a:4:{s:4:\"type\";s:4:\"text\";s:8:\"not null\";b:0;s:4:\"size\";s:3:\"big\";s:12:\"translatable\";b:1;}s:4:\"info\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:6:\"format\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:0;}}s:11:\"unique keys\";a:1:{s:4:\"info\";a:1:{i:0;s:4:\"info\";}}s:11:\"primary key\";a:1:{i:0;s:3:\"bid\";}s:6:\"module\";s:5:\"block\";s:4:\"name\";s:12:\"block_custom\";}s:11:\"cache_block\";a:5:{s:6:\"fields\";a:5:{s:3:\"cid\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:4:\"data\";a:3:{s:4:\"type\";s:4:\"blob\";s:8:\"not null\";b:0;s:4:\"size\";s:3:\"big\";}s:6:\"expire\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:7:\"created\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:10:\"serialized\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:5:\"small\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}}s:7:\"indexes\";a:1:{s:6:\"expire\";a:1:{i:0;s:6:\"expire\";}}s:11:\"primary key\";a:1:{i:0;s:3:\"cid\";}s:6:\"module\";s:5:\"block\";s:4:\"name\";s:11:\"cache_block\";}s:23:\"backup_migrate_profiles\";a:5:{s:6:\"export\";a:7:{s:3:\"key\";s:12:\"machine_name\";s:8:\"key name\";s:10:\"Profile ID\";s:11:\"admin_title\";s:4:\"name\";s:11:\"primary key\";s:10:\"profile_id\";s:10:\"identifier\";s:4:\"item\";s:12:\"default hook\";s:35:\"exportables_backup_migrate_profiles\";s:3:\"api\";a:4:{s:5:\"owner\";s:14:\"backup_migrate\";s:3:\"api\";s:26:\"backup_migrate_exportables\";s:15:\"minimum_version\";i:1;s:15:\"current_version\";i:1;}}s:6:\"fields\";a:7:{s:10:\"profile_id\";a:4:{s:4:\"type\";s:6:\"serial\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:9:\"no export\";b:1;}s:12:\"machine_name\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:1:\"0\";}s:4:\"name\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;}s:8:\"filename\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;}s:16:\"append_timestamp\";a:5:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:16:\"timestamp_format\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:14;s:8:\"not null\";b:1;}s:7:\"filters\";a:4:{s:4:\"type\";s:4:\"text\";s:8:\"not null\";b:1;s:9:\"serialize\";b:1;s:18:\"serialized default\";s:6:\"a:0:{}\";}}s:11:\"primary key\";a:1:{i:0;s:10:\"profile_id\";}s:6:\"module\";s:14:\"backup_migrate\";s:4:\"name\";s:23:\"backup_migrate_profiles\";}s:27:\"backup_migrate_destinations\";a:5:{s:6:\"export\";a:7:{s:3:\"key\";s:12:\"machine_name\";s:8:\"key name\";s:14:\"Destination ID\";s:11:\"admin_title\";s:4:\"name\";s:11:\"primary key\";s:14:\"destination_id\";s:10:\"identifier\";s:4:\"item\";s:12:\"default hook\";s:39:\"exportables_backup_migrate_destinations\";s:3:\"api\";a:4:{s:5:\"owner\";s:14:\"backup_migrate\";s:3:\"api\";s:26:\"backup_migrate_exportables\";s:15:\"minimum_version\";i:1;s:15:\"current_version\";i:1;}}s:6:\"fields\";a:6:{s:14:\"destination_id\";a:4:{s:4:\"type\";s:6:\"serial\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:9:\"no export\";b:1;}s:12:\"machine_name\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:1:\"0\";}s:4:\"name\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;}s:7:\"subtype\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;}s:8:\"location\";a:2:{s:4:\"type\";s:4:\"text\";s:8:\"not null\";b:1;}s:8:\"settings\";a:4:{s:4:\"type\";s:4:\"text\";s:8:\"not null\";b:1;s:9:\"serialize\";b:1;s:18:\"serialized default\";s:6:\"a:0:{}\";}}s:11:\"primary key\";a:1:{i:0;s:14:\"destination_id\";}s:6:\"module\";s:14:\"backup_migrate\";s:4:\"name\";s:27:\"backup_migrate_destinations\";}s:22:\"backup_migrate_sources\";a:5:{s:6:\"export\";a:7:{s:3:\"key\";s:12:\"machine_name\";s:8:\"key name\";s:9:\"Source ID\";s:11:\"admin_title\";s:4:\"name\";s:11:\"primary key\";s:9:\"source_id\";s:10:\"identifier\";s:4:\"item\";s:12:\"default hook\";s:34:\"exportables_backup_migrate_sources\";s:3:\"api\";a:4:{s:5:\"owner\";s:14:\"backup_migrate\";s:3:\"api\";s:26:\"backup_migrate_exportables\";s:15:\"minimum_version\";i:1;s:15:\"current_version\";i:1;}}s:6:\"fields\";a:6:{s:9:\"source_id\";a:4:{s:4:\"type\";s:6:\"serial\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:9:\"no export\";b:1;}s:12:\"machine_name\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;s:7:\"default\";s:1:\"0\";}s:4:\"name\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;}s:7:\"subtype\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;}s:8:\"location\";a:2:{s:4:\"type\";s:4:\"text\";s:8:\"not null\";b:1;}s:8:\"settings\";a:4:{s:4:\"type\";s:4:\"text\";s:8:\"not null\";b:1;s:9:\"serialize\";b:1;s:18:\"serialized default\";s:6:\"a:0:{}\";}}s:11:\"primary key\";a:1:{i:0;s:9:\"source_id\";}s:6:\"module\";s:14:\"backup_migrate\";s:4:\"name\";s:22:\"backup_migrate_sources\";}s:24:\"backup_migrate_schedules\";a:5:{s:6:\"export\";a:7:{s:3:\"key\";s:12:\"machine_name\";s:8:\"key name\";s:9:\"Source ID\";s:11:\"admin_title\";s:4:\"name\";s:11:\"primary key\";s:11:\"schedule_id\";s:10:\"identifier\";s:4:\"item\";s:12:\"default hook\";s:36:\"exportables_backup_migrate_schedules\";s:3:\"api\";a:4:{s:5:\"owner\";s:14:\"backup_migrate\";s:3:\"api\";s:26:\"backup_migrate_exportables\";s:15:\"minimum_version\";i:1;s:15:\"current_version\";i:1;}}s:6:\"fields\";a:12:{s:11:\"schedule_id\";a:4:{s:4:\"type\";s:6:\"serial\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:9:\"no export\";b:1;}s:12:\"machine_name\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:1:\"0\";}s:4:\"name\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;}s:9:\"source_id\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:7:\"default\";s:2:\"db\";s:8:\"not null\";b:1;}s:14:\"destination_id\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:1:\"0\";}s:19:\"copy_destination_id\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;s:7:\"default\";s:1:\"0\";}s:10:\"profile_id\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:1:\"0\";}s:4:\"keep\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:6:\"period\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:7:\"enabled\";a:5:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:4:\"cron\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;s:7:\"default\";s:7:\"builtin\";}s:13:\"cron_schedule\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:9:\"0 4 * * *\";}}s:11:\"primary key\";a:1:{i:0;s:11:\"schedule_id\";}s:6:\"module\";s:14:\"backup_migrate\";s:4:\"name\";s:24:\"backup_migrate_schedules\";}s:7:\"comment\";a:6:{s:6:\"fields\";a:15:{s:3:\"cid\";a:2:{s:4:\"type\";s:6:\"serial\";s:8:\"not null\";b:1;}s:3:\"pid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"nid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"uid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:7:\"subject\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:64;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:8:\"hostname\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:7:\"created\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:7:\"changed\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:6:\"status\";a:5:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;s:4:\"size\";s:4:\"tiny\";}s:6:\"thread\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;}s:4:\"name\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:60;s:8:\"not null\";b:0;}s:4:\"mail\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:64;s:8:\"not null\";b:0;}s:8:\"homepage\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:0;}s:8:\"language\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:12;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:4:\"uuid\";a:5:{s:4:\"type\";s:4:\"char\";s:6:\"length\";i:36;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";s:11:\"description\";s:34:\"The Universally Unique Identifier.\";}}s:7:\"indexes\";a:5:{s:18:\"comment_status_pid\";a:2:{i:0;s:3:\"pid\";i:1;s:6:\"status\";}s:15:\"comment_num_new\";a:5:{i:0;s:3:\"nid\";i:1;s:6:\"status\";i:2;s:7:\"created\";i:3;s:3:\"cid\";i:4;s:6:\"thread\";}s:11:\"comment_uid\";a:1:{i:0;s:3:\"uid\";}s:20:\"comment_nid_language\";a:2:{i:0;s:3:\"nid\";i:1;s:8:\"language\";}s:15:\"comment_created\";a:1:{i:0;s:7:\"created\";}}s:11:\"primary key\";a:1:{i:0;s:3:\"cid\";}s:12:\"foreign keys\";a:2:{s:12:\"comment_node\";a:2:{s:5:\"table\";s:4:\"node\";s:7:\"columns\";a:1:{s:3:\"nid\";s:3:\"nid\";}}s:14:\"comment_author\";a:2:{s:5:\"table\";s:5:\"users\";s:7:\"columns\";a:1:{s:3:\"uid\";s:3:\"uid\";}}}s:6:\"module\";s:7:\"comment\";s:4:\"name\";s:7:\"comment\";}s:23:\"node_comment_statistics\";a:6:{s:6:\"fields\";a:6:{s:3:\"nid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"cid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:22:\"last_comment_timestamp\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:17:\"last_comment_name\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:60;s:8:\"not null\";b:0;}s:16:\"last_comment_uid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:13:\"comment_count\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}}s:11:\"primary key\";a:1:{i:0;s:3:\"nid\";}s:7:\"indexes\";a:3:{s:22:\"node_comment_timestamp\";a:1:{i:0;s:22:\"last_comment_timestamp\";}s:13:\"comment_count\";a:1:{i:0;s:13:\"comment_count\";}s:16:\"last_comment_uid\";a:1:{i:0;s:16:\"last_comment_uid\";}}s:12:\"foreign keys\";a:2:{s:15:\"statistics_node\";a:2:{s:5:\"table\";s:4:\"node\";s:7:\"columns\";a:1:{s:3:\"nid\";s:3:\"nid\";}}s:19:\"last_comment_author\";a:2:{s:5:\"table\";s:5:\"users\";s:7:\"columns\";a:1:{s:16:\"last_comment_uid\";s:3:\"uid\";}}}s:6:\"module\";s:7:\"comment\";s:4:\"name\";s:23:\"node_comment_statistics\";}s:19:\"ctools_object_cache\";a:5:{s:6:\"fields\";a:5:{s:3:\"sid\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";s:2:\"64\";s:8:\"not null\";b:1;}s:4:\"name\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;}s:3:\"obj\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;}s:7:\"updated\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:4:\"data\";a:3:{s:4:\"type\";s:4:\"blob\";s:4:\"size\";s:3:\"big\";s:9:\"serialize\";b:1;}}s:11:\"primary key\";a:3:{i:0;s:3:\"sid\";i:1;s:3:\"obj\";i:2;s:4:\"name\";}s:7:\"indexes\";a:1:{s:7:\"updated\";a:1:{i:0;s:7:\"updated\";}}s:6:\"module\";s:6:\"ctools\";s:4:\"name\";s:19:\"ctools_object_cache\";}s:16:\"ctools_css_cache\";a:4:{s:6:\"fields\";a:4:{s:3:\"cid\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";s:3:\"128\";s:8:\"not null\";b:1;}s:8:\"filename\";a:2:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";s:3:\"255\";}s:3:\"css\";a:3:{s:4:\"type\";s:4:\"text\";s:4:\"size\";s:3:\"big\";s:9:\"serialize\";b:1;}s:6:\"filter\";a:2:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";}}s:11:\"primary key\";a:1:{i:0;s:3:\"cid\";}s:6:\"module\";s:6:\"ctools\";s:4:\"name\";s:16:\"ctools_css_cache\";}s:8:\"watchdog\";a:5:{s:6:\"fields\";a:11:{s:3:\"wid\";a:2:{s:4:\"type\";s:6:\"serial\";s:8:\"not null\";b:1;}s:3:\"uid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:4:\"type\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:64;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:7:\"message\";a:3:{s:4:\"type\";s:4:\"text\";s:8:\"not null\";b:1;s:4:\"size\";s:3:\"big\";}s:9:\"variables\";a:3:{s:4:\"type\";s:4:\"blob\";s:8:\"not null\";b:1;s:4:\"size\";s:3:\"big\";}s:8:\"severity\";a:5:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;s:4:\"size\";s:4:\"tiny\";}s:4:\"link\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:8:\"location\";a:2:{s:4:\"type\";s:4:\"text\";s:8:\"not null\";b:1;}s:7:\"referer\";a:2:{s:4:\"type\";s:4:\"text\";s:8:\"not null\";b:0;}s:8:\"hostname\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:9:\"timestamp\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}}s:11:\"primary key\";a:1:{i:0;s:3:\"wid\";}s:7:\"indexes\";a:3:{s:4:\"type\";a:1:{i:0;s:4:\"type\";}s:3:\"uid\";a:1:{i:0;s:3:\"uid\";}s:8:\"severity\";a:1:{i:0;s:8:\"severity\";}}s:6:\"module\";s:5:\"dblog\";s:4:\"name\";s:8:\"watchdog\";}s:14:\"feeds_importer\";a:5:{s:6:\"export\";a:4:{s:3:\"key\";s:2:\"id\";s:10:\"identifier\";s:14:\"feeds_importer\";s:12:\"default hook\";s:22:\"feeds_importer_default\";s:3:\"api\";a:4:{s:5:\"owner\";s:5:\"feeds\";s:3:\"api\";s:22:\"feeds_importer_default\";s:15:\"minimum_version\";i:1;s:15:\"current_version\";i:1;}}s:6:\"fields\";a:2:{s:2:\"id\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:6:\"config\";a:4:{s:4:\"type\";s:4:\"blob\";s:4:\"size\";s:3:\"big\";s:8:\"not null\";b:0;s:9